# Contributing to ProgramEngineerGPT

First off, thank you for considering contributing to ProgramEngineerGPT. It's people like you that make ProgramEngineerGPT such a great tool.

## Getting Started

* Make sure you have a [GitHub account](https://github.com/signup/free).
* Submit a ticket for your issue, assuming one does not already exist.
  * Clearly describe the issue including steps to reproduce when it is a bug.
* Fork the repository on GitHub.

## Making Changes

* Create a topic branch from where you want to base your work.
  * This is usually the `main` branch.
  * To quickly create a topic branch based on `main`; `git branch fix/main/my_contribution main` then checkout the new branch with `git checkout fix/main/my_contribution`. Please avoid working directly on the `main` branch.
* Make commits of logical units.
* Check for unnecessary whitespace with `git diff --check` before committing.
* Make sure your commit messages are in the proper format.

## Submitting Changes

* Push your changes to a topic branch in your fork of the repository.
* Submit a pull request to the repository in the organization.
* After feedback has been given we expect responses within two weeks. After two weeks we may close the pull request if it isn't showing any activity.

## Code Styling

Please follow the coding conventions defined in the project. If no guidelines are present in the project, follow standard conventions for the language the project is written in.

## Additional Resources

* [General GitHub documentation](http://help.github.com/)
* [GitHub pull request documentation](https://help.github.com/send-pull-requests/)

## Reporting a Bug

Use the GitHub issue tracker to report bugs.

## Suggesting a Feature

Use the GitHub issue tracker to suggest new features.

## Code of Conduct

Please note that this project is released with a [Contributor Code of Conduct](https://www.contributor-covenant.org/version/1/4/code-of-conduct/). By participating in this project you agree to abide by its terms.

Thank you again for your contribution!
