# `TRY401` - Do not log the exception object

## Why is it bad

It's verbose, by using `logging.exception` you're already getting the exception message. Use the message to give context instead.

## How it looks like

```py
def main_function():
    try:
        process()
        handle()
        finish()
    except Exception as ex:
        logger.exception(f"Found an error: {ex}")  # 'ex' message is going to be displayed twice
```

## How it should be

```py
def main_function():
    try:
        process()
        handle()
        finish()
    except Exception:  # <- No need to get object
        logger.exception("Something failed during main_function")  # <- Message will be shown alongside stack trace
```
