# `TRY400` - Use logging '.exception' instead of 'error'

## Why is it bad

[Python docs](https://docs.python.org/3/library/logging.html#logging.Logger.exception) point out that you should use `exception` method inside an exception handler. It automatically add the stack trace and logs the message as `ERROR` level.

## How it looks like

```py
def main_function():
    try:
        process()
        handle()
        finish()
    except Exception as ex:
        logger.error("Context message here")
```

## How it should be

```py
def main_function():
    try:
        process()
        handle()
        finish()
    except Exception:
        logger.exception("Context message here")
```
