# `TRY301` - `raise` within `try`

## Why is it bad

Raising and catching exceptions in the same block may lead to confusion,
try to abstract the raise to an inner function.

## How it looks like

```py
try:
    a = process()
    if not a:
        raise CustomException(a)
except Exception:
    logger.exception("something failed")
```

## How it should be

```py
try:
    a = process()  # This throws the exception now
except  CustomException:
    logger.exception("a failed")
except Exception:
    logger.exception("something failed")
```
