# `TRY300` - Consider `else` block

## Why is it bad

The `else` block within a `try` block outlines the successful behavior.
We can make successful `return` statements obvious by using it.

## How it looks like

```py
try:
    a = process()
    b = something_that_may_go_wrong(a)
    logger.info("b worked!")
    return b

except Exception:
    logger.exception("b failed")
    return False
```

## How it should be

```py
try:
    a = process()
    b = something_that_may_go_wrong(a)

except Exception:
    logger.exception("b failed")
    return False

else:
    logger.info("b worked!")
    return b
```

## When this is fine

You can ignore this recommendation when you have `try`/`finally` blocks, with none `except`.

```py
try:
    do_work()
    return True  # This is fine

finally:
    logger.info("done")
```
