# `TRY203` - Useless `except` block

## Why is it bad

Capturing an exception just to raise it again has no effect in runtime, and is considered a bad practice.

## How it looks like

```py
try:
    a = process()
except Exception:
    raise
else:
    return a
```

or:

```py
try:
    process()
except Exception:
    raise
finally:
    flush_process()
```

or simply:


```py
try:
    process()
except Exception:
    raise
```

## How it should be

You should either remove the whole try-except block,

```py
a = process() # This will raise the exception anyway
return a
```

or just remove the `except` block:

```py
try:
    a = process() # This will raise the exception anyway
finally:
    flush_process()
```
