# `TRY200` - Use 'raise from' to specify cause

## Why is it bad

Not specifying `from` when raising an exception from another gives you no clue
whether the exception (given the circumstances) was intentional or whether it's a bug introduced by the programmer.

## How it looks like

```py
def main_function():
    try:
        process()
        handle()
        finish()
    except Exception:
        raise MainFunctionFailed()
```

## How it should be

```py
def main_function():
    try:
        process()
        handle()
        finish()
    except Exception as ex:
        raise MainFunctionFailed() from ex
```
