# `TRY101` - Too many try blocks in your function

## Why is it bad

It makes code hard to read since you're constantly interrupted with "what if something goes wrong" in middle of the flow.
Make and capture specific exceptions in a single and unique flow.

## How it looks like

```py
def main_function():
    try:
        receipt_note = receipt_service.create(order_id)
    except Exception:
        logger.exception("log")
        raise

    try:
        broker.emit_receipt_note(receipt_note)
    except Exception:
        logger.exception("another log")
        raise
```

## How it should be

```py
def main_function():
    try:
        receipt_note = receipt_service.create(order_id)
        broker.emit_receipt_note(receipt_note)
    except ReceiptNoteCreationFailed:
        logger.exception("log")
        raise
    except NoteEmissionFailed:
        logger.exception("another log")
        raise
```
