# `TRY100` - Don't check to continue, raise an exception instead

## Why is it bad

Continuously checking whether you should continue or stop the function is hard to
read and to follow up.
Instead, you should interrupt the process with an exception.
This issue is tolerable to at least one if.

## How it looks like

```py
def main_function():
    process()
    result = retrieve_result()

    if not result:
        return "Can't proceed"

    details = result.maybe_get_details()
    if len(details) == 0:
        return "Impossible to finish without details"

    more_work()
    work_completed = finish_work()
    if not work_completed:
        return "Work failed"

    send_details_with_result(result, details)
```

## How it should be

```py
def main_function():
    process()
    result = retrieve_result()  # Internally raises exception
    details = result.get_details()  # If no details raises exception
    more_work()
    finish_work()  # Internally raises exception
    send_details_with_result(result, details)
```
