# `TRY006` - Inheriting from non defined base exception

## Why is it bad

It's a good idea to define a base exception for your project, you can define specific base types that should be used instead of the regular `Exception`.

## How to enable it

You need to define which base exceptions are intended to be used through `allowed_base_exceptions`.

```toml
[tool.tryceratops]
allowed_base_exceptions = ["MyAppException", "CriticalAppException"]
```

## How it looks like

```py
class MyAppException(Exception):
    ...

class SpecificException(Exception):
    ...
```

## How it should be

```py
class MyAppException(Exception):
    ...

class SpecificException(MyAppException):  # 👈 Assuming `MyAppException` is defined as allowed
    ...
```
