# `TRY004` - Prefer `TypeError` exception for invalid type

## Why is it bad

Using semantically incorrect exceptions results in confusing diagnostic information for the user.

The Python docs make the definition clear:

> Raised when an operation or function is applied to an object of inappropriate type. [...]
This exception may be raised by user code to indicate that an attempted operation on an object is not supported [...]
Passing arguments of the wrong type (e.g. passing a list when an int is expected) should result in a TypeError, but passing arguments with the wrong value (e.g. a number outside expected boundaries) should result in a ValueError.

[Source](https://docs.python.org/3/library/exceptions.html#TypeError)

## How it looks like

```py
if isinstance(my_var, int):
    pass
else:
    raise ValueError(f'{my_var} must be an int')
```

## How it should be

```py
if isinstance(my_var, int):
    pass
else:
    raise TypeError(f'{my_var} must be an int')
```
