# Violations

## `TRY0xx` - Exception Classes

| Code                                                                | Description                                                |
| ------------------------------------------------------------------- | ---------------------------------------------------------- |
| [TRY002](TRY002.md)                                                 | Create your own exception                                  |
| [TRY003](TRY003.md)                                                 | Avoid specifying long messages outside the exception class |
| [TRY004](TRY004.md)                                                 | Prefer `TypeError` exception for invalid type              |
| [TRY005](TRY005.md) (**ENABLED through `check_pickable`**)          | Define `__reduce__` to make exception pickable             |
| [TRY006](TRY006.md) (**ENABLED through `allowed_base_exceptions`**) | Inheriting from non defined base exception                 |

## `TRY1xx` - General

| Code                                   | Description           |
| -------------------------------------- | --------------------- |
| [TRY100](TRY100.md) (**EXPERIMENTAL**) | Check to continue     |
| [TRY101](TRY101.md)                    | Too many `try` blocks |

## `TRY2xx` - Except blocks

| Code                | Description                                         |
| ------------------- | --------------------------------------------------- |
| [TRY200](TRY200.md) | Use `raise Exception from`                          |
| [TRY201](TRY201.md) | Simply use `raise`                                  |
| [TRY202](TRY202.md) | Don't ignore a broad exception without even logging |
| [TRY203](TRY203.md) | Useless try-except                                  |

## `TRY3xx` - Try blocks

| Code                | Description                       |
| ------------------- | --------------------------------- |
| [TRY300](TRY300.md) | Consider adding an `else` block   |
| [TRY301](TRY301.md) | Avoid direct raises in `try` body |

## `TRY4xx` - Logging usage

| Code                | Description                                  |
| ------------------- | -------------------------------------------- |
| [TRY400](TRY400.md) | Use logging `.exception` instead of `.error` |
| [TRY401](TRY401.md) | Do not log the exception object              |
