<?php

/**
 * @name $DBDataTypeSQL
 */
namespace DB\DataType\SQL;

class TypeVarbinary extends FieldTypeConcrete
{
	const DTHASH = 'da4597de003f66f5e0542ba8715931ad';

	/**
	 * TypeVarbinary constructor.
	 * @param array $aData
	 */
	public function __construct(array $aData = array())
	{
		parent::__construct($aData);


		foreach ($aData as $sKey => $mValue)
		{
			$sMethod = 'set_' . $sKey;

			if (method_exists($this, $sMethod))
			{
				$this->$sMethod($mValue);
			}
		}
	}

    /**
     * @param array $aData
     * @return TypeVarbinary
     */
    public static function create(array $aData = array())
    {
        $oObject = new self($aData);

        return $oObject;
    }

	/**
	 * @return false|string JSON
	 */
	public function __toString()
	{
        return $this->getPropertyJson();
	}

	/**
	 * @return false|string
	 */
	public function getPropertyJson()
	{
        return json_encode($this->getPropertyArray());
	}

	/**
	 * @return array
	 */
	public function getPropertyArray()
	{
        return get_object_vars($this);
	}

	/**
	 * @return array
	 * @throws \ReflectionException
	 */
	public function getConstantArray()
	{
		$oReflectionClass = new \ReflectionClass($this);
		$aConstant = $oReflectionClass->getConstants();

		return $aConstant;
	}

	/**
	 * @return $this
	 */
	public function flushProperties()
	{
		foreach ($this->getPropertyArray() as $sKey => $aValue)
		{
			$sMethod = 'set_' . $sKey;

			if (method_exists($this, $sMethod)) 
			{
				$this->$sMethod('');
			}
		}

		return $this;
	}

	/**
	 * @return string JSON
	 */
	public function getDataTypeConfigJSON()
	{
		return '{"name":"TypeVarbinary","file":"TypeVarbinary.php","extends":"FieldTypeConcrete","namespace":"DB\\\\DataType\\\\SQL","constant":[],"property":[],"createHelperMethods":true}';
	}

}
