# Awesome Singing Voice Synthesis and Singing Voice Conversion
A paper and project list about the cutting edge **Speech Synthesis**, **Text-to-Speech (TTS)**, **Singing Voice Synthesis (SVS)**, **Voice Conversion (VC)**, **Singing Voice Conversion (SVC)**, and related interesting works (such as **Music Synthesis**, **Automatic Music Transcription**, **Automatic MOS Prediction**, **SSL-based ASR**, ...etc).  

Welcome to PR or contact me via email ([guanyuan@gapp.nthu.edu.tw](guanyuan@gapp.nthu.edu.tw)) for updating papers and works.  


* * *
# Paper List
## Journals
IEEE/ACM TASLP, IEEE JSTSP, JSLHR, IEEE TPAMI  


## Conferences
NeuraIPS, ICLR, ICML, IJAI, AAAI, ACL, NAACL, EMNLP, ISMIR, ACM MM, ICASSP, INTERSPEECH, ICME  


## Workshops
ASRU, SLT  


## Singing Voice Conversion (Other Key Words: SVC, Singing Style Transfer)
[**2022**]
- [Learn2Sing 2.0: Diffusion and Mutual Information-Based Target Speaker SVS by Learning from Singing Teacher](https://arxiv.org/abs/2203.16408) | **INTERSPEECH 2022**  | 
[✔️Code](https://github.com/WelkinYang/Learn2Sing2.0) | 
[🎧Demo](https://welkinyang.github.io/Learn2Sing2.0/)

- [A Hierarchical Speaker Representation Framework for One-shot Singing Voice Conversion](https://arxiv.org/abs/2206.13762) | **INTERSPEECH 2022** | 
[🎧Demo](https://lixucuhk.github.io/Unet-SVC-Demo/)

- [Improving Adversarial Waveform Generation based Singing Voice Conversion with Harmonic Signals](https://arxiv.org/abs/2201.10130) | **ICASSP 2022** | 
[🎧Demo](https://hhguo.github.io/DemoHarSVC/)

[**2021**]
- [DiffSVC: A Diffusion Probabilistic Model for Singing Voice Conversion](https://arxiv.org/abs/2105.13871) | **ASRU 2021** | 
[🎧Demo](https://liusongxiang.github.io/diffsvc/)

- [Controllable and Interpretable Singing Voice Decomposition via Assem-VC](https://arxiv.org/abs/2110.12676) | **NeurIPS 2021 Workshop** | 
[🎧Demo](https://mindslab-ai.github.io/assem-vc/singer/)

- [Towards High-fidelity Singing Voice Conversion with Acoustic Reference and Contrastive Predictive Coding](https://arxiv.org/abs/2110.04754) | 2021/10 | 
[🎧Demo](https://georgehappy1.github.io/svcdemo/)

- [FastSVC: Fast Cross-Domain Singing Voice Conversion with Feature-wise Linear Modulation](https://arxiv.org/abs/2011.05731) | **ICME 2021** | 
[🎧Demo](https://nobody996.github.io/FastSVC/)

- [Unsupervised WaveNet-based Singing Voice Conversion Using Pitch Augmentation and Two-phase Approach](https://www.airitilibrary.com/Publication/alDetailedMesh1?DocID=U0001-1107202111044100) | 2021/07 | 
[✔️Code](https://github.com/SongRongLee/mir-svc) | 
[🎧Demo](https://songronglee.github.io/singing-voice-conversion/)

[**2020**]
- [Zero-shot Singing Voice Conversion](https://program.ismir2020.net/poster_1-08.html) | **ISMIR 2020** | 
[🎧Demo](https://sites.google.com/izotope.com/ismir2020-audio-demo)

- [Phonetic Posteriorgrams based Many-to-Many Singing Voice Conversion via Adversarial Training](https://arxiv.org/abs/2012.01837) | 2020/12 | 
[🎧Demo](https://hhguo.github.io/DemoEASVC/) | [Unofficial Code](https://github.com/hhguo/EA-SVC)

- [DurIAN-SC: Duration Informed Attention Network based Singing Voice Conversion System](https://arxiv.org/abs/2008.03009) | **INTERSPEECH 2020** | 
[🎧Demo](https://tencent-ailab.github.io/learning_singing_from_speech/)

- [Unsupervised Cross-Domain Singing Voice Conversion](https://arxiv.org/abs/2008.02830) | **INTERSPEECH 2020** | 
[🎧Demo](https://singing-conversion.github.io/)

- [PitchNet: Unsupervised Singing Voice Conversion with Pitch Adversarial Network](https://arxiv.org/abs/1912.01852) | **ICASSP 2020** | 
[🎧Demo](https://tencent-ailab.github.io/pitch-net/)

- [VAW-GAN for Singing Voice Conversion with Non-parallel Training Data](https://arxiv.org/abs/2008.03992) | **APSIPA 2020** | 
[✔️Code](https://github.com/johndpope/Singing-Voice-Conversion-with-conditional-VAW-GAN) | 
[🎧Demo](https://kunzhou9646.github.io/singvaw-gan/)

### Dateset
- [M4Singer: a Multi-Style, Multi-Singer and Musical Score Provided Mandarin Singing Corpus](https://openreview.net/forum?id=qiDmAaG6mP) | **NeurIPS 2022** | 
[🔽Apply&Download](https://github.com/M4Singer/M4Singer) | 
[🎧Demo](https://m4singer.github.io/)

- [NUS-48E Sung and Spoken Lyrics Corpus](https://smcnus.comp.nus.edu.sg/archive/pdf/2012-2013/2013_05-Pub-NUS-48E.pdf) | 
[🔽Apply&Download](https://drive.google.com/drive/folders/12pP9uUl0HTVANU3IPLnumTJiRjPtVUMx)

- [NHSS: A Speech and Singing Parallel Database](https://arxiv.org/abs/2012.00337) | 
[🔽Apply&Download](https://hltnus.github.io/NHSSDatabase/index.html)


## Singing Technique Conversion/Singing Technique Classification
[**2022**]
- [Deformable CNN and Imbalance-Aware Feature Learning for Singing Technique Classification](https://arxiv.org/abs/2206.12230) | **INTERSPEECH 2022**

[**2021**]
- [Investigating Time-Frequency Representations for Audio Feature Extraction in Singing Technique Classification](https://www.slis.tsukuba.ac.jp/lspc/0000890.pdf) | **APSIPA 2021**

- [Zero-shot Singing Technique Conversion](https://arxiv.org/abs/2111.08839) | **CMMR 2021**

### Dateset
- [VocalSet: A Singing Voice Dataset](http://ismir2018.ircam.fr/doc/pdfs/114_Paper.pdf) | **ISMIR 2018** | 
[🔽Apply&Download](https://zenodo.org/record/1203819#.YxX43nZBx3g)


## Voice Conversion (Other Key Words: VC, Voice Cloning, Voice Style Transfer)
[**2022**]
- [Learning Noise-independent Speech Representation for High-quality Voice Conversion for Noisy Target Speakers](https://arxiv.org/abs/2207.00756) | **INTERSPEECH 2022** | 
[🎧Demo](https://lmxue.github.io/FlowVC/)

- [Glow-WaveGAN 2: High-quality Zero-shot Text-to-speech Synthesis and Any-to-any Voice Conversion](https://arxiv.org/abs/2207.01832) | **INTERSPEECH 2022** | 
[🎧Demo](https://leiyi420.github.io/glow-wavegan2/)

- [Diffusion-Based Voice Conversion with Fast Maximum Likelihood Sampling Scheme](https://arxiv.org/abs/2109.13821) | **ICLR 2022** | 
[✔️Code](https://github.com/huawei-noah/Speech-Backbones) | 
[🎧Demo](https://diffvc-fast-ml-solver.github.io/)

- [YourTTS: Towards Zero-Shot Multi-Speaker TTS and Zero-Shot Voice Conversion for everyone](https://arxiv.org/abs/2112.02418) | **ICML 2022** | 
[✔️Code](https://github.com/edresson/yourtts) | 
[🎧Demo](https://huggingface.co/spaces/ICML2022/YourTTS) | 
[🎧Demo](https://edresson.github.io/YourTTS/) | 
[📝Blog](https://coqui.ai/blog/tts/yourtts-zero-shot-text-synthesis-low-resource-languages)

- [A Comparative Study of Self-supervised Speech Representation Based Voice Conversion](https://arxiv.org/abs/2207.04356) | **IEEE JSTSP 2022/07**

- [S3PRL-VC: Open-Source Voice Conversion Framework with Self-Supervised Speech Representations](https://arxiv.org/abs/2110.06280) | **ICASSP 2022** | 
[✔️Code](https://github.com/s3prl/s3prl/tree/master/s3prl/downstream/a2o-vc-vcc2020)

- [A Comparison of Discrete and Soft Speech Units for Improved Voice Conversion](https://arxiv.org/abs/2111.02392) | **ICASSP 2022** | 
[✔️Code](https://github.com/bshall/soft-vc) | 
[🎧Demo](https://bshall.github.io/soft-vc/)

- [Assem-VC: Realistic Voice Conversion by Assembling Modern Speech Synthesis Techniques](https://arxiv.org/abs/2104.00931) | **ICASSP 2022** | 
[✔️Code](https://github.com/mindslab-ai/assem-vc) | 
[🎧Demo](https://mindslab-ai.github.io/assem-vc/)

- [NVC-Net: End-to-End Adversarial Voice Conversion](https://arxiv.org/abs/2106.00992) | **ICASSP 2022** | 
[✔️Code](https://github.com/sony/ai-research-code/tree/master/nvcnet) | 
[🎧Demo](https://nvcnet.github.io/)

- [Robust Disentangled Variational Speech Representation Learning for Zero-Shot Voice Conversion](https://arxiv.org/abs/2203.16705) | **ICASSP 2022** | 
[🎧Demo](https://jlian2.github.io/Robust-Voice-Style-Transfer/)

- [Training Robust Zero-Shot Voice Conversion Models with Self-supervised Features](https://arxiv.org/abs/2112.04424) | **ICASSP 2022** | 
[🎧Demo](https://trungd.github.io/ssl_vc/index.html)

- [Toward Degradation-Robust Voice Conversion](https://arxiv.org/abs/2110.07537) | **ICASSP 2022**

- [DGC-vector: A new speaker embedding for zero-shot voice conversion](https://arxiv.org/abs/2203.09722) | **ICASSP 2022** | 
[🎧Demo](https://shaw0fr.github.io/DGC-vector-DEMO/)

- [End-to-End Zero-Shot Voice Style Transfer with Location-Variable Convolutions](https://arxiv.org/abs/2205.09784) | 2022/05 | 
[🎧Demo](https://lvc-vc.github.io/lvc-vc-demo/)

[**2021**]
- [On Prosody Modeling for ASR+TTS based Voice Conversion](https://arxiv.org/abs/2107.09477) | **ASRU 2021** | 
[🎧Demo](https://unilight.github.io/Publication-Demos/publications/prosody-asr-tts-vc/index.html)

- [Neural Analysis and Synthesis: Reconstructing Speech from Self-Supervised Representations](https://arxiv.org/abs/2110.14513) | **NeurIPS 2021** | 
[🎧Demo](https://harsh-grenadilla-e40.notion.site/Demo-page-for-NANSY-37d4fd8ffb514765a2b234b04c8fc0f6) | 
[Unofficial Code](https://github.com/dhchoi99/NANSY)

- [MediumVC: Any-to-any voice conversion using synthetic specific-speaker speeches as intermedium features](https://arxiv.org/abs/2110.02500) | 2021/10 | 
[✔️Code](https://github.com/BrightGu/MediumVC) | 
[🎧Demo](https://brightgu.github.io/MediumVC/)

- [StarGANv2-VC: A Diverse, Unsupervised, Non-parallel Framework for Natural-Sounding Voice Conversion](https://arxiv.org/abs/2107.10394) | **INTERSPEECH 2021 Best Paper Award** | 
[✔️Code](https://github.com/yl4579/StarGANv2-VC) | 
[🎧Demo](https://starganv2-vc.github.io/)

- [S2VC: A Framework for Any-to-Any Voice Conversion with Self-Supervised Pretrained Representations](https://arxiv.org/abs/2104.02901) | **INTERSPEECH 2021** | 
[✔️Code](https://github.com/howard1337/S2VC) | 
[🎧Demo](https://howard1337.github.io/S2VC/)

- [Many-to-Many Voice Conversion based Feature Disentanglement using Variational Autoencoder](https://arxiv.org/abs/2107.06642) | **INTERSPEECH 2021** | 
[✔️Code](https://github.com/v-manhlt3/Disentangle-VAE-for-VC) | 
[🎧Demo](https://v-manhlt3.github.io/disentangled-VAE/)

- [Speech Resynthesis from Discrete Disentangled Self-Supervised Representations](https://arxiv.org/abs/2104.00355) | **INTERSPEECH 2021** | 
[🎧Demo](https://speechbot.github.io/resynthesis/index.html)

- [Improving Zero-shot Voice Style Transfer via Disentangled Representation Learning](https://arxiv.org/abs/2103.09420) | **ICLR 2021**

- [Global Rhythm Style Transfer Without Text Transcriptions](https://arxiv.org/abs/2106.08519) | **ICML 2021** | 
[✔️Code](https://github.com/auspicious3000/AutoPST)

- [AGAIN-VC: A One-shot Voice Conversion using Activation Guidance and Adaptive Instance Normalization](https://arxiv.org/abs/2011.00316) | **ICASSP 2021** | 
[✔️Code](https://github.com/KimythAnly/AGAIN-VC) | 
[🎧Demo](https://kimythanly.github.io/AGAIN-VC-demo/index)

- [Any-to-Many Voice Conversion with Location-Relative Sequence-to-Sequence Modeling](https://arxiv.org/abs/2009.02725v3) | **IEEE/ACM TASLP 2021/05** | 
[✔️Code](https://github.com/liusongxiang/ppg-vc) | 
[🎧Demo](https://liusongxiang.github.io/BNE-Seq2SeqMoL-VC/)

[**2020**]
- [An Overview of Voice Conversion and its Challenges: From Statistical Modeling to Deep Learning](https://arxiv.org/abs/2008.03648) | **IEEE/ACM TASLP 2020/11**

- [Unsupervised Speech Decomposition via Triple Information Bottleneck](https://arxiv.org/abs/2004.11284) | **ICML 2020** | 
[✔️Code](https://github.com/auspicious3000/SpeechSplit)

[**2019**]
- [One-shot Voice Conversion by Separating Speaker and Content Representations with Instance Normalization](https://arxiv.org/abs/1904.05742) | **INTERSPEECH 2019** | 
[✔️Code](https://github.com/cyhuang-tw/AdaIN-VC)

- [AUTOVC: Zero-Shot Voice Style Transfer with Only Autoencoder Loss](https://arxiv.org/abs/1905.05879) | **ICML 2019** | 
[✔️Code](https://github.com/auspicious3000/autovc) | 
[🎧Demo](https://auspicious3000.github.io/autovc-demo/)

### Dateset
- [CSTR VCTK Corpus: English Multi-speaker Corpus for CSTR Voice Cloning Toolkit](https://datashare.ed.ac.uk/handle/10283/3443) | **2019** | 
[🔽Apply&Download](https://datashare.ed.ac.uk/handle/10283/3443)

- [AISHELL-3: A Multi-speaker Mandarin TTS Corpus and the Baselines](https://arxiv.org/abs/2010.11567) | **2020** | 
[🔽Apply&Download](http://www.openslr.org/93/) | 
[🎧Demo](https://sos1sos2sixteen.github.io/aishell3/)

- [AISHELL-2: Transforming Mandarin ASR Research Into Industrial Scale](https://arxiv.org/abs/1808.10583) | **2018** | 
[🔽Apply&Download](https://github.com/kaldi-asr/kaldi/tree/master/egs/aishell2)

- [AIShell-1: An Open-Source Mandarin Speech Corpus and A Speech Recognition Baseline](https://arxiv.org/abs/1709.05522) | **2017** | 
[🔽Apply&Download](http://www.openslr.org/33/) 


## Emotional Voice Conversion
[**2022**]
- [Disentanglement of Emotional Style and Speaker Identity for Expressive Voice Conversion](https://arxiv.org/abs/2110.10326) | **INTERSPEECH 2022** | 
[🎧Demo](https://zy-du.github.io/IS22/)

- [Cross-speaker Emotion Transfer Based On Prosody Compensation for End-to-End Speech Synthesis](https://arxiv.org/abs/2207.01198) | **INTERSPEECH 2022** | 
[🎧Demo](https://silyfox.github.io/cspc/)

- [Emotion Intensity and its Control for Emotional Voice Conversion](https://arxiv.org/abs/2201.03967) | **IEEE Transactions on Affective Computing 2022/07** | 
[✔️Code](https://github.com/KunZhou9646/Emovox) | 
[🎧Demo](https://kunzhou9646.github.io/Emovox_demo/)

- [Textless Speech Emotion Conversion using Discrete and Decomposed Representations](https://arxiv.org/abs/2111.07402) | 202202 | 
[🎧Demo](https://speechbot.github.io/emotion/)

[**2021**]
- [Limited Data Emotional Voice Conversion Leveraging Text-to-Speech: Two-stage Sequence-to-Sequence Training](https://arxiv.org/abs/2103.16809) | **INTERSPEECH 2021** | 
[✔️Code](https://github.com/KunZhou9646/seq2seq-EVC) | 
[🎧Demo](https://kunzhou9646.github.io/IS21/)

[**2020**]
- [Converting Anyone's Emotion: Towards Speaker-Independent Emotional Voice Conversion](https://arxiv.org/abs/2005.07025) | **INTERSPEECH 2020** | 
[✔️Code](https://github.com/KunZhou9646/Speaker-independent-emotional-voice-conversion-based-on-conditional-VAW-GAN-and-CWT) | 
[🎧Demo](https://kunzhou9646.github.io/speaker-independent-emotional-vc/)

- [Transforming Spectrum and Prosody for Emotional Voice Conversion with Non-Parallel Training Data](https://arxiv.org/abs/2002.00198) | **Odyssey 2020** | 
[✔️Code](https://github.com/KunZhou9646/emotional-voice-conversion-with-CycleGAN-and-CWT-for-Spectrum-and-F0) | 
[🎧Demo](https://kunzhou9646.github.io/Odyssey2020_emotional_VC//)

### Dateset
- [Seen and Unseen emotional style transfer for voice conversion with a new emotional speech dataset](https://arxiv.org/abs/2010.14794) | **ICASSP 2021** | 
[🔽Apply&Download]([https://github.com/M4Singer/M4Singer](https://hltsingapore.github.io/ESD/index.html)) | 
[🎧Demo](https://hltsingapore.github.io/ESD/demo.html)


## Singing Voice Synthesis (Other Key Words: SVS)
[**2022**]
- [Muskits: an End-to-End Music Processing Toolkit for Singing Voice Synthesis](https://arxiv.org/abs/2205.04029) | **INTERSPEECH 2022** | 
[✔️Code](https://github.com/SJTMusicTeam/Muskits)

- [SingAug: Data Augmentation for Singing Voice Synthesis with Cycle-consistent Training Strategy](https://arxiv.org/abs/2203.17001) | **INTERSPEECH 2022** | 
[✔️Code](https://github.com/SJTMusicTeam/Muskits)

- [WeSinger: Data-augmented Singing Voice Synthesis with Auxiliary Losses](https://arxiv.org/abs/2203.10750?s=03) | **INTERSPEECH 2022** | 
[🎧Demo](https://zzw922cn.github.io/wesinger/)

- [WeSinger 2: Fully Parallel Singing Voice Synthesis via Multi-Singer Conditional Adversarial Training](https://arxiv.org/abs/2207.01886) | 2022/08 | 
[🎧Demo](https://zzw922cn.github.io/wesinger2/)

- [Deep Learning Approaches in Topics of Singing Information Processing](https://ieeexplore.ieee.org/document/9829265) | **IEEE/ACM TASLP 2022/07**

- [Learning the Beauty in Songs: Neural Singing Voice Beautifier](https://arxiv.org/abs/2202.13277) | **ACL 2022** | 
[✔️Code](https://github.com/MoonInTheRiver/NeuralSVB) | 
[🎧Demo](https://neuralsvb.github.io/)

- [DiffSinger: Singing Voice Synthesis via Shallow Diffusion Mechanism](https://arxiv.org/abs/2105.02446) | **AAAI 2022** | 
[✔️Code](https://github.com/MoonInTheRiver/DiffSinger) | 
[🎧Demo](https://diffsinger.github.io/)

[**2021**]
- [Sinsy: A Deep Neural Network-Based Singing Voice Synthesis System](https://arxiv.org/abs/2108.02776) | **IEEE/ACM TASLP 2021/08** | 
[✔️Code](https://github.com/r9y9/nnsvs)

[**2020**]
- [HiFiSinger: Towards High-Fidelity Neural Singing Voice Synthesis](https://arxiv.org/abs/2009.01776) | 2020/09 | 
[🎧Demo](https://speechresearch.github.io/hifisinger/) | 
[Unofficial Code](https://github.com/CODEJIN/HiFiSinger)

### Dateset
- [M4Singer: a Multi-Style, Multi-Singer and Musical Score Provided Mandarin Singing Corpus](https://openreview.net/forum?id=qiDmAaG6mP) | **NeurIPS 2022** | 
[🔽Apply&Download](https://github.com/M4Singer/M4Singer) | 
[🎧Demo](https://m4singer.github.io/)

- [PopCS](https://arxiv.org/abs/2105.02446) | **AAAI 2022** | 
[🔽Apply&Download](https://github.com/MoonInTheRiver/DiffSinger/blob/master/resources/apply_form.md)

- [Opencpop: A High-Quality Open Source Chinese Popular Song Corpus for Singing Voice Synthesis](https://arxiv.org/abs/2201.07429) | **INTERSPEECH 2022** | 
[🔽Apply&Download](https://wenet.org.cn/opencpop/)


## High-Quality Speech Synthesis (Other Key Words: Text-to-Speech, TTS)
[**2022**]
- [ProDiff: Progressive Fast Diffusion Model For High-Quality Text-to-Speech](https://arxiv.org/abs/2207.06389) | **ACM MM 2022** | 
[✔️Code](https://github.com/Rongjiehuang/ProDiff) | 
[🎧Demo](https://prodiff.github.io/)

- [BDDM: Bilateral Denoising Diffusion Models for Fast and High-Quality Speech Synthesis](https://arxiv.org/abs/2203.13508) | **ICLR 2022** | 
[✔️Code](https://github.com/tencent-ailab/bddm) | 
[🎧Demo](https://bilateral-denoising-diffusion-model.github.io/)

- [FastDiff: A Fast Conditional Diffusion Model for High-Quality Speech Synthesis](https://arxiv.org/abs/2204.09934) | **IJCAI 2022** | 
[✔️Code](https://github.com/Rongjiehuang/FastDiff) | 
[🎧Demo](https://fastdiff.github.io/)


## Vocoder
[**2022**]
- [DDSP-based Singing Vocoders: A New Subtractive-based Synthesizer and A Comprehensive Evaluation](https://arxiv.org/abs/2208.04756) | **ISMIR 2022** | 
[✔️Code](https://github.com/YatingMusic/ddsp-singing-vocoders/) | 
[🎧Demo](https://ddspvocoder.github.io/ismir-demo/)

- [FastDiff: A Fast Conditional Diffusion Model for High-Quality Speech Synthesis](https://arxiv.org/abs/2204.09934) | **IJCAI 2022** | 
[✔️Code](https://github.com/Rongjiehuang/FastDiff) | 
[🎧Demo](https://fastdiff.github.io/)

- [BinauralGrad: A Two-Stage Conditional Diffusion Probabilistic Model for Binaural Audio Synthesis](https://arxiv.org/abs/2205.14807) | **2022/05** | 
[🎧Demo](https://speechresearch.github.io/binauralgrad/)

[**2021**]
- [Multi-Singer: Fast Multi-Singer Singing Voice Vocoder With A Large-Scale Corpus](https://arxiv.org/abs/2112.10358) | **ACM MM 2021** | 
[🔽Apply&Download](https://github.com/Multi-Singer/Multi-Singer.github.io) | 
[✔️Code](https://github.com/Rongjiehuang/Multi-Singer) | 
[🎧Demo](https://multi-singer.github.io/)

- [WaveGrad 2: Iterative Refinement for Text-to-Speech Synthesis](https://arxiv.org/abs/2106.09660) | **INTERSPEECH 2021** | 
[🎧Demo](https://wavegrad.github.io/v2/)

- [DiffWave: A Versatile Diffusion Model for Audio Synthesis](https://arxiv.org/abs/2009.09761) | **ICLR 2021** | 
[✔️Code](https://github.com/lmnt-com/diffwave) | 
[🎧Demo](https://diffwave-demo.github.io/)

- [WaveGrad: Estimating Gradients for Waveform Generation](https://arxiv.org/abs/2009.00713) | **ICLR 2021** | 
[🎧Demo](https://wavegrad.github.io/)

[**2020**]
- [HiFi-GAN: Generative Adversarial Networks for Efficient and High Fidelity Speech Synthesis](https://arxiv.org/abs/2010.05646) | **NeurIPS 2020** | 
[✔️Code](https://github.com/jik876/hifi-gan) | 
[🎧Demo](https://jik876.github.io/hifi-gan-demo/)

- [Multi-band MelGAN: Faster Waveform Generation for High-Quality Text-to-Speech](https://arxiv.org/abs/2005.05106) | **INTERSPEECH 2020** | 
[🎧Demo](https://yanggeng1995.github.io/demo/)

- [Parallel WaveGAN: A fast waveform generation model based on generative adversarial networks with multi-resolution spectrogram](https://arxiv.org/abs/1910.11480) | **ICASSP 2020** | 
[🎧Demo](https://r9y9.github.io/projects/pwg/) | 
[Unofficial Code](https://github.com/kan-bayashi/ParallelWaveGAN)

[**2019**]
- [MelGAN: Generative Adversarial Networks for Conditional Waveform Synthesis](https://arxiv.org/abs/1910.06711) | **NeurIPS 2019** | 
[✔️Code](https://github.com/descriptinc/melgan-neurips) | 
[🎧Demo](https://melgan-neurips.github.io/)

- [Towards achieving robust universal neural vocoding](https://arxiv.org/abs/1811.06292) | **INTERSPEECH 2019** | 
[✔️Code](https://github.com/bshall/UniversalVocoding) | 
[🎧Demo](https://bshall.github.io/UniversalVocoding/) | 
[Unofficial Code](https://github.com/yistLin/universal-vocoder)


## Music Synthesis/Music Synthesis
[**2022**]
- [Multi-instrument Music Synthesis with Spectrogram Diffusion](https://arxiv.org/abs/2206.05408) | **ISMIR 2022** | 
[✔️Code](https://github.com/magenta/music-spectrogram-diffusion) | 
[🎧Demo](https://storage.googleapis.com/music-synthesis-with-spectrogram-diffusion/index.html)

- [Musika! Fast Infinite Waveform Music Generation](https://arxiv.org/abs/2208.08706) | **ISMIR 2022** | 
[✔️Code](https://github.com/marcoppasini/musika) | 
[🎧Demo](https://marcoppasini.github.io/musika)


## Automatic Music Transcription
[**2022**]
- [MT3: Multi-Task Multitrack Music Transcription](https://arxiv.org/abs/2111.03017) | **ICLR 2022** | 
[✔️Code](https://github.com/magenta/mt3) | 

[**2021**]
- [Omnizart: A General Toolbox for Automatic Music Transcription](https://joss.theoj.org/papers/10.21105/joss.03391) | **The Open Journal 2021/12** | 
[✔️Code](https://github.com/Music-and-Culture-Technology-Lab/omnizart) | 
[🎧Demo](https://music-and-culture-technology-lab.github.io/omnizart-doc/)


## Self-supervised/Unsupervised ASR
[**2022**]
- [UniSpeech-SAT: Universal Speech Representation Learning with Speaker Aware Pre-Training](https://arxiv.org/abs/2110.05752) | **ICASSP 2022** | 
[✔️Code](https://github.com/microsoft/UniSpeech) | 
[✔️Code](https://github.com/huggingface/transformers)

- [Performance-Efficiency Trade-offs in Unsupervised Pre-training for Speech Recognition](https://arxiv.org/abs/2109.06870) | **ICASSP 2022** | 
[✔️Code](https://github.com/asappresearch/sew) | 
[✔️Code](https://github.com/huggingface/transformers)

- [Pseudo-Labeling for Massively Multilingual Speech Recognition](https://arxiv.org/abs/2111.00161) | **ICASSP 2022** | 
[✔️Code](https://github.com/flashlight/wav2letter/tree/main/recipes/mling_pl) | 
[✔️Code](https://github.com/huggingface/transformers)

- [WavLM: Large-Scale Self-Supervised Pre-Training for Full Stack Speech Processing](https://arxiv.org/abs/2110.13900) | **IEEE JSTSP 2022/06** | 
[✔️Code](https://github.com/microsoft/unilm) | 
[✔️Code](https://github.com/huggingface/transformers)

[**2021**]
- [XLS-R: Self-supervised Cross-lingual Speech Representation Learning at Scale](https://arxiv.org/abs/2111.09296) | 2021/12 | 
[✔️Code](https://github.com/facebookresearch/fairseq/tree/main/examples/wav2vec/xlsr) | 
[✔️Code](https://github.com/huggingface/transformers)

- [Simple and Effective Zero-shot Cross-lingual Phoneme Recognition](https://arxiv.org/abs/2109.11680) | 2021/09 | 
[✔️Code](https://github.com/facebookresearch/fairseq) | 
[✔️Code](https://github.com/huggingface/transformers)

- [TERA: Self-Supervised Learning of Transformer Encoder Representation for Speech](https://arxiv.org/abs/2007.06028) | **IEEE/ACM TASLP 2021/08** | 
[✔️Code](https://github.com/s3prl/s3prl)

- [UniSpeech: Unified Speech Representation Learning with Labeled and Unlabeled Data](https://arxiv.org/abs/2101.07597) | **ICML 2021** | 
[✔️Code](https://github.com/cywang97/unispeech) | 
[✔️Code](https://github.com/microsoft/UniSpeech) | 
[✔️Code](https://github.com/huggingface/transformers)

- [HuBERT: Self-Supervised Speech Representation Learning by Masked Prediction of Hidden Units](https://arxiv.org/abs/2106.07447) | **IEEE/ACM TASLP 2021/06** | 
[✔️Code](https://github.com/facebookresearch/fairseq/tree/main/examples/hubert) | 
[✔️Code](https://github.com/huggingface/transformers)

[**2020**]
- [wav2vec 2.0: A Framework for Self-Supervised Learning of Speech Representations](https://arxiv.org/abs/2006.11477) | **NeurIPS 2020** | 
[✔️Code](https://github.com/facebookresearch/fairseq) | 
[✔️Code](https://github.com/huggingface/transformers)

- [vq-wav2vec: Self-Supervised Learning of Discrete Speech Representations](https://arxiv.org/abs/1910.05453) | **ICLR 2020** | 
[✔️Code](https://github.com/facebookresearch/fairseq/blob/main/examples/wav2vec/README.md) | 
[✔️Code](https://github.com/huggingface/transformers)

- [Mockingjay: Unsupervised Speech Representation Learning with Deep Bidirectional Transformer Encoders](https://arxiv.org/abs/1910.12638) | **ICASSP 2020** | 
[✔️Code](https://github.com/s3prl/s3prl)

- [Unsupervised Cross-lingual Representation Learning for Speech Recognition](https://arxiv.org/abs/2006.13979) | 2020/06 | 
[✔️Code](https://github.com/facebookresearch/fairseq/tree/main/examples/wav2vec) | 
[✔️Code](https://github.com/huggingface/transformers)

- [fairseq S2T: Fast Speech-to-Text Modeling with fairseq](https://arxiv.org/abs/2010.05171) | **AACL 2020** | 
[✔️Code](https://github.com/facebookresearch/fairseq/tree/main/examples/speech_to_text) | 
[✔️Code](https://github.com/huggingface/transformers)

[**2019**]
- [Representation Learning with Contrastive Predictive Coding](https://arxiv.org/abs/1807.03748) | 2019/07 | 
[✔️Code](https://github.com/facebookresearch/CPC_audio)


## Automatic MOS Prediction
[**2022**]
- [The VoiceMOS Challenge 2022](https://arxiv.org/abs/2203.11389) | **INTERSPEECH 2022**

[**2021**]
- [Utilizing Self-supervised Representations for MOS Prediction](https://arxiv.org/abs/2104.03017) | **INTERSPEECH 2021** | 
[✔️Code](https://github.com/s3prl/s3prl/tree/master/s3prl/downstream/mos_prediction)


## Speech Data Augmentation
[**2021**]
- [Data Augmenting Contrastive Learning of Speech Representations in the Time Domain](https://arxiv.org/abs/2007.00991) | **SLT 2021** | 
[✔️Code](https://github.com/facebookresearch/WavAugment)


## Speech Insertion
[**2022**]
- [RetrieverTTS: Modeling Decomposed Factors for Text-Based Speech Insertion](https://arxiv.org/abs/2206.13865) | **INTERSPEECH 2022** | 
[🎧Demo](https://ydcustc.github.io/retrieverTTS-demo/)


## Speech Enhancement
[**2022**]
- [Conditional Diffusion Probabilistic Model for Speech Enhancement](https://arxiv.org/abs/2202.05256) | **ICASSP 2022** | 
[✔️Code](https://github.com/neillu23/cdiffuse)

[**2021**]
- [A Study on Speech Enhancement Based on Diffusion Probabilistic Model](https://ieeexplore.ieee.org/abstract/document/9689602?casa_token=IDOwZ08QGjkAAAAA:PbT2Gmcj6XAJiz3M5-zdh_c_-z_IBWKyV3NqW9C3NwIiXIaPxxKRqf49cd0kk1ggi-XFMkQ) | **APSIPA 2021**


## Prosody-Aware
[**2022**]
- [Text-Free Prosody-Aware Generative Spoken Language Modeling](https://arxiv.org/abs/2109.03264) | **ACL 2022** | 
[✔️Code](https://github.com/facebookresearch/fairseq/tree/main/examples/textless_nlp/pgslm) | 
[🎧Demo](https://speechbot.github.io/pgslm/)

[**2021**]
- [Speech BERT Embedding For Improving Prosody in Neural TTS](https://arxiv.org/abs/2106.04312) | **ICASSP 2021** | 
[✔️Code](https://github.com/facebookresearch/fairseq/tree/main/examples/textless_nlp/pgslm) | 
[🎧Demo](https://judy44chen.github.io/TTSSpeechBERT/)


## Adversarial Attack
[**2021**]
- [Defending Your Voice: Adversarial Attack on Voice Conversion](https://arxiv.org/abs/2005.08781) | **SLT 2021** | 
[✔️Code](https://github.com/cyhuang-tw/attack-vc) | 
[🎧Demo](https://yistlin.github.io/attack-vc-demo/)


* * *
# Toolkits
## ASR Toolkits
- [S3PRL Toolkit](https://github.com/s3prl/s3prl)
- [WeNet](https://github.com/wenet-e2e/wenet)


## TTS Toolkits
- [NATSpeech: A Non-Autoregressive Text-to-Speech Framework](https://github.com/NATSpeech/NATSpeech)
- [Coqui.ai TTS](https://github.com/coqui-ai/TTS)
- [ESPnet: end-to-end speech processing toolkit](https://github.com/espnet/espnet)


## Audio/Music Processing Toolkits
- [Muskit: Open-source music processing toolkits](https://github.com/SJTMusicTeam/Muskits)
- [nnAudio: Audio processing by using pytorch 1D convolution network](https://github.com/KinWaiCheuk/nnAudio)


## Data Annotation/Alignment/ Toolkits
- [Praat: doing phonetics by computer](https://github.com/praat/praat)
- [Parselmouth - Praat in Python, the Pythonic way](https://github.com/YannickJadoul/Parselmouth)
- [Montreal Forced Aligner](https://github.com/MontrealCorpusTools/Montreal-Forced-Aligner)


## Other Frameworks and Toolkits
- [🤗 Diffusers](https://github.com/huggingface/diffusers)
- [Fairseq: Facebook AI Research Sequence-to-Sequence Toolkit](https://github.com/facebookresearch/fairseq)


* * *
# Competitions
- [Voice Conversion Challenge 2020](http://www.vc-challenge.org/) | 
[🔽Apply&Download](https://github.com/nii-yamagishilab/VCC2020-database) | 
[✔️Code](https://github.com/espnet/espnet/tree/master/egs/vcc20)

- [The Blizzard Challenge](http://www.festvox.org/blizzard/)


* * *
# References
- [Awesome Speech Recognition Speech Synthesis Papers](https://github.com/zzw922cn/awesome-speech-recognition-speech-synthesis-papers)
- [Awesome Voice Conversion Papers Projects](https://github.com/JeffC0628/awesome-voice-conversion)
- [TTS Papers](http://yqli.tech/page/tts_paper.html)
- [🐸 TTS papers](https://github.com/coqui-ai/TTS-papers)
- [Speech Synthesis Paper](https://github.com/wenet-e2e/speech-synthesis-paper)
- [Awesome Diffusion Models](https://github.com/heejkoo/Awesome-Diffusion-Models)
- [Papers With Code: Voice Conversion](https://paperswithcode.com/task/voice-conversion)
- [Papers With Code: Singing Voice Conversion](https://paperswithcode.com/search?q_meta=&q_type=&q=singing+voice+conversion)
- [Papers With Code: Singing Voice Synthesis](https://paperswithcode.com/search?q_meta=&q_type=&q=singing+voice+synthesis)
- [Awesome Open Source: Voice Conversion](https://awesomeopensource.com/projects/voice-conversion)
- [A list of demo websites for automatic music generation research](https://github.com/affige/genmusic_demo_list)
- [ICASSP 2021 Paper List-VC](https://github.com/xinshengwang/ICASSP2021_paper_list-VC)



