import PropTypes from 'prop-types';
import React from 'react';
import { cx } from 'emotion';

import style from '../styles/layout';

const Layout = props => {
  const { children, themeStyle = style, customStyle = '' } = props;

  return <div className={cx(themeStyle, customStyle)}>{children}</div>;
};

Layout.propTypes = {
  children: PropTypes.node.isRequired,
  themeStyle: PropTypes.string,
  customStyle: PropTypes.string,
};

export default Layout;
