/*
Gapstone is a Go binding for the Capstone disassembly library. For examples,
try reading the *_test.go files.

	Library Author: Nguyen Anh Quynh
	Binding Author: Ben Nagy
	License: BSD style - see LICENSE file for details
    (c) 2013 COSEINC. All Rights Reserved.

    THIS FILE WAS AUTO-GENERATED -- DO NOT EDIT!
	Command: ./genconst /Users/scottknight/work/capstone/bindings/python/capstone/
	2019-02-02T13:26:27-05:00

*/

package gapstone

// #cgo LDFLAGS: -lcapstone
// #cgo freebsd CFLAGS: -I/usr/local/include
// #cgo freebsd LDFLAGS: -L/usr/local/lib
// #include <stdlib.h>
// #include <capstone/capstone.h>
import "C"

// For Capstone Engine. AUTO-GENERATED FILE, DO NOT EDIT [x86_const.py]
// X86 registers
const (
	X86_REG_INVALID = C.X86_REG_INVALID
	X86_REG_AH      = C.X86_REG_AH
	X86_REG_AL      = C.X86_REG_AL
	X86_REG_AX      = C.X86_REG_AX
	X86_REG_BH      = C.X86_REG_BH
	X86_REG_BL      = C.X86_REG_BL
	X86_REG_BP      = C.X86_REG_BP
	X86_REG_BPL     = C.X86_REG_BPL
	X86_REG_BX      = C.X86_REG_BX
	X86_REG_CH      = C.X86_REG_CH
	X86_REG_CL      = C.X86_REG_CL
	X86_REG_CS      = C.X86_REG_CS
	X86_REG_CX      = C.X86_REG_CX
	X86_REG_DH      = C.X86_REG_DH
	X86_REG_DI      = C.X86_REG_DI
	X86_REG_DIL     = C.X86_REG_DIL
	X86_REG_DL      = C.X86_REG_DL
	X86_REG_DS      = C.X86_REG_DS
	X86_REG_DX      = C.X86_REG_DX
	X86_REG_EAX     = C.X86_REG_EAX
	X86_REG_EBP     = C.X86_REG_EBP
	X86_REG_EBX     = C.X86_REG_EBX
	X86_REG_ECX     = C.X86_REG_ECX
	X86_REG_EDI     = C.X86_REG_EDI
	X86_REG_EDX     = C.X86_REG_EDX
	X86_REG_EFLAGS  = C.X86_REG_EFLAGS
	X86_REG_EIP     = C.X86_REG_EIP
	X86_REG_EIZ     = C.X86_REG_EIZ
	X86_REG_ES      = C.X86_REG_ES
	X86_REG_ESI     = C.X86_REG_ESI
	X86_REG_ESP     = C.X86_REG_ESP
	X86_REG_FPSW    = C.X86_REG_FPSW
	X86_REG_FS      = C.X86_REG_FS
	X86_REG_GS      = C.X86_REG_GS
	X86_REG_IP      = C.X86_REG_IP
	X86_REG_RAX     = C.X86_REG_RAX
	X86_REG_RBP     = C.X86_REG_RBP
	X86_REG_RBX     = C.X86_REG_RBX
	X86_REG_RCX     = C.X86_REG_RCX
	X86_REG_RDI     = C.X86_REG_RDI
	X86_REG_RDX     = C.X86_REG_RDX
	X86_REG_RIP     = C.X86_REG_RIP
	X86_REG_RIZ     = C.X86_REG_RIZ
	X86_REG_RSI     = C.X86_REG_RSI
	X86_REG_RSP     = C.X86_REG_RSP
	X86_REG_SI      = C.X86_REG_SI
	X86_REG_SIL     = C.X86_REG_SIL
	X86_REG_SP      = C.X86_REG_SP
	X86_REG_SPL     = C.X86_REG_SPL
	X86_REG_SS      = C.X86_REG_SS
	X86_REG_CR0     = C.X86_REG_CR0
	X86_REG_CR1     = C.X86_REG_CR1
	X86_REG_CR2     = C.X86_REG_CR2
	X86_REG_CR3     = C.X86_REG_CR3
	X86_REG_CR4     = C.X86_REG_CR4
	X86_REG_CR5     = C.X86_REG_CR5
	X86_REG_CR6     = C.X86_REG_CR6
	X86_REG_CR7     = C.X86_REG_CR7
	X86_REG_CR8     = C.X86_REG_CR8
	X86_REG_CR9     = C.X86_REG_CR9
	X86_REG_CR10    = C.X86_REG_CR10
	X86_REG_CR11    = C.X86_REG_CR11
	X86_REG_CR12    = C.X86_REG_CR12
	X86_REG_CR13    = C.X86_REG_CR13
	X86_REG_CR14    = C.X86_REG_CR14
	X86_REG_CR15    = C.X86_REG_CR15
	X86_REG_DR0     = C.X86_REG_DR0
	X86_REG_DR1     = C.X86_REG_DR1
	X86_REG_DR2     = C.X86_REG_DR2
	X86_REG_DR3     = C.X86_REG_DR3
	X86_REG_DR4     = C.X86_REG_DR4
	X86_REG_DR5     = C.X86_REG_DR5
	X86_REG_DR6     = C.X86_REG_DR6
	X86_REG_DR7     = C.X86_REG_DR7
	X86_REG_DR8     = C.X86_REG_DR8
	X86_REG_DR9     = C.X86_REG_DR9
	X86_REG_DR10    = C.X86_REG_DR10
	X86_REG_DR11    = C.X86_REG_DR11
	X86_REG_DR12    = C.X86_REG_DR12
	X86_REG_DR13    = C.X86_REG_DR13
	X86_REG_DR14    = C.X86_REG_DR14
	X86_REG_DR15    = C.X86_REG_DR15
	X86_REG_FP0     = C.X86_REG_FP0
	X86_REG_FP1     = C.X86_REG_FP1
	X86_REG_FP2     = C.X86_REG_FP2
	X86_REG_FP3     = C.X86_REG_FP3
	X86_REG_FP4     = C.X86_REG_FP4
	X86_REG_FP5     = C.X86_REG_FP5
	X86_REG_FP6     = C.X86_REG_FP6
	X86_REG_FP7     = C.X86_REG_FP7
	X86_REG_K0      = C.X86_REG_K0
	X86_REG_K1      = C.X86_REG_K1
	X86_REG_K2      = C.X86_REG_K2
	X86_REG_K3      = C.X86_REG_K3
	X86_REG_K4      = C.X86_REG_K4
	X86_REG_K5      = C.X86_REG_K5
	X86_REG_K6      = C.X86_REG_K6
	X86_REG_K7      = C.X86_REG_K7
	X86_REG_MM0     = C.X86_REG_MM0
	X86_REG_MM1     = C.X86_REG_MM1
	X86_REG_MM2     = C.X86_REG_MM2
	X86_REG_MM3     = C.X86_REG_MM3
	X86_REG_MM4     = C.X86_REG_MM4
	X86_REG_MM5     = C.X86_REG_MM5
	X86_REG_MM6     = C.X86_REG_MM6
	X86_REG_MM7     = C.X86_REG_MM7
	X86_REG_R8      = C.X86_REG_R8
	X86_REG_R9      = C.X86_REG_R9
	X86_REG_R10     = C.X86_REG_R10
	X86_REG_R11     = C.X86_REG_R11
	X86_REG_R12     = C.X86_REG_R12
	X86_REG_R13     = C.X86_REG_R13
	X86_REG_R14     = C.X86_REG_R14
	X86_REG_R15     = C.X86_REG_R15
	X86_REG_ST0     = C.X86_REG_ST0
	X86_REG_ST1     = C.X86_REG_ST1
	X86_REG_ST2     = C.X86_REG_ST2
	X86_REG_ST3     = C.X86_REG_ST3
	X86_REG_ST4     = C.X86_REG_ST4
	X86_REG_ST5     = C.X86_REG_ST5
	X86_REG_ST6     = C.X86_REG_ST6
	X86_REG_ST7     = C.X86_REG_ST7
	X86_REG_XMM0    = C.X86_REG_XMM0
	X86_REG_XMM1    = C.X86_REG_XMM1
	X86_REG_XMM2    = C.X86_REG_XMM2
	X86_REG_XMM3    = C.X86_REG_XMM3
	X86_REG_XMM4    = C.X86_REG_XMM4
	X86_REG_XMM5    = C.X86_REG_XMM5
	X86_REG_XMM6    = C.X86_REG_XMM6
	X86_REG_XMM7    = C.X86_REG_XMM7
	X86_REG_XMM8    = C.X86_REG_XMM8
	X86_REG_XMM9    = C.X86_REG_XMM9
	X86_REG_XMM10   = C.X86_REG_XMM10
	X86_REG_XMM11   = C.X86_REG_XMM11
	X86_REG_XMM12   = C.X86_REG_XMM12
	X86_REG_XMM13   = C.X86_REG_XMM13
	X86_REG_XMM14   = C.X86_REG_XMM14
	X86_REG_XMM15   = C.X86_REG_XMM15
	X86_REG_XMM16   = C.X86_REG_XMM16
	X86_REG_XMM17   = C.X86_REG_XMM17
	X86_REG_XMM18   = C.X86_REG_XMM18
	X86_REG_XMM19   = C.X86_REG_XMM19
	X86_REG_XMM20   = C.X86_REG_XMM20
	X86_REG_XMM21   = C.X86_REG_XMM21
	X86_REG_XMM22   = C.X86_REG_XMM22
	X86_REG_XMM23   = C.X86_REG_XMM23
	X86_REG_XMM24   = C.X86_REG_XMM24
	X86_REG_XMM25   = C.X86_REG_XMM25
	X86_REG_XMM26   = C.X86_REG_XMM26
	X86_REG_XMM27   = C.X86_REG_XMM27
	X86_REG_XMM28   = C.X86_REG_XMM28
	X86_REG_XMM29   = C.X86_REG_XMM29
	X86_REG_XMM30   = C.X86_REG_XMM30
	X86_REG_XMM31   = C.X86_REG_XMM31
	X86_REG_YMM0    = C.X86_REG_YMM0
	X86_REG_YMM1    = C.X86_REG_YMM1
	X86_REG_YMM2    = C.X86_REG_YMM2
	X86_REG_YMM3    = C.X86_REG_YMM3
	X86_REG_YMM4    = C.X86_REG_YMM4
	X86_REG_YMM5    = C.X86_REG_YMM5
	X86_REG_YMM6    = C.X86_REG_YMM6
	X86_REG_YMM7    = C.X86_REG_YMM7
	X86_REG_YMM8    = C.X86_REG_YMM8
	X86_REG_YMM9    = C.X86_REG_YMM9
	X86_REG_YMM10   = C.X86_REG_YMM10
	X86_REG_YMM11   = C.X86_REG_YMM11
	X86_REG_YMM12   = C.X86_REG_YMM12
	X86_REG_YMM13   = C.X86_REG_YMM13
	X86_REG_YMM14   = C.X86_REG_YMM14
	X86_REG_YMM15   = C.X86_REG_YMM15
	X86_REG_YMM16   = C.X86_REG_YMM16
	X86_REG_YMM17   = C.X86_REG_YMM17
	X86_REG_YMM18   = C.X86_REG_YMM18
	X86_REG_YMM19   = C.X86_REG_YMM19
	X86_REG_YMM20   = C.X86_REG_YMM20
	X86_REG_YMM21   = C.X86_REG_YMM21
	X86_REG_YMM22   = C.X86_REG_YMM22
	X86_REG_YMM23   = C.X86_REG_YMM23
	X86_REG_YMM24   = C.X86_REG_YMM24
	X86_REG_YMM25   = C.X86_REG_YMM25
	X86_REG_YMM26   = C.X86_REG_YMM26
	X86_REG_YMM27   = C.X86_REG_YMM27
	X86_REG_YMM28   = C.X86_REG_YMM28
	X86_REG_YMM29   = C.X86_REG_YMM29
	X86_REG_YMM30   = C.X86_REG_YMM30
	X86_REG_YMM31   = C.X86_REG_YMM31
	X86_REG_ZMM0    = C.X86_REG_ZMM0
	X86_REG_ZMM1    = C.X86_REG_ZMM1
	X86_REG_ZMM2    = C.X86_REG_ZMM2
	X86_REG_ZMM3    = C.X86_REG_ZMM3
	X86_REG_ZMM4    = C.X86_REG_ZMM4
	X86_REG_ZMM5    = C.X86_REG_ZMM5
	X86_REG_ZMM6    = C.X86_REG_ZMM6
	X86_REG_ZMM7    = C.X86_REG_ZMM7
	X86_REG_ZMM8    = C.X86_REG_ZMM8
	X86_REG_ZMM9    = C.X86_REG_ZMM9
	X86_REG_ZMM10   = C.X86_REG_ZMM10
	X86_REG_ZMM11   = C.X86_REG_ZMM11
	X86_REG_ZMM12   = C.X86_REG_ZMM12
	X86_REG_ZMM13   = C.X86_REG_ZMM13
	X86_REG_ZMM14   = C.X86_REG_ZMM14
	X86_REG_ZMM15   = C.X86_REG_ZMM15
	X86_REG_ZMM16   = C.X86_REG_ZMM16
	X86_REG_ZMM17   = C.X86_REG_ZMM17
	X86_REG_ZMM18   = C.X86_REG_ZMM18
	X86_REG_ZMM19   = C.X86_REG_ZMM19
	X86_REG_ZMM20   = C.X86_REG_ZMM20
	X86_REG_ZMM21   = C.X86_REG_ZMM21
	X86_REG_ZMM22   = C.X86_REG_ZMM22
	X86_REG_ZMM23   = C.X86_REG_ZMM23
	X86_REG_ZMM24   = C.X86_REG_ZMM24
	X86_REG_ZMM25   = C.X86_REG_ZMM25
	X86_REG_ZMM26   = C.X86_REG_ZMM26
	X86_REG_ZMM27   = C.X86_REG_ZMM27
	X86_REG_ZMM28   = C.X86_REG_ZMM28
	X86_REG_ZMM29   = C.X86_REG_ZMM29
	X86_REG_ZMM30   = C.X86_REG_ZMM30
	X86_REG_ZMM31   = C.X86_REG_ZMM31
	X86_REG_R8B     = C.X86_REG_R8B
	X86_REG_R9B     = C.X86_REG_R9B
	X86_REG_R10B    = C.X86_REG_R10B
	X86_REG_R11B    = C.X86_REG_R11B
	X86_REG_R12B    = C.X86_REG_R12B
	X86_REG_R13B    = C.X86_REG_R13B
	X86_REG_R14B    = C.X86_REG_R14B
	X86_REG_R15B    = C.X86_REG_R15B
	X86_REG_R8D     = C.X86_REG_R8D
	X86_REG_R9D     = C.X86_REG_R9D
	X86_REG_R10D    = C.X86_REG_R10D
	X86_REG_R11D    = C.X86_REG_R11D
	X86_REG_R12D    = C.X86_REG_R12D
	X86_REG_R13D    = C.X86_REG_R13D
	X86_REG_R14D    = C.X86_REG_R14D
	X86_REG_R15D    = C.X86_REG_R15D
	X86_REG_R8W     = C.X86_REG_R8W
	X86_REG_R9W     = C.X86_REG_R9W
	X86_REG_R10W    = C.X86_REG_R10W
	X86_REG_R11W    = C.X86_REG_R11W
	X86_REG_R12W    = C.X86_REG_R12W
	X86_REG_R13W    = C.X86_REG_R13W
	X86_REG_R14W    = C.X86_REG_R14W
	X86_REG_R15W    = C.X86_REG_R15W
	X86_REG_ENDING  = C.X86_REG_ENDING
)

// Sub-flags of EFLAGS
const (
	X86_EFLAGS_MODIFY_AF       = C.X86_EFLAGS_MODIFY_AF
	X86_EFLAGS_MODIFY_CF       = C.X86_EFLAGS_MODIFY_CF
	X86_EFLAGS_MODIFY_SF       = C.X86_EFLAGS_MODIFY_SF
	X86_EFLAGS_MODIFY_ZF       = C.X86_EFLAGS_MODIFY_ZF
	X86_EFLAGS_MODIFY_PF       = C.X86_EFLAGS_MODIFY_PF
	X86_EFLAGS_MODIFY_OF       = C.X86_EFLAGS_MODIFY_OF
	X86_EFLAGS_MODIFY_TF       = C.X86_EFLAGS_MODIFY_TF
	X86_EFLAGS_MODIFY_IF       = C.X86_EFLAGS_MODIFY_IF
	X86_EFLAGS_MODIFY_DF       = C.X86_EFLAGS_MODIFY_DF
	X86_EFLAGS_MODIFY_NT       = C.X86_EFLAGS_MODIFY_NT
	X86_EFLAGS_MODIFY_RF       = C.X86_EFLAGS_MODIFY_RF
	X86_EFLAGS_PRIOR_OF        = C.X86_EFLAGS_PRIOR_OF
	X86_EFLAGS_PRIOR_SF        = C.X86_EFLAGS_PRIOR_SF
	X86_EFLAGS_PRIOR_ZF        = C.X86_EFLAGS_PRIOR_ZF
	X86_EFLAGS_PRIOR_AF        = C.X86_EFLAGS_PRIOR_AF
	X86_EFLAGS_PRIOR_PF        = C.X86_EFLAGS_PRIOR_PF
	X86_EFLAGS_PRIOR_CF        = C.X86_EFLAGS_PRIOR_CF
	X86_EFLAGS_PRIOR_TF        = C.X86_EFLAGS_PRIOR_TF
	X86_EFLAGS_PRIOR_IF        = C.X86_EFLAGS_PRIOR_IF
	X86_EFLAGS_PRIOR_DF        = C.X86_EFLAGS_PRIOR_DF
	X86_EFLAGS_PRIOR_NT        = C.X86_EFLAGS_PRIOR_NT
	X86_EFLAGS_RESET_OF        = C.X86_EFLAGS_RESET_OF
	X86_EFLAGS_RESET_CF        = C.X86_EFLAGS_RESET_CF
	X86_EFLAGS_RESET_DF        = C.X86_EFLAGS_RESET_DF
	X86_EFLAGS_RESET_IF        = C.X86_EFLAGS_RESET_IF
	X86_EFLAGS_RESET_SF        = C.X86_EFLAGS_RESET_SF
	X86_EFLAGS_RESET_AF        = C.X86_EFLAGS_RESET_AF
	X86_EFLAGS_RESET_TF        = C.X86_EFLAGS_RESET_TF
	X86_EFLAGS_RESET_NT        = C.X86_EFLAGS_RESET_NT
	X86_EFLAGS_RESET_PF        = C.X86_EFLAGS_RESET_PF
	X86_EFLAGS_SET_CF          = C.X86_EFLAGS_SET_CF
	X86_EFLAGS_SET_DF          = C.X86_EFLAGS_SET_DF
	X86_EFLAGS_SET_IF          = C.X86_EFLAGS_SET_IF
	X86_EFLAGS_TEST_OF         = C.X86_EFLAGS_TEST_OF
	X86_EFLAGS_TEST_SF         = C.X86_EFLAGS_TEST_SF
	X86_EFLAGS_TEST_ZF         = C.X86_EFLAGS_TEST_ZF
	X86_EFLAGS_TEST_PF         = C.X86_EFLAGS_TEST_PF
	X86_EFLAGS_TEST_CF         = C.X86_EFLAGS_TEST_CF
	X86_EFLAGS_TEST_NT         = C.X86_EFLAGS_TEST_NT
	X86_EFLAGS_TEST_DF         = C.X86_EFLAGS_TEST_DF
	X86_EFLAGS_UNDEFINED_OF    = C.X86_EFLAGS_UNDEFINED_OF
	X86_EFLAGS_UNDEFINED_SF    = C.X86_EFLAGS_UNDEFINED_SF
	X86_EFLAGS_UNDEFINED_ZF    = C.X86_EFLAGS_UNDEFINED_ZF
	X86_EFLAGS_UNDEFINED_PF    = C.X86_EFLAGS_UNDEFINED_PF
	X86_EFLAGS_UNDEFINED_AF    = C.X86_EFLAGS_UNDEFINED_AF
	X86_EFLAGS_UNDEFINED_CF    = C.X86_EFLAGS_UNDEFINED_CF
	X86_EFLAGS_RESET_RF        = C.X86_EFLAGS_RESET_RF
	X86_EFLAGS_TEST_RF         = C.X86_EFLAGS_TEST_RF
	X86_EFLAGS_TEST_IF         = C.X86_EFLAGS_TEST_IF
	X86_EFLAGS_TEST_TF         = C.X86_EFLAGS_TEST_TF
	X86_EFLAGS_TEST_AF         = C.X86_EFLAGS_TEST_AF
	X86_EFLAGS_RESET_ZF        = C.X86_EFLAGS_RESET_ZF
	X86_EFLAGS_SET_OF          = C.X86_EFLAGS_SET_OF
	X86_EFLAGS_SET_SF          = C.X86_EFLAGS_SET_SF
	X86_EFLAGS_SET_ZF          = C.X86_EFLAGS_SET_ZF
	X86_EFLAGS_SET_AF          = C.X86_EFLAGS_SET_AF
	X86_EFLAGS_SET_PF          = C.X86_EFLAGS_SET_PF
	X86_EFLAGS_RESET_0F        = C.X86_EFLAGS_RESET_0F
	X86_EFLAGS_RESET_AC        = C.X86_EFLAGS_RESET_AC
	X86_FPU_FLAGS_MODIFY_C0    = C.X86_FPU_FLAGS_MODIFY_C0
	X86_FPU_FLAGS_MODIFY_C1    = C.X86_FPU_FLAGS_MODIFY_C1
	X86_FPU_FLAGS_MODIFY_C2    = C.X86_FPU_FLAGS_MODIFY_C2
	X86_FPU_FLAGS_MODIFY_C3    = C.X86_FPU_FLAGS_MODIFY_C3
	X86_FPU_FLAGS_RESET_C0     = C.X86_FPU_FLAGS_RESET_C0
	X86_FPU_FLAGS_RESET_C1     = C.X86_FPU_FLAGS_RESET_C1
	X86_FPU_FLAGS_RESET_C2     = C.X86_FPU_FLAGS_RESET_C2
	X86_FPU_FLAGS_RESET_C3     = C.X86_FPU_FLAGS_RESET_C3
	X86_FPU_FLAGS_SET_C0       = C.X86_FPU_FLAGS_SET_C0
	X86_FPU_FLAGS_SET_C1       = C.X86_FPU_FLAGS_SET_C1
	X86_FPU_FLAGS_SET_C2       = C.X86_FPU_FLAGS_SET_C2
	X86_FPU_FLAGS_SET_C3       = C.X86_FPU_FLAGS_SET_C3
	X86_FPU_FLAGS_UNDEFINED_C0 = C.X86_FPU_FLAGS_UNDEFINED_C0
	X86_FPU_FLAGS_UNDEFINED_C1 = C.X86_FPU_FLAGS_UNDEFINED_C1
	X86_FPU_FLAGS_UNDEFINED_C2 = C.X86_FPU_FLAGS_UNDEFINED_C2
	X86_FPU_FLAGS_UNDEFINED_C3 = C.X86_FPU_FLAGS_UNDEFINED_C3
	X86_FPU_FLAGS_TEST_C0      = C.X86_FPU_FLAGS_TEST_C0
	X86_FPU_FLAGS_TEST_C1      = C.X86_FPU_FLAGS_TEST_C1
	X86_FPU_FLAGS_TEST_C2      = C.X86_FPU_FLAGS_TEST_C2
	X86_FPU_FLAGS_TEST_C3      = C.X86_FPU_FLAGS_TEST_C3
)

// Operand type for instruction's operands
const (
	X86_OP_INVALID = C.X86_OP_INVALID
	X86_OP_REG     = C.X86_OP_REG
	X86_OP_IMM     = C.X86_OP_IMM
	X86_OP_MEM     = C.X86_OP_MEM
)

// XOP Code Condition type
const (
	X86_XOP_CC_INVALID = C.X86_XOP_CC_INVALID
	X86_XOP_CC_LT      = C.X86_XOP_CC_LT
	X86_XOP_CC_LE      = C.X86_XOP_CC_LE
	X86_XOP_CC_GT      = C.X86_XOP_CC_GT
	X86_XOP_CC_GE      = C.X86_XOP_CC_GE
	X86_XOP_CC_EQ      = C.X86_XOP_CC_EQ
	X86_XOP_CC_NEQ     = C.X86_XOP_CC_NEQ
	X86_XOP_CC_FALSE   = C.X86_XOP_CC_FALSE
	X86_XOP_CC_TRUE    = C.X86_XOP_CC_TRUE
)

// AVX broadcast type
const (
	X86_AVX_BCAST_INVALID = C.X86_AVX_BCAST_INVALID
	X86_AVX_BCAST_2       = C.X86_AVX_BCAST_2
	X86_AVX_BCAST_4       = C.X86_AVX_BCAST_4
	X86_AVX_BCAST_8       = C.X86_AVX_BCAST_8
	X86_AVX_BCAST_16      = C.X86_AVX_BCAST_16
)

// SSE Code Condition type
const (
	X86_SSE_CC_INVALID = C.X86_SSE_CC_INVALID
	X86_SSE_CC_EQ      = C.X86_SSE_CC_EQ
	X86_SSE_CC_LT      = C.X86_SSE_CC_LT
	X86_SSE_CC_LE      = C.X86_SSE_CC_LE
	X86_SSE_CC_UNORD   = C.X86_SSE_CC_UNORD
	X86_SSE_CC_NEQ     = C.X86_SSE_CC_NEQ
	X86_SSE_CC_NLT     = C.X86_SSE_CC_NLT
	X86_SSE_CC_NLE     = C.X86_SSE_CC_NLE
	X86_SSE_CC_ORD     = C.X86_SSE_CC_ORD
)

// AVX Code Condition type
const (
	X86_AVX_CC_INVALID  = C.X86_AVX_CC_INVALID
	X86_AVX_CC_EQ       = C.X86_AVX_CC_EQ
	X86_AVX_CC_LT       = C.X86_AVX_CC_LT
	X86_AVX_CC_LE       = C.X86_AVX_CC_LE
	X86_AVX_CC_UNORD    = C.X86_AVX_CC_UNORD
	X86_AVX_CC_NEQ      = C.X86_AVX_CC_NEQ
	X86_AVX_CC_NLT      = C.X86_AVX_CC_NLT
	X86_AVX_CC_NLE      = C.X86_AVX_CC_NLE
	X86_AVX_CC_ORD      = C.X86_AVX_CC_ORD
	X86_AVX_CC_EQ_UQ    = C.X86_AVX_CC_EQ_UQ
	X86_AVX_CC_NGE      = C.X86_AVX_CC_NGE
	X86_AVX_CC_NGT      = C.X86_AVX_CC_NGT
	X86_AVX_CC_FALSE    = C.X86_AVX_CC_FALSE
	X86_AVX_CC_NEQ_OQ   = C.X86_AVX_CC_NEQ_OQ
	X86_AVX_CC_GE       = C.X86_AVX_CC_GE
	X86_AVX_CC_GT       = C.X86_AVX_CC_GT
	X86_AVX_CC_TRUE     = C.X86_AVX_CC_TRUE
	X86_AVX_CC_EQ_OS    = C.X86_AVX_CC_EQ_OS
	X86_AVX_CC_LT_OQ    = C.X86_AVX_CC_LT_OQ
	X86_AVX_CC_LE_OQ    = C.X86_AVX_CC_LE_OQ
	X86_AVX_CC_UNORD_S  = C.X86_AVX_CC_UNORD_S
	X86_AVX_CC_NEQ_US   = C.X86_AVX_CC_NEQ_US
	X86_AVX_CC_NLT_UQ   = C.X86_AVX_CC_NLT_UQ
	X86_AVX_CC_NLE_UQ   = C.X86_AVX_CC_NLE_UQ
	X86_AVX_CC_ORD_S    = C.X86_AVX_CC_ORD_S
	X86_AVX_CC_EQ_US    = C.X86_AVX_CC_EQ_US
	X86_AVX_CC_NGE_UQ   = C.X86_AVX_CC_NGE_UQ
	X86_AVX_CC_NGT_UQ   = C.X86_AVX_CC_NGT_UQ
	X86_AVX_CC_FALSE_OS = C.X86_AVX_CC_FALSE_OS
	X86_AVX_CC_NEQ_OS   = C.X86_AVX_CC_NEQ_OS
	X86_AVX_CC_GE_OQ    = C.X86_AVX_CC_GE_OQ
	X86_AVX_CC_GT_OQ    = C.X86_AVX_CC_GT_OQ
	X86_AVX_CC_TRUE_US  = C.X86_AVX_CC_TRUE_US
)

// AVX static rounding mode type
const (
	X86_AVX_RM_INVALID = C.X86_AVX_RM_INVALID
	X86_AVX_RM_RN      = C.X86_AVX_RM_RN
	X86_AVX_RM_RD      = C.X86_AVX_RM_RD
	X86_AVX_RM_RU      = C.X86_AVX_RM_RU
	X86_AVX_RM_RZ      = C.X86_AVX_RM_RZ
)

// Instruction prefixes - to be used in cs_x86.prefix[]
const (
	X86_PREFIX_LOCK     = C.X86_PREFIX_LOCK
	X86_PREFIX_REP      = C.X86_PREFIX_REP
	X86_PREFIX_REPE     = C.X86_PREFIX_REPE
	X86_PREFIX_REPNE    = C.X86_PREFIX_REPNE
	X86_PREFIX_CS       = C.X86_PREFIX_CS
	X86_PREFIX_SS       = C.X86_PREFIX_SS
	X86_PREFIX_DS       = C.X86_PREFIX_DS
	X86_PREFIX_ES       = C.X86_PREFIX_ES
	X86_PREFIX_FS       = C.X86_PREFIX_FS
	X86_PREFIX_GS       = C.X86_PREFIX_GS
	X86_PREFIX_OPSIZE   = C.X86_PREFIX_OPSIZE
	X86_PREFIX_ADDRSIZE = C.X86_PREFIX_ADDRSIZE
)

// X86 instructions
const (
	X86_INS_INVALID          = C.X86_INS_INVALID
	X86_INS_AAA              = C.X86_INS_AAA
	X86_INS_AAD              = C.X86_INS_AAD
	X86_INS_AAM              = C.X86_INS_AAM
	X86_INS_AAS              = C.X86_INS_AAS
	X86_INS_FABS             = C.X86_INS_FABS
	X86_INS_ADC              = C.X86_INS_ADC
	X86_INS_ADCX             = C.X86_INS_ADCX
	X86_INS_ADD              = C.X86_INS_ADD
	X86_INS_ADDPD            = C.X86_INS_ADDPD
	X86_INS_ADDPS            = C.X86_INS_ADDPS
	X86_INS_ADDSD            = C.X86_INS_ADDSD
	X86_INS_ADDSS            = C.X86_INS_ADDSS
	X86_INS_ADDSUBPD         = C.X86_INS_ADDSUBPD
	X86_INS_ADDSUBPS         = C.X86_INS_ADDSUBPS
	X86_INS_FADD             = C.X86_INS_FADD
	X86_INS_FIADD            = C.X86_INS_FIADD
	X86_INS_FADDP            = C.X86_INS_FADDP
	X86_INS_ADOX             = C.X86_INS_ADOX
	X86_INS_AESDECLAST       = C.X86_INS_AESDECLAST
	X86_INS_AESDEC           = C.X86_INS_AESDEC
	X86_INS_AESENCLAST       = C.X86_INS_AESENCLAST
	X86_INS_AESENC           = C.X86_INS_AESENC
	X86_INS_AESIMC           = C.X86_INS_AESIMC
	X86_INS_AESKEYGENASSIST  = C.X86_INS_AESKEYGENASSIST
	X86_INS_AND              = C.X86_INS_AND
	X86_INS_ANDN             = C.X86_INS_ANDN
	X86_INS_ANDNPD           = C.X86_INS_ANDNPD
	X86_INS_ANDNPS           = C.X86_INS_ANDNPS
	X86_INS_ANDPD            = C.X86_INS_ANDPD
	X86_INS_ANDPS            = C.X86_INS_ANDPS
	X86_INS_ARPL             = C.X86_INS_ARPL
	X86_INS_BEXTR            = C.X86_INS_BEXTR
	X86_INS_BLCFILL          = C.X86_INS_BLCFILL
	X86_INS_BLCI             = C.X86_INS_BLCI
	X86_INS_BLCIC            = C.X86_INS_BLCIC
	X86_INS_BLCMSK           = C.X86_INS_BLCMSK
	X86_INS_BLCS             = C.X86_INS_BLCS
	X86_INS_BLENDPD          = C.X86_INS_BLENDPD
	X86_INS_BLENDPS          = C.X86_INS_BLENDPS
	X86_INS_BLENDVPD         = C.X86_INS_BLENDVPD
	X86_INS_BLENDVPS         = C.X86_INS_BLENDVPS
	X86_INS_BLSFILL          = C.X86_INS_BLSFILL
	X86_INS_BLSI             = C.X86_INS_BLSI
	X86_INS_BLSIC            = C.X86_INS_BLSIC
	X86_INS_BLSMSK           = C.X86_INS_BLSMSK
	X86_INS_BLSR             = C.X86_INS_BLSR
	X86_INS_BOUND            = C.X86_INS_BOUND
	X86_INS_BSF              = C.X86_INS_BSF
	X86_INS_BSR              = C.X86_INS_BSR
	X86_INS_BSWAP            = C.X86_INS_BSWAP
	X86_INS_BT               = C.X86_INS_BT
	X86_INS_BTC              = C.X86_INS_BTC
	X86_INS_BTR              = C.X86_INS_BTR
	X86_INS_BTS              = C.X86_INS_BTS
	X86_INS_BZHI             = C.X86_INS_BZHI
	X86_INS_CALL             = C.X86_INS_CALL
	X86_INS_CBW              = C.X86_INS_CBW
	X86_INS_CDQ              = C.X86_INS_CDQ
	X86_INS_CDQE             = C.X86_INS_CDQE
	X86_INS_FCHS             = C.X86_INS_FCHS
	X86_INS_CLAC             = C.X86_INS_CLAC
	X86_INS_CLC              = C.X86_INS_CLC
	X86_INS_CLD              = C.X86_INS_CLD
	X86_INS_CLFLUSH          = C.X86_INS_CLFLUSH
	X86_INS_CLFLUSHOPT       = C.X86_INS_CLFLUSHOPT
	X86_INS_CLGI             = C.X86_INS_CLGI
	X86_INS_CLI              = C.X86_INS_CLI
	X86_INS_CLTS             = C.X86_INS_CLTS
	X86_INS_CLWB             = C.X86_INS_CLWB
	X86_INS_CMC              = C.X86_INS_CMC
	X86_INS_CMOVA            = C.X86_INS_CMOVA
	X86_INS_CMOVAE           = C.X86_INS_CMOVAE
	X86_INS_CMOVB            = C.X86_INS_CMOVB
	X86_INS_CMOVBE           = C.X86_INS_CMOVBE
	X86_INS_FCMOVBE          = C.X86_INS_FCMOVBE
	X86_INS_FCMOVB           = C.X86_INS_FCMOVB
	X86_INS_CMOVE            = C.X86_INS_CMOVE
	X86_INS_FCMOVE           = C.X86_INS_FCMOVE
	X86_INS_CMOVG            = C.X86_INS_CMOVG
	X86_INS_CMOVGE           = C.X86_INS_CMOVGE
	X86_INS_CMOVL            = C.X86_INS_CMOVL
	X86_INS_CMOVLE           = C.X86_INS_CMOVLE
	X86_INS_FCMOVNBE         = C.X86_INS_FCMOVNBE
	X86_INS_FCMOVNB          = C.X86_INS_FCMOVNB
	X86_INS_CMOVNE           = C.X86_INS_CMOVNE
	X86_INS_FCMOVNE          = C.X86_INS_FCMOVNE
	X86_INS_CMOVNO           = C.X86_INS_CMOVNO
	X86_INS_CMOVNP           = C.X86_INS_CMOVNP
	X86_INS_FCMOVNU          = C.X86_INS_FCMOVNU
	X86_INS_CMOVNS           = C.X86_INS_CMOVNS
	X86_INS_CMOVO            = C.X86_INS_CMOVO
	X86_INS_CMOVP            = C.X86_INS_CMOVP
	X86_INS_FCMOVU           = C.X86_INS_FCMOVU
	X86_INS_CMOVS            = C.X86_INS_CMOVS
	X86_INS_CMP              = C.X86_INS_CMP
	X86_INS_CMPSB            = C.X86_INS_CMPSB
	X86_INS_CMPSQ            = C.X86_INS_CMPSQ
	X86_INS_CMPSW            = C.X86_INS_CMPSW
	X86_INS_CMPXCHG16B       = C.X86_INS_CMPXCHG16B
	X86_INS_CMPXCHG          = C.X86_INS_CMPXCHG
	X86_INS_CMPXCHG8B        = C.X86_INS_CMPXCHG8B
	X86_INS_COMISD           = C.X86_INS_COMISD
	X86_INS_COMISS           = C.X86_INS_COMISS
	X86_INS_FCOMP            = C.X86_INS_FCOMP
	X86_INS_FCOMIP           = C.X86_INS_FCOMIP
	X86_INS_FCOMI            = C.X86_INS_FCOMI
	X86_INS_FCOM             = C.X86_INS_FCOM
	X86_INS_FCOS             = C.X86_INS_FCOS
	X86_INS_CPUID            = C.X86_INS_CPUID
	X86_INS_CQO              = C.X86_INS_CQO
	X86_INS_CRC32            = C.X86_INS_CRC32
	X86_INS_CVTDQ2PD         = C.X86_INS_CVTDQ2PD
	X86_INS_CVTDQ2PS         = C.X86_INS_CVTDQ2PS
	X86_INS_CVTPD2DQ         = C.X86_INS_CVTPD2DQ
	X86_INS_CVTPD2PS         = C.X86_INS_CVTPD2PS
	X86_INS_CVTPS2DQ         = C.X86_INS_CVTPS2DQ
	X86_INS_CVTPS2PD         = C.X86_INS_CVTPS2PD
	X86_INS_CVTSD2SI         = C.X86_INS_CVTSD2SI
	X86_INS_CVTSD2SS         = C.X86_INS_CVTSD2SS
	X86_INS_CVTSI2SD         = C.X86_INS_CVTSI2SD
	X86_INS_CVTSI2SS         = C.X86_INS_CVTSI2SS
	X86_INS_CVTSS2SD         = C.X86_INS_CVTSS2SD
	X86_INS_CVTSS2SI         = C.X86_INS_CVTSS2SI
	X86_INS_CVTTPD2DQ        = C.X86_INS_CVTTPD2DQ
	X86_INS_CVTTPS2DQ        = C.X86_INS_CVTTPS2DQ
	X86_INS_CVTTSD2SI        = C.X86_INS_CVTTSD2SI
	X86_INS_CVTTSS2SI        = C.X86_INS_CVTTSS2SI
	X86_INS_CWD              = C.X86_INS_CWD
	X86_INS_CWDE             = C.X86_INS_CWDE
	X86_INS_DAA              = C.X86_INS_DAA
	X86_INS_DAS              = C.X86_INS_DAS
	X86_INS_DATA16           = C.X86_INS_DATA16
	X86_INS_DEC              = C.X86_INS_DEC
	X86_INS_DIV              = C.X86_INS_DIV
	X86_INS_DIVPD            = C.X86_INS_DIVPD
	X86_INS_DIVPS            = C.X86_INS_DIVPS
	X86_INS_FDIVR            = C.X86_INS_FDIVR
	X86_INS_FIDIVR           = C.X86_INS_FIDIVR
	X86_INS_FDIVRP           = C.X86_INS_FDIVRP
	X86_INS_DIVSD            = C.X86_INS_DIVSD
	X86_INS_DIVSS            = C.X86_INS_DIVSS
	X86_INS_FDIV             = C.X86_INS_FDIV
	X86_INS_FIDIV            = C.X86_INS_FIDIV
	X86_INS_FDIVP            = C.X86_INS_FDIVP
	X86_INS_DPPD             = C.X86_INS_DPPD
	X86_INS_DPPS             = C.X86_INS_DPPS
	X86_INS_RET              = C.X86_INS_RET
	X86_INS_ENCLS            = C.X86_INS_ENCLS
	X86_INS_ENCLU            = C.X86_INS_ENCLU
	X86_INS_ENTER            = C.X86_INS_ENTER
	X86_INS_EXTRACTPS        = C.X86_INS_EXTRACTPS
	X86_INS_EXTRQ            = C.X86_INS_EXTRQ
	X86_INS_F2XM1            = C.X86_INS_F2XM1
	X86_INS_LCALL            = C.X86_INS_LCALL
	X86_INS_LJMP             = C.X86_INS_LJMP
	X86_INS_FBLD             = C.X86_INS_FBLD
	X86_INS_FBSTP            = C.X86_INS_FBSTP
	X86_INS_FCOMPP           = C.X86_INS_FCOMPP
	X86_INS_FDECSTP          = C.X86_INS_FDECSTP
	X86_INS_FEMMS            = C.X86_INS_FEMMS
	X86_INS_FFREE            = C.X86_INS_FFREE
	X86_INS_FICOM            = C.X86_INS_FICOM
	X86_INS_FICOMP           = C.X86_INS_FICOMP
	X86_INS_FINCSTP          = C.X86_INS_FINCSTP
	X86_INS_FLDCW            = C.X86_INS_FLDCW
	X86_INS_FLDENV           = C.X86_INS_FLDENV
	X86_INS_FLDL2E           = C.X86_INS_FLDL2E
	X86_INS_FLDL2T           = C.X86_INS_FLDL2T
	X86_INS_FLDLG2           = C.X86_INS_FLDLG2
	X86_INS_FLDLN2           = C.X86_INS_FLDLN2
	X86_INS_FLDPI            = C.X86_INS_FLDPI
	X86_INS_FNCLEX           = C.X86_INS_FNCLEX
	X86_INS_FNINIT           = C.X86_INS_FNINIT
	X86_INS_FNOP             = C.X86_INS_FNOP
	X86_INS_FNSTCW           = C.X86_INS_FNSTCW
	X86_INS_FNSTSW           = C.X86_INS_FNSTSW
	X86_INS_FPATAN           = C.X86_INS_FPATAN
	X86_INS_FPREM            = C.X86_INS_FPREM
	X86_INS_FPREM1           = C.X86_INS_FPREM1
	X86_INS_FPTAN            = C.X86_INS_FPTAN
	X86_INS_FFREEP           = C.X86_INS_FFREEP
	X86_INS_FRNDINT          = C.X86_INS_FRNDINT
	X86_INS_FRSTOR           = C.X86_INS_FRSTOR
	X86_INS_FNSAVE           = C.X86_INS_FNSAVE
	X86_INS_FSCALE           = C.X86_INS_FSCALE
	X86_INS_FSETPM           = C.X86_INS_FSETPM
	X86_INS_FSINCOS          = C.X86_INS_FSINCOS
	X86_INS_FNSTENV          = C.X86_INS_FNSTENV
	X86_INS_FXAM             = C.X86_INS_FXAM
	X86_INS_FXRSTOR          = C.X86_INS_FXRSTOR
	X86_INS_FXRSTOR64        = C.X86_INS_FXRSTOR64
	X86_INS_FXSAVE           = C.X86_INS_FXSAVE
	X86_INS_FXSAVE64         = C.X86_INS_FXSAVE64
	X86_INS_FXTRACT          = C.X86_INS_FXTRACT
	X86_INS_FYL2X            = C.X86_INS_FYL2X
	X86_INS_FYL2XP1          = C.X86_INS_FYL2XP1
	X86_INS_MOVAPD           = C.X86_INS_MOVAPD
	X86_INS_MOVAPS           = C.X86_INS_MOVAPS
	X86_INS_ORPD             = C.X86_INS_ORPD
	X86_INS_ORPS             = C.X86_INS_ORPS
	X86_INS_VMOVAPD          = C.X86_INS_VMOVAPD
	X86_INS_VMOVAPS          = C.X86_INS_VMOVAPS
	X86_INS_XORPD            = C.X86_INS_XORPD
	X86_INS_XORPS            = C.X86_INS_XORPS
	X86_INS_GETSEC           = C.X86_INS_GETSEC
	X86_INS_HADDPD           = C.X86_INS_HADDPD
	X86_INS_HADDPS           = C.X86_INS_HADDPS
	X86_INS_HLT              = C.X86_INS_HLT
	X86_INS_HSUBPD           = C.X86_INS_HSUBPD
	X86_INS_HSUBPS           = C.X86_INS_HSUBPS
	X86_INS_IDIV             = C.X86_INS_IDIV
	X86_INS_FILD             = C.X86_INS_FILD
	X86_INS_IMUL             = C.X86_INS_IMUL
	X86_INS_IN               = C.X86_INS_IN
	X86_INS_INC              = C.X86_INS_INC
	X86_INS_INSB             = C.X86_INS_INSB
	X86_INS_INSERTPS         = C.X86_INS_INSERTPS
	X86_INS_INSERTQ          = C.X86_INS_INSERTQ
	X86_INS_INSD             = C.X86_INS_INSD
	X86_INS_INSW             = C.X86_INS_INSW
	X86_INS_INT              = C.X86_INS_INT
	X86_INS_INT1             = C.X86_INS_INT1
	X86_INS_INT3             = C.X86_INS_INT3
	X86_INS_INTO             = C.X86_INS_INTO
	X86_INS_INVD             = C.X86_INS_INVD
	X86_INS_INVEPT           = C.X86_INS_INVEPT
	X86_INS_INVLPG           = C.X86_INS_INVLPG
	X86_INS_INVLPGA          = C.X86_INS_INVLPGA
	X86_INS_INVPCID          = C.X86_INS_INVPCID
	X86_INS_INVVPID          = C.X86_INS_INVVPID
	X86_INS_IRET             = C.X86_INS_IRET
	X86_INS_IRETD            = C.X86_INS_IRETD
	X86_INS_IRETQ            = C.X86_INS_IRETQ
	X86_INS_FISTTP           = C.X86_INS_FISTTP
	X86_INS_FIST             = C.X86_INS_FIST
	X86_INS_FISTP            = C.X86_INS_FISTP
	X86_INS_UCOMISD          = C.X86_INS_UCOMISD
	X86_INS_UCOMISS          = C.X86_INS_UCOMISS
	X86_INS_VCOMISD          = C.X86_INS_VCOMISD
	X86_INS_VCOMISS          = C.X86_INS_VCOMISS
	X86_INS_VCVTSD2SS        = C.X86_INS_VCVTSD2SS
	X86_INS_VCVTSI2SD        = C.X86_INS_VCVTSI2SD
	X86_INS_VCVTSI2SS        = C.X86_INS_VCVTSI2SS
	X86_INS_VCVTSS2SD        = C.X86_INS_VCVTSS2SD
	X86_INS_VCVTTSD2SI       = C.X86_INS_VCVTTSD2SI
	X86_INS_VCVTTSD2USI      = C.X86_INS_VCVTTSD2USI
	X86_INS_VCVTTSS2SI       = C.X86_INS_VCVTTSS2SI
	X86_INS_VCVTTSS2USI      = C.X86_INS_VCVTTSS2USI
	X86_INS_VCVTUSI2SD       = C.X86_INS_VCVTUSI2SD
	X86_INS_VCVTUSI2SS       = C.X86_INS_VCVTUSI2SS
	X86_INS_VUCOMISD         = C.X86_INS_VUCOMISD
	X86_INS_VUCOMISS         = C.X86_INS_VUCOMISS
	X86_INS_JAE              = C.X86_INS_JAE
	X86_INS_JA               = C.X86_INS_JA
	X86_INS_JBE              = C.X86_INS_JBE
	X86_INS_JB               = C.X86_INS_JB
	X86_INS_JCXZ             = C.X86_INS_JCXZ
	X86_INS_JECXZ            = C.X86_INS_JECXZ
	X86_INS_JE               = C.X86_INS_JE
	X86_INS_JGE              = C.X86_INS_JGE
	X86_INS_JG               = C.X86_INS_JG
	X86_INS_JLE              = C.X86_INS_JLE
	X86_INS_JL               = C.X86_INS_JL
	X86_INS_JMP              = C.X86_INS_JMP
	X86_INS_JNE              = C.X86_INS_JNE
	X86_INS_JNO              = C.X86_INS_JNO
	X86_INS_JNP              = C.X86_INS_JNP
	X86_INS_JNS              = C.X86_INS_JNS
	X86_INS_JO               = C.X86_INS_JO
	X86_INS_JP               = C.X86_INS_JP
	X86_INS_JRCXZ            = C.X86_INS_JRCXZ
	X86_INS_JS               = C.X86_INS_JS
	X86_INS_KANDB            = C.X86_INS_KANDB
	X86_INS_KANDD            = C.X86_INS_KANDD
	X86_INS_KANDNB           = C.X86_INS_KANDNB
	X86_INS_KANDND           = C.X86_INS_KANDND
	X86_INS_KANDNQ           = C.X86_INS_KANDNQ
	X86_INS_KANDNW           = C.X86_INS_KANDNW
	X86_INS_KANDQ            = C.X86_INS_KANDQ
	X86_INS_KANDW            = C.X86_INS_KANDW
	X86_INS_KMOVB            = C.X86_INS_KMOVB
	X86_INS_KMOVD            = C.X86_INS_KMOVD
	X86_INS_KMOVQ            = C.X86_INS_KMOVQ
	X86_INS_KMOVW            = C.X86_INS_KMOVW
	X86_INS_KNOTB            = C.X86_INS_KNOTB
	X86_INS_KNOTD            = C.X86_INS_KNOTD
	X86_INS_KNOTQ            = C.X86_INS_KNOTQ
	X86_INS_KNOTW            = C.X86_INS_KNOTW
	X86_INS_KORB             = C.X86_INS_KORB
	X86_INS_KORD             = C.X86_INS_KORD
	X86_INS_KORQ             = C.X86_INS_KORQ
	X86_INS_KORTESTB         = C.X86_INS_KORTESTB
	X86_INS_KORTESTD         = C.X86_INS_KORTESTD
	X86_INS_KORTESTQ         = C.X86_INS_KORTESTQ
	X86_INS_KORTESTW         = C.X86_INS_KORTESTW
	X86_INS_KORW             = C.X86_INS_KORW
	X86_INS_KSHIFTLB         = C.X86_INS_KSHIFTLB
	X86_INS_KSHIFTLD         = C.X86_INS_KSHIFTLD
	X86_INS_KSHIFTLQ         = C.X86_INS_KSHIFTLQ
	X86_INS_KSHIFTLW         = C.X86_INS_KSHIFTLW
	X86_INS_KSHIFTRB         = C.X86_INS_KSHIFTRB
	X86_INS_KSHIFTRD         = C.X86_INS_KSHIFTRD
	X86_INS_KSHIFTRQ         = C.X86_INS_KSHIFTRQ
	X86_INS_KSHIFTRW         = C.X86_INS_KSHIFTRW
	X86_INS_KUNPCKBW         = C.X86_INS_KUNPCKBW
	X86_INS_KXNORB           = C.X86_INS_KXNORB
	X86_INS_KXNORD           = C.X86_INS_KXNORD
	X86_INS_KXNORQ           = C.X86_INS_KXNORQ
	X86_INS_KXNORW           = C.X86_INS_KXNORW
	X86_INS_KXORB            = C.X86_INS_KXORB
	X86_INS_KXORD            = C.X86_INS_KXORD
	X86_INS_KXORQ            = C.X86_INS_KXORQ
	X86_INS_KXORW            = C.X86_INS_KXORW
	X86_INS_LAHF             = C.X86_INS_LAHF
	X86_INS_LAR              = C.X86_INS_LAR
	X86_INS_LDDQU            = C.X86_INS_LDDQU
	X86_INS_LDMXCSR          = C.X86_INS_LDMXCSR
	X86_INS_LDS              = C.X86_INS_LDS
	X86_INS_FLDZ             = C.X86_INS_FLDZ
	X86_INS_FLD1             = C.X86_INS_FLD1
	X86_INS_FLD              = C.X86_INS_FLD
	X86_INS_LEA              = C.X86_INS_LEA
	X86_INS_LEAVE            = C.X86_INS_LEAVE
	X86_INS_LES              = C.X86_INS_LES
	X86_INS_LFENCE           = C.X86_INS_LFENCE
	X86_INS_LFS              = C.X86_INS_LFS
	X86_INS_LGDT             = C.X86_INS_LGDT
	X86_INS_LGS              = C.X86_INS_LGS
	X86_INS_LIDT             = C.X86_INS_LIDT
	X86_INS_LLDT             = C.X86_INS_LLDT
	X86_INS_LMSW             = C.X86_INS_LMSW
	X86_INS_OR               = C.X86_INS_OR
	X86_INS_SUB              = C.X86_INS_SUB
	X86_INS_XOR              = C.X86_INS_XOR
	X86_INS_LODSB            = C.X86_INS_LODSB
	X86_INS_LODSD            = C.X86_INS_LODSD
	X86_INS_LODSQ            = C.X86_INS_LODSQ
	X86_INS_LODSW            = C.X86_INS_LODSW
	X86_INS_LOOP             = C.X86_INS_LOOP
	X86_INS_LOOPE            = C.X86_INS_LOOPE
	X86_INS_LOOPNE           = C.X86_INS_LOOPNE
	X86_INS_RETF             = C.X86_INS_RETF
	X86_INS_RETFQ            = C.X86_INS_RETFQ
	X86_INS_LSL              = C.X86_INS_LSL
	X86_INS_LSS              = C.X86_INS_LSS
	X86_INS_LTR              = C.X86_INS_LTR
	X86_INS_XADD             = C.X86_INS_XADD
	X86_INS_LZCNT            = C.X86_INS_LZCNT
	X86_INS_MASKMOVDQU       = C.X86_INS_MASKMOVDQU
	X86_INS_MAXPD            = C.X86_INS_MAXPD
	X86_INS_MAXPS            = C.X86_INS_MAXPS
	X86_INS_MAXSD            = C.X86_INS_MAXSD
	X86_INS_MAXSS            = C.X86_INS_MAXSS
	X86_INS_MFENCE           = C.X86_INS_MFENCE
	X86_INS_MINPD            = C.X86_INS_MINPD
	X86_INS_MINPS            = C.X86_INS_MINPS
	X86_INS_MINSD            = C.X86_INS_MINSD
	X86_INS_MINSS            = C.X86_INS_MINSS
	X86_INS_CVTPD2PI         = C.X86_INS_CVTPD2PI
	X86_INS_CVTPI2PD         = C.X86_INS_CVTPI2PD
	X86_INS_CVTPI2PS         = C.X86_INS_CVTPI2PS
	X86_INS_CVTPS2PI         = C.X86_INS_CVTPS2PI
	X86_INS_CVTTPD2PI        = C.X86_INS_CVTTPD2PI
	X86_INS_CVTTPS2PI        = C.X86_INS_CVTTPS2PI
	X86_INS_EMMS             = C.X86_INS_EMMS
	X86_INS_MASKMOVQ         = C.X86_INS_MASKMOVQ
	X86_INS_MOVD             = C.X86_INS_MOVD
	X86_INS_MOVDQ2Q          = C.X86_INS_MOVDQ2Q
	X86_INS_MOVNTQ           = C.X86_INS_MOVNTQ
	X86_INS_MOVQ2DQ          = C.X86_INS_MOVQ2DQ
	X86_INS_MOVQ             = C.X86_INS_MOVQ
	X86_INS_PABSB            = C.X86_INS_PABSB
	X86_INS_PABSD            = C.X86_INS_PABSD
	X86_INS_PABSW            = C.X86_INS_PABSW
	X86_INS_PACKSSDW         = C.X86_INS_PACKSSDW
	X86_INS_PACKSSWB         = C.X86_INS_PACKSSWB
	X86_INS_PACKUSWB         = C.X86_INS_PACKUSWB
	X86_INS_PADDB            = C.X86_INS_PADDB
	X86_INS_PADDD            = C.X86_INS_PADDD
	X86_INS_PADDQ            = C.X86_INS_PADDQ
	X86_INS_PADDSB           = C.X86_INS_PADDSB
	X86_INS_PADDSW           = C.X86_INS_PADDSW
	X86_INS_PADDUSB          = C.X86_INS_PADDUSB
	X86_INS_PADDUSW          = C.X86_INS_PADDUSW
	X86_INS_PADDW            = C.X86_INS_PADDW
	X86_INS_PALIGNR          = C.X86_INS_PALIGNR
	X86_INS_PANDN            = C.X86_INS_PANDN
	X86_INS_PAND             = C.X86_INS_PAND
	X86_INS_PAVGB            = C.X86_INS_PAVGB
	X86_INS_PAVGW            = C.X86_INS_PAVGW
	X86_INS_PCMPEQB          = C.X86_INS_PCMPEQB
	X86_INS_PCMPEQD          = C.X86_INS_PCMPEQD
	X86_INS_PCMPEQW          = C.X86_INS_PCMPEQW
	X86_INS_PCMPGTB          = C.X86_INS_PCMPGTB
	X86_INS_PCMPGTD          = C.X86_INS_PCMPGTD
	X86_INS_PCMPGTW          = C.X86_INS_PCMPGTW
	X86_INS_PEXTRW           = C.X86_INS_PEXTRW
	X86_INS_PHADDSW          = C.X86_INS_PHADDSW
	X86_INS_PHADDW           = C.X86_INS_PHADDW
	X86_INS_PHADDD           = C.X86_INS_PHADDD
	X86_INS_PHSUBD           = C.X86_INS_PHSUBD
	X86_INS_PHSUBSW          = C.X86_INS_PHSUBSW
	X86_INS_PHSUBW           = C.X86_INS_PHSUBW
	X86_INS_PINSRW           = C.X86_INS_PINSRW
	X86_INS_PMADDUBSW        = C.X86_INS_PMADDUBSW
	X86_INS_PMADDWD          = C.X86_INS_PMADDWD
	X86_INS_PMAXSW           = C.X86_INS_PMAXSW
	X86_INS_PMAXUB           = C.X86_INS_PMAXUB
	X86_INS_PMINSW           = C.X86_INS_PMINSW
	X86_INS_PMINUB           = C.X86_INS_PMINUB
	X86_INS_PMOVMSKB         = C.X86_INS_PMOVMSKB
	X86_INS_PMULHRSW         = C.X86_INS_PMULHRSW
	X86_INS_PMULHUW          = C.X86_INS_PMULHUW
	X86_INS_PMULHW           = C.X86_INS_PMULHW
	X86_INS_PMULLW           = C.X86_INS_PMULLW
	X86_INS_PMULUDQ          = C.X86_INS_PMULUDQ
	X86_INS_POR              = C.X86_INS_POR
	X86_INS_PSADBW           = C.X86_INS_PSADBW
	X86_INS_PSHUFB           = C.X86_INS_PSHUFB
	X86_INS_PSHUFW           = C.X86_INS_PSHUFW
	X86_INS_PSIGNB           = C.X86_INS_PSIGNB
	X86_INS_PSIGND           = C.X86_INS_PSIGND
	X86_INS_PSIGNW           = C.X86_INS_PSIGNW
	X86_INS_PSLLD            = C.X86_INS_PSLLD
	X86_INS_PSLLQ            = C.X86_INS_PSLLQ
	X86_INS_PSLLW            = C.X86_INS_PSLLW
	X86_INS_PSRAD            = C.X86_INS_PSRAD
	X86_INS_PSRAW            = C.X86_INS_PSRAW
	X86_INS_PSRLD            = C.X86_INS_PSRLD
	X86_INS_PSRLQ            = C.X86_INS_PSRLQ
	X86_INS_PSRLW            = C.X86_INS_PSRLW
	X86_INS_PSUBB            = C.X86_INS_PSUBB
	X86_INS_PSUBD            = C.X86_INS_PSUBD
	X86_INS_PSUBQ            = C.X86_INS_PSUBQ
	X86_INS_PSUBSB           = C.X86_INS_PSUBSB
	X86_INS_PSUBSW           = C.X86_INS_PSUBSW
	X86_INS_PSUBUSB          = C.X86_INS_PSUBUSB
	X86_INS_PSUBUSW          = C.X86_INS_PSUBUSW
	X86_INS_PSUBW            = C.X86_INS_PSUBW
	X86_INS_PUNPCKHBW        = C.X86_INS_PUNPCKHBW
	X86_INS_PUNPCKHDQ        = C.X86_INS_PUNPCKHDQ
	X86_INS_PUNPCKHWD        = C.X86_INS_PUNPCKHWD
	X86_INS_PUNPCKLBW        = C.X86_INS_PUNPCKLBW
	X86_INS_PUNPCKLDQ        = C.X86_INS_PUNPCKLDQ
	X86_INS_PUNPCKLWD        = C.X86_INS_PUNPCKLWD
	X86_INS_PXOR             = C.X86_INS_PXOR
	X86_INS_MONITOR          = C.X86_INS_MONITOR
	X86_INS_MONTMUL          = C.X86_INS_MONTMUL
	X86_INS_MOV              = C.X86_INS_MOV
	X86_INS_MOVABS           = C.X86_INS_MOVABS
	X86_INS_MOVBE            = C.X86_INS_MOVBE
	X86_INS_MOVDDUP          = C.X86_INS_MOVDDUP
	X86_INS_MOVDQA           = C.X86_INS_MOVDQA
	X86_INS_MOVDQU           = C.X86_INS_MOVDQU
	X86_INS_MOVHLPS          = C.X86_INS_MOVHLPS
	X86_INS_MOVHPD           = C.X86_INS_MOVHPD
	X86_INS_MOVHPS           = C.X86_INS_MOVHPS
	X86_INS_MOVLHPS          = C.X86_INS_MOVLHPS
	X86_INS_MOVLPD           = C.X86_INS_MOVLPD
	X86_INS_MOVLPS           = C.X86_INS_MOVLPS
	X86_INS_MOVMSKPD         = C.X86_INS_MOVMSKPD
	X86_INS_MOVMSKPS         = C.X86_INS_MOVMSKPS
	X86_INS_MOVNTDQA         = C.X86_INS_MOVNTDQA
	X86_INS_MOVNTDQ          = C.X86_INS_MOVNTDQ
	X86_INS_MOVNTI           = C.X86_INS_MOVNTI
	X86_INS_MOVNTPD          = C.X86_INS_MOVNTPD
	X86_INS_MOVNTPS          = C.X86_INS_MOVNTPS
	X86_INS_MOVNTSD          = C.X86_INS_MOVNTSD
	X86_INS_MOVNTSS          = C.X86_INS_MOVNTSS
	X86_INS_MOVSB            = C.X86_INS_MOVSB
	X86_INS_MOVSD            = C.X86_INS_MOVSD
	X86_INS_MOVSHDUP         = C.X86_INS_MOVSHDUP
	X86_INS_MOVSLDUP         = C.X86_INS_MOVSLDUP
	X86_INS_MOVSQ            = C.X86_INS_MOVSQ
	X86_INS_MOVSS            = C.X86_INS_MOVSS
	X86_INS_MOVSW            = C.X86_INS_MOVSW
	X86_INS_MOVSX            = C.X86_INS_MOVSX
	X86_INS_MOVSXD           = C.X86_INS_MOVSXD
	X86_INS_MOVUPD           = C.X86_INS_MOVUPD
	X86_INS_MOVUPS           = C.X86_INS_MOVUPS
	X86_INS_MOVZX            = C.X86_INS_MOVZX
	X86_INS_MPSADBW          = C.X86_INS_MPSADBW
	X86_INS_MUL              = C.X86_INS_MUL
	X86_INS_MULPD            = C.X86_INS_MULPD
	X86_INS_MULPS            = C.X86_INS_MULPS
	X86_INS_MULSD            = C.X86_INS_MULSD
	X86_INS_MULSS            = C.X86_INS_MULSS
	X86_INS_MULX             = C.X86_INS_MULX
	X86_INS_FMUL             = C.X86_INS_FMUL
	X86_INS_FIMUL            = C.X86_INS_FIMUL
	X86_INS_FMULP            = C.X86_INS_FMULP
	X86_INS_MWAIT            = C.X86_INS_MWAIT
	X86_INS_NEG              = C.X86_INS_NEG
	X86_INS_NOP              = C.X86_INS_NOP
	X86_INS_NOT              = C.X86_INS_NOT
	X86_INS_OUT              = C.X86_INS_OUT
	X86_INS_OUTSB            = C.X86_INS_OUTSB
	X86_INS_OUTSD            = C.X86_INS_OUTSD
	X86_INS_OUTSW            = C.X86_INS_OUTSW
	X86_INS_PACKUSDW         = C.X86_INS_PACKUSDW
	X86_INS_PAUSE            = C.X86_INS_PAUSE
	X86_INS_PAVGUSB          = C.X86_INS_PAVGUSB
	X86_INS_PBLENDVB         = C.X86_INS_PBLENDVB
	X86_INS_PBLENDW          = C.X86_INS_PBLENDW
	X86_INS_PCLMULQDQ        = C.X86_INS_PCLMULQDQ
	X86_INS_PCMPEQQ          = C.X86_INS_PCMPEQQ
	X86_INS_PCMPESTRI        = C.X86_INS_PCMPESTRI
	X86_INS_PCMPESTRM        = C.X86_INS_PCMPESTRM
	X86_INS_PCMPGTQ          = C.X86_INS_PCMPGTQ
	X86_INS_PCMPISTRI        = C.X86_INS_PCMPISTRI
	X86_INS_PCMPISTRM        = C.X86_INS_PCMPISTRM
	X86_INS_PCOMMIT          = C.X86_INS_PCOMMIT
	X86_INS_PDEP             = C.X86_INS_PDEP
	X86_INS_PEXT             = C.X86_INS_PEXT
	X86_INS_PEXTRB           = C.X86_INS_PEXTRB
	X86_INS_PEXTRD           = C.X86_INS_PEXTRD
	X86_INS_PEXTRQ           = C.X86_INS_PEXTRQ
	X86_INS_PF2ID            = C.X86_INS_PF2ID
	X86_INS_PF2IW            = C.X86_INS_PF2IW
	X86_INS_PFACC            = C.X86_INS_PFACC
	X86_INS_PFADD            = C.X86_INS_PFADD
	X86_INS_PFCMPEQ          = C.X86_INS_PFCMPEQ
	X86_INS_PFCMPGE          = C.X86_INS_PFCMPGE
	X86_INS_PFCMPGT          = C.X86_INS_PFCMPGT
	X86_INS_PFMAX            = C.X86_INS_PFMAX
	X86_INS_PFMIN            = C.X86_INS_PFMIN
	X86_INS_PFMUL            = C.X86_INS_PFMUL
	X86_INS_PFNACC           = C.X86_INS_PFNACC
	X86_INS_PFPNACC          = C.X86_INS_PFPNACC
	X86_INS_PFRCPIT1         = C.X86_INS_PFRCPIT1
	X86_INS_PFRCPIT2         = C.X86_INS_PFRCPIT2
	X86_INS_PFRCP            = C.X86_INS_PFRCP
	X86_INS_PFRSQIT1         = C.X86_INS_PFRSQIT1
	X86_INS_PFRSQRT          = C.X86_INS_PFRSQRT
	X86_INS_PFSUBR           = C.X86_INS_PFSUBR
	X86_INS_PFSUB            = C.X86_INS_PFSUB
	X86_INS_PHMINPOSUW       = C.X86_INS_PHMINPOSUW
	X86_INS_PI2FD            = C.X86_INS_PI2FD
	X86_INS_PI2FW            = C.X86_INS_PI2FW
	X86_INS_PINSRB           = C.X86_INS_PINSRB
	X86_INS_PINSRD           = C.X86_INS_PINSRD
	X86_INS_PINSRQ           = C.X86_INS_PINSRQ
	X86_INS_PMAXSB           = C.X86_INS_PMAXSB
	X86_INS_PMAXSD           = C.X86_INS_PMAXSD
	X86_INS_PMAXUD           = C.X86_INS_PMAXUD
	X86_INS_PMAXUW           = C.X86_INS_PMAXUW
	X86_INS_PMINSB           = C.X86_INS_PMINSB
	X86_INS_PMINSD           = C.X86_INS_PMINSD
	X86_INS_PMINUD           = C.X86_INS_PMINUD
	X86_INS_PMINUW           = C.X86_INS_PMINUW
	X86_INS_PMOVSXBD         = C.X86_INS_PMOVSXBD
	X86_INS_PMOVSXBQ         = C.X86_INS_PMOVSXBQ
	X86_INS_PMOVSXBW         = C.X86_INS_PMOVSXBW
	X86_INS_PMOVSXDQ         = C.X86_INS_PMOVSXDQ
	X86_INS_PMOVSXWD         = C.X86_INS_PMOVSXWD
	X86_INS_PMOVSXWQ         = C.X86_INS_PMOVSXWQ
	X86_INS_PMOVZXBD         = C.X86_INS_PMOVZXBD
	X86_INS_PMOVZXBQ         = C.X86_INS_PMOVZXBQ
	X86_INS_PMOVZXBW         = C.X86_INS_PMOVZXBW
	X86_INS_PMOVZXDQ         = C.X86_INS_PMOVZXDQ
	X86_INS_PMOVZXWD         = C.X86_INS_PMOVZXWD
	X86_INS_PMOVZXWQ         = C.X86_INS_PMOVZXWQ
	X86_INS_PMULDQ           = C.X86_INS_PMULDQ
	X86_INS_PMULHRW          = C.X86_INS_PMULHRW
	X86_INS_PMULLD           = C.X86_INS_PMULLD
	X86_INS_POP              = C.X86_INS_POP
	X86_INS_POPAW            = C.X86_INS_POPAW
	X86_INS_POPAL            = C.X86_INS_POPAL
	X86_INS_POPCNT           = C.X86_INS_POPCNT
	X86_INS_POPF             = C.X86_INS_POPF
	X86_INS_POPFD            = C.X86_INS_POPFD
	X86_INS_POPFQ            = C.X86_INS_POPFQ
	X86_INS_PREFETCH         = C.X86_INS_PREFETCH
	X86_INS_PREFETCHNTA      = C.X86_INS_PREFETCHNTA
	X86_INS_PREFETCHT0       = C.X86_INS_PREFETCHT0
	X86_INS_PREFETCHT1       = C.X86_INS_PREFETCHT1
	X86_INS_PREFETCHT2       = C.X86_INS_PREFETCHT2
	X86_INS_PREFETCHW        = C.X86_INS_PREFETCHW
	X86_INS_PSHUFD           = C.X86_INS_PSHUFD
	X86_INS_PSHUFHW          = C.X86_INS_PSHUFHW
	X86_INS_PSHUFLW          = C.X86_INS_PSHUFLW
	X86_INS_PSLLDQ           = C.X86_INS_PSLLDQ
	X86_INS_PSRLDQ           = C.X86_INS_PSRLDQ
	X86_INS_PSWAPD           = C.X86_INS_PSWAPD
	X86_INS_PTEST            = C.X86_INS_PTEST
	X86_INS_PUNPCKHQDQ       = C.X86_INS_PUNPCKHQDQ
	X86_INS_PUNPCKLQDQ       = C.X86_INS_PUNPCKLQDQ
	X86_INS_PUSH             = C.X86_INS_PUSH
	X86_INS_PUSHAW           = C.X86_INS_PUSHAW
	X86_INS_PUSHAL           = C.X86_INS_PUSHAL
	X86_INS_PUSHF            = C.X86_INS_PUSHF
	X86_INS_PUSHFD           = C.X86_INS_PUSHFD
	X86_INS_PUSHFQ           = C.X86_INS_PUSHFQ
	X86_INS_RCL              = C.X86_INS_RCL
	X86_INS_RCPPS            = C.X86_INS_RCPPS
	X86_INS_RCPSS            = C.X86_INS_RCPSS
	X86_INS_RCR              = C.X86_INS_RCR
	X86_INS_RDFSBASE         = C.X86_INS_RDFSBASE
	X86_INS_RDGSBASE         = C.X86_INS_RDGSBASE
	X86_INS_RDMSR            = C.X86_INS_RDMSR
	X86_INS_RDPMC            = C.X86_INS_RDPMC
	X86_INS_RDRAND           = C.X86_INS_RDRAND
	X86_INS_RDSEED           = C.X86_INS_RDSEED
	X86_INS_RDTSC            = C.X86_INS_RDTSC
	X86_INS_RDTSCP           = C.X86_INS_RDTSCP
	X86_INS_ROL              = C.X86_INS_ROL
	X86_INS_ROR              = C.X86_INS_ROR
	X86_INS_RORX             = C.X86_INS_RORX
	X86_INS_ROUNDPD          = C.X86_INS_ROUNDPD
	X86_INS_ROUNDPS          = C.X86_INS_ROUNDPS
	X86_INS_ROUNDSD          = C.X86_INS_ROUNDSD
	X86_INS_ROUNDSS          = C.X86_INS_ROUNDSS
	X86_INS_RSM              = C.X86_INS_RSM
	X86_INS_RSQRTPS          = C.X86_INS_RSQRTPS
	X86_INS_RSQRTSS          = C.X86_INS_RSQRTSS
	X86_INS_SAHF             = C.X86_INS_SAHF
	X86_INS_SAL              = C.X86_INS_SAL
	X86_INS_SALC             = C.X86_INS_SALC
	X86_INS_SAR              = C.X86_INS_SAR
	X86_INS_SARX             = C.X86_INS_SARX
	X86_INS_SBB              = C.X86_INS_SBB
	X86_INS_SCASB            = C.X86_INS_SCASB
	X86_INS_SCASD            = C.X86_INS_SCASD
	X86_INS_SCASQ            = C.X86_INS_SCASQ
	X86_INS_SCASW            = C.X86_INS_SCASW
	X86_INS_SETAE            = C.X86_INS_SETAE
	X86_INS_SETA             = C.X86_INS_SETA
	X86_INS_SETBE            = C.X86_INS_SETBE
	X86_INS_SETB             = C.X86_INS_SETB
	X86_INS_SETE             = C.X86_INS_SETE
	X86_INS_SETGE            = C.X86_INS_SETGE
	X86_INS_SETG             = C.X86_INS_SETG
	X86_INS_SETLE            = C.X86_INS_SETLE
	X86_INS_SETL             = C.X86_INS_SETL
	X86_INS_SETNE            = C.X86_INS_SETNE
	X86_INS_SETNO            = C.X86_INS_SETNO
	X86_INS_SETNP            = C.X86_INS_SETNP
	X86_INS_SETNS            = C.X86_INS_SETNS
	X86_INS_SETO             = C.X86_INS_SETO
	X86_INS_SETP             = C.X86_INS_SETP
	X86_INS_SETS             = C.X86_INS_SETS
	X86_INS_SFENCE           = C.X86_INS_SFENCE
	X86_INS_SGDT             = C.X86_INS_SGDT
	X86_INS_SHA1MSG1         = C.X86_INS_SHA1MSG1
	X86_INS_SHA1MSG2         = C.X86_INS_SHA1MSG2
	X86_INS_SHA1NEXTE        = C.X86_INS_SHA1NEXTE
	X86_INS_SHA1RNDS4        = C.X86_INS_SHA1RNDS4
	X86_INS_SHA256MSG1       = C.X86_INS_SHA256MSG1
	X86_INS_SHA256MSG2       = C.X86_INS_SHA256MSG2
	X86_INS_SHA256RNDS2      = C.X86_INS_SHA256RNDS2
	X86_INS_SHL              = C.X86_INS_SHL
	X86_INS_SHLD             = C.X86_INS_SHLD
	X86_INS_SHLX             = C.X86_INS_SHLX
	X86_INS_SHR              = C.X86_INS_SHR
	X86_INS_SHRD             = C.X86_INS_SHRD
	X86_INS_SHRX             = C.X86_INS_SHRX
	X86_INS_SHUFPD           = C.X86_INS_SHUFPD
	X86_INS_SHUFPS           = C.X86_INS_SHUFPS
	X86_INS_SIDT             = C.X86_INS_SIDT
	X86_INS_FSIN             = C.X86_INS_FSIN
	X86_INS_SKINIT           = C.X86_INS_SKINIT
	X86_INS_SLDT             = C.X86_INS_SLDT
	X86_INS_SMSW             = C.X86_INS_SMSW
	X86_INS_SQRTPD           = C.X86_INS_SQRTPD
	X86_INS_SQRTPS           = C.X86_INS_SQRTPS
	X86_INS_SQRTSD           = C.X86_INS_SQRTSD
	X86_INS_SQRTSS           = C.X86_INS_SQRTSS
	X86_INS_FSQRT            = C.X86_INS_FSQRT
	X86_INS_STAC             = C.X86_INS_STAC
	X86_INS_STC              = C.X86_INS_STC
	X86_INS_STD              = C.X86_INS_STD
	X86_INS_STGI             = C.X86_INS_STGI
	X86_INS_STI              = C.X86_INS_STI
	X86_INS_STMXCSR          = C.X86_INS_STMXCSR
	X86_INS_STOSB            = C.X86_INS_STOSB
	X86_INS_STOSD            = C.X86_INS_STOSD
	X86_INS_STOSQ            = C.X86_INS_STOSQ
	X86_INS_STOSW            = C.X86_INS_STOSW
	X86_INS_STR              = C.X86_INS_STR
	X86_INS_FST              = C.X86_INS_FST
	X86_INS_FSTP             = C.X86_INS_FSTP
	X86_INS_FSTPNCE          = C.X86_INS_FSTPNCE
	X86_INS_FXCH             = C.X86_INS_FXCH
	X86_INS_SUBPD            = C.X86_INS_SUBPD
	X86_INS_SUBPS            = C.X86_INS_SUBPS
	X86_INS_FSUBR            = C.X86_INS_FSUBR
	X86_INS_FISUBR           = C.X86_INS_FISUBR
	X86_INS_FSUBRP           = C.X86_INS_FSUBRP
	X86_INS_SUBSD            = C.X86_INS_SUBSD
	X86_INS_SUBSS            = C.X86_INS_SUBSS
	X86_INS_FSUB             = C.X86_INS_FSUB
	X86_INS_FISUB            = C.X86_INS_FISUB
	X86_INS_FSUBP            = C.X86_INS_FSUBP
	X86_INS_SWAPGS           = C.X86_INS_SWAPGS
	X86_INS_SYSCALL          = C.X86_INS_SYSCALL
	X86_INS_SYSENTER         = C.X86_INS_SYSENTER
	X86_INS_SYSEXIT          = C.X86_INS_SYSEXIT
	X86_INS_SYSRET           = C.X86_INS_SYSRET
	X86_INS_T1MSKC           = C.X86_INS_T1MSKC
	X86_INS_TEST             = C.X86_INS_TEST
	X86_INS_UD2              = C.X86_INS_UD2
	X86_INS_FTST             = C.X86_INS_FTST
	X86_INS_TZCNT            = C.X86_INS_TZCNT
	X86_INS_TZMSK            = C.X86_INS_TZMSK
	X86_INS_FUCOMIP          = C.X86_INS_FUCOMIP
	X86_INS_FUCOMI           = C.X86_INS_FUCOMI
	X86_INS_FUCOMPP          = C.X86_INS_FUCOMPP
	X86_INS_FUCOMP           = C.X86_INS_FUCOMP
	X86_INS_FUCOM            = C.X86_INS_FUCOM
	X86_INS_UD2B             = C.X86_INS_UD2B
	X86_INS_UNPCKHPD         = C.X86_INS_UNPCKHPD
	X86_INS_UNPCKHPS         = C.X86_INS_UNPCKHPS
	X86_INS_UNPCKLPD         = C.X86_INS_UNPCKLPD
	X86_INS_UNPCKLPS         = C.X86_INS_UNPCKLPS
	X86_INS_VADDPD           = C.X86_INS_VADDPD
	X86_INS_VADDPS           = C.X86_INS_VADDPS
	X86_INS_VADDSD           = C.X86_INS_VADDSD
	X86_INS_VADDSS           = C.X86_INS_VADDSS
	X86_INS_VADDSUBPD        = C.X86_INS_VADDSUBPD
	X86_INS_VADDSUBPS        = C.X86_INS_VADDSUBPS
	X86_INS_VAESDECLAST      = C.X86_INS_VAESDECLAST
	X86_INS_VAESDEC          = C.X86_INS_VAESDEC
	X86_INS_VAESENCLAST      = C.X86_INS_VAESENCLAST
	X86_INS_VAESENC          = C.X86_INS_VAESENC
	X86_INS_VAESIMC          = C.X86_INS_VAESIMC
	X86_INS_VAESKEYGENASSIST = C.X86_INS_VAESKEYGENASSIST
	X86_INS_VALIGND          = C.X86_INS_VALIGND
	X86_INS_VALIGNQ          = C.X86_INS_VALIGNQ
	X86_INS_VANDNPD          = C.X86_INS_VANDNPD
	X86_INS_VANDNPS          = C.X86_INS_VANDNPS
	X86_INS_VANDPD           = C.X86_INS_VANDPD
	X86_INS_VANDPS           = C.X86_INS_VANDPS
	X86_INS_VBLENDMPD        = C.X86_INS_VBLENDMPD
	X86_INS_VBLENDMPS        = C.X86_INS_VBLENDMPS
	X86_INS_VBLENDPD         = C.X86_INS_VBLENDPD
	X86_INS_VBLENDPS         = C.X86_INS_VBLENDPS
	X86_INS_VBLENDVPD        = C.X86_INS_VBLENDVPD
	X86_INS_VBLENDVPS        = C.X86_INS_VBLENDVPS
	X86_INS_VBROADCASTF128   = C.X86_INS_VBROADCASTF128
	X86_INS_VBROADCASTI32X4  = C.X86_INS_VBROADCASTI32X4
	X86_INS_VBROADCASTI64X4  = C.X86_INS_VBROADCASTI64X4
	X86_INS_VBROADCASTSD     = C.X86_INS_VBROADCASTSD
	X86_INS_VBROADCASTSS     = C.X86_INS_VBROADCASTSS
	X86_INS_VCOMPRESSPD      = C.X86_INS_VCOMPRESSPD
	X86_INS_VCOMPRESSPS      = C.X86_INS_VCOMPRESSPS
	X86_INS_VCVTDQ2PD        = C.X86_INS_VCVTDQ2PD
	X86_INS_VCVTDQ2PS        = C.X86_INS_VCVTDQ2PS
	X86_INS_VCVTPD2DQX       = C.X86_INS_VCVTPD2DQX
	X86_INS_VCVTPD2DQ        = C.X86_INS_VCVTPD2DQ
	X86_INS_VCVTPD2PSX       = C.X86_INS_VCVTPD2PSX
	X86_INS_VCVTPD2PS        = C.X86_INS_VCVTPD2PS
	X86_INS_VCVTPD2UDQ       = C.X86_INS_VCVTPD2UDQ
	X86_INS_VCVTPH2PS        = C.X86_INS_VCVTPH2PS
	X86_INS_VCVTPS2DQ        = C.X86_INS_VCVTPS2DQ
	X86_INS_VCVTPS2PD        = C.X86_INS_VCVTPS2PD
	X86_INS_VCVTPS2PH        = C.X86_INS_VCVTPS2PH
	X86_INS_VCVTPS2UDQ       = C.X86_INS_VCVTPS2UDQ
	X86_INS_VCVTSD2SI        = C.X86_INS_VCVTSD2SI
	X86_INS_VCVTSD2USI       = C.X86_INS_VCVTSD2USI
	X86_INS_VCVTSS2SI        = C.X86_INS_VCVTSS2SI
	X86_INS_VCVTSS2USI       = C.X86_INS_VCVTSS2USI
	X86_INS_VCVTTPD2DQX      = C.X86_INS_VCVTTPD2DQX
	X86_INS_VCVTTPD2DQ       = C.X86_INS_VCVTTPD2DQ
	X86_INS_VCVTTPD2UDQ      = C.X86_INS_VCVTTPD2UDQ
	X86_INS_VCVTTPS2DQ       = C.X86_INS_VCVTTPS2DQ
	X86_INS_VCVTTPS2UDQ      = C.X86_INS_VCVTTPS2UDQ
	X86_INS_VCVTUDQ2PD       = C.X86_INS_VCVTUDQ2PD
	X86_INS_VCVTUDQ2PS       = C.X86_INS_VCVTUDQ2PS
	X86_INS_VDIVPD           = C.X86_INS_VDIVPD
	X86_INS_VDIVPS           = C.X86_INS_VDIVPS
	X86_INS_VDIVSD           = C.X86_INS_VDIVSD
	X86_INS_VDIVSS           = C.X86_INS_VDIVSS
	X86_INS_VDPPD            = C.X86_INS_VDPPD
	X86_INS_VDPPS            = C.X86_INS_VDPPS
	X86_INS_VERR             = C.X86_INS_VERR
	X86_INS_VERW             = C.X86_INS_VERW
	X86_INS_VEXP2PD          = C.X86_INS_VEXP2PD
	X86_INS_VEXP2PS          = C.X86_INS_VEXP2PS
	X86_INS_VEXPANDPD        = C.X86_INS_VEXPANDPD
	X86_INS_VEXPANDPS        = C.X86_INS_VEXPANDPS
	X86_INS_VEXTRACTF128     = C.X86_INS_VEXTRACTF128
	X86_INS_VEXTRACTF32X4    = C.X86_INS_VEXTRACTF32X4
	X86_INS_VEXTRACTF64X4    = C.X86_INS_VEXTRACTF64X4
	X86_INS_VEXTRACTI128     = C.X86_INS_VEXTRACTI128
	X86_INS_VEXTRACTI32X4    = C.X86_INS_VEXTRACTI32X4
	X86_INS_VEXTRACTI64X4    = C.X86_INS_VEXTRACTI64X4
	X86_INS_VEXTRACTPS       = C.X86_INS_VEXTRACTPS
	X86_INS_VFMADD132PD      = C.X86_INS_VFMADD132PD
	X86_INS_VFMADD132PS      = C.X86_INS_VFMADD132PS
	X86_INS_VFMADDPD         = C.X86_INS_VFMADDPD
	X86_INS_VFMADD213PD      = C.X86_INS_VFMADD213PD
	X86_INS_VFMADD231PD      = C.X86_INS_VFMADD231PD
	X86_INS_VFMADDPS         = C.X86_INS_VFMADDPS
	X86_INS_VFMADD213PS      = C.X86_INS_VFMADD213PS
	X86_INS_VFMADD231PS      = C.X86_INS_VFMADD231PS
	X86_INS_VFMADDSD         = C.X86_INS_VFMADDSD
	X86_INS_VFMADD213SD      = C.X86_INS_VFMADD213SD
	X86_INS_VFMADD132SD      = C.X86_INS_VFMADD132SD
	X86_INS_VFMADD231SD      = C.X86_INS_VFMADD231SD
	X86_INS_VFMADDSS         = C.X86_INS_VFMADDSS
	X86_INS_VFMADD213SS      = C.X86_INS_VFMADD213SS
	X86_INS_VFMADD132SS      = C.X86_INS_VFMADD132SS
	X86_INS_VFMADD231SS      = C.X86_INS_VFMADD231SS
	X86_INS_VFMADDSUB132PD   = C.X86_INS_VFMADDSUB132PD
	X86_INS_VFMADDSUB132PS   = C.X86_INS_VFMADDSUB132PS
	X86_INS_VFMADDSUBPD      = C.X86_INS_VFMADDSUBPD
	X86_INS_VFMADDSUB213PD   = C.X86_INS_VFMADDSUB213PD
	X86_INS_VFMADDSUB231PD   = C.X86_INS_VFMADDSUB231PD
	X86_INS_VFMADDSUBPS      = C.X86_INS_VFMADDSUBPS
	X86_INS_VFMADDSUB213PS   = C.X86_INS_VFMADDSUB213PS
	X86_INS_VFMADDSUB231PS   = C.X86_INS_VFMADDSUB231PS
	X86_INS_VFMSUB132PD      = C.X86_INS_VFMSUB132PD
	X86_INS_VFMSUB132PS      = C.X86_INS_VFMSUB132PS
	X86_INS_VFMSUBADD132PD   = C.X86_INS_VFMSUBADD132PD
	X86_INS_VFMSUBADD132PS   = C.X86_INS_VFMSUBADD132PS
	X86_INS_VFMSUBADDPD      = C.X86_INS_VFMSUBADDPD
	X86_INS_VFMSUBADD213PD   = C.X86_INS_VFMSUBADD213PD
	X86_INS_VFMSUBADD231PD   = C.X86_INS_VFMSUBADD231PD
	X86_INS_VFMSUBADDPS      = C.X86_INS_VFMSUBADDPS
	X86_INS_VFMSUBADD213PS   = C.X86_INS_VFMSUBADD213PS
	X86_INS_VFMSUBADD231PS   = C.X86_INS_VFMSUBADD231PS
	X86_INS_VFMSUBPD         = C.X86_INS_VFMSUBPD
	X86_INS_VFMSUB213PD      = C.X86_INS_VFMSUB213PD
	X86_INS_VFMSUB231PD      = C.X86_INS_VFMSUB231PD
	X86_INS_VFMSUBPS         = C.X86_INS_VFMSUBPS
	X86_INS_VFMSUB213PS      = C.X86_INS_VFMSUB213PS
	X86_INS_VFMSUB231PS      = C.X86_INS_VFMSUB231PS
	X86_INS_VFMSUBSD         = C.X86_INS_VFMSUBSD
	X86_INS_VFMSUB213SD      = C.X86_INS_VFMSUB213SD
	X86_INS_VFMSUB132SD      = C.X86_INS_VFMSUB132SD
	X86_INS_VFMSUB231SD      = C.X86_INS_VFMSUB231SD
	X86_INS_VFMSUBSS         = C.X86_INS_VFMSUBSS
	X86_INS_VFMSUB213SS      = C.X86_INS_VFMSUB213SS
	X86_INS_VFMSUB132SS      = C.X86_INS_VFMSUB132SS
	X86_INS_VFMSUB231SS      = C.X86_INS_VFMSUB231SS
	X86_INS_VFNMADD132PD     = C.X86_INS_VFNMADD132PD
	X86_INS_VFNMADD132PS     = C.X86_INS_VFNMADD132PS
	X86_INS_VFNMADDPD        = C.X86_INS_VFNMADDPD
	X86_INS_VFNMADD213PD     = C.X86_INS_VFNMADD213PD
	X86_INS_VFNMADD231PD     = C.X86_INS_VFNMADD231PD
	X86_INS_VFNMADDPS        = C.X86_INS_VFNMADDPS
	X86_INS_VFNMADD213PS     = C.X86_INS_VFNMADD213PS
	X86_INS_VFNMADD231PS     = C.X86_INS_VFNMADD231PS
	X86_INS_VFNMADDSD        = C.X86_INS_VFNMADDSD
	X86_INS_VFNMADD213SD     = C.X86_INS_VFNMADD213SD
	X86_INS_VFNMADD132SD     = C.X86_INS_VFNMADD132SD
	X86_INS_VFNMADD231SD     = C.X86_INS_VFNMADD231SD
	X86_INS_VFNMADDSS        = C.X86_INS_VFNMADDSS
	X86_INS_VFNMADD213SS     = C.X86_INS_VFNMADD213SS
	X86_INS_VFNMADD132SS     = C.X86_INS_VFNMADD132SS
	X86_INS_VFNMADD231SS     = C.X86_INS_VFNMADD231SS
	X86_INS_VFNMSUB132PD     = C.X86_INS_VFNMSUB132PD
	X86_INS_VFNMSUB132PS     = C.X86_INS_VFNMSUB132PS
	X86_INS_VFNMSUBPD        = C.X86_INS_VFNMSUBPD
	X86_INS_VFNMSUB213PD     = C.X86_INS_VFNMSUB213PD
	X86_INS_VFNMSUB231PD     = C.X86_INS_VFNMSUB231PD
	X86_INS_VFNMSUBPS        = C.X86_INS_VFNMSUBPS
	X86_INS_VFNMSUB213PS     = C.X86_INS_VFNMSUB213PS
	X86_INS_VFNMSUB231PS     = C.X86_INS_VFNMSUB231PS
	X86_INS_VFNMSUBSD        = C.X86_INS_VFNMSUBSD
	X86_INS_VFNMSUB213SD     = C.X86_INS_VFNMSUB213SD
	X86_INS_VFNMSUB132SD     = C.X86_INS_VFNMSUB132SD
	X86_INS_VFNMSUB231SD     = C.X86_INS_VFNMSUB231SD
	X86_INS_VFNMSUBSS        = C.X86_INS_VFNMSUBSS
	X86_INS_VFNMSUB213SS     = C.X86_INS_VFNMSUB213SS
	X86_INS_VFNMSUB132SS     = C.X86_INS_VFNMSUB132SS
	X86_INS_VFNMSUB231SS     = C.X86_INS_VFNMSUB231SS
	X86_INS_VFRCZPD          = C.X86_INS_VFRCZPD
	X86_INS_VFRCZPS          = C.X86_INS_VFRCZPS
	X86_INS_VFRCZSD          = C.X86_INS_VFRCZSD
	X86_INS_VFRCZSS          = C.X86_INS_VFRCZSS
	X86_INS_VORPD            = C.X86_INS_VORPD
	X86_INS_VORPS            = C.X86_INS_VORPS
	X86_INS_VXORPD           = C.X86_INS_VXORPD
	X86_INS_VXORPS           = C.X86_INS_VXORPS
	X86_INS_VGATHERDPD       = C.X86_INS_VGATHERDPD
	X86_INS_VGATHERDPS       = C.X86_INS_VGATHERDPS
	X86_INS_VGATHERPF0DPD    = C.X86_INS_VGATHERPF0DPD
	X86_INS_VGATHERPF0DPS    = C.X86_INS_VGATHERPF0DPS
	X86_INS_VGATHERPF0QPD    = C.X86_INS_VGATHERPF0QPD
	X86_INS_VGATHERPF0QPS    = C.X86_INS_VGATHERPF0QPS
	X86_INS_VGATHERPF1DPD    = C.X86_INS_VGATHERPF1DPD
	X86_INS_VGATHERPF1DPS    = C.X86_INS_VGATHERPF1DPS
	X86_INS_VGATHERPF1QPD    = C.X86_INS_VGATHERPF1QPD
	X86_INS_VGATHERPF1QPS    = C.X86_INS_VGATHERPF1QPS
	X86_INS_VGATHERQPD       = C.X86_INS_VGATHERQPD
	X86_INS_VGATHERQPS       = C.X86_INS_VGATHERQPS
	X86_INS_VHADDPD          = C.X86_INS_VHADDPD
	X86_INS_VHADDPS          = C.X86_INS_VHADDPS
	X86_INS_VHSUBPD          = C.X86_INS_VHSUBPD
	X86_INS_VHSUBPS          = C.X86_INS_VHSUBPS
	X86_INS_VINSERTF128      = C.X86_INS_VINSERTF128
	X86_INS_VINSERTF32X4     = C.X86_INS_VINSERTF32X4
	X86_INS_VINSERTF32X8     = C.X86_INS_VINSERTF32X8
	X86_INS_VINSERTF64X2     = C.X86_INS_VINSERTF64X2
	X86_INS_VINSERTF64X4     = C.X86_INS_VINSERTF64X4
	X86_INS_VINSERTI128      = C.X86_INS_VINSERTI128
	X86_INS_VINSERTI32X4     = C.X86_INS_VINSERTI32X4
	X86_INS_VINSERTI32X8     = C.X86_INS_VINSERTI32X8
	X86_INS_VINSERTI64X2     = C.X86_INS_VINSERTI64X2
	X86_INS_VINSERTI64X4     = C.X86_INS_VINSERTI64X4
	X86_INS_VINSERTPS        = C.X86_INS_VINSERTPS
	X86_INS_VLDDQU           = C.X86_INS_VLDDQU
	X86_INS_VLDMXCSR         = C.X86_INS_VLDMXCSR
	X86_INS_VMASKMOVDQU      = C.X86_INS_VMASKMOVDQU
	X86_INS_VMASKMOVPD       = C.X86_INS_VMASKMOVPD
	X86_INS_VMASKMOVPS       = C.X86_INS_VMASKMOVPS
	X86_INS_VMAXPD           = C.X86_INS_VMAXPD
	X86_INS_VMAXPS           = C.X86_INS_VMAXPS
	X86_INS_VMAXSD           = C.X86_INS_VMAXSD
	X86_INS_VMAXSS           = C.X86_INS_VMAXSS
	X86_INS_VMCALL           = C.X86_INS_VMCALL
	X86_INS_VMCLEAR          = C.X86_INS_VMCLEAR
	X86_INS_VMFUNC           = C.X86_INS_VMFUNC
	X86_INS_VMINPD           = C.X86_INS_VMINPD
	X86_INS_VMINPS           = C.X86_INS_VMINPS
	X86_INS_VMINSD           = C.X86_INS_VMINSD
	X86_INS_VMINSS           = C.X86_INS_VMINSS
	X86_INS_VMLAUNCH         = C.X86_INS_VMLAUNCH
	X86_INS_VMLOAD           = C.X86_INS_VMLOAD
	X86_INS_VMMCALL          = C.X86_INS_VMMCALL
	X86_INS_VMOVQ            = C.X86_INS_VMOVQ
	X86_INS_VMOVDDUP         = C.X86_INS_VMOVDDUP
	X86_INS_VMOVD            = C.X86_INS_VMOVD
	X86_INS_VMOVDQA32        = C.X86_INS_VMOVDQA32
	X86_INS_VMOVDQA64        = C.X86_INS_VMOVDQA64
	X86_INS_VMOVDQA          = C.X86_INS_VMOVDQA
	X86_INS_VMOVDQU16        = C.X86_INS_VMOVDQU16
	X86_INS_VMOVDQU32        = C.X86_INS_VMOVDQU32
	X86_INS_VMOVDQU64        = C.X86_INS_VMOVDQU64
	X86_INS_VMOVDQU8         = C.X86_INS_VMOVDQU8
	X86_INS_VMOVDQU          = C.X86_INS_VMOVDQU
	X86_INS_VMOVHLPS         = C.X86_INS_VMOVHLPS
	X86_INS_VMOVHPD          = C.X86_INS_VMOVHPD
	X86_INS_VMOVHPS          = C.X86_INS_VMOVHPS
	X86_INS_VMOVLHPS         = C.X86_INS_VMOVLHPS
	X86_INS_VMOVLPD          = C.X86_INS_VMOVLPD
	X86_INS_VMOVLPS          = C.X86_INS_VMOVLPS
	X86_INS_VMOVMSKPD        = C.X86_INS_VMOVMSKPD
	X86_INS_VMOVMSKPS        = C.X86_INS_VMOVMSKPS
	X86_INS_VMOVNTDQA        = C.X86_INS_VMOVNTDQA
	X86_INS_VMOVNTDQ         = C.X86_INS_VMOVNTDQ
	X86_INS_VMOVNTPD         = C.X86_INS_VMOVNTPD
	X86_INS_VMOVNTPS         = C.X86_INS_VMOVNTPS
	X86_INS_VMOVSD           = C.X86_INS_VMOVSD
	X86_INS_VMOVSHDUP        = C.X86_INS_VMOVSHDUP
	X86_INS_VMOVSLDUP        = C.X86_INS_VMOVSLDUP
	X86_INS_VMOVSS           = C.X86_INS_VMOVSS
	X86_INS_VMOVUPD          = C.X86_INS_VMOVUPD
	X86_INS_VMOVUPS          = C.X86_INS_VMOVUPS
	X86_INS_VMPSADBW         = C.X86_INS_VMPSADBW
	X86_INS_VMPTRLD          = C.X86_INS_VMPTRLD
	X86_INS_VMPTRST          = C.X86_INS_VMPTRST
	X86_INS_VMREAD           = C.X86_INS_VMREAD
	X86_INS_VMRESUME         = C.X86_INS_VMRESUME
	X86_INS_VMRUN            = C.X86_INS_VMRUN
	X86_INS_VMSAVE           = C.X86_INS_VMSAVE
	X86_INS_VMULPD           = C.X86_INS_VMULPD
	X86_INS_VMULPS           = C.X86_INS_VMULPS
	X86_INS_VMULSD           = C.X86_INS_VMULSD
	X86_INS_VMULSS           = C.X86_INS_VMULSS
	X86_INS_VMWRITE          = C.X86_INS_VMWRITE
	X86_INS_VMXOFF           = C.X86_INS_VMXOFF
	X86_INS_VMXON            = C.X86_INS_VMXON
	X86_INS_VPABSB           = C.X86_INS_VPABSB
	X86_INS_VPABSD           = C.X86_INS_VPABSD
	X86_INS_VPABSQ           = C.X86_INS_VPABSQ
	X86_INS_VPABSW           = C.X86_INS_VPABSW
	X86_INS_VPACKSSDW        = C.X86_INS_VPACKSSDW
	X86_INS_VPACKSSWB        = C.X86_INS_VPACKSSWB
	X86_INS_VPACKUSDW        = C.X86_INS_VPACKUSDW
	X86_INS_VPACKUSWB        = C.X86_INS_VPACKUSWB
	X86_INS_VPADDB           = C.X86_INS_VPADDB
	X86_INS_VPADDD           = C.X86_INS_VPADDD
	X86_INS_VPADDQ           = C.X86_INS_VPADDQ
	X86_INS_VPADDSB          = C.X86_INS_VPADDSB
	X86_INS_VPADDSW          = C.X86_INS_VPADDSW
	X86_INS_VPADDUSB         = C.X86_INS_VPADDUSB
	X86_INS_VPADDUSW         = C.X86_INS_VPADDUSW
	X86_INS_VPADDW           = C.X86_INS_VPADDW
	X86_INS_VPALIGNR         = C.X86_INS_VPALIGNR
	X86_INS_VPANDD           = C.X86_INS_VPANDD
	X86_INS_VPANDND          = C.X86_INS_VPANDND
	X86_INS_VPANDNQ          = C.X86_INS_VPANDNQ
	X86_INS_VPANDN           = C.X86_INS_VPANDN
	X86_INS_VPANDQ           = C.X86_INS_VPANDQ
	X86_INS_VPAND            = C.X86_INS_VPAND
	X86_INS_VPAVGB           = C.X86_INS_VPAVGB
	X86_INS_VPAVGW           = C.X86_INS_VPAVGW
	X86_INS_VPBLENDD         = C.X86_INS_VPBLENDD
	X86_INS_VPBLENDMB        = C.X86_INS_VPBLENDMB
	X86_INS_VPBLENDMD        = C.X86_INS_VPBLENDMD
	X86_INS_VPBLENDMQ        = C.X86_INS_VPBLENDMQ
	X86_INS_VPBLENDMW        = C.X86_INS_VPBLENDMW
	X86_INS_VPBLENDVB        = C.X86_INS_VPBLENDVB
	X86_INS_VPBLENDW         = C.X86_INS_VPBLENDW
	X86_INS_VPBROADCASTB     = C.X86_INS_VPBROADCASTB
	X86_INS_VPBROADCASTD     = C.X86_INS_VPBROADCASTD
	X86_INS_VPBROADCASTMB2Q  = C.X86_INS_VPBROADCASTMB2Q
	X86_INS_VPBROADCASTMW2D  = C.X86_INS_VPBROADCASTMW2D
	X86_INS_VPBROADCASTQ     = C.X86_INS_VPBROADCASTQ
	X86_INS_VPBROADCASTW     = C.X86_INS_VPBROADCASTW
	X86_INS_VPCLMULQDQ       = C.X86_INS_VPCLMULQDQ
	X86_INS_VPCMOV           = C.X86_INS_VPCMOV
	X86_INS_VPCMPB           = C.X86_INS_VPCMPB
	X86_INS_VPCMPD           = C.X86_INS_VPCMPD
	X86_INS_VPCMPEQB         = C.X86_INS_VPCMPEQB
	X86_INS_VPCMPEQD         = C.X86_INS_VPCMPEQD
	X86_INS_VPCMPEQQ         = C.X86_INS_VPCMPEQQ
	X86_INS_VPCMPEQW         = C.X86_INS_VPCMPEQW
	X86_INS_VPCMPESTRI       = C.X86_INS_VPCMPESTRI
	X86_INS_VPCMPESTRM       = C.X86_INS_VPCMPESTRM
	X86_INS_VPCMPGTB         = C.X86_INS_VPCMPGTB
	X86_INS_VPCMPGTD         = C.X86_INS_VPCMPGTD
	X86_INS_VPCMPGTQ         = C.X86_INS_VPCMPGTQ
	X86_INS_VPCMPGTW         = C.X86_INS_VPCMPGTW
	X86_INS_VPCMPISTRI       = C.X86_INS_VPCMPISTRI
	X86_INS_VPCMPISTRM       = C.X86_INS_VPCMPISTRM
	X86_INS_VPCMPQ           = C.X86_INS_VPCMPQ
	X86_INS_VPCMPUB          = C.X86_INS_VPCMPUB
	X86_INS_VPCMPUD          = C.X86_INS_VPCMPUD
	X86_INS_VPCMPUQ          = C.X86_INS_VPCMPUQ
	X86_INS_VPCMPUW          = C.X86_INS_VPCMPUW
	X86_INS_VPCMPW           = C.X86_INS_VPCMPW
	X86_INS_VPCOMB           = C.X86_INS_VPCOMB
	X86_INS_VPCOMD           = C.X86_INS_VPCOMD
	X86_INS_VPCOMPRESSD      = C.X86_INS_VPCOMPRESSD
	X86_INS_VPCOMPRESSQ      = C.X86_INS_VPCOMPRESSQ
	X86_INS_VPCOMQ           = C.X86_INS_VPCOMQ
	X86_INS_VPCOMUB          = C.X86_INS_VPCOMUB
	X86_INS_VPCOMUD          = C.X86_INS_VPCOMUD
	X86_INS_VPCOMUQ          = C.X86_INS_VPCOMUQ
	X86_INS_VPCOMUW          = C.X86_INS_VPCOMUW
	X86_INS_VPCOMW           = C.X86_INS_VPCOMW
	X86_INS_VPCONFLICTD      = C.X86_INS_VPCONFLICTD
	X86_INS_VPCONFLICTQ      = C.X86_INS_VPCONFLICTQ
	X86_INS_VPERM2F128       = C.X86_INS_VPERM2F128
	X86_INS_VPERM2I128       = C.X86_INS_VPERM2I128
	X86_INS_VPERMD           = C.X86_INS_VPERMD
	X86_INS_VPERMI2D         = C.X86_INS_VPERMI2D
	X86_INS_VPERMI2PD        = C.X86_INS_VPERMI2PD
	X86_INS_VPERMI2PS        = C.X86_INS_VPERMI2PS
	X86_INS_VPERMI2Q         = C.X86_INS_VPERMI2Q
	X86_INS_VPERMIL2PD       = C.X86_INS_VPERMIL2PD
	X86_INS_VPERMIL2PS       = C.X86_INS_VPERMIL2PS
	X86_INS_VPERMILPD        = C.X86_INS_VPERMILPD
	X86_INS_VPERMILPS        = C.X86_INS_VPERMILPS
	X86_INS_VPERMPD          = C.X86_INS_VPERMPD
	X86_INS_VPERMPS          = C.X86_INS_VPERMPS
	X86_INS_VPERMQ           = C.X86_INS_VPERMQ
	X86_INS_VPERMT2D         = C.X86_INS_VPERMT2D
	X86_INS_VPERMT2PD        = C.X86_INS_VPERMT2PD
	X86_INS_VPERMT2PS        = C.X86_INS_VPERMT2PS
	X86_INS_VPERMT2Q         = C.X86_INS_VPERMT2Q
	X86_INS_VPEXPANDD        = C.X86_INS_VPEXPANDD
	X86_INS_VPEXPANDQ        = C.X86_INS_VPEXPANDQ
	X86_INS_VPEXTRB          = C.X86_INS_VPEXTRB
	X86_INS_VPEXTRD          = C.X86_INS_VPEXTRD
	X86_INS_VPEXTRQ          = C.X86_INS_VPEXTRQ
	X86_INS_VPEXTRW          = C.X86_INS_VPEXTRW
	X86_INS_VPGATHERDD       = C.X86_INS_VPGATHERDD
	X86_INS_VPGATHERDQ       = C.X86_INS_VPGATHERDQ
	X86_INS_VPGATHERQD       = C.X86_INS_VPGATHERQD
	X86_INS_VPGATHERQQ       = C.X86_INS_VPGATHERQQ
	X86_INS_VPHADDBD         = C.X86_INS_VPHADDBD
	X86_INS_VPHADDBQ         = C.X86_INS_VPHADDBQ
	X86_INS_VPHADDBW         = C.X86_INS_VPHADDBW
	X86_INS_VPHADDDQ         = C.X86_INS_VPHADDDQ
	X86_INS_VPHADDD          = C.X86_INS_VPHADDD
	X86_INS_VPHADDSW         = C.X86_INS_VPHADDSW
	X86_INS_VPHADDUBD        = C.X86_INS_VPHADDUBD
	X86_INS_VPHADDUBQ        = C.X86_INS_VPHADDUBQ
	X86_INS_VPHADDUBW        = C.X86_INS_VPHADDUBW
	X86_INS_VPHADDUDQ        = C.X86_INS_VPHADDUDQ
	X86_INS_VPHADDUWD        = C.X86_INS_VPHADDUWD
	X86_INS_VPHADDUWQ        = C.X86_INS_VPHADDUWQ
	X86_INS_VPHADDWD         = C.X86_INS_VPHADDWD
	X86_INS_VPHADDWQ         = C.X86_INS_VPHADDWQ
	X86_INS_VPHADDW          = C.X86_INS_VPHADDW
	X86_INS_VPHMINPOSUW      = C.X86_INS_VPHMINPOSUW
	X86_INS_VPHSUBBW         = C.X86_INS_VPHSUBBW
	X86_INS_VPHSUBDQ         = C.X86_INS_VPHSUBDQ
	X86_INS_VPHSUBD          = C.X86_INS_VPHSUBD
	X86_INS_VPHSUBSW         = C.X86_INS_VPHSUBSW
	X86_INS_VPHSUBWD         = C.X86_INS_VPHSUBWD
	X86_INS_VPHSUBW          = C.X86_INS_VPHSUBW
	X86_INS_VPINSRB          = C.X86_INS_VPINSRB
	X86_INS_VPINSRD          = C.X86_INS_VPINSRD
	X86_INS_VPINSRQ          = C.X86_INS_VPINSRQ
	X86_INS_VPINSRW          = C.X86_INS_VPINSRW
	X86_INS_VPLZCNTD         = C.X86_INS_VPLZCNTD
	X86_INS_VPLZCNTQ         = C.X86_INS_VPLZCNTQ
	X86_INS_VPMACSDD         = C.X86_INS_VPMACSDD
	X86_INS_VPMACSDQH        = C.X86_INS_VPMACSDQH
	X86_INS_VPMACSDQL        = C.X86_INS_VPMACSDQL
	X86_INS_VPMACSSDD        = C.X86_INS_VPMACSSDD
	X86_INS_VPMACSSDQH       = C.X86_INS_VPMACSSDQH
	X86_INS_VPMACSSDQL       = C.X86_INS_VPMACSSDQL
	X86_INS_VPMACSSWD        = C.X86_INS_VPMACSSWD
	X86_INS_VPMACSSWW        = C.X86_INS_VPMACSSWW
	X86_INS_VPMACSWD         = C.X86_INS_VPMACSWD
	X86_INS_VPMACSWW         = C.X86_INS_VPMACSWW
	X86_INS_VPMADCSSWD       = C.X86_INS_VPMADCSSWD
	X86_INS_VPMADCSWD        = C.X86_INS_VPMADCSWD
	X86_INS_VPMADDUBSW       = C.X86_INS_VPMADDUBSW
	X86_INS_VPMADDWD         = C.X86_INS_VPMADDWD
	X86_INS_VPMASKMOVD       = C.X86_INS_VPMASKMOVD
	X86_INS_VPMASKMOVQ       = C.X86_INS_VPMASKMOVQ
	X86_INS_VPMAXSB          = C.X86_INS_VPMAXSB
	X86_INS_VPMAXSD          = C.X86_INS_VPMAXSD
	X86_INS_VPMAXSQ          = C.X86_INS_VPMAXSQ
	X86_INS_VPMAXSW          = C.X86_INS_VPMAXSW
	X86_INS_VPMAXUB          = C.X86_INS_VPMAXUB
	X86_INS_VPMAXUD          = C.X86_INS_VPMAXUD
	X86_INS_VPMAXUQ          = C.X86_INS_VPMAXUQ
	X86_INS_VPMAXUW          = C.X86_INS_VPMAXUW
	X86_INS_VPMINSB          = C.X86_INS_VPMINSB
	X86_INS_VPMINSD          = C.X86_INS_VPMINSD
	X86_INS_VPMINSQ          = C.X86_INS_VPMINSQ
	X86_INS_VPMINSW          = C.X86_INS_VPMINSW
	X86_INS_VPMINUB          = C.X86_INS_VPMINUB
	X86_INS_VPMINUD          = C.X86_INS_VPMINUD
	X86_INS_VPMINUQ          = C.X86_INS_VPMINUQ
	X86_INS_VPMINUW          = C.X86_INS_VPMINUW
	X86_INS_VPMOVDB          = C.X86_INS_VPMOVDB
	X86_INS_VPMOVDW          = C.X86_INS_VPMOVDW
	X86_INS_VPMOVM2B         = C.X86_INS_VPMOVM2B
	X86_INS_VPMOVM2D         = C.X86_INS_VPMOVM2D
	X86_INS_VPMOVM2Q         = C.X86_INS_VPMOVM2Q
	X86_INS_VPMOVM2W         = C.X86_INS_VPMOVM2W
	X86_INS_VPMOVMSKB        = C.X86_INS_VPMOVMSKB
	X86_INS_VPMOVQB          = C.X86_INS_VPMOVQB
	X86_INS_VPMOVQD          = C.X86_INS_VPMOVQD
	X86_INS_VPMOVQW          = C.X86_INS_VPMOVQW
	X86_INS_VPMOVSDB         = C.X86_INS_VPMOVSDB
	X86_INS_VPMOVSDW         = C.X86_INS_VPMOVSDW
	X86_INS_VPMOVSQB         = C.X86_INS_VPMOVSQB
	X86_INS_VPMOVSQD         = C.X86_INS_VPMOVSQD
	X86_INS_VPMOVSQW         = C.X86_INS_VPMOVSQW
	X86_INS_VPMOVSXBD        = C.X86_INS_VPMOVSXBD
	X86_INS_VPMOVSXBQ        = C.X86_INS_VPMOVSXBQ
	X86_INS_VPMOVSXBW        = C.X86_INS_VPMOVSXBW
	X86_INS_VPMOVSXDQ        = C.X86_INS_VPMOVSXDQ
	X86_INS_VPMOVSXWD        = C.X86_INS_VPMOVSXWD
	X86_INS_VPMOVSXWQ        = C.X86_INS_VPMOVSXWQ
	X86_INS_VPMOVUSDB        = C.X86_INS_VPMOVUSDB
	X86_INS_VPMOVUSDW        = C.X86_INS_VPMOVUSDW
	X86_INS_VPMOVUSQB        = C.X86_INS_VPMOVUSQB
	X86_INS_VPMOVUSQD        = C.X86_INS_VPMOVUSQD
	X86_INS_VPMOVUSQW        = C.X86_INS_VPMOVUSQW
	X86_INS_VPMOVZXBD        = C.X86_INS_VPMOVZXBD
	X86_INS_VPMOVZXBQ        = C.X86_INS_VPMOVZXBQ
	X86_INS_VPMOVZXBW        = C.X86_INS_VPMOVZXBW
	X86_INS_VPMOVZXDQ        = C.X86_INS_VPMOVZXDQ
	X86_INS_VPMOVZXWD        = C.X86_INS_VPMOVZXWD
	X86_INS_VPMOVZXWQ        = C.X86_INS_VPMOVZXWQ
	X86_INS_VPMULDQ          = C.X86_INS_VPMULDQ
	X86_INS_VPMULHRSW        = C.X86_INS_VPMULHRSW
	X86_INS_VPMULHUW         = C.X86_INS_VPMULHUW
	X86_INS_VPMULHW          = C.X86_INS_VPMULHW
	X86_INS_VPMULLD          = C.X86_INS_VPMULLD
	X86_INS_VPMULLQ          = C.X86_INS_VPMULLQ
	X86_INS_VPMULLW          = C.X86_INS_VPMULLW
	X86_INS_VPMULUDQ         = C.X86_INS_VPMULUDQ
	X86_INS_VPORD            = C.X86_INS_VPORD
	X86_INS_VPORQ            = C.X86_INS_VPORQ
	X86_INS_VPOR             = C.X86_INS_VPOR
	X86_INS_VPPERM           = C.X86_INS_VPPERM
	X86_INS_VPROTB           = C.X86_INS_VPROTB
	X86_INS_VPROTD           = C.X86_INS_VPROTD
	X86_INS_VPROTQ           = C.X86_INS_VPROTQ
	X86_INS_VPROTW           = C.X86_INS_VPROTW
	X86_INS_VPSADBW          = C.X86_INS_VPSADBW
	X86_INS_VPSCATTERDD      = C.X86_INS_VPSCATTERDD
	X86_INS_VPSCATTERDQ      = C.X86_INS_VPSCATTERDQ
	X86_INS_VPSCATTERQD      = C.X86_INS_VPSCATTERQD
	X86_INS_VPSCATTERQQ      = C.X86_INS_VPSCATTERQQ
	X86_INS_VPSHAB           = C.X86_INS_VPSHAB
	X86_INS_VPSHAD           = C.X86_INS_VPSHAD
	X86_INS_VPSHAQ           = C.X86_INS_VPSHAQ
	X86_INS_VPSHAW           = C.X86_INS_VPSHAW
	X86_INS_VPSHLB           = C.X86_INS_VPSHLB
	X86_INS_VPSHLD           = C.X86_INS_VPSHLD
	X86_INS_VPSHLQ           = C.X86_INS_VPSHLQ
	X86_INS_VPSHLW           = C.X86_INS_VPSHLW
	X86_INS_VPSHUFB          = C.X86_INS_VPSHUFB
	X86_INS_VPSHUFD          = C.X86_INS_VPSHUFD
	X86_INS_VPSHUFHW         = C.X86_INS_VPSHUFHW
	X86_INS_VPSHUFLW         = C.X86_INS_VPSHUFLW
	X86_INS_VPSIGNB          = C.X86_INS_VPSIGNB
	X86_INS_VPSIGND          = C.X86_INS_VPSIGND
	X86_INS_VPSIGNW          = C.X86_INS_VPSIGNW
	X86_INS_VPSLLDQ          = C.X86_INS_VPSLLDQ
	X86_INS_VPSLLD           = C.X86_INS_VPSLLD
	X86_INS_VPSLLQ           = C.X86_INS_VPSLLQ
	X86_INS_VPSLLVD          = C.X86_INS_VPSLLVD
	X86_INS_VPSLLVQ          = C.X86_INS_VPSLLVQ
	X86_INS_VPSLLW           = C.X86_INS_VPSLLW
	X86_INS_VPSRAD           = C.X86_INS_VPSRAD
	X86_INS_VPSRAQ           = C.X86_INS_VPSRAQ
	X86_INS_VPSRAVD          = C.X86_INS_VPSRAVD
	X86_INS_VPSRAVQ          = C.X86_INS_VPSRAVQ
	X86_INS_VPSRAW           = C.X86_INS_VPSRAW
	X86_INS_VPSRLDQ          = C.X86_INS_VPSRLDQ
	X86_INS_VPSRLD           = C.X86_INS_VPSRLD
	X86_INS_VPSRLQ           = C.X86_INS_VPSRLQ
	X86_INS_VPSRLVD          = C.X86_INS_VPSRLVD
	X86_INS_VPSRLVQ          = C.X86_INS_VPSRLVQ
	X86_INS_VPSRLW           = C.X86_INS_VPSRLW
	X86_INS_VPSUBB           = C.X86_INS_VPSUBB
	X86_INS_VPSUBD           = C.X86_INS_VPSUBD
	X86_INS_VPSUBQ           = C.X86_INS_VPSUBQ
	X86_INS_VPSUBSB          = C.X86_INS_VPSUBSB
	X86_INS_VPSUBSW          = C.X86_INS_VPSUBSW
	X86_INS_VPSUBUSB         = C.X86_INS_VPSUBUSB
	X86_INS_VPSUBUSW         = C.X86_INS_VPSUBUSW
	X86_INS_VPSUBW           = C.X86_INS_VPSUBW
	X86_INS_VPTESTMD         = C.X86_INS_VPTESTMD
	X86_INS_VPTESTMQ         = C.X86_INS_VPTESTMQ
	X86_INS_VPTESTNMD        = C.X86_INS_VPTESTNMD
	X86_INS_VPTESTNMQ        = C.X86_INS_VPTESTNMQ
	X86_INS_VPTEST           = C.X86_INS_VPTEST
	X86_INS_VPUNPCKHBW       = C.X86_INS_VPUNPCKHBW
	X86_INS_VPUNPCKHDQ       = C.X86_INS_VPUNPCKHDQ
	X86_INS_VPUNPCKHQDQ      = C.X86_INS_VPUNPCKHQDQ
	X86_INS_VPUNPCKHWD       = C.X86_INS_VPUNPCKHWD
	X86_INS_VPUNPCKLBW       = C.X86_INS_VPUNPCKLBW
	X86_INS_VPUNPCKLDQ       = C.X86_INS_VPUNPCKLDQ
	X86_INS_VPUNPCKLQDQ      = C.X86_INS_VPUNPCKLQDQ
	X86_INS_VPUNPCKLWD       = C.X86_INS_VPUNPCKLWD
	X86_INS_VPXORD           = C.X86_INS_VPXORD
	X86_INS_VPXORQ           = C.X86_INS_VPXORQ
	X86_INS_VPXOR            = C.X86_INS_VPXOR
	X86_INS_VRCP14PD         = C.X86_INS_VRCP14PD
	X86_INS_VRCP14PS         = C.X86_INS_VRCP14PS
	X86_INS_VRCP14SD         = C.X86_INS_VRCP14SD
	X86_INS_VRCP14SS         = C.X86_INS_VRCP14SS
	X86_INS_VRCP28PD         = C.X86_INS_VRCP28PD
	X86_INS_VRCP28PS         = C.X86_INS_VRCP28PS
	X86_INS_VRCP28SD         = C.X86_INS_VRCP28SD
	X86_INS_VRCP28SS         = C.X86_INS_VRCP28SS
	X86_INS_VRCPPS           = C.X86_INS_VRCPPS
	X86_INS_VRCPSS           = C.X86_INS_VRCPSS
	X86_INS_VRNDSCALEPD      = C.X86_INS_VRNDSCALEPD
	X86_INS_VRNDSCALEPS      = C.X86_INS_VRNDSCALEPS
	X86_INS_VRNDSCALESD      = C.X86_INS_VRNDSCALESD
	X86_INS_VRNDSCALESS      = C.X86_INS_VRNDSCALESS
	X86_INS_VROUNDPD         = C.X86_INS_VROUNDPD
	X86_INS_VROUNDPS         = C.X86_INS_VROUNDPS
	X86_INS_VROUNDSD         = C.X86_INS_VROUNDSD
	X86_INS_VROUNDSS         = C.X86_INS_VROUNDSS
	X86_INS_VRSQRT14PD       = C.X86_INS_VRSQRT14PD
	X86_INS_VRSQRT14PS       = C.X86_INS_VRSQRT14PS
	X86_INS_VRSQRT14SD       = C.X86_INS_VRSQRT14SD
	X86_INS_VRSQRT14SS       = C.X86_INS_VRSQRT14SS
	X86_INS_VRSQRT28PD       = C.X86_INS_VRSQRT28PD
	X86_INS_VRSQRT28PS       = C.X86_INS_VRSQRT28PS
	X86_INS_VRSQRT28SD       = C.X86_INS_VRSQRT28SD
	X86_INS_VRSQRT28SS       = C.X86_INS_VRSQRT28SS
	X86_INS_VRSQRTPS         = C.X86_INS_VRSQRTPS
	X86_INS_VRSQRTSS         = C.X86_INS_VRSQRTSS
	X86_INS_VSCATTERDPD      = C.X86_INS_VSCATTERDPD
	X86_INS_VSCATTERDPS      = C.X86_INS_VSCATTERDPS
	X86_INS_VSCATTERPF0DPD   = C.X86_INS_VSCATTERPF0DPD
	X86_INS_VSCATTERPF0DPS   = C.X86_INS_VSCATTERPF0DPS
	X86_INS_VSCATTERPF0QPD   = C.X86_INS_VSCATTERPF0QPD
	X86_INS_VSCATTERPF0QPS   = C.X86_INS_VSCATTERPF0QPS
	X86_INS_VSCATTERPF1DPD   = C.X86_INS_VSCATTERPF1DPD
	X86_INS_VSCATTERPF1DPS   = C.X86_INS_VSCATTERPF1DPS
	X86_INS_VSCATTERPF1QPD   = C.X86_INS_VSCATTERPF1QPD
	X86_INS_VSCATTERPF1QPS   = C.X86_INS_VSCATTERPF1QPS
	X86_INS_VSCATTERQPD      = C.X86_INS_VSCATTERQPD
	X86_INS_VSCATTERQPS      = C.X86_INS_VSCATTERQPS
	X86_INS_VSHUFPD          = C.X86_INS_VSHUFPD
	X86_INS_VSHUFPS          = C.X86_INS_VSHUFPS
	X86_INS_VSQRTPD          = C.X86_INS_VSQRTPD
	X86_INS_VSQRTPS          = C.X86_INS_VSQRTPS
	X86_INS_VSQRTSD          = C.X86_INS_VSQRTSD
	X86_INS_VSQRTSS          = C.X86_INS_VSQRTSS
	X86_INS_VSTMXCSR         = C.X86_INS_VSTMXCSR
	X86_INS_VSUBPD           = C.X86_INS_VSUBPD
	X86_INS_VSUBPS           = C.X86_INS_VSUBPS
	X86_INS_VSUBSD           = C.X86_INS_VSUBSD
	X86_INS_VSUBSS           = C.X86_INS_VSUBSS
	X86_INS_VTESTPD          = C.X86_INS_VTESTPD
	X86_INS_VTESTPS          = C.X86_INS_VTESTPS
	X86_INS_VUNPCKHPD        = C.X86_INS_VUNPCKHPD
	X86_INS_VUNPCKHPS        = C.X86_INS_VUNPCKHPS
	X86_INS_VUNPCKLPD        = C.X86_INS_VUNPCKLPD
	X86_INS_VUNPCKLPS        = C.X86_INS_VUNPCKLPS
	X86_INS_VZEROALL         = C.X86_INS_VZEROALL
	X86_INS_VZEROUPPER       = C.X86_INS_VZEROUPPER
	X86_INS_WAIT             = C.X86_INS_WAIT
	X86_INS_WBINVD           = C.X86_INS_WBINVD
	X86_INS_WRFSBASE         = C.X86_INS_WRFSBASE
	X86_INS_WRGSBASE         = C.X86_INS_WRGSBASE
	X86_INS_WRMSR            = C.X86_INS_WRMSR
	X86_INS_XABORT           = C.X86_INS_XABORT
	X86_INS_XACQUIRE         = C.X86_INS_XACQUIRE
	X86_INS_XBEGIN           = C.X86_INS_XBEGIN
	X86_INS_XCHG             = C.X86_INS_XCHG
	X86_INS_XCRYPTCBC        = C.X86_INS_XCRYPTCBC
	X86_INS_XCRYPTCFB        = C.X86_INS_XCRYPTCFB
	X86_INS_XCRYPTCTR        = C.X86_INS_XCRYPTCTR
	X86_INS_XCRYPTECB        = C.X86_INS_XCRYPTECB
	X86_INS_XCRYPTOFB        = C.X86_INS_XCRYPTOFB
	X86_INS_XEND             = C.X86_INS_XEND
	X86_INS_XGETBV           = C.X86_INS_XGETBV
	X86_INS_XLATB            = C.X86_INS_XLATB
	X86_INS_XRELEASE         = C.X86_INS_XRELEASE
	X86_INS_XRSTOR           = C.X86_INS_XRSTOR
	X86_INS_XRSTOR64         = C.X86_INS_XRSTOR64
	X86_INS_XRSTORS          = C.X86_INS_XRSTORS
	X86_INS_XRSTORS64        = C.X86_INS_XRSTORS64
	X86_INS_XSAVE            = C.X86_INS_XSAVE
	X86_INS_XSAVE64          = C.X86_INS_XSAVE64
	X86_INS_XSAVEC           = C.X86_INS_XSAVEC
	X86_INS_XSAVEC64         = C.X86_INS_XSAVEC64
	X86_INS_XSAVEOPT         = C.X86_INS_XSAVEOPT
	X86_INS_XSAVEOPT64       = C.X86_INS_XSAVEOPT64
	X86_INS_XSAVES           = C.X86_INS_XSAVES
	X86_INS_XSAVES64         = C.X86_INS_XSAVES64
	X86_INS_XSETBV           = C.X86_INS_XSETBV
	X86_INS_XSHA1            = C.X86_INS_XSHA1
	X86_INS_XSHA256          = C.X86_INS_XSHA256
	X86_INS_XSTORE           = C.X86_INS_XSTORE
	X86_INS_XTEST            = C.X86_INS_XTEST
	X86_INS_FDISI8087_NOP    = C.X86_INS_FDISI8087_NOP
	X86_INS_FENI8087_NOP     = C.X86_INS_FENI8087_NOP
	X86_INS_CMPSS            = C.X86_INS_CMPSS
	X86_INS_CMPEQSS          = C.X86_INS_CMPEQSS
	X86_INS_CMPLTSS          = C.X86_INS_CMPLTSS
	X86_INS_CMPLESS          = C.X86_INS_CMPLESS
	X86_INS_CMPUNORDSS       = C.X86_INS_CMPUNORDSS
	X86_INS_CMPNEQSS         = C.X86_INS_CMPNEQSS
	X86_INS_CMPNLTSS         = C.X86_INS_CMPNLTSS
	X86_INS_CMPNLESS         = C.X86_INS_CMPNLESS
	X86_INS_CMPORDSS         = C.X86_INS_CMPORDSS
	X86_INS_CMPSD            = C.X86_INS_CMPSD
	X86_INS_CMPEQSD          = C.X86_INS_CMPEQSD
	X86_INS_CMPLTSD          = C.X86_INS_CMPLTSD
	X86_INS_CMPLESD          = C.X86_INS_CMPLESD
	X86_INS_CMPUNORDSD       = C.X86_INS_CMPUNORDSD
	X86_INS_CMPNEQSD         = C.X86_INS_CMPNEQSD
	X86_INS_CMPNLTSD         = C.X86_INS_CMPNLTSD
	X86_INS_CMPNLESD         = C.X86_INS_CMPNLESD
	X86_INS_CMPORDSD         = C.X86_INS_CMPORDSD
	X86_INS_CMPPS            = C.X86_INS_CMPPS
	X86_INS_CMPEQPS          = C.X86_INS_CMPEQPS
	X86_INS_CMPLTPS          = C.X86_INS_CMPLTPS
	X86_INS_CMPLEPS          = C.X86_INS_CMPLEPS
	X86_INS_CMPUNORDPS       = C.X86_INS_CMPUNORDPS
	X86_INS_CMPNEQPS         = C.X86_INS_CMPNEQPS
	X86_INS_CMPNLTPS         = C.X86_INS_CMPNLTPS
	X86_INS_CMPNLEPS         = C.X86_INS_CMPNLEPS
	X86_INS_CMPORDPS         = C.X86_INS_CMPORDPS
	X86_INS_CMPPD            = C.X86_INS_CMPPD
	X86_INS_CMPEQPD          = C.X86_INS_CMPEQPD
	X86_INS_CMPLTPD          = C.X86_INS_CMPLTPD
	X86_INS_CMPLEPD          = C.X86_INS_CMPLEPD
	X86_INS_CMPUNORDPD       = C.X86_INS_CMPUNORDPD
	X86_INS_CMPNEQPD         = C.X86_INS_CMPNEQPD
	X86_INS_CMPNLTPD         = C.X86_INS_CMPNLTPD
	X86_INS_CMPNLEPD         = C.X86_INS_CMPNLEPD
	X86_INS_CMPORDPD         = C.X86_INS_CMPORDPD
	X86_INS_VCMPSS           = C.X86_INS_VCMPSS
	X86_INS_VCMPEQSS         = C.X86_INS_VCMPEQSS
	X86_INS_VCMPLTSS         = C.X86_INS_VCMPLTSS
	X86_INS_VCMPLESS         = C.X86_INS_VCMPLESS
	X86_INS_VCMPUNORDSS      = C.X86_INS_VCMPUNORDSS
	X86_INS_VCMPNEQSS        = C.X86_INS_VCMPNEQSS
	X86_INS_VCMPNLTSS        = C.X86_INS_VCMPNLTSS
	X86_INS_VCMPNLESS        = C.X86_INS_VCMPNLESS
	X86_INS_VCMPORDSS        = C.X86_INS_VCMPORDSS
	X86_INS_VCMPEQ_UQSS      = C.X86_INS_VCMPEQ_UQSS
	X86_INS_VCMPNGESS        = C.X86_INS_VCMPNGESS
	X86_INS_VCMPNGTSS        = C.X86_INS_VCMPNGTSS
	X86_INS_VCMPFALSESS      = C.X86_INS_VCMPFALSESS
	X86_INS_VCMPNEQ_OQSS     = C.X86_INS_VCMPNEQ_OQSS
	X86_INS_VCMPGESS         = C.X86_INS_VCMPGESS
	X86_INS_VCMPGTSS         = C.X86_INS_VCMPGTSS
	X86_INS_VCMPTRUESS       = C.X86_INS_VCMPTRUESS
	X86_INS_VCMPEQ_OSSS      = C.X86_INS_VCMPEQ_OSSS
	X86_INS_VCMPLT_OQSS      = C.X86_INS_VCMPLT_OQSS
	X86_INS_VCMPLE_OQSS      = C.X86_INS_VCMPLE_OQSS
	X86_INS_VCMPUNORD_SSS    = C.X86_INS_VCMPUNORD_SSS
	X86_INS_VCMPNEQ_USSS     = C.X86_INS_VCMPNEQ_USSS
	X86_INS_VCMPNLT_UQSS     = C.X86_INS_VCMPNLT_UQSS
	X86_INS_VCMPNLE_UQSS     = C.X86_INS_VCMPNLE_UQSS
	X86_INS_VCMPORD_SSS      = C.X86_INS_VCMPORD_SSS
	X86_INS_VCMPEQ_USSS      = C.X86_INS_VCMPEQ_USSS
	X86_INS_VCMPNGE_UQSS     = C.X86_INS_VCMPNGE_UQSS
	X86_INS_VCMPNGT_UQSS     = C.X86_INS_VCMPNGT_UQSS
	X86_INS_VCMPFALSE_OSSS   = C.X86_INS_VCMPFALSE_OSSS
	X86_INS_VCMPNEQ_OSSS     = C.X86_INS_VCMPNEQ_OSSS
	X86_INS_VCMPGE_OQSS      = C.X86_INS_VCMPGE_OQSS
	X86_INS_VCMPGT_OQSS      = C.X86_INS_VCMPGT_OQSS
	X86_INS_VCMPTRUE_USSS    = C.X86_INS_VCMPTRUE_USSS
	X86_INS_VCMPSD           = C.X86_INS_VCMPSD
	X86_INS_VCMPEQSD         = C.X86_INS_VCMPEQSD
	X86_INS_VCMPLTSD         = C.X86_INS_VCMPLTSD
	X86_INS_VCMPLESD         = C.X86_INS_VCMPLESD
	X86_INS_VCMPUNORDSD      = C.X86_INS_VCMPUNORDSD
	X86_INS_VCMPNEQSD        = C.X86_INS_VCMPNEQSD
	X86_INS_VCMPNLTSD        = C.X86_INS_VCMPNLTSD
	X86_INS_VCMPNLESD        = C.X86_INS_VCMPNLESD
	X86_INS_VCMPORDSD        = C.X86_INS_VCMPORDSD
	X86_INS_VCMPEQ_UQSD      = C.X86_INS_VCMPEQ_UQSD
	X86_INS_VCMPNGESD        = C.X86_INS_VCMPNGESD
	X86_INS_VCMPNGTSD        = C.X86_INS_VCMPNGTSD
	X86_INS_VCMPFALSESD      = C.X86_INS_VCMPFALSESD
	X86_INS_VCMPNEQ_OQSD     = C.X86_INS_VCMPNEQ_OQSD
	X86_INS_VCMPGESD         = C.X86_INS_VCMPGESD
	X86_INS_VCMPGTSD         = C.X86_INS_VCMPGTSD
	X86_INS_VCMPTRUESD       = C.X86_INS_VCMPTRUESD
	X86_INS_VCMPEQ_OSSD      = C.X86_INS_VCMPEQ_OSSD
	X86_INS_VCMPLT_OQSD      = C.X86_INS_VCMPLT_OQSD
	X86_INS_VCMPLE_OQSD      = C.X86_INS_VCMPLE_OQSD
	X86_INS_VCMPUNORD_SSD    = C.X86_INS_VCMPUNORD_SSD
	X86_INS_VCMPNEQ_USSD     = C.X86_INS_VCMPNEQ_USSD
	X86_INS_VCMPNLT_UQSD     = C.X86_INS_VCMPNLT_UQSD
	X86_INS_VCMPNLE_UQSD     = C.X86_INS_VCMPNLE_UQSD
	X86_INS_VCMPORD_SSD      = C.X86_INS_VCMPORD_SSD
	X86_INS_VCMPEQ_USSD      = C.X86_INS_VCMPEQ_USSD
	X86_INS_VCMPNGE_UQSD     = C.X86_INS_VCMPNGE_UQSD
	X86_INS_VCMPNGT_UQSD     = C.X86_INS_VCMPNGT_UQSD
	X86_INS_VCMPFALSE_OSSD   = C.X86_INS_VCMPFALSE_OSSD
	X86_INS_VCMPNEQ_OSSD     = C.X86_INS_VCMPNEQ_OSSD
	X86_INS_VCMPGE_OQSD      = C.X86_INS_VCMPGE_OQSD
	X86_INS_VCMPGT_OQSD      = C.X86_INS_VCMPGT_OQSD
	X86_INS_VCMPTRUE_USSD    = C.X86_INS_VCMPTRUE_USSD
	X86_INS_VCMPPS           = C.X86_INS_VCMPPS
	X86_INS_VCMPEQPS         = C.X86_INS_VCMPEQPS
	X86_INS_VCMPLTPS         = C.X86_INS_VCMPLTPS
	X86_INS_VCMPLEPS         = C.X86_INS_VCMPLEPS
	X86_INS_VCMPUNORDPS      = C.X86_INS_VCMPUNORDPS
	X86_INS_VCMPNEQPS        = C.X86_INS_VCMPNEQPS
	X86_INS_VCMPNLTPS        = C.X86_INS_VCMPNLTPS
	X86_INS_VCMPNLEPS        = C.X86_INS_VCMPNLEPS
	X86_INS_VCMPORDPS        = C.X86_INS_VCMPORDPS
	X86_INS_VCMPEQ_UQPS      = C.X86_INS_VCMPEQ_UQPS
	X86_INS_VCMPNGEPS        = C.X86_INS_VCMPNGEPS
	X86_INS_VCMPNGTPS        = C.X86_INS_VCMPNGTPS
	X86_INS_VCMPFALSEPS      = C.X86_INS_VCMPFALSEPS
	X86_INS_VCMPNEQ_OQPS     = C.X86_INS_VCMPNEQ_OQPS
	X86_INS_VCMPGEPS         = C.X86_INS_VCMPGEPS
	X86_INS_VCMPGTPS         = C.X86_INS_VCMPGTPS
	X86_INS_VCMPTRUEPS       = C.X86_INS_VCMPTRUEPS
	X86_INS_VCMPEQ_OSPS      = C.X86_INS_VCMPEQ_OSPS
	X86_INS_VCMPLT_OQPS      = C.X86_INS_VCMPLT_OQPS
	X86_INS_VCMPLE_OQPS      = C.X86_INS_VCMPLE_OQPS
	X86_INS_VCMPUNORD_SPS    = C.X86_INS_VCMPUNORD_SPS
	X86_INS_VCMPNEQ_USPS     = C.X86_INS_VCMPNEQ_USPS
	X86_INS_VCMPNLT_UQPS     = C.X86_INS_VCMPNLT_UQPS
	X86_INS_VCMPNLE_UQPS     = C.X86_INS_VCMPNLE_UQPS
	X86_INS_VCMPORD_SPS      = C.X86_INS_VCMPORD_SPS
	X86_INS_VCMPEQ_USPS      = C.X86_INS_VCMPEQ_USPS
	X86_INS_VCMPNGE_UQPS     = C.X86_INS_VCMPNGE_UQPS
	X86_INS_VCMPNGT_UQPS     = C.X86_INS_VCMPNGT_UQPS
	X86_INS_VCMPFALSE_OSPS   = C.X86_INS_VCMPFALSE_OSPS
	X86_INS_VCMPNEQ_OSPS     = C.X86_INS_VCMPNEQ_OSPS
	X86_INS_VCMPGE_OQPS      = C.X86_INS_VCMPGE_OQPS
	X86_INS_VCMPGT_OQPS      = C.X86_INS_VCMPGT_OQPS
	X86_INS_VCMPTRUE_USPS    = C.X86_INS_VCMPTRUE_USPS
	X86_INS_VCMPPD           = C.X86_INS_VCMPPD
	X86_INS_VCMPEQPD         = C.X86_INS_VCMPEQPD
	X86_INS_VCMPLTPD         = C.X86_INS_VCMPLTPD
	X86_INS_VCMPLEPD         = C.X86_INS_VCMPLEPD
	X86_INS_VCMPUNORDPD      = C.X86_INS_VCMPUNORDPD
	X86_INS_VCMPNEQPD        = C.X86_INS_VCMPNEQPD
	X86_INS_VCMPNLTPD        = C.X86_INS_VCMPNLTPD
	X86_INS_VCMPNLEPD        = C.X86_INS_VCMPNLEPD
	X86_INS_VCMPORDPD        = C.X86_INS_VCMPORDPD
	X86_INS_VCMPEQ_UQPD      = C.X86_INS_VCMPEQ_UQPD
	X86_INS_VCMPNGEPD        = C.X86_INS_VCMPNGEPD
	X86_INS_VCMPNGTPD        = C.X86_INS_VCMPNGTPD
	X86_INS_VCMPFALSEPD      = C.X86_INS_VCMPFALSEPD
	X86_INS_VCMPNEQ_OQPD     = C.X86_INS_VCMPNEQ_OQPD
	X86_INS_VCMPGEPD         = C.X86_INS_VCMPGEPD
	X86_INS_VCMPGTPD         = C.X86_INS_VCMPGTPD
	X86_INS_VCMPTRUEPD       = C.X86_INS_VCMPTRUEPD
	X86_INS_VCMPEQ_OSPD      = C.X86_INS_VCMPEQ_OSPD
	X86_INS_VCMPLT_OQPD      = C.X86_INS_VCMPLT_OQPD
	X86_INS_VCMPLE_OQPD      = C.X86_INS_VCMPLE_OQPD
	X86_INS_VCMPUNORD_SPD    = C.X86_INS_VCMPUNORD_SPD
	X86_INS_VCMPNEQ_USPD     = C.X86_INS_VCMPNEQ_USPD
	X86_INS_VCMPNLT_UQPD     = C.X86_INS_VCMPNLT_UQPD
	X86_INS_VCMPNLE_UQPD     = C.X86_INS_VCMPNLE_UQPD
	X86_INS_VCMPORD_SPD      = C.X86_INS_VCMPORD_SPD
	X86_INS_VCMPEQ_USPD      = C.X86_INS_VCMPEQ_USPD
	X86_INS_VCMPNGE_UQPD     = C.X86_INS_VCMPNGE_UQPD
	X86_INS_VCMPNGT_UQPD     = C.X86_INS_VCMPNGT_UQPD
	X86_INS_VCMPFALSE_OSPD   = C.X86_INS_VCMPFALSE_OSPD
	X86_INS_VCMPNEQ_OSPD     = C.X86_INS_VCMPNEQ_OSPD
	X86_INS_VCMPGE_OQPD      = C.X86_INS_VCMPGE_OQPD
	X86_INS_VCMPGT_OQPD      = C.X86_INS_VCMPGT_OQPD
	X86_INS_VCMPTRUE_USPD    = C.X86_INS_VCMPTRUE_USPD
	X86_INS_UD0              = C.X86_INS_UD0
	X86_INS_ENDBR32          = C.X86_INS_ENDBR32
	X86_INS_ENDBR64          = C.X86_INS_ENDBR64
	X86_INS_ENDING           = C.X86_INS_ENDING
)

// Group of X86 instructions
const (
	X86_GRP_INVALID = C.X86_GRP_INVALID
)

// Generic groups
const (
	X86_GRP_JUMP            = C.X86_GRP_JUMP
	X86_GRP_CALL            = C.X86_GRP_CALL
	X86_GRP_RET             = C.X86_GRP_RET
	X86_GRP_INT             = C.X86_GRP_INT
	X86_GRP_IRET            = C.X86_GRP_IRET
	X86_GRP_PRIVILEGE       = C.X86_GRP_PRIVILEGE
	X86_GRP_BRANCH_RELATIVE = C.X86_GRP_BRANCH_RELATIVE
)

// Architecture-specific groups
const (
	X86_GRP_VM           = C.X86_GRP_VM
	X86_GRP_3DNOW        = C.X86_GRP_3DNOW
	X86_GRP_AES          = C.X86_GRP_AES
	X86_GRP_ADX          = C.X86_GRP_ADX
	X86_GRP_AVX          = C.X86_GRP_AVX
	X86_GRP_AVX2         = C.X86_GRP_AVX2
	X86_GRP_AVX512       = C.X86_GRP_AVX512
	X86_GRP_BMI          = C.X86_GRP_BMI
	X86_GRP_BMI2         = C.X86_GRP_BMI2
	X86_GRP_CMOV         = C.X86_GRP_CMOV
	X86_GRP_F16C         = C.X86_GRP_F16C
	X86_GRP_FMA          = C.X86_GRP_FMA
	X86_GRP_FMA4         = C.X86_GRP_FMA4
	X86_GRP_FSGSBASE     = C.X86_GRP_FSGSBASE
	X86_GRP_HLE          = C.X86_GRP_HLE
	X86_GRP_MMX          = C.X86_GRP_MMX
	X86_GRP_MODE32       = C.X86_GRP_MODE32
	X86_GRP_MODE64       = C.X86_GRP_MODE64
	X86_GRP_RTM          = C.X86_GRP_RTM
	X86_GRP_SHA          = C.X86_GRP_SHA
	X86_GRP_SSE1         = C.X86_GRP_SSE1
	X86_GRP_SSE2         = C.X86_GRP_SSE2
	X86_GRP_SSE3         = C.X86_GRP_SSE3
	X86_GRP_SSE41        = C.X86_GRP_SSE41
	X86_GRP_SSE42        = C.X86_GRP_SSE42
	X86_GRP_SSE4A        = C.X86_GRP_SSE4A
	X86_GRP_SSSE3        = C.X86_GRP_SSSE3
	X86_GRP_PCLMUL       = C.X86_GRP_PCLMUL
	X86_GRP_XOP          = C.X86_GRP_XOP
	X86_GRP_CDI          = C.X86_GRP_CDI
	X86_GRP_ERI          = C.X86_GRP_ERI
	X86_GRP_TBM          = C.X86_GRP_TBM
	X86_GRP_16BITMODE    = C.X86_GRP_16BITMODE
	X86_GRP_NOT64BITMODE = C.X86_GRP_NOT64BITMODE
	X86_GRP_SGX          = C.X86_GRP_SGX
	X86_GRP_DQI          = C.X86_GRP_DQI
	X86_GRP_BWI          = C.X86_GRP_BWI
	X86_GRP_PFI          = C.X86_GRP_PFI
	X86_GRP_VLX          = C.X86_GRP_VLX
	X86_GRP_SMAP         = C.X86_GRP_SMAP
	X86_GRP_NOVLX        = C.X86_GRP_NOVLX
	X86_GRP_FPU          = C.X86_GRP_FPU
	X86_GRP_ENDING       = C.X86_GRP_ENDING
)
