/*
Gapstone is a Go binding for the Capstone disassembly library. For examples,
try reading the *_test.go files.

	Library Author: Nguyen Anh Quynh
	Binding Author: Ben Nagy
	License: BSD style - see LICENSE file for details
    (c) 2013 COSEINC. All Rights Reserved.

    THIS FILE WAS AUTO-GENERATED -- DO NOT EDIT!
	Command: ./genconst /Users/scottknight/work/capstone/bindings/python/capstone/
	2019-02-02T13:26:27-05:00

*/

package gapstone

// #cgo LDFLAGS: -lcapstone
// #cgo freebsd CFLAGS: -I/usr/local/include
// #cgo freebsd LDFLAGS: -L/usr/local/lib
// #include <stdlib.h>
// #include <capstone/capstone.h>
import "C"

// For Capstone Engine. AUTO-GENERATED FILE, DO NOT EDIT [ppc_const.py]
// PPC branch codes for some branch instructions
const (
	PPC_BC_INVALID = C.PPC_BC_INVALID
	PPC_BC_LT      = C.PPC_BC_LT
	PPC_BC_LE      = C.PPC_BC_LE
	PPC_BC_EQ      = C.PPC_BC_EQ
	PPC_BC_GE      = C.PPC_BC_GE
	PPC_BC_GT      = C.PPC_BC_GT
	PPC_BC_NE      = C.PPC_BC_NE
	PPC_BC_UN      = C.PPC_BC_UN
	PPC_BC_NU      = C.PPC_BC_NU
	PPC_BC_SO      = C.PPC_BC_SO
	PPC_BC_NS      = C.PPC_BC_NS
)

// PPC branch hint for some branch instructions
const (
	PPC_BH_INVALID = C.PPC_BH_INVALID
	PPC_BH_PLUS    = C.PPC_BH_PLUS
	PPC_BH_MINUS   = C.PPC_BH_MINUS
)

// Operand type for instruction's operands
const (
	PPC_OP_INVALID = C.PPC_OP_INVALID
	PPC_OP_REG     = C.PPC_OP_REG
	PPC_OP_IMM     = C.PPC_OP_IMM
	PPC_OP_MEM     = C.PPC_OP_MEM
	PPC_OP_CRX     = C.PPC_OP_CRX
)

// PPC registers
const (
	PPC_REG_INVALID = C.PPC_REG_INVALID
	PPC_REG_CARRY   = C.PPC_REG_CARRY
	PPC_REG_CR0     = C.PPC_REG_CR0
	PPC_REG_CR1     = C.PPC_REG_CR1
	PPC_REG_CR2     = C.PPC_REG_CR2
	PPC_REG_CR3     = C.PPC_REG_CR3
	PPC_REG_CR4     = C.PPC_REG_CR4
	PPC_REG_CR5     = C.PPC_REG_CR5
	PPC_REG_CR6     = C.PPC_REG_CR6
	PPC_REG_CR7     = C.PPC_REG_CR7
	PPC_REG_CTR     = C.PPC_REG_CTR
	PPC_REG_F0      = C.PPC_REG_F0
	PPC_REG_F1      = C.PPC_REG_F1
	PPC_REG_F2      = C.PPC_REG_F2
	PPC_REG_F3      = C.PPC_REG_F3
	PPC_REG_F4      = C.PPC_REG_F4
	PPC_REG_F5      = C.PPC_REG_F5
	PPC_REG_F6      = C.PPC_REG_F6
	PPC_REG_F7      = C.PPC_REG_F7
	PPC_REG_F8      = C.PPC_REG_F8
	PPC_REG_F9      = C.PPC_REG_F9
	PPC_REG_F10     = C.PPC_REG_F10
	PPC_REG_F11     = C.PPC_REG_F11
	PPC_REG_F12     = C.PPC_REG_F12
	PPC_REG_F13     = C.PPC_REG_F13
	PPC_REG_F14     = C.PPC_REG_F14
	PPC_REG_F15     = C.PPC_REG_F15
	PPC_REG_F16     = C.PPC_REG_F16
	PPC_REG_F17     = C.PPC_REG_F17
	PPC_REG_F18     = C.PPC_REG_F18
	PPC_REG_F19     = C.PPC_REG_F19
	PPC_REG_F20     = C.PPC_REG_F20
	PPC_REG_F21     = C.PPC_REG_F21
	PPC_REG_F22     = C.PPC_REG_F22
	PPC_REG_F23     = C.PPC_REG_F23
	PPC_REG_F24     = C.PPC_REG_F24
	PPC_REG_F25     = C.PPC_REG_F25
	PPC_REG_F26     = C.PPC_REG_F26
	PPC_REG_F27     = C.PPC_REG_F27
	PPC_REG_F28     = C.PPC_REG_F28
	PPC_REG_F29     = C.PPC_REG_F29
	PPC_REG_F30     = C.PPC_REG_F30
	PPC_REG_F31     = C.PPC_REG_F31
	PPC_REG_LR      = C.PPC_REG_LR
	PPC_REG_R0      = C.PPC_REG_R0
	PPC_REG_R1      = C.PPC_REG_R1
	PPC_REG_R2      = C.PPC_REG_R2
	PPC_REG_R3      = C.PPC_REG_R3
	PPC_REG_R4      = C.PPC_REG_R4
	PPC_REG_R5      = C.PPC_REG_R5
	PPC_REG_R6      = C.PPC_REG_R6
	PPC_REG_R7      = C.PPC_REG_R7
	PPC_REG_R8      = C.PPC_REG_R8
	PPC_REG_R9      = C.PPC_REG_R9
	PPC_REG_R10     = C.PPC_REG_R10
	PPC_REG_R11     = C.PPC_REG_R11
	PPC_REG_R12     = C.PPC_REG_R12
	PPC_REG_R13     = C.PPC_REG_R13
	PPC_REG_R14     = C.PPC_REG_R14
	PPC_REG_R15     = C.PPC_REG_R15
	PPC_REG_R16     = C.PPC_REG_R16
	PPC_REG_R17     = C.PPC_REG_R17
	PPC_REG_R18     = C.PPC_REG_R18
	PPC_REG_R19     = C.PPC_REG_R19
	PPC_REG_R20     = C.PPC_REG_R20
	PPC_REG_R21     = C.PPC_REG_R21
	PPC_REG_R22     = C.PPC_REG_R22
	PPC_REG_R23     = C.PPC_REG_R23
	PPC_REG_R24     = C.PPC_REG_R24
	PPC_REG_R25     = C.PPC_REG_R25
	PPC_REG_R26     = C.PPC_REG_R26
	PPC_REG_R27     = C.PPC_REG_R27
	PPC_REG_R28     = C.PPC_REG_R28
	PPC_REG_R29     = C.PPC_REG_R29
	PPC_REG_R30     = C.PPC_REG_R30
	PPC_REG_R31     = C.PPC_REG_R31
	PPC_REG_V0      = C.PPC_REG_V0
	PPC_REG_V1      = C.PPC_REG_V1
	PPC_REG_V2      = C.PPC_REG_V2
	PPC_REG_V3      = C.PPC_REG_V3
	PPC_REG_V4      = C.PPC_REG_V4
	PPC_REG_V5      = C.PPC_REG_V5
	PPC_REG_V6      = C.PPC_REG_V6
	PPC_REG_V7      = C.PPC_REG_V7
	PPC_REG_V8      = C.PPC_REG_V8
	PPC_REG_V9      = C.PPC_REG_V9
	PPC_REG_V10     = C.PPC_REG_V10
	PPC_REG_V11     = C.PPC_REG_V11
	PPC_REG_V12     = C.PPC_REG_V12
	PPC_REG_V13     = C.PPC_REG_V13
	PPC_REG_V14     = C.PPC_REG_V14
	PPC_REG_V15     = C.PPC_REG_V15
	PPC_REG_V16     = C.PPC_REG_V16
	PPC_REG_V17     = C.PPC_REG_V17
	PPC_REG_V18     = C.PPC_REG_V18
	PPC_REG_V19     = C.PPC_REG_V19
	PPC_REG_V20     = C.PPC_REG_V20
	PPC_REG_V21     = C.PPC_REG_V21
	PPC_REG_V22     = C.PPC_REG_V22
	PPC_REG_V23     = C.PPC_REG_V23
	PPC_REG_V24     = C.PPC_REG_V24
	PPC_REG_V25     = C.PPC_REG_V25
	PPC_REG_V26     = C.PPC_REG_V26
	PPC_REG_V27     = C.PPC_REG_V27
	PPC_REG_V28     = C.PPC_REG_V28
	PPC_REG_V29     = C.PPC_REG_V29
	PPC_REG_V30     = C.PPC_REG_V30
	PPC_REG_V31     = C.PPC_REG_V31
	PPC_REG_VRSAVE  = C.PPC_REG_VRSAVE
	PPC_REG_VS0     = C.PPC_REG_VS0
	PPC_REG_VS1     = C.PPC_REG_VS1
	PPC_REG_VS2     = C.PPC_REG_VS2
	PPC_REG_VS3     = C.PPC_REG_VS3
	PPC_REG_VS4     = C.PPC_REG_VS4
	PPC_REG_VS5     = C.PPC_REG_VS5
	PPC_REG_VS6     = C.PPC_REG_VS6
	PPC_REG_VS7     = C.PPC_REG_VS7
	PPC_REG_VS8     = C.PPC_REG_VS8
	PPC_REG_VS9     = C.PPC_REG_VS9
	PPC_REG_VS10    = C.PPC_REG_VS10
	PPC_REG_VS11    = C.PPC_REG_VS11
	PPC_REG_VS12    = C.PPC_REG_VS12
	PPC_REG_VS13    = C.PPC_REG_VS13
	PPC_REG_VS14    = C.PPC_REG_VS14
	PPC_REG_VS15    = C.PPC_REG_VS15
	PPC_REG_VS16    = C.PPC_REG_VS16
	PPC_REG_VS17    = C.PPC_REG_VS17
	PPC_REG_VS18    = C.PPC_REG_VS18
	PPC_REG_VS19    = C.PPC_REG_VS19
	PPC_REG_VS20    = C.PPC_REG_VS20
	PPC_REG_VS21    = C.PPC_REG_VS21
	PPC_REG_VS22    = C.PPC_REG_VS22
	PPC_REG_VS23    = C.PPC_REG_VS23
	PPC_REG_VS24    = C.PPC_REG_VS24
	PPC_REG_VS25    = C.PPC_REG_VS25
	PPC_REG_VS26    = C.PPC_REG_VS26
	PPC_REG_VS27    = C.PPC_REG_VS27
	PPC_REG_VS28    = C.PPC_REG_VS28
	PPC_REG_VS29    = C.PPC_REG_VS29
	PPC_REG_VS30    = C.PPC_REG_VS30
	PPC_REG_VS31    = C.PPC_REG_VS31
	PPC_REG_VS32    = C.PPC_REG_VS32
	PPC_REG_VS33    = C.PPC_REG_VS33
	PPC_REG_VS34    = C.PPC_REG_VS34
	PPC_REG_VS35    = C.PPC_REG_VS35
	PPC_REG_VS36    = C.PPC_REG_VS36
	PPC_REG_VS37    = C.PPC_REG_VS37
	PPC_REG_VS38    = C.PPC_REG_VS38
	PPC_REG_VS39    = C.PPC_REG_VS39
	PPC_REG_VS40    = C.PPC_REG_VS40
	PPC_REG_VS41    = C.PPC_REG_VS41
	PPC_REG_VS42    = C.PPC_REG_VS42
	PPC_REG_VS43    = C.PPC_REG_VS43
	PPC_REG_VS44    = C.PPC_REG_VS44
	PPC_REG_VS45    = C.PPC_REG_VS45
	PPC_REG_VS46    = C.PPC_REG_VS46
	PPC_REG_VS47    = C.PPC_REG_VS47
	PPC_REG_VS48    = C.PPC_REG_VS48
	PPC_REG_VS49    = C.PPC_REG_VS49
	PPC_REG_VS50    = C.PPC_REG_VS50
	PPC_REG_VS51    = C.PPC_REG_VS51
	PPC_REG_VS52    = C.PPC_REG_VS52
	PPC_REG_VS53    = C.PPC_REG_VS53
	PPC_REG_VS54    = C.PPC_REG_VS54
	PPC_REG_VS55    = C.PPC_REG_VS55
	PPC_REG_VS56    = C.PPC_REG_VS56
	PPC_REG_VS57    = C.PPC_REG_VS57
	PPC_REG_VS58    = C.PPC_REG_VS58
	PPC_REG_VS59    = C.PPC_REG_VS59
	PPC_REG_VS60    = C.PPC_REG_VS60
	PPC_REG_VS61    = C.PPC_REG_VS61
	PPC_REG_VS62    = C.PPC_REG_VS62
	PPC_REG_VS63    = C.PPC_REG_VS63
	PPC_REG_Q0      = C.PPC_REG_Q0
	PPC_REG_Q1      = C.PPC_REG_Q1
	PPC_REG_Q2      = C.PPC_REG_Q2
	PPC_REG_Q3      = C.PPC_REG_Q3
	PPC_REG_Q4      = C.PPC_REG_Q4
	PPC_REG_Q5      = C.PPC_REG_Q5
	PPC_REG_Q6      = C.PPC_REG_Q6
	PPC_REG_Q7      = C.PPC_REG_Q7
	PPC_REG_Q8      = C.PPC_REG_Q8
	PPC_REG_Q9      = C.PPC_REG_Q9
	PPC_REG_Q10     = C.PPC_REG_Q10
	PPC_REG_Q11     = C.PPC_REG_Q11
	PPC_REG_Q12     = C.PPC_REG_Q12
	PPC_REG_Q13     = C.PPC_REG_Q13
	PPC_REG_Q14     = C.PPC_REG_Q14
	PPC_REG_Q15     = C.PPC_REG_Q15
	PPC_REG_Q16     = C.PPC_REG_Q16
	PPC_REG_Q17     = C.PPC_REG_Q17
	PPC_REG_Q18     = C.PPC_REG_Q18
	PPC_REG_Q19     = C.PPC_REG_Q19
	PPC_REG_Q20     = C.PPC_REG_Q20
	PPC_REG_Q21     = C.PPC_REG_Q21
	PPC_REG_Q22     = C.PPC_REG_Q22
	PPC_REG_Q23     = C.PPC_REG_Q23
	PPC_REG_Q24     = C.PPC_REG_Q24
	PPC_REG_Q25     = C.PPC_REG_Q25
	PPC_REG_Q26     = C.PPC_REG_Q26
	PPC_REG_Q27     = C.PPC_REG_Q27
	PPC_REG_Q28     = C.PPC_REG_Q28
	PPC_REG_Q29     = C.PPC_REG_Q29
	PPC_REG_Q30     = C.PPC_REG_Q30
	PPC_REG_Q31     = C.PPC_REG_Q31
	PPC_REG_RM      = C.PPC_REG_RM
	PPC_REG_CTR8    = C.PPC_REG_CTR8
	PPC_REG_LR8     = C.PPC_REG_LR8
	PPC_REG_CR1EQ   = C.PPC_REG_CR1EQ
	PPC_REG_X2      = C.PPC_REG_X2
	PPC_REG_ENDING  = C.PPC_REG_ENDING
)

// PPC instruction
const (
	PPC_INS_INVALID       = C.PPC_INS_INVALID
	PPC_INS_ADD           = C.PPC_INS_ADD
	PPC_INS_ADDC          = C.PPC_INS_ADDC
	PPC_INS_ADDE          = C.PPC_INS_ADDE
	PPC_INS_ADDI          = C.PPC_INS_ADDI
	PPC_INS_ADDIC         = C.PPC_INS_ADDIC
	PPC_INS_ADDIS         = C.PPC_INS_ADDIS
	PPC_INS_ADDME         = C.PPC_INS_ADDME
	PPC_INS_ADDZE         = C.PPC_INS_ADDZE
	PPC_INS_AND           = C.PPC_INS_AND
	PPC_INS_ANDC          = C.PPC_INS_ANDC
	PPC_INS_ANDIS         = C.PPC_INS_ANDIS
	PPC_INS_ANDI          = C.PPC_INS_ANDI
	PPC_INS_ATTN          = C.PPC_INS_ATTN
	PPC_INS_B             = C.PPC_INS_B
	PPC_INS_BA            = C.PPC_INS_BA
	PPC_INS_BC            = C.PPC_INS_BC
	PPC_INS_BCCTR         = C.PPC_INS_BCCTR
	PPC_INS_BCCTRL        = C.PPC_INS_BCCTRL
	PPC_INS_BCL           = C.PPC_INS_BCL
	PPC_INS_BCLR          = C.PPC_INS_BCLR
	PPC_INS_BCLRL         = C.PPC_INS_BCLRL
	PPC_INS_BCTR          = C.PPC_INS_BCTR
	PPC_INS_BCTRL         = C.PPC_INS_BCTRL
	PPC_INS_BCT           = C.PPC_INS_BCT
	PPC_INS_BDNZ          = C.PPC_INS_BDNZ
	PPC_INS_BDNZA         = C.PPC_INS_BDNZA
	PPC_INS_BDNZL         = C.PPC_INS_BDNZL
	PPC_INS_BDNZLA        = C.PPC_INS_BDNZLA
	PPC_INS_BDNZLR        = C.PPC_INS_BDNZLR
	PPC_INS_BDNZLRL       = C.PPC_INS_BDNZLRL
	PPC_INS_BDZ           = C.PPC_INS_BDZ
	PPC_INS_BDZA          = C.PPC_INS_BDZA
	PPC_INS_BDZL          = C.PPC_INS_BDZL
	PPC_INS_BDZLA         = C.PPC_INS_BDZLA
	PPC_INS_BDZLR         = C.PPC_INS_BDZLR
	PPC_INS_BDZLRL        = C.PPC_INS_BDZLRL
	PPC_INS_BL            = C.PPC_INS_BL
	PPC_INS_BLA           = C.PPC_INS_BLA
	PPC_INS_BLR           = C.PPC_INS_BLR
	PPC_INS_BLRL          = C.PPC_INS_BLRL
	PPC_INS_BRINC         = C.PPC_INS_BRINC
	PPC_INS_CMPB          = C.PPC_INS_CMPB
	PPC_INS_CMPD          = C.PPC_INS_CMPD
	PPC_INS_CMPDI         = C.PPC_INS_CMPDI
	PPC_INS_CMPLD         = C.PPC_INS_CMPLD
	PPC_INS_CMPLDI        = C.PPC_INS_CMPLDI
	PPC_INS_CMPLW         = C.PPC_INS_CMPLW
	PPC_INS_CMPLWI        = C.PPC_INS_CMPLWI
	PPC_INS_CMPW          = C.PPC_INS_CMPW
	PPC_INS_CMPWI         = C.PPC_INS_CMPWI
	PPC_INS_CNTLZD        = C.PPC_INS_CNTLZD
	PPC_INS_CNTLZW        = C.PPC_INS_CNTLZW
	PPC_INS_CREQV         = C.PPC_INS_CREQV
	PPC_INS_CRXOR         = C.PPC_INS_CRXOR
	PPC_INS_CRAND         = C.PPC_INS_CRAND
	PPC_INS_CRANDC        = C.PPC_INS_CRANDC
	PPC_INS_CRNAND        = C.PPC_INS_CRNAND
	PPC_INS_CRNOR         = C.PPC_INS_CRNOR
	PPC_INS_CROR          = C.PPC_INS_CROR
	PPC_INS_CRORC         = C.PPC_INS_CRORC
	PPC_INS_DCBA          = C.PPC_INS_DCBA
	PPC_INS_DCBF          = C.PPC_INS_DCBF
	PPC_INS_DCBI          = C.PPC_INS_DCBI
	PPC_INS_DCBST         = C.PPC_INS_DCBST
	PPC_INS_DCBT          = C.PPC_INS_DCBT
	PPC_INS_DCBTST        = C.PPC_INS_DCBTST
	PPC_INS_DCBZ          = C.PPC_INS_DCBZ
	PPC_INS_DCBZL         = C.PPC_INS_DCBZL
	PPC_INS_DCCCI         = C.PPC_INS_DCCCI
	PPC_INS_DIVD          = C.PPC_INS_DIVD
	PPC_INS_DIVDU         = C.PPC_INS_DIVDU
	PPC_INS_DIVW          = C.PPC_INS_DIVW
	PPC_INS_DIVWU         = C.PPC_INS_DIVWU
	PPC_INS_DSS           = C.PPC_INS_DSS
	PPC_INS_DSSALL        = C.PPC_INS_DSSALL
	PPC_INS_DST           = C.PPC_INS_DST
	PPC_INS_DSTST         = C.PPC_INS_DSTST
	PPC_INS_DSTSTT        = C.PPC_INS_DSTSTT
	PPC_INS_DSTT          = C.PPC_INS_DSTT
	PPC_INS_EQV           = C.PPC_INS_EQV
	PPC_INS_EVABS         = C.PPC_INS_EVABS
	PPC_INS_EVADDIW       = C.PPC_INS_EVADDIW
	PPC_INS_EVADDSMIAAW   = C.PPC_INS_EVADDSMIAAW
	PPC_INS_EVADDSSIAAW   = C.PPC_INS_EVADDSSIAAW
	PPC_INS_EVADDUMIAAW   = C.PPC_INS_EVADDUMIAAW
	PPC_INS_EVADDUSIAAW   = C.PPC_INS_EVADDUSIAAW
	PPC_INS_EVADDW        = C.PPC_INS_EVADDW
	PPC_INS_EVAND         = C.PPC_INS_EVAND
	PPC_INS_EVANDC        = C.PPC_INS_EVANDC
	PPC_INS_EVCMPEQ       = C.PPC_INS_EVCMPEQ
	PPC_INS_EVCMPGTS      = C.PPC_INS_EVCMPGTS
	PPC_INS_EVCMPGTU      = C.PPC_INS_EVCMPGTU
	PPC_INS_EVCMPLTS      = C.PPC_INS_EVCMPLTS
	PPC_INS_EVCMPLTU      = C.PPC_INS_EVCMPLTU
	PPC_INS_EVCNTLSW      = C.PPC_INS_EVCNTLSW
	PPC_INS_EVCNTLZW      = C.PPC_INS_EVCNTLZW
	PPC_INS_EVDIVWS       = C.PPC_INS_EVDIVWS
	PPC_INS_EVDIVWU       = C.PPC_INS_EVDIVWU
	PPC_INS_EVEQV         = C.PPC_INS_EVEQV
	PPC_INS_EVEXTSB       = C.PPC_INS_EVEXTSB
	PPC_INS_EVEXTSH       = C.PPC_INS_EVEXTSH
	PPC_INS_EVLDD         = C.PPC_INS_EVLDD
	PPC_INS_EVLDDX        = C.PPC_INS_EVLDDX
	PPC_INS_EVLDH         = C.PPC_INS_EVLDH
	PPC_INS_EVLDHX        = C.PPC_INS_EVLDHX
	PPC_INS_EVLDW         = C.PPC_INS_EVLDW
	PPC_INS_EVLDWX        = C.PPC_INS_EVLDWX
	PPC_INS_EVLHHESPLAT   = C.PPC_INS_EVLHHESPLAT
	PPC_INS_EVLHHESPLATX  = C.PPC_INS_EVLHHESPLATX
	PPC_INS_EVLHHOSSPLAT  = C.PPC_INS_EVLHHOSSPLAT
	PPC_INS_EVLHHOSSPLATX = C.PPC_INS_EVLHHOSSPLATX
	PPC_INS_EVLHHOUSPLAT  = C.PPC_INS_EVLHHOUSPLAT
	PPC_INS_EVLHHOUSPLATX = C.PPC_INS_EVLHHOUSPLATX
	PPC_INS_EVLWHE        = C.PPC_INS_EVLWHE
	PPC_INS_EVLWHEX       = C.PPC_INS_EVLWHEX
	PPC_INS_EVLWHOS       = C.PPC_INS_EVLWHOS
	PPC_INS_EVLWHOSX      = C.PPC_INS_EVLWHOSX
	PPC_INS_EVLWHOU       = C.PPC_INS_EVLWHOU
	PPC_INS_EVLWHOUX      = C.PPC_INS_EVLWHOUX
	PPC_INS_EVLWHSPLAT    = C.PPC_INS_EVLWHSPLAT
	PPC_INS_EVLWHSPLATX   = C.PPC_INS_EVLWHSPLATX
	PPC_INS_EVLWWSPLAT    = C.PPC_INS_EVLWWSPLAT
	PPC_INS_EVLWWSPLATX   = C.PPC_INS_EVLWWSPLATX
	PPC_INS_EVMERGEHI     = C.PPC_INS_EVMERGEHI
	PPC_INS_EVMERGEHILO   = C.PPC_INS_EVMERGEHILO
	PPC_INS_EVMERGELO     = C.PPC_INS_EVMERGELO
	PPC_INS_EVMERGELOHI   = C.PPC_INS_EVMERGELOHI
	PPC_INS_EVMHEGSMFAA   = C.PPC_INS_EVMHEGSMFAA
	PPC_INS_EVMHEGSMFAN   = C.PPC_INS_EVMHEGSMFAN
	PPC_INS_EVMHEGSMIAA   = C.PPC_INS_EVMHEGSMIAA
	PPC_INS_EVMHEGSMIAN   = C.PPC_INS_EVMHEGSMIAN
	PPC_INS_EVMHEGUMIAA   = C.PPC_INS_EVMHEGUMIAA
	PPC_INS_EVMHEGUMIAN   = C.PPC_INS_EVMHEGUMIAN
	PPC_INS_EVMHESMF      = C.PPC_INS_EVMHESMF
	PPC_INS_EVMHESMFA     = C.PPC_INS_EVMHESMFA
	PPC_INS_EVMHESMFAAW   = C.PPC_INS_EVMHESMFAAW
	PPC_INS_EVMHESMFANW   = C.PPC_INS_EVMHESMFANW
	PPC_INS_EVMHESMI      = C.PPC_INS_EVMHESMI
	PPC_INS_EVMHESMIA     = C.PPC_INS_EVMHESMIA
	PPC_INS_EVMHESMIAAW   = C.PPC_INS_EVMHESMIAAW
	PPC_INS_EVMHESMIANW   = C.PPC_INS_EVMHESMIANW
	PPC_INS_EVMHESSF      = C.PPC_INS_EVMHESSF
	PPC_INS_EVMHESSFA     = C.PPC_INS_EVMHESSFA
	PPC_INS_EVMHESSFAAW   = C.PPC_INS_EVMHESSFAAW
	PPC_INS_EVMHESSFANW   = C.PPC_INS_EVMHESSFANW
	PPC_INS_EVMHESSIAAW   = C.PPC_INS_EVMHESSIAAW
	PPC_INS_EVMHESSIANW   = C.PPC_INS_EVMHESSIANW
	PPC_INS_EVMHEUMI      = C.PPC_INS_EVMHEUMI
	PPC_INS_EVMHEUMIA     = C.PPC_INS_EVMHEUMIA
	PPC_INS_EVMHEUMIAAW   = C.PPC_INS_EVMHEUMIAAW
	PPC_INS_EVMHEUMIANW   = C.PPC_INS_EVMHEUMIANW
	PPC_INS_EVMHEUSIAAW   = C.PPC_INS_EVMHEUSIAAW
	PPC_INS_EVMHEUSIANW   = C.PPC_INS_EVMHEUSIANW
	PPC_INS_EVMHOGSMFAA   = C.PPC_INS_EVMHOGSMFAA
	PPC_INS_EVMHOGSMFAN   = C.PPC_INS_EVMHOGSMFAN
	PPC_INS_EVMHOGSMIAA   = C.PPC_INS_EVMHOGSMIAA
	PPC_INS_EVMHOGSMIAN   = C.PPC_INS_EVMHOGSMIAN
	PPC_INS_EVMHOGUMIAA   = C.PPC_INS_EVMHOGUMIAA
	PPC_INS_EVMHOGUMIAN   = C.PPC_INS_EVMHOGUMIAN
	PPC_INS_EVMHOSMF      = C.PPC_INS_EVMHOSMF
	PPC_INS_EVMHOSMFA     = C.PPC_INS_EVMHOSMFA
	PPC_INS_EVMHOSMFAAW   = C.PPC_INS_EVMHOSMFAAW
	PPC_INS_EVMHOSMFANW   = C.PPC_INS_EVMHOSMFANW
	PPC_INS_EVMHOSMI      = C.PPC_INS_EVMHOSMI
	PPC_INS_EVMHOSMIA     = C.PPC_INS_EVMHOSMIA
	PPC_INS_EVMHOSMIAAW   = C.PPC_INS_EVMHOSMIAAW
	PPC_INS_EVMHOSMIANW   = C.PPC_INS_EVMHOSMIANW
	PPC_INS_EVMHOSSF      = C.PPC_INS_EVMHOSSF
	PPC_INS_EVMHOSSFA     = C.PPC_INS_EVMHOSSFA
	PPC_INS_EVMHOSSFAAW   = C.PPC_INS_EVMHOSSFAAW
	PPC_INS_EVMHOSSFANW   = C.PPC_INS_EVMHOSSFANW
	PPC_INS_EVMHOSSIAAW   = C.PPC_INS_EVMHOSSIAAW
	PPC_INS_EVMHOSSIANW   = C.PPC_INS_EVMHOSSIANW
	PPC_INS_EVMHOUMI      = C.PPC_INS_EVMHOUMI
	PPC_INS_EVMHOUMIA     = C.PPC_INS_EVMHOUMIA
	PPC_INS_EVMHOUMIAAW   = C.PPC_INS_EVMHOUMIAAW
	PPC_INS_EVMHOUMIANW   = C.PPC_INS_EVMHOUMIANW
	PPC_INS_EVMHOUSIAAW   = C.PPC_INS_EVMHOUSIAAW
	PPC_INS_EVMHOUSIANW   = C.PPC_INS_EVMHOUSIANW
	PPC_INS_EVMRA         = C.PPC_INS_EVMRA
	PPC_INS_EVMWHSMF      = C.PPC_INS_EVMWHSMF
	PPC_INS_EVMWHSMFA     = C.PPC_INS_EVMWHSMFA
	PPC_INS_EVMWHSMI      = C.PPC_INS_EVMWHSMI
	PPC_INS_EVMWHSMIA     = C.PPC_INS_EVMWHSMIA
	PPC_INS_EVMWHSSF      = C.PPC_INS_EVMWHSSF
	PPC_INS_EVMWHSSFA     = C.PPC_INS_EVMWHSSFA
	PPC_INS_EVMWHUMI      = C.PPC_INS_EVMWHUMI
	PPC_INS_EVMWHUMIA     = C.PPC_INS_EVMWHUMIA
	PPC_INS_EVMWLSMIAAW   = C.PPC_INS_EVMWLSMIAAW
	PPC_INS_EVMWLSMIANW   = C.PPC_INS_EVMWLSMIANW
	PPC_INS_EVMWLSSIAAW   = C.PPC_INS_EVMWLSSIAAW
	PPC_INS_EVMWLSSIANW   = C.PPC_INS_EVMWLSSIANW
	PPC_INS_EVMWLUMI      = C.PPC_INS_EVMWLUMI
	PPC_INS_EVMWLUMIA     = C.PPC_INS_EVMWLUMIA
	PPC_INS_EVMWLUMIAAW   = C.PPC_INS_EVMWLUMIAAW
	PPC_INS_EVMWLUMIANW   = C.PPC_INS_EVMWLUMIANW
	PPC_INS_EVMWLUSIAAW   = C.PPC_INS_EVMWLUSIAAW
	PPC_INS_EVMWLUSIANW   = C.PPC_INS_EVMWLUSIANW
	PPC_INS_EVMWSMF       = C.PPC_INS_EVMWSMF
	PPC_INS_EVMWSMFA      = C.PPC_INS_EVMWSMFA
	PPC_INS_EVMWSMFAA     = C.PPC_INS_EVMWSMFAA
	PPC_INS_EVMWSMFAN     = C.PPC_INS_EVMWSMFAN
	PPC_INS_EVMWSMI       = C.PPC_INS_EVMWSMI
	PPC_INS_EVMWSMIA      = C.PPC_INS_EVMWSMIA
	PPC_INS_EVMWSMIAA     = C.PPC_INS_EVMWSMIAA
	PPC_INS_EVMWSMIAN     = C.PPC_INS_EVMWSMIAN
	PPC_INS_EVMWSSF       = C.PPC_INS_EVMWSSF
	PPC_INS_EVMWSSFA      = C.PPC_INS_EVMWSSFA
	PPC_INS_EVMWSSFAA     = C.PPC_INS_EVMWSSFAA
	PPC_INS_EVMWSSFAN     = C.PPC_INS_EVMWSSFAN
	PPC_INS_EVMWUMI       = C.PPC_INS_EVMWUMI
	PPC_INS_EVMWUMIA      = C.PPC_INS_EVMWUMIA
	PPC_INS_EVMWUMIAA     = C.PPC_INS_EVMWUMIAA
	PPC_INS_EVMWUMIAN     = C.PPC_INS_EVMWUMIAN
	PPC_INS_EVNAND        = C.PPC_INS_EVNAND
	PPC_INS_EVNEG         = C.PPC_INS_EVNEG
	PPC_INS_EVNOR         = C.PPC_INS_EVNOR
	PPC_INS_EVOR          = C.PPC_INS_EVOR
	PPC_INS_EVORC         = C.PPC_INS_EVORC
	PPC_INS_EVRLW         = C.PPC_INS_EVRLW
	PPC_INS_EVRLWI        = C.PPC_INS_EVRLWI
	PPC_INS_EVRNDW        = C.PPC_INS_EVRNDW
	PPC_INS_EVSLW         = C.PPC_INS_EVSLW
	PPC_INS_EVSLWI        = C.PPC_INS_EVSLWI
	PPC_INS_EVSPLATFI     = C.PPC_INS_EVSPLATFI
	PPC_INS_EVSPLATI      = C.PPC_INS_EVSPLATI
	PPC_INS_EVSRWIS       = C.PPC_INS_EVSRWIS
	PPC_INS_EVSRWIU       = C.PPC_INS_EVSRWIU
	PPC_INS_EVSRWS        = C.PPC_INS_EVSRWS
	PPC_INS_EVSRWU        = C.PPC_INS_EVSRWU
	PPC_INS_EVSTDD        = C.PPC_INS_EVSTDD
	PPC_INS_EVSTDDX       = C.PPC_INS_EVSTDDX
	PPC_INS_EVSTDH        = C.PPC_INS_EVSTDH
	PPC_INS_EVSTDHX       = C.PPC_INS_EVSTDHX
	PPC_INS_EVSTDW        = C.PPC_INS_EVSTDW
	PPC_INS_EVSTDWX       = C.PPC_INS_EVSTDWX
	PPC_INS_EVSTWHE       = C.PPC_INS_EVSTWHE
	PPC_INS_EVSTWHEX      = C.PPC_INS_EVSTWHEX
	PPC_INS_EVSTWHO       = C.PPC_INS_EVSTWHO
	PPC_INS_EVSTWHOX      = C.PPC_INS_EVSTWHOX
	PPC_INS_EVSTWWE       = C.PPC_INS_EVSTWWE
	PPC_INS_EVSTWWEX      = C.PPC_INS_EVSTWWEX
	PPC_INS_EVSTWWO       = C.PPC_INS_EVSTWWO
	PPC_INS_EVSTWWOX      = C.PPC_INS_EVSTWWOX
	PPC_INS_EVSUBFSMIAAW  = C.PPC_INS_EVSUBFSMIAAW
	PPC_INS_EVSUBFSSIAAW  = C.PPC_INS_EVSUBFSSIAAW
	PPC_INS_EVSUBFUMIAAW  = C.PPC_INS_EVSUBFUMIAAW
	PPC_INS_EVSUBFUSIAAW  = C.PPC_INS_EVSUBFUSIAAW
	PPC_INS_EVSUBFW       = C.PPC_INS_EVSUBFW
	PPC_INS_EVSUBIFW      = C.PPC_INS_EVSUBIFW
	PPC_INS_EVXOR         = C.PPC_INS_EVXOR
	PPC_INS_EXTSB         = C.PPC_INS_EXTSB
	PPC_INS_EXTSH         = C.PPC_INS_EXTSH
	PPC_INS_EXTSW         = C.PPC_INS_EXTSW
	PPC_INS_EIEIO         = C.PPC_INS_EIEIO
	PPC_INS_FABS          = C.PPC_INS_FABS
	PPC_INS_FADD          = C.PPC_INS_FADD
	PPC_INS_FADDS         = C.PPC_INS_FADDS
	PPC_INS_FCFID         = C.PPC_INS_FCFID
	PPC_INS_FCFIDS        = C.PPC_INS_FCFIDS
	PPC_INS_FCFIDU        = C.PPC_INS_FCFIDU
	PPC_INS_FCFIDUS       = C.PPC_INS_FCFIDUS
	PPC_INS_FCMPU         = C.PPC_INS_FCMPU
	PPC_INS_FCPSGN        = C.PPC_INS_FCPSGN
	PPC_INS_FCTID         = C.PPC_INS_FCTID
	PPC_INS_FCTIDUZ       = C.PPC_INS_FCTIDUZ
	PPC_INS_FCTIDZ        = C.PPC_INS_FCTIDZ
	PPC_INS_FCTIW         = C.PPC_INS_FCTIW
	PPC_INS_FCTIWUZ       = C.PPC_INS_FCTIWUZ
	PPC_INS_FCTIWZ        = C.PPC_INS_FCTIWZ
	PPC_INS_FDIV          = C.PPC_INS_FDIV
	PPC_INS_FDIVS         = C.PPC_INS_FDIVS
	PPC_INS_FMADD         = C.PPC_INS_FMADD
	PPC_INS_FMADDS        = C.PPC_INS_FMADDS
	PPC_INS_FMR           = C.PPC_INS_FMR
	PPC_INS_FMSUB         = C.PPC_INS_FMSUB
	PPC_INS_FMSUBS        = C.PPC_INS_FMSUBS
	PPC_INS_FMUL          = C.PPC_INS_FMUL
	PPC_INS_FMULS         = C.PPC_INS_FMULS
	PPC_INS_FNABS         = C.PPC_INS_FNABS
	PPC_INS_FNEG          = C.PPC_INS_FNEG
	PPC_INS_FNMADD        = C.PPC_INS_FNMADD
	PPC_INS_FNMADDS       = C.PPC_INS_FNMADDS
	PPC_INS_FNMSUB        = C.PPC_INS_FNMSUB
	PPC_INS_FNMSUBS       = C.PPC_INS_FNMSUBS
	PPC_INS_FRE           = C.PPC_INS_FRE
	PPC_INS_FRES          = C.PPC_INS_FRES
	PPC_INS_FRIM          = C.PPC_INS_FRIM
	PPC_INS_FRIN          = C.PPC_INS_FRIN
	PPC_INS_FRIP          = C.PPC_INS_FRIP
	PPC_INS_FRIZ          = C.PPC_INS_FRIZ
	PPC_INS_FRSP          = C.PPC_INS_FRSP
	PPC_INS_FRSQRTE       = C.PPC_INS_FRSQRTE
	PPC_INS_FRSQRTES      = C.PPC_INS_FRSQRTES
	PPC_INS_FSEL          = C.PPC_INS_FSEL
	PPC_INS_FSQRT         = C.PPC_INS_FSQRT
	PPC_INS_FSQRTS        = C.PPC_INS_FSQRTS
	PPC_INS_FSUB          = C.PPC_INS_FSUB
	PPC_INS_FSUBS         = C.PPC_INS_FSUBS
	PPC_INS_ICBI          = C.PPC_INS_ICBI
	PPC_INS_ICBT          = C.PPC_INS_ICBT
	PPC_INS_ICCCI         = C.PPC_INS_ICCCI
	PPC_INS_ISEL          = C.PPC_INS_ISEL
	PPC_INS_ISYNC         = C.PPC_INS_ISYNC
	PPC_INS_LA            = C.PPC_INS_LA
	PPC_INS_LBZ           = C.PPC_INS_LBZ
	PPC_INS_LBZCIX        = C.PPC_INS_LBZCIX
	PPC_INS_LBZU          = C.PPC_INS_LBZU
	PPC_INS_LBZUX         = C.PPC_INS_LBZUX
	PPC_INS_LBZX          = C.PPC_INS_LBZX
	PPC_INS_LD            = C.PPC_INS_LD
	PPC_INS_LDARX         = C.PPC_INS_LDARX
	PPC_INS_LDBRX         = C.PPC_INS_LDBRX
	PPC_INS_LDCIX         = C.PPC_INS_LDCIX
	PPC_INS_LDU           = C.PPC_INS_LDU
	PPC_INS_LDUX          = C.PPC_INS_LDUX
	PPC_INS_LDX           = C.PPC_INS_LDX
	PPC_INS_LFD           = C.PPC_INS_LFD
	PPC_INS_LFDU          = C.PPC_INS_LFDU
	PPC_INS_LFDUX         = C.PPC_INS_LFDUX
	PPC_INS_LFDX          = C.PPC_INS_LFDX
	PPC_INS_LFIWAX        = C.PPC_INS_LFIWAX
	PPC_INS_LFIWZX        = C.PPC_INS_LFIWZX
	PPC_INS_LFS           = C.PPC_INS_LFS
	PPC_INS_LFSU          = C.PPC_INS_LFSU
	PPC_INS_LFSUX         = C.PPC_INS_LFSUX
	PPC_INS_LFSX          = C.PPC_INS_LFSX
	PPC_INS_LHA           = C.PPC_INS_LHA
	PPC_INS_LHAU          = C.PPC_INS_LHAU
	PPC_INS_LHAUX         = C.PPC_INS_LHAUX
	PPC_INS_LHAX          = C.PPC_INS_LHAX
	PPC_INS_LHBRX         = C.PPC_INS_LHBRX
	PPC_INS_LHZ           = C.PPC_INS_LHZ
	PPC_INS_LHZCIX        = C.PPC_INS_LHZCIX
	PPC_INS_LHZU          = C.PPC_INS_LHZU
	PPC_INS_LHZUX         = C.PPC_INS_LHZUX
	PPC_INS_LHZX          = C.PPC_INS_LHZX
	PPC_INS_LI            = C.PPC_INS_LI
	PPC_INS_LIS           = C.PPC_INS_LIS
	PPC_INS_LMW           = C.PPC_INS_LMW
	PPC_INS_LSWI          = C.PPC_INS_LSWI
	PPC_INS_LVEBX         = C.PPC_INS_LVEBX
	PPC_INS_LVEHX         = C.PPC_INS_LVEHX
	PPC_INS_LVEWX         = C.PPC_INS_LVEWX
	PPC_INS_LVSL          = C.PPC_INS_LVSL
	PPC_INS_LVSR          = C.PPC_INS_LVSR
	PPC_INS_LVX           = C.PPC_INS_LVX
	PPC_INS_LVXL          = C.PPC_INS_LVXL
	PPC_INS_LWA           = C.PPC_INS_LWA
	PPC_INS_LWARX         = C.PPC_INS_LWARX
	PPC_INS_LWAUX         = C.PPC_INS_LWAUX
	PPC_INS_LWAX          = C.PPC_INS_LWAX
	PPC_INS_LWBRX         = C.PPC_INS_LWBRX
	PPC_INS_LWZ           = C.PPC_INS_LWZ
	PPC_INS_LWZCIX        = C.PPC_INS_LWZCIX
	PPC_INS_LWZU          = C.PPC_INS_LWZU
	PPC_INS_LWZUX         = C.PPC_INS_LWZUX
	PPC_INS_LWZX          = C.PPC_INS_LWZX
	PPC_INS_LXSDX         = C.PPC_INS_LXSDX
	PPC_INS_LXVD2X        = C.PPC_INS_LXVD2X
	PPC_INS_LXVDSX        = C.PPC_INS_LXVDSX
	PPC_INS_LXVW4X        = C.PPC_INS_LXVW4X
	PPC_INS_MBAR          = C.PPC_INS_MBAR
	PPC_INS_MCRF          = C.PPC_INS_MCRF
	PPC_INS_MCRFS         = C.PPC_INS_MCRFS
	PPC_INS_MFCR          = C.PPC_INS_MFCR
	PPC_INS_MFCTR         = C.PPC_INS_MFCTR
	PPC_INS_MFDCR         = C.PPC_INS_MFDCR
	PPC_INS_MFFS          = C.PPC_INS_MFFS
	PPC_INS_MFLR          = C.PPC_INS_MFLR
	PPC_INS_MFMSR         = C.PPC_INS_MFMSR
	PPC_INS_MFOCRF        = C.PPC_INS_MFOCRF
	PPC_INS_MFSPR         = C.PPC_INS_MFSPR
	PPC_INS_MFSR          = C.PPC_INS_MFSR
	PPC_INS_MFSRIN        = C.PPC_INS_MFSRIN
	PPC_INS_MFTB          = C.PPC_INS_MFTB
	PPC_INS_MFVSCR        = C.PPC_INS_MFVSCR
	PPC_INS_MSYNC         = C.PPC_INS_MSYNC
	PPC_INS_MTCRF         = C.PPC_INS_MTCRF
	PPC_INS_MTCTR         = C.PPC_INS_MTCTR
	PPC_INS_MTDCR         = C.PPC_INS_MTDCR
	PPC_INS_MTFSB0        = C.PPC_INS_MTFSB0
	PPC_INS_MTFSB1        = C.PPC_INS_MTFSB1
	PPC_INS_MTFSF         = C.PPC_INS_MTFSF
	PPC_INS_MTFSFI        = C.PPC_INS_MTFSFI
	PPC_INS_MTLR          = C.PPC_INS_MTLR
	PPC_INS_MTMSR         = C.PPC_INS_MTMSR
	PPC_INS_MTMSRD        = C.PPC_INS_MTMSRD
	PPC_INS_MTOCRF        = C.PPC_INS_MTOCRF
	PPC_INS_MTSPR         = C.PPC_INS_MTSPR
	PPC_INS_MTSR          = C.PPC_INS_MTSR
	PPC_INS_MTSRIN        = C.PPC_INS_MTSRIN
	PPC_INS_MTVSCR        = C.PPC_INS_MTVSCR
	PPC_INS_MULHD         = C.PPC_INS_MULHD
	PPC_INS_MULHDU        = C.PPC_INS_MULHDU
	PPC_INS_MULHW         = C.PPC_INS_MULHW
	PPC_INS_MULHWU        = C.PPC_INS_MULHWU
	PPC_INS_MULLD         = C.PPC_INS_MULLD
	PPC_INS_MULLI         = C.PPC_INS_MULLI
	PPC_INS_MULLW         = C.PPC_INS_MULLW
	PPC_INS_NAND          = C.PPC_INS_NAND
	PPC_INS_NEG           = C.PPC_INS_NEG
	PPC_INS_NOP           = C.PPC_INS_NOP
	PPC_INS_ORI           = C.PPC_INS_ORI
	PPC_INS_NOR           = C.PPC_INS_NOR
	PPC_INS_OR            = C.PPC_INS_OR
	PPC_INS_ORC           = C.PPC_INS_ORC
	PPC_INS_ORIS          = C.PPC_INS_ORIS
	PPC_INS_POPCNTD       = C.PPC_INS_POPCNTD
	PPC_INS_POPCNTW       = C.PPC_INS_POPCNTW
	PPC_INS_QVALIGNI      = C.PPC_INS_QVALIGNI
	PPC_INS_QVESPLATI     = C.PPC_INS_QVESPLATI
	PPC_INS_QVFABS        = C.PPC_INS_QVFABS
	PPC_INS_QVFADD        = C.PPC_INS_QVFADD
	PPC_INS_QVFADDS       = C.PPC_INS_QVFADDS
	PPC_INS_QVFCFID       = C.PPC_INS_QVFCFID
	PPC_INS_QVFCFIDS      = C.PPC_INS_QVFCFIDS
	PPC_INS_QVFCFIDU      = C.PPC_INS_QVFCFIDU
	PPC_INS_QVFCFIDUS     = C.PPC_INS_QVFCFIDUS
	PPC_INS_QVFCMPEQ      = C.PPC_INS_QVFCMPEQ
	PPC_INS_QVFCMPGT      = C.PPC_INS_QVFCMPGT
	PPC_INS_QVFCMPLT      = C.PPC_INS_QVFCMPLT
	PPC_INS_QVFCPSGN      = C.PPC_INS_QVFCPSGN
	PPC_INS_QVFCTID       = C.PPC_INS_QVFCTID
	PPC_INS_QVFCTIDU      = C.PPC_INS_QVFCTIDU
	PPC_INS_QVFCTIDUZ     = C.PPC_INS_QVFCTIDUZ
	PPC_INS_QVFCTIDZ      = C.PPC_INS_QVFCTIDZ
	PPC_INS_QVFCTIW       = C.PPC_INS_QVFCTIW
	PPC_INS_QVFCTIWU      = C.PPC_INS_QVFCTIWU
	PPC_INS_QVFCTIWUZ     = C.PPC_INS_QVFCTIWUZ
	PPC_INS_QVFCTIWZ      = C.PPC_INS_QVFCTIWZ
	PPC_INS_QVFLOGICAL    = C.PPC_INS_QVFLOGICAL
	PPC_INS_QVFMADD       = C.PPC_INS_QVFMADD
	PPC_INS_QVFMADDS      = C.PPC_INS_QVFMADDS
	PPC_INS_QVFMR         = C.PPC_INS_QVFMR
	PPC_INS_QVFMSUB       = C.PPC_INS_QVFMSUB
	PPC_INS_QVFMSUBS      = C.PPC_INS_QVFMSUBS
	PPC_INS_QVFMUL        = C.PPC_INS_QVFMUL
	PPC_INS_QVFMULS       = C.PPC_INS_QVFMULS
	PPC_INS_QVFNABS       = C.PPC_INS_QVFNABS
	PPC_INS_QVFNEG        = C.PPC_INS_QVFNEG
	PPC_INS_QVFNMADD      = C.PPC_INS_QVFNMADD
	PPC_INS_QVFNMADDS     = C.PPC_INS_QVFNMADDS
	PPC_INS_QVFNMSUB      = C.PPC_INS_QVFNMSUB
	PPC_INS_QVFNMSUBS     = C.PPC_INS_QVFNMSUBS
	PPC_INS_QVFPERM       = C.PPC_INS_QVFPERM
	PPC_INS_QVFRE         = C.PPC_INS_QVFRE
	PPC_INS_QVFRES        = C.PPC_INS_QVFRES
	PPC_INS_QVFRIM        = C.PPC_INS_QVFRIM
	PPC_INS_QVFRIN        = C.PPC_INS_QVFRIN
	PPC_INS_QVFRIP        = C.PPC_INS_QVFRIP
	PPC_INS_QVFRIZ        = C.PPC_INS_QVFRIZ
	PPC_INS_QVFRSP        = C.PPC_INS_QVFRSP
	PPC_INS_QVFRSQRTE     = C.PPC_INS_QVFRSQRTE
	PPC_INS_QVFRSQRTES    = C.PPC_INS_QVFRSQRTES
	PPC_INS_QVFSEL        = C.PPC_INS_QVFSEL
	PPC_INS_QVFSUB        = C.PPC_INS_QVFSUB
	PPC_INS_QVFSUBS       = C.PPC_INS_QVFSUBS
	PPC_INS_QVFTSTNAN     = C.PPC_INS_QVFTSTNAN
	PPC_INS_QVFXMADD      = C.PPC_INS_QVFXMADD
	PPC_INS_QVFXMADDS     = C.PPC_INS_QVFXMADDS
	PPC_INS_QVFXMUL       = C.PPC_INS_QVFXMUL
	PPC_INS_QVFXMULS      = C.PPC_INS_QVFXMULS
	PPC_INS_QVFXXCPNMADD  = C.PPC_INS_QVFXXCPNMADD
	PPC_INS_QVFXXCPNMADDS = C.PPC_INS_QVFXXCPNMADDS
	PPC_INS_QVFXXMADD     = C.PPC_INS_QVFXXMADD
	PPC_INS_QVFXXMADDS    = C.PPC_INS_QVFXXMADDS
	PPC_INS_QVFXXNPMADD   = C.PPC_INS_QVFXXNPMADD
	PPC_INS_QVFXXNPMADDS  = C.PPC_INS_QVFXXNPMADDS
	PPC_INS_QVGPCI        = C.PPC_INS_QVGPCI
	PPC_INS_QVLFCDUX      = C.PPC_INS_QVLFCDUX
	PPC_INS_QVLFCDUXA     = C.PPC_INS_QVLFCDUXA
	PPC_INS_QVLFCDX       = C.PPC_INS_QVLFCDX
	PPC_INS_QVLFCDXA      = C.PPC_INS_QVLFCDXA
	PPC_INS_QVLFCSUX      = C.PPC_INS_QVLFCSUX
	PPC_INS_QVLFCSUXA     = C.PPC_INS_QVLFCSUXA
	PPC_INS_QVLFCSX       = C.PPC_INS_QVLFCSX
	PPC_INS_QVLFCSXA      = C.PPC_INS_QVLFCSXA
	PPC_INS_QVLFDUX       = C.PPC_INS_QVLFDUX
	PPC_INS_QVLFDUXA      = C.PPC_INS_QVLFDUXA
	PPC_INS_QVLFDX        = C.PPC_INS_QVLFDX
	PPC_INS_QVLFDXA       = C.PPC_INS_QVLFDXA
	PPC_INS_QVLFIWAX      = C.PPC_INS_QVLFIWAX
	PPC_INS_QVLFIWAXA     = C.PPC_INS_QVLFIWAXA
	PPC_INS_QVLFIWZX      = C.PPC_INS_QVLFIWZX
	PPC_INS_QVLFIWZXA     = C.PPC_INS_QVLFIWZXA
	PPC_INS_QVLFSUX       = C.PPC_INS_QVLFSUX
	PPC_INS_QVLFSUXA      = C.PPC_INS_QVLFSUXA
	PPC_INS_QVLFSX        = C.PPC_INS_QVLFSX
	PPC_INS_QVLFSXA       = C.PPC_INS_QVLFSXA
	PPC_INS_QVLPCLDX      = C.PPC_INS_QVLPCLDX
	PPC_INS_QVLPCLSX      = C.PPC_INS_QVLPCLSX
	PPC_INS_QVLPCRDX      = C.PPC_INS_QVLPCRDX
	PPC_INS_QVLPCRSX      = C.PPC_INS_QVLPCRSX
	PPC_INS_QVSTFCDUX     = C.PPC_INS_QVSTFCDUX
	PPC_INS_QVSTFCDUXA    = C.PPC_INS_QVSTFCDUXA
	PPC_INS_QVSTFCDUXI    = C.PPC_INS_QVSTFCDUXI
	PPC_INS_QVSTFCDUXIA   = C.PPC_INS_QVSTFCDUXIA
	PPC_INS_QVSTFCDX      = C.PPC_INS_QVSTFCDX
	PPC_INS_QVSTFCDXA     = C.PPC_INS_QVSTFCDXA
	PPC_INS_QVSTFCDXI     = C.PPC_INS_QVSTFCDXI
	PPC_INS_QVSTFCDXIA    = C.PPC_INS_QVSTFCDXIA
	PPC_INS_QVSTFCSUX     = C.PPC_INS_QVSTFCSUX
	PPC_INS_QVSTFCSUXA    = C.PPC_INS_QVSTFCSUXA
	PPC_INS_QVSTFCSUXI    = C.PPC_INS_QVSTFCSUXI
	PPC_INS_QVSTFCSUXIA   = C.PPC_INS_QVSTFCSUXIA
	PPC_INS_QVSTFCSX      = C.PPC_INS_QVSTFCSX
	PPC_INS_QVSTFCSXA     = C.PPC_INS_QVSTFCSXA
	PPC_INS_QVSTFCSXI     = C.PPC_INS_QVSTFCSXI
	PPC_INS_QVSTFCSXIA    = C.PPC_INS_QVSTFCSXIA
	PPC_INS_QVSTFDUX      = C.PPC_INS_QVSTFDUX
	PPC_INS_QVSTFDUXA     = C.PPC_INS_QVSTFDUXA
	PPC_INS_QVSTFDUXI     = C.PPC_INS_QVSTFDUXI
	PPC_INS_QVSTFDUXIA    = C.PPC_INS_QVSTFDUXIA
	PPC_INS_QVSTFDX       = C.PPC_INS_QVSTFDX
	PPC_INS_QVSTFDXA      = C.PPC_INS_QVSTFDXA
	PPC_INS_QVSTFDXI      = C.PPC_INS_QVSTFDXI
	PPC_INS_QVSTFDXIA     = C.PPC_INS_QVSTFDXIA
	PPC_INS_QVSTFIWX      = C.PPC_INS_QVSTFIWX
	PPC_INS_QVSTFIWXA     = C.PPC_INS_QVSTFIWXA
	PPC_INS_QVSTFSUX      = C.PPC_INS_QVSTFSUX
	PPC_INS_QVSTFSUXA     = C.PPC_INS_QVSTFSUXA
	PPC_INS_QVSTFSUXI     = C.PPC_INS_QVSTFSUXI
	PPC_INS_QVSTFSUXIA    = C.PPC_INS_QVSTFSUXIA
	PPC_INS_QVSTFSX       = C.PPC_INS_QVSTFSX
	PPC_INS_QVSTFSXA      = C.PPC_INS_QVSTFSXA
	PPC_INS_QVSTFSXI      = C.PPC_INS_QVSTFSXI
	PPC_INS_QVSTFSXIA     = C.PPC_INS_QVSTFSXIA
	PPC_INS_RFCI          = C.PPC_INS_RFCI
	PPC_INS_RFDI          = C.PPC_INS_RFDI
	PPC_INS_RFI           = C.PPC_INS_RFI
	PPC_INS_RFID          = C.PPC_INS_RFID
	PPC_INS_RFMCI         = C.PPC_INS_RFMCI
	PPC_INS_RLDCL         = C.PPC_INS_RLDCL
	PPC_INS_RLDCR         = C.PPC_INS_RLDCR
	PPC_INS_RLDIC         = C.PPC_INS_RLDIC
	PPC_INS_RLDICL        = C.PPC_INS_RLDICL
	PPC_INS_RLDICR        = C.PPC_INS_RLDICR
	PPC_INS_RLDIMI        = C.PPC_INS_RLDIMI
	PPC_INS_RLWIMI        = C.PPC_INS_RLWIMI
	PPC_INS_RLWINM        = C.PPC_INS_RLWINM
	PPC_INS_RLWNM         = C.PPC_INS_RLWNM
	PPC_INS_SC            = C.PPC_INS_SC
	PPC_INS_SLBIA         = C.PPC_INS_SLBIA
	PPC_INS_SLBIE         = C.PPC_INS_SLBIE
	PPC_INS_SLBMFEE       = C.PPC_INS_SLBMFEE
	PPC_INS_SLBMTE        = C.PPC_INS_SLBMTE
	PPC_INS_SLD           = C.PPC_INS_SLD
	PPC_INS_SLW           = C.PPC_INS_SLW
	PPC_INS_SRAD          = C.PPC_INS_SRAD
	PPC_INS_SRADI         = C.PPC_INS_SRADI
	PPC_INS_SRAW          = C.PPC_INS_SRAW
	PPC_INS_SRAWI         = C.PPC_INS_SRAWI
	PPC_INS_SRD           = C.PPC_INS_SRD
	PPC_INS_SRW           = C.PPC_INS_SRW
	PPC_INS_STB           = C.PPC_INS_STB
	PPC_INS_STBCIX        = C.PPC_INS_STBCIX
	PPC_INS_STBU          = C.PPC_INS_STBU
	PPC_INS_STBUX         = C.PPC_INS_STBUX
	PPC_INS_STBX          = C.PPC_INS_STBX
	PPC_INS_STD           = C.PPC_INS_STD
	PPC_INS_STDBRX        = C.PPC_INS_STDBRX
	PPC_INS_STDCIX        = C.PPC_INS_STDCIX
	PPC_INS_STDCX         = C.PPC_INS_STDCX
	PPC_INS_STDU          = C.PPC_INS_STDU
	PPC_INS_STDUX         = C.PPC_INS_STDUX
	PPC_INS_STDX          = C.PPC_INS_STDX
	PPC_INS_STFD          = C.PPC_INS_STFD
	PPC_INS_STFDU         = C.PPC_INS_STFDU
	PPC_INS_STFDUX        = C.PPC_INS_STFDUX
	PPC_INS_STFDX         = C.PPC_INS_STFDX
	PPC_INS_STFIWX        = C.PPC_INS_STFIWX
	PPC_INS_STFS          = C.PPC_INS_STFS
	PPC_INS_STFSU         = C.PPC_INS_STFSU
	PPC_INS_STFSUX        = C.PPC_INS_STFSUX
	PPC_INS_STFSX         = C.PPC_INS_STFSX
	PPC_INS_STH           = C.PPC_INS_STH
	PPC_INS_STHBRX        = C.PPC_INS_STHBRX
	PPC_INS_STHCIX        = C.PPC_INS_STHCIX
	PPC_INS_STHU          = C.PPC_INS_STHU
	PPC_INS_STHUX         = C.PPC_INS_STHUX
	PPC_INS_STHX          = C.PPC_INS_STHX
	PPC_INS_STMW          = C.PPC_INS_STMW
	PPC_INS_STSWI         = C.PPC_INS_STSWI
	PPC_INS_STVEBX        = C.PPC_INS_STVEBX
	PPC_INS_STVEHX        = C.PPC_INS_STVEHX
	PPC_INS_STVEWX        = C.PPC_INS_STVEWX
	PPC_INS_STVX          = C.PPC_INS_STVX
	PPC_INS_STVXL         = C.PPC_INS_STVXL
	PPC_INS_STW           = C.PPC_INS_STW
	PPC_INS_STWBRX        = C.PPC_INS_STWBRX
	PPC_INS_STWCIX        = C.PPC_INS_STWCIX
	PPC_INS_STWCX         = C.PPC_INS_STWCX
	PPC_INS_STWU          = C.PPC_INS_STWU
	PPC_INS_STWUX         = C.PPC_INS_STWUX
	PPC_INS_STWX          = C.PPC_INS_STWX
	PPC_INS_STXSDX        = C.PPC_INS_STXSDX
	PPC_INS_STXVD2X       = C.PPC_INS_STXVD2X
	PPC_INS_STXVW4X       = C.PPC_INS_STXVW4X
	PPC_INS_SUBF          = C.PPC_INS_SUBF
	PPC_INS_SUBFC         = C.PPC_INS_SUBFC
	PPC_INS_SUBFE         = C.PPC_INS_SUBFE
	PPC_INS_SUBFIC        = C.PPC_INS_SUBFIC
	PPC_INS_SUBFME        = C.PPC_INS_SUBFME
	PPC_INS_SUBFZE        = C.PPC_INS_SUBFZE
	PPC_INS_SYNC          = C.PPC_INS_SYNC
	PPC_INS_TD            = C.PPC_INS_TD
	PPC_INS_TDI           = C.PPC_INS_TDI
	PPC_INS_TLBIA         = C.PPC_INS_TLBIA
	PPC_INS_TLBIE         = C.PPC_INS_TLBIE
	PPC_INS_TLBIEL        = C.PPC_INS_TLBIEL
	PPC_INS_TLBIVAX       = C.PPC_INS_TLBIVAX
	PPC_INS_TLBLD         = C.PPC_INS_TLBLD
	PPC_INS_TLBLI         = C.PPC_INS_TLBLI
	PPC_INS_TLBRE         = C.PPC_INS_TLBRE
	PPC_INS_TLBSX         = C.PPC_INS_TLBSX
	PPC_INS_TLBSYNC       = C.PPC_INS_TLBSYNC
	PPC_INS_TLBWE         = C.PPC_INS_TLBWE
	PPC_INS_TRAP          = C.PPC_INS_TRAP
	PPC_INS_TW            = C.PPC_INS_TW
	PPC_INS_TWI           = C.PPC_INS_TWI
	PPC_INS_VADDCUW       = C.PPC_INS_VADDCUW
	PPC_INS_VADDFP        = C.PPC_INS_VADDFP
	PPC_INS_VADDSBS       = C.PPC_INS_VADDSBS
	PPC_INS_VADDSHS       = C.PPC_INS_VADDSHS
	PPC_INS_VADDSWS       = C.PPC_INS_VADDSWS
	PPC_INS_VADDUBM       = C.PPC_INS_VADDUBM
	PPC_INS_VADDUBS       = C.PPC_INS_VADDUBS
	PPC_INS_VADDUDM       = C.PPC_INS_VADDUDM
	PPC_INS_VADDUHM       = C.PPC_INS_VADDUHM
	PPC_INS_VADDUHS       = C.PPC_INS_VADDUHS
	PPC_INS_VADDUWM       = C.PPC_INS_VADDUWM
	PPC_INS_VADDUWS       = C.PPC_INS_VADDUWS
	PPC_INS_VAND          = C.PPC_INS_VAND
	PPC_INS_VANDC         = C.PPC_INS_VANDC
	PPC_INS_VAVGSB        = C.PPC_INS_VAVGSB
	PPC_INS_VAVGSH        = C.PPC_INS_VAVGSH
	PPC_INS_VAVGSW        = C.PPC_INS_VAVGSW
	PPC_INS_VAVGUB        = C.PPC_INS_VAVGUB
	PPC_INS_VAVGUH        = C.PPC_INS_VAVGUH
	PPC_INS_VAVGUW        = C.PPC_INS_VAVGUW
	PPC_INS_VCFSX         = C.PPC_INS_VCFSX
	PPC_INS_VCFUX         = C.PPC_INS_VCFUX
	PPC_INS_VCLZB         = C.PPC_INS_VCLZB
	PPC_INS_VCLZD         = C.PPC_INS_VCLZD
	PPC_INS_VCLZH         = C.PPC_INS_VCLZH
	PPC_INS_VCLZW         = C.PPC_INS_VCLZW
	PPC_INS_VCMPBFP       = C.PPC_INS_VCMPBFP
	PPC_INS_VCMPEQFP      = C.PPC_INS_VCMPEQFP
	PPC_INS_VCMPEQUB      = C.PPC_INS_VCMPEQUB
	PPC_INS_VCMPEQUD      = C.PPC_INS_VCMPEQUD
	PPC_INS_VCMPEQUH      = C.PPC_INS_VCMPEQUH
	PPC_INS_VCMPEQUW      = C.PPC_INS_VCMPEQUW
	PPC_INS_VCMPGEFP      = C.PPC_INS_VCMPGEFP
	PPC_INS_VCMPGTFP      = C.PPC_INS_VCMPGTFP
	PPC_INS_VCMPGTSB      = C.PPC_INS_VCMPGTSB
	PPC_INS_VCMPGTSD      = C.PPC_INS_VCMPGTSD
	PPC_INS_VCMPGTSH      = C.PPC_INS_VCMPGTSH
	PPC_INS_VCMPGTSW      = C.PPC_INS_VCMPGTSW
	PPC_INS_VCMPGTUB      = C.PPC_INS_VCMPGTUB
	PPC_INS_VCMPGTUD      = C.PPC_INS_VCMPGTUD
	PPC_INS_VCMPGTUH      = C.PPC_INS_VCMPGTUH
	PPC_INS_VCMPGTUW      = C.PPC_INS_VCMPGTUW
	PPC_INS_VCTSXS        = C.PPC_INS_VCTSXS
	PPC_INS_VCTUXS        = C.PPC_INS_VCTUXS
	PPC_INS_VEQV          = C.PPC_INS_VEQV
	PPC_INS_VEXPTEFP      = C.PPC_INS_VEXPTEFP
	PPC_INS_VLOGEFP       = C.PPC_INS_VLOGEFP
	PPC_INS_VMADDFP       = C.PPC_INS_VMADDFP
	PPC_INS_VMAXFP        = C.PPC_INS_VMAXFP
	PPC_INS_VMAXSB        = C.PPC_INS_VMAXSB
	PPC_INS_VMAXSD        = C.PPC_INS_VMAXSD
	PPC_INS_VMAXSH        = C.PPC_INS_VMAXSH
	PPC_INS_VMAXSW        = C.PPC_INS_VMAXSW
	PPC_INS_VMAXUB        = C.PPC_INS_VMAXUB
	PPC_INS_VMAXUD        = C.PPC_INS_VMAXUD
	PPC_INS_VMAXUH        = C.PPC_INS_VMAXUH
	PPC_INS_VMAXUW        = C.PPC_INS_VMAXUW
	PPC_INS_VMHADDSHS     = C.PPC_INS_VMHADDSHS
	PPC_INS_VMHRADDSHS    = C.PPC_INS_VMHRADDSHS
	PPC_INS_VMINUD        = C.PPC_INS_VMINUD
	PPC_INS_VMINFP        = C.PPC_INS_VMINFP
	PPC_INS_VMINSB        = C.PPC_INS_VMINSB
	PPC_INS_VMINSD        = C.PPC_INS_VMINSD
	PPC_INS_VMINSH        = C.PPC_INS_VMINSH
	PPC_INS_VMINSW        = C.PPC_INS_VMINSW
	PPC_INS_VMINUB        = C.PPC_INS_VMINUB
	PPC_INS_VMINUH        = C.PPC_INS_VMINUH
	PPC_INS_VMINUW        = C.PPC_INS_VMINUW
	PPC_INS_VMLADDUHM     = C.PPC_INS_VMLADDUHM
	PPC_INS_VMRGHB        = C.PPC_INS_VMRGHB
	PPC_INS_VMRGHH        = C.PPC_INS_VMRGHH
	PPC_INS_VMRGHW        = C.PPC_INS_VMRGHW
	PPC_INS_VMRGLB        = C.PPC_INS_VMRGLB
	PPC_INS_VMRGLH        = C.PPC_INS_VMRGLH
	PPC_INS_VMRGLW        = C.PPC_INS_VMRGLW
	PPC_INS_VMSUMMBM      = C.PPC_INS_VMSUMMBM
	PPC_INS_VMSUMSHM      = C.PPC_INS_VMSUMSHM
	PPC_INS_VMSUMSHS      = C.PPC_INS_VMSUMSHS
	PPC_INS_VMSUMUBM      = C.PPC_INS_VMSUMUBM
	PPC_INS_VMSUMUHM      = C.PPC_INS_VMSUMUHM
	PPC_INS_VMSUMUHS      = C.PPC_INS_VMSUMUHS
	PPC_INS_VMULESB       = C.PPC_INS_VMULESB
	PPC_INS_VMULESH       = C.PPC_INS_VMULESH
	PPC_INS_VMULESW       = C.PPC_INS_VMULESW
	PPC_INS_VMULEUB       = C.PPC_INS_VMULEUB
	PPC_INS_VMULEUH       = C.PPC_INS_VMULEUH
	PPC_INS_VMULEUW       = C.PPC_INS_VMULEUW
	PPC_INS_VMULOSB       = C.PPC_INS_VMULOSB
	PPC_INS_VMULOSH       = C.PPC_INS_VMULOSH
	PPC_INS_VMULOSW       = C.PPC_INS_VMULOSW
	PPC_INS_VMULOUB       = C.PPC_INS_VMULOUB
	PPC_INS_VMULOUH       = C.PPC_INS_VMULOUH
	PPC_INS_VMULOUW       = C.PPC_INS_VMULOUW
	PPC_INS_VMULUWM       = C.PPC_INS_VMULUWM
	PPC_INS_VNAND         = C.PPC_INS_VNAND
	PPC_INS_VNMSUBFP      = C.PPC_INS_VNMSUBFP
	PPC_INS_VNOR          = C.PPC_INS_VNOR
	PPC_INS_VOR           = C.PPC_INS_VOR
	PPC_INS_VORC          = C.PPC_INS_VORC
	PPC_INS_VPERM         = C.PPC_INS_VPERM
	PPC_INS_VPKPX         = C.PPC_INS_VPKPX
	PPC_INS_VPKSHSS       = C.PPC_INS_VPKSHSS
	PPC_INS_VPKSHUS       = C.PPC_INS_VPKSHUS
	PPC_INS_VPKSWSS       = C.PPC_INS_VPKSWSS
	PPC_INS_VPKSWUS       = C.PPC_INS_VPKSWUS
	PPC_INS_VPKUHUM       = C.PPC_INS_VPKUHUM
	PPC_INS_VPKUHUS       = C.PPC_INS_VPKUHUS
	PPC_INS_VPKUWUM       = C.PPC_INS_VPKUWUM
	PPC_INS_VPKUWUS       = C.PPC_INS_VPKUWUS
	PPC_INS_VPOPCNTB      = C.PPC_INS_VPOPCNTB
	PPC_INS_VPOPCNTD      = C.PPC_INS_VPOPCNTD
	PPC_INS_VPOPCNTH      = C.PPC_INS_VPOPCNTH
	PPC_INS_VPOPCNTW      = C.PPC_INS_VPOPCNTW
	PPC_INS_VREFP         = C.PPC_INS_VREFP
	PPC_INS_VRFIM         = C.PPC_INS_VRFIM
	PPC_INS_VRFIN         = C.PPC_INS_VRFIN
	PPC_INS_VRFIP         = C.PPC_INS_VRFIP
	PPC_INS_VRFIZ         = C.PPC_INS_VRFIZ
	PPC_INS_VRLB          = C.PPC_INS_VRLB
	PPC_INS_VRLD          = C.PPC_INS_VRLD
	PPC_INS_VRLH          = C.PPC_INS_VRLH
	PPC_INS_VRLW          = C.PPC_INS_VRLW
	PPC_INS_VRSQRTEFP     = C.PPC_INS_VRSQRTEFP
	PPC_INS_VSEL          = C.PPC_INS_VSEL
	PPC_INS_VSL           = C.PPC_INS_VSL
	PPC_INS_VSLB          = C.PPC_INS_VSLB
	PPC_INS_VSLD          = C.PPC_INS_VSLD
	PPC_INS_VSLDOI        = C.PPC_INS_VSLDOI
	PPC_INS_VSLH          = C.PPC_INS_VSLH
	PPC_INS_VSLO          = C.PPC_INS_VSLO
	PPC_INS_VSLW          = C.PPC_INS_VSLW
	PPC_INS_VSPLTB        = C.PPC_INS_VSPLTB
	PPC_INS_VSPLTH        = C.PPC_INS_VSPLTH
	PPC_INS_VSPLTISB      = C.PPC_INS_VSPLTISB
	PPC_INS_VSPLTISH      = C.PPC_INS_VSPLTISH
	PPC_INS_VSPLTISW      = C.PPC_INS_VSPLTISW
	PPC_INS_VSPLTW        = C.PPC_INS_VSPLTW
	PPC_INS_VSR           = C.PPC_INS_VSR
	PPC_INS_VSRAB         = C.PPC_INS_VSRAB
	PPC_INS_VSRAD         = C.PPC_INS_VSRAD
	PPC_INS_VSRAH         = C.PPC_INS_VSRAH
	PPC_INS_VSRAW         = C.PPC_INS_VSRAW
	PPC_INS_VSRB          = C.PPC_INS_VSRB
	PPC_INS_VSRD          = C.PPC_INS_VSRD
	PPC_INS_VSRH          = C.PPC_INS_VSRH
	PPC_INS_VSRO          = C.PPC_INS_VSRO
	PPC_INS_VSRW          = C.PPC_INS_VSRW
	PPC_INS_VSUBCUW       = C.PPC_INS_VSUBCUW
	PPC_INS_VSUBFP        = C.PPC_INS_VSUBFP
	PPC_INS_VSUBSBS       = C.PPC_INS_VSUBSBS
	PPC_INS_VSUBSHS       = C.PPC_INS_VSUBSHS
	PPC_INS_VSUBSWS       = C.PPC_INS_VSUBSWS
	PPC_INS_VSUBUBM       = C.PPC_INS_VSUBUBM
	PPC_INS_VSUBUBS       = C.PPC_INS_VSUBUBS
	PPC_INS_VSUBUDM       = C.PPC_INS_VSUBUDM
	PPC_INS_VSUBUHM       = C.PPC_INS_VSUBUHM
	PPC_INS_VSUBUHS       = C.PPC_INS_VSUBUHS
	PPC_INS_VSUBUWM       = C.PPC_INS_VSUBUWM
	PPC_INS_VSUBUWS       = C.PPC_INS_VSUBUWS
	PPC_INS_VSUM2SWS      = C.PPC_INS_VSUM2SWS
	PPC_INS_VSUM4SBS      = C.PPC_INS_VSUM4SBS
	PPC_INS_VSUM4SHS      = C.PPC_INS_VSUM4SHS
	PPC_INS_VSUM4UBS      = C.PPC_INS_VSUM4UBS
	PPC_INS_VSUMSWS       = C.PPC_INS_VSUMSWS
	PPC_INS_VUPKHPX       = C.PPC_INS_VUPKHPX
	PPC_INS_VUPKHSB       = C.PPC_INS_VUPKHSB
	PPC_INS_VUPKHSH       = C.PPC_INS_VUPKHSH
	PPC_INS_VUPKLPX       = C.PPC_INS_VUPKLPX
	PPC_INS_VUPKLSB       = C.PPC_INS_VUPKLSB
	PPC_INS_VUPKLSH       = C.PPC_INS_VUPKLSH
	PPC_INS_VXOR          = C.PPC_INS_VXOR
	PPC_INS_WAIT          = C.PPC_INS_WAIT
	PPC_INS_WRTEE         = C.PPC_INS_WRTEE
	PPC_INS_WRTEEI        = C.PPC_INS_WRTEEI
	PPC_INS_XOR           = C.PPC_INS_XOR
	PPC_INS_XORI          = C.PPC_INS_XORI
	PPC_INS_XORIS         = C.PPC_INS_XORIS
	PPC_INS_XSABSDP       = C.PPC_INS_XSABSDP
	PPC_INS_XSADDDP       = C.PPC_INS_XSADDDP
	PPC_INS_XSCMPODP      = C.PPC_INS_XSCMPODP
	PPC_INS_XSCMPUDP      = C.PPC_INS_XSCMPUDP
	PPC_INS_XSCPSGNDP     = C.PPC_INS_XSCPSGNDP
	PPC_INS_XSCVDPSP      = C.PPC_INS_XSCVDPSP
	PPC_INS_XSCVDPSXDS    = C.PPC_INS_XSCVDPSXDS
	PPC_INS_XSCVDPSXWS    = C.PPC_INS_XSCVDPSXWS
	PPC_INS_XSCVDPUXDS    = C.PPC_INS_XSCVDPUXDS
	PPC_INS_XSCVDPUXWS    = C.PPC_INS_XSCVDPUXWS
	PPC_INS_XSCVSPDP      = C.PPC_INS_XSCVSPDP
	PPC_INS_XSCVSXDDP     = C.PPC_INS_XSCVSXDDP
	PPC_INS_XSCVUXDDP     = C.PPC_INS_XSCVUXDDP
	PPC_INS_XSDIVDP       = C.PPC_INS_XSDIVDP
	PPC_INS_XSMADDADP     = C.PPC_INS_XSMADDADP
	PPC_INS_XSMADDMDP     = C.PPC_INS_XSMADDMDP
	PPC_INS_XSMAXDP       = C.PPC_INS_XSMAXDP
	PPC_INS_XSMINDP       = C.PPC_INS_XSMINDP
	PPC_INS_XSMSUBADP     = C.PPC_INS_XSMSUBADP
	PPC_INS_XSMSUBMDP     = C.PPC_INS_XSMSUBMDP
	PPC_INS_XSMULDP       = C.PPC_INS_XSMULDP
	PPC_INS_XSNABSDP      = C.PPC_INS_XSNABSDP
	PPC_INS_XSNEGDP       = C.PPC_INS_XSNEGDP
	PPC_INS_XSNMADDADP    = C.PPC_INS_XSNMADDADP
	PPC_INS_XSNMADDMDP    = C.PPC_INS_XSNMADDMDP
	PPC_INS_XSNMSUBADP    = C.PPC_INS_XSNMSUBADP
	PPC_INS_XSNMSUBMDP    = C.PPC_INS_XSNMSUBMDP
	PPC_INS_XSRDPI        = C.PPC_INS_XSRDPI
	PPC_INS_XSRDPIC       = C.PPC_INS_XSRDPIC
	PPC_INS_XSRDPIM       = C.PPC_INS_XSRDPIM
	PPC_INS_XSRDPIP       = C.PPC_INS_XSRDPIP
	PPC_INS_XSRDPIZ       = C.PPC_INS_XSRDPIZ
	PPC_INS_XSREDP        = C.PPC_INS_XSREDP
	PPC_INS_XSRSQRTEDP    = C.PPC_INS_XSRSQRTEDP
	PPC_INS_XSSQRTDP      = C.PPC_INS_XSSQRTDP
	PPC_INS_XSSUBDP       = C.PPC_INS_XSSUBDP
	PPC_INS_XSTDIVDP      = C.PPC_INS_XSTDIVDP
	PPC_INS_XSTSQRTDP     = C.PPC_INS_XSTSQRTDP
	PPC_INS_XVABSDP       = C.PPC_INS_XVABSDP
	PPC_INS_XVABSSP       = C.PPC_INS_XVABSSP
	PPC_INS_XVADDDP       = C.PPC_INS_XVADDDP
	PPC_INS_XVADDSP       = C.PPC_INS_XVADDSP
	PPC_INS_XVCMPEQDP     = C.PPC_INS_XVCMPEQDP
	PPC_INS_XVCMPEQSP     = C.PPC_INS_XVCMPEQSP
	PPC_INS_XVCMPGEDP     = C.PPC_INS_XVCMPGEDP
	PPC_INS_XVCMPGESP     = C.PPC_INS_XVCMPGESP
	PPC_INS_XVCMPGTDP     = C.PPC_INS_XVCMPGTDP
	PPC_INS_XVCMPGTSP     = C.PPC_INS_XVCMPGTSP
	PPC_INS_XVCPSGNDP     = C.PPC_INS_XVCPSGNDP
	PPC_INS_XVCPSGNSP     = C.PPC_INS_XVCPSGNSP
	PPC_INS_XVCVDPSP      = C.PPC_INS_XVCVDPSP
	PPC_INS_XVCVDPSXDS    = C.PPC_INS_XVCVDPSXDS
	PPC_INS_XVCVDPSXWS    = C.PPC_INS_XVCVDPSXWS
	PPC_INS_XVCVDPUXDS    = C.PPC_INS_XVCVDPUXDS
	PPC_INS_XVCVDPUXWS    = C.PPC_INS_XVCVDPUXWS
	PPC_INS_XVCVSPDP      = C.PPC_INS_XVCVSPDP
	PPC_INS_XVCVSPSXDS    = C.PPC_INS_XVCVSPSXDS
	PPC_INS_XVCVSPSXWS    = C.PPC_INS_XVCVSPSXWS
	PPC_INS_XVCVSPUXDS    = C.PPC_INS_XVCVSPUXDS
	PPC_INS_XVCVSPUXWS    = C.PPC_INS_XVCVSPUXWS
	PPC_INS_XVCVSXDDP     = C.PPC_INS_XVCVSXDDP
	PPC_INS_XVCVSXDSP     = C.PPC_INS_XVCVSXDSP
	PPC_INS_XVCVSXWDP     = C.PPC_INS_XVCVSXWDP
	PPC_INS_XVCVSXWSP     = C.PPC_INS_XVCVSXWSP
	PPC_INS_XVCVUXDDP     = C.PPC_INS_XVCVUXDDP
	PPC_INS_XVCVUXDSP     = C.PPC_INS_XVCVUXDSP
	PPC_INS_XVCVUXWDP     = C.PPC_INS_XVCVUXWDP
	PPC_INS_XVCVUXWSP     = C.PPC_INS_XVCVUXWSP
	PPC_INS_XVDIVDP       = C.PPC_INS_XVDIVDP
	PPC_INS_XVDIVSP       = C.PPC_INS_XVDIVSP
	PPC_INS_XVMADDADP     = C.PPC_INS_XVMADDADP
	PPC_INS_XVMADDASP     = C.PPC_INS_XVMADDASP
	PPC_INS_XVMADDMDP     = C.PPC_INS_XVMADDMDP
	PPC_INS_XVMADDMSP     = C.PPC_INS_XVMADDMSP
	PPC_INS_XVMAXDP       = C.PPC_INS_XVMAXDP
	PPC_INS_XVMAXSP       = C.PPC_INS_XVMAXSP
	PPC_INS_XVMINDP       = C.PPC_INS_XVMINDP
	PPC_INS_XVMINSP       = C.PPC_INS_XVMINSP
	PPC_INS_XVMSUBADP     = C.PPC_INS_XVMSUBADP
	PPC_INS_XVMSUBASP     = C.PPC_INS_XVMSUBASP
	PPC_INS_XVMSUBMDP     = C.PPC_INS_XVMSUBMDP
	PPC_INS_XVMSUBMSP     = C.PPC_INS_XVMSUBMSP
	PPC_INS_XVMULDP       = C.PPC_INS_XVMULDP
	PPC_INS_XVMULSP       = C.PPC_INS_XVMULSP
	PPC_INS_XVNABSDP      = C.PPC_INS_XVNABSDP
	PPC_INS_XVNABSSP      = C.PPC_INS_XVNABSSP
	PPC_INS_XVNEGDP       = C.PPC_INS_XVNEGDP
	PPC_INS_XVNEGSP       = C.PPC_INS_XVNEGSP
	PPC_INS_XVNMADDADP    = C.PPC_INS_XVNMADDADP
	PPC_INS_XVNMADDASP    = C.PPC_INS_XVNMADDASP
	PPC_INS_XVNMADDMDP    = C.PPC_INS_XVNMADDMDP
	PPC_INS_XVNMADDMSP    = C.PPC_INS_XVNMADDMSP
	PPC_INS_XVNMSUBADP    = C.PPC_INS_XVNMSUBADP
	PPC_INS_XVNMSUBASP    = C.PPC_INS_XVNMSUBASP
	PPC_INS_XVNMSUBMDP    = C.PPC_INS_XVNMSUBMDP
	PPC_INS_XVNMSUBMSP    = C.PPC_INS_XVNMSUBMSP
	PPC_INS_XVRDPI        = C.PPC_INS_XVRDPI
	PPC_INS_XVRDPIC       = C.PPC_INS_XVRDPIC
	PPC_INS_XVRDPIM       = C.PPC_INS_XVRDPIM
	PPC_INS_XVRDPIP       = C.PPC_INS_XVRDPIP
	PPC_INS_XVRDPIZ       = C.PPC_INS_XVRDPIZ
	PPC_INS_XVREDP        = C.PPC_INS_XVREDP
	PPC_INS_XVRESP        = C.PPC_INS_XVRESP
	PPC_INS_XVRSPI        = C.PPC_INS_XVRSPI
	PPC_INS_XVRSPIC       = C.PPC_INS_XVRSPIC
	PPC_INS_XVRSPIM       = C.PPC_INS_XVRSPIM
	PPC_INS_XVRSPIP       = C.PPC_INS_XVRSPIP
	PPC_INS_XVRSPIZ       = C.PPC_INS_XVRSPIZ
	PPC_INS_XVRSQRTEDP    = C.PPC_INS_XVRSQRTEDP
	PPC_INS_XVRSQRTESP    = C.PPC_INS_XVRSQRTESP
	PPC_INS_XVSQRTDP      = C.PPC_INS_XVSQRTDP
	PPC_INS_XVSQRTSP      = C.PPC_INS_XVSQRTSP
	PPC_INS_XVSUBDP       = C.PPC_INS_XVSUBDP
	PPC_INS_XVSUBSP       = C.PPC_INS_XVSUBSP
	PPC_INS_XVTDIVDP      = C.PPC_INS_XVTDIVDP
	PPC_INS_XVTDIVSP      = C.PPC_INS_XVTDIVSP
	PPC_INS_XVTSQRTDP     = C.PPC_INS_XVTSQRTDP
	PPC_INS_XVTSQRTSP     = C.PPC_INS_XVTSQRTSP
	PPC_INS_XXLAND        = C.PPC_INS_XXLAND
	PPC_INS_XXLANDC       = C.PPC_INS_XXLANDC
	PPC_INS_XXLEQV        = C.PPC_INS_XXLEQV
	PPC_INS_XXLNAND       = C.PPC_INS_XXLNAND
	PPC_INS_XXLNOR        = C.PPC_INS_XXLNOR
	PPC_INS_XXLOR         = C.PPC_INS_XXLOR
	PPC_INS_XXLORC        = C.PPC_INS_XXLORC
	PPC_INS_XXLXOR        = C.PPC_INS_XXLXOR
	PPC_INS_XXMRGHW       = C.PPC_INS_XXMRGHW
	PPC_INS_XXMRGLW       = C.PPC_INS_XXMRGLW
	PPC_INS_XXPERMDI      = C.PPC_INS_XXPERMDI
	PPC_INS_XXSEL         = C.PPC_INS_XXSEL
	PPC_INS_XXSLDWI       = C.PPC_INS_XXSLDWI
	PPC_INS_XXSPLTW       = C.PPC_INS_XXSPLTW
	PPC_INS_BCA           = C.PPC_INS_BCA
	PPC_INS_BCLA          = C.PPC_INS_BCLA
	PPC_INS_SLWI          = C.PPC_INS_SLWI
	PPC_INS_SRWI          = C.PPC_INS_SRWI
	PPC_INS_SLDI          = C.PPC_INS_SLDI
	PPC_INS_BTA           = C.PPC_INS_BTA
	PPC_INS_CRSET         = C.PPC_INS_CRSET
	PPC_INS_CRNOT         = C.PPC_INS_CRNOT
	PPC_INS_CRMOVE        = C.PPC_INS_CRMOVE
	PPC_INS_CRCLR         = C.PPC_INS_CRCLR
	PPC_INS_MFBR0         = C.PPC_INS_MFBR0
	PPC_INS_MFBR1         = C.PPC_INS_MFBR1
	PPC_INS_MFBR2         = C.PPC_INS_MFBR2
	PPC_INS_MFBR3         = C.PPC_INS_MFBR3
	PPC_INS_MFBR4         = C.PPC_INS_MFBR4
	PPC_INS_MFBR5         = C.PPC_INS_MFBR5
	PPC_INS_MFBR6         = C.PPC_INS_MFBR6
	PPC_INS_MFBR7         = C.PPC_INS_MFBR7
	PPC_INS_MFXER         = C.PPC_INS_MFXER
	PPC_INS_MFRTCU        = C.PPC_INS_MFRTCU
	PPC_INS_MFRTCL        = C.PPC_INS_MFRTCL
	PPC_INS_MFDSCR        = C.PPC_INS_MFDSCR
	PPC_INS_MFDSISR       = C.PPC_INS_MFDSISR
	PPC_INS_MFDAR         = C.PPC_INS_MFDAR
	PPC_INS_MFSRR2        = C.PPC_INS_MFSRR2
	PPC_INS_MFSRR3        = C.PPC_INS_MFSRR3
	PPC_INS_MFCFAR        = C.PPC_INS_MFCFAR
	PPC_INS_MFAMR         = C.PPC_INS_MFAMR
	PPC_INS_MFPID         = C.PPC_INS_MFPID
	PPC_INS_MFTBLO        = C.PPC_INS_MFTBLO
	PPC_INS_MFTBHI        = C.PPC_INS_MFTBHI
	PPC_INS_MFDBATU       = C.PPC_INS_MFDBATU
	PPC_INS_MFDBATL       = C.PPC_INS_MFDBATL
	PPC_INS_MFIBATU       = C.PPC_INS_MFIBATU
	PPC_INS_MFIBATL       = C.PPC_INS_MFIBATL
	PPC_INS_MFDCCR        = C.PPC_INS_MFDCCR
	PPC_INS_MFICCR        = C.PPC_INS_MFICCR
	PPC_INS_MFDEAR        = C.PPC_INS_MFDEAR
	PPC_INS_MFESR         = C.PPC_INS_MFESR
	PPC_INS_MFSPEFSCR     = C.PPC_INS_MFSPEFSCR
	PPC_INS_MFTCR         = C.PPC_INS_MFTCR
	PPC_INS_MFASR         = C.PPC_INS_MFASR
	PPC_INS_MFPVR         = C.PPC_INS_MFPVR
	PPC_INS_MFTBU         = C.PPC_INS_MFTBU
	PPC_INS_MTCR          = C.PPC_INS_MTCR
	PPC_INS_MTBR0         = C.PPC_INS_MTBR0
	PPC_INS_MTBR1         = C.PPC_INS_MTBR1
	PPC_INS_MTBR2         = C.PPC_INS_MTBR2
	PPC_INS_MTBR3         = C.PPC_INS_MTBR3
	PPC_INS_MTBR4         = C.PPC_INS_MTBR4
	PPC_INS_MTBR5         = C.PPC_INS_MTBR5
	PPC_INS_MTBR6         = C.PPC_INS_MTBR6
	PPC_INS_MTBR7         = C.PPC_INS_MTBR7
	PPC_INS_MTXER         = C.PPC_INS_MTXER
	PPC_INS_MTDSCR        = C.PPC_INS_MTDSCR
	PPC_INS_MTDSISR       = C.PPC_INS_MTDSISR
	PPC_INS_MTDAR         = C.PPC_INS_MTDAR
	PPC_INS_MTSRR2        = C.PPC_INS_MTSRR2
	PPC_INS_MTSRR3        = C.PPC_INS_MTSRR3
	PPC_INS_MTCFAR        = C.PPC_INS_MTCFAR
	PPC_INS_MTAMR         = C.PPC_INS_MTAMR
	PPC_INS_MTPID         = C.PPC_INS_MTPID
	PPC_INS_MTTBL         = C.PPC_INS_MTTBL
	PPC_INS_MTTBU         = C.PPC_INS_MTTBU
	PPC_INS_MTTBLO        = C.PPC_INS_MTTBLO
	PPC_INS_MTTBHI        = C.PPC_INS_MTTBHI
	PPC_INS_MTDBATU       = C.PPC_INS_MTDBATU
	PPC_INS_MTDBATL       = C.PPC_INS_MTDBATL
	PPC_INS_MTIBATU       = C.PPC_INS_MTIBATU
	PPC_INS_MTIBATL       = C.PPC_INS_MTIBATL
	PPC_INS_MTDCCR        = C.PPC_INS_MTDCCR
	PPC_INS_MTICCR        = C.PPC_INS_MTICCR
	PPC_INS_MTDEAR        = C.PPC_INS_MTDEAR
	PPC_INS_MTESR         = C.PPC_INS_MTESR
	PPC_INS_MTSPEFSCR     = C.PPC_INS_MTSPEFSCR
	PPC_INS_MTTCR         = C.PPC_INS_MTTCR
	PPC_INS_NOT           = C.PPC_INS_NOT
	PPC_INS_MR            = C.PPC_INS_MR
	PPC_INS_ROTLD         = C.PPC_INS_ROTLD
	PPC_INS_ROTLDI        = C.PPC_INS_ROTLDI
	PPC_INS_CLRLDI        = C.PPC_INS_CLRLDI
	PPC_INS_ROTLWI        = C.PPC_INS_ROTLWI
	PPC_INS_CLRLWI        = C.PPC_INS_CLRLWI
	PPC_INS_ROTLW         = C.PPC_INS_ROTLW
	PPC_INS_SUB           = C.PPC_INS_SUB
	PPC_INS_SUBC          = C.PPC_INS_SUBC
	PPC_INS_LWSYNC        = C.PPC_INS_LWSYNC
	PPC_INS_PTESYNC       = C.PPC_INS_PTESYNC
	PPC_INS_TDLT          = C.PPC_INS_TDLT
	PPC_INS_TDEQ          = C.PPC_INS_TDEQ
	PPC_INS_TDGT          = C.PPC_INS_TDGT
	PPC_INS_TDNE          = C.PPC_INS_TDNE
	PPC_INS_TDLLT         = C.PPC_INS_TDLLT
	PPC_INS_TDLGT         = C.PPC_INS_TDLGT
	PPC_INS_TDU           = C.PPC_INS_TDU
	PPC_INS_TDLTI         = C.PPC_INS_TDLTI
	PPC_INS_TDEQI         = C.PPC_INS_TDEQI
	PPC_INS_TDGTI         = C.PPC_INS_TDGTI
	PPC_INS_TDNEI         = C.PPC_INS_TDNEI
	PPC_INS_TDLLTI        = C.PPC_INS_TDLLTI
	PPC_INS_TDLGTI        = C.PPC_INS_TDLGTI
	PPC_INS_TDUI          = C.PPC_INS_TDUI
	PPC_INS_TLBREHI       = C.PPC_INS_TLBREHI
	PPC_INS_TLBRELO       = C.PPC_INS_TLBRELO
	PPC_INS_TLBWEHI       = C.PPC_INS_TLBWEHI
	PPC_INS_TLBWELO       = C.PPC_INS_TLBWELO
	PPC_INS_TWLT          = C.PPC_INS_TWLT
	PPC_INS_TWEQ          = C.PPC_INS_TWEQ
	PPC_INS_TWGT          = C.PPC_INS_TWGT
	PPC_INS_TWNE          = C.PPC_INS_TWNE
	PPC_INS_TWLLT         = C.PPC_INS_TWLLT
	PPC_INS_TWLGT         = C.PPC_INS_TWLGT
	PPC_INS_TWU           = C.PPC_INS_TWU
	PPC_INS_TWLTI         = C.PPC_INS_TWLTI
	PPC_INS_TWEQI         = C.PPC_INS_TWEQI
	PPC_INS_TWGTI         = C.PPC_INS_TWGTI
	PPC_INS_TWNEI         = C.PPC_INS_TWNEI
	PPC_INS_TWLLTI        = C.PPC_INS_TWLLTI
	PPC_INS_TWLGTI        = C.PPC_INS_TWLGTI
	PPC_INS_TWUI          = C.PPC_INS_TWUI
	PPC_INS_WAITRSV       = C.PPC_INS_WAITRSV
	PPC_INS_WAITIMPL      = C.PPC_INS_WAITIMPL
	PPC_INS_XNOP          = C.PPC_INS_XNOP
	PPC_INS_XVMOVDP       = C.PPC_INS_XVMOVDP
	PPC_INS_XVMOVSP       = C.PPC_INS_XVMOVSP
	PPC_INS_XXSPLTD       = C.PPC_INS_XXSPLTD
	PPC_INS_XXMRGHD       = C.PPC_INS_XXMRGHD
	PPC_INS_XXMRGLD       = C.PPC_INS_XXMRGLD
	PPC_INS_XXSWAPD       = C.PPC_INS_XXSWAPD
	PPC_INS_BT            = C.PPC_INS_BT
	PPC_INS_BF            = C.PPC_INS_BF
	PPC_INS_BDNZT         = C.PPC_INS_BDNZT
	PPC_INS_BDNZF         = C.PPC_INS_BDNZF
	PPC_INS_BDZF          = C.PPC_INS_BDZF
	PPC_INS_BDZT          = C.PPC_INS_BDZT
	PPC_INS_BFA           = C.PPC_INS_BFA
	PPC_INS_BDNZTA        = C.PPC_INS_BDNZTA
	PPC_INS_BDNZFA        = C.PPC_INS_BDNZFA
	PPC_INS_BDZTA         = C.PPC_INS_BDZTA
	PPC_INS_BDZFA         = C.PPC_INS_BDZFA
	PPC_INS_BTCTR         = C.PPC_INS_BTCTR
	PPC_INS_BFCTR         = C.PPC_INS_BFCTR
	PPC_INS_BTCTRL        = C.PPC_INS_BTCTRL
	PPC_INS_BFCTRL        = C.PPC_INS_BFCTRL
	PPC_INS_BTL           = C.PPC_INS_BTL
	PPC_INS_BFL           = C.PPC_INS_BFL
	PPC_INS_BDNZTL        = C.PPC_INS_BDNZTL
	PPC_INS_BDNZFL        = C.PPC_INS_BDNZFL
	PPC_INS_BDZTL         = C.PPC_INS_BDZTL
	PPC_INS_BDZFL         = C.PPC_INS_BDZFL
	PPC_INS_BTLA          = C.PPC_INS_BTLA
	PPC_INS_BFLA          = C.PPC_INS_BFLA
	PPC_INS_BDNZTLA       = C.PPC_INS_BDNZTLA
	PPC_INS_BDNZFLA       = C.PPC_INS_BDNZFLA
	PPC_INS_BDZTLA        = C.PPC_INS_BDZTLA
	PPC_INS_BDZFLA        = C.PPC_INS_BDZFLA
	PPC_INS_BTLR          = C.PPC_INS_BTLR
	PPC_INS_BFLR          = C.PPC_INS_BFLR
	PPC_INS_BDNZTLR       = C.PPC_INS_BDNZTLR
	PPC_INS_BDZTLR        = C.PPC_INS_BDZTLR
	PPC_INS_BDZFLR        = C.PPC_INS_BDZFLR
	PPC_INS_BTLRL         = C.PPC_INS_BTLRL
	PPC_INS_BFLRL         = C.PPC_INS_BFLRL
	PPC_INS_BDNZTLRL      = C.PPC_INS_BDNZTLRL
	PPC_INS_BDNZFLRL      = C.PPC_INS_BDNZFLRL
	PPC_INS_BDZTLRL       = C.PPC_INS_BDZTLRL
	PPC_INS_BDZFLRL       = C.PPC_INS_BDZFLRL
	PPC_INS_QVFAND        = C.PPC_INS_QVFAND
	PPC_INS_QVFCLR        = C.PPC_INS_QVFCLR
	PPC_INS_QVFANDC       = C.PPC_INS_QVFANDC
	PPC_INS_QVFCTFB       = C.PPC_INS_QVFCTFB
	PPC_INS_QVFXOR        = C.PPC_INS_QVFXOR
	PPC_INS_QVFOR         = C.PPC_INS_QVFOR
	PPC_INS_QVFNOR        = C.PPC_INS_QVFNOR
	PPC_INS_QVFEQU        = C.PPC_INS_QVFEQU
	PPC_INS_QVFNOT        = C.PPC_INS_QVFNOT
	PPC_INS_QVFORC        = C.PPC_INS_QVFORC
	PPC_INS_QVFNAND       = C.PPC_INS_QVFNAND
	PPC_INS_QVFSET        = C.PPC_INS_QVFSET
	PPC_INS_ENDING        = C.PPC_INS_ENDING
)

// Group of PPC instructions
const (
	PPC_GRP_INVALID = C.PPC_GRP_INVALID
)

// Generic groups
const (
	PPC_GRP_JUMP = C.PPC_GRP_JUMP
)

// Architecture-specific groups
const (
	PPC_GRP_ALTIVEC   = C.PPC_GRP_ALTIVEC
	PPC_GRP_MODE32    = C.PPC_GRP_MODE32
	PPC_GRP_MODE64    = C.PPC_GRP_MODE64
	PPC_GRP_BOOKE     = C.PPC_GRP_BOOKE
	PPC_GRP_NOTBOOKE  = C.PPC_GRP_NOTBOOKE
	PPC_GRP_SPE       = C.PPC_GRP_SPE
	PPC_GRP_VSX       = C.PPC_GRP_VSX
	PPC_GRP_E500      = C.PPC_GRP_E500
	PPC_GRP_PPC4XX    = C.PPC_GRP_PPC4XX
	PPC_GRP_PPC6XX    = C.PPC_GRP_PPC6XX
	PPC_GRP_ICBT      = C.PPC_GRP_ICBT
	PPC_GRP_P8ALTIVEC = C.PPC_GRP_P8ALTIVEC
	PPC_GRP_P8VECTOR  = C.PPC_GRP_P8VECTOR
	PPC_GRP_QPX       = C.PPC_GRP_QPX
	PPC_GRP_ENDING    = C.PPC_GRP_ENDING
)
