/*
Gapstone is a Go binding for the Capstone disassembly library. For examples,
try reading the *_test.go files.

	Library Author: Nguyen Anh Quynh
	Binding Author: Ben Nagy
	License: BSD style - see LICENSE file for details
    (c) 2013 COSEINC. All Rights Reserved.

    THIS FILE WAS AUTO-GENERATED -- DO NOT EDIT!
	Command: ./genconst /Users/scottknight/work/capstone/bindings/python/capstone/
	2019-02-02T13:26:27-05:00

*/

package gapstone

// #cgo LDFLAGS: -lcapstone
// #cgo freebsd CFLAGS: -I/usr/local/include
// #cgo freebsd LDFLAGS: -L/usr/local/lib
// #include <stdlib.h>
// #include <capstone/capstone.h>
import "C"

// For Capstone Engine. AUTO-GENERATED FILE, DO NOT EDIT [arm64_const.py]
// ARM64 shift type
const (
	ARM64_SFT_INVALID = C.ARM64_SFT_INVALID
	ARM64_SFT_LSL     = C.ARM64_SFT_LSL
	ARM64_SFT_MSL     = C.ARM64_SFT_MSL
	ARM64_SFT_LSR     = C.ARM64_SFT_LSR
	ARM64_SFT_ASR     = C.ARM64_SFT_ASR
	ARM64_SFT_ROR     = C.ARM64_SFT_ROR
)

// ARM64 extender type
const (
	ARM64_EXT_INVALID = C.ARM64_EXT_INVALID
	ARM64_EXT_UXTB    = C.ARM64_EXT_UXTB
	ARM64_EXT_UXTH    = C.ARM64_EXT_UXTH
	ARM64_EXT_UXTW    = C.ARM64_EXT_UXTW
	ARM64_EXT_UXTX    = C.ARM64_EXT_UXTX
	ARM64_EXT_SXTB    = C.ARM64_EXT_SXTB
	ARM64_EXT_SXTH    = C.ARM64_EXT_SXTH
	ARM64_EXT_SXTW    = C.ARM64_EXT_SXTW
	ARM64_EXT_SXTX    = C.ARM64_EXT_SXTX
)

// ARM64 condition code
const (
	ARM64_CC_INVALID = C.ARM64_CC_INVALID
	ARM64_CC_EQ      = C.ARM64_CC_EQ
	ARM64_CC_NE      = C.ARM64_CC_NE
	ARM64_CC_HS      = C.ARM64_CC_HS
	ARM64_CC_LO      = C.ARM64_CC_LO
	ARM64_CC_MI      = C.ARM64_CC_MI
	ARM64_CC_PL      = C.ARM64_CC_PL
	ARM64_CC_VS      = C.ARM64_CC_VS
	ARM64_CC_VC      = C.ARM64_CC_VC
	ARM64_CC_HI      = C.ARM64_CC_HI
	ARM64_CC_LS      = C.ARM64_CC_LS
	ARM64_CC_GE      = C.ARM64_CC_GE
	ARM64_CC_LT      = C.ARM64_CC_LT
	ARM64_CC_GT      = C.ARM64_CC_GT
	ARM64_CC_LE      = C.ARM64_CC_LE
	ARM64_CC_AL      = C.ARM64_CC_AL
	ARM64_CC_NV      = C.ARM64_CC_NV
)

// System registers
// System registers for MRS
const (
	ARM64_SYSREG_INVALID           = C.ARM64_SYSREG_INVALID
	ARM64_SYSREG_MDCCSR_EL0        = C.ARM64_SYSREG_MDCCSR_EL0
	ARM64_SYSREG_DBGDTRRX_EL0      = C.ARM64_SYSREG_DBGDTRRX_EL0
	ARM64_SYSREG_MDRAR_EL1         = C.ARM64_SYSREG_MDRAR_EL1
	ARM64_SYSREG_OSLSR_EL1         = C.ARM64_SYSREG_OSLSR_EL1
	ARM64_SYSREG_DBGAUTHSTATUS_EL1 = C.ARM64_SYSREG_DBGAUTHSTATUS_EL1
	ARM64_SYSREG_PMCEID0_EL0       = C.ARM64_SYSREG_PMCEID0_EL0
	ARM64_SYSREG_PMCEID1_EL0       = C.ARM64_SYSREG_PMCEID1_EL0
	ARM64_SYSREG_MIDR_EL1          = C.ARM64_SYSREG_MIDR_EL1
	ARM64_SYSREG_CCSIDR_EL1        = C.ARM64_SYSREG_CCSIDR_EL1
	ARM64_SYSREG_CLIDR_EL1         = C.ARM64_SYSREG_CLIDR_EL1
	ARM64_SYSREG_CTR_EL0           = C.ARM64_SYSREG_CTR_EL0
	ARM64_SYSREG_MPIDR_EL1         = C.ARM64_SYSREG_MPIDR_EL1
	ARM64_SYSREG_REVIDR_EL1        = C.ARM64_SYSREG_REVIDR_EL1
	ARM64_SYSREG_AIDR_EL1          = C.ARM64_SYSREG_AIDR_EL1
	ARM64_SYSREG_DCZID_EL0         = C.ARM64_SYSREG_DCZID_EL0
	ARM64_SYSREG_ID_PFR0_EL1       = C.ARM64_SYSREG_ID_PFR0_EL1
	ARM64_SYSREG_ID_PFR1_EL1       = C.ARM64_SYSREG_ID_PFR1_EL1
	ARM64_SYSREG_ID_DFR0_EL1       = C.ARM64_SYSREG_ID_DFR0_EL1
	ARM64_SYSREG_ID_AFR0_EL1       = C.ARM64_SYSREG_ID_AFR0_EL1
	ARM64_SYSREG_ID_MMFR0_EL1      = C.ARM64_SYSREG_ID_MMFR0_EL1
	ARM64_SYSREG_ID_MMFR1_EL1      = C.ARM64_SYSREG_ID_MMFR1_EL1
	ARM64_SYSREG_ID_MMFR2_EL1      = C.ARM64_SYSREG_ID_MMFR2_EL1
	ARM64_SYSREG_ID_MMFR3_EL1      = C.ARM64_SYSREG_ID_MMFR3_EL1
	ARM64_SYSREG_ID_ISAR0_EL1      = C.ARM64_SYSREG_ID_ISAR0_EL1
	ARM64_SYSREG_ID_ISAR1_EL1      = C.ARM64_SYSREG_ID_ISAR1_EL1
	ARM64_SYSREG_ID_ISAR2_EL1      = C.ARM64_SYSREG_ID_ISAR2_EL1
	ARM64_SYSREG_ID_ISAR3_EL1      = C.ARM64_SYSREG_ID_ISAR3_EL1
	ARM64_SYSREG_ID_ISAR4_EL1      = C.ARM64_SYSREG_ID_ISAR4_EL1
	ARM64_SYSREG_ID_ISAR5_EL1      = C.ARM64_SYSREG_ID_ISAR5_EL1
	ARM64_SYSREG_ID_A64PFR0_EL1    = C.ARM64_SYSREG_ID_A64PFR0_EL1
	ARM64_SYSREG_ID_A64PFR1_EL1    = C.ARM64_SYSREG_ID_A64PFR1_EL1
	ARM64_SYSREG_ID_A64DFR0_EL1    = C.ARM64_SYSREG_ID_A64DFR0_EL1
	ARM64_SYSREG_ID_A64DFR1_EL1    = C.ARM64_SYSREG_ID_A64DFR1_EL1
	ARM64_SYSREG_ID_A64AFR0_EL1    = C.ARM64_SYSREG_ID_A64AFR0_EL1
	ARM64_SYSREG_ID_A64AFR1_EL1    = C.ARM64_SYSREG_ID_A64AFR1_EL1
	ARM64_SYSREG_ID_A64ISAR0_EL1   = C.ARM64_SYSREG_ID_A64ISAR0_EL1
	ARM64_SYSREG_ID_A64ISAR1_EL1   = C.ARM64_SYSREG_ID_A64ISAR1_EL1
	ARM64_SYSREG_ID_A64MMFR0_EL1   = C.ARM64_SYSREG_ID_A64MMFR0_EL1
	ARM64_SYSREG_ID_A64MMFR1_EL1   = C.ARM64_SYSREG_ID_A64MMFR1_EL1
	ARM64_SYSREG_MVFR0_EL1         = C.ARM64_SYSREG_MVFR0_EL1
	ARM64_SYSREG_MVFR1_EL1         = C.ARM64_SYSREG_MVFR1_EL1
	ARM64_SYSREG_MVFR2_EL1         = C.ARM64_SYSREG_MVFR2_EL1
	ARM64_SYSREG_RVBAR_EL1         = C.ARM64_SYSREG_RVBAR_EL1
	ARM64_SYSREG_RVBAR_EL2         = C.ARM64_SYSREG_RVBAR_EL2
	ARM64_SYSREG_RVBAR_EL3         = C.ARM64_SYSREG_RVBAR_EL3
	ARM64_SYSREG_ISR_EL1           = C.ARM64_SYSREG_ISR_EL1
	ARM64_SYSREG_CNTPCT_EL0        = C.ARM64_SYSREG_CNTPCT_EL0
	ARM64_SYSREG_CNTVCT_EL0        = C.ARM64_SYSREG_CNTVCT_EL0
	ARM64_SYSREG_TRCSTATR          = C.ARM64_SYSREG_TRCSTATR
	ARM64_SYSREG_TRCIDR8           = C.ARM64_SYSREG_TRCIDR8
	ARM64_SYSREG_TRCIDR9           = C.ARM64_SYSREG_TRCIDR9
	ARM64_SYSREG_TRCIDR10          = C.ARM64_SYSREG_TRCIDR10
	ARM64_SYSREG_TRCIDR11          = C.ARM64_SYSREG_TRCIDR11
	ARM64_SYSREG_TRCIDR12          = C.ARM64_SYSREG_TRCIDR12
	ARM64_SYSREG_TRCIDR13          = C.ARM64_SYSREG_TRCIDR13
	ARM64_SYSREG_TRCIDR0           = C.ARM64_SYSREG_TRCIDR0
	ARM64_SYSREG_TRCIDR1           = C.ARM64_SYSREG_TRCIDR1
	ARM64_SYSREG_TRCIDR2           = C.ARM64_SYSREG_TRCIDR2
	ARM64_SYSREG_TRCIDR3           = C.ARM64_SYSREG_TRCIDR3
	ARM64_SYSREG_TRCIDR4           = C.ARM64_SYSREG_TRCIDR4
	ARM64_SYSREG_TRCIDR5           = C.ARM64_SYSREG_TRCIDR5
	ARM64_SYSREG_TRCIDR6           = C.ARM64_SYSREG_TRCIDR6
	ARM64_SYSREG_TRCIDR7           = C.ARM64_SYSREG_TRCIDR7
	ARM64_SYSREG_TRCOSLSR          = C.ARM64_SYSREG_TRCOSLSR
	ARM64_SYSREG_TRCPDSR           = C.ARM64_SYSREG_TRCPDSR
	ARM64_SYSREG_TRCDEVAFF0        = C.ARM64_SYSREG_TRCDEVAFF0
	ARM64_SYSREG_TRCDEVAFF1        = C.ARM64_SYSREG_TRCDEVAFF1
	ARM64_SYSREG_TRCLSR            = C.ARM64_SYSREG_TRCLSR
	ARM64_SYSREG_TRCAUTHSTATUS     = C.ARM64_SYSREG_TRCAUTHSTATUS
	ARM64_SYSREG_TRCDEVARCH        = C.ARM64_SYSREG_TRCDEVARCH
	ARM64_SYSREG_TRCDEVID          = C.ARM64_SYSREG_TRCDEVID
	ARM64_SYSREG_TRCDEVTYPE        = C.ARM64_SYSREG_TRCDEVTYPE
	ARM64_SYSREG_TRCPIDR4          = C.ARM64_SYSREG_TRCPIDR4
	ARM64_SYSREG_TRCPIDR5          = C.ARM64_SYSREG_TRCPIDR5
	ARM64_SYSREG_TRCPIDR6          = C.ARM64_SYSREG_TRCPIDR6
	ARM64_SYSREG_TRCPIDR7          = C.ARM64_SYSREG_TRCPIDR7
	ARM64_SYSREG_TRCPIDR0          = C.ARM64_SYSREG_TRCPIDR0
	ARM64_SYSREG_TRCPIDR1          = C.ARM64_SYSREG_TRCPIDR1
	ARM64_SYSREG_TRCPIDR2          = C.ARM64_SYSREG_TRCPIDR2
	ARM64_SYSREG_TRCPIDR3          = C.ARM64_SYSREG_TRCPIDR3
	ARM64_SYSREG_TRCCIDR0          = C.ARM64_SYSREG_TRCCIDR0
	ARM64_SYSREG_TRCCIDR1          = C.ARM64_SYSREG_TRCCIDR1
	ARM64_SYSREG_TRCCIDR2          = C.ARM64_SYSREG_TRCCIDR2
	ARM64_SYSREG_TRCCIDR3          = C.ARM64_SYSREG_TRCCIDR3
	ARM64_SYSREG_ICC_IAR1_EL1      = C.ARM64_SYSREG_ICC_IAR1_EL1
	ARM64_SYSREG_ICC_IAR0_EL1      = C.ARM64_SYSREG_ICC_IAR0_EL1
	ARM64_SYSREG_ICC_HPPIR1_EL1    = C.ARM64_SYSREG_ICC_HPPIR1_EL1
	ARM64_SYSREG_ICC_HPPIR0_EL1    = C.ARM64_SYSREG_ICC_HPPIR0_EL1
	ARM64_SYSREG_ICC_RPR_EL1       = C.ARM64_SYSREG_ICC_RPR_EL1
	ARM64_SYSREG_ICH_VTR_EL2       = C.ARM64_SYSREG_ICH_VTR_EL2
	ARM64_SYSREG_ICH_EISR_EL2      = C.ARM64_SYSREG_ICH_EISR_EL2
	ARM64_SYSREG_ICH_ELSR_EL2      = C.ARM64_SYSREG_ICH_ELSR_EL2
)

// System registers for MSR
const (
	ARM64_SYSREG_DBGDTRTX_EL0   = C.ARM64_SYSREG_DBGDTRTX_EL0
	ARM64_SYSREG_OSLAR_EL1      = C.ARM64_SYSREG_OSLAR_EL1
	ARM64_SYSREG_PMSWINC_EL0    = C.ARM64_SYSREG_PMSWINC_EL0
	ARM64_SYSREG_TRCOSLAR       = C.ARM64_SYSREG_TRCOSLAR
	ARM64_SYSREG_TRCLAR         = C.ARM64_SYSREG_TRCLAR
	ARM64_SYSREG_ICC_EOIR1_EL1  = C.ARM64_SYSREG_ICC_EOIR1_EL1
	ARM64_SYSREG_ICC_EOIR0_EL1  = C.ARM64_SYSREG_ICC_EOIR0_EL1
	ARM64_SYSREG_ICC_DIR_EL1    = C.ARM64_SYSREG_ICC_DIR_EL1
	ARM64_SYSREG_ICC_SGI1R_EL1  = C.ARM64_SYSREG_ICC_SGI1R_EL1
	ARM64_SYSREG_ICC_ASGI1R_EL1 = C.ARM64_SYSREG_ICC_ASGI1R_EL1
	ARM64_SYSREG_ICC_SGI0R_EL1  = C.ARM64_SYSREG_ICC_SGI0R_EL1
)

// System PState Field (MSR instruction)
const (
	ARM64_PSTATE_INVALID = C.ARM64_PSTATE_INVALID
	ARM64_PSTATE_SPSEL   = C.ARM64_PSTATE_SPSEL
	ARM64_PSTATE_DAIFSET = C.ARM64_PSTATE_DAIFSET
	ARM64_PSTATE_DAIFCLR = C.ARM64_PSTATE_DAIFCLR
)

// Vector arrangement specifier (for FloatingPoint/Advanced SIMD insn)
const (
	ARM64_VAS_INVALID = C.ARM64_VAS_INVALID
	ARM64_VAS_8B      = C.ARM64_VAS_8B
	ARM64_VAS_16B     = C.ARM64_VAS_16B
	ARM64_VAS_4H      = C.ARM64_VAS_4H
	ARM64_VAS_8H      = C.ARM64_VAS_8H
	ARM64_VAS_2S      = C.ARM64_VAS_2S
	ARM64_VAS_4S      = C.ARM64_VAS_4S
	ARM64_VAS_1D      = C.ARM64_VAS_1D
	ARM64_VAS_2D      = C.ARM64_VAS_2D
	ARM64_VAS_1Q      = C.ARM64_VAS_1Q
)

// Vector element size specifier
const (
	ARM64_VESS_INVALID = C.ARM64_VESS_INVALID
	ARM64_VESS_B       = C.ARM64_VESS_B
	ARM64_VESS_H       = C.ARM64_VESS_H
	ARM64_VESS_S       = C.ARM64_VESS_S
	ARM64_VESS_D       = C.ARM64_VESS_D
)

// Memory barrier operands
const (
	ARM64_BARRIER_INVALID = C.ARM64_BARRIER_INVALID
	ARM64_BARRIER_OSHLD   = C.ARM64_BARRIER_OSHLD
	ARM64_BARRIER_OSHST   = C.ARM64_BARRIER_OSHST
	ARM64_BARRIER_OSH     = C.ARM64_BARRIER_OSH
	ARM64_BARRIER_NSHLD   = C.ARM64_BARRIER_NSHLD
	ARM64_BARRIER_NSHST   = C.ARM64_BARRIER_NSHST
	ARM64_BARRIER_NSH     = C.ARM64_BARRIER_NSH
	ARM64_BARRIER_ISHLD   = C.ARM64_BARRIER_ISHLD
	ARM64_BARRIER_ISHST   = C.ARM64_BARRIER_ISHST
	ARM64_BARRIER_ISH     = C.ARM64_BARRIER_ISH
	ARM64_BARRIER_LD      = C.ARM64_BARRIER_LD
	ARM64_BARRIER_ST      = C.ARM64_BARRIER_ST
	ARM64_BARRIER_SY      = C.ARM64_BARRIER_SY
)

// Operand type for instruction's operands
const (
	ARM64_OP_INVALID  = C.ARM64_OP_INVALID
	ARM64_OP_REG      = C.ARM64_OP_REG
	ARM64_OP_IMM      = C.ARM64_OP_IMM
	ARM64_OP_MEM      = C.ARM64_OP_MEM
	ARM64_OP_FP       = C.ARM64_OP_FP
	ARM64_OP_CIMM     = C.ARM64_OP_CIMM
	ARM64_OP_REG_MRS  = C.ARM64_OP_REG_MRS
	ARM64_OP_REG_MSR  = C.ARM64_OP_REG_MSR
	ARM64_OP_PSTATE   = C.ARM64_OP_PSTATE
	ARM64_OP_SYS      = C.ARM64_OP_SYS
	ARM64_OP_PREFETCH = C.ARM64_OP_PREFETCH
	ARM64_OP_BARRIER  = C.ARM64_OP_BARRIER
)

// TLBI operations
const (
	ARM64_TLBI_INVALID      = C.ARM64_TLBI_INVALID
	ARM64_TLBI_VMALLE1IS    = C.ARM64_TLBI_VMALLE1IS
	ARM64_TLBI_VAE1IS       = C.ARM64_TLBI_VAE1IS
	ARM64_TLBI_ASIDE1IS     = C.ARM64_TLBI_ASIDE1IS
	ARM64_TLBI_VAAE1IS      = C.ARM64_TLBI_VAAE1IS
	ARM64_TLBI_VALE1IS      = C.ARM64_TLBI_VALE1IS
	ARM64_TLBI_VAALE1IS     = C.ARM64_TLBI_VAALE1IS
	ARM64_TLBI_ALLE2IS      = C.ARM64_TLBI_ALLE2IS
	ARM64_TLBI_VAE2IS       = C.ARM64_TLBI_VAE2IS
	ARM64_TLBI_ALLE1IS      = C.ARM64_TLBI_ALLE1IS
	ARM64_TLBI_VALE2IS      = C.ARM64_TLBI_VALE2IS
	ARM64_TLBI_VMALLS12E1IS = C.ARM64_TLBI_VMALLS12E1IS
	ARM64_TLBI_ALLE3IS      = C.ARM64_TLBI_ALLE3IS
	ARM64_TLBI_VAE3IS       = C.ARM64_TLBI_VAE3IS
	ARM64_TLBI_VALE3IS      = C.ARM64_TLBI_VALE3IS
	ARM64_TLBI_IPAS2E1IS    = C.ARM64_TLBI_IPAS2E1IS
	ARM64_TLBI_IPAS2LE1IS   = C.ARM64_TLBI_IPAS2LE1IS
	ARM64_TLBI_IPAS2E1      = C.ARM64_TLBI_IPAS2E1
	ARM64_TLBI_IPAS2LE1     = C.ARM64_TLBI_IPAS2LE1
	ARM64_TLBI_VMALLE1      = C.ARM64_TLBI_VMALLE1
	ARM64_TLBI_VAE1         = C.ARM64_TLBI_VAE1
	ARM64_TLBI_ASIDE1       = C.ARM64_TLBI_ASIDE1
	ARM64_TLBI_VAAE1        = C.ARM64_TLBI_VAAE1
	ARM64_TLBI_VALE1        = C.ARM64_TLBI_VALE1
	ARM64_TLBI_VAALE1       = C.ARM64_TLBI_VAALE1
	ARM64_TLBI_ALLE2        = C.ARM64_TLBI_ALLE2
	ARM64_TLBI_VAE2         = C.ARM64_TLBI_VAE2
	ARM64_TLBI_ALLE1        = C.ARM64_TLBI_ALLE1
	ARM64_TLBI_VALE2        = C.ARM64_TLBI_VALE2
	ARM64_TLBI_VMALLS12E1   = C.ARM64_TLBI_VMALLS12E1
	ARM64_TLBI_ALLE3        = C.ARM64_TLBI_ALLE3
	ARM64_TLBI_VAE3         = C.ARM64_TLBI_VAE3
	ARM64_TLBI_VALE3        = C.ARM64_TLBI_VALE3
)

// AT operations
const (
	ARM64_AT_S1E1R  = C.ARM64_AT_S1E1R
	ARM64_AT_S1E1W  = C.ARM64_AT_S1E1W
	ARM64_AT_S1E0R  = C.ARM64_AT_S1E0R
	ARM64_AT_S1E0W  = C.ARM64_AT_S1E0W
	ARM64_AT_S1E2R  = C.ARM64_AT_S1E2R
	ARM64_AT_S1E2W  = C.ARM64_AT_S1E2W
	ARM64_AT_S12E1R = C.ARM64_AT_S12E1R
	ARM64_AT_S12E1W = C.ARM64_AT_S12E1W
	ARM64_AT_S12E0R = C.ARM64_AT_S12E0R
	ARM64_AT_S12E0W = C.ARM64_AT_S12E0W
	ARM64_AT_S1E3R  = C.ARM64_AT_S1E3R
	ARM64_AT_S1E3W  = C.ARM64_AT_S1E3W
)

// DC operations
const (
	ARM64_DC_INVALID = C.ARM64_DC_INVALID
	ARM64_DC_ZVA     = C.ARM64_DC_ZVA
	ARM64_DC_IVAC    = C.ARM64_DC_IVAC
	ARM64_DC_ISW     = C.ARM64_DC_ISW
	ARM64_DC_CVAC    = C.ARM64_DC_CVAC
	ARM64_DC_CSW     = C.ARM64_DC_CSW
	ARM64_DC_CVAU    = C.ARM64_DC_CVAU
	ARM64_DC_CIVAC   = C.ARM64_DC_CIVAC
	ARM64_DC_CISW    = C.ARM64_DC_CISW
)

// IC operations
const (
	ARM64_IC_INVALID = C.ARM64_IC_INVALID
	ARM64_IC_IALLUIS = C.ARM64_IC_IALLUIS
	ARM64_IC_IALLU   = C.ARM64_IC_IALLU
	ARM64_IC_IVAU    = C.ARM64_IC_IVAU
)

// Prefetch operations (PRFM)
const (
	ARM64_PRFM_INVALID   = C.ARM64_PRFM_INVALID
	ARM64_PRFM_PLDL1KEEP = C.ARM64_PRFM_PLDL1KEEP
	ARM64_PRFM_PLDL1STRM = C.ARM64_PRFM_PLDL1STRM
	ARM64_PRFM_PLDL2KEEP = C.ARM64_PRFM_PLDL2KEEP
	ARM64_PRFM_PLDL2STRM = C.ARM64_PRFM_PLDL2STRM
	ARM64_PRFM_PLDL3KEEP = C.ARM64_PRFM_PLDL3KEEP
	ARM64_PRFM_PLDL3STRM = C.ARM64_PRFM_PLDL3STRM
	ARM64_PRFM_PLIL1KEEP = C.ARM64_PRFM_PLIL1KEEP
	ARM64_PRFM_PLIL1STRM = C.ARM64_PRFM_PLIL1STRM
	ARM64_PRFM_PLIL2KEEP = C.ARM64_PRFM_PLIL2KEEP
	ARM64_PRFM_PLIL2STRM = C.ARM64_PRFM_PLIL2STRM
	ARM64_PRFM_PLIL3KEEP = C.ARM64_PRFM_PLIL3KEEP
	ARM64_PRFM_PLIL3STRM = C.ARM64_PRFM_PLIL3STRM
	ARM64_PRFM_PSTL1KEEP = C.ARM64_PRFM_PSTL1KEEP
	ARM64_PRFM_PSTL1STRM = C.ARM64_PRFM_PSTL1STRM
	ARM64_PRFM_PSTL2KEEP = C.ARM64_PRFM_PSTL2KEEP
	ARM64_PRFM_PSTL2STRM = C.ARM64_PRFM_PSTL2STRM
	ARM64_PRFM_PSTL3KEEP = C.ARM64_PRFM_PSTL3KEEP
	ARM64_PRFM_PSTL3STRM = C.ARM64_PRFM_PSTL3STRM
)

// ARM64 registers
const (
	ARM64_REG_INVALID = C.ARM64_REG_INVALID
	ARM64_REG_X29     = C.ARM64_REG_X29
	ARM64_REG_X30     = C.ARM64_REG_X30
	ARM64_REG_NZCV    = C.ARM64_REG_NZCV
	ARM64_REG_SP      = C.ARM64_REG_SP
	ARM64_REG_WSP     = C.ARM64_REG_WSP
	ARM64_REG_WZR     = C.ARM64_REG_WZR
	ARM64_REG_XZR     = C.ARM64_REG_XZR
	ARM64_REG_B0      = C.ARM64_REG_B0
	ARM64_REG_B1      = C.ARM64_REG_B1
	ARM64_REG_B2      = C.ARM64_REG_B2
	ARM64_REG_B3      = C.ARM64_REG_B3
	ARM64_REG_B4      = C.ARM64_REG_B4
	ARM64_REG_B5      = C.ARM64_REG_B5
	ARM64_REG_B6      = C.ARM64_REG_B6
	ARM64_REG_B7      = C.ARM64_REG_B7
	ARM64_REG_B8      = C.ARM64_REG_B8
	ARM64_REG_B9      = C.ARM64_REG_B9
	ARM64_REG_B10     = C.ARM64_REG_B10
	ARM64_REG_B11     = C.ARM64_REG_B11
	ARM64_REG_B12     = C.ARM64_REG_B12
	ARM64_REG_B13     = C.ARM64_REG_B13
	ARM64_REG_B14     = C.ARM64_REG_B14
	ARM64_REG_B15     = C.ARM64_REG_B15
	ARM64_REG_B16     = C.ARM64_REG_B16
	ARM64_REG_B17     = C.ARM64_REG_B17
	ARM64_REG_B18     = C.ARM64_REG_B18
	ARM64_REG_B19     = C.ARM64_REG_B19
	ARM64_REG_B20     = C.ARM64_REG_B20
	ARM64_REG_B21     = C.ARM64_REG_B21
	ARM64_REG_B22     = C.ARM64_REG_B22
	ARM64_REG_B23     = C.ARM64_REG_B23
	ARM64_REG_B24     = C.ARM64_REG_B24
	ARM64_REG_B25     = C.ARM64_REG_B25
	ARM64_REG_B26     = C.ARM64_REG_B26
	ARM64_REG_B27     = C.ARM64_REG_B27
	ARM64_REG_B28     = C.ARM64_REG_B28
	ARM64_REG_B29     = C.ARM64_REG_B29
	ARM64_REG_B30     = C.ARM64_REG_B30
	ARM64_REG_B31     = C.ARM64_REG_B31
	ARM64_REG_D0      = C.ARM64_REG_D0
	ARM64_REG_D1      = C.ARM64_REG_D1
	ARM64_REG_D2      = C.ARM64_REG_D2
	ARM64_REG_D3      = C.ARM64_REG_D3
	ARM64_REG_D4      = C.ARM64_REG_D4
	ARM64_REG_D5      = C.ARM64_REG_D5
	ARM64_REG_D6      = C.ARM64_REG_D6
	ARM64_REG_D7      = C.ARM64_REG_D7
	ARM64_REG_D8      = C.ARM64_REG_D8
	ARM64_REG_D9      = C.ARM64_REG_D9
	ARM64_REG_D10     = C.ARM64_REG_D10
	ARM64_REG_D11     = C.ARM64_REG_D11
	ARM64_REG_D12     = C.ARM64_REG_D12
	ARM64_REG_D13     = C.ARM64_REG_D13
	ARM64_REG_D14     = C.ARM64_REG_D14
	ARM64_REG_D15     = C.ARM64_REG_D15
	ARM64_REG_D16     = C.ARM64_REG_D16
	ARM64_REG_D17     = C.ARM64_REG_D17
	ARM64_REG_D18     = C.ARM64_REG_D18
	ARM64_REG_D19     = C.ARM64_REG_D19
	ARM64_REG_D20     = C.ARM64_REG_D20
	ARM64_REG_D21     = C.ARM64_REG_D21
	ARM64_REG_D22     = C.ARM64_REG_D22
	ARM64_REG_D23     = C.ARM64_REG_D23
	ARM64_REG_D24     = C.ARM64_REG_D24
	ARM64_REG_D25     = C.ARM64_REG_D25
	ARM64_REG_D26     = C.ARM64_REG_D26
	ARM64_REG_D27     = C.ARM64_REG_D27
	ARM64_REG_D28     = C.ARM64_REG_D28
	ARM64_REG_D29     = C.ARM64_REG_D29
	ARM64_REG_D30     = C.ARM64_REG_D30
	ARM64_REG_D31     = C.ARM64_REG_D31
	ARM64_REG_H0      = C.ARM64_REG_H0
	ARM64_REG_H1      = C.ARM64_REG_H1
	ARM64_REG_H2      = C.ARM64_REG_H2
	ARM64_REG_H3      = C.ARM64_REG_H3
	ARM64_REG_H4      = C.ARM64_REG_H4
	ARM64_REG_H5      = C.ARM64_REG_H5
	ARM64_REG_H6      = C.ARM64_REG_H6
	ARM64_REG_H7      = C.ARM64_REG_H7
	ARM64_REG_H8      = C.ARM64_REG_H8
	ARM64_REG_H9      = C.ARM64_REG_H9
	ARM64_REG_H10     = C.ARM64_REG_H10
	ARM64_REG_H11     = C.ARM64_REG_H11
	ARM64_REG_H12     = C.ARM64_REG_H12
	ARM64_REG_H13     = C.ARM64_REG_H13
	ARM64_REG_H14     = C.ARM64_REG_H14
	ARM64_REG_H15     = C.ARM64_REG_H15
	ARM64_REG_H16     = C.ARM64_REG_H16
	ARM64_REG_H17     = C.ARM64_REG_H17
	ARM64_REG_H18     = C.ARM64_REG_H18
	ARM64_REG_H19     = C.ARM64_REG_H19
	ARM64_REG_H20     = C.ARM64_REG_H20
	ARM64_REG_H21     = C.ARM64_REG_H21
	ARM64_REG_H22     = C.ARM64_REG_H22
	ARM64_REG_H23     = C.ARM64_REG_H23
	ARM64_REG_H24     = C.ARM64_REG_H24
	ARM64_REG_H25     = C.ARM64_REG_H25
	ARM64_REG_H26     = C.ARM64_REG_H26
	ARM64_REG_H27     = C.ARM64_REG_H27
	ARM64_REG_H28     = C.ARM64_REG_H28
	ARM64_REG_H29     = C.ARM64_REG_H29
	ARM64_REG_H30     = C.ARM64_REG_H30
	ARM64_REG_H31     = C.ARM64_REG_H31
	ARM64_REG_Q0      = C.ARM64_REG_Q0
	ARM64_REG_Q1      = C.ARM64_REG_Q1
	ARM64_REG_Q2      = C.ARM64_REG_Q2
	ARM64_REG_Q3      = C.ARM64_REG_Q3
	ARM64_REG_Q4      = C.ARM64_REG_Q4
	ARM64_REG_Q5      = C.ARM64_REG_Q5
	ARM64_REG_Q6      = C.ARM64_REG_Q6
	ARM64_REG_Q7      = C.ARM64_REG_Q7
	ARM64_REG_Q8      = C.ARM64_REG_Q8
	ARM64_REG_Q9      = C.ARM64_REG_Q9
	ARM64_REG_Q10     = C.ARM64_REG_Q10
	ARM64_REG_Q11     = C.ARM64_REG_Q11
	ARM64_REG_Q12     = C.ARM64_REG_Q12
	ARM64_REG_Q13     = C.ARM64_REG_Q13
	ARM64_REG_Q14     = C.ARM64_REG_Q14
	ARM64_REG_Q15     = C.ARM64_REG_Q15
	ARM64_REG_Q16     = C.ARM64_REG_Q16
	ARM64_REG_Q17     = C.ARM64_REG_Q17
	ARM64_REG_Q18     = C.ARM64_REG_Q18
	ARM64_REG_Q19     = C.ARM64_REG_Q19
	ARM64_REG_Q20     = C.ARM64_REG_Q20
	ARM64_REG_Q21     = C.ARM64_REG_Q21
	ARM64_REG_Q22     = C.ARM64_REG_Q22
	ARM64_REG_Q23     = C.ARM64_REG_Q23
	ARM64_REG_Q24     = C.ARM64_REG_Q24
	ARM64_REG_Q25     = C.ARM64_REG_Q25
	ARM64_REG_Q26     = C.ARM64_REG_Q26
	ARM64_REG_Q27     = C.ARM64_REG_Q27
	ARM64_REG_Q28     = C.ARM64_REG_Q28
	ARM64_REG_Q29     = C.ARM64_REG_Q29
	ARM64_REG_Q30     = C.ARM64_REG_Q30
	ARM64_REG_Q31     = C.ARM64_REG_Q31
	ARM64_REG_S0      = C.ARM64_REG_S0
	ARM64_REG_S1      = C.ARM64_REG_S1
	ARM64_REG_S2      = C.ARM64_REG_S2
	ARM64_REG_S3      = C.ARM64_REG_S3
	ARM64_REG_S4      = C.ARM64_REG_S4
	ARM64_REG_S5      = C.ARM64_REG_S5
	ARM64_REG_S6      = C.ARM64_REG_S6
	ARM64_REG_S7      = C.ARM64_REG_S7
	ARM64_REG_S8      = C.ARM64_REG_S8
	ARM64_REG_S9      = C.ARM64_REG_S9
	ARM64_REG_S10     = C.ARM64_REG_S10
	ARM64_REG_S11     = C.ARM64_REG_S11
	ARM64_REG_S12     = C.ARM64_REG_S12
	ARM64_REG_S13     = C.ARM64_REG_S13
	ARM64_REG_S14     = C.ARM64_REG_S14
	ARM64_REG_S15     = C.ARM64_REG_S15
	ARM64_REG_S16     = C.ARM64_REG_S16
	ARM64_REG_S17     = C.ARM64_REG_S17
	ARM64_REG_S18     = C.ARM64_REG_S18
	ARM64_REG_S19     = C.ARM64_REG_S19
	ARM64_REG_S20     = C.ARM64_REG_S20
	ARM64_REG_S21     = C.ARM64_REG_S21
	ARM64_REG_S22     = C.ARM64_REG_S22
	ARM64_REG_S23     = C.ARM64_REG_S23
	ARM64_REG_S24     = C.ARM64_REG_S24
	ARM64_REG_S25     = C.ARM64_REG_S25
	ARM64_REG_S26     = C.ARM64_REG_S26
	ARM64_REG_S27     = C.ARM64_REG_S27
	ARM64_REG_S28     = C.ARM64_REG_S28
	ARM64_REG_S29     = C.ARM64_REG_S29
	ARM64_REG_S30     = C.ARM64_REG_S30
	ARM64_REG_S31     = C.ARM64_REG_S31
	ARM64_REG_W0      = C.ARM64_REG_W0
	ARM64_REG_W1      = C.ARM64_REG_W1
	ARM64_REG_W2      = C.ARM64_REG_W2
	ARM64_REG_W3      = C.ARM64_REG_W3
	ARM64_REG_W4      = C.ARM64_REG_W4
	ARM64_REG_W5      = C.ARM64_REG_W5
	ARM64_REG_W6      = C.ARM64_REG_W6
	ARM64_REG_W7      = C.ARM64_REG_W7
	ARM64_REG_W8      = C.ARM64_REG_W8
	ARM64_REG_W9      = C.ARM64_REG_W9
	ARM64_REG_W10     = C.ARM64_REG_W10
	ARM64_REG_W11     = C.ARM64_REG_W11
	ARM64_REG_W12     = C.ARM64_REG_W12
	ARM64_REG_W13     = C.ARM64_REG_W13
	ARM64_REG_W14     = C.ARM64_REG_W14
	ARM64_REG_W15     = C.ARM64_REG_W15
	ARM64_REG_W16     = C.ARM64_REG_W16
	ARM64_REG_W17     = C.ARM64_REG_W17
	ARM64_REG_W18     = C.ARM64_REG_W18
	ARM64_REG_W19     = C.ARM64_REG_W19
	ARM64_REG_W20     = C.ARM64_REG_W20
	ARM64_REG_W21     = C.ARM64_REG_W21
	ARM64_REG_W22     = C.ARM64_REG_W22
	ARM64_REG_W23     = C.ARM64_REG_W23
	ARM64_REG_W24     = C.ARM64_REG_W24
	ARM64_REG_W25     = C.ARM64_REG_W25
	ARM64_REG_W26     = C.ARM64_REG_W26
	ARM64_REG_W27     = C.ARM64_REG_W27
	ARM64_REG_W28     = C.ARM64_REG_W28
	ARM64_REG_W29     = C.ARM64_REG_W29
	ARM64_REG_W30     = C.ARM64_REG_W30
	ARM64_REG_X0      = C.ARM64_REG_X0
	ARM64_REG_X1      = C.ARM64_REG_X1
	ARM64_REG_X2      = C.ARM64_REG_X2
	ARM64_REG_X3      = C.ARM64_REG_X3
	ARM64_REG_X4      = C.ARM64_REG_X4
	ARM64_REG_X5      = C.ARM64_REG_X5
	ARM64_REG_X6      = C.ARM64_REG_X6
	ARM64_REG_X7      = C.ARM64_REG_X7
	ARM64_REG_X8      = C.ARM64_REG_X8
	ARM64_REG_X9      = C.ARM64_REG_X9
	ARM64_REG_X10     = C.ARM64_REG_X10
	ARM64_REG_X11     = C.ARM64_REG_X11
	ARM64_REG_X12     = C.ARM64_REG_X12
	ARM64_REG_X13     = C.ARM64_REG_X13
	ARM64_REG_X14     = C.ARM64_REG_X14
	ARM64_REG_X15     = C.ARM64_REG_X15
	ARM64_REG_X16     = C.ARM64_REG_X16
	ARM64_REG_X17     = C.ARM64_REG_X17
	ARM64_REG_X18     = C.ARM64_REG_X18
	ARM64_REG_X19     = C.ARM64_REG_X19
	ARM64_REG_X20     = C.ARM64_REG_X20
	ARM64_REG_X21     = C.ARM64_REG_X21
	ARM64_REG_X22     = C.ARM64_REG_X22
	ARM64_REG_X23     = C.ARM64_REG_X23
	ARM64_REG_X24     = C.ARM64_REG_X24
	ARM64_REG_X25     = C.ARM64_REG_X25
	ARM64_REG_X26     = C.ARM64_REG_X26
	ARM64_REG_X27     = C.ARM64_REG_X27
	ARM64_REG_X28     = C.ARM64_REG_X28
	ARM64_REG_V0      = C.ARM64_REG_V0
	ARM64_REG_V1      = C.ARM64_REG_V1
	ARM64_REG_V2      = C.ARM64_REG_V2
	ARM64_REG_V3      = C.ARM64_REG_V3
	ARM64_REG_V4      = C.ARM64_REG_V4
	ARM64_REG_V5      = C.ARM64_REG_V5
	ARM64_REG_V6      = C.ARM64_REG_V6
	ARM64_REG_V7      = C.ARM64_REG_V7
	ARM64_REG_V8      = C.ARM64_REG_V8
	ARM64_REG_V9      = C.ARM64_REG_V9
	ARM64_REG_V10     = C.ARM64_REG_V10
	ARM64_REG_V11     = C.ARM64_REG_V11
	ARM64_REG_V12     = C.ARM64_REG_V12
	ARM64_REG_V13     = C.ARM64_REG_V13
	ARM64_REG_V14     = C.ARM64_REG_V14
	ARM64_REG_V15     = C.ARM64_REG_V15
	ARM64_REG_V16     = C.ARM64_REG_V16
	ARM64_REG_V17     = C.ARM64_REG_V17
	ARM64_REG_V18     = C.ARM64_REG_V18
	ARM64_REG_V19     = C.ARM64_REG_V19
	ARM64_REG_V20     = C.ARM64_REG_V20
	ARM64_REG_V21     = C.ARM64_REG_V21
	ARM64_REG_V22     = C.ARM64_REG_V22
	ARM64_REG_V23     = C.ARM64_REG_V23
	ARM64_REG_V24     = C.ARM64_REG_V24
	ARM64_REG_V25     = C.ARM64_REG_V25
	ARM64_REG_V26     = C.ARM64_REG_V26
	ARM64_REG_V27     = C.ARM64_REG_V27
	ARM64_REG_V28     = C.ARM64_REG_V28
	ARM64_REG_V29     = C.ARM64_REG_V29
	ARM64_REG_V30     = C.ARM64_REG_V30
	ARM64_REG_V31     = C.ARM64_REG_V31
	ARM64_REG_ENDING  = C.ARM64_REG_ENDING
)

// alias registers
const (
	ARM64_REG_IP1 = C.ARM64_REG_IP1
	ARM64_REG_IP0 = C.ARM64_REG_IP0
	ARM64_REG_FP  = C.ARM64_REG_FP
	ARM64_REG_LR  = C.ARM64_REG_LR
)

// ARM64 instruction
const (
	ARM64_INS_INVALID   = C.ARM64_INS_INVALID
	ARM64_INS_ABS       = C.ARM64_INS_ABS
	ARM64_INS_ADC       = C.ARM64_INS_ADC
	ARM64_INS_ADDHN     = C.ARM64_INS_ADDHN
	ARM64_INS_ADDHN2    = C.ARM64_INS_ADDHN2
	ARM64_INS_ADDP      = C.ARM64_INS_ADDP
	ARM64_INS_ADD       = C.ARM64_INS_ADD
	ARM64_INS_ADDV      = C.ARM64_INS_ADDV
	ARM64_INS_ADR       = C.ARM64_INS_ADR
	ARM64_INS_ADRP      = C.ARM64_INS_ADRP
	ARM64_INS_AESD      = C.ARM64_INS_AESD
	ARM64_INS_AESE      = C.ARM64_INS_AESE
	ARM64_INS_AESIMC    = C.ARM64_INS_AESIMC
	ARM64_INS_AESMC     = C.ARM64_INS_AESMC
	ARM64_INS_AND       = C.ARM64_INS_AND
	ARM64_INS_ASR       = C.ARM64_INS_ASR
	ARM64_INS_B         = C.ARM64_INS_B
	ARM64_INS_BFM       = C.ARM64_INS_BFM
	ARM64_INS_BIC       = C.ARM64_INS_BIC
	ARM64_INS_BIF       = C.ARM64_INS_BIF
	ARM64_INS_BIT       = C.ARM64_INS_BIT
	ARM64_INS_BL        = C.ARM64_INS_BL
	ARM64_INS_BLR       = C.ARM64_INS_BLR
	ARM64_INS_BR        = C.ARM64_INS_BR
	ARM64_INS_BRK       = C.ARM64_INS_BRK
	ARM64_INS_BSL       = C.ARM64_INS_BSL
	ARM64_INS_CBNZ      = C.ARM64_INS_CBNZ
	ARM64_INS_CBZ       = C.ARM64_INS_CBZ
	ARM64_INS_CCMN      = C.ARM64_INS_CCMN
	ARM64_INS_CCMP      = C.ARM64_INS_CCMP
	ARM64_INS_CLREX     = C.ARM64_INS_CLREX
	ARM64_INS_CLS       = C.ARM64_INS_CLS
	ARM64_INS_CLZ       = C.ARM64_INS_CLZ
	ARM64_INS_CMEQ      = C.ARM64_INS_CMEQ
	ARM64_INS_CMGE      = C.ARM64_INS_CMGE
	ARM64_INS_CMGT      = C.ARM64_INS_CMGT
	ARM64_INS_CMHI      = C.ARM64_INS_CMHI
	ARM64_INS_CMHS      = C.ARM64_INS_CMHS
	ARM64_INS_CMLE      = C.ARM64_INS_CMLE
	ARM64_INS_CMLT      = C.ARM64_INS_CMLT
	ARM64_INS_CMTST     = C.ARM64_INS_CMTST
	ARM64_INS_CNT       = C.ARM64_INS_CNT
	ARM64_INS_MOV       = C.ARM64_INS_MOV
	ARM64_INS_CRC32B    = C.ARM64_INS_CRC32B
	ARM64_INS_CRC32CB   = C.ARM64_INS_CRC32CB
	ARM64_INS_CRC32CH   = C.ARM64_INS_CRC32CH
	ARM64_INS_CRC32CW   = C.ARM64_INS_CRC32CW
	ARM64_INS_CRC32CX   = C.ARM64_INS_CRC32CX
	ARM64_INS_CRC32H    = C.ARM64_INS_CRC32H
	ARM64_INS_CRC32W    = C.ARM64_INS_CRC32W
	ARM64_INS_CRC32X    = C.ARM64_INS_CRC32X
	ARM64_INS_CSEL      = C.ARM64_INS_CSEL
	ARM64_INS_CSINC     = C.ARM64_INS_CSINC
	ARM64_INS_CSINV     = C.ARM64_INS_CSINV
	ARM64_INS_CSNEG     = C.ARM64_INS_CSNEG
	ARM64_INS_DCPS1     = C.ARM64_INS_DCPS1
	ARM64_INS_DCPS2     = C.ARM64_INS_DCPS2
	ARM64_INS_DCPS3     = C.ARM64_INS_DCPS3
	ARM64_INS_DMB       = C.ARM64_INS_DMB
	ARM64_INS_DRPS      = C.ARM64_INS_DRPS
	ARM64_INS_DSB       = C.ARM64_INS_DSB
	ARM64_INS_DUP       = C.ARM64_INS_DUP
	ARM64_INS_EON       = C.ARM64_INS_EON
	ARM64_INS_EOR       = C.ARM64_INS_EOR
	ARM64_INS_ERET      = C.ARM64_INS_ERET
	ARM64_INS_EXTR      = C.ARM64_INS_EXTR
	ARM64_INS_EXT       = C.ARM64_INS_EXT
	ARM64_INS_FABD      = C.ARM64_INS_FABD
	ARM64_INS_FABS      = C.ARM64_INS_FABS
	ARM64_INS_FACGE     = C.ARM64_INS_FACGE
	ARM64_INS_FACGT     = C.ARM64_INS_FACGT
	ARM64_INS_FADD      = C.ARM64_INS_FADD
	ARM64_INS_FADDP     = C.ARM64_INS_FADDP
	ARM64_INS_FCCMP     = C.ARM64_INS_FCCMP
	ARM64_INS_FCCMPE    = C.ARM64_INS_FCCMPE
	ARM64_INS_FCMEQ     = C.ARM64_INS_FCMEQ
	ARM64_INS_FCMGE     = C.ARM64_INS_FCMGE
	ARM64_INS_FCMGT     = C.ARM64_INS_FCMGT
	ARM64_INS_FCMLE     = C.ARM64_INS_FCMLE
	ARM64_INS_FCMLT     = C.ARM64_INS_FCMLT
	ARM64_INS_FCMP      = C.ARM64_INS_FCMP
	ARM64_INS_FCMPE     = C.ARM64_INS_FCMPE
	ARM64_INS_FCSEL     = C.ARM64_INS_FCSEL
	ARM64_INS_FCVTAS    = C.ARM64_INS_FCVTAS
	ARM64_INS_FCVTAU    = C.ARM64_INS_FCVTAU
	ARM64_INS_FCVT      = C.ARM64_INS_FCVT
	ARM64_INS_FCVTL     = C.ARM64_INS_FCVTL
	ARM64_INS_FCVTL2    = C.ARM64_INS_FCVTL2
	ARM64_INS_FCVTMS    = C.ARM64_INS_FCVTMS
	ARM64_INS_FCVTMU    = C.ARM64_INS_FCVTMU
	ARM64_INS_FCVTNS    = C.ARM64_INS_FCVTNS
	ARM64_INS_FCVTNU    = C.ARM64_INS_FCVTNU
	ARM64_INS_FCVTN     = C.ARM64_INS_FCVTN
	ARM64_INS_FCVTN2    = C.ARM64_INS_FCVTN2
	ARM64_INS_FCVTPS    = C.ARM64_INS_FCVTPS
	ARM64_INS_FCVTPU    = C.ARM64_INS_FCVTPU
	ARM64_INS_FCVTXN    = C.ARM64_INS_FCVTXN
	ARM64_INS_FCVTXN2   = C.ARM64_INS_FCVTXN2
	ARM64_INS_FCVTZS    = C.ARM64_INS_FCVTZS
	ARM64_INS_FCVTZU    = C.ARM64_INS_FCVTZU
	ARM64_INS_FDIV      = C.ARM64_INS_FDIV
	ARM64_INS_FMADD     = C.ARM64_INS_FMADD
	ARM64_INS_FMAX      = C.ARM64_INS_FMAX
	ARM64_INS_FMAXNM    = C.ARM64_INS_FMAXNM
	ARM64_INS_FMAXNMP   = C.ARM64_INS_FMAXNMP
	ARM64_INS_FMAXNMV   = C.ARM64_INS_FMAXNMV
	ARM64_INS_FMAXP     = C.ARM64_INS_FMAXP
	ARM64_INS_FMAXV     = C.ARM64_INS_FMAXV
	ARM64_INS_FMIN      = C.ARM64_INS_FMIN
	ARM64_INS_FMINNM    = C.ARM64_INS_FMINNM
	ARM64_INS_FMINNMP   = C.ARM64_INS_FMINNMP
	ARM64_INS_FMINNMV   = C.ARM64_INS_FMINNMV
	ARM64_INS_FMINP     = C.ARM64_INS_FMINP
	ARM64_INS_FMINV     = C.ARM64_INS_FMINV
	ARM64_INS_FMLA      = C.ARM64_INS_FMLA
	ARM64_INS_FMLS      = C.ARM64_INS_FMLS
	ARM64_INS_FMOV      = C.ARM64_INS_FMOV
	ARM64_INS_FMSUB     = C.ARM64_INS_FMSUB
	ARM64_INS_FMUL      = C.ARM64_INS_FMUL
	ARM64_INS_FMULX     = C.ARM64_INS_FMULX
	ARM64_INS_FNEG      = C.ARM64_INS_FNEG
	ARM64_INS_FNMADD    = C.ARM64_INS_FNMADD
	ARM64_INS_FNMSUB    = C.ARM64_INS_FNMSUB
	ARM64_INS_FNMUL     = C.ARM64_INS_FNMUL
	ARM64_INS_FRECPE    = C.ARM64_INS_FRECPE
	ARM64_INS_FRECPS    = C.ARM64_INS_FRECPS
	ARM64_INS_FRECPX    = C.ARM64_INS_FRECPX
	ARM64_INS_FRINTA    = C.ARM64_INS_FRINTA
	ARM64_INS_FRINTI    = C.ARM64_INS_FRINTI
	ARM64_INS_FRINTM    = C.ARM64_INS_FRINTM
	ARM64_INS_FRINTN    = C.ARM64_INS_FRINTN
	ARM64_INS_FRINTP    = C.ARM64_INS_FRINTP
	ARM64_INS_FRINTX    = C.ARM64_INS_FRINTX
	ARM64_INS_FRINTZ    = C.ARM64_INS_FRINTZ
	ARM64_INS_FRSQRTE   = C.ARM64_INS_FRSQRTE
	ARM64_INS_FRSQRTS   = C.ARM64_INS_FRSQRTS
	ARM64_INS_FSQRT     = C.ARM64_INS_FSQRT
	ARM64_INS_FSUB      = C.ARM64_INS_FSUB
	ARM64_INS_HINT      = C.ARM64_INS_HINT
	ARM64_INS_HLT       = C.ARM64_INS_HLT
	ARM64_INS_HVC       = C.ARM64_INS_HVC
	ARM64_INS_INS       = C.ARM64_INS_INS
	ARM64_INS_ISB       = C.ARM64_INS_ISB
	ARM64_INS_LD1       = C.ARM64_INS_LD1
	ARM64_INS_LD1R      = C.ARM64_INS_LD1R
	ARM64_INS_LD2R      = C.ARM64_INS_LD2R
	ARM64_INS_LD2       = C.ARM64_INS_LD2
	ARM64_INS_LD3R      = C.ARM64_INS_LD3R
	ARM64_INS_LD3       = C.ARM64_INS_LD3
	ARM64_INS_LD4       = C.ARM64_INS_LD4
	ARM64_INS_LD4R      = C.ARM64_INS_LD4R
	ARM64_INS_LDARB     = C.ARM64_INS_LDARB
	ARM64_INS_LDARH     = C.ARM64_INS_LDARH
	ARM64_INS_LDAR      = C.ARM64_INS_LDAR
	ARM64_INS_LDAXP     = C.ARM64_INS_LDAXP
	ARM64_INS_LDAXRB    = C.ARM64_INS_LDAXRB
	ARM64_INS_LDAXRH    = C.ARM64_INS_LDAXRH
	ARM64_INS_LDAXR     = C.ARM64_INS_LDAXR
	ARM64_INS_LDNP      = C.ARM64_INS_LDNP
	ARM64_INS_LDP       = C.ARM64_INS_LDP
	ARM64_INS_LDPSW     = C.ARM64_INS_LDPSW
	ARM64_INS_LDRB      = C.ARM64_INS_LDRB
	ARM64_INS_LDR       = C.ARM64_INS_LDR
	ARM64_INS_LDRH      = C.ARM64_INS_LDRH
	ARM64_INS_LDRSB     = C.ARM64_INS_LDRSB
	ARM64_INS_LDRSH     = C.ARM64_INS_LDRSH
	ARM64_INS_LDRSW     = C.ARM64_INS_LDRSW
	ARM64_INS_LDTRB     = C.ARM64_INS_LDTRB
	ARM64_INS_LDTRH     = C.ARM64_INS_LDTRH
	ARM64_INS_LDTRSB    = C.ARM64_INS_LDTRSB
	ARM64_INS_LDTRSH    = C.ARM64_INS_LDTRSH
	ARM64_INS_LDTRSW    = C.ARM64_INS_LDTRSW
	ARM64_INS_LDTR      = C.ARM64_INS_LDTR
	ARM64_INS_LDURB     = C.ARM64_INS_LDURB
	ARM64_INS_LDUR      = C.ARM64_INS_LDUR
	ARM64_INS_LDURH     = C.ARM64_INS_LDURH
	ARM64_INS_LDURSB    = C.ARM64_INS_LDURSB
	ARM64_INS_LDURSH    = C.ARM64_INS_LDURSH
	ARM64_INS_LDURSW    = C.ARM64_INS_LDURSW
	ARM64_INS_LDXP      = C.ARM64_INS_LDXP
	ARM64_INS_LDXRB     = C.ARM64_INS_LDXRB
	ARM64_INS_LDXRH     = C.ARM64_INS_LDXRH
	ARM64_INS_LDXR      = C.ARM64_INS_LDXR
	ARM64_INS_LSL       = C.ARM64_INS_LSL
	ARM64_INS_LSR       = C.ARM64_INS_LSR
	ARM64_INS_MADD      = C.ARM64_INS_MADD
	ARM64_INS_MLA       = C.ARM64_INS_MLA
	ARM64_INS_MLS       = C.ARM64_INS_MLS
	ARM64_INS_MOVI      = C.ARM64_INS_MOVI
	ARM64_INS_MOVK      = C.ARM64_INS_MOVK
	ARM64_INS_MOVN      = C.ARM64_INS_MOVN
	ARM64_INS_MOVZ      = C.ARM64_INS_MOVZ
	ARM64_INS_MRS       = C.ARM64_INS_MRS
	ARM64_INS_MSR       = C.ARM64_INS_MSR
	ARM64_INS_MSUB      = C.ARM64_INS_MSUB
	ARM64_INS_MUL       = C.ARM64_INS_MUL
	ARM64_INS_MVNI      = C.ARM64_INS_MVNI
	ARM64_INS_NEG       = C.ARM64_INS_NEG
	ARM64_INS_NOT       = C.ARM64_INS_NOT
	ARM64_INS_ORN       = C.ARM64_INS_ORN
	ARM64_INS_ORR       = C.ARM64_INS_ORR
	ARM64_INS_PMULL2    = C.ARM64_INS_PMULL2
	ARM64_INS_PMULL     = C.ARM64_INS_PMULL
	ARM64_INS_PMUL      = C.ARM64_INS_PMUL
	ARM64_INS_PRFM      = C.ARM64_INS_PRFM
	ARM64_INS_PRFUM     = C.ARM64_INS_PRFUM
	ARM64_INS_RADDHN    = C.ARM64_INS_RADDHN
	ARM64_INS_RADDHN2   = C.ARM64_INS_RADDHN2
	ARM64_INS_RBIT      = C.ARM64_INS_RBIT
	ARM64_INS_RET       = C.ARM64_INS_RET
	ARM64_INS_REV16     = C.ARM64_INS_REV16
	ARM64_INS_REV32     = C.ARM64_INS_REV32
	ARM64_INS_REV64     = C.ARM64_INS_REV64
	ARM64_INS_REV       = C.ARM64_INS_REV
	ARM64_INS_ROR       = C.ARM64_INS_ROR
	ARM64_INS_RSHRN2    = C.ARM64_INS_RSHRN2
	ARM64_INS_RSHRN     = C.ARM64_INS_RSHRN
	ARM64_INS_RSUBHN    = C.ARM64_INS_RSUBHN
	ARM64_INS_RSUBHN2   = C.ARM64_INS_RSUBHN2
	ARM64_INS_SABAL2    = C.ARM64_INS_SABAL2
	ARM64_INS_SABAL     = C.ARM64_INS_SABAL
	ARM64_INS_SABA      = C.ARM64_INS_SABA
	ARM64_INS_SABDL2    = C.ARM64_INS_SABDL2
	ARM64_INS_SABDL     = C.ARM64_INS_SABDL
	ARM64_INS_SABD      = C.ARM64_INS_SABD
	ARM64_INS_SADALP    = C.ARM64_INS_SADALP
	ARM64_INS_SADDLP    = C.ARM64_INS_SADDLP
	ARM64_INS_SADDLV    = C.ARM64_INS_SADDLV
	ARM64_INS_SADDL2    = C.ARM64_INS_SADDL2
	ARM64_INS_SADDL     = C.ARM64_INS_SADDL
	ARM64_INS_SADDW2    = C.ARM64_INS_SADDW2
	ARM64_INS_SADDW     = C.ARM64_INS_SADDW
	ARM64_INS_SBC       = C.ARM64_INS_SBC
	ARM64_INS_SBFM      = C.ARM64_INS_SBFM
	ARM64_INS_SCVTF     = C.ARM64_INS_SCVTF
	ARM64_INS_SDIV      = C.ARM64_INS_SDIV
	ARM64_INS_SHA1C     = C.ARM64_INS_SHA1C
	ARM64_INS_SHA1H     = C.ARM64_INS_SHA1H
	ARM64_INS_SHA1M     = C.ARM64_INS_SHA1M
	ARM64_INS_SHA1P     = C.ARM64_INS_SHA1P
	ARM64_INS_SHA1SU0   = C.ARM64_INS_SHA1SU0
	ARM64_INS_SHA1SU1   = C.ARM64_INS_SHA1SU1
	ARM64_INS_SHA256H2  = C.ARM64_INS_SHA256H2
	ARM64_INS_SHA256H   = C.ARM64_INS_SHA256H
	ARM64_INS_SHA256SU0 = C.ARM64_INS_SHA256SU0
	ARM64_INS_SHA256SU1 = C.ARM64_INS_SHA256SU1
	ARM64_INS_SHADD     = C.ARM64_INS_SHADD
	ARM64_INS_SHLL2     = C.ARM64_INS_SHLL2
	ARM64_INS_SHLL      = C.ARM64_INS_SHLL
	ARM64_INS_SHL       = C.ARM64_INS_SHL
	ARM64_INS_SHRN2     = C.ARM64_INS_SHRN2
	ARM64_INS_SHRN      = C.ARM64_INS_SHRN
	ARM64_INS_SHSUB     = C.ARM64_INS_SHSUB
	ARM64_INS_SLI       = C.ARM64_INS_SLI
	ARM64_INS_SMADDL    = C.ARM64_INS_SMADDL
	ARM64_INS_SMAXP     = C.ARM64_INS_SMAXP
	ARM64_INS_SMAXV     = C.ARM64_INS_SMAXV
	ARM64_INS_SMAX      = C.ARM64_INS_SMAX
	ARM64_INS_SMC       = C.ARM64_INS_SMC
	ARM64_INS_SMINP     = C.ARM64_INS_SMINP
	ARM64_INS_SMINV     = C.ARM64_INS_SMINV
	ARM64_INS_SMIN      = C.ARM64_INS_SMIN
	ARM64_INS_SMLAL2    = C.ARM64_INS_SMLAL2
	ARM64_INS_SMLAL     = C.ARM64_INS_SMLAL
	ARM64_INS_SMLSL2    = C.ARM64_INS_SMLSL2
	ARM64_INS_SMLSL     = C.ARM64_INS_SMLSL
	ARM64_INS_SMOV      = C.ARM64_INS_SMOV
	ARM64_INS_SMSUBL    = C.ARM64_INS_SMSUBL
	ARM64_INS_SMULH     = C.ARM64_INS_SMULH
	ARM64_INS_SMULL2    = C.ARM64_INS_SMULL2
	ARM64_INS_SMULL     = C.ARM64_INS_SMULL
	ARM64_INS_SQABS     = C.ARM64_INS_SQABS
	ARM64_INS_SQADD     = C.ARM64_INS_SQADD
	ARM64_INS_SQDMLAL   = C.ARM64_INS_SQDMLAL
	ARM64_INS_SQDMLAL2  = C.ARM64_INS_SQDMLAL2
	ARM64_INS_SQDMLSL   = C.ARM64_INS_SQDMLSL
	ARM64_INS_SQDMLSL2  = C.ARM64_INS_SQDMLSL2
	ARM64_INS_SQDMULH   = C.ARM64_INS_SQDMULH
	ARM64_INS_SQDMULL   = C.ARM64_INS_SQDMULL
	ARM64_INS_SQDMULL2  = C.ARM64_INS_SQDMULL2
	ARM64_INS_SQNEG     = C.ARM64_INS_SQNEG
	ARM64_INS_SQRDMULH  = C.ARM64_INS_SQRDMULH
	ARM64_INS_SQRSHL    = C.ARM64_INS_SQRSHL
	ARM64_INS_SQRSHRN   = C.ARM64_INS_SQRSHRN
	ARM64_INS_SQRSHRN2  = C.ARM64_INS_SQRSHRN2
	ARM64_INS_SQRSHRUN  = C.ARM64_INS_SQRSHRUN
	ARM64_INS_SQRSHRUN2 = C.ARM64_INS_SQRSHRUN2
	ARM64_INS_SQSHLU    = C.ARM64_INS_SQSHLU
	ARM64_INS_SQSHL     = C.ARM64_INS_SQSHL
	ARM64_INS_SQSHRN    = C.ARM64_INS_SQSHRN
	ARM64_INS_SQSHRN2   = C.ARM64_INS_SQSHRN2
	ARM64_INS_SQSHRUN   = C.ARM64_INS_SQSHRUN
	ARM64_INS_SQSHRUN2  = C.ARM64_INS_SQSHRUN2
	ARM64_INS_SQSUB     = C.ARM64_INS_SQSUB
	ARM64_INS_SQXTN2    = C.ARM64_INS_SQXTN2
	ARM64_INS_SQXTN     = C.ARM64_INS_SQXTN
	ARM64_INS_SQXTUN2   = C.ARM64_INS_SQXTUN2
	ARM64_INS_SQXTUN    = C.ARM64_INS_SQXTUN
	ARM64_INS_SRHADD    = C.ARM64_INS_SRHADD
	ARM64_INS_SRI       = C.ARM64_INS_SRI
	ARM64_INS_SRSHL     = C.ARM64_INS_SRSHL
	ARM64_INS_SRSHR     = C.ARM64_INS_SRSHR
	ARM64_INS_SRSRA     = C.ARM64_INS_SRSRA
	ARM64_INS_SSHLL2    = C.ARM64_INS_SSHLL2
	ARM64_INS_SSHLL     = C.ARM64_INS_SSHLL
	ARM64_INS_SSHL      = C.ARM64_INS_SSHL
	ARM64_INS_SSHR      = C.ARM64_INS_SSHR
	ARM64_INS_SSRA      = C.ARM64_INS_SSRA
	ARM64_INS_SSUBL2    = C.ARM64_INS_SSUBL2
	ARM64_INS_SSUBL     = C.ARM64_INS_SSUBL
	ARM64_INS_SSUBW2    = C.ARM64_INS_SSUBW2
	ARM64_INS_SSUBW     = C.ARM64_INS_SSUBW
	ARM64_INS_ST1       = C.ARM64_INS_ST1
	ARM64_INS_ST2       = C.ARM64_INS_ST2
	ARM64_INS_ST3       = C.ARM64_INS_ST3
	ARM64_INS_ST4       = C.ARM64_INS_ST4
	ARM64_INS_STLRB     = C.ARM64_INS_STLRB
	ARM64_INS_STLRH     = C.ARM64_INS_STLRH
	ARM64_INS_STLR      = C.ARM64_INS_STLR
	ARM64_INS_STLXP     = C.ARM64_INS_STLXP
	ARM64_INS_STLXRB    = C.ARM64_INS_STLXRB
	ARM64_INS_STLXRH    = C.ARM64_INS_STLXRH
	ARM64_INS_STLXR     = C.ARM64_INS_STLXR
	ARM64_INS_STNP      = C.ARM64_INS_STNP
	ARM64_INS_STP       = C.ARM64_INS_STP
	ARM64_INS_STRB      = C.ARM64_INS_STRB
	ARM64_INS_STR       = C.ARM64_INS_STR
	ARM64_INS_STRH      = C.ARM64_INS_STRH
	ARM64_INS_STTRB     = C.ARM64_INS_STTRB
	ARM64_INS_STTRH     = C.ARM64_INS_STTRH
	ARM64_INS_STTR      = C.ARM64_INS_STTR
	ARM64_INS_STURB     = C.ARM64_INS_STURB
	ARM64_INS_STUR      = C.ARM64_INS_STUR
	ARM64_INS_STURH     = C.ARM64_INS_STURH
	ARM64_INS_STXP      = C.ARM64_INS_STXP
	ARM64_INS_STXRB     = C.ARM64_INS_STXRB
	ARM64_INS_STXRH     = C.ARM64_INS_STXRH
	ARM64_INS_STXR      = C.ARM64_INS_STXR
	ARM64_INS_SUBHN     = C.ARM64_INS_SUBHN
	ARM64_INS_SUBHN2    = C.ARM64_INS_SUBHN2
	ARM64_INS_SUB       = C.ARM64_INS_SUB
	ARM64_INS_SUQADD    = C.ARM64_INS_SUQADD
	ARM64_INS_SVC       = C.ARM64_INS_SVC
	ARM64_INS_SYSL      = C.ARM64_INS_SYSL
	ARM64_INS_SYS       = C.ARM64_INS_SYS
	ARM64_INS_TBL       = C.ARM64_INS_TBL
	ARM64_INS_TBNZ      = C.ARM64_INS_TBNZ
	ARM64_INS_TBX       = C.ARM64_INS_TBX
	ARM64_INS_TBZ       = C.ARM64_INS_TBZ
	ARM64_INS_TRN1      = C.ARM64_INS_TRN1
	ARM64_INS_TRN2      = C.ARM64_INS_TRN2
	ARM64_INS_UABAL2    = C.ARM64_INS_UABAL2
	ARM64_INS_UABAL     = C.ARM64_INS_UABAL
	ARM64_INS_UABA      = C.ARM64_INS_UABA
	ARM64_INS_UABDL2    = C.ARM64_INS_UABDL2
	ARM64_INS_UABDL     = C.ARM64_INS_UABDL
	ARM64_INS_UABD      = C.ARM64_INS_UABD
	ARM64_INS_UADALP    = C.ARM64_INS_UADALP
	ARM64_INS_UADDLP    = C.ARM64_INS_UADDLP
	ARM64_INS_UADDLV    = C.ARM64_INS_UADDLV
	ARM64_INS_UADDL2    = C.ARM64_INS_UADDL2
	ARM64_INS_UADDL     = C.ARM64_INS_UADDL
	ARM64_INS_UADDW2    = C.ARM64_INS_UADDW2
	ARM64_INS_UADDW     = C.ARM64_INS_UADDW
	ARM64_INS_UBFM      = C.ARM64_INS_UBFM
	ARM64_INS_UCVTF     = C.ARM64_INS_UCVTF
	ARM64_INS_UDIV      = C.ARM64_INS_UDIV
	ARM64_INS_UHADD     = C.ARM64_INS_UHADD
	ARM64_INS_UHSUB     = C.ARM64_INS_UHSUB
	ARM64_INS_UMADDL    = C.ARM64_INS_UMADDL
	ARM64_INS_UMAXP     = C.ARM64_INS_UMAXP
	ARM64_INS_UMAXV     = C.ARM64_INS_UMAXV
	ARM64_INS_UMAX      = C.ARM64_INS_UMAX
	ARM64_INS_UMINP     = C.ARM64_INS_UMINP
	ARM64_INS_UMINV     = C.ARM64_INS_UMINV
	ARM64_INS_UMIN      = C.ARM64_INS_UMIN
	ARM64_INS_UMLAL2    = C.ARM64_INS_UMLAL2
	ARM64_INS_UMLAL     = C.ARM64_INS_UMLAL
	ARM64_INS_UMLSL2    = C.ARM64_INS_UMLSL2
	ARM64_INS_UMLSL     = C.ARM64_INS_UMLSL
	ARM64_INS_UMOV      = C.ARM64_INS_UMOV
	ARM64_INS_UMSUBL    = C.ARM64_INS_UMSUBL
	ARM64_INS_UMULH     = C.ARM64_INS_UMULH
	ARM64_INS_UMULL2    = C.ARM64_INS_UMULL2
	ARM64_INS_UMULL     = C.ARM64_INS_UMULL
	ARM64_INS_UQADD     = C.ARM64_INS_UQADD
	ARM64_INS_UQRSHL    = C.ARM64_INS_UQRSHL
	ARM64_INS_UQRSHRN   = C.ARM64_INS_UQRSHRN
	ARM64_INS_UQRSHRN2  = C.ARM64_INS_UQRSHRN2
	ARM64_INS_UQSHL     = C.ARM64_INS_UQSHL
	ARM64_INS_UQSHRN    = C.ARM64_INS_UQSHRN
	ARM64_INS_UQSHRN2   = C.ARM64_INS_UQSHRN2
	ARM64_INS_UQSUB     = C.ARM64_INS_UQSUB
	ARM64_INS_UQXTN2    = C.ARM64_INS_UQXTN2
	ARM64_INS_UQXTN     = C.ARM64_INS_UQXTN
	ARM64_INS_URECPE    = C.ARM64_INS_URECPE
	ARM64_INS_URHADD    = C.ARM64_INS_URHADD
	ARM64_INS_URSHL     = C.ARM64_INS_URSHL
	ARM64_INS_URSHR     = C.ARM64_INS_URSHR
	ARM64_INS_URSQRTE   = C.ARM64_INS_URSQRTE
	ARM64_INS_URSRA     = C.ARM64_INS_URSRA
	ARM64_INS_USHLL2    = C.ARM64_INS_USHLL2
	ARM64_INS_USHLL     = C.ARM64_INS_USHLL
	ARM64_INS_USHL      = C.ARM64_INS_USHL
	ARM64_INS_USHR      = C.ARM64_INS_USHR
	ARM64_INS_USQADD    = C.ARM64_INS_USQADD
	ARM64_INS_USRA      = C.ARM64_INS_USRA
	ARM64_INS_USUBL2    = C.ARM64_INS_USUBL2
	ARM64_INS_USUBL     = C.ARM64_INS_USUBL
	ARM64_INS_USUBW2    = C.ARM64_INS_USUBW2
	ARM64_INS_USUBW     = C.ARM64_INS_USUBW
	ARM64_INS_UZP1      = C.ARM64_INS_UZP1
	ARM64_INS_UZP2      = C.ARM64_INS_UZP2
	ARM64_INS_XTN2      = C.ARM64_INS_XTN2
	ARM64_INS_XTN       = C.ARM64_INS_XTN
	ARM64_INS_ZIP1      = C.ARM64_INS_ZIP1
	ARM64_INS_ZIP2      = C.ARM64_INS_ZIP2
	ARM64_INS_MNEG      = C.ARM64_INS_MNEG
	ARM64_INS_UMNEGL    = C.ARM64_INS_UMNEGL
	ARM64_INS_SMNEGL    = C.ARM64_INS_SMNEGL
	ARM64_INS_NOP       = C.ARM64_INS_NOP
	ARM64_INS_YIELD     = C.ARM64_INS_YIELD
	ARM64_INS_WFE       = C.ARM64_INS_WFE
	ARM64_INS_WFI       = C.ARM64_INS_WFI
	ARM64_INS_SEV       = C.ARM64_INS_SEV
	ARM64_INS_SEVL      = C.ARM64_INS_SEVL
	ARM64_INS_NGC       = C.ARM64_INS_NGC
	ARM64_INS_SBFIZ     = C.ARM64_INS_SBFIZ
	ARM64_INS_UBFIZ     = C.ARM64_INS_UBFIZ
	ARM64_INS_SBFX      = C.ARM64_INS_SBFX
	ARM64_INS_UBFX      = C.ARM64_INS_UBFX
	ARM64_INS_BFI       = C.ARM64_INS_BFI
	ARM64_INS_BFXIL     = C.ARM64_INS_BFXIL
	ARM64_INS_CMN       = C.ARM64_INS_CMN
	ARM64_INS_MVN       = C.ARM64_INS_MVN
	ARM64_INS_TST       = C.ARM64_INS_TST
	ARM64_INS_CSET      = C.ARM64_INS_CSET
	ARM64_INS_CINC      = C.ARM64_INS_CINC
	ARM64_INS_CSETM     = C.ARM64_INS_CSETM
	ARM64_INS_CINV      = C.ARM64_INS_CINV
	ARM64_INS_CNEG      = C.ARM64_INS_CNEG
	ARM64_INS_SXTB      = C.ARM64_INS_SXTB
	ARM64_INS_SXTH      = C.ARM64_INS_SXTH
	ARM64_INS_SXTW      = C.ARM64_INS_SXTW
	ARM64_INS_CMP       = C.ARM64_INS_CMP
	ARM64_INS_UXTB      = C.ARM64_INS_UXTB
	ARM64_INS_UXTH      = C.ARM64_INS_UXTH
	ARM64_INS_UXTW      = C.ARM64_INS_UXTW
	ARM64_INS_IC        = C.ARM64_INS_IC
	ARM64_INS_DC        = C.ARM64_INS_DC
	ARM64_INS_AT        = C.ARM64_INS_AT
	ARM64_INS_TLBI      = C.ARM64_INS_TLBI
	ARM64_INS_NEGS      = C.ARM64_INS_NEGS
	ARM64_INS_NGCS      = C.ARM64_INS_NGCS
	ARM64_INS_ENDING    = C.ARM64_INS_ENDING
)

// Group of ARM64 instructions
const (
	ARM64_GRP_INVALID = C.ARM64_GRP_INVALID
)

// Generic groups
const (
	ARM64_GRP_JUMP            = C.ARM64_GRP_JUMP
	ARM64_GRP_CALL            = C.ARM64_GRP_CALL
	ARM64_GRP_RET             = C.ARM64_GRP_RET
	ARM64_GRP_INT             = C.ARM64_GRP_INT
	ARM64_GRP_PRIVILEGE       = C.ARM64_GRP_PRIVILEGE
	ARM64_GRP_BRANCH_RELATIVE = C.ARM64_GRP_BRANCH_RELATIVE
)

// Architecture-specific groups
const (
	ARM64_GRP_CRYPTO  = C.ARM64_GRP_CRYPTO
	ARM64_GRP_FPARMV8 = C.ARM64_GRP_FPARMV8
	ARM64_GRP_NEON    = C.ARM64_GRP_NEON
	ARM64_GRP_CRC     = C.ARM64_GRP_CRC
	ARM64_GRP_ENDING  = C.ARM64_GRP_ENDING
)
