# gqty

## 3.2.2

### Patch Changes

- [#2033](https://github.com/gqty-dev/gqty/pull/2033)
  [`f681c06`](https://github.com/gqty-dev/gqty/commit/f681c06b2af6d979a5d9af92e087872c17234af4)
  Thanks [@vicary](https://github.com/vicary)! - fix(gqty): onSubscribe for
  connected WebSockets

- [#2035](https://github.com/gqty-dev/gqty/pull/2035)
  [`ee30fe3`](https://github.com/gqty-dev/gqty/commit/ee30fe39f2ebf512716247d9ae37eb6dbd33f8eb)
  Thanks [@bkniffler](https://github.com/bkniffler)! - fix(package/gqty): remove
  async keyword from default error handler

## 3.2.1

### Patch Changes

- [#1992](https://github.com/gqty-dev/gqty/pull/1992)
  [`c222005`](https://github.com/gqty-dev/gqty/commit/c222005ef1295f06f6ed6abcedccc512405d8771)
  Thanks [@vicary](https://github.com/vicary)! - Allow `resolve` to return
  `null`

## 3.2.0

### Minor Changes

- [#1908](https://github.com/gqty-dev/gqty/pull/1908)
  [`8a3ff42`](https://github.com/gqty-dev/gqty/commit/8a3ff425a094de964418b94208bef4dbc8f3c4e5)
  Thanks [@vicary](https://github.com/vicary)! - Added default fetch response
  handler

### Patch Changes

- [`f79f363`](https://github.com/gqty-dev/gqty/commit/f79f3638d9b93025a318c8e3716026474070ab5a)
  Thanks [@vicary](https://github.com/vicary)! - chore: add description and sort
  fields in package.json

## 3.1.1

### Patch Changes

- [`4a5b6f9`](https://github.com/gqty-dev/gqty/commit/4a5b6f9e353873bfc1ca3894bdb6e0c1e84c1578)
  Thanks [@vicary](https://github.com/vicary)! - Generic schema type

## 3.1.0

### Minor Changes

- [#1849](https://github.com/gqty-dev/gqty/pull/1849)
  [`a577128`](https://github.com/gqty-dev/gqty/commit/a577128f6c5e929321193f5effed700c6e7d32c8)
  Thanks [@vicary](https://github.com/vicary)! - Retain sub-selections for empty
  arrays and null objects

### Patch Changes

- [#1850](https://github.com/gqty-dev/gqty/pull/1850)
  [`3e5cd7d`](https://github.com/gqty-dev/gqty/commit/3e5cd7d81fbe537bd4237cfd8584982b5f1b6468)
  Thanks [@vicary](https://github.com/vicary)! - Apply eslint and fix lint
  errors

- [`dcd6ac2`](https://github.com/gqty-dev/gqty/commit/dcd6ac25cfd463c492b4d12ecdb603ca70894c8b)
  Thanks [@vicary](https://github.com/vicary)! - Upgrade jest for Prettier v3

## 3.0.1

### Patch Changes

- [`0b69356`](https://github.com/gqty-dev/gqty/commit/0b69356a564cdb91d5c4e4780f7f7dd5fd8f2c83)
  Thanks [@vicary](https://github.com/vicary)! - Fix logo URL in README

## 3.0.0

### Major Changes

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Added "Legacy" prefix to
  deprecated types

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Added new logging interface for
  `@gqty/logger`

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - `backupPersistence()` and
  `restorePersistence()` is now replaced with `persist()`, `restore()` and
  `restoreAsync()`.

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - QueryFetcher now accepts
  QueryPayload as the first parameter

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Remade `Cache` with expiry,
  normalization and persistence

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Axed `Scheduler`, `Interceptor`
  and `EventHandler`

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Reworked `Accessor` and added
  scoped context

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Replaced `@gqty/subscriptions`
  with `graphql-ws` and `graphql-sse`

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Rewritten `Selection` class

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Introduced `resolve()` and
  `subscribe()` API

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Replaced `lodash` with `just-*`
  and dropped `@gqty/utils`

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Deprecated `resolved()`,
  `inlineResolved()`, `mutate()`, `track()`, `prefetch()` and `refetch()`

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Replace variable serializer
  with object-hash, now with shortened alias

### Minor Changes

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Added `operationName` in
  `resolved()`, `inlineResolved()`, `useTransactionQuery()` and `useLazyQuery()`

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Batching by microtask

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Added `$meta` API

- [#1799](https://github.com/gqty-dev/gqty/pull/1799)
  [`fe29ac0`](https://github.com/gqty-dev/gqty/commit/fe29ac0468389ea0783d97eb297b28b4b4fc11d2)
  Thanks [@vicary](https://github.com/vicary)! - Debounce query batching with
  microtasks

- [#1742](https://github.com/gqty-dev/gqty/pull/1742)
  [`2e274f1`](https://github.com/gqty-dev/gqty/commit/2e274f12144a900f88c85358c23a6b357f1e8d11)
  Thanks [@vicary](https://github.com/vicary)! - Added `batchWindow` option in
  `ClientOptions`

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Added `extensions` option for
  passing arbitraty data to the query fetcher.

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Added `name` in `GQtyError` for
  better logging

### Patch Changes

- [`ac34d04`](https://github.com/gqty-dev/gqty/commit/ac34d0477c6cee041177c125336003aec47080df)
  Thanks [@vicary](https://github.com/vicary)! - Update all relevant temporary
  caches for batched queries.

- [`7ffaebf`](https://github.com/gqty-dev/gqty/commit/7ffaebf0c327efdf567a6c241188b72732001ffc)
  Thanks [@vicary](https://github.com/vicary)! - Avoid sending unused arguments

- [#1744](https://github.com/gqty-dev/gqty/pull/1744)
  [`ffb7d5c`](https://github.com/gqty-dev/gqty/commit/ffb7d5c0a3ff2d640d2d885fccd6916e48b799eb)
  Thanks [@vicary](https://github.com/vicary)! - Added default return type for
  `resolve`

- [#1476](https://github.com/gqty-dev/gqty/pull/1476)
  [`595ec84`](https://github.com/gqty-dev/gqty/commit/595ec8431de0d4be2edc4f60809988bda0cf2833)
  Thanks [@vicary](https://github.com/vicary)! - Remove alias without args

## 3.0.0-alpha.0

### Major Changes

- Added "Legacy" prefix to deprecated types
- Added new logging interface for `@gqty/logger`
- `backupPersistence()` and `restorePersistence()` is now replaced with
  `persist()`, `restore()` and `restoreAsync()`.
- QueryFetcher now accepts QueryPayload instead of 3 parameters
- Remade `Cache` with expiry, normalization and persistence
- Axed `Scheduler`, `Interceptor` and `EventHandler`
- Reworked `Accessor` and added scoped context
- Replaced `@gqty/subscriptions` with `graphql-ws` and `graphql-sse`
- Rewritten `Selection` class
- Introduced `resolve()` and `subscribe()` API
- Replaced `lodash` with `just-*` and dropped `@gqty/utils`
- Deprecated `resolved()`, `inlineResolved()`, `mutate()`, `track()`,
  `prefetch()` and `refetch()`
- Replace variable serializer with object-hash, now with shortened alias

### Minor Changes

- f39bb450: Add `operationName` option to `resolved()` and `inlineResolved()`.
- Added `$meta` API
- Added `name` in `GQtyError` for better logging

### Patch Changes

- 595ec843: Remove alias without args

## 2.3.0

### Minor Changes

- 6ecd2b0: Use lodash mergeWith from "@gqty/utils" package
- 59d38ad: Change variable aliasing to be deterministic with cached and sliced
  sha1 hashing

### Patch Changes

- Updated dependencies [6ecd2b0]
- Updated dependencies [59d38ad]
  - @gqty/utils@1.0.0

## 2.2.0

### Minor Changes

- dd47986: New option `"fetchOptions"`, added to the
  [`resolved`](https://gqty.dev/docs/client/fetching-data#resolved) client
  function, that allows for giving extra configurations to the expected
  [fetch](https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API) call.

  This enables, for example, the customization of the headers sent for a
  specific query or to pass an
  [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal).

  ```ts
  import { resolved, query } from '../gqty';

  // ...

  const controller = new AbortController();

  await resolved(() => query.currentUser?.email, {
    fetchOptions: {
      headers: {
        'Content-Type': 'application/json',
        authorization: 'secret_token',
      },
      signal: controller.signal,
    },
  });
  ```

  For already generated clients to be able to use this new option, it is
  required manually modify the existing query fetcher, to do for example:

  ```ts
  const queryFetcher: QueryFetcher = async function (
    query,
    variables,
    fetchOptions
  ) {
    const response = await fetch(endpoint, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({
        query,
        variables,
      }),
      ...fetchOptions,
    });

    const json = await response.json();

    return json;
  };
  ```

## 2.1.0

### Minor Changes

- 6df0318: Add new Core configuration `"depthLimit"` (by default is `15`),
  needed to prevent possible infinite recursion, after the specified depth is
  reached, the proxy creation is stopped returning `null`.

## 2.0.4

### Patch Changes

- d6d0a22: Fix check Error.captureStackTrace before calling it

## 2.0.3

### Patch Changes

- 9e22119: Fix unions/interface fetch loop

  closes #236

## 2.0.2

### Patch Changes

- d014462: remove unused dependency
- 6b60991: improve normalization key auto-fetch logic
- 5cc001f: Fix: Prevent duplicated concurrent scheduler fetch
- d6da2ae: `Variables`/`Args` utility type to re-use variables types from any
  field with arguments.

  You can use either `Variables` or `Args`.

  ```ts
  import { query, Query } from '../gqty';

  import type { Variables, Args } from 'gqty';

  function getUserName(args: Variables<Query['user']>) {
    return query.user(args).name;
  }

  function getUserEmail(args: Args<(typeof query)['user']>) {
    return query.user(args).email;
  }
  ```

## 2.0.1

### Patch Changes

- 28e2c09: [Bug fixing breaking change] Fix types and retrieval of unions/interfaces
  of different object types

## 2.0.0

### Major Changes

- 3586c45: Remove undocumented "buildSelections"
- 3586c45: Change previous unstable `Unions` support with new `"$on"` property
  with support for both `Unions` & `Interfaces`

## 1.1.3

### Patch Changes

- 3b9c614: Improve refetch selection history logic

## 1.1.2

### Patch Changes

- 1fc2672: add "sideEffects: false" for improved tree-shaking

## 1.1.1

### Patch Changes

- 6703c2f: fix undefined object types names

## 1.1.0

### Minor Changes

- a216972: add "track" helper, specially useful subscriptions and tracking cache
  state

## 1.0.3

### Patch Changes

- e6afb46: fix refetch array on initially empty state
- 4c66ab2: fix prepareRender await

## 1.0.2

### Patch Changes

- 25aceae: fix ESM import with extension

## 1.0.1

### Patch Changes

- 3784c2b: release

## 2.0.15

### Patch Changes

- 3f08372: publish fork

## 2.0.14

### Patch Changes

- 422eb9a: allow set core "resolved" defaults
- 422eb9a: hotfix nullable getFields

## 2.0.13

### Patch Changes

- 4a3d5ef: divide subscriptions with only one top level field
- af6a437: - Rename `gqtyConfig` to `GQtyConfig` (so it's consistent with the
  new logo)
  - Rename `gqtyError` to `GQtyError`
  - Remove `endpoint` option from the configuration, and instead always defaults
    to introspection one
    - It's confusing why theres two of them, and the user can change it later by
      modifying the file anyway

## 2.0.12

### Patch Changes

- c45ca0d: add NPM readme

## 2.0.11

### Patch Changes

- 85a389c: fix selections backup & fix resolved false-positive warn
- cca9d02: add inlineResolved function
- 0904297: remove normalizedCache from persistence

## 2.0.10

### Patch Changes

- 65c4d32: add resolved "onEmptyResolve" callback and warn on empty "resolved"
  calls

## 2.0.9

### Patch Changes

- 6a9269f: fix getArrayFields type inference on nullable arrays

## 2.0.8

### Patch Changes

- c74442e: fix prepareRender logic
- d78f2ab: resolved "onNoCacheFound" helper
- 0ffaa9d: optimize selections cache & backups size

## 2.0.7

### Patch Changes

- ff66195: fix getFields
- 63fd3ea: support for non-serializable variables
- 40d2101: improve array length access

## 2.0.6

### Patch Changes

- 173e11d: add subscriptions to events
- c613410: fix selection alias id & persistence only query

## 2.0.5

### Patch Changes

- 6fef085: add cache persistence helpers

## 2.0.4

### Patch Changes

- 2bf4ce2: add inner scheduler "getResolvingPromise"

## 2.0.3

### Patch Changes

- 27f9ece: set "graphql" as optional peerDependency

## 2.0.2

### Patch Changes

- c06ef80: add "prepass" helper

## 2.0.1

### Patch Changes

- a57cab4: official beta v2 publish
