# @gqty/cli

## 4.2.1

### Patch Changes

- [`92498f8`](https://github.com/gqty-dev/gqty/commit/92498f8c3944f6322b7d91925531fd278ee4da81)
  Thanks [@vicary](https://github.com/vicary)! - allow default auto-detected
  frameworks

- Updated dependencies
  [[`f681c06`](https://github.com/gqty-dev/gqty/commit/f681c06b2af6d979a5d9af92e087872c17234af4),
  [`ee30fe3`](https://github.com/gqty-dev/gqty/commit/ee30fe39f2ebf512716247d9ae37eb6dbd33f8eb)]:
  - gqty@3.2.2

## 4.2.0

### Minor Changes

- [#1758](https://github.com/gqty-dev/gqty/pull/1758)
  [`3297a2d`](https://github.com/gqty-dev/gqty/commit/3297a2dbfd06a4952acef4cc7fab0d14a002b986)
  Thanks [@vicary](https://github.com/vicary)! - Improves Solid support using
  createResource over createSignal

## 4.1.2

### Patch Changes

- [#2000](https://github.com/gqty-dev/gqty/pull/2000)
  [`fc1155f`](https://github.com/gqty-dev/gqty/commit/fc1155f4a70c352416b107d5d8a47d6a15998e4b)
  Thanks [@lubosmato](https://github.com/lubosmato)! - Allow watch targets above
  current working directory

## 4.1.1

### Patch Changes

- Updated dependencies
  [[`c222005`](https://github.com/gqty-dev/gqty/commit/c222005ef1295f06f6ed6abcedccc512405d8771)]:
  - gqty@3.2.1

## 4.1.0

### Minor Changes

- [#1901](https://github.com/gqty-dev/gqty/pull/1901)
  [`df2fb48`](https://github.com/gqty-dev/gqty/commit/df2fb483849dbc235790e707182ff7e91bd02b9e)
  Thanks [@vicary](https://github.com/vicary)! - Expose CLI essentials for
  external integrations

- [#1908](https://github.com/gqty-dev/gqty/pull/1908)
  [`8a3ff42`](https://github.com/gqty-dev/gqty/commit/8a3ff425a094de964418b94208bef4dbc8f3c4e5)
  Thanks [@vicary](https://github.com/vicary)! - Added default fetch response
  handler

- [#1908](https://github.com/gqty-dev/gqty/pull/1908)
  [`8a3ff42`](https://github.com/gqty-dev/gqty/commit/8a3ff425a094de964418b94208bef4dbc8f3c4e5)
  Thanks [@vicary](https://github.com/vicary)! - Throw GraphQL errors in the
  generated client.

### Patch Changes

- [`f79f363`](https://github.com/gqty-dev/gqty/commit/f79f3638d9b93025a318c8e3716026474070ab5a)
  Thanks [@vicary](https://github.com/vicary)! - chore: add description and sort
  fields in package.json

- [#1902](https://github.com/gqty-dev/gqty/pull/1902)
  [`152a1d9`](https://github.com/gqty-dev/gqty/commit/152a1d9ac6b1e136484e61a7d0e602f450c6d4f8)
  Thanks [@vicary](https://github.com/vicary)! - Respect interactive endpoint as
  generation result.

- Updated dependencies
  [[`f79f363`](https://github.com/gqty-dev/gqty/commit/f79f3638d9b93025a318c8e3716026474070ab5a),
  [`8a3ff42`](https://github.com/gqty-dev/gqty/commit/8a3ff425a094de964418b94208bef4dbc8f3c4e5)]:
  - gqty@3.2.0

## 4.0.3

### Patch Changes

- Updated dependencies
  [[`4a5b6f9`](https://github.com/gqty-dev/gqty/commit/4a5b6f9e353873bfc1ca3894bdb6e0c1e84c1578)]:
  - gqty@3.1.1

## 4.0.2

### Patch Changes

- [#1855](https://github.com/gqty-dev/gqty/pull/1855)
  [`6d72f03`](https://github.com/gqty-dev/gqty/commit/6d72f03c806c3f3a42d1cc1f018d96e7973667d3)
  Thanks [@vicary](https://github.com/vicary)! - ESM import path for optional
  deps in watch mode

- Updated dependencies
  [[`a577128`](https://github.com/gqty-dev/gqty/commit/a577128f6c5e929321193f5effed700c6e7d32c8),
  [`3e5cd7d`](https://github.com/gqty-dev/gqty/commit/3e5cd7d81fbe537bd4237cfd8584982b5f1b6468),
  [`dcd6ac2`](https://github.com/gqty-dev/gqty/commit/dcd6ac25cfd463c492b4d12ecdb603ca70894c8b)]:
  - gqty@3.1.0

## 4.0.1

### Patch Changes

- [`0b69356`](https://github.com/gqty-dev/gqty/commit/0b69356a564cdb91d5c4e4780f7f7dd5fd8f2c83)
  Thanks [@vicary](https://github.com/vicary)! - Fix logo URL in README

- Updated dependencies
  [[`0b69356`](https://github.com/gqty-dev/gqty/commit/0b69356a564cdb91d5c4e4780f7f7dd5fd8f2c83)]:
  - gqty@3.0.1

## 4.0.0

### Major Changes

- [#1724](https://github.com/gqty-dev/gqty/pull/1724)
  [`b289c05`](https://github.com/gqty-dev/gqty/commit/b289c051fb85ab045a0c75f7441927599440d105)
  Thanks [@renovate](https://github.com/apps/renovate)! - Drop Node 16 support,
  and add Node 22 in the tests.

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Dropped inferrable types from
  generated schema

- [#1634](https://github.com/gqty-dev/gqty/pull/1634)
  [`3c5bc4a`](https://github.com/gqty-dev/gqty/commit/3c5bc4a7590a8e3a039b634b5600239185bf4085)
  Thanks [@vicary](https://github.com/vicary)! - Upgrade
  @graphql-codegen/typescript to v4

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Generated query fetcher now
  takes a single `QueryPayload` parameter

### Minor Changes

- [#1585](https://github.com/gqty-dev/gqty/pull/1585)
  [`f6d00c0`](https://github.com/gqty-dev/gqty/commit/f6d00c0741659729c8503f7957018664bb5e76ac)
  Thanks [@vicary](https://github.com/vicary)! - Support "endpoint" in
  configuration

- [#1544](https://github.com/gqty-dev/gqty/pull/1544)
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)
  Thanks [@vicary](https://github.com/vicary)! - Interactive mode for generating
  queries and mutations

- [#1683](https://github.com/gqty-dev/gqty/pull/1683)
  [`eab8c7a`](https://github.com/gqty-dev/gqty/commit/eab8c7a7178db08c0eeb339ccced3485f7fb6493)
  Thanks [@vicary](https://github.com/vicary)! - Add `enumStyle` config option.

### Patch Changes

- Updated dependencies
  [[`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`fe29ac0`](https://github.com/gqty-dev/gqty/commit/fe29ac0468389ea0783d97eb297b28b4b4fc11d2),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`ac34d04`](https://github.com/gqty-dev/gqty/commit/ac34d0477c6cee041177c125336003aec47080df),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`7ffaebf`](https://github.com/gqty-dev/gqty/commit/7ffaebf0c327efdf567a6c241188b72732001ffc),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`2e274f1`](https://github.com/gqty-dev/gqty/commit/2e274f12144a900f88c85358c23a6b357f1e8d11),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`ffb7d5c`](https://github.com/gqty-dev/gqty/commit/ffb7d5c0a3ff2d640d2d885fccd6916e48b799eb),
  [`595ec84`](https://github.com/gqty-dev/gqty/commit/595ec8431de0d4be2edc4f60809988bda0cf2833),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724),
  [`a758ed1`](https://github.com/gqty-dev/gqty/commit/a758ed17130ff2f5e8fc659c9ded3203798f9724)]:
  - gqty@3.0.0

## 3.3.0

### Minor Changes

- 323ecbe: A new option `enumsAsConsts` is added to the `GQtyConfig`

  Here's a sample of how it differs from `enum`

  ```ts
  enum Enum {
    A_B_C = 'A_B_C',
    X_Y_Z = 'X_Y_Z',
    _TEST = '_TEST',
    My_Value = 'My_Value',
  }

  export const EnumAsConst = {
    ABC: 'A_B_C',
    XYZ: 'X_Y_Z',
    Test: '_TEST',
    MyValue: 'My_Value',
  } as const;
  export type EnumAsConst = (typeof EnumAsConst)[keyof typeof EnumAsConst];

  function useEnum(value: Enum) {}
  function useEnumAsConst(value: EnumAsConst) {}

  useEnum(Enum.A_B_C); // Ok
  useEnum('A_B_C'); // Error: Argument of type '"A_B_C"' is not assignable to parameter of type 'Enum'.

  useEnumAsConst(Enum.A_B_C); // Ok
  useEnumAsConst(EnumAsConst.ABC); // Ok
  useEnumAsConst('A_B_C'); // Ok
  ```

  See also:

  - [Ben Lesh on Twitter: "I've run across this pattern for enums in TypeScript..."](https://twitter.com/BenLesh/status/1510983348944056327/)
  - [Replacing Enums With Unions](https://www.tomche.space/post/replacing-enums-with-unions/)

## 3.2.0

### Minor Changes

- dd47986: New option `"fetchOptions"`, added to the
  [`resolved`](https://gqty.dev/docs/client/fetching-data#resolved) client
  function, that allows for giving extra configurations to the expected
  [fetch](https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API) call.

  This enables, for example, the customization of the headers sent for a
  specific query or to pass an
  [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal).

  ```ts
  import { resolved, query } from '../gqty';

  // ...

  const controller = new AbortController();

  await resolved(() => query.currentUser?.email, {
    fetchOptions: {
      headers: {
        'Content-Type': 'application/json',
        authorization: 'secret_token',
      },
      signal: controller.signal,
    },
  });
  ```

  For already generated clients to be able to use this new option, it is
  required manually modify the existing query fetcher, to do for example:

  ```ts
  const queryFetcher: QueryFetcher = async function (
    query,
    variables,
    fetchOptions
  ) {
    const response = await fetch(endpoint, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({
        query,
        variables,
      }),
      ...fetchOptions,
    });

    const json = await response.json();

    return json;
  };
  ```

- b7c8710: Fix generator: Argument is required only if it is non-null and does
  not have default value. Previously only checking if it is non-null.

### Patch Changes

- Updated dependencies [dd47986]
  - gqty@2.2.0

## 3.1.0

### Minor Changes

- 4c43e7a: New "transformSchema" configuration

### Patch Changes

- 46efcd2: Use `undici` for network schema introspection
- 18e719b: Fix interop graphql import

## 3.0.1

### Patch Changes

- 3ac7bee: Use "import \* as" to prevent esm-cjs interop issues

## 3.0.0

### Major Changes

- c7b80c8: Minimize npm dependencies

### Minor Changes

- f9fd0b9: Added the ability to use fast-glob patterns in the schema generate
  endpoint to be able to use and combine multiple gql/graphql schema files

## 2.3.1

### Patch Changes

- 96ab370: Change export syntax to fix bundling issues, show a warning on
  existent generated clients with `export const {` syntax.

  Closes #292

## 2.3.0

### Minor Changes

- 0b1860a: lexicographic sort GraphQL Schema before generating
- 82fd259: Use ESM for CLI

### Patch Changes

- Updated dependencies [6df0318]
  - gqty@2.1.0

## 2.2.0

### Minor Changes

- cba5c43: Don't skip config read on NODE_ENV === "test"
- a4fc294: New [Envelop](https://www.envelop.dev/) /
  [graphql-ez](https://www.graphql-ez.com/) plugin that automatically generates
  gqty code based on schema and gqty.config.cjs

  ```ts
  // graphql-ez

  // ...
  import { useGenerateGQty } from '@gqty/cli/envelop';

  const ezApp = CreateApp({
    // ...
    envelop: {
      plugins: [
        // ...
        useGenerateGQty({
          // ...
        }),
      ],
    },
  });
  ```

  ```ts
  // Envelop

  import { envelop } from '@envelop/core';
  import { useGenerateGQty } from '@gqty/cli/envelop';

  //...

  const getEnveloped = envelop({
    plugins: [
      // ...
      useGenerateGQty({
        // ...
      }),
    ],
  });
  ```

### Patch Changes

- aab8e48: Fix: don't put invalid default generate endpoint
- f72aa23: GraphQL v16 compatibility

  closes #268

## 2.1.2

### Patch Changes

- 2b33e6a: Add missing useSubscription in generated react code

## 2.1.1

### Patch Changes

- f4ddac9: Enforce `"importsNotUsedAsValues"` & `"preserveValueImports"` using
  `import type`
- ff821ef: default config react enabled only if "react" dependency is found

## 2.1.0

### Minor Changes

- c993f2e: Sort alphabetically generated code

### Patch Changes

- 0a30558: Fix misplaced semi-colons in input types

## 2.0.1

### Patch Changes

- 28e2c09: [Bug fixing breaking change] Fix types and retrieval of unions/interfaces
  of different object types
- Updated dependencies [28e2c09]
  - gqty@2.0.1

## 2.0.0

### Major Changes

- 3586c45: Change previous unstable `Unions` support with new `"$on"` property
  with support for both `Unions` & `Interfaces`

### Patch Changes

- Updated dependencies [3586c45]
- Updated dependencies [3586c45]
  - gqty@2.0.0

## 1.1.4

### Patch Changes

- 5446d83: Fix/Improve config loading
- Updated dependencies [1fc2672]
  - gqty@1.1.2

## 1.1.3

### Patch Changes

- 9faebb6: fix dynamic import transpilation

## 1.1.2

### Patch Changes

- d097ae3: fix ESM build

## 1.1.1

### Patch Changes

- cad0d92: fix false positive error after second call on inspectWriteGenerate

## 1.1.0

### Minor Changes

- f860c01: change \_\_typename undefined to optional undefined

### Patch Changes

- Updated dependencies [a216972]
  - gqty@1.1.0

## 1.0.4

### Patch Changes

- bd31ab8: fix cli package json read

## 1.0.3

### Patch Changes

- f0315c4: fix js target

## 1.0.2

### Patch Changes

- 0f9e0e8: fix build

## 1.0.1

### Patch Changes

- 3784c2b: release
- Updated dependencies [3784c2b]
  - gqty@1.0.1

## 2.0.18

### Patch Changes

- a88d4e8: fix generated schema use scoped gqty

## 2.0.17

### Patch Changes

- 3f08372: publish fork
- Updated dependencies [3f08372]
  - gqty@2.0.15

## 2.0.16

### Patch Changes

- 422eb9a: fix importsNotUsedAsValues error on generated schema
- Updated dependencies [422eb9a]
- Updated dependencies [422eb9a]
  - gqty@2.0.14

## 2.0.15

### Patch Changes

- 4a3d5ef: allow introspection json without "data" field
- af6a437: - Rename `gqtyConfig` to `GQtyConfig` (so it's consistent with the
  new logo)
  - Rename `gqtyError` to `GQtyError`
  - Remove `endpoint` option from the configuration, and instead always defaults
    to introspection one
    - It's confusing why theres two of them, and the user can change it later by
      modifying the file anyway
- 4a3d5ef: disable config file write if no cli usage
- Updated dependencies [4a3d5ef]
- Updated dependencies [af6a437]
  - gqty@2.0.13

## 2.0.14

### Patch Changes

- 7e084fb: accept json introspection schema result

## 2.0.13

### Patch Changes

- 9b9d127: add "usePaginatedQuery" hook
- Updated dependencies [85a389c]
- Updated dependencies [cca9d02]
- Updated dependencies [0904297]
  - gqty@2.0.11

## 2.0.12

### Patch Changes

- Updated dependencies [65c4d32]
  - gqty@2.0.10

## 2.0.11

### Patch Changes

- 5d89cbd: fix generated interfaces
- Updated dependencies [6a9269f]
  - gqty@2.0.9

## 2.0.10

### Patch Changes

- Updated dependencies [c74442e]
- Updated dependencies [d78f2ab]
- Updated dependencies [0ffaa9d]
  - gqty@2.0.8

## 2.0.9

### Patch Changes

- Updated dependencies [ff66195]
- Updated dependencies [63fd3ea]
- Updated dependencies [40d2101]
  - gqty@2.0.7

## 2.0.8

### Patch Changes

- 1eaa4b4: fix not null args & nullable scalar fields

## 2.0.7

### Patch Changes

- eb45ca2: improve generate config conflict warning
- Updated dependencies [173e11d]
- Updated dependencies [c613410]
  - gqty@2.0.6

## 2.0.6

### Patch Changes

- 8f1a329: add "ignoreArgs" schema transform
- Updated dependencies [6fef085]
  - gqty@2.0.5

## 2.0.5

### Patch Changes

- 940883a: fix yarn berry compatibility

## 2.0.4

### Patch Changes

- 2bf4ce2: improve config validation & add javascript output
- Updated dependencies [2bf4ce2]
  - gqty@2.0.4

## 2.0.3

### Patch Changes

- 27f9ece: set "graphql" as optional peerDependency
- Updated dependencies [27f9ece]
  - gqty@2.0.3

## 2.0.2

### Patch Changes

- 7d932f8: fix import gqty
- 6f9416d: set "gqty" as direct dependency
- Updated dependencies [c06ef80]
  - gqty@2.0.2

## 2.0.1

### Patch Changes

- a57cab4: official beta v2 publish
- Updated dependencies [a57cab4]
  - gqty@2.0.1
