/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DiskFileItemSerializeTest {
    private static final File REPO = new File(System.getProperty("java.io.tmpdir"), "diskfileitemrepo");
    private static final String textContentType = "text/plain";
    private static final int threshold = 16;

    @Before
    public void setUp() throws Exception {
        if (REPO.exists()) {
            FileUtils.deleteDirectory((File)REPO);
        }
        FileUtils.forceMkdir((File)REPO);
    }

    @After
    public void tearDown() throws IOException {
        for (File file : FileUtils.listFiles((File)REPO, null, (boolean)true)) {
            System.out.println("Found leftover file " + file);
        }
        FileUtils.deleteDirectory((File)REPO);
    }

    public void testInMemoryObject(byte[] testFieldValueBytes, File repository) {
        FileItem item = this.createFileItem(testFieldValueBytes, repository);
        Assert.assertTrue((String)"Initial: in memory", (boolean)item.isInMemory());
        Assert.assertEquals((String)"Initial: size", (long)item.getSize(), (long)testFieldValueBytes.length);
        this.compareBytes("Initial", item.get(), testFieldValueBytes);
        item.delete();
    }

    private void testInMemoryObject(byte[] testFieldValueBytes) {
        this.testInMemoryObject(testFieldValueBytes, REPO);
    }

    @Test
    public void testBelowThreshold() {
        byte[] testFieldValueBytes = this.createContentBytes(15);
        this.testInMemoryObject(testFieldValueBytes);
    }

    @Test
    public void testThreshold() {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        this.testInMemoryObject(testFieldValueBytes);
    }

    @Test
    public void testAboveThreshold() {
        byte[] testFieldValueBytes = this.createContentBytes(17);
        FileItem item = this.createFileItem(testFieldValueBytes);
        Assert.assertFalse((String)"Initial: in memory", (boolean)item.isInMemory());
        Assert.assertEquals((String)"Initial: size", (long)item.getSize(), (long)testFieldValueBytes.length);
        this.compareBytes("Initial", item.get(), testFieldValueBytes);
        item.delete();
    }

    @Test
    public void testValidRepository() {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        this.testInMemoryObject(testFieldValueBytes, REPO);
    }

    @Test(expected=IOException.class)
    public void testInvalidRepository() throws Exception {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        File repository = new File(System.getProperty("java.io.tmpdir"), "file");
        FileItem item = this.createFileItem(testFieldValueBytes, repository);
        this.deserialize(this.serialize(item));
    }

    @Test(expected=IOException.class)
    public void testInvalidRepositoryWithNullChar() throws Exception {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        File repository = new File(System.getProperty("java.io.tmpdir"), "\u0000");
        FileItem item = this.createFileItem(testFieldValueBytes, repository);
        this.deserialize(this.serialize(item));
    }

    private void compareBytes(String text, byte[] origBytes, byte[] newBytes) {
        Assert.assertNotNull((String)"origBytes must not be null", (Object)origBytes);
        Assert.assertNotNull((String)"newBytes must not be null", (Object)newBytes);
        Assert.assertEquals((String)(text + " byte[] length"), (long)origBytes.length, (long)newBytes.length);
        for (int i = 0; i < origBytes.length; ++i) {
            Assert.assertEquals((String)(text + " byte[" + i + "]"), (long)origBytes[i], (long)newBytes[i]);
        }
    }

    private byte[] createContentBytes(int size) {
        StringBuilder buffer = new StringBuilder(size);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            buffer.append(count + "");
            count = (byte)(count + 1);
            if (count <= 9) continue;
            count = 0;
        }
        return buffer.toString().getBytes();
    }

    private FileItem createFileItem(byte[] contentBytes, File repository) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, repository);
        String textFieldName = "textField";
        FileItem item = factory.createItem(textFieldName, textContentType, true, "My File Name");
        try {
            OutputStream os = item.getOutputStream();
            os.write(contentBytes);
            os.close();
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected IOException" + e));
        }
        return item;
    }

    private FileItem createFileItem(byte[] contentBytes) {
        return this.createFileItem(contentBytes, REPO);
    }

    private ByteArrayOutputStream serialize(Object target) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(target);
        oos.flush();
        oos.close();
        return baos;
    }

    private Object deserialize(ByteArrayOutputStream baos) throws Exception {
        Object result = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        result = ois.readObject();
        bais.close();
        return result;
    }
}

