/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class DeferredFileOutputStreamTest {
    private final String testString = "0123456789";
    private final byte[] testBytes = "0123456789".getBytes();

    public static IntStream data() {
        return IntStream.of(1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096);
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testBelowThreshold(int initialBufferSize) {
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length + 42, initialBufferSize, null);
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            Assertions.fail((String)"Unexpected IOException");
        }
        Assertions.assertTrue((boolean)dfos.isInMemory());
        byte[] resultBytes = dfos.getData();
        Assertions.assertEquals((int)this.testBytes.length, (int)resultBytes.length);
        Assertions.assertTrue((boolean)Arrays.equals(resultBytes, this.testBytes));
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testAtThreshold(int initialBufferSize) {
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length, initialBufferSize, null);
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            Assertions.fail((String)"Unexpected IOException");
        }
        Assertions.assertTrue((boolean)dfos.isInMemory());
        byte[] resultBytes = dfos.getData();
        Assertions.assertEquals((int)this.testBytes.length, (int)resultBytes.length);
        Assertions.assertTrue((boolean)Arrays.equals(resultBytes, this.testBytes));
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testAboveThreshold(int initialBufferSize) {
        File testFile = new File("testAboveThreshold.dat");
        testFile.delete();
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length - 5, initialBufferSize, testFile);
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            Assertions.fail((String)"Unexpected IOException");
        }
        Assertions.assertFalse((boolean)dfos.isInMemory());
        Assertions.assertNull((Object)dfos.getData());
        this.verifyResultFile(testFile);
        testFile.delete();
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testThresholdReached(int initialBufferSize) {
        File testFile = new File("testThresholdReached.dat");
        testFile.delete();
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length / 2, initialBufferSize, testFile);
        int chunkSize = this.testBytes.length / 3;
        try {
            dfos.write(this.testBytes, 0, chunkSize);
            dfos.write(this.testBytes, chunkSize, chunkSize);
            dfos.write(this.testBytes, chunkSize * 2, this.testBytes.length - chunkSize * 2);
            dfos.close();
        }
        catch (IOException e) {
            Assertions.fail((String)"Unexpected IOException");
        }
        Assertions.assertFalse((boolean)dfos.isInMemory());
        Assertions.assertNull((Object)dfos.getData());
        this.verifyResultFile(testFile);
        testFile.delete();
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testWriteToSmall(int initialBufferSize) {
        File testFile = new File("testWriteToMem.dat");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(initialBufferSize);
        testFile.delete();
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length * 2, initialBufferSize, testFile);
        try {
            dfos.write(this.testBytes);
            Assertions.assertFalse((boolean)testFile.exists());
            Assertions.assertTrue((boolean)dfos.isInMemory());
            try {
                dfos.writeTo((OutputStream)baos);
                Assertions.fail((String)"Should not have been able to write before closing");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            dfos.close();
            dfos.writeTo((OutputStream)baos);
        }
        catch (IOException ioe) {
            Assertions.fail((String)"Unexpected IOException");
        }
        byte[] copiedBytes = baos.toByteArray();
        Assertions.assertTrue((boolean)Arrays.equals(this.testBytes, copiedBytes));
        testFile.delete();
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testWriteToLarge(int initialBufferSize) {
        File testFile = new File("testWriteToFile.dat");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(initialBufferSize);
        testFile.delete();
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length / 2, testFile);
        try {
            dfos.write(this.testBytes);
            Assertions.assertTrue((boolean)testFile.exists());
            Assertions.assertFalse((boolean)dfos.isInMemory());
            try {
                dfos.writeTo((OutputStream)baos);
                Assertions.fail((String)"Should not have been able to write before closeing");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            dfos.close();
            dfos.writeTo((OutputStream)baos);
        }
        catch (IOException ioe) {
            Assertions.fail((String)"Unexpected IOException");
        }
        byte[] copiedBytes = baos.toByteArray();
        Assertions.assertTrue((boolean)Arrays.equals(this.testBytes, copiedBytes));
        this.verifyResultFile(testFile);
        testFile.delete();
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testTempFileBelowThreshold(int initialBufferSize) {
        String prefix = "commons-io-test";
        String suffix = ".out";
        File tempDir = new File(".");
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length + 42, initialBufferSize, "commons-io-test", ".out", tempDir);
        Assertions.assertNull((Object)dfos.getFile(), (String)"Check file is null-A");
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            Assertions.fail((String)"Unexpected IOException");
        }
        Assertions.assertTrue((boolean)dfos.isInMemory());
        Assertions.assertNull((Object)dfos.getFile(), (String)"Check file is null-B");
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testTempFileAboveThreshold(int initialBufferSize) {
        String prefix = "commons-io-test";
        String suffix = ".out";
        File tempDir = new File(".");
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length - 5, initialBufferSize, "commons-io-test", ".out", tempDir);
        Assertions.assertNull((Object)dfos.getFile(), (String)"Check file is null-A");
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            Assertions.fail((String)"Unexpected IOException");
        }
        Assertions.assertFalse((boolean)dfos.isInMemory());
        Assertions.assertNull((Object)dfos.getData());
        Assertions.assertNotNull((Object)dfos.getFile(), (String)"Check file not null");
        Assertions.assertTrue((boolean)dfos.getFile().exists(), (String)"Check file exists");
        Assertions.assertTrue((boolean)dfos.getFile().getName().startsWith("commons-io-test"), (String)"Check prefix");
        Assertions.assertTrue((boolean)dfos.getFile().getName().endsWith(".out"), (String)"Check suffix");
        Assertions.assertEquals((Object)tempDir.getPath(), (Object)dfos.getFile().getParent(), (String)"Check dir");
        this.verifyResultFile(dfos.getFile());
        dfos.getFile().delete();
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    public void testTempFileAboveThresholdPrefixOnly(int initialBufferSize) {
        String prefix = "commons-io-test";
        String suffix = null;
        File tempDir = null;
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length - 5, initialBufferSize, "commons-io-test", suffix, tempDir);
        Assertions.assertNull((Object)dfos.getFile(), (String)"Check file is null-A");
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            Assertions.fail((String)"Unexpected IOException");
        }
        Assertions.assertFalse((boolean)dfos.isInMemory());
        Assertions.assertNull((Object)dfos.getData());
        Assertions.assertNotNull((Object)dfos.getFile(), (String)"Check file not null");
        Assertions.assertTrue((boolean)dfos.getFile().exists(), (String)"Check file exists");
        Assertions.assertTrue((boolean)dfos.getFile().getName().startsWith("commons-io-test"), (String)"Check prefix");
        Assertions.assertTrue((boolean)dfos.getFile().getName().endsWith(".tmp"), (String)"Check suffix");
        this.verifyResultFile(dfos.getFile());
        dfos.getFile().delete();
    }

    @Test
    public void testTempFileError() throws Exception {
        String prefix = null;
        String suffix = ".out";
        File tempDir = new File(".");
        try {
            new DeferredFileOutputStream(this.testBytes.length - 5, prefix, ".out", tempDir).close();
            Assertions.fail((String)"Expected IllegalArgumentException ");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void verifyResultFile(File testFile) {
        try {
            FileInputStream fis = new FileInputStream(testFile);
            Assertions.assertEquals((int)this.testBytes.length, (int)fis.available());
            byte[] resultBytes = new byte[this.testBytes.length];
            Assertions.assertEquals((int)this.testBytes.length, (int)fis.read(resultBytes));
            Assertions.assertTrue((boolean)Arrays.equals(resultBytes, this.testBytes));
            Assertions.assertEquals((int)-1, (int)fis.read(resultBytes));
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException e) {
            Assertions.fail((String)"Unexpected FileNotFoundException");
        }
        catch (IOException e) {
            Assertions.fail((String)"Unexpected IOException");
        }
    }
}

