/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.output.BrokenWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BrokenWriterTest {
    private IOException exception;
    private Writer writer;

    @BeforeEach
    public void setUp() {
        this.exception = new IOException("test exception");
        this.writer = new BrokenWriter(this.exception);
    }

    @Test
    public void testWrite() {
        try {
            this.writer.write(1);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.writer.write(new char[1]);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.writer.write(new char[1], 0, 1);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testFlush() {
        try {
            this.writer.flush();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testClose() {
        try {
            this.writer.close();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }
}

