/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Random;
import org.apache.commons.io.input.buffer.CircularBufferInputStream;
import org.junit.jupiter.api.Test;

public class CircularBufferInputStreamTest {
    private final Random rnd = new Random(1530960934483L);

    @Test
    public void testRandomRead() throws Exception {
        byte[] inputBuffer = this.newInputBuffer();
        byte[] bufferCopy = new byte[inputBuffer.length];
        ByteArrayInputStream bais = new ByteArrayInputStream(inputBuffer);
        CircularBufferInputStream cbis = new CircularBufferInputStream((InputStream)bais, 253);
        int offset = 0;
        byte[] readBuffer = new byte[256];
        block4: while (offset < bufferCopy.length) {
            switch (this.rnd.nextInt(2)) {
                case 0: {
                    int res = cbis.read();
                    if (res == -1) {
                        throw new IllegalStateException("Unexpected EOF at offset " + offset);
                    }
                    if (inputBuffer[offset] != res) {
                        throw new IllegalStateException("Expected " + inputBuffer[offset] + " at offset " + offset + ", got " + res);
                    }
                    ++offset;
                    continue block4;
                }
                case 1: {
                    int res = cbis.read(readBuffer, 0, this.rnd.nextInt(readBuffer.length + 1));
                    if (res == -1) {
                        throw new IllegalStateException("Unexpected EOF at offset " + offset);
                    }
                    if (res == 0) {
                        throw new IllegalStateException("Unexpected zero-byte-result at offset " + offset);
                    }
                    for (int i = 0; i < res; ++i) {
                        if (inputBuffer[offset] != readBuffer[i]) {
                            throw new IllegalStateException("Expected " + inputBuffer[offset] + " at offset " + offset + ", got " + readBuffer[i]);
                        }
                        ++offset;
                    }
                    continue block4;
                }
            }
            throw new IllegalStateException("Unexpected random choice value");
        }
    }

    private byte[] newInputBuffer() {
        byte[] buffer = new byte[8192 + this.rnd.nextInt(512)];
        this.rnd.nextBytes(buffer);
        return buffer;
    }
}

