/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.testtools.YellOnCloseInputStream;
import org.apache.commons.io.testtools.YellOnCloseOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TeeInputStreamTest {
    private final String ASCII = "US-ASCII";
    private InputStream tee;
    private ByteArrayOutputStream output;

    @BeforeEach
    public void setUp() throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream("abc".getBytes("US-ASCII"));
        this.output = new ByteArrayOutputStream();
        this.tee = new TeeInputStream((InputStream)input, (OutputStream)this.output);
    }

    @Test
    public void testReadNothing() throws Exception {
        Assertions.assertEquals((Object)"", (Object)new String(this.output.toString("US-ASCII")));
    }

    @Test
    public void testReadOneByte() throws Exception {
        Assertions.assertEquals((int)97, (int)this.tee.read());
        Assertions.assertEquals((Object)"a", (Object)new String(this.output.toString("US-ASCII")));
    }

    @Test
    public void testReadEverything() throws Exception {
        Assertions.assertEquals((int)97, (int)this.tee.read());
        Assertions.assertEquals((int)98, (int)this.tee.read());
        Assertions.assertEquals((int)99, (int)this.tee.read());
        Assertions.assertEquals((int)-1, (int)this.tee.read());
        Assertions.assertEquals((Object)"abc", (Object)new String(this.output.toString("US-ASCII")));
    }

    @Test
    public void testReadToArray() throws Exception {
        byte[] buffer = new byte[8];
        Assertions.assertEquals((int)3, (int)this.tee.read(buffer));
        Assertions.assertEquals((int)97, (int)buffer[0]);
        Assertions.assertEquals((int)98, (int)buffer[1]);
        Assertions.assertEquals((int)99, (int)buffer[2]);
        Assertions.assertEquals((int)-1, (int)this.tee.read(buffer));
        Assertions.assertEquals((Object)"abc", (Object)new String(this.output.toString("US-ASCII")));
    }

    @Test
    public void testReadToArrayWithOffset() throws Exception {
        byte[] buffer = new byte[8];
        Assertions.assertEquals((int)3, (int)this.tee.read(buffer, 4, 4));
        Assertions.assertEquals((int)97, (int)buffer[4]);
        Assertions.assertEquals((int)98, (int)buffer[5]);
        Assertions.assertEquals((int)99, (int)buffer[6]);
        Assertions.assertEquals((int)-1, (int)this.tee.read(buffer, 4, 4));
        Assertions.assertEquals((Object)"abc", (Object)new String(this.output.toString("US-ASCII")));
    }

    @Test
    public void testSkip() throws Exception {
        Assertions.assertEquals((int)97, (int)this.tee.read());
        Assertions.assertEquals((long)1L, (long)this.tee.skip(1L));
        Assertions.assertEquals((int)99, (int)this.tee.read());
        Assertions.assertEquals((int)-1, (int)this.tee.read());
        Assertions.assertEquals((Object)"ac", (Object)new String(this.output.toString("US-ASCII")));
    }

    @Test
    public void testMarkReset() throws Exception {
        Assertions.assertEquals((int)97, (int)this.tee.read());
        this.tee.mark(1);
        Assertions.assertEquals((int)98, (int)this.tee.read());
        this.tee.reset();
        Assertions.assertEquals((int)98, (int)this.tee.read());
        Assertions.assertEquals((int)99, (int)this.tee.read());
        Assertions.assertEquals((int)-1, (int)this.tee.read());
        Assertions.assertEquals((Object)"abbc", (Object)new String(this.output.toString("US-ASCII")));
    }

    @Test
    public void testCloseBranchIOException() throws Exception {
        ByteArrayInputStream goodIs = (ByteArrayInputStream)Mockito.mock(ByteArrayInputStream.class);
        YellOnCloseOutputStream badOs = new YellOnCloseOutputStream();
        TeeInputStream nonClosingTis = new TeeInputStream((InputStream)goodIs, (OutputStream)((Object)badOs), false);
        nonClosingTis.close();
        ((ByteArrayInputStream)Mockito.verify((Object)goodIs)).close();
        TeeInputStream closingTis = new TeeInputStream((InputStream)goodIs, (OutputStream)((Object)badOs), true);
        try {
            closingTis.close();
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOException e) {
            ((ByteArrayInputStream)Mockito.verify((Object)goodIs, (VerificationMode)Mockito.times((int)2))).close();
        }
    }

    @Test
    public void testCloseMainIOException() throws IOException {
        YellOnCloseInputStream badIs = new YellOnCloseInputStream();
        ByteArrayOutputStream goodOs = (ByteArrayOutputStream)Mockito.mock(ByteArrayOutputStream.class);
        TeeInputStream nonClosingTis = new TeeInputStream((InputStream)((Object)badIs), (OutputStream)goodOs, false);
        try {
            nonClosingTis.close();
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOException e) {
            ((ByteArrayOutputStream)Mockito.verify((Object)goodOs, (VerificationMode)Mockito.never())).close();
        }
        TeeInputStream closingTis = new TeeInputStream((InputStream)((Object)badIs), (OutputStream)goodOs, true);
        try {
            closingTis.close();
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOException e) {
            ((ByteArrayOutputStream)Mockito.verify((Object)goodOs)).close();
        }
    }
}

