/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOFunctionTest {
    @Test
    public void testApply() throws IOException {
        IOFunction readByte = is -> is.read();
        ByteArrayInputStream is2 = new ByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)10, (Integer)((Integer)readByte.apply((Object)is2)));
        Assertions.assertEquals((int)11, (Integer)((Integer)readByte.apply((Object)is2)));
        Assertions.assertEquals((int)12, (Integer)((Integer)readByte.apply((Object)is2)));
        Assertions.assertEquals((int)-1, (Integer)((Integer)readByte.apply((Object)is2)));
    }

    @Test
    public void testApplyRaisesException() {
        IOFunction raiseException = is -> {
            throw new IOException("Boom!");
        };
        ByteArrayInputStream is2 = new ByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertThrows(IOException.class, () -> raiseException.apply((Object)is2));
    }

    @Test
    public void testComposeIOFunction() throws IOException {
        IOFunction readByte = is -> is.read();
        IOFunction squareInteger = i -> i * i;
        IOFunction productFunction = squareInteger.compose(readByte);
        ByteArrayInputStream is2 = new ByteArrayInputStream(new byte[]{2, 3});
        Assertions.assertEquals((int)4, (Integer)((Integer)productFunction.apply((Object)is2)));
        Assertions.assertEquals((int)9, (Integer)((Integer)productFunction.apply((Object)is2)));
    }

    @Test
    public void testComposeFunction() throws IOException {
        Function<InputStream, Integer> alwaysSeven = is -> 7;
        IOFunction squareInteger = i -> i * i;
        IOFunction productFunction = squareInteger.compose(alwaysSeven);
        ByteArrayInputStream is2 = new ByteArrayInputStream(new byte[]{2, 3});
        Assertions.assertEquals((int)49, (Integer)((Integer)productFunction.apply((Object)is2)));
        Assertions.assertEquals((int)49, (Integer)((Integer)productFunction.apply((Object)is2)));
    }

    @Test
    public void testComposeIOSupplier() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{2, 3});
        IOSupplier readByte = () -> is.read();
        IOFunction squareInteger = i -> i * i;
        IOSupplier productFunction = squareInteger.compose(readByte);
        Assertions.assertEquals((int)4, (Integer)((Integer)productFunction.get()));
        Assertions.assertEquals((int)9, (Integer)((Integer)productFunction.get()));
    }

    @Test
    public void testComposeSupplier() throws IOException {
        Supplier<Integer> alwaysNine = () -> 9;
        IOFunction squareInteger = i -> i * i;
        IOSupplier productFunction = squareInteger.compose(alwaysNine);
        Assertions.assertEquals((int)81, (Integer)((Integer)productFunction.get()));
        Assertions.assertEquals((int)81, (Integer)((Integer)productFunction.get()));
    }

    @Test
    public void testAndThenIOFunction() throws IOException {
        IOFunction readByte = is -> is.read();
        IOFunction squareInteger = i -> i * i;
        IOFunction productFunction = readByte.andThen(squareInteger);
        ByteArrayInputStream is2 = new ByteArrayInputStream(new byte[]{2, 3});
        Assertions.assertEquals((int)4, (Integer)((Integer)productFunction.apply((Object)is2)));
        Assertions.assertEquals((int)9, (Integer)((Integer)productFunction.apply((Object)is2)));
    }

    @Test
    public void testAndThenFunction() throws IOException {
        IOFunction readByte = is -> is.read();
        Function<Integer, Integer> squareInteger = i -> i * i;
        IOFunction productFunction = readByte.andThen(squareInteger);
        ByteArrayInputStream is2 = new ByteArrayInputStream(new byte[]{2, 3});
        Assertions.assertEquals((int)4, (Integer)((Integer)productFunction.apply((Object)is2)));
        Assertions.assertEquals((int)9, (Integer)((Integer)productFunction.apply((Object)is2)));
    }

    @Test
    public void testAndThenIOConsumer() throws IOException {
        Holder holder = new Holder();
        IOFunction readByte = is -> is.read();
        IOConsumer sinkInteger = i -> {
            holder.value = i * i;
        };
        IOConsumer productFunction = readByte.andThen(sinkInteger);
        ByteArrayInputStream is2 = new ByteArrayInputStream(new byte[]{2, 3});
        productFunction.accept((Object)is2);
        Assertions.assertEquals((int)4, (Integer)((Integer)holder.value));
        productFunction.accept((Object)is2);
        Assertions.assertEquals((int)9, (Integer)((Integer)holder.value));
    }

    @Test
    public void testAndThenConsumer() throws IOException {
        Holder holder = new Holder();
        IOFunction readByte = is -> is.read();
        Consumer<Integer> sinkInteger = i -> {
            holder.value = i * i;
        };
        IOConsumer productFunction = readByte.andThen(sinkInteger);
        ByteArrayInputStream is2 = new ByteArrayInputStream(new byte[]{2, 3});
        productFunction.accept((Object)is2);
        Assertions.assertEquals((int)4, (Integer)((Integer)holder.value));
        productFunction.accept((Object)is2);
        Assertions.assertEquals((int)9, (Integer)((Integer)holder.value));
    }

    @Test
    public void testIdentity() throws IOException {
        IOFunction identityFunction = IOFunction.identity();
        try (ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{10, 11, 12});){
            Assertions.assertEquals((Object)is, (Object)identityFunction.apply((Object)is));
        }
    }

    private static class Holder<T> {
        T value;

        private Holder() {
        }
    }
}

