/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.PathUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PathUtilsDeleteDirectoryTest {
    private Path tempDir;

    @AfterEach
    public void afterEach() throws IOException {
        if (Files.exists(this.tempDir, new LinkOption[0]) && PathUtils.isEmptyDirectory((Path)this.tempDir)) {
            Files.deleteIfExists(this.tempDir);
        }
    }

    @BeforeEach
    public void beforeEach() throws IOException {
        this.tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
    }

    @Test
    public void testDeleteDirectory1FileSize0() throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(1L, 1L, 0L, PathUtils.deleteDirectory((Path)this.tempDir));
        Files.deleteIfExists(this.tempDir);
    }

    @Test
    public void testDeleteDirectory1FileSize1() throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(1L, 1L, 1L, PathUtils.deleteDirectory((Path)this.tempDir));
        Files.deleteIfExists(this.tempDir);
    }

    @Test
    public void testDeleteDirectory2FileSize2() throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(3L, 2L, 2L, PathUtils.deleteDirectory((Path)this.tempDir));
        Files.deleteIfExists(this.tempDir);
    }

    @Test
    public void testDeleteEmptyDirectory() throws IOException {
        CounterAssertions.assertCounts(1L, 0L, 0L, PathUtils.deleteDirectory((Path)this.tempDir));
        Files.deleteIfExists(this.tempDir);
    }
}

