/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.EOFException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOExceptionList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOExceptionListTestCase {
    @Test
    public void testCause() {
        EOFException cause = new EOFException();
        List<EOFException> list = Collections.singletonList(cause);
        IOExceptionList sqlExceptionList = new IOExceptionList(list);
        Assertions.assertEquals((Object)cause, (Object)sqlExceptionList.getCause());
        Assertions.assertEquals((Object)cause, (Object)sqlExceptionList.getCause(0));
        Assertions.assertEquals(list, (Object)sqlExceptionList.getCauseList());
        Assertions.assertEquals(list, (Object)sqlExceptionList.getCauseList(EOFException.class));
        Assertions.assertEquals((Object)cause, (Object)sqlExceptionList.getCause(0, EOFException.class));
        List causeList = sqlExceptionList.getCauseList();
        Assertions.assertEquals(list, (Object)causeList);
    }

    @Test
    public void testNullCause() {
        IOExceptionList sqlExceptionList = new IOExceptionList(null);
        Assertions.assertNull((Object)sqlExceptionList.getCause());
        Assertions.assertTrue((boolean)sqlExceptionList.getCauseList().isEmpty());
    }

    @Test
    public void testPrintStackTrace() {
        EOFException cause = new EOFException();
        List<EOFException> list = Collections.singletonList(cause);
        IOExceptionList sqlExceptionList = new IOExceptionList(list);
        sqlExceptionList.printStackTrace();
    }
}

