/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileUtilsFileNewerTestCase {
    @TempDir
    public File temporaryFolder;
    private static final int FILE1_SIZE = 1;
    private static final int FILE2_SIZE = 4097;
    private File m_testFile1;
    private File m_testFile2;

    @BeforeEach
    public void setUp() throws Exception {
        this.m_testFile1 = new File(this.temporaryFolder, "file1-test.txt");
        this.m_testFile2 = new File(this.temporaryFolder, "file2-test.txt");
        if (!this.m_testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.m_testFile1 + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(this.m_testFile1));){
            TestUtils.generateTestData(output1, 1L);
        }
        if (!this.m_testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.m_testFile2 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.m_testFile2));){
            TestUtils.generateTestData(output, 4097L);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testIsFileNewer() {
        if (!this.m_testFile1.exists()) {
            throw new IllegalStateException("The m_testFile1 should exist");
        }
        long fileLastModified = this.m_testFile1.lastModified();
        long TWO_SECOND = 2000L;
        this.testIsFileNewer("two second earlier is not newer", this.m_testFile1, fileLastModified + 2000L, false);
        this.testIsFileNewer("same time is not newer", this.m_testFile1, fileLastModified, false);
        this.testIsFileNewer("two second later is newer", this.m_testFile1, fileLastModified - 2000L, true);
    }

    @Test
    public void testIsFileNewerImaginaryFile() {
        File imaginaryFile = new File(this.temporaryFolder, "imaginaryFile");
        if (imaginaryFile.exists()) {
            throw new IllegalStateException("The imaginary File exists");
        }
        this.testIsFileNewer("imaginary file can be newer", imaginaryFile, this.m_testFile2.lastModified(), false);
    }

    protected void testIsFileNewer(String description, File file, long time, boolean wantedResult) {
        Assertions.assertEquals((Object)wantedResult, (Object)FileUtils.isFileNewer((File)file, (long)time), (String)(description + " - time"));
        Assertions.assertEquals((Object)wantedResult, (Object)FileUtils.isFileNewer((File)file, (Date)new Date(time)), (String)(description + " - date"));
        File temporaryFile = this.m_testFile2;
        temporaryFile.setLastModified(time);
        Assertions.assertEquals((long)time, (long)temporaryFile.lastModified(), (String)"The temporary file hasn't the right last modification date");
        Assertions.assertEquals((Object)wantedResult, (Object)FileUtils.isFileNewer((File)file, (File)temporaryFile), (String)(description + " - file"));
    }

    @Test
    public void testIsFileNewerNoFile() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.isFileNewer(null, (long)0L), (String)"File not specified");
    }

    @Test
    public void testIsFileNewerNoDate() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.isFileNewer((File)this.m_testFile1, (Date)null), (String)"Date not specified");
    }

    @Test
    public void testIsFileNewerNoFileReference() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.isFileNewer((File)this.m_testFile1, (File)null), (String)"Reference file is not specified");
    }
}

