/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileUtilsCopyDirectoryToDirectoryTestCase {
    @TempDir
    public File temporaryFolder;

    @Test
    public void copyDirectoryToDirectoryThrowsIllegalExceptionWithCorrectMessageWhenSrcDirIsNotDirectory() throws IOException {
        File srcDir = File.createTempFile("notadireotry", null, this.temporaryFolder);
        File destDir = new File(this.temporaryFolder, "destinationDirectory");
        destDir.mkdirs();
        String expectedMessage = String.format("Source '%s' is not a directory", srcDir);
        FileUtilsCopyDirectoryToDirectoryTestCase.assertExceptionTypeAndMessage(srcDir, destDir, IllegalArgumentException.class, expectedMessage);
    }

    @Test
    public void copyDirectoryToDirectoryThrowsIllegalArgumentExceptionWithCorrectMessageWhenDstDirIsNotDirectory() throws IOException {
        File srcDir = new File(this.temporaryFolder, "sourceDirectory");
        srcDir.mkdir();
        File destDir = new File(this.temporaryFolder, "notadirectory");
        destDir.createNewFile();
        String expectedMessage = String.format("Destination '%s' is not a directory", destDir);
        FileUtilsCopyDirectoryToDirectoryTestCase.assertExceptionTypeAndMessage(srcDir, destDir, IllegalArgumentException.class, expectedMessage);
    }

    @Test
    public void copyDirectoryToDirectoryThrowsNullPointerExceptionWithCorrectMessageWhenSrcDirIsNull() {
        File srcDir = null;
        File destinationDirectory = new File(this.temporaryFolder, "destinationDirectory");
        destinationDirectory.mkdir();
        FileUtilsCopyDirectoryToDirectoryTestCase.assertExceptionTypeAndMessage(srcDir, destinationDirectory, NullPointerException.class, "sourceDir");
    }

    @Test
    public void copyDirectoryToDirectoryThrowsNullPointerExceptionWithCorrectMessageWhenDstDirIsNull() {
        File srcDir = new File(this.temporaryFolder, "sourceDirectory");
        srcDir.mkdir();
        File destDir = null;
        FileUtilsCopyDirectoryToDirectoryTestCase.assertExceptionTypeAndMessage(srcDir, destDir, NullPointerException.class, "destinationDir");
    }

    private static void assertExceptionTypeAndMessage(File srcDir, File destDir, Class<? extends Exception> expectedExceptionType, String expectedMessage) {
        try {
            FileUtils.copyDirectoryToDirectory((File)srcDir, (File)destDir);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            Assertions.assertEquals(expectedExceptionType, e.getClass());
            Assertions.assertEquals((Object)expectedMessage, (Object)msg);
            return;
        }
        Assertions.fail();
    }
}

