/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.io.input.DemuxInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.DemuxOutputStream;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DemuxTestCase {
    private static final String T1 = "Thread1";
    private static final String T2 = "Thread2";
    private static final String T3 = "Thread3";
    private static final String T4 = "Thread4";
    private static final String DATA1 = "Data for thread1";
    private static final String DATA2 = "Data for thread2";
    private static final String DATA3 = "Data for thread3";
    private static final String DATA4 = "Data for thread4";
    private static final Random c_random = new Random();
    private final HashMap<String, ByteArrayOutputStream> m_outputMap = new HashMap();
    private final HashMap<String, Thread> m_threadMap = new HashMap();

    private String getOutput(String threadName) {
        ByteArrayOutputStream output = this.m_outputMap.get(threadName);
        Assertions.assertNotNull((Object)output, (String)"getOutput()");
        return output.toString(StandardCharsets.UTF_8);
    }

    private String getInput(String threadName) {
        ReaderThread thread = (ReaderThread)this.m_threadMap.get(threadName);
        Assertions.assertNotNull((Object)thread, (String)"getInput()");
        return thread.getData();
    }

    private void doStart() throws Exception {
        for (String name : this.m_threadMap.keySet()) {
            Thread thread = this.m_threadMap.get(name);
            thread.start();
        }
    }

    private void doJoin() throws Exception {
        for (String name : this.m_threadMap.keySet()) {
            Thread thread = this.m_threadMap.get(name);
            thread.join();
        }
    }

    private void startWriter(String name, String data, DemuxOutputStream demux) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.m_outputMap.put(name, output);
        WriterThread thread = new WriterThread(name, data, (OutputStream)output, demux);
        this.m_threadMap.put(name, thread);
    }

    private void startReader(String name, String data, DemuxInputStream demux) throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(data.getBytes());
        ReaderThread thread = new ReaderThread(name, input, demux);
        this.m_threadMap.put(name, thread);
    }

    @Test
    public void testOutputStream() throws Exception {
        DemuxOutputStream output = new DemuxOutputStream();
        this.startWriter(T1, DATA1, output);
        this.startWriter(T2, DATA2, output);
        this.startWriter(T3, DATA3, output);
        this.startWriter(T4, DATA4, output);
        this.doStart();
        this.doJoin();
        Assertions.assertEquals((Object)DATA1, (Object)this.getOutput(T1), (String)"Data1");
        Assertions.assertEquals((Object)DATA2, (Object)this.getOutput(T2), (String)"Data2");
        Assertions.assertEquals((Object)DATA3, (Object)this.getOutput(T3), (String)"Data3");
        Assertions.assertEquals((Object)DATA4, (Object)this.getOutput(T4), (String)"Data4");
    }

    @Test
    public void testInputStream() throws Exception {
        DemuxInputStream input = new DemuxInputStream();
        this.startReader(T1, DATA1, input);
        this.startReader(T2, DATA2, input);
        this.startReader(T3, DATA3, input);
        this.startReader(T4, DATA4, input);
        this.doStart();
        this.doJoin();
        Assertions.assertEquals((Object)DATA1, (Object)this.getInput(T1), (String)"Data1");
        Assertions.assertEquals((Object)DATA2, (Object)this.getInput(T2), (String)"Data2");
        Assertions.assertEquals((Object)DATA3, (Object)this.getInput(T3), (String)"Data3");
        Assertions.assertEquals((Object)DATA4, (Object)this.getInput(T4), (String)"Data4");
    }

    private static class WriterThread
    extends Thread {
        private final byte[] m_data;
        private final OutputStream m_output;
        private final DemuxOutputStream m_demux;

        WriterThread(String name, String data, OutputStream output, DemuxOutputStream demux) {
            super(name);
            this.m_output = output;
            this.m_demux = demux;
            this.m_data = data.getBytes();
        }

        @Override
        public void run() {
            this.m_demux.bindStream(this.m_output);
            for (byte element : this.m_data) {
                try {
                    this.m_demux.write((int)element);
                    int sleepTime = Math.abs(c_random.nextInt() % 10);
                    TestUtils.sleep(sleepTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static class ReaderThread
    extends Thread {
        private final StringBuffer m_buffer = new StringBuffer();
        private final InputStream m_input;
        private final DemuxInputStream m_demux;

        ReaderThread(String name, InputStream input, DemuxInputStream demux) {
            super(name);
            this.m_input = input;
            this.m_demux = demux;
        }

        public String getData() {
            return this.m_buffer.toString();
        }

        @Override
        public void run() {
            this.m_demux.bindStream(this.m_input);
            try {
                int ch = this.m_demux.read();
                while (-1 != ch) {
                    this.m_buffer.append((char)ch);
                    int sleepTime = Math.abs(c_random.nextInt() % 10);
                    TestUtils.sleep(sleepTime);
                    ch = this.m_demux.read();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

