/*
 * Decompiled with CFR 0.152.
 */
package it.firegloves.mempoi.styles.template;

import it.firegloves.mempoi.styles.MempoiStyler;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public interface StyleTemplate {
    public static final String STANDARD_DATE_FORMAT = "yyyy/mm/dd";
    public static final String STANDARD_DATETIME_FORMAT = "yyyy/mm/dd h:mm";
    public static final String STANDARD_NUMBER_FORMAT = "#,##0.00";

    public CellStyle getHeaderCellStyle(Workbook var1);

    public CellStyle getSubfooterCellStyle(Workbook var1);

    default public CellStyle getDateCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setDataFormat(workbook.getCreationHelper().createDataFormat().getFormat(STANDARD_DATE_FORMAT));
        return cellStyle;
    }

    default public CellStyle getDatetimeCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setDataFormat(workbook.getCreationHelper().createDataFormat().getFormat(STANDARD_DATETIME_FORMAT));
        return cellStyle;
    }

    default public CellStyle getNumberCellStyle(Workbook workbook) {
        return null;
    }

    default public CellStyle getCommonDataCellStyle(Workbook workbook) {
        return null;
    }

    default public MempoiStyler toMempoiStyler(Workbook workbook) {
        return new MempoiStyler(this.getHeaderCellStyle(workbook), this.getCommonDataCellStyle(workbook), this.getDateCellStyle(workbook), this.getDatetimeCellStyle(workbook), this.getNumberCellStyle(workbook), this.getSubfooterCellStyle(workbook));
    }

    default public void addBgCellColor(CellStyle cellStyle, short commonCellBgColorIndex) {
        cellStyle.setFillForegroundColor(commonCellBgColorIndex);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
    }

    default public void addFontStyle(Workbook workbook, CellStyle cellStyle, short fontColor, boolean bold) {
        Font font = workbook.createFont();
        font.setColor(fontColor);
        font.setBold(bold);
        cellStyle.setFont(font);
    }

    default public void addCellBorders(CellStyle cellStyle, short borderColor) {
        BorderStyle style = BorderStyle.THIN;
        cellStyle.setBorderBottom(style);
        cellStyle.setBottomBorderColor(borderColor);
        cellStyle.setBorderLeft(style);
        cellStyle.setLeftBorderColor(borderColor);
        cellStyle.setBorderRight(style);
        cellStyle.setRightBorderColor(borderColor);
        cellStyle.setBorderTop(style);
        cellStyle.setTopBorderColor(borderColor);
    }
}

