/*
 * Decompiled with CFR 0.152.
 */
package it.firegloves.mempoi.styles.template;

import it.firegloves.mempoi.styles.template.StyleTemplate;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public abstract class HueStyleTemplate
implements StyleTemplate {
    private short headerCellBgColorIndex = IndexedColors.CORAL.getIndex();
    private short headerFontColorIndex = IndexedColors.WHITE.getIndex();
    private short headerFontSizeInPoint = (short)16;
    private short commonCellBgColorIndex = IndexedColors.WHITE.getIndex();
    private short commonFontColorIndex = IndexedColors.BLACK.getIndex();
    private short borderColorIndex = IndexedColors.BLACK.getIndex();
    private short subFooterCellBgColorIndex = IndexedColors.CORAL.getIndex();
    private short subFooterFontColorIndex = IndexedColors.WHITE.getIndex();

    public short getHeaderCellBgColorIndex() {
        return this.headerCellBgColorIndex;
    }

    public void setHeaderCellBgColorIndex(short headerCellBgColorIndex) {
        this.headerCellBgColorIndex = headerCellBgColorIndex;
    }

    public short getCommonCellBgColorIndex() {
        return this.commonCellBgColorIndex;
    }

    public void setCommonCellBgColorIndex(short commonCellBgColorIndex) {
        this.commonCellBgColorIndex = commonCellBgColorIndex;
    }

    public short getHeaderFontColorIndex() {
        return this.headerFontColorIndex;
    }

    public void setHeaderFontColorIndex(short headerFontColorIndex) {
        this.headerFontColorIndex = headerFontColorIndex;
    }

    public short getCommonFontColorIndex() {
        return this.commonFontColorIndex;
    }

    public void setCommonFontColorIndex(short commonFontColorIndex) {
        this.commonFontColorIndex = commonFontColorIndex;
    }

    public short getSubFooterCellBgColorIndex() {
        return this.subFooterCellBgColorIndex;
    }

    public void setSubFooterCellBgColorIndex(short subFooterCellBgColorIndex) {
        this.subFooterCellBgColorIndex = subFooterCellBgColorIndex;
    }

    public short getSubFooterFontColorIndex() {
        return this.subFooterFontColorIndex;
    }

    public void setSubFooterFontColorIndex(short subFooterFontColorIndex) {
        this.subFooterFontColorIndex = subFooterFontColorIndex;
    }

    public short getBorderColorIndex() {
        return this.borderColorIndex;
    }

    public void setBorderColorIndex(short borderColorIndex) {
        this.borderColorIndex = borderColorIndex;
    }

    @Override
    public CellStyle getHeaderCellStyle(Workbook workbook) {
        CellStyle cellStyle = this.setGenericCellStyle(workbook, this.headerCellBgColorIndex, this.headerFontColorIndex, true, this.borderColorIndex);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        if (cellStyle instanceof XSSFCellStyle) {
            ((XSSFCellStyle)cellStyle).getFont().setFontHeightInPoints(this.headerFontSizeInPoint);
        } else {
            ((HSSFCellStyle)cellStyle).getFont(workbook).setFontHeight((short)(this.headerFontSizeInPoint * 20));
        }
        cellStyle.setWrapText(true);
        return cellStyle;
    }

    @Override
    public CellStyle getSubfooterCellStyle(Workbook workbook) {
        CellStyle cellStyle = this.setGenericCellStyle(workbook, this.subFooterCellBgColorIndex, this.subFooterFontColorIndex, true, this.borderColorIndex);
        return cellStyle;
    }

    @Override
    public CellStyle getDateCellStyle(Workbook workbook) {
        CellStyle cellStyle = this.setGenericCellStyle(workbook, this.commonCellBgColorIndex, this.commonFontColorIndex, false, this.borderColorIndex);
        cellStyle.setDataFormat(workbook.getCreationHelper().createDataFormat().getFormat("yyyy/mm/dd"));
        return cellStyle;
    }

    @Override
    public CellStyle getDatetimeCellStyle(Workbook workbook) {
        CellStyle cellStyle = this.setGenericCellStyle(workbook, this.commonCellBgColorIndex, this.commonFontColorIndex, false, this.borderColorIndex);
        cellStyle.setDataFormat(workbook.getCreationHelper().createDataFormat().getFormat("yyyy/mm/dd h:mm"));
        return cellStyle;
    }

    @Override
    public CellStyle getNumberCellStyle(Workbook workbook) {
        CellStyle cellStyle = this.setGenericCellStyle(workbook, this.commonCellBgColorIndex, this.commonFontColorIndex, false, this.borderColorIndex);
        cellStyle.setDataFormat(workbook.getCreationHelper().createDataFormat().getFormat("#,##0.00"));
        return cellStyle;
    }

    @Override
    public CellStyle getCommonDataCellStyle(Workbook workbook) {
        CellStyle cellStyle = this.setGenericCellStyle(workbook, this.commonCellBgColorIndex, this.commonFontColorIndex, false, this.borderColorIndex);
        return cellStyle;
    }

    private CellStyle setGenericCellStyle(Workbook workbook, short cellBgColorIndex, short fontColorIndex, boolean bold, short borderColor) {
        CellStyle cellStyle = workbook.createCellStyle();
        this.addBgCellColor(cellStyle, cellBgColorIndex);
        this.addFontStyle(workbook, cellStyle, fontColorIndex, bold);
        this.addCellBorders(cellStyle, borderColor);
        return cellStyle;
    }
}

