/*
 * Decompiled with CFR 0.152.
 */
package it.firegloves.mempoi.styles;

import it.firegloves.mempoi.domain.EExportDataType;
import it.firegloves.mempoi.domain.MempoiColumn;
import it.firegloves.mempoi.styles.MempoiStyler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;

public class MempoiColumnStyleManager {
    private HashMap<EnumSet<EExportDataType>, CellStyle> cellStylerMap;
    private MempoiStyler reportStyler;

    public MempoiColumnStyleManager(MempoiStyler reportStyler) {
        this.reportStyler = reportStyler;
        this.initCellStyleMap();
    }

    private void initCellStyleMap() {
        this.cellStylerMap = new HashMap();
        this.cellStylerMap.put(EExportDataType.DATE_STYLER_TYPES, this.reportStyler.getDateCellStyle());
        this.cellStylerMap.put(EExportDataType.DATETIME_STYLER_TYPES, this.reportStyler.getDatetimeCellStyle());
        this.cellStylerMap.put(EExportDataType.NUMBER_STYLER_TYPES, this.reportStyler.getNumberCellStyle());
    }

    private EnumSet<EExportDataType> getEExportDataTypeEnumSet(EExportDataType type) {
        if (EExportDataType.DATE_STYLER_TYPES.contains((Object)type)) {
            return EExportDataType.DATE_STYLER_TYPES;
        }
        if (EExportDataType.DATETIME_STYLER_TYPES.contains((Object)type)) {
            return EExportDataType.DATETIME_STYLER_TYPES;
        }
        if (EExportDataType.NUMBER_STYLER_TYPES.contains((Object)type)) {
            return EExportDataType.NUMBER_STYLER_TYPES;
        }
        return null;
    }

    public void setMempoiColumnListStyler(List<MempoiColumn> mempoiColumnList) {
        mempoiColumnList.stream().forEach(mc -> {
            if (mc.getColumnName().equalsIgnoreCase("id")) {
                mc.setCellStyle(this.reportStyler.getCommonDataCellStyle());
            } else {
                mc.setCellStyle(this.cellStylerMap.getOrDefault(this.getEExportDataTypeEnumSet(mc.getType()), this.reportStyler.getCommonDataCellStyle()));
            }
        });
    }
}

