/*
 * Decompiled with CFR 0.152.
 */
package it.firegloves.mempoi.domain.footer;

import it.firegloves.mempoi.domain.EExportDataType;
import it.firegloves.mempoi.domain.MempoiColumn;
import it.firegloves.mempoi.domain.footer.MempoiSubFooter;
import it.firegloves.mempoi.domain.footer.MempoiSubFooterCell;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;

public abstract class FormulaSubFooter
implements MempoiSubFooter {
    protected String formula;

    @Override
    public void setColumnSubFooter(Workbook workbook, List<MempoiColumn> mempoiColumnList, CellStyle subFooterCellStyle, int firstDataRowIndex, int lastDataRowIndex) {
        this.customizeSubFooterCellStyle(workbook, subFooterCellStyle);
        int len = mempoiColumnList.size();
        for (int i = 0; i < len; ++i) {
            MempoiColumn mc = mempoiColumnList.get(i);
            if (!mc.getColumnName().equalsIgnoreCase("id") && EExportDataType.NUMBER_STYLER_TYPES.contains((Object)mc.getType())) {
                String colLetter = CellReference.convertNumToColString((int)i);
                mempoiColumnList.get(i).setSubFooterCell(new MempoiSubFooterCell(this.getFormula(colLetter, firstDataRowIndex, lastDataRowIndex), true, subFooterCellStyle));
                continue;
            }
            mempoiColumnList.get(i).setSubFooterCell(new MempoiSubFooterCell(subFooterCellStyle));
        }
    }

    protected abstract void customizeSubFooterCellStyle(Workbook var1, CellStyle var2);

    protected abstract String getFormula(String var1, int var2, int var3);
}

