/*
 * Decompiled with CFR 0.152.
 */
package it.firegloves.mempoi.domain;

import it.firegloves.mempoi.domain.EExportDataType;
import it.firegloves.mempoi.domain.footer.MempoiSubFooterCell;
import it.firegloves.mempoi.exception.MempoiException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

public class MempoiColumn {
    private EExportDataType type;
    private CellStyle cellStyle;
    private String columnName;
    private Method rsAccessDataMethod;
    private Method cellSetValueMethod;
    private MempoiSubFooterCell subFooterCell;

    public MempoiColumn(int sqlObjType, String columnName) {
        this.columnName = columnName;
        this.setType(sqlObjType);
    }

    public EExportDataType getType() {
        return this.type;
    }

    public void setType(EExportDataType type) {
        this.type = type;
    }

    public void setType(int sqlObjType) {
        this.type = this.getFieldTypeName(sqlObjType);
        this.setResultSetAccessMethod();
        this.setCellSetValueMethod();
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public MempoiSubFooterCell getSubFooterCell() {
        return this.subFooterCell;
    }

    public void setSubFooterCell(MempoiSubFooterCell subFooterCell) {
        this.subFooterCell = subFooterCell;
    }

    private void setResultSetAccessMethod() {
        try {
            this.rsAccessDataMethod = ResultSet.class.getMethod(this.type.getRsAccessDataMethodName(), this.type.getRsAccessParamClass());
        }
        catch (NoSuchMethodException e) {
            throw new MempoiException(e);
        }
    }

    private void setCellSetValueMethod() {
        try {
            this.cellSetValueMethod = Cell.class.getMethod("setCellValue", this.type.getRsReturnClass());
        }
        catch (NoSuchMethodException e) {
            throw new MempoiException(e);
        }
    }

    private EExportDataType getFieldTypeName(int sqlObjType) {
        switch (sqlObjType) {
            case -5: 
            case 8: {
                return EExportDataType.DOUBLE;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return EExportDataType.FLOAT;
            }
            case -6: 
            case 4: 
            case 5: {
                return EExportDataType.INT;
            }
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return EExportDataType.TEXT;
            }
            case 93: {
                return EExportDataType.TIMESTAMP;
            }
            case 91: {
                return EExportDataType.DATE;
            }
            case 92: {
                return EExportDataType.TIME;
            }
            case -7: 
            case 16: {
                return EExportDataType.BOOLEAN;
            }
        }
        throw new MempoiException("SQL TYPE NOT RECOGNIZED: " + sqlObjType);
    }

    public Method getRsAccessDataMethod() {
        return this.rsAccessDataMethod;
    }

    public Method getCellSetValueMethod() {
        return this.cellSetValueMethod;
    }

    public void setCellSetValueMethod(Method cellSetValueMethod) {
        this.cellSetValueMethod = cellSetValueMethod;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MempoiColumn other = (MempoiColumn)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.cellStyle, other.cellStyle) && Objects.equals(this.columnName, other.columnName) && Objects.equals(this.rsAccessDataMethod, other.rsAccessDataMethod) && Objects.equals(this.cellSetValueMethod, other.cellSetValueMethod) && Objects.equals(this.subFooterCell, other.subFooterCell);
    }
}

