/*
 * Decompiled with CFR 0.152.
 */
package it.firegloves.mempoi.dao.impl;

import it.firegloves.mempoi.dao.MempoiDAO;
import it.firegloves.mempoi.domain.MempoiColumn;
import it.firegloves.mempoi.exception.MempoiException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMempoiDAO
implements MempoiDAO {
    private static final Logger logger = LoggerFactory.getLogger(DBMempoiDAO.class);
    private static DBMempoiDAO instance = new DBMempoiDAO();

    private DBMempoiDAO() {
    }

    public static DBMempoiDAO getInstance() {
        return instance;
    }

    @Override
    public ResultSet executeExportQuery(PreparedStatement prepStmt) {
        try {
            logger.debug("EXECUTING EXPORT QUERY: " + prepStmt.toString());
            return prepStmt.executeQuery();
        }
        catch (SQLException e) {
            throw new MempoiException(e);
        }
    }

    @Override
    public List<MempoiColumn> readMetadata(ResultSet rs) {
        if (null == rs) {
            throw new MempoiException("NULL ResultSet!");
        }
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            ArrayList<MempoiColumn> columnList = new ArrayList<MempoiColumn>();
            int columnsNumber = rsmd.getColumnCount();
            for (int i = 1; i <= columnsNumber; ++i) {
                columnList.add(new MempoiColumn(rsmd.getColumnType(i), rsmd.getColumnLabel(i)));
            }
            return columnList;
        }
        catch (SQLException e) {
            throw new MempoiException(e);
        }
    }
}

