/*
 * Decompiled with CFR 0.152.
 */
package it.firegloves.mempoi;

import it.firegloves.mempoi.config.WorkbookConfig;
import it.firegloves.mempoi.dao.impl.DBMempoiDAO;
import it.firegloves.mempoi.domain.MempoiColumn;
import it.firegloves.mempoi.domain.MempoiSheet;
import it.firegloves.mempoi.domain.footer.MempoiFooter;
import it.firegloves.mempoi.domain.footer.MempoiSubFooter;
import it.firegloves.mempoi.domain.footer.MempoiSubFooterCell;
import it.firegloves.mempoi.exception.MempoiException;
import it.firegloves.mempoi.manager.ConnectionManager;
import it.firegloves.mempoi.styles.MempoiColumnStyleManager;
import it.firegloves.mempoi.styles.MempoiStyler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Strategos {
    private static final Logger logger = LoggerFactory.getLogger(Strategos.class);
    private WorkbookConfig workbookConfig;

    public Strategos(WorkbookConfig workbookConfig) {
        this.workbookConfig = workbookConfig;
    }

    public String generateMempoiReportToFile(List<MempoiSheet> mempoiSheetList, File fileToExport) throws MempoiException {
        this.generateMempoiReport(mempoiSheetList);
        return this.writeFile(fileToExport);
    }

    public byte[] generateMempoiReportToByteArray() throws MempoiException {
        this.generateMempoiReport(this.workbookConfig.getSheetList());
        return this.writeToByteArray();
    }

    private void generateMempoiReport(List<MempoiSheet> mempoiSheetList) {
        this.generateReport(mempoiSheetList);
        this.manageFormulaToEvaluate(this.workbookConfig.isEvaluateCellFormulas(), this.workbookConfig.isHasFormulasToEvaluate());
    }

    private void manageFormulaToEvaluate(boolean evaluateCellFormulas, boolean hasFormulasToEvaluate) {
        if (evaluateCellFormulas && hasFormulasToEvaluate) {
            logger.debug("we have formulas to evaluate");
            File tmpFile = this.writeTempFile();
            this.openTempFileAndEvaluateCellFormulas(tmpFile);
        }
    }

    private void generateReport(List<MempoiSheet> mempoiSheetList) {
        mempoiSheetList.stream().forEach(mempoiSheet -> this.generateSheet((MempoiSheet)mempoiSheet));
    }

    private void generateSheet(MempoiSheet mempoiSheet) {
        Sheet sheet;
        int rowCounter = 0;
        Sheet sheet2 = sheet = null != mempoiSheet.getSheetName() && !mempoiSheet.getSheetName().isEmpty() ? this.workbookConfig.getWorkbook().createSheet(mempoiSheet.getSheetName()) : this.workbookConfig.getWorkbook().createSheet();
        if (this.workbookConfig.isAdjustColSize() && sheet instanceof SXSSFSheet) {
            ((SXSSFSheet)sheet).trackAllColumnsForAutoSizing();
        }
        ResultSet rs = DBMempoiDAO.getInstance().executeExportQuery(mempoiSheet.getPrepStmt());
        List<MempoiColumn> columnList = DBMempoiDAO.getInstance().readMetadata(rs);
        MempoiStyler sheetReportStyler = mempoiSheet.getSheetStyler();
        new MempoiColumnStyleManager(sheetReportStyler).setMempoiColumnListStyler(columnList);
        rowCounter = this.createHeaderRow(sheet, columnList, rowCounter, sheetReportStyler);
        int firstDataRowIndex = rowCounter + 1;
        try {
            rowCounter = this.createDataRows(sheet, rs, columnList, rowCounter);
            this.createSubFooterRow(sheet, columnList, mempoiSheet.getMempoiSubFooter().orElseGet(() -> this.workbookConfig.getMempoiSubFooter()), firstDataRowIndex, rowCounter, sheetReportStyler);
            this.createFooterRow(sheet, mempoiSheet.getMempoiFooter().orElseGet(() -> this.workbookConfig.getMempoiFooter()));
            this.adjustColSize(sheet, columnList.size());
        }
        catch (Exception e) {
            throw new MempoiException(e);
        }
        finally {
            ConnectionManager.closeResultSetAndPrepStmt(rs, mempoiSheet.getPrepStmt());
        }
    }

    private int createHeaderRow(Sheet sheet, List<MempoiColumn> columnList, int rowCounter, MempoiStyler sheetReportStyler) {
        Row row = sheet.createRow(rowCounter++);
        int colListLen = columnList.size();
        for (int i = 0; i < colListLen; ++i) {
            MempoiColumn cm = columnList.get(i);
            Cell cell = row.createCell(i);
            if (sheet instanceof XSSFSheet) {
                ((XSSFSheet)sheet).getColumnHelper().setColDefaultStyle((long)i, cm.getCellStyle());
            }
            cell.setCellStyle(sheetReportStyler.getHeaderCellStyle());
            cell.setCellValue(cm.getColumnName());
            logger.debug("SETTING HEADER FOR COLUMN " + columnList.get(i).getColumnName());
        }
        if (sheetReportStyler.getHeaderCellStyle() instanceof XSSFCellStyle) {
            row.setHeightInPoints((float)(((XSSFCellStyle)sheetReportStyler.getHeaderCellStyle()).getFont().getFontHeightInPoints() + 5));
        } else {
            row.setHeightInPoints((float)(((HSSFCellStyle)sheetReportStyler.getHeaderCellStyle()).getFont(this.workbookConfig.getWorkbook()).getFontHeightInPoints() + 5));
        }
        return rowCounter;
    }

    private int createDataRows(Sheet sheet, ResultSet rs, List<MempoiColumn> columnList, int rowCounter) {
        int colListLen = columnList.size();
        try {
            while (rs.next()) {
                logger.debug("creating row");
                Row row = sheet.createRow(rowCounter++);
                for (int i = 0; i < colListLen; ++i) {
                    MempoiColumn col = columnList.get(i);
                    Cell cell = row.createCell(i);
                    if (!(sheet instanceof XSSFSheet)) {
                        cell.setCellStyle(col.getCellStyle());
                    }
                    logger.debug("SETTING CELL FOR COLUMN " + col.getColumnName());
                    col.getCellSetValueMethod().invoke((Object)cell, col.getRsAccessDataMethod().invoke((Object)rs, col.getColumnName()));
                }
            }
        }
        catch (Exception e) {
            throw new MempoiException(e);
        }
        return rowCounter;
    }

    private File writeTempFile() {
        File tmpFile = new File(System.getProperty("java.io.tmpdir") + "mempoi_temp_" + System.currentTimeMillis() + ".xlsx");
        try (FileOutputStream outputStream = new FileOutputStream(tmpFile);){
            this.workbookConfig.getWorkbook().write((OutputStream)outputStream);
            logger.debug("MemPOI temp file created: " + tmpFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new MempoiException(e);
        }
        finally {
            this.closeWorkbook();
        }
        return tmpFile;
    }

    private void openTempFileAndEvaluateCellFormulas(File tmpFile) {
        try {
            logger.debug("reading temp file");
            this.workbookConfig.setWorkbook(WorkbookFactory.create((File)tmpFile));
            logger.debug("readed temp file");
            this.workbookConfig.getWorkbook().getCreationHelper().createFormulaEvaluator().evaluateAll();
            logger.debug("evaluated formulas");
        }
        catch (Exception e) {
            throw new MempoiException(e);
        }
    }

    private String writeFile(File file) {
        try {
            if (!file.getAbsoluteFile().getParentFile().exists()) {
                file.getAbsoluteFile().getParentFile().mkdirs();
                logger.debug("CREATED FILE TO EXPORT PARENT DIR: " + file.getParentFile().getAbsolutePath());
            }
            try (Object outputStream = new FileOutputStream(file);){
                logger.debug("writing final file");
                this.workbookConfig.getWorkbook().write((OutputStream)outputStream);
                logger.debug("written final file");
            }
            outputStream = file.getAbsolutePath();
            return outputStream;
        }
        catch (Exception e) {
            throw new MempoiException(e);
        }
        finally {
            this.closeWorkbook();
        }
    }

    private void createSubFooterRow(Sheet sheet, List<MempoiColumn> columnList, MempoiSubFooter mempoiSubFooter, int firstDataRowIndex, int rowCounter, MempoiStyler reportStyler) {
        if (null != mempoiSubFooter) {
            int colListLen = columnList.size();
            mempoiSubFooter.setColumnSubFooter(this.workbookConfig.getWorkbook(), columnList, reportStyler.getSubFooterCellStyle(), firstDataRowIndex, rowCounter);
            Row row = sheet.createRow(rowCounter++);
            for (int i = 0; i < colListLen; ++i) {
                MempoiSubFooterCell subFooterCell = columnList.get(i).getSubFooterCell();
                Cell cell = row.createCell(i);
                cell.setCellStyle(subFooterCell.getStyle());
                logger.debug("SETTING SUB FOOTER CELL FOR COLUMN " + columnList.get(i).getColumnName());
                if (subFooterCell.isCellFormula()) {
                    cell.setCellFormula(subFooterCell.getValue());
                    continue;
                }
                cell.setCellValue(subFooterCell.getValue());
            }
            if (!this.workbookConfig.isEvaluateCellFormulas()) {
                sheet.setForceFormulaRecalculation(true);
            }
        }
    }

    private void createFooterRow(Sheet sheet, MempoiFooter mempoiFooter) {
        if (null != mempoiFooter) {
            Footer footer = sheet.getFooter();
            footer.setLeft(mempoiFooter.getLeftText());
            footer.setCenter(mempoiFooter.getCenterText());
            footer.setRight(mempoiFooter.getRightText());
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] writeToByteArray() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void adjustColSize(Sheet sheet, int colListLen) {
        if (this.workbookConfig.isAdjustColSize()) {
            for (int i = 0; i < colListLen; ++i) {
                logger.debug("autosizing col num " + i);
                sheet.autoSizeColumn(i);
            }
        }
    }

    private void closeWorkbook() {
        if (this.workbookConfig.getWorkbook() instanceof SXSSFWorkbook) {
            ((SXSSFWorkbook)this.workbookConfig.getWorkbook()).dispose();
        }
        try {
            this.workbookConfig.getWorkbook().close();
        }
        catch (Exception e) {
            throw new MempoiException(e);
        }
    }
}

