/*
 * Decompiled with CFR 0.152.
 */
package it.firegloves.mempoi;

import it.firegloves.mempoi.Strategos;
import it.firegloves.mempoi.config.WorkbookConfig;
import it.firegloves.mempoi.exception.MempoiException;
import java.util.concurrent.CompletableFuture;

public class MemPOI {
    private WorkbookConfig workbookConfig;

    public MemPOI() {
    }

    public MemPOI(WorkbookConfig workbookConfig) {
        this.workbookConfig = workbookConfig;
    }

    public WorkbookConfig getWorkbookConfig() {
        return this.workbookConfig;
    }

    public void setWorkbookConfig(WorkbookConfig workbookConfig) {
        this.workbookConfig = workbookConfig;
    }

    public CompletableFuture<String> prepareMempoiReportToFile() throws MempoiException {
        return CompletableFuture.supplyAsync(() -> {
            if (null == this.workbookConfig.getFile()) {
                throw new MempoiException("Error: report to file requested but no file was specified in the config");
            }
            Strategos strategos = new Strategos(this.workbookConfig);
            return strategos.generateMempoiReportToFile(this.workbookConfig.getSheetList(), this.workbookConfig.getFile());
        });
    }

    public CompletableFuture<byte[]> prepareMempoiReportToByteArray() throws MempoiException {
        return CompletableFuture.supplyAsync(() -> {
            Strategos strategos = new Strategos(this.workbookConfig);
            return strategos.generateMempoiReportToByteArray();
        });
    }
}

