/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.sx;
import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IWarningCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SwfSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;

public abstract class SaveOptions {
    private boolean aUf = true;
    private boolean aUg;
    private String aUh;
    private IWarningCallback Sq;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean Nk() {
        return false;
    }

    boolean OP() {
        return true;
    }

    boolean ajW() {
        return this.aUf;
    }

    public String getTempFolder() {
        return this.aUh;
    }

    public void setTempFolder(String value) {
        this.aUh = value;
    }

    public boolean getPrettyFormat() {
        return this.aUg;
    }

    public void setPrettyFormat(boolean value) {
        this.aUg = value;
    }

    public IWarningCallback getWarningCallback() {
        return this.Sq;
    }

    public void setWarningCallback(IWarningCallback value) {
        this.Sq = value;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions();
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 43: {
                return new SwfSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 104: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.extensionToSaveFormat(sx.bz(fileName)));
    }
}

