/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.PageInfo;
import com.aspose.words.PrinterSettings;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.FileOutputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;

public class PrintUtilities {
    public static void print(PrinterSettings printerSettings, String documentName, Pageable pageableDoc) {
        PrintUtilities.a(printerSettings, documentName, true, pageableDoc);
    }

    public static void print(PrinterSettings printerSettings, String documentName, Printable printableDoc) {
        PrintUtilities.a(printerSettings, documentName, false, printableDoc);
    }

    public static void printToFile(PrinterSettings printerSettings, Printable printableDoc) {
        PrintUtilities.a(printerSettings, false, printableDoc);
    }

    public static void printToFile(PrinterSettings printerSettings, Pageable pageableDoc) {
        PrintUtilities.a(printerSettings, true, pageableDoc);
    }

    public static Book createBook(Document document, Printable printableDoc) {
        try {
            int n2 = document.getPageCount();
            PageFormat pageFormat = new PageFormat();
            pageFormat.setOrientation(0);
            Book book = new Book();
            book.append(printableDoc, new PageFormat(), n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                PageInfo pageInfo = document.getPageInfo(i2);
                if (!pageInfo.getLandscape()) continue;
                book.setPage(i2, printableDoc, pageFormat);
            }
            return book;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static void a(PrinterSettings printerSettings, String string, boolean bl2, Object object) {
        PrintUtilities.a(printerSettings);
        PrintService printService = PrintUtilities.b(printerSettings);
        if (printService == null) {
            throw new IllegalStateException("There are no available print Services.");
        }
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintService(printService);
            if (bl2) {
                printerJob.setPageable((Pageable)object);
            } else {
                printerJob.setPrintable((Printable)object);
            }
            if (string != null) {
                printerJob.setJobName(string);
            }
            printerJob.print(printerSettings.getAttributes());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(PrinterSettings printerSettings, boolean bl2, Object object) {
        StreamPrintServiceFactory[] streamPrintServiceFactoryArray;
        PrintUtilities.a(printerSettings);
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        if (!bl2) {
            sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        }
        if ((streamPrintServiceFactoryArray = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(sERVICE_FORMATTED, DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType())).length == 0) {
            throw new IllegalStateException("There are no available print Services to print into POSTSCRIPT format");
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(printerSettings.getOutputFile());
            StreamPrintService streamPrintService = streamPrintServiceFactoryArray[0].getPrintService(fileOutputStream);
            DocPrintJob docPrintJob = streamPrintService.createPrintJob();
            SimpleDoc simpleDoc = new SimpleDoc(object, sERVICE_FORMATTED, null);
            docPrintJob.print(simpleDoc, printerSettings.getAttributes());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static void a(PrinterSettings printerSettings) {
        Integer n2 = printerSettings.getFromPage();
        Integer n3 = printerSettings.getToPage();
        PageRanges pageRanges = null;
        if (n2 != null && n3 != null && n2.compareTo(n3) < 0) {
            pageRanges = new PageRanges(n2, n3);
        } else if (n2 != null && n3 != null && n2.compareTo(n3) == 0) {
            pageRanges = new PageRanges(n2);
        } else if (n2 != null && n3 != null && n2.compareTo(n3) > 0) {
            pageRanges = new PageRanges(n3, n2);
        } else if (n2 != null) {
            pageRanges = new PageRanges(n2);
        } else if (n3 != null) {
            pageRanges = new PageRanges(n3);
        }
        if (pageRanges != null) {
            printerSettings.getAttributes().add(pageRanges);
        }
    }

    private static PrintService b(PrinterSettings printerSettings) {
        PrintRequestAttributeSet printRequestAttributeSet = printerSettings.getAttributes();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, printRequestAttributeSet);
        if (printServiceArray.length == 0) {
            return null;
        }
        PrintService printService = PrintUtilities.a(printServiceArray, printerSettings.getPrinterName());
        return printService;
    }

    private static PrintService a(PrintService[] printServiceArray, String string) {
        if (printServiceArray == null || printServiceArray.length == 0) {
            return null;
        }
        if (string == null) {
            return printServiceArray[0];
        }
        for (int i2 = 0; i2 < printServiceArray.length; ++i2) {
            if (!printServiceArray[i2].getName().trim().equalsIgnoreCase(string.trim())) continue;
            return printServiceArray[i2];
        }
        return null;
    }
}

