/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.un;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Range;
import com.aspose.words.aax;
import com.aspose.words.ff;
import java.util.Stack;

public abstract class Node
implements Cloneable {
    private Node aAR;
    private Node aAS;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.l(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.aAR == null) {
            return null;
        }
        if (this.aAR.getNodeType() == 31) {
            return null;
        }
        return (CompositeNode)this.aAR;
    }

    CompositeNode WM() {
        return aax.U(this.getParentNode()) ? this.getParentNode().WM() : this.getParentNode();
    }

    public DocumentBase getDocument() {
        DocumentBase documentBase = un.a(this, DocumentBase.class);
        if (documentBase != null) {
            return documentBase;
        }
        if (this.aAR == null) {
            return null;
        }
        return this.aAR.getDocument();
    }

    Document Gv() {
        Document document = un.a(this.getDocument(), Document.class);
        if (document == null) {
            throw new IllegalStateException("This operation requires the node to be inside the main document.");
        }
        return document;
    }

    public Node getPreviousSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null) {
            Node node;
            for (node = compositeNode.getFirstChild(); node != null && node.getNextSibling() != this; node = node.getNextSibling()) {
            }
            return node;
        }
        return null;
    }

    Node WN() {
        CompositeNode compositeNode = this.WM();
        if (compositeNode != null) {
            Node node;
            for (node = compositeNode.xX(); node != null && node.WO() != this; node = node.WO()) {
            }
            return node;
        }
        return null;
    }

    Node WO() {
        CompositeNode compositeNode = this.WM();
        if (compositeNode != null && this != compositeNode.xY()) {
            return this.WP();
        }
        return null;
    }

    Node WP() {
        if (this.getParentNode() == null) {
            return null;
        }
        if (this.WQ() && aax.U(this.getParentNode())) {
            return this.getParentNode().WP();
        }
        if (aax.U(this.aAS)) {
            CompositeNode compositeNode = (CompositeNode)this.aAS;
            return compositeNode.hasChildNodes() ? compositeNode.xX() : compositeNode.WP();
        }
        return this.aAS;
    }

    public Node getNextSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getLastChild()) {
            return this.WR();
        }
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    boolean WQ() {
        return this.getParentNode() == null ? true : this == this.getParentNode().getLastChild();
    }

    boolean isFirstChild() {
        return this.getParentNode() == null ? true : this == this.getParentNode().getFirstChild();
    }

    Node WR() {
        return this.aAS;
    }

    void B(Node node) {
        this.aAS = node;
    }

    int WS() {
        if (this.getNodeType() == 1) {
            return 0;
        }
        if (this.getNodeType() == 2) {
            return 1;
        }
        if (this.getNodeType() == 3 || this.getNodeType() == 4) {
            return 2;
        }
        if (aax.Q(this)) {
            return 3;
        }
        if (aax.T(this)) {
            return 4;
        }
        return 5;
    }

    int getStart() {
        if (this.getParentNode() == null) {
            return 0;
        }
        int n2 = 0;
        for (Node node = this.getParentNode().getFirstChild(); node != this; node = node.getNextSibling()) {
            n2 += node.getTextLength();
        }
        return this.getParentNode().getStart() + n2;
    }

    boolean contains(int position) {
        int n2 = this.getStart();
        int n3 = n2 + this.getTextLength();
        return position >= n2 && position < n3;
    }

    Node en(int n2) {
        return this.contains(n2) ? this : null;
    }

    public Node deepClone(boolean isCloneChildren) {
        Node node = (Node)this.memberwiseClone();
        if (this.aAR != null) {
            node.aAR = this.getDocument().AY();
        }
        node.aAS = null;
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    public Node getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isAssignableFrom(compositeNode.getClass())) continue;
            return compositeNode;
        }
        return null;
    }

    public Node getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    void C(Node node) {
        this.aAR = node != null ? node : this.getDocument().AY();
    }

    void l(DocumentBase documentBase) {
        this.aAR = documentBase != null ? documentBase.AY() : null;
    }

    boolean D(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node;
        Node node2 = node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node = this.getPreviousSibling();
        while (node != null) {
            Node node2;
            Node node3 = node2 = node.isComposite() ? ((CompositeNode)node).getLastChild() : null;
            if (node2 == null) break;
            node = node2;
        }
        if (node == null) {
            node = this.getParentNode();
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    Node lO(int n2) {
        Node node;
        for (node = this.getNextSibling(); null != node && n2 != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    Node lP(int n2) {
        Node node;
        for (node = this.getPreviousSibling(); null != node && n2 != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    public String toTxt() throws Exception {
        return Document.b(this, 70);
    }

    Node lQ(int n2) {
        for (CompositeNode compositeNode = this.getParentNode(); null != compositeNode; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n2) {
                return compositeNode;
            }
            if (!aax.P(compositeNode)) continue;
            if (n2 != 0) break;
            return compositeNode;
        }
        return null;
    }

    ff WT() {
        Node node = this.getPreviousSibling();
        return node != null ? ff.m(node) : ff.l(this.getParentNode());
    }

    ff WU() {
        Node node = this.getNextSibling();
        return node != null ? ff.l(node) : ff.m(this.getParentNode());
    }

    boolean E(Node node) {
        return Node.d(this, node);
    }

    static boolean d(Node node, Node node2) {
        Stack stack;
        if (node == null || node2 == null) {
            return false;
        }
        Stack stack2 = Node.F(node);
        Node node3 = (Node)Node.a(stack2, stack = Node.F(node2));
        if (node3 == null) {
            return false;
        }
        if (stack2.size() == 0 || stack.size() == 0) {
            boolean bl2 = stack.size() > 0;
            return bl2;
        }
        Object e2 = stack2.peek();
        Object e3 = stack.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e2) {
                return true;
            }
            if (node4 != e3) continue;
            return false;
        }
        return false;
    }

    private static Stack F(Node node) {
        Stack<Node> stack = new Stack<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            stack.push(node2);
        }
        return stack;
    }

    private static Object a(Stack stack, Stack stack2) {
        Object var2_2 = null;
        while (stack.peek() == stack2.peek()) {
            var2_2 = stack.pop();
            stack2.pop();
            if (stack.size() != 0 && stack2.size() != 0) continue;
            break;
        }
        return var2_2;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 11: {
                return "GroupShape";
            }
            case 12: {
                return "Shape";
            }
            case 13: {
                return "Comment";
            }
            case 14: {
                return "Footnote";
            }
            case 15: {
                return "Run";
            }
            case 16: {
                return "FieldStart";
            }
            case 17: {
                return "FieldSeparator";
            }
            case 18: {
                return "FieldEnd";
            }
            case 19: {
                return "FormField";
            }
            case 20: {
                return "SpecialChar";
            }
            case 21: {
                return "SmartTag";
            }
            case 22: {
                return "CustomXmlMarkup";
            }
            case 23: {
                return "StructuredDocumentTag";
            }
            case 24: {
                return "GlossaryDocument";
            }
            case 25: {
                return "BuildingBlock";
            }
            case 26: {
                return "CommentRangeStart";
            }
            case 27: {
                return "CommentRangeEnd";
            }
            case 28: {
                return "DrawingML";
            }
            case 29: {
                return "OfficeMath";
            }
            case 30: {
                return "System";
            }
            case 31: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

