/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.az;
import asposewobfuscated.jb;
import com.aspose.words.ConvertUtil;

public class ImageSize {
    private int sp;
    private int apJ;
    private double nh;
    private double ni;

    public ImageSize(int widthPixels, int heightPixels) {
        this(widthPixels, heightPixels, 96.0, 96.0);
    }

    public ImageSize(int widthPixels, int heightPixels, double horizontalResolution, double verticalResolution) {
        this.sp = widthPixels;
        this.apJ = heightPixels;
        this.nh = horizontalResolution;
        this.ni = verticalResolution;
    }

    ImageSize(jb core) {
        this.sp = core.getWidth();
        this.apJ = core.getHeight();
        this.nh = core.getHorizontalResolution();
        this.ni = core.getVerticalResolution();
    }

    boolean isValid() {
        return this.getWidthPixels() > 0 && this.getHeightPixels() > 0;
    }

    public int getWidthPixels() {
        return this.sp;
    }

    public int getHeightPixels() {
        return this.apJ;
    }

    public double getHorizontalResolution() {
        return this.nh;
    }

    public double getVerticalResolution() {
        return this.ni;
    }

    public double getWidthPoints() {
        return ConvertUtil.pixelToPoint(this.sp, this.nh);
    }

    public double getHeightPoints() {
        return ConvertUtil.pixelToPoint(this.apJ, this.ni);
    }

    int hy() {
        return az.f(this.sp, this.nh);
    }

    int hz() {
        return az.f(this.apJ, this.ni);
    }
}

