/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.jc;
import asposewobfuscated.je;
import asposewobfuscated.ko;
import asposewobfuscated.st;
import asposewobfuscated.sv;
import asposewobfuscated.sy;
import asposewobfuscated.uj;
import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.axg;
import com.aspose.words.oz;
import java.io.EOFException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static final uj di = new uj("doc", "dot", "docx", "docm", "dotx", "dotm", "fopc", "rtf", "xml", "wml", "wordml", "pdf", "xps", "swf", "html", "htm", "xhtml", "mht", "mhtm", "mhtml", "msg", "eml", "odt", "ott", "txt", "epub", "xaml", "tiff", "tif", "png", "bmp", "jpeg", "jpg");

    private FileFormatUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        ko.h(fileName, "fileName");
        sv sv2 = st.bw(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.E(sv2);
            return fileFormatInfo;
        }
        finally {
            if (sv2 != null) {
                ((sy)sv2).close();
            }
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.E(je.a(stream));
    }

    static FileFormatInfo E(sy sy2) throws Exception {
        if (sy2 == null) {
            throw new IllegalArgumentException("stream");
        }
        try {
            oz oz2 = new oz();
            return oz2.C(sy2);
        }
        catch (Exception exception) {
            throw FileFormatUtil.a(exception);
        }
    }

    static Exception a(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ParseException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    public static String loadFormatToExtension(int loadFormat) {
        switch (loadFormat) {
            case 10: {
                return ".doc";
            }
            case 11: {
                return ".dot";
            }
            case 20: {
                return ".docx";
            }
            case 21: {
                return ".docm";
            }
            case 22: {
                return ".dotx";
            }
            case 23: {
                return ".dotm";
            }
            case 24: {
                return ".xml";
            }
            case 30: {
                return ".rtf";
            }
            case 31: {
                return ".wml";
            }
            case 50: {
                return ".html";
            }
            case 51: {
                return ".mhtml";
            }
            case 60: {
                return ".odt";
            }
            case 61: {
                return ".ott";
            }
            case 254: {
                return ".docx";
            }
        }
        throw new IllegalArgumentException("Unknown load format.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        switch (saveFormat) {
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 20: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 22: {
                return 22;
            }
            case 23: {
                return 23;
            }
            case 24: {
                return 24;
            }
            case 30: {
                return 30;
            }
            case 31: {
                return 31;
            }
            case 50: {
                return 50;
            }
            case 51: {
                return 51;
            }
            case 60: {
                return 60;
            }
            case 61: {
                return 61;
            }
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        switch (loadFormat) {
            case 0: 
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 20: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 22: {
                return 22;
            }
            case 23: {
                return 23;
            }
            case 24: {
                return 24;
            }
            case 30: {
                return 30;
            }
            case 31: {
                return 31;
            }
            case 50: {
                return 50;
            }
            case 51: {
                return 51;
            }
            case 60: {
                return 60;
            }
            case 61: {
                return 61;
            }
            case 254: {
                return 20;
            }
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int format) {
        switch (format) {
            case 10: {
                return ".doc";
            }
            case 11: {
                return ".dot";
            }
            case 20: {
                return ".docx";
            }
            case 21: {
                return ".docm";
            }
            case 22: {
                return ".dotx";
            }
            case 23: {
                return ".dotm";
            }
            case 24: {
                return ".fopc";
            }
            case 30: {
                return ".rtf";
            }
            case 31: {
                return ".wml";
            }
            case 40: {
                return ".pdf";
            }
            case 41: {
                return ".xps";
            }
            case 42: {
                return ".xaml";
            }
            case 43: {
                return ".swf";
            }
            case 50: {
                return ".html";
            }
            case 51: {
                return ".mht";
            }
            case 60: {
                return ".odt";
            }
            case 61: {
                return ".ott";
            }
            case 70: {
                return ".txt";
            }
            case 52: {
                return ".epub";
            }
            case 71: {
                return ".xaml";
            }
            case 100: {
                return ".tiff";
            }
            case 101: {
                return ".png";
            }
            case 102: {
                return ".bmp";
            }
            case 104: {
                return ".jpeg";
            }
        }
        throw new IllegalStateException("Unknown save format.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new IllegalArgumentException("extension");
        }
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        switch (di.bR(extension.toLowerCase())) {
            case 0: {
                return 10;
            }
            case 1: {
                return 11;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 21;
            }
            case 4: {
                return 22;
            }
            case 5: {
                return 23;
            }
            case 6: {
                return 24;
            }
            case 7: {
                return 30;
            }
            case 8: 
            case 9: 
            case 10: {
                return 31;
            }
            case 11: {
                return 40;
            }
            case 12: {
                return 41;
            }
            case 13: {
                return 43;
            }
            case 14: 
            case 15: 
            case 16: {
                return 50;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return 51;
            }
            case 22: {
                return 60;
            }
            case 23: {
                return 61;
            }
            case 24: {
                return 70;
            }
            case 25: {
                return 52;
            }
            case 26: {
                return 71;
            }
            case 27: 
            case 28: {
                return 100;
            }
            case 29: {
                return 101;
            }
            case 30: {
                return 102;
            }
            case 31: 
            case 32: {
                return 104;
            }
        }
        return 0;
    }

    public static String imageTypeToExtension(int imageType) {
        return "." + jc.ae(axg.tl(imageType));
    }
}

