<?php
/**
+-----------------------------------------------------------------------------------------------
* GouGuOPEN [ 左手研发，右手开源，未来可期！]
+-----------------------------------------------------------------------------------------------
* @Copyright (c) 2021~2024 http://www.gouguoa.com All rights reserved.
+-----------------------------------------------------------------------------------------------
* @Licensed 勾股OA，开源且可免费使用，但并不是自由软件，未经授权许可不能去除勾股OA的相关版权信息
+-----------------------------------------------------------------------------------------------
* @Author 勾股工作室 <hdm58@qq.com>
+-----------------------------------------------------------------------------------------------
*/
declare (strict_types = 1);
namespace app\oa\controller;

use app\api\BaseController;
use app\oa\model\Schedule;
use app\oa\model\WorkComment;
use think\facade\Db;
use think\facade\View;

class Api extends BaseController
{
	//获取工作日志列表
    public function get_schedule()
    {
		$param = get_params();
		$project_id = isset($param['project_id']) ? $param['project_id'] : 0;
		$task_id = isset($param['task_id']) ? $param['task_id'] : 0;
		if ($project_id>0) {
			$task_ids = Db::name('ProjectTask')->where(['delete_time' => 0, 'project_id' => $project_id])->column('id');
			$where[] = ['a.tid', 'in', $task_ids];
		}
		if ($task_id>0) {
			$where[] = ['a.tid', '=', $task_id];
		}
		$where[] = ['a.delete_time', '=', 0];
		$model = new Schedule();
		$list = $model->datalist($param,$where);
		return table_assign(0, '', $list);
    }
	
    //调整工时
    public function update_schedule()
    {
        $param = get_params();
		$is_leader = isLeader($this->uid);
		$role_auth = isAuth($this->uid,'office_admin','conf_1');
		$hour_auth = valueAuth('office_admin','conf_2');
		$edit_role = false;		
		if($hour_auth==4 && $role_auth > 0){
			$edit_role = true;	
		}
		if($hour_auth==3 && $is_leader > 0){
			$edit_role = true;
		}
		if($hour_auth==2){
			$admin_id = Db::name('Schedule')->where('id',$param['id'])->value('admin_id');
			if($admin_id == $this->uid){
				$edit_role = true;
			}				
		}
		if($edit_role == false){
			return to_assign(1, "您无权限编辑");
		}
		
        if (isset($param['start_time_a'])) {
            $param['start_time'] = strtotime($param['start_time_a'] . '' . $param['start_time_b']);
        }
        if (isset($param['end_time_a'])) {
            $param['end_time'] = strtotime($param['end_time_a'] . '' . $param['end_time_b']);
        }
		if($param['start_time']>time()){
			return to_assign(1, "开始时间不能大于当前时间");		
		}
        if ($param['end_time'] <= $param['start_time']) {
            return to_assign(1, "结束时间需要大于开始时间");
        }
        $where1[] = ['delete_time', '=', 0];
        $where1[] = ['id', '<>', $param['id']];
        $where1[] = ['admin_id', '=', $param['admin_id']];
        $where1[] = ['start_time', 'between', [$param['start_time'], $param['end_time'] - 1]];

        $where2[] = ['delete_time', '=', 0];
        $where2[] = ['id', '<>', $param['id']];
        $where2[] = ['admin_id', '=', $param['admin_id']];
        $where2[] = ['start_time', '<=', $param['start_time']];
        $where2[] = ['start_time', '>=', $param['end_time']];

        $where3[] = ['delete_time', '=', 0];
        $where3[] = ['id', '<>', $param['id']];
        $where3[] = ['admin_id', '=', $param['admin_id']];
        $where3[] = ['end_time', 'between', [$param['start_time'] + 1, $param['end_time']]];

        $record = Db::name('Schedule')
            ->where(function ($query) use ($where1) {
                $query->where($where1);
            })
            ->whereOr(function ($query) use ($where2) {
                $query->where($where2);
            })
            ->whereOr(function ($query) use ($where3) {
                $query->where($where3);
            })
            ->count();
        if ($record > 0) {
            return to_assign(1, "您所选的时间区间已有工作记录，请重新选时间");
        }
        $param['labor_time'] = ($param['end_time'] - $param['start_time']) / 3600;
        $res = Db::name('Schedule')->strict(false)->field(true)->update($param);
        if ($res !== false) {
            return to_assign(0, "操作成功");
            add_log('edit', $param['id'], $param);
        } else {
            return to_assign(1, "操作失败");
        }
    }
	
	//获取评论列表
    public function work_comment()
    {
		$param = get_params();
		$list = new WorkComment();
		$content = $list->get_list($param);
		return to_assign(0, '', $content);
    }
	
    //添加修改评论内容
    public function add_comment()
    {
		$param = get_params();	
		if (!empty($param['id']) && $param['id'] > 0) {
			$param['update_time'] = time();
			unset($param['pid']);
			unset($param['padmin_id']);
            $res = WorkComment::where(['admin_id' => $this->uid,'id'=>$param['id']])->strict(false)->field(true)->update($param);
			if ($res) {
				add_log('edit', $param['id'], $param,'评论');
				return to_assign();
			}
        } else {
            $param['create_time'] = time();
            $param['admin_id'] = $this->uid;
            $cid = WorkComment::strict(false)->field(true)->insertGetId($param);
			if ($cid) {
				add_log('add', $cid, $param,'评论');
				$msg=[
					'from_uid'=>$this->uid,//发送人
					'to_uids'=>Db::name('Work')->where('id',$param['work_id'])->value('admin_id'),//接收人
					'template_id'=>'work_commet',//消息模板标识
					'content'=>[ //消息内容
						'create_time'=>date('Y-m-d H:i:s'),
						'action_id'=>$param['work_id']
					]
				];
				send_message($msg);
				return to_assign();
			}			
		}
    }
	
	//删除评论内容
    public function delete_comment()
    {
		if (request()->isDelete()) {
			$id = get_params("id");
			$res = WorkComment::where('id',$id)->strict(false)->field(true)->update(['delete_time'=>time()]);
			if ($res) {
				add_log('delete', $id,[],'评论');
				return to_assign(0, "删除成功");
			} else {
				return to_assign(1, "删除失败");
			}
		}else{
			return to_assign(1, "错误的请求");
		}
    }
}
