SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for oa_city
-- ----------------------------
DROP TABLE IF EXISTS `oa_city`;
CREATE TABLE `oa_city`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '地区编码',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '地区名称',
  `level` tinyint(4) UNSIGNED NOT NULL DEFAULT 0 COMMENT '地区级别',
  `pid` mediumint(8) UNSIGNED NOT NULL DEFAULT 0 COMMENT '地区父编码id',
  `region_path` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '地区编码路径',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '中国省市区数据表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of oa_city
-- ----------------------------
INSERT INTO `oa_city` VALUES (110000, '北京市', 1, 0, ',110000,');
INSERT INTO `oa_city` VALUES (110101, '东城区', 2, 110000, ',110000,110101,');
INSERT INTO `oa_city` VALUES (110102, '西城区', 2, 110000, ',110000,110102,');
INSERT INTO `oa_city` VALUES (110103, '崇文区', 2, 110000, ',110000,110103,');
INSERT INTO `oa_city` VALUES (110104, '宣武区', 2, 110000, ',110000,110104,');
INSERT INTO `oa_city` VALUES (110105, '朝阳区', 2, 110000, ',110000,110105,');
INSERT INTO `oa_city` VALUES (110106, '丰台区', 2, 110000, ',110000,110106,');
INSERT INTO `oa_city` VALUES (110107, '石景山区', 2, 110000, ',110000,110107,');
INSERT INTO `oa_city` VALUES (110108, '海淀区', 2, 110000, ',110000,110108,');
INSERT INTO `oa_city` VALUES (110109, '门头沟区', 2, 110000, ',110000,110109,');
INSERT INTO `oa_city` VALUES (110111, '房山区', 2, 110000, ',110000,110111,');
INSERT INTO `oa_city` VALUES (110112, '通州区', 2, 110000, ',110000,110112,');
INSERT INTO `oa_city` VALUES (110113, '顺义区', 2, 110000, ',110000,110113,');
INSERT INTO `oa_city` VALUES (110114, '昌平区', 2, 110000, ',110000,110114,');
INSERT INTO `oa_city` VALUES (110115, '大兴区', 2, 110000, ',110000,110115,');
INSERT INTO `oa_city` VALUES (110116, '怀柔区', 2, 110000, ',110000,110116,');
INSERT INTO `oa_city` VALUES (110117, '平谷区', 2, 110000, ',110000,110117,');
INSERT INTO `oa_city` VALUES (110228, '密云县', 2, 110000, ',110000,110228,');
INSERT INTO `oa_city` VALUES (110229, '延庆县', 2, 110000, ',110000,110229,');
INSERT INTO `oa_city` VALUES (120000, '天津市', 1, 0, ',120000,');
INSERT INTO `oa_city` VALUES (120101, '和平区', 2, 120000, ',120000,120101,');
INSERT INTO `oa_city` VALUES (120102, '河东区', 2, 120000, ',120000,120102,');
INSERT INTO `oa_city` VALUES (120103, '河西区', 2, 120000, ',120000,120103,');
INSERT INTO `oa_city` VALUES (120104, '南开区', 2, 120000, ',120000,120104,');
INSERT INTO `oa_city` VALUES (120105, '河北区', 2, 120000, ',120000,120105,');
INSERT INTO `oa_city` VALUES (120106, '红桥区', 2, 120000, ',120000,120106,');
INSERT INTO `oa_city` VALUES (120107, '塘沽区', 2, 120000, ',120000,120107,');
INSERT INTO `oa_city` VALUES (120108, '汉沽区', 2, 120000, ',120000,120108,');
INSERT INTO `oa_city` VALUES (120109, '大港区', 2, 120000, ',120000,120109,');
INSERT INTO `oa_city` VALUES (120110, '东丽区', 2, 120000, ',120000,120110,');
INSERT INTO `oa_city` VALUES (120111, '西青区', 2, 120000, ',120000,120111,');
INSERT INTO `oa_city` VALUES (120112, '津南区', 2, 120000, ',120000,120112,');
INSERT INTO `oa_city` VALUES (120113, '北辰区', 2, 120000, ',120000,120113,');
INSERT INTO `oa_city` VALUES (120114, '武清区', 2, 120000, ',120000,120114,');
INSERT INTO `oa_city` VALUES (120115, '宝坻区', 2, 120000, ',120000,120115,');
INSERT INTO `oa_city` VALUES (120116, '滨海新区', 2, 120000, ',120000,120116,');
INSERT INTO `oa_city` VALUES (120221, '宁河县', 3, 120000, ',120000,120221,');
INSERT INTO `oa_city` VALUES (120223, '静海县', 3, 120000, ',120000,120223,');
INSERT INTO `oa_city` VALUES (120225, '蓟　县', 3, 120000, ',120000,120225,');
INSERT INTO `oa_city` VALUES (130000, '河北省', 1, 0, ',130000,');
INSERT INTO `oa_city` VALUES (130100, '石家庄市', 2, 130000, ',130000,130100,');
INSERT INTO `oa_city` VALUES (130102, '长安区', 3, 130100, ',130000,130100,130102,');
INSERT INTO `oa_city` VALUES (130103, '桥东区', 3, 130100, ',130000,130100,130103,');
INSERT INTO `oa_city` VALUES (130104, '桥西区', 3, 130100, ',130000,130100,130104,');
INSERT INTO `oa_city` VALUES (130105, '新华区', 3, 130100, ',130000,130100,130105,');
INSERT INTO `oa_city` VALUES (130107, '井陉矿区', 3, 130100, ',130000,130100,130107,');
INSERT INTO `oa_city` VALUES (130108, '裕华区', 3, 130100, ',130000,130100,130108,');
INSERT INTO `oa_city` VALUES (130121, '井陉县', 3, 130100, ',130000,130100,130121,');
INSERT INTO `oa_city` VALUES (130123, '正定县', 3, 130100, ',130000,130100,130123,');
INSERT INTO `oa_city` VALUES (130124, '栾城县', 3, 130100, ',130000,130100,130124,');
INSERT INTO `oa_city` VALUES (130125, '行唐县', 3, 130100, ',130000,130100,130125,');
INSERT INTO `oa_city` VALUES (130126, '灵寿县', 3, 130100, ',130000,130100,130126,');
INSERT INTO `oa_city` VALUES (130127, '高邑县', 3, 130100, ',130000,130100,130127,');
INSERT INTO `oa_city` VALUES (130128, '深泽县', 3, 130100, ',130000,130100,130128,');
INSERT INTO `oa_city` VALUES (130129, '赞皇县', 3, 130100, ',130000,130100,130129,');
INSERT INTO `oa_city` VALUES (130130, '无极县', 3, 130100, ',130000,130100,130130,');
INSERT INTO `oa_city` VALUES (130131, '平山县', 3, 130100, ',130000,130100,130131,');
INSERT INTO `oa_city` VALUES (130132, '元氏县', 3, 130100, ',130000,130100,130132,');
INSERT INTO `oa_city` VALUES (130133, '赵　县', 3, 130100, ',130000,130100,130133,');
INSERT INTO `oa_city` VALUES (130181, '辛集市', 3, 130100, ',130000,130100,130181,');
INSERT INTO `oa_city` VALUES (130182, '藁城市', 3, 130100, ',130000,130100,130182,');
INSERT INTO `oa_city` VALUES (130183, '晋州市', 3, 130100, ',130000,130100,130183,');
INSERT INTO `oa_city` VALUES (130184, '新乐市', 3, 130100, ',130000,130100,130184,');
INSERT INTO `oa_city` VALUES (130185, '鹿泉市', 3, 130100, ',130000,130100,130185,');
INSERT INTO `oa_city` VALUES (130200, '唐山市', 2, 130000, ',130000,130200,');
INSERT INTO `oa_city` VALUES (130202, '路南区', 3, 130200, ',130000,130200,130202,');
INSERT INTO `oa_city` VALUES (130203, '路北区', 3, 130200, ',130000,130200,130203,');
INSERT INTO `oa_city` VALUES (130204, '古冶区', 3, 130200, ',130000,130200,130204,');
INSERT INTO `oa_city` VALUES (130205, '开平区', 3, 130200, ',130000,130200,130205,');
INSERT INTO `oa_city` VALUES (130207, '丰南区', 3, 130200, ',130000,130200,130207,');
INSERT INTO `oa_city` VALUES (130208, '丰润区', 3, 130200, ',130000,130200,130208,');
INSERT INTO `oa_city` VALUES (130223, '滦　县', 3, 130200, ',130000,130200,130223,');
INSERT INTO `oa_city` VALUES (130224, '滦南县', 3, 130200, ',130000,130200,130224,');
INSERT INTO `oa_city` VALUES (130225, '乐亭县', 3, 130200, ',130000,130200,130225,');
INSERT INTO `oa_city` VALUES (130227, '迁西县', 3, 130200, ',130000,130200,130227,');
INSERT INTO `oa_city` VALUES (130229, '玉田县', 3, 130200, ',130000,130200,130229,');
INSERT INTO `oa_city` VALUES (130230, '唐海县', 3, 130200, ',130000,130200,130230,');
INSERT INTO `oa_city` VALUES (130281, '遵化市', 3, 130200, ',130000,130200,130281,');
INSERT INTO `oa_city` VALUES (130283, '迁安市', 3, 130200, ',130000,130200,130283,');
INSERT INTO `oa_city` VALUES (130300, '秦皇岛市', 2, 130000, ',130000,130300,');
INSERT INTO `oa_city` VALUES (130302, '海港区', 3, 130300, ',130000,130300,130302,');
INSERT INTO `oa_city` VALUES (130303, '山海关区', 3, 130300, ',130000,130300,130303,');
INSERT INTO `oa_city` VALUES (130304, '北戴河区', 3, 130300, ',130000,130300,130304,');
INSERT INTO `oa_city` VALUES (130321, '青龙满族自治县', 3, 130300, ',130000,130300,130321,');
INSERT INTO `oa_city` VALUES (130322, '昌黎县', 3, 130300, ',130000,130300,130322,');
INSERT INTO `oa_city` VALUES (130323, '抚宁县', 3, 130300, ',130000,130300,130323,');
INSERT INTO `oa_city` VALUES (130324, '卢龙县', 3, 130300, ',130000,130300,130324,');
INSERT INTO `oa_city` VALUES (130400, '邯郸市', 2, 130000, ',130000,130400,');
INSERT INTO `oa_city` VALUES (130402, '邯山区', 3, 130400, ',130000,130400,130402,');
INSERT INTO `oa_city` VALUES (130403, '丛台区', 3, 130400, ',130000,130400,130403,');
INSERT INTO `oa_city` VALUES (130404, '复兴区', 3, 130400, ',130000,130400,130404,');
INSERT INTO `oa_city` VALUES (130406, '峰峰矿区', 3, 130400, ',130000,130400,130406,');
INSERT INTO `oa_city` VALUES (130421, '邯郸县', 3, 130400, ',130000,130400,130421,');
INSERT INTO `oa_city` VALUES (130423, '临漳县', 3, 130400, ',130000,130400,130423,');
INSERT INTO `oa_city` VALUES (130424, '成安县', 3, 130400, ',130000,130400,130424,');
INSERT INTO `oa_city` VALUES (130425, '大名县', 3, 130400, ',130000,130400,130425,');
INSERT INTO `oa_city` VALUES (130426, '涉　县', 3, 130400, ',130000,130400,130426,');
INSERT INTO `oa_city` VALUES (130427, '磁　县', 3, 130400, ',130000,130400,130427,');
INSERT INTO `oa_city` VALUES (130428, '肥乡县', 3, 130400, ',130000,130400,130428,');
INSERT INTO `oa_city` VALUES (130429, '永年县', 3, 130400, ',130000,130400,130429,');
INSERT INTO `oa_city` VALUES (130430, '邱　县', 3, 130400, ',130000,130400,130430,');
INSERT INTO `oa_city` VALUES (130431, '鸡泽县', 3, 130400, ',130000,130400,130431,');
INSERT INTO `oa_city` VALUES (130432, '广平县', 3, 130400, ',130000,130400,130432,');
INSERT INTO `oa_city` VALUES (130433, '馆陶县', 3, 130400, ',130000,130400,130433,');
INSERT INTO `oa_city` VALUES (130434, '魏　县', 3, 130400, ',130000,130400,130434,');
INSERT INTO `oa_city` VALUES (130435, '曲周县', 3, 130400, ',130000,130400,130435,');
INSERT INTO `oa_city` VALUES (130481, '武安市', 3, 130400, ',130000,130400,130481,');
INSERT INTO `oa_city` VALUES (130500, '邢台市', 2, 130000, ',130000,130500,');
INSERT INTO `oa_city` VALUES (130502, '桥东区', 3, 130500, ',130000,130500,130502,');
INSERT INTO `oa_city` VALUES (130503, '桥西区', 3, 130500, ',130000,130500,130503,');
INSERT INTO `oa_city` VALUES (130521, '邢台县', 3, 130500, ',130000,130500,130521,');
INSERT INTO `oa_city` VALUES (130522, '临城县', 3, 130500, ',130000,130500,130522,');
INSERT INTO `oa_city` VALUES (130523, '内丘县', 3, 130500, ',130000,130500,130523,');
INSERT INTO `oa_city` VALUES (130524, '柏乡县', 3, 130500, ',130000,130500,130524,');
INSERT INTO `oa_city` VALUES (130525, '隆尧县', 3, 130500, ',130000,130500,130525,');
INSERT INTO `oa_city` VALUES (130526, '任　县', 3, 130500, ',130000,130500,130526,');
INSERT INTO `oa_city` VALUES (130527, '南和县', 3, 130500, ',130000,130500,130527,');
INSERT INTO `oa_city` VALUES (130528, '宁晋县', 3, 130500, ',130000,130500,130528,');
INSERT INTO `oa_city` VALUES (130529, '巨鹿县', 3, 130500, ',130000,130500,130529,');
INSERT INTO `oa_city` VALUES (130530, '新河县', 3, 130500, ',130000,130500,130530,');
INSERT INTO `oa_city` VALUES (130531, '广宗县', 3, 130500, ',130000,130500,130531,');
INSERT INTO `oa_city` VALUES (130532, '平乡县', 3, 130500, ',130000,130500,130532,');
INSERT INTO `oa_city` VALUES (130533, '威　县', 3, 130500, ',130000,130500,130533,');
INSERT INTO `oa_city` VALUES (130534, '清河县', 3, 130500, ',130000,130500,130534,');
INSERT INTO `oa_city` VALUES (130535, '临西县', 3, 130500, ',130000,130500,130535,');
INSERT INTO `oa_city` VALUES (130581, '南宫市', 3, 130500, ',130000,130500,130581,');
INSERT INTO `oa_city` VALUES (130582, '沙河市', 3, 130500, ',130000,130500,130582,');
INSERT INTO `oa_city` VALUES (130600, '保定市', 2, 130000, ',130000,130600,');
INSERT INTO `oa_city` VALUES (130602, '新市区', 3, 130600, ',130000,130600,130602,');
INSERT INTO `oa_city` VALUES (130603, '北市区', 3, 130600, ',130000,130600,130603,');
INSERT INTO `oa_city` VALUES (130604, '南市区', 3, 130600, ',130000,130600,130604,');
INSERT INTO `oa_city` VALUES (130621, '满城县', 3, 130600, ',130000,130600,130621,');
INSERT INTO `oa_city` VALUES (130622, '清苑县', 3, 130600, ',130000,130600,130622,');
INSERT INTO `oa_city` VALUES (130623, '涞水县', 3, 130600, ',130000,130600,130623,');
INSERT INTO `oa_city` VALUES (130624, '阜平县', 3, 130600, ',130000,130600,130624,');
INSERT INTO `oa_city` VALUES (130625, '徐水县', 3, 130600, ',130000,130600,130625,');
INSERT INTO `oa_city` VALUES (130626, '定兴县', 3, 130600, ',130000,130600,130626,');
INSERT INTO `oa_city` VALUES (130627, '唐　县', 3, 130600, ',130000,130600,130627,');
INSERT INTO `oa_city` VALUES (130628, '高阳县', 3, 130600, ',130000,130600,130628,');
INSERT INTO `oa_city` VALUES (130629, '容城县', 3, 130600, ',130000,130600,130629,');
INSERT INTO `oa_city` VALUES (130630, '涞源县', 3, 130600, ',130000,130600,130630,');
INSERT INTO `oa_city` VALUES (130631, '望都县', 3, 130600, ',130000,130600,130631,');
INSERT INTO `oa_city` VALUES (130632, '安新县', 3, 130600, ',130000,130600,130632,');
INSERT INTO `oa_city` VALUES (130633, '易　县', 3, 130600, ',130000,130600,130633,');
INSERT INTO `oa_city` VALUES (130634, '曲阳县', 3, 130600, ',130000,130600,130634,');
INSERT INTO `oa_city` VALUES (130635, '蠡　县', 3, 130600, ',130000,130600,130635,');
INSERT INTO `oa_city` VALUES (130636, '顺平县', 3, 130600, ',130000,130600,130636,');
INSERT INTO `oa_city` VALUES (130637, '博野县', 3, 130600, ',130000,130600,130637,');
INSERT INTO `oa_city` VALUES (130638, '雄　县', 3, 130600, ',130000,130600,130638,');
INSERT INTO `oa_city` VALUES (130681, '涿州市', 3, 130600, ',130000,130600,130681,');
INSERT INTO `oa_city` VALUES (130682, '定州市', 3, 130600, ',130000,130600,130682,');
INSERT INTO `oa_city` VALUES (130683, '安国市', 3, 130600, ',130000,130600,130683,');
INSERT INTO `oa_city` VALUES (130684, '高碑店市', 3, 130600, ',130000,130600,130684,');
INSERT INTO `oa_city` VALUES (130700, '张家口市', 2, 130000, ',130000,130700,');
INSERT INTO `oa_city` VALUES (130702, '桥东区', 3, 130700, ',130000,130700,130702,');
INSERT INTO `oa_city` VALUES (130703, '桥西区', 3, 130700, ',130000,130700,130703,');
INSERT INTO `oa_city` VALUES (130705, '宣化区', 3, 130700, ',130000,130700,130705,');
INSERT INTO `oa_city` VALUES (130706, '下花园区', 3, 130700, ',130000,130700,130706,');
INSERT INTO `oa_city` VALUES (130721, '宣化县', 3, 130700, ',130000,130700,130721,');
INSERT INTO `oa_city` VALUES (130722, '张北县', 3, 130700, ',130000,130700,130722,');
INSERT INTO `oa_city` VALUES (130723, '康保县', 3, 130700, ',130000,130700,130723,');
INSERT INTO `oa_city` VALUES (130724, '沽源县', 3, 130700, ',130000,130700,130724,');
INSERT INTO `oa_city` VALUES (130725, '尚义县', 3, 130700, ',130000,130700,130725,');
INSERT INTO `oa_city` VALUES (130726, '蔚　县', 3, 130700, ',130000,130700,130726,');
INSERT INTO `oa_city` VALUES (130727, '阳原县', 3, 130700, ',130000,130700,130727,');
INSERT INTO `oa_city` VALUES (130728, '怀安县', 3, 130700, ',130000,130700,130728,');
INSERT INTO `oa_city` VALUES (130729, '万全县', 3, 130700, ',130000,130700,130729,');
INSERT INTO `oa_city` VALUES (130730, '怀来县', 3, 130700, ',130000,130700,130730,');
INSERT INTO `oa_city` VALUES (130731, '涿鹿县', 3, 130700, ',130000,130700,130731,');
INSERT INTO `oa_city` VALUES (130732, '赤城县', 3, 130700, ',130000,130700,130732,');
INSERT INTO `oa_city` VALUES (130733, '崇礼县', 3, 130700, ',130000,130700,130733,');
INSERT INTO `oa_city` VALUES (130800, '承德市', 2, 130000, ',130000,130800,');
INSERT INTO `oa_city` VALUES (130802, '双桥区', 3, 130800, ',130000,130800,130802,');
INSERT INTO `oa_city` VALUES (130803, '双滦区', 3, 130800, ',130000,130800,130803,');
INSERT INTO `oa_city` VALUES (130804, '鹰手营子矿区', 3, 130800, ',130000,130800,130804,');
INSERT INTO `oa_city` VALUES (130821, '承德县', 3, 130800, ',130000,130800,130821,');
INSERT INTO `oa_city` VALUES (130822, '兴隆县', 3, 130800, ',130000,130800,130822,');
INSERT INTO `oa_city` VALUES (130823, '平泉县', 3, 130800, ',130000,130800,130823,');
INSERT INTO `oa_city` VALUES (130824, '滦平县', 3, 130800, ',130000,130800,130824,');
INSERT INTO `oa_city` VALUES (130825, '隆化县', 3, 130800, ',130000,130800,130825,');
INSERT INTO `oa_city` VALUES (130826, '丰宁满族自治县', 3, 130800, ',130000,130800,130826,');
INSERT INTO `oa_city` VALUES (130827, '宽城满族自治县', 3, 130800, ',130000,130800,130827,');
INSERT INTO `oa_city` VALUES (130828, '围场满族蒙古族自治县', 3, 130800, ',130000,130800,130828,');
INSERT INTO `oa_city` VALUES (130900, '沧州市', 2, 130000, ',130000,130900,');
INSERT INTO `oa_city` VALUES (130902, '新华区', 3, 130900, ',130000,130900,130902,');
INSERT INTO `oa_city` VALUES (130903, '运河区', 3, 130900, ',130000,130900,130903,');
INSERT INTO `oa_city` VALUES (130921, '沧　县', 3, 130900, ',130000,130900,130921,');
INSERT INTO `oa_city` VALUES (130922, '青　县', 3, 130900, ',130000,130900,130922,');
INSERT INTO `oa_city` VALUES (130923, '东光县', 3, 130900, ',130000,130900,130923,');
INSERT INTO `oa_city` VALUES (130924, '海兴县', 3, 130900, ',130000,130900,130924,');
INSERT INTO `oa_city` VALUES (130925, '盐山县', 3, 130900, ',130000,130900,130925,');
INSERT INTO `oa_city` VALUES (130926, '肃宁县', 3, 130900, ',130000,130900,130926,');
INSERT INTO `oa_city` VALUES (130927, '南皮县', 3, 130900, ',130000,130900,130927,');
INSERT INTO `oa_city` VALUES (130928, '吴桥县', 3, 130900, ',130000,130900,130928,');
INSERT INTO `oa_city` VALUES (130929, '献　县', 3, 130900, ',130000,130900,130929,');
INSERT INTO `oa_city` VALUES (130930, '孟村回族自治县', 3, 130900, ',130000,130900,130930,');
INSERT INTO `oa_city` VALUES (130981, '泊头市', 3, 130900, ',130000,130900,130981,');
INSERT INTO `oa_city` VALUES (130982, '任丘市', 3, 130900, ',130000,130900,130982,');
INSERT INTO `oa_city` VALUES (130983, '黄骅市', 3, 130900, ',130000,130900,130983,');
INSERT INTO `oa_city` VALUES (130984, '河间市', 3, 130900, ',130000,130900,130984,');
INSERT INTO `oa_city` VALUES (131000, '廊坊市', 2, 130000, ',130000,131000,');
INSERT INTO `oa_city` VALUES (131002, '安次区', 3, 131000, ',130000,131000,131002,');
INSERT INTO `oa_city` VALUES (131003, '广阳区', 3, 131000, ',130000,131000,131003,');
INSERT INTO `oa_city` VALUES (131022, '固安县', 3, 131000, ',130000,131000,131022,');
INSERT INTO `oa_city` VALUES (131023, '永清县', 3, 131000, ',130000,131000,131023,');
INSERT INTO `oa_city` VALUES (131024, '香河县', 3, 131000, ',130000,131000,131024,');
INSERT INTO `oa_city` VALUES (131025, '大城县', 3, 131000, ',130000,131000,131025,');
INSERT INTO `oa_city` VALUES (131026, '文安县', 3, 131000, ',130000,131000,131026,');
INSERT INTO `oa_city` VALUES (131028, '大厂回族自治县', 3, 131000, ',130000,131000,131028,');
INSERT INTO `oa_city` VALUES (131081, '霸州市', 3, 131000, ',130000,131000,131081,');
INSERT INTO `oa_city` VALUES (131082, '三河市', 3, 131000, ',130000,131000,131082,');
INSERT INTO `oa_city` VALUES (131100, '衡水市', 2, 130000, ',130000,131100,');
INSERT INTO `oa_city` VALUES (131102, '桃城区', 3, 131100, ',130000,131100,131102,');
INSERT INTO `oa_city` VALUES (131121, '枣强县', 3, 131100, ',130000,131100,131121,');
INSERT INTO `oa_city` VALUES (131122, '武邑县', 3, 131100, ',130000,131100,131122,');
INSERT INTO `oa_city` VALUES (131123, '武强县', 3, 131100, ',130000,131100,131123,');
INSERT INTO `oa_city` VALUES (131124, '饶阳县', 3, 131100, ',130000,131100,131124,');
INSERT INTO `oa_city` VALUES (131125, '安平县', 3, 131100, ',130000,131100,131125,');
INSERT INTO `oa_city` VALUES (131126, '故城县', 3, 131100, ',130000,131100,131126,');
INSERT INTO `oa_city` VALUES (131127, '景　县', 3, 131100, ',130000,131100,131127,');
INSERT INTO `oa_city` VALUES (131128, '阜城县', 3, 131100, ',130000,131100,131128,');
INSERT INTO `oa_city` VALUES (131181, '冀州市', 3, 131100, ',130000,131100,131181,');
INSERT INTO `oa_city` VALUES (131182, '深州市', 3, 131100, ',130000,131100,131182,');
INSERT INTO `oa_city` VALUES (140000, '山西省', 1, 0, ',140000,');
INSERT INTO `oa_city` VALUES (140100, '太原市', 2, 140000, ',140000,140100,');
INSERT INTO `oa_city` VALUES (140105, '小店区', 3, 140100, ',140000,140100,140105,');
INSERT INTO `oa_city` VALUES (140106, '迎泽区', 3, 140100, ',140000,140100,140106,');
INSERT INTO `oa_city` VALUES (140107, '杏花岭区', 3, 140100, ',140000,140100,140107,');
INSERT INTO `oa_city` VALUES (140108, '尖草坪区', 3, 140100, ',140000,140100,140108,');
INSERT INTO `oa_city` VALUES (140109, '万柏林区', 3, 140100, ',140000,140100,140109,');
INSERT INTO `oa_city` VALUES (140110, '晋源区', 3, 140100, ',140000,140100,140110,');
INSERT INTO `oa_city` VALUES (140121, '清徐县', 3, 140100, ',140000,140100,140121,');
INSERT INTO `oa_city` VALUES (140122, '阳曲县', 3, 140100, ',140000,140100,140122,');
INSERT INTO `oa_city` VALUES (140123, '娄烦县', 3, 140100, ',140000,140100,140123,');
INSERT INTO `oa_city` VALUES (140181, '古交市', 3, 140100, ',140000,140100,140181,');
INSERT INTO `oa_city` VALUES (140200, '大同市', 2, 140000, ',140000,140200,');
INSERT INTO `oa_city` VALUES (140202, '城　区', 3, 140200, ',140000,140200,140202,');
INSERT INTO `oa_city` VALUES (140203, '矿　区', 3, 140200, ',140000,140200,140203,');
INSERT INTO `oa_city` VALUES (140211, '南郊区', 3, 140200, ',140000,140200,140211,');
INSERT INTO `oa_city` VALUES (140212, '新荣区', 3, 140200, ',140000,140200,140212,');
INSERT INTO `oa_city` VALUES (140221, '阳高县', 3, 140200, ',140000,140200,140221,');
INSERT INTO `oa_city` VALUES (140222, '天镇县', 3, 140200, ',140000,140200,140222,');
INSERT INTO `oa_city` VALUES (140223, '广灵县', 3, 140200, ',140000,140200,140223,');
INSERT INTO `oa_city` VALUES (140224, '灵丘县', 3, 140200, ',140000,140200,140224,');
INSERT INTO `oa_city` VALUES (140225, '浑源县', 3, 140200, ',140000,140200,140225,');
INSERT INTO `oa_city` VALUES (140226, '左云县', 3, 140200, ',140000,140200,140226,');
INSERT INTO `oa_city` VALUES (140227, '大同县', 3, 140200, ',140000,140200,140227,');
INSERT INTO `oa_city` VALUES (140300, '阳泉市', 2, 140000, ',140000,140300,');
INSERT INTO `oa_city` VALUES (140302, '城　区', 3, 140300, ',140000,140300,140302,');
INSERT INTO `oa_city` VALUES (140303, '矿　区', 3, 140300, ',140000,140300,140303,');
INSERT INTO `oa_city` VALUES (140311, '郊　区', 3, 140300, ',140000,140300,140311,');
INSERT INTO `oa_city` VALUES (140321, '平定县', 3, 140300, ',140000,140300,140321,');
INSERT INTO `oa_city` VALUES (140322, '盂　县', 3, 140300, ',140000,140300,140322,');
INSERT INTO `oa_city` VALUES (140400, '长治市', 2, 140000, ',140000,140400,');
INSERT INTO `oa_city` VALUES (140402, '城　区', 3, 140400, ',140000,140400,140402,');
INSERT INTO `oa_city` VALUES (140411, '郊　区', 3, 140400, ',140000,140400,140411,');
INSERT INTO `oa_city` VALUES (140421, '长治县', 3, 140400, ',140000,140400,140421,');
INSERT INTO `oa_city` VALUES (140423, '襄垣县', 3, 140400, ',140000,140400,140423,');
INSERT INTO `oa_city` VALUES (140424, '屯留县', 3, 140400, ',140000,140400,140424,');
INSERT INTO `oa_city` VALUES (140425, '平顺县', 3, 140400, ',140000,140400,140425,');
INSERT INTO `oa_city` VALUES (140426, '黎城县', 3, 140400, ',140000,140400,140426,');
INSERT INTO `oa_city` VALUES (140427, '壶关县', 3, 140400, ',140000,140400,140427,');
INSERT INTO `oa_city` VALUES (140428, '长子县', 3, 140400, ',140000,140400,140428,');
INSERT INTO `oa_city` VALUES (140429, '武乡县', 3, 140400, ',140000,140400,140429,');
INSERT INTO `oa_city` VALUES (140430, '沁　县', 3, 140400, ',140000,140400,140430,');
INSERT INTO `oa_city` VALUES (140431, '沁源县', 3, 140400, ',140000,140400,140431,');
INSERT INTO `oa_city` VALUES (140481, '潞城市', 3, 140400, ',140000,140400,140481,');
INSERT INTO `oa_city` VALUES (140500, '晋城市', 2, 140000, ',140000,140500,');
INSERT INTO `oa_city` VALUES (140502, '城　区', 3, 140500, ',140000,140500,140502,');
INSERT INTO `oa_city` VALUES (140521, '沁水县', 3, 140500, ',140000,140500,140521,');
INSERT INTO `oa_city` VALUES (140522, '阳城县', 3, 140500, ',140000,140500,140522,');
INSERT INTO `oa_city` VALUES (140524, '陵川县', 3, 140500, ',140000,140500,140524,');
INSERT INTO `oa_city` VALUES (140525, '泽州县', 3, 140500, ',140000,140500,140525,');
INSERT INTO `oa_city` VALUES (140581, '高平市', 3, 140500, ',140000,140500,140581,');
INSERT INTO `oa_city` VALUES (140600, '朔州市', 2, 140000, ',140000,140600,');
INSERT INTO `oa_city` VALUES (140602, '朔城区', 3, 140600, ',140000,140600,140602,');
INSERT INTO `oa_city` VALUES (140603, '平鲁区', 3, 140600, ',140000,140600,140603,');
INSERT INTO `oa_city` VALUES (140621, '山阴县', 3, 140600, ',140000,140600,140621,');
INSERT INTO `oa_city` VALUES (140622, '应　县', 3, 140600, ',140000,140600,140622,');
INSERT INTO `oa_city` VALUES (140623, '右玉县', 3, 140600, ',140000,140600,140623,');
INSERT INTO `oa_city` VALUES (140624, '怀仁县', 3, 140600, ',140000,140600,140624,');
INSERT INTO `oa_city` VALUES (140700, '晋中市', 2, 140000, ',140000,140700,');
INSERT INTO `oa_city` VALUES (140702, '榆次区', 3, 140700, ',140000,140700,140702,');
INSERT INTO `oa_city` VALUES (140721, '榆社县', 3, 140700, ',140000,140700,140721,');
INSERT INTO `oa_city` VALUES (140722, '左权县', 3, 140700, ',140000,140700,140722,');
INSERT INTO `oa_city` VALUES (140723, '和顺县', 3, 140700, ',140000,140700,140723,');
INSERT INTO `oa_city` VALUES (140724, '昔阳县', 3, 140700, ',140000,140700,140724,');
INSERT INTO `oa_city` VALUES (140725, '寿阳县', 3, 140700, ',140000,140700,140725,');
INSERT INTO `oa_city` VALUES (140726, '太谷县', 3, 140700, ',140000,140700,140726,');
INSERT INTO `oa_city` VALUES (140727, '祁　县', 3, 140700, ',140000,140700,140727,');
INSERT INTO `oa_city` VALUES (140728, '平遥县', 3, 140700, ',140000,140700,140728,');
INSERT INTO `oa_city` VALUES (140729, '灵石县', 3, 140700, ',140000,140700,140729,');
INSERT INTO `oa_city` VALUES (140781, '介休市', 3, 140700, ',140000,140700,140781,');
INSERT INTO `oa_city` VALUES (140800, '运城市', 2, 140000, ',140000,140800,');
INSERT INTO `oa_city` VALUES (140802, '盐湖区', 3, 140800, ',140000,140800,140802,');
INSERT INTO `oa_city` VALUES (140821, '临猗县', 3, 140800, ',140000,140800,140821,');
INSERT INTO `oa_city` VALUES (140822, '万荣县', 3, 140800, ',140000,140800,140822,');
INSERT INTO `oa_city` VALUES (140823, '闻喜县', 3, 140800, ',140000,140800,140823,');
INSERT INTO `oa_city` VALUES (140824, '稷山县', 3, 140800, ',140000,140800,140824,');
INSERT INTO `oa_city` VALUES (140825, '新绛县', 3, 140800, ',140000,140800,140825,');
INSERT INTO `oa_city` VALUES (140826, '绛　县', 3, 140800, ',140000,140800,140826,');
INSERT INTO `oa_city` VALUES (140827, '垣曲县', 3, 140800, ',140000,140800,140827,');
INSERT INTO `oa_city` VALUES (140828, '夏　县', 3, 140800, ',140000,140800,140828,');
INSERT INTO `oa_city` VALUES (140829, '平陆县', 3, 140800, ',140000,140800,140829,');
INSERT INTO `oa_city` VALUES (140830, '芮城县', 3, 140800, ',140000,140800,140830,');
INSERT INTO `oa_city` VALUES (140881, '永济市', 3, 140800, ',140000,140800,140881,');
INSERT INTO `oa_city` VALUES (140882, '河津市', 3, 140800, ',140000,140800,140882,');
INSERT INTO `oa_city` VALUES (140900, '忻州市', 2, 140000, ',140000,140900,');
INSERT INTO `oa_city` VALUES (140902, '忻府区', 3, 140900, ',140000,140900,140902,');
INSERT INTO `oa_city` VALUES (140921, '定襄县', 3, 140900, ',140000,140900,140921,');
INSERT INTO `oa_city` VALUES (140922, '五台县', 3, 140900, ',140000,140900,140922,');
INSERT INTO `oa_city` VALUES (140923, '代　县', 3, 140900, ',140000,140900,140923,');
INSERT INTO `oa_city` VALUES (140924, '繁峙县', 3, 140900, ',140000,140900,140924,');
INSERT INTO `oa_city` VALUES (140925, '宁武县', 3, 140900, ',140000,140900,140925,');
INSERT INTO `oa_city` VALUES (140926, '静乐县', 3, 140900, ',140000,140900,140926,');
INSERT INTO `oa_city` VALUES (140927, '神池县', 3, 140900, ',140000,140900,140927,');
INSERT INTO `oa_city` VALUES (140928, '五寨县', 3, 140900, ',140000,140900,140928,');
INSERT INTO `oa_city` VALUES (140929, '岢岚县', 3, 140900, ',140000,140900,140929,');
INSERT INTO `oa_city` VALUES (140930, '河曲县', 3, 140900, ',140000,140900,140930,');
INSERT INTO `oa_city` VALUES (140931, '保德县', 3, 140900, ',140000,140900,140931,');
INSERT INTO `oa_city` VALUES (140932, '偏关县', 3, 140900, ',140000,140900,140932,');
INSERT INTO `oa_city` VALUES (140981, '原平市', 3, 140900, ',140000,140900,140981,');
INSERT INTO `oa_city` VALUES (141000, '临汾市', 2, 140000, ',140000,141000,');
INSERT INTO `oa_city` VALUES (141002, '尧都区', 3, 141000, ',140000,141000,141002,');
INSERT INTO `oa_city` VALUES (141021, '曲沃县', 3, 141000, ',140000,141000,141021,');
INSERT INTO `oa_city` VALUES (141022, '翼城县', 3, 141000, ',140000,141000,141022,');
INSERT INTO `oa_city` VALUES (141023, '襄汾县', 3, 141000, ',140000,141000,141023,');
INSERT INTO `oa_city` VALUES (141024, '洪洞县', 3, 141000, ',140000,141000,141024,');
INSERT INTO `oa_city` VALUES (141025, '古　县', 3, 141000, ',140000,141000,141025,');
INSERT INTO `oa_city` VALUES (141026, '安泽县', 3, 141000, ',140000,141000,141026,');
INSERT INTO `oa_city` VALUES (141027, '浮山县', 3, 141000, ',140000,141000,141027,');
INSERT INTO `oa_city` VALUES (141028, '吉　县', 3, 141000, ',140000,141000,141028,');
INSERT INTO `oa_city` VALUES (141029, '乡宁县', 3, 141000, ',140000,141000,141029,');
INSERT INTO `oa_city` VALUES (141030, '大宁县', 3, 141000, ',140000,141000,141030,');
INSERT INTO `oa_city` VALUES (141031, '隰　县', 3, 141000, ',140000,141000,141031,');
INSERT INTO `oa_city` VALUES (141032, '永和县', 3, 141000, ',140000,141000,141032,');
INSERT INTO `oa_city` VALUES (141033, '蒲　县', 3, 141000, ',140000,141000,141033,');
INSERT INTO `oa_city` VALUES (141034, '汾西县', 3, 141000, ',140000,141000,141034,');
INSERT INTO `oa_city` VALUES (141081, '侯马市', 3, 141000, ',140000,141000,141081,');
INSERT INTO `oa_city` VALUES (141082, '霍州市', 3, 141000, ',140000,141000,141082,');
INSERT INTO `oa_city` VALUES (141100, '吕梁市', 2, 140000, ',140000,141100,');
INSERT INTO `oa_city` VALUES (141102, '离石区', 3, 141100, ',140000,141100,141102,');
INSERT INTO `oa_city` VALUES (141121, '文水县', 3, 141100, ',140000,141100,141121,');
INSERT INTO `oa_city` VALUES (141122, '交城县', 3, 141100, ',140000,141100,141122,');
INSERT INTO `oa_city` VALUES (141123, '兴　县', 3, 141100, ',140000,141100,141123,');
INSERT INTO `oa_city` VALUES (141124, '临　县', 3, 141100, ',140000,141100,141124,');
INSERT INTO `oa_city` VALUES (141125, '柳林县', 3, 141100, ',140000,141100,141125,');
INSERT INTO `oa_city` VALUES (141126, '石楼县', 3, 141100, ',140000,141100,141126,');
INSERT INTO `oa_city` VALUES (141127, '岚　县', 3, 141100, ',140000,141100,141127,');
INSERT INTO `oa_city` VALUES (141128, '方山县', 3, 141100, ',140000,141100,141128,');
INSERT INTO `oa_city` VALUES (141129, '中阳县', 3, 141100, ',140000,141100,141129,');
INSERT INTO `oa_city` VALUES (141130, '交口县', 3, 141100, ',140000,141100,141130,');
INSERT INTO `oa_city` VALUES (141181, '孝义市', 3, 141100, ',140000,141100,141181,');
INSERT INTO `oa_city` VALUES (141182, '汾阳市', 3, 141100, ',140000,141100,141182,');
INSERT INTO `oa_city` VALUES (150000, '内蒙古', 1, 0, ',150000,');
INSERT INTO `oa_city` VALUES (150100, '呼和浩特市', 2, 150000, ',150000,150100,');
INSERT INTO `oa_city` VALUES (150102, '新城区', 3, 150100, ',150000,150100,150102,');
INSERT INTO `oa_city` VALUES (150103, '回民区', 3, 150100, ',150000,150100,150103,');
INSERT INTO `oa_city` VALUES (150104, '玉泉区', 3, 150100, ',150000,150100,150104,');
INSERT INTO `oa_city` VALUES (150105, '赛罕区', 3, 150100, ',150000,150100,150105,');
INSERT INTO `oa_city` VALUES (150121, '土默特左旗', 3, 150100, ',150000,150100,150121,');
INSERT INTO `oa_city` VALUES (150122, '托克托县', 3, 150100, ',150000,150100,150122,');
INSERT INTO `oa_city` VALUES (150123, '和林格尔县', 3, 150100, ',150000,150100,150123,');
INSERT INTO `oa_city` VALUES (150124, '清水河县', 3, 150100, ',150000,150100,150124,');
INSERT INTO `oa_city` VALUES (150125, '武川县', 3, 150100, ',150000,150100,150125,');
INSERT INTO `oa_city` VALUES (150200, '包头市', 2, 150000, ',150000,150200,');
INSERT INTO `oa_city` VALUES (150202, '东河区', 3, 150200, ',150000,150200,150202,');
INSERT INTO `oa_city` VALUES (150203, '昆都仑区', 3, 150200, ',150000,150200,150203,');
INSERT INTO `oa_city` VALUES (150204, '青山区', 3, 150200, ',150000,150200,150204,');
INSERT INTO `oa_city` VALUES (150205, '石拐区', 3, 150200, ',150000,150200,150205,');
INSERT INTO `oa_city` VALUES (150206, '白云矿区', 3, 150200, ',150000,150200,150206,');
INSERT INTO `oa_city` VALUES (150207, '九原区', 3, 150200, ',150000,150200,150207,');
INSERT INTO `oa_city` VALUES (150221, '土默特右旗', 3, 150200, ',150000,150200,150221,');
INSERT INTO `oa_city` VALUES (150222, '固阳县', 3, 150200, ',150000,150200,150222,');
INSERT INTO `oa_city` VALUES (150223, '达尔罕茂明安联合旗', 3, 150200, ',150000,150200,150223,');
INSERT INTO `oa_city` VALUES (150300, '乌海市', 2, 150000, ',150000,150300,');
INSERT INTO `oa_city` VALUES (150302, '海勃湾区', 3, 150300, ',150000,150300,150302,');
INSERT INTO `oa_city` VALUES (150303, '海南区', 3, 150300, ',150000,150300,150303,');
INSERT INTO `oa_city` VALUES (150304, '乌达区', 3, 150300, ',150000,150300,150304,');
INSERT INTO `oa_city` VALUES (150400, '赤峰市', 2, 150000, ',150000,150400,');
INSERT INTO `oa_city` VALUES (150402, '红山区', 3, 150400, ',150000,150400,150402,');
INSERT INTO `oa_city` VALUES (150403, '元宝山区', 3, 150400, ',150000,150400,150403,');
INSERT INTO `oa_city` VALUES (150404, '松山区', 3, 150400, ',150000,150400,150404,');
INSERT INTO `oa_city` VALUES (150421, '阿鲁科尔沁旗', 3, 150400, ',150000,150400,150421,');
INSERT INTO `oa_city` VALUES (150422, '巴林左旗', 3, 150400, ',150000,150400,150422,');
INSERT INTO `oa_city` VALUES (150423, '巴林右旗', 3, 150400, ',150000,150400,150423,');
INSERT INTO `oa_city` VALUES (150424, '林西县', 3, 150400, ',150000,150400,150424,');
INSERT INTO `oa_city` VALUES (150425, '克什克腾旗', 3, 150400, ',150000,150400,150425,');
INSERT INTO `oa_city` VALUES (150426, '翁牛特旗', 3, 150400, ',150000,150400,150426,');
INSERT INTO `oa_city` VALUES (150428, '喀喇沁旗', 3, 150400, ',150000,150400,150428,');
INSERT INTO `oa_city` VALUES (150429, '宁城县', 3, 150400, ',150000,150400,150429,');
INSERT INTO `oa_city` VALUES (150430, '敖汉旗', 3, 150400, ',150000,150400,150430,');
INSERT INTO `oa_city` VALUES (150500, '通辽市', 2, 150000, ',150000,150500,');
INSERT INTO `oa_city` VALUES (150502, '科尔沁区', 3, 150500, ',150000,150500,150502,');
INSERT INTO `oa_city` VALUES (150521, '科尔沁左翼中旗', 3, 150500, ',150000,150500,150521,');
INSERT INTO `oa_city` VALUES (150522, '科尔沁左翼后旗', 3, 150500, ',150000,150500,150522,');
INSERT INTO `oa_city` VALUES (150523, '开鲁县', 3, 150500, ',150000,150500,150523,');
INSERT INTO `oa_city` VALUES (150524, '库伦旗', 3, 150500, ',150000,150500,150524,');
INSERT INTO `oa_city` VALUES (150525, '奈曼旗', 3, 150500, ',150000,150500,150525,');
INSERT INTO `oa_city` VALUES (150526, '扎鲁特旗', 3, 150500, ',150000,150500,150526,');
INSERT INTO `oa_city` VALUES (150581, '霍林郭勒市', 3, 150500, ',150000,150500,150581,');
INSERT INTO `oa_city` VALUES (150600, '鄂尔多斯市', 2, 150000, ',150000,150600,');
INSERT INTO `oa_city` VALUES (150602, '东胜区', 3, 150600, ',150000,150600,150602,');
INSERT INTO `oa_city` VALUES (150621, '达拉特旗', 3, 150600, ',150000,150600,150621,');
INSERT INTO `oa_city` VALUES (150622, '准格尔旗', 3, 150600, ',150000,150600,150622,');
INSERT INTO `oa_city` VALUES (150623, '鄂托克前旗', 3, 150600, ',150000,150600,150623,');
INSERT INTO `oa_city` VALUES (150624, '鄂托克旗', 3, 150600, ',150000,150600,150624,');
INSERT INTO `oa_city` VALUES (150625, '杭锦旗', 3, 150600, ',150000,150600,150625,');
INSERT INTO `oa_city` VALUES (150626, '乌审旗', 3, 150600, ',150000,150600,150626,');
INSERT INTO `oa_city` VALUES (150627, '伊金霍洛旗', 3, 150600, ',150000,150600,150627,');
INSERT INTO `oa_city` VALUES (150700, '呼伦贝尔市', 2, 150000, ',150000,150700,');
INSERT INTO `oa_city` VALUES (150702, '海拉尔区', 3, 150700, ',150000,150700,150702,');
INSERT INTO `oa_city` VALUES (150721, '阿荣旗', 3, 150700, ',150000,150700,150721,');
INSERT INTO `oa_city` VALUES (150722, '莫力达瓦达斡尔族自治旗', 3, 150700, ',150000,150700,150722,');
INSERT INTO `oa_city` VALUES (150723, '鄂伦春自治旗', 3, 150700, ',150000,150700,150723,');
INSERT INTO `oa_city` VALUES (150724, '鄂温克族自治旗', 3, 150700, ',150000,150700,150724,');
INSERT INTO `oa_city` VALUES (150725, '陈巴尔虎旗', 3, 150700, ',150000,150700,150725,');
INSERT INTO `oa_city` VALUES (150726, '新巴尔虎左旗', 3, 150700, ',150000,150700,150726,');
INSERT INTO `oa_city` VALUES (150727, '新巴尔虎右旗', 3, 150700, ',150000,150700,150727,');
INSERT INTO `oa_city` VALUES (150781, '满洲里市', 3, 150700, ',150000,150700,150781,');
INSERT INTO `oa_city` VALUES (150782, '牙克石市', 3, 150700, ',150000,150700,150782,');
INSERT INTO `oa_city` VALUES (150783, '扎兰屯市', 3, 150700, ',150000,150700,150783,');
INSERT INTO `oa_city` VALUES (150784, '额尔古纳市', 3, 150700, ',150000,150700,150784,');
INSERT INTO `oa_city` VALUES (150785, '根河市', 3, 150700, ',150000,150700,150785,');
INSERT INTO `oa_city` VALUES (150800, '巴彦淖尔市', 2, 150000, ',150000,150800,');
INSERT INTO `oa_city` VALUES (150802, '临河区', 3, 150800, ',150000,150800,150802,');
INSERT INTO `oa_city` VALUES (150821, '五原县', 3, 150800, ',150000,150800,150821,');
INSERT INTO `oa_city` VALUES (150822, '磴口县', 3, 150800, ',150000,150800,150822,');
INSERT INTO `oa_city` VALUES (150823, '乌拉特前旗', 3, 150800, ',150000,150800,150823,');
INSERT INTO `oa_city` VALUES (150824, '乌拉特中旗', 3, 150800, ',150000,150800,150824,');
INSERT INTO `oa_city` VALUES (150825, '乌拉特后旗', 3, 150800, ',150000,150800,150825,');
INSERT INTO `oa_city` VALUES (150826, '杭锦后旗', 3, 150800, ',150000,150800,150826,');
INSERT INTO `oa_city` VALUES (150900, '乌兰察布市', 2, 150000, ',150000,150900,');
INSERT INTO `oa_city` VALUES (150902, '集宁区', 3, 150900, ',150000,150900,150902,');
INSERT INTO `oa_city` VALUES (150921, '卓资县', 3, 150900, ',150000,150900,150921,');
INSERT INTO `oa_city` VALUES (150922, '化德县', 3, 150900, ',150000,150900,150922,');
INSERT INTO `oa_city` VALUES (150923, '商都县', 3, 150900, ',150000,150900,150923,');
INSERT INTO `oa_city` VALUES (150924, '兴和县', 3, 150900, ',150000,150900,150924,');
INSERT INTO `oa_city` VALUES (150925, '凉城县', 3, 150900, ',150000,150900,150925,');
INSERT INTO `oa_city` VALUES (150926, '察哈尔右翼前旗', 3, 150900, ',150000,150900,150926,');
INSERT INTO `oa_city` VALUES (150927, '察哈尔右翼中旗', 3, 150900, ',150000,150900,150927,');
INSERT INTO `oa_city` VALUES (150928, '察哈尔右翼后旗', 3, 150900, ',150000,150900,150928,');
INSERT INTO `oa_city` VALUES (150929, '四子王旗', 3, 150900, ',150000,150900,150929,');
INSERT INTO `oa_city` VALUES (150981, '丰镇市', 3, 150900, ',150000,150900,150981,');
INSERT INTO `oa_city` VALUES (152200, '兴安盟', 2, 150000, ',150000,152200,');
INSERT INTO `oa_city` VALUES (152201, '乌兰浩特市', 3, 152200, ',150000,152200,152201,');
INSERT INTO `oa_city` VALUES (152202, '阿尔山市', 3, 152200, ',150000,152200,152202,');
INSERT INTO `oa_city` VALUES (152221, '科尔沁右翼前旗', 3, 152200, ',150000,152200,152221,');
INSERT INTO `oa_city` VALUES (152222, '科尔沁右翼中旗', 3, 152200, ',150000,152200,152222,');
INSERT INTO `oa_city` VALUES (152223, '扎赉特旗', 3, 152200, ',150000,152200,152223,');
INSERT INTO `oa_city` VALUES (152224, '突泉县', 3, 152200, ',150000,152200,152224,');
INSERT INTO `oa_city` VALUES (152500, '锡林郭勒盟', 2, 150000, ',150000,152500,');
INSERT INTO `oa_city` VALUES (152501, '二连浩特市', 3, 152500, ',150000,152500,152501,');
INSERT INTO `oa_city` VALUES (152502, '锡林浩特市', 3, 152500, ',150000,152500,152502,');
INSERT INTO `oa_city` VALUES (152522, '阿巴嘎旗', 3, 152500, ',150000,152500,152522,');
INSERT INTO `oa_city` VALUES (152523, '苏尼特左旗', 3, 152500, ',150000,152500,152523,');
INSERT INTO `oa_city` VALUES (152524, '苏尼特右旗', 3, 152500, ',150000,152500,152524,');
INSERT INTO `oa_city` VALUES (152525, '东乌珠穆沁旗', 3, 152500, ',150000,152500,152525,');
INSERT INTO `oa_city` VALUES (152526, '西乌珠穆沁旗', 3, 152500, ',150000,152500,152526,');
INSERT INTO `oa_city` VALUES (152527, '太仆寺旗', 3, 152500, ',150000,152500,152527,');
INSERT INTO `oa_city` VALUES (152528, '镶黄旗', 3, 152500, ',150000,152500,152528,');
INSERT INTO `oa_city` VALUES (152529, '正镶白旗', 3, 152500, ',150000,152500,152529,');
INSERT INTO `oa_city` VALUES (152530, '正蓝旗', 3, 152500, ',150000,152500,152530,');
INSERT INTO `oa_city` VALUES (152531, '多伦县', 3, 152500, ',150000,152500,152531,');
INSERT INTO `oa_city` VALUES (152900, '阿拉善盟', 2, 150000, ',150000,152900,');
INSERT INTO `oa_city` VALUES (152921, '阿拉善左旗', 3, 152900, ',150000,152900,152921,');
INSERT INTO `oa_city` VALUES (152922, '阿拉善右旗', 3, 152900, ',150000,152900,152922,');
INSERT INTO `oa_city` VALUES (152923, '额济纳旗', 3, 152900, ',150000,152900,152923,');
INSERT INTO `oa_city` VALUES (210000, '辽宁省', 1, 0, ',210000,');
INSERT INTO `oa_city` VALUES (210100, '沈阳市', 2, 210000, ',210000,210100,');
INSERT INTO `oa_city` VALUES (210102, '和平区', 3, 210100, ',210000,210100,210102,');
INSERT INTO `oa_city` VALUES (210103, '沈河区', 3, 210100, ',210000,210100,210103,');
INSERT INTO `oa_city` VALUES (210104, '大东区', 3, 210100, ',210000,210100,210104,');
INSERT INTO `oa_city` VALUES (210105, '皇姑区', 3, 210100, ',210000,210100,210105,');
INSERT INTO `oa_city` VALUES (210106, '铁西区', 3, 210100, ',210000,210100,210106,');
INSERT INTO `oa_city` VALUES (210111, '苏家屯区', 3, 210100, ',210000,210100,210111,');
INSERT INTO `oa_city` VALUES (210112, '东陵区', 3, 210100, ',210000,210100,210112,');
INSERT INTO `oa_city` VALUES (210113, '新城子区', 3, 210100, ',210000,210100,210113,');
INSERT INTO `oa_city` VALUES (210114, '于洪区', 3, 210100, ',210000,210100,210114,');
INSERT INTO `oa_city` VALUES (210122, '辽中县', 3, 210100, ',210000,210100,210122,');
INSERT INTO `oa_city` VALUES (210123, '康平县', 3, 210100, ',210000,210100,210123,');
INSERT INTO `oa_city` VALUES (210124, '法库县', 3, 210100, ',210000,210100,210124,');
INSERT INTO `oa_city` VALUES (210181, '新民市', 3, 210100, ',210000,210100,210181,');
INSERT INTO `oa_city` VALUES (210200, '大连市', 2, 210000, ',210000,210200,');
INSERT INTO `oa_city` VALUES (210202, '中山区', 3, 210200, ',210000,210200,210202,');
INSERT INTO `oa_city` VALUES (210203, '西岗区', 3, 210200, ',210000,210200,210203,');
INSERT INTO `oa_city` VALUES (210204, '沙河口区', 3, 210200, ',210000,210200,210204,');
INSERT INTO `oa_city` VALUES (210211, '甘井子区', 3, 210200, ',210000,210200,210211,');
INSERT INTO `oa_city` VALUES (210212, '旅顺口区', 3, 210200, ',210000,210200,210212,');
INSERT INTO `oa_city` VALUES (210213, '金州区', 3, 210200, ',210000,210200,210213,');
INSERT INTO `oa_city` VALUES (210224, '长海县', 3, 210200, ',210000,210200,210224,');
INSERT INTO `oa_city` VALUES (210281, '瓦房店市', 3, 210200, ',210000,210200,210281,');
INSERT INTO `oa_city` VALUES (210282, '普兰店市', 3, 210200, ',210000,210200,210282,');
INSERT INTO `oa_city` VALUES (210283, '庄河市', 3, 210200, ',210000,210200,210283,');
INSERT INTO `oa_city` VALUES (210300, '鞍山市', 2, 210000, ',210000,210300,');
INSERT INTO `oa_city` VALUES (210302, '铁东区', 3, 210300, ',210000,210300,210302,');
INSERT INTO `oa_city` VALUES (210303, '铁西区', 3, 210300, ',210000,210300,210303,');
INSERT INTO `oa_city` VALUES (210304, '立山区', 3, 210300, ',210000,210300,210304,');
INSERT INTO `oa_city` VALUES (210311, '千山区', 3, 210300, ',210000,210300,210311,');
INSERT INTO `oa_city` VALUES (210321, '台安县', 3, 210300, ',210000,210300,210321,');
INSERT INTO `oa_city` VALUES (210323, '岫岩满族自治县', 3, 210300, ',210000,210300,210323,');
INSERT INTO `oa_city` VALUES (210381, '海城市', 3, 210300, ',210000,210300,210381,');
INSERT INTO `oa_city` VALUES (210400, '抚顺市', 2, 210000, ',210000,210400,');
INSERT INTO `oa_city` VALUES (210402, '新抚区', 3, 210400, ',210000,210400,210402,');
INSERT INTO `oa_city` VALUES (210403, '东洲区', 3, 210400, ',210000,210400,210403,');
INSERT INTO `oa_city` VALUES (210404, '望花区', 3, 210400, ',210000,210400,210404,');
INSERT INTO `oa_city` VALUES (210411, '顺城区', 3, 210400, ',210000,210400,210411,');
INSERT INTO `oa_city` VALUES (210421, '抚顺县', 3, 210400, ',210000,210400,210421,');
INSERT INTO `oa_city` VALUES (210422, '新宾满族自治县', 3, 210400, ',210000,210400,210422,');
INSERT INTO `oa_city` VALUES (210423, '清原满族自治县', 3, 210400, ',210000,210400,210423,');
INSERT INTO `oa_city` VALUES (210500, '本溪市', 2, 210000, ',210000,210500,');
INSERT INTO `oa_city` VALUES (210502, '平山区', 3, 210500, ',210000,210500,210502,');
INSERT INTO `oa_city` VALUES (210503, '溪湖区', 3, 210500, ',210000,210500,210503,');
INSERT INTO `oa_city` VALUES (210504, '明山区', 3, 210500, ',210000,210500,210504,');
INSERT INTO `oa_city` VALUES (210505, '南芬区', 3, 210500, ',210000,210500,210505,');
INSERT INTO `oa_city` VALUES (210521, '本溪满族自治县', 3, 210500, ',210000,210500,210521,');
INSERT INTO `oa_city` VALUES (210522, '桓仁满族自治县', 3, 210500, ',210000,210500,210522,');
INSERT INTO `oa_city` VALUES (210600, '丹东市', 2, 210000, ',210000,210600,');
INSERT INTO `oa_city` VALUES (210602, '元宝区', 3, 210600, ',210000,210600,210602,');
INSERT INTO `oa_city` VALUES (210603, '振兴区', 3, 210600, ',210000,210600,210603,');
INSERT INTO `oa_city` VALUES (210604, '振安区', 3, 210600, ',210000,210600,210604,');
INSERT INTO `oa_city` VALUES (210624, '宽甸满族自治县', 3, 210600, ',210000,210600,210624,');
INSERT INTO `oa_city` VALUES (210681, '东港市', 3, 210600, ',210000,210600,210681,');
INSERT INTO `oa_city` VALUES (210682, '凤城市', 3, 210600, ',210000,210600,210682,');
INSERT INTO `oa_city` VALUES (210700, '锦州市', 2, 210000, ',210000,210700,');
INSERT INTO `oa_city` VALUES (210702, '古塔区', 3, 210700, ',210000,210700,210702,');
INSERT INTO `oa_city` VALUES (210703, '凌河区', 3, 210700, ',210000,210700,210703,');
INSERT INTO `oa_city` VALUES (210711, '太和区', 3, 210700, ',210000,210700,210711,');
INSERT INTO `oa_city` VALUES (210726, '黑山县', 3, 210700, ',210000,210700,210726,');
INSERT INTO `oa_city` VALUES (210727, '义　县', 3, 210700, ',210000,210700,210727,');
INSERT INTO `oa_city` VALUES (210781, '凌海市', 3, 210700, ',210000,210700,210781,');
INSERT INTO `oa_city` VALUES (210782, '北宁市', 3, 210700, ',210000,210700,210782,');
INSERT INTO `oa_city` VALUES (210800, '营口市', 2, 210000, ',210000,210800,');
INSERT INTO `oa_city` VALUES (210802, '站前区', 3, 210800, ',210000,210800,210802,');
INSERT INTO `oa_city` VALUES (210803, '西市区', 3, 210800, ',210000,210800,210803,');
INSERT INTO `oa_city` VALUES (210804, '鲅鱼圈区', 3, 210800, ',210000,210800,210804,');
INSERT INTO `oa_city` VALUES (210811, '老边区', 3, 210800, ',210000,210800,210811,');
INSERT INTO `oa_city` VALUES (210881, '盖州市', 3, 210800, ',210000,210800,210881,');
INSERT INTO `oa_city` VALUES (210882, '大石桥市', 3, 210800, ',210000,210800,210882,');
INSERT INTO `oa_city` VALUES (210900, '阜新市', 2, 210000, ',210000,210900,');
INSERT INTO `oa_city` VALUES (210902, '海州区', 3, 210900, ',210000,210900,210902,');
INSERT INTO `oa_city` VALUES (210903, '新邱区', 3, 210900, ',210000,210900,210903,');
INSERT INTO `oa_city` VALUES (210904, '太平区', 3, 210900, ',210000,210900,210904,');
INSERT INTO `oa_city` VALUES (210905, '清河门区', 3, 210900, ',210000,210900,210905,');
INSERT INTO `oa_city` VALUES (210911, '细河区', 3, 210900, ',210000,210900,210911,');
INSERT INTO `oa_city` VALUES (210921, '阜新蒙古族自治县', 3, 210900, ',210000,210900,210921,');
INSERT INTO `oa_city` VALUES (210922, '彰武县', 3, 210900, ',210000,210900,210922,');
INSERT INTO `oa_city` VALUES (211000, '辽阳市', 2, 210000, ',210000,211000,');
INSERT INTO `oa_city` VALUES (211002, '白塔区', 3, 211000, ',210000,211000,211002,');
INSERT INTO `oa_city` VALUES (211003, '文圣区', 3, 211000, ',210000,211000,211003,');
INSERT INTO `oa_city` VALUES (211004, '宏伟区', 3, 211000, ',210000,211000,211004,');
INSERT INTO `oa_city` VALUES (211005, '弓长岭区', 3, 211000, ',210000,211000,211005,');
INSERT INTO `oa_city` VALUES (211011, '太子河区', 3, 211000, ',210000,211000,211011,');
INSERT INTO `oa_city` VALUES (211021, '辽阳县', 3, 211000, ',210000,211000,211021,');
INSERT INTO `oa_city` VALUES (211081, '灯塔市', 3, 211000, ',210000,211000,211081,');
INSERT INTO `oa_city` VALUES (211100, '盘锦市', 2, 210000, ',210000,211100,');
INSERT INTO `oa_city` VALUES (211102, '双台子区', 3, 211100, ',210000,211100,211102,');
INSERT INTO `oa_city` VALUES (211103, '兴隆台区', 3, 211100, ',210000,211100,211103,');
INSERT INTO `oa_city` VALUES (211121, '大洼县', 3, 211100, ',210000,211100,211121,');
INSERT INTO `oa_city` VALUES (211122, '盘山县', 3, 211100, ',210000,211100,211122,');
INSERT INTO `oa_city` VALUES (211200, '铁岭市', 2, 210000, ',210000,211200,');
INSERT INTO `oa_city` VALUES (211202, '银州区', 3, 211200, ',210000,211200,211202,');
INSERT INTO `oa_city` VALUES (211204, '清河区', 3, 211200, ',210000,211200,211204,');
INSERT INTO `oa_city` VALUES (211221, '铁岭县', 3, 211200, ',210000,211200,211221,');
INSERT INTO `oa_city` VALUES (211223, '西丰县', 3, 211200, ',210000,211200,211223,');
INSERT INTO `oa_city` VALUES (211224, '昌图县', 3, 211200, ',210000,211200,211224,');
INSERT INTO `oa_city` VALUES (211281, '调兵山市', 3, 211200, ',210000,211200,211281,');
INSERT INTO `oa_city` VALUES (211282, '开原市', 3, 211200, ',210000,211200,211282,');
INSERT INTO `oa_city` VALUES (211300, '朝阳市', 2, 210000, ',210000,211300,');
INSERT INTO `oa_city` VALUES (211302, '双塔区', 3, 211300, ',210000,211300,211302,');
INSERT INTO `oa_city` VALUES (211303, '龙城区', 3, 211300, ',210000,211300,211303,');
INSERT INTO `oa_city` VALUES (211321, '朝阳县', 3, 211300, ',210000,211300,211321,');
INSERT INTO `oa_city` VALUES (211322, '建平县', 3, 211300, ',210000,211300,211322,');
INSERT INTO `oa_city` VALUES (211324, '喀喇沁左翼蒙古族自治县', 3, 211300, ',210000,211300,211324,');
INSERT INTO `oa_city` VALUES (211381, '北票市', 3, 211300, ',210000,211300,211381,');
INSERT INTO `oa_city` VALUES (211382, '凌源市', 3, 211300, ',210000,211300,211382,');
INSERT INTO `oa_city` VALUES (211400, '葫芦岛市', 2, 210000, ',210000,211400,');
INSERT INTO `oa_city` VALUES (211402, '连山区', 3, 211400, ',210000,211400,211402,');
INSERT INTO `oa_city` VALUES (211403, '龙港区', 3, 211400, ',210000,211400,211403,');
INSERT INTO `oa_city` VALUES (211404, '南票区', 3, 211400, ',210000,211400,211404,');
INSERT INTO `oa_city` VALUES (211421, '绥中县', 3, 211400, ',210000,211400,211421,');
INSERT INTO `oa_city` VALUES (211422, '建昌县', 3, 211400, ',210000,211400,211422,');
INSERT INTO `oa_city` VALUES (211481, '兴城市', 3, 211400, ',210000,211400,211481,');
INSERT INTO `oa_city` VALUES (220000, '吉林省', 1, 0, ',220000,');
INSERT INTO `oa_city` VALUES (220100, '长春市', 2, 220000, ',220000,220100,');
INSERT INTO `oa_city` VALUES (220102, '南关区', 3, 220100, ',220000,220100,220102,');
INSERT INTO `oa_city` VALUES (220103, '宽城区', 3, 220100, ',220000,220100,220103,');
INSERT INTO `oa_city` VALUES (220104, '朝阳区', 3, 220100, ',220000,220100,220104,');
INSERT INTO `oa_city` VALUES (220105, '二道区', 3, 220100, ',220000,220100,220105,');
INSERT INTO `oa_city` VALUES (220106, '绿园区', 3, 220100, ',220000,220100,220106,');
INSERT INTO `oa_city` VALUES (220112, '双阳区', 3, 220100, ',220000,220100,220112,');
INSERT INTO `oa_city` VALUES (220122, '农安县', 3, 220100, ',220000,220100,220122,');
INSERT INTO `oa_city` VALUES (220181, '九台市', 3, 220100, ',220000,220100,220181,');
INSERT INTO `oa_city` VALUES (220182, '榆树市', 3, 220100, ',220000,220100,220182,');
INSERT INTO `oa_city` VALUES (220183, '德惠市', 3, 220100, ',220000,220100,220183,');
INSERT INTO `oa_city` VALUES (220200, '吉林市', 2, 220000, ',220000,220200,');
INSERT INTO `oa_city` VALUES (220202, '昌邑区', 3, 220200, ',220000,220200,220202,');
INSERT INTO `oa_city` VALUES (220203, '龙潭区', 3, 220200, ',220000,220200,220203,');
INSERT INTO `oa_city` VALUES (220204, '船营区', 3, 220200, ',220000,220200,220204,');
INSERT INTO `oa_city` VALUES (220211, '丰满区', 3, 220200, ',220000,220200,220211,');
INSERT INTO `oa_city` VALUES (220221, '永吉县', 3, 220200, ',220000,220200,220221,');
INSERT INTO `oa_city` VALUES (220281, '蛟河市', 3, 220200, ',220000,220200,220281,');
INSERT INTO `oa_city` VALUES (220282, '桦甸市', 3, 220200, ',220000,220200,220282,');
INSERT INTO `oa_city` VALUES (220283, '舒兰市', 3, 220200, ',220000,220200,220283,');
INSERT INTO `oa_city` VALUES (220284, '磐石市', 3, 220200, ',220000,220200,220284,');
INSERT INTO `oa_city` VALUES (220300, '四平市', 2, 220000, ',220000,220300,');
INSERT INTO `oa_city` VALUES (220302, '铁西区', 3, 220300, ',220000,220300,220302,');
INSERT INTO `oa_city` VALUES (220303, '铁东区', 3, 220300, ',220000,220300,220303,');
INSERT INTO `oa_city` VALUES (220322, '梨树县', 3, 220300, ',220000,220300,220322,');
INSERT INTO `oa_city` VALUES (220323, '伊通满族自治县', 3, 220300, ',220000,220300,220323,');
INSERT INTO `oa_city` VALUES (220381, '公主岭市', 3, 220300, ',220000,220300,220381,');
INSERT INTO `oa_city` VALUES (220382, '双辽市', 3, 220300, ',220000,220300,220382,');
INSERT INTO `oa_city` VALUES (220400, '辽源市', 2, 220000, ',220000,220400,');
INSERT INTO `oa_city` VALUES (220402, '龙山区', 3, 220400, ',220000,220400,220402,');
INSERT INTO `oa_city` VALUES (220403, '西安区', 3, 220400, ',220000,220400,220403,');
INSERT INTO `oa_city` VALUES (220421, '东丰县', 3, 220400, ',220000,220400,220421,');
INSERT INTO `oa_city` VALUES (220422, '东辽县', 3, 220400, ',220000,220400,220422,');
INSERT INTO `oa_city` VALUES (220500, '通化市', 2, 220000, ',220000,220500,');
INSERT INTO `oa_city` VALUES (220502, '东昌区', 3, 220500, ',220000,220500,220502,');
INSERT INTO `oa_city` VALUES (220503, '二道江区', 3, 220500, ',220000,220500,220503,');
INSERT INTO `oa_city` VALUES (220521, '通化县', 3, 220500, ',220000,220500,220521,');
INSERT INTO `oa_city` VALUES (220523, '辉南县', 3, 220500, ',220000,220500,220523,');
INSERT INTO `oa_city` VALUES (220524, '柳河县', 3, 220500, ',220000,220500,220524,');
INSERT INTO `oa_city` VALUES (220581, '梅河口市', 3, 220500, ',220000,220500,220581,');
INSERT INTO `oa_city` VALUES (220582, '集安市', 3, 220500, ',220000,220500,220582,');
INSERT INTO `oa_city` VALUES (220600, '白山市', 2, 220000, ',220000,220600,');
INSERT INTO `oa_city` VALUES (220602, '八道江区', 3, 220600, ',220000,220600,220602,');
INSERT INTO `oa_city` VALUES (220621, '抚松县', 3, 220600, ',220000,220600,220621,');
INSERT INTO `oa_city` VALUES (220622, '靖宇县', 3, 220600, ',220000,220600,220622,');
INSERT INTO `oa_city` VALUES (220623, '长白朝鲜族自治县', 3, 220600, ',220000,220600,220623,');
INSERT INTO `oa_city` VALUES (220625, '江源县', 3, 220600, ',220000,220600,220625,');
INSERT INTO `oa_city` VALUES (220681, '临江市', 3, 220600, ',220000,220600,220681,');
INSERT INTO `oa_city` VALUES (220700, '松原市', 2, 220000, ',220000,220700,');
INSERT INTO `oa_city` VALUES (220702, '宁江区', 3, 220700, ',220000,220700,220702,');
INSERT INTO `oa_city` VALUES (220721, '前郭尔罗斯蒙古族自治县', 3, 220700, ',220000,220700,220721,');
INSERT INTO `oa_city` VALUES (220722, '长岭县', 3, 220700, ',220000,220700,220722,');
INSERT INTO `oa_city` VALUES (220723, '乾安县', 3, 220700, ',220000,220700,220723,');
INSERT INTO `oa_city` VALUES (220724, '扶余县', 3, 220700, ',220000,220700,220724,');
INSERT INTO `oa_city` VALUES (220800, '白城市', 2, 220000, ',220000,220800,');
INSERT INTO `oa_city` VALUES (220802, '洮北区', 3, 220800, ',220000,220800,220802,');
INSERT INTO `oa_city` VALUES (220821, '镇赉县', 3, 220800, ',220000,220800,220821,');
INSERT INTO `oa_city` VALUES (220822, '通榆县', 3, 220800, ',220000,220800,220822,');
INSERT INTO `oa_city` VALUES (220881, '洮南市', 3, 220800, ',220000,220800,220881,');
INSERT INTO `oa_city` VALUES (220882, '大安市', 3, 220800, ',220000,220800,220882,');
INSERT INTO `oa_city` VALUES (222400, '延边朝鲜族自治州', 2, 220000, ',220000,222400,');
INSERT INTO `oa_city` VALUES (222401, '延吉市', 3, 222400, ',220000,222400,222401,');
INSERT INTO `oa_city` VALUES (222402, '图们市', 3, 222400, ',220000,222400,222402,');
INSERT INTO `oa_city` VALUES (222403, '敦化市', 3, 222400, ',220000,222400,222403,');
INSERT INTO `oa_city` VALUES (222404, '珲春市', 3, 222400, ',220000,222400,222404,');
INSERT INTO `oa_city` VALUES (222405, '龙井市', 3, 222400, ',220000,222400,222405,');
INSERT INTO `oa_city` VALUES (222406, '和龙市', 3, 222400, ',220000,222400,222406,');
INSERT INTO `oa_city` VALUES (222424, '汪清县', 3, 222400, ',220000,222400,222424,');
INSERT INTO `oa_city` VALUES (222426, '安图县', 3, 222400, ',220000,222400,222426,');
INSERT INTO `oa_city` VALUES (230000, '黑龙江', 1, 0, ',230000,');
INSERT INTO `oa_city` VALUES (230100, '哈尔滨市', 2, 230000, ',230000,230100,');
INSERT INTO `oa_city` VALUES (230102, '道里区', 3, 230100, ',230000,230100,230102,');
INSERT INTO `oa_city` VALUES (230103, '南岗区', 3, 230100, ',230000,230100,230103,');
INSERT INTO `oa_city` VALUES (230104, '道外区', 3, 230100, ',230000,230100,230104,');
INSERT INTO `oa_city` VALUES (230106, '香坊区', 3, 230100, ',230000,230100,230106,');
INSERT INTO `oa_city` VALUES (230107, '动力区', 3, 230100, ',230000,230100,230107,');
INSERT INTO `oa_city` VALUES (230108, '平房区', 3, 230100, ',230000,230100,230108,');
INSERT INTO `oa_city` VALUES (230109, '松北区', 3, 230100, ',230000,230100,230109,');
INSERT INTO `oa_city` VALUES (230111, '呼兰区', 3, 230100, ',230000,230100,230111,');
INSERT INTO `oa_city` VALUES (230123, '依兰县', 3, 230100, ',230000,230100,230123,');
INSERT INTO `oa_city` VALUES (230124, '方正县', 3, 230100, ',230000,230100,230124,');
INSERT INTO `oa_city` VALUES (230125, '宾　县', 3, 230100, ',230000,230100,230125,');
INSERT INTO `oa_city` VALUES (230126, '巴彦县', 3, 230100, ',230000,230100,230126,');
INSERT INTO `oa_city` VALUES (230127, '木兰县', 3, 230100, ',230000,230100,230127,');
INSERT INTO `oa_city` VALUES (230128, '通河县', 3, 230100, ',230000,230100,230128,');
INSERT INTO `oa_city` VALUES (230129, '延寿县', 3, 230100, ',230000,230100,230129,');
INSERT INTO `oa_city` VALUES (230181, '阿城市', 3, 230100, ',230000,230100,230181,');
INSERT INTO `oa_city` VALUES (230182, '双城市', 3, 230100, ',230000,230100,230182,');
INSERT INTO `oa_city` VALUES (230183, '尚志市', 3, 230100, ',230000,230100,230183,');
INSERT INTO `oa_city` VALUES (230184, '五常市', 3, 230100, ',230000,230100,230184,');
INSERT INTO `oa_city` VALUES (230200, '齐齐哈尔市', 2, 230000, ',230000,230200,');
INSERT INTO `oa_city` VALUES (230202, '龙沙区', 3, 230200, ',230000,230200,230202,');
INSERT INTO `oa_city` VALUES (230203, '建华区', 3, 230200, ',230000,230200,230203,');
INSERT INTO `oa_city` VALUES (230204, '铁锋区', 3, 230200, ',230000,230200,230204,');
INSERT INTO `oa_city` VALUES (230205, '昂昂溪区', 3, 230200, ',230000,230200,230205,');
INSERT INTO `oa_city` VALUES (230206, '富拉尔基区', 3, 230200, ',230000,230200,230206,');
INSERT INTO `oa_city` VALUES (230207, '碾子山区', 3, 230200, ',230000,230200,230207,');
INSERT INTO `oa_city` VALUES (230208, '梅里斯达斡尔族区', 3, 230200, ',230000,230200,230208,');
INSERT INTO `oa_city` VALUES (230221, '龙江县', 3, 230200, ',230000,230200,230221,');
INSERT INTO `oa_city` VALUES (230223, '依安县', 3, 230200, ',230000,230200,230223,');
INSERT INTO `oa_city` VALUES (230224, '泰来县', 3, 230200, ',230000,230200,230224,');
INSERT INTO `oa_city` VALUES (230225, '甘南县', 3, 230200, ',230000,230200,230225,');
INSERT INTO `oa_city` VALUES (230227, '富裕县', 3, 230200, ',230000,230200,230227,');
INSERT INTO `oa_city` VALUES (230229, '克山县', 3, 230200, ',230000,230200,230229,');
INSERT INTO `oa_city` VALUES (230230, '克东县', 3, 230200, ',230000,230200,230230,');
INSERT INTO `oa_city` VALUES (230231, '拜泉县', 3, 230200, ',230000,230200,230231,');
INSERT INTO `oa_city` VALUES (230281, '讷河市', 3, 230200, ',230000,230200,230281,');
INSERT INTO `oa_city` VALUES (230300, '鸡西市', 2, 230000, ',230000,230300,');
INSERT INTO `oa_city` VALUES (230302, '鸡冠区', 3, 230300, ',230000,230300,230302,');
INSERT INTO `oa_city` VALUES (230303, '恒山区', 3, 230300, ',230000,230300,230303,');
INSERT INTO `oa_city` VALUES (230304, '滴道区', 3, 230300, ',230000,230300,230304,');
INSERT INTO `oa_city` VALUES (230305, '梨树区', 3, 230300, ',230000,230300,230305,');
INSERT INTO `oa_city` VALUES (230306, '城子河区', 3, 230300, ',230000,230300,230306,');
INSERT INTO `oa_city` VALUES (230307, '麻山区', 3, 230300, ',230000,230300,230307,');
INSERT INTO `oa_city` VALUES (230321, '鸡东县', 3, 230300, ',230000,230300,230321,');
INSERT INTO `oa_city` VALUES (230381, '虎林市', 3, 230300, ',230000,230300,230381,');
INSERT INTO `oa_city` VALUES (230382, '密山市', 3, 230300, ',230000,230300,230382,');
INSERT INTO `oa_city` VALUES (230400, '鹤岗市', 2, 230000, ',230000,230400,');
INSERT INTO `oa_city` VALUES (230402, '向阳区', 3, 230400, ',230000,230400,230402,');
INSERT INTO `oa_city` VALUES (230403, '工农区', 3, 230400, ',230000,230400,230403,');
INSERT INTO `oa_city` VALUES (230404, '南山区', 3, 230400, ',230000,230400,230404,');
INSERT INTO `oa_city` VALUES (230405, '兴安区', 3, 230400, ',230000,230400,230405,');
INSERT INTO `oa_city` VALUES (230406, '东山区', 3, 230400, ',230000,230400,230406,');
INSERT INTO `oa_city` VALUES (230407, '兴山区', 3, 230400, ',230000,230400,230407,');
INSERT INTO `oa_city` VALUES (230421, '萝北县', 3, 230400, ',230000,230400,230421,');
INSERT INTO `oa_city` VALUES (230422, '绥滨县', 3, 230400, ',230000,230400,230422,');
INSERT INTO `oa_city` VALUES (230500, '双鸭山市', 2, 230000, ',230000,230500,');
INSERT INTO `oa_city` VALUES (230502, '尖山区', 3, 230500, ',230000,230500,230502,');
INSERT INTO `oa_city` VALUES (230503, '岭东区', 3, 230500, ',230000,230500,230503,');
INSERT INTO `oa_city` VALUES (230505, '四方台区', 3, 230500, ',230000,230500,230505,');
INSERT INTO `oa_city` VALUES (230506, '宝山区', 3, 230500, ',230000,230500,230506,');
INSERT INTO `oa_city` VALUES (230521, '集贤县', 3, 230500, ',230000,230500,230521,');
INSERT INTO `oa_city` VALUES (230522, '友谊县', 3, 230500, ',230000,230500,230522,');
INSERT INTO `oa_city` VALUES (230523, '宝清县', 3, 230500, ',230000,230500,230523,');
INSERT INTO `oa_city` VALUES (230524, '饶河县', 3, 230500, ',230000,230500,230524,');
INSERT INTO `oa_city` VALUES (230600, '大庆市', 2, 230000, ',230000,230600,');
INSERT INTO `oa_city` VALUES (230602, '萨尔图区', 3, 230600, ',230000,230600,230602,');
INSERT INTO `oa_city` VALUES (230603, '龙凤区', 3, 230600, ',230000,230600,230603,');
INSERT INTO `oa_city` VALUES (230604, '让胡路区', 3, 230600, ',230000,230600,230604,');
INSERT INTO `oa_city` VALUES (230605, '红岗区', 3, 230600, ',230000,230600,230605,');
INSERT INTO `oa_city` VALUES (230606, '大同区', 3, 230600, ',230000,230600,230606,');
INSERT INTO `oa_city` VALUES (230621, '肇州县', 3, 230600, ',230000,230600,230621,');
INSERT INTO `oa_city` VALUES (230622, '肇源县', 3, 230600, ',230000,230600,230622,');
INSERT INTO `oa_city` VALUES (230623, '林甸县', 3, 230600, ',230000,230600,230623,');
INSERT INTO `oa_city` VALUES (230624, '杜尔伯特蒙古族自治县', 3, 230600, ',230000,230600,230624,');
INSERT INTO `oa_city` VALUES (230700, '伊春市', 2, 230000, ',230000,230700,');
INSERT INTO `oa_city` VALUES (230702, '伊春区', 3, 230700, ',230000,230700,230702,');
INSERT INTO `oa_city` VALUES (230703, '南岔区', 3, 230700, ',230000,230700,230703,');
INSERT INTO `oa_city` VALUES (230704, '友好区', 3, 230700, ',230000,230700,230704,');
INSERT INTO `oa_city` VALUES (230705, '西林区', 3, 230700, ',230000,230700,230705,');
INSERT INTO `oa_city` VALUES (230706, '翠峦区', 3, 230700, ',230000,230700,230706,');
INSERT INTO `oa_city` VALUES (230707, '新青区', 3, 230700, ',230000,230700,230707,');
INSERT INTO `oa_city` VALUES (230708, '美溪区', 3, 230700, ',230000,230700,230708,');
INSERT INTO `oa_city` VALUES (230709, '金山屯区', 3, 230700, ',230000,230700,230709,');
INSERT INTO `oa_city` VALUES (230710, '五营区', 3, 230700, ',230000,230700,230710,');
INSERT INTO `oa_city` VALUES (230711, '乌马河区', 3, 230700, ',230000,230700,230711,');
INSERT INTO `oa_city` VALUES (230712, '汤旺河区', 3, 230700, ',230000,230700,230712,');
INSERT INTO `oa_city` VALUES (230713, '带岭区', 3, 230700, ',230000,230700,230713,');
INSERT INTO `oa_city` VALUES (230714, '乌伊岭区', 3, 230700, ',230000,230700,230714,');
INSERT INTO `oa_city` VALUES (230715, '红星区', 3, 230700, ',230000,230700,230715,');
INSERT INTO `oa_city` VALUES (230716, '上甘岭区', 3, 230700, ',230000,230700,230716,');
INSERT INTO `oa_city` VALUES (230722, '嘉荫县', 3, 230700, ',230000,230700,230722,');
INSERT INTO `oa_city` VALUES (230781, '铁力市', 3, 230700, ',230000,230700,230781,');
INSERT INTO `oa_city` VALUES (230800, '佳木斯市', 2, 230000, ',230000,230800,');
INSERT INTO `oa_city` VALUES (230802, '永红区', 3, 230800, ',230000,230800,230802,');
INSERT INTO `oa_city` VALUES (230803, '向阳区', 3, 230800, ',230000,230800,230803,');
INSERT INTO `oa_city` VALUES (230804, '前进区', 3, 230800, ',230000,230800,230804,');
INSERT INTO `oa_city` VALUES (230805, '东风区', 3, 230800, ',230000,230800,230805,');
INSERT INTO `oa_city` VALUES (230811, '郊　区', 3, 230800, ',230000,230800,230811,');
INSERT INTO `oa_city` VALUES (230822, '桦南县', 3, 230800, ',230000,230800,230822,');
INSERT INTO `oa_city` VALUES (230826, '桦川县', 3, 230800, ',230000,230800,230826,');
INSERT INTO `oa_city` VALUES (230828, '汤原县', 3, 230800, ',230000,230800,230828,');
INSERT INTO `oa_city` VALUES (230833, '抚远县', 3, 230800, ',230000,230800,230833,');
INSERT INTO `oa_city` VALUES (230881, '同江市', 3, 230800, ',230000,230800,230881,');
INSERT INTO `oa_city` VALUES (230882, '富锦市', 3, 230800, ',230000,230800,230882,');
INSERT INTO `oa_city` VALUES (230900, '七台河市', 2, 230000, ',230000,230900,');
INSERT INTO `oa_city` VALUES (230902, '新兴区', 3, 230900, ',230000,230900,230902,');
INSERT INTO `oa_city` VALUES (230903, '桃山区', 3, 230900, ',230000,230900,230903,');
INSERT INTO `oa_city` VALUES (230904, '茄子河区', 3, 230900, ',230000,230900,230904,');
INSERT INTO `oa_city` VALUES (230921, '勃利县', 3, 230900, ',230000,230900,230921,');
INSERT INTO `oa_city` VALUES (231000, '牡丹江市', 2, 230000, ',230000,231000,');
INSERT INTO `oa_city` VALUES (231002, '东安区', 3, 231000, ',230000,231000,231002,');
INSERT INTO `oa_city` VALUES (231003, '阳明区', 3, 231000, ',230000,231000,231003,');
INSERT INTO `oa_city` VALUES (231004, '爱民区', 3, 231000, ',230000,231000,231004,');
INSERT INTO `oa_city` VALUES (231005, '西安区', 3, 231000, ',230000,231000,231005,');
INSERT INTO `oa_city` VALUES (231024, '东宁县', 3, 231000, ',230000,231000,231024,');
INSERT INTO `oa_city` VALUES (231025, '林口县', 3, 231000, ',230000,231000,231025,');
INSERT INTO `oa_city` VALUES (231081, '绥芬河市', 3, 231000, ',230000,231000,231081,');
INSERT INTO `oa_city` VALUES (231083, '海林市', 3, 231000, ',230000,231000,231083,');
INSERT INTO `oa_city` VALUES (231084, '宁安市', 3, 231000, ',230000,231000,231084,');
INSERT INTO `oa_city` VALUES (231085, '穆棱市', 3, 231000, ',230000,231000,231085,');
INSERT INTO `oa_city` VALUES (231100, '黑河市', 2, 230000, ',230000,231100,');
INSERT INTO `oa_city` VALUES (231102, '爱辉区', 3, 231100, ',230000,231100,231102,');
INSERT INTO `oa_city` VALUES (231121, '嫩江县', 3, 231100, ',230000,231100,231121,');
INSERT INTO `oa_city` VALUES (231123, '逊克县', 3, 231100, ',230000,231100,231123,');
INSERT INTO `oa_city` VALUES (231124, '孙吴县', 3, 231100, ',230000,231100,231124,');
INSERT INTO `oa_city` VALUES (231181, '北安市', 3, 231100, ',230000,231100,231181,');
INSERT INTO `oa_city` VALUES (231182, '五大连池市', 3, 231100, ',230000,231100,231182,');
INSERT INTO `oa_city` VALUES (231200, '绥化市', 2, 230000, ',230000,231200,');
INSERT INTO `oa_city` VALUES (231202, '北林区', 3, 231200, ',230000,231200,231202,');
INSERT INTO `oa_city` VALUES (231221, '望奎县', 3, 231200, ',230000,231200,231221,');
INSERT INTO `oa_city` VALUES (231222, '兰西县', 3, 231200, ',230000,231200,231222,');
INSERT INTO `oa_city` VALUES (231223, '青冈县', 3, 231200, ',230000,231200,231223,');
INSERT INTO `oa_city` VALUES (231224, '庆安县', 3, 231200, ',230000,231200,231224,');
INSERT INTO `oa_city` VALUES (231225, '明水县', 3, 231200, ',230000,231200,231225,');
INSERT INTO `oa_city` VALUES (231226, '绥棱县', 3, 231200, ',230000,231200,231226,');
INSERT INTO `oa_city` VALUES (231281, '安达市', 3, 231200, ',230000,231200,231281,');
INSERT INTO `oa_city` VALUES (231282, '肇东市', 3, 231200, ',230000,231200,231282,');
INSERT INTO `oa_city` VALUES (231283, '海伦市', 3, 231200, ',230000,231200,231283,');
INSERT INTO `oa_city` VALUES (232700, '大兴安岭地区', 2, 230000, ',230000,232700,');
INSERT INTO `oa_city` VALUES (232721, '呼玛县', 3, 232700, ',230000,232700,232721,');
INSERT INTO `oa_city` VALUES (232722, '塔河县', 3, 232700, ',230000,232700,232722,');
INSERT INTO `oa_city` VALUES (232723, '漠河县', 3, 232700, ',230000,232700,232723,');
INSERT INTO `oa_city` VALUES (310000, '上海市', 1, 0, ',310000,');
INSERT INTO `oa_city` VALUES (310101, '黄浦区', 2, 310000, ',310000,310101,');
INSERT INTO `oa_city` VALUES (310103, '卢湾区', 2, 310000, ',310000,310103,');
INSERT INTO `oa_city` VALUES (310104, '徐汇区', 2, 310000, ',310000,310104,');
INSERT INTO `oa_city` VALUES (310105, '长宁区', 2, 310000, ',310000,310105,');
INSERT INTO `oa_city` VALUES (310106, '静安区', 2, 310000, ',310000,310106,');
INSERT INTO `oa_city` VALUES (310107, '普陀区', 2, 310000, ',310000,310107,');
INSERT INTO `oa_city` VALUES (310108, '闸北区', 2, 310000, ',310000,310108,');
INSERT INTO `oa_city` VALUES (310109, '虹口区', 2, 310000, ',310000,310109,');
INSERT INTO `oa_city` VALUES (310110, '杨浦区', 2, 310000, ',310000,310110,');
INSERT INTO `oa_city` VALUES (310112, '闵行区', 2, 310000, ',310000,310112,');
INSERT INTO `oa_city` VALUES (310113, '宝山区', 2, 310000, ',310000,310113,');
INSERT INTO `oa_city` VALUES (310114, '嘉定区', 2, 310000, ',310000,310114,');
INSERT INTO `oa_city` VALUES (310115, '浦东新区', 2, 310000, ',310000,310115,');
INSERT INTO `oa_city` VALUES (310116, '金山区', 2, 310000, ',310000,310116,');
INSERT INTO `oa_city` VALUES (310117, '松江区', 2, 310000, ',310000,310117,');
INSERT INTO `oa_city` VALUES (310118, '青浦区', 2, 310000, ',310000,310118,');
INSERT INTO `oa_city` VALUES (310120, '奉贤区', 2, 310000, ',310000,310120,');
INSERT INTO `oa_city` VALUES (310230, '崇明县', 3, 310000, ',310000,310230,');
INSERT INTO `oa_city` VALUES (320000, '江苏省', 1, 0, ',320000,');
INSERT INTO `oa_city` VALUES (320100, '南京市', 2, 320000, ',320000,320100,');
INSERT INTO `oa_city` VALUES (320102, '玄武区', 3, 320100, ',320000,320100,320102,');
INSERT INTO `oa_city` VALUES (320103, '白下区', 3, 320100, ',320000,320100,320103,');
INSERT INTO `oa_city` VALUES (320104, '秦淮区', 3, 320100, ',320000,320100,320104,');
INSERT INTO `oa_city` VALUES (320105, '建邺区', 3, 320100, ',320000,320100,320105,');
INSERT INTO `oa_city` VALUES (320106, '鼓楼区', 3, 320100, ',320000,320100,320106,');
INSERT INTO `oa_city` VALUES (320107, '下关区', 3, 320100, ',320000,320100,320107,');
INSERT INTO `oa_city` VALUES (320111, '浦口区', 3, 320100, ',320000,320100,320111,');
INSERT INTO `oa_city` VALUES (320113, '栖霞区', 3, 320100, ',320000,320100,320113,');
INSERT INTO `oa_city` VALUES (320114, '雨花台区', 3, 320100, ',320000,320100,320114,');
INSERT INTO `oa_city` VALUES (320115, '江宁区', 3, 320100, ',320000,320100,320115,');
INSERT INTO `oa_city` VALUES (320116, '六合区', 3, 320100, ',320000,320100,320116,');
INSERT INTO `oa_city` VALUES (320124, '溧水县', 3, 320100, ',320000,320100,320124,');
INSERT INTO `oa_city` VALUES (320125, '高淳县', 3, 320100, ',320000,320100,320125,');
INSERT INTO `oa_city` VALUES (320200, '无锡市', 2, 320000, ',320000,320200,');
INSERT INTO `oa_city` VALUES (320202, '崇安区', 3, 320200, ',320000,320200,320202,');
INSERT INTO `oa_city` VALUES (320203, '南长区', 3, 320200, ',320000,320200,320203,');
INSERT INTO `oa_city` VALUES (320204, '北塘区', 3, 320200, ',320000,320200,320204,');
INSERT INTO `oa_city` VALUES (320205, '锡山区', 3, 320200, ',320000,320200,320205,');
INSERT INTO `oa_city` VALUES (320206, '惠山区', 3, 320200, ',320000,320200,320206,');
INSERT INTO `oa_city` VALUES (320211, '滨湖区', 3, 320200, ',320000,320200,320211,');
INSERT INTO `oa_city` VALUES (320281, '江阴市', 3, 320200, ',320000,320200,320281,');
INSERT INTO `oa_city` VALUES (320282, '宜兴市', 3, 320200, ',320000,320200,320282,');
INSERT INTO `oa_city` VALUES (320300, '徐州市', 2, 320000, ',320000,320300,');
INSERT INTO `oa_city` VALUES (320302, '鼓楼区', 3, 320300, ',320000,320300,320302,');
INSERT INTO `oa_city` VALUES (320303, '云龙区', 3, 320300, ',320000,320300,320303,');
INSERT INTO `oa_city` VALUES (320304, '九里区', 3, 320300, ',320000,320300,320304,');
INSERT INTO `oa_city` VALUES (320305, '贾汪区', 3, 320300, ',320000,320300,320305,');
INSERT INTO `oa_city` VALUES (320311, '泉山区', 3, 320300, ',320000,320300,320311,');
INSERT INTO `oa_city` VALUES (320321, '丰　县', 3, 320300, ',320000,320300,320321,');
INSERT INTO `oa_city` VALUES (320322, '沛　县', 3, 320300, ',320000,320300,320322,');
INSERT INTO `oa_city` VALUES (320323, '铜山县', 3, 320300, ',320000,320300,320323,');
INSERT INTO `oa_city` VALUES (320324, '睢宁县', 3, 320300, ',320000,320300,320324,');
INSERT INTO `oa_city` VALUES (320381, '新沂市', 3, 320300, ',320000,320300,320381,');
INSERT INTO `oa_city` VALUES (320382, '邳州市', 3, 320300, ',320000,320300,320382,');
INSERT INTO `oa_city` VALUES (320400, '常州市', 2, 320000, ',320000,320400,');
INSERT INTO `oa_city` VALUES (320402, '天宁区', 3, 320400, ',320000,320400,320402,');
INSERT INTO `oa_city` VALUES (320404, '钟楼区', 3, 320400, ',320000,320400,320404,');
INSERT INTO `oa_city` VALUES (320405, '戚墅堰区', 3, 320400, ',320000,320400,320405,');
INSERT INTO `oa_city` VALUES (320411, '新北区', 3, 320400, ',320000,320400,320411,');
INSERT INTO `oa_city` VALUES (320412, '武进区', 3, 320400, ',320000,320400,320412,');
INSERT INTO `oa_city` VALUES (320481, '溧阳市', 3, 320400, ',320000,320400,320481,');
INSERT INTO `oa_city` VALUES (320482, '金坛市', 3, 320400, ',320000,320400,320482,');
INSERT INTO `oa_city` VALUES (320500, '苏州市', 2, 320000, ',320000,320500,');
INSERT INTO `oa_city` VALUES (320502, '沧浪区', 3, 320500, ',320000,320500,320502,');
INSERT INTO `oa_city` VALUES (320503, '平江区', 3, 320500, ',320000,320500,320503,');
INSERT INTO `oa_city` VALUES (320504, '金阊区', 3, 320500, ',320000,320500,320504,');
INSERT INTO `oa_city` VALUES (320505, '虎丘区', 3, 320500, ',320000,320500,320505,');
INSERT INTO `oa_city` VALUES (320506, '吴中区', 3, 320500, ',320000,320500,320506,');
INSERT INTO `oa_city` VALUES (320507, '相城区', 3, 320500, ',320000,320500,320507,');
INSERT INTO `oa_city` VALUES (320581, '常熟市', 3, 320500, ',320000,320500,320581,');
INSERT INTO `oa_city` VALUES (320582, '张家港市', 3, 320500, ',320000,320500,320582,');
INSERT INTO `oa_city` VALUES (320583, '昆山市', 3, 320500, ',320000,320500,320583,');
INSERT INTO `oa_city` VALUES (320584, '吴江市', 3, 320500, ',320000,320500,320584,');
INSERT INTO `oa_city` VALUES (320585, '太仓市', 3, 320500, ',320000,320500,320585,');
INSERT INTO `oa_city` VALUES (320600, '南通市', 2, 320000, ',320000,320600,');
INSERT INTO `oa_city` VALUES (320602, '崇川区', 3, 320600, ',320000,320600,320602,');
INSERT INTO `oa_city` VALUES (320611, '港闸区', 3, 320600, ',320000,320600,320611,');
INSERT INTO `oa_city` VALUES (320621, '海安县', 3, 320600, ',320000,320600,320621,');
INSERT INTO `oa_city` VALUES (320623, '如东县', 3, 320600, ',320000,320600,320623,');
INSERT INTO `oa_city` VALUES (320681, '启东市', 3, 320600, ',320000,320600,320681,');
INSERT INTO `oa_city` VALUES (320682, '如皋市', 3, 320600, ',320000,320600,320682,');
INSERT INTO `oa_city` VALUES (320683, '通州市', 3, 320600, ',320000,320600,320683,');
INSERT INTO `oa_city` VALUES (320684, '海门市', 3, 320600, ',320000,320600,320684,');
INSERT INTO `oa_city` VALUES (320700, '连云港市', 2, 320000, ',320000,320700,');
INSERT INTO `oa_city` VALUES (320703, '连云区', 3, 320700, ',320000,320700,320703,');
INSERT INTO `oa_city` VALUES (320705, '新浦区', 3, 320700, ',320000,320700,320705,');
INSERT INTO `oa_city` VALUES (320706, '海州区', 3, 320700, ',320000,320700,320706,');
INSERT INTO `oa_city` VALUES (320721, '赣榆县', 3, 320700, ',320000,320700,320721,');
INSERT INTO `oa_city` VALUES (320722, '东海县', 3, 320700, ',320000,320700,320722,');
INSERT INTO `oa_city` VALUES (320723, '灌云县', 3, 320700, ',320000,320700,320723,');
INSERT INTO `oa_city` VALUES (320724, '灌南县', 3, 320700, ',320000,320700,320724,');
INSERT INTO `oa_city` VALUES (320800, '淮安市', 2, 320000, ',320000,320800,');
INSERT INTO `oa_city` VALUES (320802, '清河区', 3, 320800, ',320000,320800,320802,');
INSERT INTO `oa_city` VALUES (320803, '楚州区', 3, 320800, ',320000,320800,320803,');
INSERT INTO `oa_city` VALUES (320804, '淮阴区', 3, 320800, ',320000,320800,320804,');
INSERT INTO `oa_city` VALUES (320811, '清浦区', 3, 320800, ',320000,320800,320811,');
INSERT INTO `oa_city` VALUES (320826, '涟水县', 3, 320800, ',320000,320800,320826,');
INSERT INTO `oa_city` VALUES (320829, '洪泽县', 3, 320800, ',320000,320800,320829,');
INSERT INTO `oa_city` VALUES (320830, '盱眙县', 3, 320800, ',320000,320800,320830,');
INSERT INTO `oa_city` VALUES (320831, '金湖县', 3, 320800, ',320000,320800,320831,');
INSERT INTO `oa_city` VALUES (320900, '盐城市', 2, 320000, ',320000,320900,');
INSERT INTO `oa_city` VALUES (320902, '亭湖区', 3, 320900, ',320000,320900,320902,');
INSERT INTO `oa_city` VALUES (320903, '盐都区', 3, 320900, ',320000,320900,320903,');
INSERT INTO `oa_city` VALUES (320921, '响水县', 3, 320900, ',320000,320900,320921,');
INSERT INTO `oa_city` VALUES (320922, '滨海县', 3, 320900, ',320000,320900,320922,');
INSERT INTO `oa_city` VALUES (320923, '阜宁县', 3, 320900, ',320000,320900,320923,');
INSERT INTO `oa_city` VALUES (320924, '射阳县', 3, 320900, ',320000,320900,320924,');
INSERT INTO `oa_city` VALUES (320925, '建湖县', 3, 320900, ',320000,320900,320925,');
INSERT INTO `oa_city` VALUES (320981, '东台市', 3, 320900, ',320000,320900,320981,');
INSERT INTO `oa_city` VALUES (320982, '大丰市', 3, 320900, ',320000,320900,320982,');
INSERT INTO `oa_city` VALUES (321000, '扬州市', 2, 320000, ',320000,321000,');
INSERT INTO `oa_city` VALUES (321002, '广陵区', 3, 321000, ',320000,321000,321002,');
INSERT INTO `oa_city` VALUES (321003, '邗江区', 3, 321000, ',320000,321000,321003,');
INSERT INTO `oa_city` VALUES (321011, '郊　区', 3, 321000, ',320000,321000,321011,');
INSERT INTO `oa_city` VALUES (321023, '宝应县', 3, 321000, ',320000,321000,321023,');
INSERT INTO `oa_city` VALUES (321081, '仪征市', 3, 321000, ',320000,321000,321081,');
INSERT INTO `oa_city` VALUES (321084, '高邮市', 3, 321000, ',320000,321000,321084,');
INSERT INTO `oa_city` VALUES (321088, '江都市', 3, 321000, ',320000,321000,321088,');
INSERT INTO `oa_city` VALUES (321100, '镇江市', 2, 320000, ',320000,321100,');
INSERT INTO `oa_city` VALUES (321102, '京口区', 3, 321100, ',320000,321100,321102,');
INSERT INTO `oa_city` VALUES (321111, '润州区', 3, 321100, ',320000,321100,321111,');
INSERT INTO `oa_city` VALUES (321112, '丹徒区', 3, 321100, ',320000,321100,321112,');
INSERT INTO `oa_city` VALUES (321181, '丹阳市', 3, 321100, ',320000,321100,321181,');
INSERT INTO `oa_city` VALUES (321182, '扬中市', 3, 321100, ',320000,321100,321182,');
INSERT INTO `oa_city` VALUES (321183, '句容市', 3, 321100, ',320000,321100,321183,');
INSERT INTO `oa_city` VALUES (321200, '泰州市', 2, 320000, ',320000,321200,');
INSERT INTO `oa_city` VALUES (321202, '海陵区', 3, 321200, ',320000,321200,321202,');
INSERT INTO `oa_city` VALUES (321203, '高港区', 3, 321200, ',320000,321200,321203,');
INSERT INTO `oa_city` VALUES (321281, '兴化市', 3, 321200, ',320000,321200,321281,');
INSERT INTO `oa_city` VALUES (321282, '靖江市', 3, 321200, ',320000,321200,321282,');
INSERT INTO `oa_city` VALUES (321283, '泰兴市', 3, 321200, ',320000,321200,321283,');
INSERT INTO `oa_city` VALUES (321284, '姜堰市', 3, 321200, ',320000,321200,321284,');
INSERT INTO `oa_city` VALUES (321300, '宿迁市', 2, 320000, ',320000,321300,');
INSERT INTO `oa_city` VALUES (321302, '宿城区', 3, 321300, ',320000,321300,321302,');
INSERT INTO `oa_city` VALUES (321311, '宿豫区', 3, 321300, ',320000,321300,321311,');
INSERT INTO `oa_city` VALUES (321322, '沭阳县', 3, 321300, ',320000,321300,321322,');
INSERT INTO `oa_city` VALUES (321323, '泗阳县', 3, 321300, ',320000,321300,321323,');
INSERT INTO `oa_city` VALUES (321324, '泗洪县', 3, 321300, ',320000,321300,321324,');
INSERT INTO `oa_city` VALUES (330000, '浙江省', 1, 0, ',330000,');
INSERT INTO `oa_city` VALUES (330100, '杭州市', 2, 330000, ',330000,330100,');
INSERT INTO `oa_city` VALUES (330102, '上城区', 3, 330100, ',330000,330100,330102,');
INSERT INTO `oa_city` VALUES (330103, '下城区', 3, 330100, ',330000,330100,330103,');
INSERT INTO `oa_city` VALUES (330104, '江干区', 3, 330100, ',330000,330100,330104,');
INSERT INTO `oa_city` VALUES (330105, '拱墅区', 3, 330100, ',330000,330100,330105,');
INSERT INTO `oa_city` VALUES (330106, '西湖区', 3, 330100, ',330000,330100,330106,');
INSERT INTO `oa_city` VALUES (330108, '滨江区', 3, 330100, ',330000,330100,330108,');
INSERT INTO `oa_city` VALUES (330109, '萧山区', 3, 330100, ',330000,330100,330109,');
INSERT INTO `oa_city` VALUES (330110, '余杭区', 3, 330100, ',330000,330100,330110,');
INSERT INTO `oa_city` VALUES (330122, '桐庐县', 3, 330100, ',330000,330100,330122,');
INSERT INTO `oa_city` VALUES (330127, '淳安县', 3, 330100, ',330000,330100,330127,');
INSERT INTO `oa_city` VALUES (330182, '建德市', 3, 330100, ',330000,330100,330182,');
INSERT INTO `oa_city` VALUES (330183, '富阳市', 3, 330100, ',330000,330100,330183,');
INSERT INTO `oa_city` VALUES (330185, '临安市', 3, 330100, ',330000,330100,330185,');
INSERT INTO `oa_city` VALUES (330200, '宁波市', 2, 330000, ',330000,330200,');
INSERT INTO `oa_city` VALUES (330203, '海曙区', 3, 330200, ',330000,330200,330203,');
INSERT INTO `oa_city` VALUES (330204, '江东区', 3, 330200, ',330000,330200,330204,');
INSERT INTO `oa_city` VALUES (330205, '江北区', 3, 330200, ',330000,330200,330205,');
INSERT INTO `oa_city` VALUES (330206, '北仑区', 3, 330200, ',330000,330200,330206,');
INSERT INTO `oa_city` VALUES (330211, '镇海区', 3, 330200, ',330000,330200,330211,');
INSERT INTO `oa_city` VALUES (330212, '鄞州区', 3, 330200, ',330000,330200,330212,');
INSERT INTO `oa_city` VALUES (330225, '象山县', 3, 330200, ',330000,330200,330225,');
INSERT INTO `oa_city` VALUES (330226, '宁海县', 3, 330200, ',330000,330200,330226,');
INSERT INTO `oa_city` VALUES (330281, '余姚市', 3, 330200, ',330000,330200,330281,');
INSERT INTO `oa_city` VALUES (330282, '慈溪市', 3, 330200, ',330000,330200,330282,');
INSERT INTO `oa_city` VALUES (330283, '奉化市', 3, 330200, ',330000,330200,330283,');
INSERT INTO `oa_city` VALUES (330300, '温州市', 2, 330000, ',330000,330300,');
INSERT INTO `oa_city` VALUES (330302, '鹿城区', 3, 330300, ',330000,330300,330302,');
INSERT INTO `oa_city` VALUES (330303, '龙湾区', 3, 330300, ',330000,330300,330303,');
INSERT INTO `oa_city` VALUES (330304, '瓯海区', 3, 330300, ',330000,330300,330304,');
INSERT INTO `oa_city` VALUES (330322, '洞头县', 3, 330300, ',330000,330300,330322,');
INSERT INTO `oa_city` VALUES (330324, '永嘉县', 3, 330300, ',330000,330300,330324,');
INSERT INTO `oa_city` VALUES (330326, '平阳县', 3, 330300, ',330000,330300,330326,');
INSERT INTO `oa_city` VALUES (330327, '苍南县', 3, 330300, ',330000,330300,330327,');
INSERT INTO `oa_city` VALUES (330328, '文成县', 3, 330300, ',330000,330300,330328,');
INSERT INTO `oa_city` VALUES (330329, '泰顺县', 3, 330300, ',330000,330300,330329,');
INSERT INTO `oa_city` VALUES (330381, '瑞安市', 3, 330300, ',330000,330300,330381,');
INSERT INTO `oa_city` VALUES (330382, '乐清市', 3, 330300, ',330000,330300,330382,');
INSERT INTO `oa_city` VALUES (330400, '嘉兴市', 2, 330000, ',330000,330400,');
INSERT INTO `oa_city` VALUES (330402, '秀城区', 3, 330400, ',330000,330400,330402,');
INSERT INTO `oa_city` VALUES (330411, '秀洲区', 3, 330400, ',330000,330400,330411,');
INSERT INTO `oa_city` VALUES (330421, '嘉善县', 3, 330400, ',330000,330400,330421,');
INSERT INTO `oa_city` VALUES (330424, '海盐县', 3, 330400, ',330000,330400,330424,');
INSERT INTO `oa_city` VALUES (330481, '海宁市', 3, 330400, ',330000,330400,330481,');
INSERT INTO `oa_city` VALUES (330482, '平湖市', 3, 330400, ',330000,330400,330482,');
INSERT INTO `oa_city` VALUES (330483, '桐乡市', 3, 330400, ',330000,330400,330483,');
INSERT INTO `oa_city` VALUES (330500, '湖州市', 2, 330000, ',330000,330500,');
INSERT INTO `oa_city` VALUES (330502, '吴兴区', 3, 330500, ',330000,330500,330502,');
INSERT INTO `oa_city` VALUES (330503, '南浔区', 3, 330500, ',330000,330500,330503,');
INSERT INTO `oa_city` VALUES (330521, '德清县', 3, 330500, ',330000,330500,330521,');
INSERT INTO `oa_city` VALUES (330522, '长兴县', 3, 330500, ',330000,330500,330522,');
INSERT INTO `oa_city` VALUES (330523, '安吉县', 3, 330500, ',330000,330500,330523,');
INSERT INTO `oa_city` VALUES (330600, '绍兴市', 2, 330000, ',330000,330600,');
INSERT INTO `oa_city` VALUES (330602, '越城区', 3, 330600, ',330000,330600,330602,');
INSERT INTO `oa_city` VALUES (330621, '绍兴县', 3, 330600, ',330000,330600,330621,');
INSERT INTO `oa_city` VALUES (330624, '新昌县', 3, 330600, ',330000,330600,330624,');
INSERT INTO `oa_city` VALUES (330681, '诸暨市', 3, 330600, ',330000,330600,330681,');
INSERT INTO `oa_city` VALUES (330682, '上虞市', 3, 330600, ',330000,330600,330682,');
INSERT INTO `oa_city` VALUES (330683, '嵊州市', 3, 330600, ',330000,330600,330683,');
INSERT INTO `oa_city` VALUES (330700, '金华市', 2, 330000, ',330000,330700,');
INSERT INTO `oa_city` VALUES (330702, '婺城区', 3, 330700, ',330000,330700,330702,');
INSERT INTO `oa_city` VALUES (330703, '金东区', 3, 330700, ',330000,330700,330703,');
INSERT INTO `oa_city` VALUES (330723, '武义县', 3, 330700, ',330000,330700,330723,');
INSERT INTO `oa_city` VALUES (330726, '浦江县', 3, 330700, ',330000,330700,330726,');
INSERT INTO `oa_city` VALUES (330727, '磐安县', 3, 330700, ',330000,330700,330727,');
INSERT INTO `oa_city` VALUES (330781, '兰溪市', 3, 330700, ',330000,330700,330781,');
INSERT INTO `oa_city` VALUES (330782, '义乌市', 3, 330700, ',330000,330700,330782,');
INSERT INTO `oa_city` VALUES (330783, '东阳市', 3, 330700, ',330000,330700,330783,');
INSERT INTO `oa_city` VALUES (330784, '永康市', 3, 330700, ',330000,330700,330784,');
INSERT INTO `oa_city` VALUES (330800, '衢州市', 2, 330000, ',330000,330800,');
INSERT INTO `oa_city` VALUES (330802, '柯城区', 3, 330800, ',330000,330800,330802,');
INSERT INTO `oa_city` VALUES (330803, '衢江区', 3, 330800, ',330000,330800,330803,');
INSERT INTO `oa_city` VALUES (330822, '常山县', 3, 330800, ',330000,330800,330822,');
INSERT INTO `oa_city` VALUES (330824, '开化县', 3, 330800, ',330000,330800,330824,');
INSERT INTO `oa_city` VALUES (330825, '龙游县', 3, 330800, ',330000,330800,330825,');
INSERT INTO `oa_city` VALUES (330881, '江山市', 3, 330800, ',330000,330800,330881,');
INSERT INTO `oa_city` VALUES (330900, '舟山市', 2, 330000, ',330000,330900,');
INSERT INTO `oa_city` VALUES (330902, '定海区', 3, 330900, ',330000,330900,330902,');
INSERT INTO `oa_city` VALUES (330903, '普陀区', 3, 330900, ',330000,330900,330903,');
INSERT INTO `oa_city` VALUES (330921, '岱山县', 3, 330900, ',330000,330900,330921,');
INSERT INTO `oa_city` VALUES (330922, '嵊泗县', 3, 330900, ',330000,330900,330922,');
INSERT INTO `oa_city` VALUES (331000, '台州市', 2, 330000, ',330000,331000,');
INSERT INTO `oa_city` VALUES (331002, '椒江区', 3, 331000, ',330000,331000,331002,');
INSERT INTO `oa_city` VALUES (331003, '黄岩区', 3, 331000, ',330000,331000,331003,');
INSERT INTO `oa_city` VALUES (331004, '路桥区', 3, 331000, ',330000,331000,331004,');
INSERT INTO `oa_city` VALUES (331021, '玉环县', 3, 331000, ',330000,331000,331021,');
INSERT INTO `oa_city` VALUES (331022, '三门县', 3, 331000, ',330000,331000,331022,');
INSERT INTO `oa_city` VALUES (331023, '天台县', 3, 331000, ',330000,331000,331023,');
INSERT INTO `oa_city` VALUES (331024, '仙居县', 3, 331000, ',330000,331000,331024,');
INSERT INTO `oa_city` VALUES (331081, '温岭市', 3, 331000, ',330000,331000,331081,');
INSERT INTO `oa_city` VALUES (331082, '临海市', 3, 331000, ',330000,331000,331082,');
INSERT INTO `oa_city` VALUES (331100, '丽水市', 2, 330000, ',330000,331100,');
INSERT INTO `oa_city` VALUES (331102, '莲都区', 3, 331100, ',330000,331100,331102,');
INSERT INTO `oa_city` VALUES (331121, '青田县', 3, 331100, ',330000,331100,331121,');
INSERT INTO `oa_city` VALUES (331122, '缙云县', 3, 331100, ',330000,331100,331122,');
INSERT INTO `oa_city` VALUES (331123, '遂昌县', 3, 331100, ',330000,331100,331123,');
INSERT INTO `oa_city` VALUES (331124, '松阳县', 3, 331100, ',330000,331100,331124,');
INSERT INTO `oa_city` VALUES (331125, '云和县', 3, 331100, ',330000,331100,331125,');
INSERT INTO `oa_city` VALUES (331126, '庆元县', 3, 331100, ',330000,331100,331126,');
INSERT INTO `oa_city` VALUES (331127, '景宁畲族自治县', 3, 331100, ',330000,331100,331127,');
INSERT INTO `oa_city` VALUES (331181, '龙泉市', 3, 331100, ',330000,331100,331181,');
INSERT INTO `oa_city` VALUES (340000, '安徽省', 1, 0, ',340000,');
INSERT INTO `oa_city` VALUES (340100, '合肥市', 2, 340000, ',340000,340100,');
INSERT INTO `oa_city` VALUES (340102, '瑶海区', 3, 340100, ',340000,340100,340102,');
INSERT INTO `oa_city` VALUES (340103, '庐阳区', 3, 340100, ',340000,340100,340103,');
INSERT INTO `oa_city` VALUES (340104, '蜀山区', 3, 340100, ',340000,340100,340104,');
INSERT INTO `oa_city` VALUES (340111, '包河区', 3, 340100, ',340000,340100,340111,');
INSERT INTO `oa_city` VALUES (340121, '长丰县', 3, 340100, ',340000,340100,340121,');
INSERT INTO `oa_city` VALUES (340122, '肥东县', 3, 340100, ',340000,340100,340122,');
INSERT INTO `oa_city` VALUES (340123, '肥西县', 3, 340100, ',340000,340100,340123,');
INSERT INTO `oa_city` VALUES (340200, '芜湖市', 2, 340000, ',340000,340200,');
INSERT INTO `oa_city` VALUES (340202, '镜湖区', 3, 340200, ',340000,340200,340202,');
INSERT INTO `oa_city` VALUES (340203, '马塘区', 3, 340200, ',340000,340200,340203,');
INSERT INTO `oa_city` VALUES (340204, '新芜区', 3, 340200, ',340000,340200,340204,');
INSERT INTO `oa_city` VALUES (340207, '鸠江区', 3, 340200, ',340000,340200,340207,');
INSERT INTO `oa_city` VALUES (340221, '芜湖县', 3, 340200, ',340000,340200,340221,');
INSERT INTO `oa_city` VALUES (340222, '繁昌县', 3, 340200, ',340000,340200,340222,');
INSERT INTO `oa_city` VALUES (340223, '南陵县', 3, 340200, ',340000,340200,340223,');
INSERT INTO `oa_city` VALUES (340300, '蚌埠市', 2, 340000, ',340000,340300,');
INSERT INTO `oa_city` VALUES (340302, '龙子湖区', 3, 340300, ',340000,340300,340302,');
INSERT INTO `oa_city` VALUES (340303, '蚌山区', 3, 340300, ',340000,340300,340303,');
INSERT INTO `oa_city` VALUES (340304, '禹会区', 3, 340300, ',340000,340300,340304,');
INSERT INTO `oa_city` VALUES (340311, '淮上区', 3, 340300, ',340000,340300,340311,');
INSERT INTO `oa_city` VALUES (340321, '怀远县', 3, 340300, ',340000,340300,340321,');
INSERT INTO `oa_city` VALUES (340322, '五河县', 3, 340300, ',340000,340300,340322,');
INSERT INTO `oa_city` VALUES (340323, '固镇县', 3, 340300, ',340000,340300,340323,');
INSERT INTO `oa_city` VALUES (340400, '淮南市', 2, 340000, ',340000,340400,');
INSERT INTO `oa_city` VALUES (340402, '大通区', 3, 340400, ',340000,340400,340402,');
INSERT INTO `oa_city` VALUES (340403, '田家庵区', 3, 340400, ',340000,340400,340403,');
INSERT INTO `oa_city` VALUES (340404, '谢家集区', 3, 340400, ',340000,340400,340404,');
INSERT INTO `oa_city` VALUES (340405, '八公山区', 3, 340400, ',340000,340400,340405,');
INSERT INTO `oa_city` VALUES (340406, '潘集区', 3, 340400, ',340000,340400,340406,');
INSERT INTO `oa_city` VALUES (340421, '凤台县', 3, 340400, ',340000,340400,340421,');
INSERT INTO `oa_city` VALUES (340500, '马鞍山市', 2, 340000, ',340000,340500,');
INSERT INTO `oa_city` VALUES (340502, '金家庄区', 3, 340500, ',340000,340500,340502,');
INSERT INTO `oa_city` VALUES (340503, '花山区', 3, 340500, ',340000,340500,340503,');
INSERT INTO `oa_city` VALUES (340504, '雨山区', 3, 340500, ',340000,340500,340504,');
INSERT INTO `oa_city` VALUES (340521, '当涂县', 3, 340500, ',340000,340500,340521,');
INSERT INTO `oa_city` VALUES (340600, '淮北市', 2, 340000, ',340000,340600,');
INSERT INTO `oa_city` VALUES (340602, '杜集区', 3, 340600, ',340000,340600,340602,');
INSERT INTO `oa_city` VALUES (340603, '相山区', 3, 340600, ',340000,340600,340603,');
INSERT INTO `oa_city` VALUES (340604, '烈山区', 3, 340600, ',340000,340600,340604,');
INSERT INTO `oa_city` VALUES (340621, '濉溪县', 3, 340600, ',340000,340600,340621,');
INSERT INTO `oa_city` VALUES (340700, '铜陵市', 2, 340000, ',340000,340700,');
INSERT INTO `oa_city` VALUES (340702, '铜官山区', 3, 340700, ',340000,340700,340702,');
INSERT INTO `oa_city` VALUES (340703, '狮子山区', 3, 340700, ',340000,340700,340703,');
INSERT INTO `oa_city` VALUES (340711, '郊　区', 3, 340700, ',340000,340700,340711,');
INSERT INTO `oa_city` VALUES (340721, '铜陵县', 3, 340700, ',340000,340700,340721,');
INSERT INTO `oa_city` VALUES (340800, '安庆市', 2, 340000, ',340000,340800,');
INSERT INTO `oa_city` VALUES (340802, '迎江区', 3, 340800, ',340000,340800,340802,');
INSERT INTO `oa_city` VALUES (340803, '大观区', 3, 340800, ',340000,340800,340803,');
INSERT INTO `oa_city` VALUES (340811, '郊　区', 3, 340800, ',340000,340800,340811,');
INSERT INTO `oa_city` VALUES (340822, '怀宁县', 3, 340800, ',340000,340800,340822,');
INSERT INTO `oa_city` VALUES (340823, '枞阳县', 3, 340800, ',340000,340800,340823,');
INSERT INTO `oa_city` VALUES (340824, '潜山县', 3, 340800, ',340000,340800,340824,');
INSERT INTO `oa_city` VALUES (340825, '太湖县', 3, 340800, ',340000,340800,340825,');
INSERT INTO `oa_city` VALUES (340826, '宿松县', 3, 340800, ',340000,340800,340826,');
INSERT INTO `oa_city` VALUES (340827, '望江县', 3, 340800, ',340000,340800,340827,');
INSERT INTO `oa_city` VALUES (340828, '岳西县', 3, 340800, ',340000,340800,340828,');
INSERT INTO `oa_city` VALUES (340881, '桐城市', 3, 340800, ',340000,340800,340881,');
INSERT INTO `oa_city` VALUES (341000, '黄山市', 2, 340000, ',340000,341000,');
INSERT INTO `oa_city` VALUES (341002, '屯溪区', 3, 341000, ',340000,341000,341002,');
INSERT INTO `oa_city` VALUES (341003, '黄山区', 3, 341000, ',340000,341000,341003,');
INSERT INTO `oa_city` VALUES (341004, '徽州区', 3, 341000, ',340000,341000,341004,');
INSERT INTO `oa_city` VALUES (341021, '歙　县', 3, 341000, ',340000,341000,341021,');
INSERT INTO `oa_city` VALUES (341022, '休宁县', 3, 341000, ',340000,341000,341022,');
INSERT INTO `oa_city` VALUES (341023, '黟　县', 3, 341000, ',340000,341000,341023,');
INSERT INTO `oa_city` VALUES (341024, '祁门县', 3, 341000, ',340000,341000,341024,');
INSERT INTO `oa_city` VALUES (341100, '滁州市', 2, 340000, ',340000,341100,');
INSERT INTO `oa_city` VALUES (341102, '琅琊区', 3, 341100, ',340000,341100,341102,');
INSERT INTO `oa_city` VALUES (341103, '南谯区', 3, 341100, ',340000,341100,341103,');
INSERT INTO `oa_city` VALUES (341122, '来安县', 3, 341100, ',340000,341100,341122,');
INSERT INTO `oa_city` VALUES (341124, '全椒县', 3, 341100, ',340000,341100,341124,');
INSERT INTO `oa_city` VALUES (341125, '定远县', 3, 341100, ',340000,341100,341125,');
INSERT INTO `oa_city` VALUES (341126, '凤阳县', 3, 341100, ',340000,341100,341126,');
INSERT INTO `oa_city` VALUES (341181, '天长市', 3, 341100, ',340000,341100,341181,');
INSERT INTO `oa_city` VALUES (341182, '明光市', 3, 341100, ',340000,341100,341182,');
INSERT INTO `oa_city` VALUES (341200, '阜阳市', 2, 340000, ',340000,341200,');
INSERT INTO `oa_city` VALUES (341202, '颍州区', 3, 341200, ',340000,341200,341202,');
INSERT INTO `oa_city` VALUES (341203, '颍东区', 3, 341200, ',340000,341200,341203,');
INSERT INTO `oa_city` VALUES (341204, '颍泉区', 3, 341200, ',340000,341200,341204,');
INSERT INTO `oa_city` VALUES (341221, '临泉县', 3, 341200, ',340000,341200,341221,');
INSERT INTO `oa_city` VALUES (341222, '太和县', 3, 341200, ',340000,341200,341222,');
INSERT INTO `oa_city` VALUES (341225, '阜南县', 3, 341200, ',340000,341200,341225,');
INSERT INTO `oa_city` VALUES (341226, '颍上县', 3, 341200, ',340000,341200,341226,');
INSERT INTO `oa_city` VALUES (341282, '界首市', 3, 341200, ',340000,341200,341282,');
INSERT INTO `oa_city` VALUES (341300, '宿州市', 2, 340000, ',340000,341300,');
INSERT INTO `oa_city` VALUES (341302, '墉桥区', 3, 341300, ',340000,341300,341302,');
INSERT INTO `oa_city` VALUES (341321, '砀山县', 3, 341300, ',340000,341300,341321,');
INSERT INTO `oa_city` VALUES (341322, '萧　县', 3, 341300, ',340000,341300,341322,');
INSERT INTO `oa_city` VALUES (341323, '灵璧县', 3, 341300, ',340000,341300,341323,');
INSERT INTO `oa_city` VALUES (341324, '泗　县', 3, 341300, ',340000,341300,341324,');
INSERT INTO `oa_city` VALUES (341400, '巢湖市', 2, 340000, ',340000,341400,');
INSERT INTO `oa_city` VALUES (341401, '庐江县', 3, 340100, ',340000,340100,341401,');
INSERT INTO `oa_city` VALUES (341402, '巢湖市', 3, 340100, ',340000,340100,341402,');
INSERT INTO `oa_city` VALUES (341421, '庐江县', 3, 341400, ',340000,341400,341421,');
INSERT INTO `oa_city` VALUES (341422, '无为县', 3, 340200, ',340000,340200,341422,');
INSERT INTO `oa_city` VALUES (341423, '含山县', 3, 340500, ',340000,340500,341423,');
INSERT INTO `oa_city` VALUES (341424, '和　县', 3, 340500, ',340000,340500,341424,');
INSERT INTO `oa_city` VALUES (341500, '六安市', 2, 340000, ',340000,341500,');
INSERT INTO `oa_city` VALUES (341502, '金安区', 3, 341500, ',340000,341500,341502,');
INSERT INTO `oa_city` VALUES (341503, '裕安区', 3, 341500, ',340000,341500,341503,');
INSERT INTO `oa_city` VALUES (341521, '寿　县', 3, 341500, ',340000,341500,341521,');
INSERT INTO `oa_city` VALUES (341522, '霍邱县', 3, 341500, ',340000,341500,341522,');
INSERT INTO `oa_city` VALUES (341523, '舒城县', 3, 341500, ',340000,341500,341523,');
INSERT INTO `oa_city` VALUES (341524, '金寨县', 3, 341500, ',340000,341500,341524,');
INSERT INTO `oa_city` VALUES (341525, '霍山县', 3, 341500, ',340000,341500,341525,');
INSERT INTO `oa_city` VALUES (341600, '亳州市', 2, 340000, ',340000,341600,');
INSERT INTO `oa_city` VALUES (341602, '谯城区', 3, 341600, ',340000,341600,341602,');
INSERT INTO `oa_city` VALUES (341621, '涡阳县', 3, 341600, ',340000,341600,341621,');
INSERT INTO `oa_city` VALUES (341622, '蒙城县', 3, 341600, ',340000,341600,341622,');
INSERT INTO `oa_city` VALUES (341623, '利辛县', 3, 341600, ',340000,341600,341623,');
INSERT INTO `oa_city` VALUES (341700, '池州市', 2, 340000, ',340000,341700,');
INSERT INTO `oa_city` VALUES (341702, '贵池区', 3, 341700, ',340000,341700,341702,');
INSERT INTO `oa_city` VALUES (341721, '东至县', 3, 341700, ',340000,341700,341721,');
INSERT INTO `oa_city` VALUES (341722, '石台县', 3, 341700, ',340000,341700,341722,');
INSERT INTO `oa_city` VALUES (341723, '青阳县', 3, 341700, ',340000,341700,341723,');
INSERT INTO `oa_city` VALUES (341800, '宣城市', 2, 340000, ',340000,341800,');
INSERT INTO `oa_city` VALUES (341802, '宣州区', 3, 341800, ',340000,341800,341802,');
INSERT INTO `oa_city` VALUES (341821, '郎溪县', 3, 341800, ',340000,341800,341821,');
INSERT INTO `oa_city` VALUES (341822, '广德县', 3, 341800, ',340000,341800,341822,');
INSERT INTO `oa_city` VALUES (341823, '泾　县', 3, 341800, ',340000,341800,341823,');
INSERT INTO `oa_city` VALUES (341824, '绩溪县', 3, 341800, ',340000,341800,341824,');
INSERT INTO `oa_city` VALUES (341825, '旌德县', 3, 341800, ',340000,341800,341825,');
INSERT INTO `oa_city` VALUES (341881, '宁国市', 3, 341800, ',340000,341800,341881,');
INSERT INTO `oa_city` VALUES (350000, '福建省', 1, 0, ',350000,');
INSERT INTO `oa_city` VALUES (350100, '福州市', 2, 350000, ',350000,350100,');
INSERT INTO `oa_city` VALUES (350102, '鼓楼区', 3, 350100, ',350000,350100,350102,');
INSERT INTO `oa_city` VALUES (350103, '台江区', 3, 350100, ',350000,350100,350103,');
INSERT INTO `oa_city` VALUES (350104, '仓山区', 3, 350100, ',350000,350100,350104,');
INSERT INTO `oa_city` VALUES (350105, '马尾区', 3, 350100, ',350000,350100,350105,');
INSERT INTO `oa_city` VALUES (350111, '晋安区', 3, 350100, ',350000,350100,350111,');
INSERT INTO `oa_city` VALUES (350121, '闽侯县', 3, 350100, ',350000,350100,350121,');
INSERT INTO `oa_city` VALUES (350122, '连江县', 3, 350100, ',350000,350100,350122,');
INSERT INTO `oa_city` VALUES (350123, '罗源县', 3, 350100, ',350000,350100,350123,');
INSERT INTO `oa_city` VALUES (350124, '闽清县', 3, 350100, ',350000,350100,350124,');
INSERT INTO `oa_city` VALUES (350125, '永泰县', 3, 350100, ',350000,350100,350125,');
INSERT INTO `oa_city` VALUES (350128, '平潭县', 3, 350100, ',350000,350100,350128,');
INSERT INTO `oa_city` VALUES (350181, '福清市', 3, 350100, ',350000,350100,350181,');
INSERT INTO `oa_city` VALUES (350182, '长乐市', 3, 350100, ',350000,350100,350182,');
INSERT INTO `oa_city` VALUES (350200, '厦门市', 2, 350000, ',350000,350200,');
INSERT INTO `oa_city` VALUES (350203, '思明区', 3, 350200, ',350000,350200,350203,');
INSERT INTO `oa_city` VALUES (350205, '海沧区', 3, 350200, ',350000,350200,350205,');
INSERT INTO `oa_city` VALUES (350206, '湖里区', 3, 350200, ',350000,350200,350206,');
INSERT INTO `oa_city` VALUES (350211, '集美区', 3, 350200, ',350000,350200,350211,');
INSERT INTO `oa_city` VALUES (350212, '同安区', 3, 350200, ',350000,350200,350212,');
INSERT INTO `oa_city` VALUES (350213, '翔安区', 3, 350200, ',350000,350200,350213,');
INSERT INTO `oa_city` VALUES (350300, '莆田市', 2, 350000, ',350000,350300,');
INSERT INTO `oa_city` VALUES (350302, '城厢区', 3, 350300, ',350000,350300,350302,');
INSERT INTO `oa_city` VALUES (350303, '涵江区', 3, 350300, ',350000,350300,350303,');
INSERT INTO `oa_city` VALUES (350304, '荔城区', 3, 350300, ',350000,350300,350304,');
INSERT INTO `oa_city` VALUES (350305, '秀屿区', 3, 350300, ',350000,350300,350305,');
INSERT INTO `oa_city` VALUES (350322, '仙游县', 3, 350300, ',350000,350300,350322,');
INSERT INTO `oa_city` VALUES (350400, '三明市', 2, 350000, ',350000,350400,');
INSERT INTO `oa_city` VALUES (350402, '梅列区', 3, 350400, ',350000,350400,350402,');
INSERT INTO `oa_city` VALUES (350403, '三元区', 3, 350400, ',350000,350400,350403,');
INSERT INTO `oa_city` VALUES (350421, '明溪县', 3, 350400, ',350000,350400,350421,');
INSERT INTO `oa_city` VALUES (350423, '清流县', 3, 350400, ',350000,350400,350423,');
INSERT INTO `oa_city` VALUES (350424, '宁化县', 3, 350400, ',350000,350400,350424,');
INSERT INTO `oa_city` VALUES (350425, '大田县', 3, 350400, ',350000,350400,350425,');
INSERT INTO `oa_city` VALUES (350426, '尤溪县', 3, 350400, ',350000,350400,350426,');
INSERT INTO `oa_city` VALUES (350427, '沙　县', 3, 350400, ',350000,350400,350427,');
INSERT INTO `oa_city` VALUES (350428, '将乐县', 3, 350400, ',350000,350400,350428,');
INSERT INTO `oa_city` VALUES (350429, '泰宁县', 3, 350400, ',350000,350400,350429,');
INSERT INTO `oa_city` VALUES (350430, '建宁县', 3, 350400, ',350000,350400,350430,');
INSERT INTO `oa_city` VALUES (350481, '永安市', 3, 350400, ',350000,350400,350481,');
INSERT INTO `oa_city` VALUES (350500, '泉州市', 2, 350000, ',350000,350500,');
INSERT INTO `oa_city` VALUES (350502, '鲤城区', 3, 350500, ',350000,350500,350502,');
INSERT INTO `oa_city` VALUES (350503, '丰泽区', 3, 350500, ',350000,350500,350503,');
INSERT INTO `oa_city` VALUES (350504, '洛江区', 3, 350500, ',350000,350500,350504,');
INSERT INTO `oa_city` VALUES (350505, '泉港区', 3, 350500, ',350000,350500,350505,');
INSERT INTO `oa_city` VALUES (350521, '惠安县', 3, 350500, ',350000,350500,350521,');
INSERT INTO `oa_city` VALUES (350524, '安溪县', 3, 350500, ',350000,350500,350524,');
INSERT INTO `oa_city` VALUES (350525, '永春县', 3, 350500, ',350000,350500,350525,');
INSERT INTO `oa_city` VALUES (350526, '德化县', 3, 350500, ',350000,350500,350526,');
INSERT INTO `oa_city` VALUES (350527, '金门县', 3, 350500, ',350000,350500,350527,');
INSERT INTO `oa_city` VALUES (350581, '石狮市', 3, 350500, ',350000,350500,350581,');
INSERT INTO `oa_city` VALUES (350582, '晋江市', 3, 350500, ',350000,350500,350582,');
INSERT INTO `oa_city` VALUES (350583, '南安市', 3, 350500, ',350000,350500,350583,');
INSERT INTO `oa_city` VALUES (350600, '漳州市', 2, 350000, ',350000,350600,');
INSERT INTO `oa_city` VALUES (350602, '芗城区', 3, 350600, ',350000,350600,350602,');
INSERT INTO `oa_city` VALUES (350603, '龙文区', 3, 350600, ',350000,350600,350603,');
INSERT INTO `oa_city` VALUES (350622, '云霄县', 3, 350600, ',350000,350600,350622,');
INSERT INTO `oa_city` VALUES (350623, '漳浦县', 3, 350600, ',350000,350600,350623,');
INSERT INTO `oa_city` VALUES (350624, '诏安县', 3, 350600, ',350000,350600,350624,');
INSERT INTO `oa_city` VALUES (350625, '长泰县', 3, 350600, ',350000,350600,350625,');
INSERT INTO `oa_city` VALUES (350626, '东山县', 3, 350600, ',350000,350600,350626,');
INSERT INTO `oa_city` VALUES (350627, '南靖县', 3, 350600, ',350000,350600,350627,');
INSERT INTO `oa_city` VALUES (350628, '平和县', 3, 350600, ',350000,350600,350628,');
INSERT INTO `oa_city` VALUES (350629, '华安县', 3, 350600, ',350000,350600,350629,');
INSERT INTO `oa_city` VALUES (350681, '龙海市', 3, 350600, ',350000,350600,350681,');
INSERT INTO `oa_city` VALUES (350700, '南平市', 2, 350000, ',350000,350700,');
INSERT INTO `oa_city` VALUES (350702, '延平区', 3, 350700, ',350000,350700,350702,');
INSERT INTO `oa_city` VALUES (350721, '顺昌县', 3, 350700, ',350000,350700,350721,');
INSERT INTO `oa_city` VALUES (350722, '浦城县', 3, 350700, ',350000,350700,350722,');
INSERT INTO `oa_city` VALUES (350723, '光泽县', 3, 350700, ',350000,350700,350723,');
INSERT INTO `oa_city` VALUES (350724, '松溪县', 3, 350700, ',350000,350700,350724,');
INSERT INTO `oa_city` VALUES (350725, '政和县', 3, 350700, ',350000,350700,350725,');
INSERT INTO `oa_city` VALUES (350781, '邵武市', 3, 350700, ',350000,350700,350781,');
INSERT INTO `oa_city` VALUES (350782, '武夷山市', 3, 350700, ',350000,350700,350782,');
INSERT INTO `oa_city` VALUES (350783, '建瓯市', 3, 350700, ',350000,350700,350783,');
INSERT INTO `oa_city` VALUES (350784, '建阳市', 3, 350700, ',350000,350700,350784,');
INSERT INTO `oa_city` VALUES (350800, '龙岩市', 2, 350000, ',350000,350800,');
INSERT INTO `oa_city` VALUES (350802, '新罗区', 3, 350800, ',350000,350800,350802,');
INSERT INTO `oa_city` VALUES (350821, '长汀县', 3, 350800, ',350000,350800,350821,');
INSERT INTO `oa_city` VALUES (350822, '永定县', 3, 350800, ',350000,350800,350822,');
INSERT INTO `oa_city` VALUES (350823, '上杭县', 3, 350800, ',350000,350800,350823,');
INSERT INTO `oa_city` VALUES (350824, '武平县', 3, 350800, ',350000,350800,350824,');
INSERT INTO `oa_city` VALUES (350825, '连城县', 3, 350800, ',350000,350800,350825,');
INSERT INTO `oa_city` VALUES (350881, '漳平市', 3, 350800, ',350000,350800,350881,');
INSERT INTO `oa_city` VALUES (350900, '宁德市', 2, 350000, ',350000,350900,');
INSERT INTO `oa_city` VALUES (350902, '蕉城区', 3, 350900, ',350000,350900,350902,');
INSERT INTO `oa_city` VALUES (350921, '霞浦县', 3, 350900, ',350000,350900,350921,');
INSERT INTO `oa_city` VALUES (350922, '古田县', 3, 350900, ',350000,350900,350922,');
INSERT INTO `oa_city` VALUES (350923, '屏南县', 3, 350900, ',350000,350900,350923,');
INSERT INTO `oa_city` VALUES (350924, '寿宁县', 3, 350900, ',350000,350900,350924,');
INSERT INTO `oa_city` VALUES (350925, '周宁县', 3, 350900, ',350000,350900,350925,');
INSERT INTO `oa_city` VALUES (350926, '柘荣县', 3, 350900, ',350000,350900,350926,');
INSERT INTO `oa_city` VALUES (350981, '福安市', 3, 350900, ',350000,350900,350981,');
INSERT INTO `oa_city` VALUES (350982, '福鼎市', 3, 350900, ',350000,350900,350982,');
INSERT INTO `oa_city` VALUES (360000, '江西省', 1, 0, ',360000,');
INSERT INTO `oa_city` VALUES (360100, '南昌市', 2, 360000, ',360000,360100,');
INSERT INTO `oa_city` VALUES (360102, '东湖区', 3, 360100, ',360000,360100,360102,');
INSERT INTO `oa_city` VALUES (360103, '西湖区', 3, 360100, ',360000,360100,360103,');
INSERT INTO `oa_city` VALUES (360104, '青云谱区', 3, 360100, ',360000,360100,360104,');
INSERT INTO `oa_city` VALUES (360105, '湾里区', 3, 360100, ',360000,360100,360105,');
INSERT INTO `oa_city` VALUES (360111, '青山湖区', 3, 360100, ',360000,360100,360111,');
INSERT INTO `oa_city` VALUES (360121, '南昌县', 3, 360100, ',360000,360100,360121,');
INSERT INTO `oa_city` VALUES (360122, '新建县', 3, 360100, ',360000,360100,360122,');
INSERT INTO `oa_city` VALUES (360123, '安义县', 3, 360100, ',360000,360100,360123,');
INSERT INTO `oa_city` VALUES (360124, '进贤县', 3, 360100, ',360000,360100,360124,');
INSERT INTO `oa_city` VALUES (360200, '景德镇市', 2, 360000, ',360000,360200,');
INSERT INTO `oa_city` VALUES (360202, '昌江区', 3, 360200, ',360000,360200,360202,');
INSERT INTO `oa_city` VALUES (360203, '珠山区', 3, 360200, ',360000,360200,360203,');
INSERT INTO `oa_city` VALUES (360222, '浮梁县', 3, 360200, ',360000,360200,360222,');
INSERT INTO `oa_city` VALUES (360281, '乐平市', 3, 360200, ',360000,360200,360281,');
INSERT INTO `oa_city` VALUES (360300, '萍乡市', 2, 360000, ',360000,360300,');
INSERT INTO `oa_city` VALUES (360302, '安源区', 3, 360300, ',360000,360300,360302,');
INSERT INTO `oa_city` VALUES (360313, '湘东区', 3, 360300, ',360000,360300,360313,');
INSERT INTO `oa_city` VALUES (360321, '莲花县', 3, 360300, ',360000,360300,360321,');
INSERT INTO `oa_city` VALUES (360322, '上栗县', 3, 360300, ',360000,360300,360322,');
INSERT INTO `oa_city` VALUES (360323, '芦溪县', 3, 360300, ',360000,360300,360323,');
INSERT INTO `oa_city` VALUES (360400, '九江市', 2, 360000, ',360000,360400,');
INSERT INTO `oa_city` VALUES (360402, '庐山区', 3, 360400, ',360000,360400,360402,');
INSERT INTO `oa_city` VALUES (360403, '浔阳区', 3, 360400, ',360000,360400,360403,');
INSERT INTO `oa_city` VALUES (360421, '九江县', 3, 360400, ',360000,360400,360421,');
INSERT INTO `oa_city` VALUES (360423, '武宁县', 3, 360400, ',360000,360400,360423,');
INSERT INTO `oa_city` VALUES (360424, '修水县', 3, 360400, ',360000,360400,360424,');
INSERT INTO `oa_city` VALUES (360425, '永修县', 3, 360400, ',360000,360400,360425,');
INSERT INTO `oa_city` VALUES (360426, '德安县', 3, 360400, ',360000,360400,360426,');
INSERT INTO `oa_city` VALUES (360427, '星子县', 3, 360400, ',360000,360400,360427,');
INSERT INTO `oa_city` VALUES (360428, '都昌县', 3, 360400, ',360000,360400,360428,');
INSERT INTO `oa_city` VALUES (360429, '湖口县', 3, 360400, ',360000,360400,360429,');
INSERT INTO `oa_city` VALUES (360430, '彭泽县', 3, 360400, ',360000,360400,360430,');
INSERT INTO `oa_city` VALUES (360481, '瑞昌市', 3, 360400, ',360000,360400,360481,');
INSERT INTO `oa_city` VALUES (360500, '新余市', 2, 360000, ',360000,360500,');
INSERT INTO `oa_city` VALUES (360502, '渝水区', 3, 360500, ',360000,360500,360502,');
INSERT INTO `oa_city` VALUES (360521, '分宜县', 3, 360500, ',360000,360500,360521,');
INSERT INTO `oa_city` VALUES (360600, '鹰潭市', 2, 360000, ',360000,360600,');
INSERT INTO `oa_city` VALUES (360602, '月湖区', 3, 360600, ',360000,360600,360602,');
INSERT INTO `oa_city` VALUES (360622, '余江县', 3, 360600, ',360000,360600,360622,');
INSERT INTO `oa_city` VALUES (360681, '贵溪市', 3, 360600, ',360000,360600,360681,');
INSERT INTO `oa_city` VALUES (360700, '赣州市', 2, 360000, ',360000,360700,');
INSERT INTO `oa_city` VALUES (360702, '章贡区', 3, 360700, ',360000,360700,360702,');
INSERT INTO `oa_city` VALUES (360721, '赣　县', 3, 360700, ',360000,360700,360721,');
INSERT INTO `oa_city` VALUES (360722, '信丰县', 3, 360700, ',360000,360700,360722,');
INSERT INTO `oa_city` VALUES (360723, '大余县', 3, 360700, ',360000,360700,360723,');
INSERT INTO `oa_city` VALUES (360724, '上犹县', 3, 360700, ',360000,360700,360724,');
INSERT INTO `oa_city` VALUES (360725, '崇义县', 3, 360700, ',360000,360700,360725,');
INSERT INTO `oa_city` VALUES (360726, '安远县', 3, 360700, ',360000,360700,360726,');
INSERT INTO `oa_city` VALUES (360727, '龙南县', 3, 360700, ',360000,360700,360727,');
INSERT INTO `oa_city` VALUES (360728, '定南县', 3, 360700, ',360000,360700,360728,');
INSERT INTO `oa_city` VALUES (360729, '全南县', 3, 360700, ',360000,360700,360729,');
INSERT INTO `oa_city` VALUES (360730, '宁都县', 3, 360700, ',360000,360700,360730,');
INSERT INTO `oa_city` VALUES (360731, '于都县', 3, 360700, ',360000,360700,360731,');
INSERT INTO `oa_city` VALUES (360732, '兴国县', 3, 360700, ',360000,360700,360732,');
INSERT INTO `oa_city` VALUES (360733, '会昌县', 3, 360700, ',360000,360700,360733,');
INSERT INTO `oa_city` VALUES (360734, '寻乌县', 3, 360700, ',360000,360700,360734,');
INSERT INTO `oa_city` VALUES (360735, '石城县', 3, 360700, ',360000,360700,360735,');
INSERT INTO `oa_city` VALUES (360781, '瑞金市', 3, 360700, ',360000,360700,360781,');
INSERT INTO `oa_city` VALUES (360782, '南康市', 3, 360700, ',360000,360700,360782,');
INSERT INTO `oa_city` VALUES (360800, '吉安市', 2, 360000, ',360000,360800,');
INSERT INTO `oa_city` VALUES (360802, '吉州区', 3, 360800, ',360000,360800,360802,');
INSERT INTO `oa_city` VALUES (360803, '青原区', 3, 360800, ',360000,360800,360803,');
INSERT INTO `oa_city` VALUES (360821, '吉安县', 3, 360800, ',360000,360800,360821,');
INSERT INTO `oa_city` VALUES (360822, '吉水县', 3, 360800, ',360000,360800,360822,');
INSERT INTO `oa_city` VALUES (360823, '峡江县', 3, 360800, ',360000,360800,360823,');
INSERT INTO `oa_city` VALUES (360824, '新干县', 3, 360800, ',360000,360800,360824,');
INSERT INTO `oa_city` VALUES (360825, '永丰县', 3, 360800, ',360000,360800,360825,');
INSERT INTO `oa_city` VALUES (360826, '泰和县', 3, 360800, ',360000,360800,360826,');
INSERT INTO `oa_city` VALUES (360827, '遂川县', 3, 360800, ',360000,360800,360827,');
INSERT INTO `oa_city` VALUES (360828, '万安县', 3, 360800, ',360000,360800,360828,');
INSERT INTO `oa_city` VALUES (360829, '安福县', 3, 360800, ',360000,360800,360829,');
INSERT INTO `oa_city` VALUES (360830, '永新县', 3, 360800, ',360000,360800,360830,');
INSERT INTO `oa_city` VALUES (360881, '井冈山市', 3, 360800, ',360000,360800,360881,');
INSERT INTO `oa_city` VALUES (360900, '宜春市', 2, 360000, ',360000,360900,');
INSERT INTO `oa_city` VALUES (360902, '袁州区', 3, 360900, ',360000,360900,360902,');
INSERT INTO `oa_city` VALUES (360921, '奉新县', 3, 360900, ',360000,360900,360921,');
INSERT INTO `oa_city` VALUES (360922, '万载县', 3, 360900, ',360000,360900,360922,');
INSERT INTO `oa_city` VALUES (360923, '上高县', 3, 360900, ',360000,360900,360923,');
INSERT INTO `oa_city` VALUES (360924, '宜丰县', 3, 360900, ',360000,360900,360924,');
INSERT INTO `oa_city` VALUES (360925, '靖安县', 3, 360900, ',360000,360900,360925,');
INSERT INTO `oa_city` VALUES (360926, '铜鼓县', 3, 360900, ',360000,360900,360926,');
INSERT INTO `oa_city` VALUES (360981, '丰城市', 3, 360900, ',360000,360900,360981,');
INSERT INTO `oa_city` VALUES (360982, '樟树市', 3, 360900, ',360000,360900,360982,');
INSERT INTO `oa_city` VALUES (360983, '高安市', 3, 360900, ',360000,360900,360983,');
INSERT INTO `oa_city` VALUES (361000, '抚州市', 2, 360000, ',360000,361000,');
INSERT INTO `oa_city` VALUES (361002, '临川区', 3, 361000, ',360000,361000,361002,');
INSERT INTO `oa_city` VALUES (361021, '南城县', 3, 361000, ',360000,361000,361021,');
INSERT INTO `oa_city` VALUES (361022, '黎川县', 3, 361000, ',360000,361000,361022,');
INSERT INTO `oa_city` VALUES (361023, '南丰县', 3, 361000, ',360000,361000,361023,');
INSERT INTO `oa_city` VALUES (361024, '崇仁县', 3, 361000, ',360000,361000,361024,');
INSERT INTO `oa_city` VALUES (361025, '乐安县', 3, 361000, ',360000,361000,361025,');
INSERT INTO `oa_city` VALUES (361026, '宜黄县', 3, 361000, ',360000,361000,361026,');
INSERT INTO `oa_city` VALUES (361027, '金溪县', 3, 361000, ',360000,361000,361027,');
INSERT INTO `oa_city` VALUES (361028, '资溪县', 3, 361000, ',360000,361000,361028,');
INSERT INTO `oa_city` VALUES (361029, '东乡县', 3, 361000, ',360000,361000,361029,');
INSERT INTO `oa_city` VALUES (361030, '广昌县', 3, 361000, ',360000,361000,361030,');
INSERT INTO `oa_city` VALUES (361100, '上饶市', 2, 360000, ',360000,361100,');
INSERT INTO `oa_city` VALUES (361102, '信州区', 3, 361100, ',360000,361100,361102,');
INSERT INTO `oa_city` VALUES (361121, '上饶县', 3, 361100, ',360000,361100,361121,');
INSERT INTO `oa_city` VALUES (361122, '广丰县', 3, 361100, ',360000,361100,361122,');
INSERT INTO `oa_city` VALUES (361123, '玉山县', 3, 361100, ',360000,361100,361123,');
INSERT INTO `oa_city` VALUES (361124, '铅山县', 3, 361100, ',360000,361100,361124,');
INSERT INTO `oa_city` VALUES (361125, '横峰县', 3, 361100, ',360000,361100,361125,');
INSERT INTO `oa_city` VALUES (361126, '弋阳县', 3, 361100, ',360000,361100,361126,');
INSERT INTO `oa_city` VALUES (361127, '余干县', 3, 361100, ',360000,361100,361127,');
INSERT INTO `oa_city` VALUES (361128, '鄱阳县', 3, 361100, ',360000,361100,361128,');
INSERT INTO `oa_city` VALUES (361129, '万年县', 3, 361100, ',360000,361100,361129,');
INSERT INTO `oa_city` VALUES (361130, '婺源县', 3, 361100, ',360000,361100,361130,');
INSERT INTO `oa_city` VALUES (361181, '德兴市', 3, 361100, ',360000,361100,361181,');
INSERT INTO `oa_city` VALUES (370000, '山东省', 1, 0, ',370000,');
INSERT INTO `oa_city` VALUES (370100, '济南市', 2, 370000, ',370000,370100,');
INSERT INTO `oa_city` VALUES (370102, '历下区', 3, 370100, ',370000,370100,370102,');
INSERT INTO `oa_city` VALUES (370103, '市中区', 3, 370100, ',370000,370100,370103,');
INSERT INTO `oa_city` VALUES (370104, '槐荫区', 3, 370100, ',370000,370100,370104,');
INSERT INTO `oa_city` VALUES (370105, '天桥区', 3, 370100, ',370000,370100,370105,');
INSERT INTO `oa_city` VALUES (370112, '历城区', 3, 370100, ',370000,370100,370112,');
INSERT INTO `oa_city` VALUES (370113, '长清区', 3, 370100, ',370000,370100,370113,');
INSERT INTO `oa_city` VALUES (370124, '平阴县', 3, 370100, ',370000,370100,370124,');
INSERT INTO `oa_city` VALUES (370125, '济阳县', 3, 370100, ',370000,370100,370125,');
INSERT INTO `oa_city` VALUES (370126, '商河县', 3, 370100, ',370000,370100,370126,');
INSERT INTO `oa_city` VALUES (370181, '章丘市', 3, 370100, ',370000,370100,370181,');
INSERT INTO `oa_city` VALUES (370200, '青岛市', 2, 370000, ',370000,370200,');
INSERT INTO `oa_city` VALUES (370202, '市南区', 3, 370200, ',370000,370200,370202,');
INSERT INTO `oa_city` VALUES (370203, '市北区', 3, 370200, ',370000,370200,370203,');
INSERT INTO `oa_city` VALUES (370205, '四方区', 3, 370200, ',370000,370200,370205,');
INSERT INTO `oa_city` VALUES (370211, '黄岛区', 3, 370200, ',370000,370200,370211,');
INSERT INTO `oa_city` VALUES (370212, '崂山区', 3, 370200, ',370000,370200,370212,');
INSERT INTO `oa_city` VALUES (370213, '李沧区', 3, 370200, ',370000,370200,370213,');
INSERT INTO `oa_city` VALUES (370214, '城阳区', 3, 370200, ',370000,370200,370214,');
INSERT INTO `oa_city` VALUES (370281, '胶州市', 3, 370200, ',370000,370200,370281,');
INSERT INTO `oa_city` VALUES (370282, '即墨市', 3, 370200, ',370000,370200,370282,');
INSERT INTO `oa_city` VALUES (370283, '平度市', 3, 370200, ',370000,370200,370283,');
INSERT INTO `oa_city` VALUES (370284, '胶南市', 3, 370200, ',370000,370200,370284,');
INSERT INTO `oa_city` VALUES (370285, '莱西市', 3, 370200, ',370000,370200,370285,');
INSERT INTO `oa_city` VALUES (370300, '淄博市', 2, 370000, ',370000,370300,');
INSERT INTO `oa_city` VALUES (370302, '淄川区', 3, 370300, ',370000,370300,370302,');
INSERT INTO `oa_city` VALUES (370303, '张店区', 3, 370300, ',370000,370300,370303,');
INSERT INTO `oa_city` VALUES (370304, '博山区', 3, 370300, ',370000,370300,370304,');
INSERT INTO `oa_city` VALUES (370305, '临淄区', 3, 370300, ',370000,370300,370305,');
INSERT INTO `oa_city` VALUES (370306, '周村区', 3, 370300, ',370000,370300,370306,');
INSERT INTO `oa_city` VALUES (370321, '桓台县', 3, 370300, ',370000,370300,370321,');
INSERT INTO `oa_city` VALUES (370322, '高青县', 3, 370300, ',370000,370300,370322,');
INSERT INTO `oa_city` VALUES (370323, '沂源县', 3, 370300, ',370000,370300,370323,');
INSERT INTO `oa_city` VALUES (370400, '枣庄市', 2, 370000, ',370000,370400,');
INSERT INTO `oa_city` VALUES (370402, '市中区', 3, 370400, ',370000,370400,370402,');
INSERT INTO `oa_city` VALUES (370403, '薛城区', 3, 370400, ',370000,370400,370403,');
INSERT INTO `oa_city` VALUES (370404, '峄城区', 3, 370400, ',370000,370400,370404,');
INSERT INTO `oa_city` VALUES (370405, '台儿庄区', 3, 370400, ',370000,370400,370405,');
INSERT INTO `oa_city` VALUES (370406, '山亭区', 3, 370400, ',370000,370400,370406,');
INSERT INTO `oa_city` VALUES (370481, '滕州市', 3, 370400, ',370000,370400,370481,');
INSERT INTO `oa_city` VALUES (370500, '东营市', 2, 370000, ',370000,370500,');
INSERT INTO `oa_city` VALUES (370502, '东营区', 3, 370500, ',370000,370500,370502,');
INSERT INTO `oa_city` VALUES (370503, '河口区', 3, 370500, ',370000,370500,370503,');
INSERT INTO `oa_city` VALUES (370521, '垦利县', 3, 370500, ',370000,370500,370521,');
INSERT INTO `oa_city` VALUES (370522, '利津县', 3, 370500, ',370000,370500,370522,');
INSERT INTO `oa_city` VALUES (370523, '广饶县', 3, 370500, ',370000,370500,370523,');
INSERT INTO `oa_city` VALUES (370600, '烟台市', 2, 370000, ',370000,370600,');
INSERT INTO `oa_city` VALUES (370602, '芝罘区', 3, 370600, ',370000,370600,370602,');
INSERT INTO `oa_city` VALUES (370611, '福山区', 3, 370600, ',370000,370600,370611,');
INSERT INTO `oa_city` VALUES (370612, '牟平区', 3, 370600, ',370000,370600,370612,');
INSERT INTO `oa_city` VALUES (370613, '莱山区', 3, 370600, ',370000,370600,370613,');
INSERT INTO `oa_city` VALUES (370634, '长岛县', 3, 370600, ',370000,370600,370634,');
INSERT INTO `oa_city` VALUES (370681, '龙口市', 3, 370600, ',370000,370600,370681,');
INSERT INTO `oa_city` VALUES (370682, '莱阳市', 3, 370600, ',370000,370600,370682,');
INSERT INTO `oa_city` VALUES (370683, '莱州市', 3, 370600, ',370000,370600,370683,');
INSERT INTO `oa_city` VALUES (370684, '蓬莱市', 3, 370600, ',370000,370600,370684,');
INSERT INTO `oa_city` VALUES (370685, '招远市', 3, 370600, ',370000,370600,370685,');
INSERT INTO `oa_city` VALUES (370686, '栖霞市', 3, 370600, ',370000,370600,370686,');
INSERT INTO `oa_city` VALUES (370687, '海阳市', 3, 370600, ',370000,370600,370687,');
INSERT INTO `oa_city` VALUES (370700, '潍坊市', 2, 370000, ',370000,370700,');
INSERT INTO `oa_city` VALUES (370702, '潍城区', 3, 370700, ',370000,370700,370702,');
INSERT INTO `oa_city` VALUES (370703, '寒亭区', 3, 370700, ',370000,370700,370703,');
INSERT INTO `oa_city` VALUES (370704, '坊子区', 3, 370700, ',370000,370700,370704,');
INSERT INTO `oa_city` VALUES (370705, '奎文区', 3, 370700, ',370000,370700,370705,');
INSERT INTO `oa_city` VALUES (370724, '临朐县', 3, 370700, ',370000,370700,370724,');
INSERT INTO `oa_city` VALUES (370725, '昌乐县', 3, 370700, ',370000,370700,370725,');
INSERT INTO `oa_city` VALUES (370781, '青州市', 3, 370700, ',370000,370700,370781,');
INSERT INTO `oa_city` VALUES (370782, '诸城市', 3, 370700, ',370000,370700,370782,');
INSERT INTO `oa_city` VALUES (370783, '寿光市', 3, 370700, ',370000,370700,370783,');
INSERT INTO `oa_city` VALUES (370784, '安丘市', 3, 370700, ',370000,370700,370784,');
INSERT INTO `oa_city` VALUES (370785, '高密市', 3, 370700, ',370000,370700,370785,');
INSERT INTO `oa_city` VALUES (370786, '昌邑市', 3, 370700, ',370000,370700,370786,');
INSERT INTO `oa_city` VALUES (370800, '济宁市', 2, 370000, ',370000,370800,');
INSERT INTO `oa_city` VALUES (370802, '市中区', 3, 370800, ',370000,370800,370802,');
INSERT INTO `oa_city` VALUES (370811, '任城区', 3, 370800, ',370000,370800,370811,');
INSERT INTO `oa_city` VALUES (370826, '微山县', 3, 370800, ',370000,370800,370826,');
INSERT INTO `oa_city` VALUES (370827, '鱼台县', 3, 370800, ',370000,370800,370827,');
INSERT INTO `oa_city` VALUES (370828, '金乡县', 3, 370800, ',370000,370800,370828,');
INSERT INTO `oa_city` VALUES (370829, '嘉祥县', 3, 370800, ',370000,370800,370829,');
INSERT INTO `oa_city` VALUES (370830, '汶上县', 3, 370800, ',370000,370800,370830,');
INSERT INTO `oa_city` VALUES (370831, '泗水县', 3, 370800, ',370000,370800,370831,');
INSERT INTO `oa_city` VALUES (370832, '梁山县', 3, 370800, ',370000,370800,370832,');
INSERT INTO `oa_city` VALUES (370881, '曲阜市', 3, 370800, ',370000,370800,370881,');
INSERT INTO `oa_city` VALUES (370882, '兖州市', 3, 370800, ',370000,370800,370882,');
INSERT INTO `oa_city` VALUES (370883, '邹城市', 3, 370800, ',370000,370800,370883,');
INSERT INTO `oa_city` VALUES (370900, '泰安市', 2, 370000, ',370000,370900,');
INSERT INTO `oa_city` VALUES (370902, '泰山区', 3, 370900, ',370000,370900,370902,');
INSERT INTO `oa_city` VALUES (370903, '岱岳区', 3, 370900, ',370000,370900,370903,');
INSERT INTO `oa_city` VALUES (370921, '宁阳县', 3, 370900, ',370000,370900,370921,');
INSERT INTO `oa_city` VALUES (370923, '东平县', 3, 370900, ',370000,370900,370923,');
INSERT INTO `oa_city` VALUES (370982, '新泰市', 3, 370900, ',370000,370900,370982,');
INSERT INTO `oa_city` VALUES (370983, '肥城市', 3, 370900, ',370000,370900,370983,');
INSERT INTO `oa_city` VALUES (371000, '威海市', 2, 370000, ',370000,371000,');
INSERT INTO `oa_city` VALUES (371002, '环翠区', 3, 371000, ',370000,371000,371002,');
INSERT INTO `oa_city` VALUES (371081, '文登市', 3, 371000, ',370000,371000,371081,');
INSERT INTO `oa_city` VALUES (371082, '荣成市', 3, 371000, ',370000,371000,371082,');
INSERT INTO `oa_city` VALUES (371083, '乳山市', 3, 371000, ',370000,371000,371083,');
INSERT INTO `oa_city` VALUES (371100, '日照市', 2, 370000, ',370000,371100,');
INSERT INTO `oa_city` VALUES (371102, '东港区', 3, 371100, ',370000,371100,371102,');
INSERT INTO `oa_city` VALUES (371103, '岚山区', 3, 371100, ',370000,371100,371103,');
INSERT INTO `oa_city` VALUES (371121, '五莲县', 3, 371100, ',370000,371100,371121,');
INSERT INTO `oa_city` VALUES (371122, '莒　县', 3, 371100, ',370000,371100,371122,');
INSERT INTO `oa_city` VALUES (371200, '莱芜市', 2, 370000, ',370000,371200,');
INSERT INTO `oa_city` VALUES (371202, '莱城区', 3, 371200, ',370000,371200,371202,');
INSERT INTO `oa_city` VALUES (371203, '钢城区', 3, 371200, ',370000,371200,371203,');
INSERT INTO `oa_city` VALUES (371300, '临沂市', 2, 370000, ',370000,371300,');
INSERT INTO `oa_city` VALUES (371302, '兰山区', 3, 371300, ',370000,371300,371302,');
INSERT INTO `oa_city` VALUES (371311, '罗庄区', 3, 371300, ',370000,371300,371311,');
INSERT INTO `oa_city` VALUES (371312, '河东区', 3, 371300, ',370000,371300,371312,');
INSERT INTO `oa_city` VALUES (371321, '沂南县', 3, 371300, ',370000,371300,371321,');
INSERT INTO `oa_city` VALUES (371322, '郯城县', 3, 371300, ',370000,371300,371322,');
INSERT INTO `oa_city` VALUES (371323, '沂水县', 3, 371300, ',370000,371300,371323,');
INSERT INTO `oa_city` VALUES (371324, '苍山县', 3, 371300, ',370000,371300,371324,');
INSERT INTO `oa_city` VALUES (371325, '费　县', 3, 371300, ',370000,371300,371325,');
INSERT INTO `oa_city` VALUES (371326, '平邑县', 3, 371300, ',370000,371300,371326,');
INSERT INTO `oa_city` VALUES (371327, '莒南县', 3, 371300, ',370000,371300,371327,');
INSERT INTO `oa_city` VALUES (371328, '蒙阴县', 3, 371300, ',370000,371300,371328,');
INSERT INTO `oa_city` VALUES (371329, '临沭县', 3, 371300, ',370000,371300,371329,');
INSERT INTO `oa_city` VALUES (371400, '德州市', 2, 370000, ',370000,371400,');
INSERT INTO `oa_city` VALUES (371402, '德城区', 3, 371400, ',370000,371400,371402,');
INSERT INTO `oa_city` VALUES (371421, '陵　县', 3, 371400, ',370000,371400,371421,');
INSERT INTO `oa_city` VALUES (371422, '宁津县', 3, 371400, ',370000,371400,371422,');
INSERT INTO `oa_city` VALUES (371423, '庆云县', 3, 371400, ',370000,371400,371423,');
INSERT INTO `oa_city` VALUES (371424, '临邑县', 3, 371400, ',370000,371400,371424,');
INSERT INTO `oa_city` VALUES (371425, '齐河县', 3, 371400, ',370000,371400,371425,');
INSERT INTO `oa_city` VALUES (371426, '平原县', 3, 371400, ',370000,371400,371426,');
INSERT INTO `oa_city` VALUES (371427, '夏津县', 3, 371400, ',370000,371400,371427,');
INSERT INTO `oa_city` VALUES (371428, '武城县', 3, 371400, ',370000,371400,371428,');
INSERT INTO `oa_city` VALUES (371481, '乐陵市', 3, 371400, ',370000,371400,371481,');
INSERT INTO `oa_city` VALUES (371482, '禹城市', 3, 371400, ',370000,371400,371482,');
INSERT INTO `oa_city` VALUES (371500, '聊城市', 2, 370000, ',370000,371500,');
INSERT INTO `oa_city` VALUES (371502, '东昌府区', 3, 371500, ',370000,371500,371502,');
INSERT INTO `oa_city` VALUES (371521, '阳谷县', 3, 371500, ',370000,371500,371521,');
INSERT INTO `oa_city` VALUES (371522, '莘　县', 3, 371500, ',370000,371500,371522,');
INSERT INTO `oa_city` VALUES (371523, '茌平县', 3, 371500, ',370000,371500,371523,');
INSERT INTO `oa_city` VALUES (371524, '东阿县', 3, 371500, ',370000,371500,371524,');
INSERT INTO `oa_city` VALUES (371525, '冠　县', 3, 371500, ',370000,371500,371525,');
INSERT INTO `oa_city` VALUES (371526, '高唐县', 3, 371500, ',370000,371500,371526,');
INSERT INTO `oa_city` VALUES (371581, '临清市', 3, 371500, ',370000,371500,371581,');
INSERT INTO `oa_city` VALUES (371600, '滨州市', 2, 370000, ',370000,371600,');
INSERT INTO `oa_city` VALUES (371602, '滨城区', 3, 371600, ',370000,371600,371602,');
INSERT INTO `oa_city` VALUES (371621, '惠民县', 3, 371600, ',370000,371600,371621,');
INSERT INTO `oa_city` VALUES (371622, '阳信县', 3, 371600, ',370000,371600,371622,');
INSERT INTO `oa_city` VALUES (371623, '无棣县', 3, 371600, ',370000,371600,371623,');
INSERT INTO `oa_city` VALUES (371624, '沾化县', 3, 371600, ',370000,371600,371624,');
INSERT INTO `oa_city` VALUES (371625, '博兴县', 3, 371600, ',370000,371600,371625,');
INSERT INTO `oa_city` VALUES (371626, '邹平县', 3, 371600, ',370000,371600,371626,');
INSERT INTO `oa_city` VALUES (371700, '菏泽市', 2, 370000, ',370000,371700,');
INSERT INTO `oa_city` VALUES (371702, '牡丹区', 3, 371700, ',370000,371700,371702,');
INSERT INTO `oa_city` VALUES (371721, '曹　县', 3, 371700, ',370000,371700,371721,');
INSERT INTO `oa_city` VALUES (371722, '单　县', 3, 371700, ',370000,371700,371722,');
INSERT INTO `oa_city` VALUES (371723, '成武县', 3, 371700, ',370000,371700,371723,');
INSERT INTO `oa_city` VALUES (371724, '巨野县', 3, 371700, ',370000,371700,371724,');
INSERT INTO `oa_city` VALUES (371725, '郓城县', 3, 371700, ',370000,371700,371725,');
INSERT INTO `oa_city` VALUES (371726, '鄄城县', 3, 371700, ',370000,371700,371726,');
INSERT INTO `oa_city` VALUES (371727, '定陶县', 3, 371700, ',370000,371700,371727,');
INSERT INTO `oa_city` VALUES (371728, '东明县', 3, 371700, ',370000,371700,371728,');
INSERT INTO `oa_city` VALUES (410000, '河南省', 1, 0, ',410000,');
INSERT INTO `oa_city` VALUES (410100, '郑州市', 2, 410000, ',410000,410100,');
INSERT INTO `oa_city` VALUES (410102, '中原区', 3, 410100, ',410000,410100,410102,');
INSERT INTO `oa_city` VALUES (410103, '二七区', 3, 410100, ',410000,410100,410103,');
INSERT INTO `oa_city` VALUES (410104, '管城回族区', 3, 410100, ',410000,410100,410104,');
INSERT INTO `oa_city` VALUES (410105, '金水区', 3, 410100, ',410000,410100,410105,');
INSERT INTO `oa_city` VALUES (410106, '上街区', 3, 410100, ',410000,410100,410106,');
INSERT INTO `oa_city` VALUES (410108, '邙山区', 3, 410100, ',410000,410100,410108,');
INSERT INTO `oa_city` VALUES (410122, '中牟县', 3, 410100, ',410000,410100,410122,');
INSERT INTO `oa_city` VALUES (410181, '巩义市', 3, 410100, ',410000,410100,410181,');
INSERT INTO `oa_city` VALUES (410182, '荥阳市', 3, 410100, ',410000,410100,410182,');
INSERT INTO `oa_city` VALUES (410183, '新密市', 3, 410100, ',410000,410100,410183,');
INSERT INTO `oa_city` VALUES (410184, '新郑市', 3, 410100, ',410000,410100,410184,');
INSERT INTO `oa_city` VALUES (410185, '登封市', 3, 410100, ',410000,410100,410185,');
INSERT INTO `oa_city` VALUES (410200, '开封市', 2, 410000, ',410000,410200,');
INSERT INTO `oa_city` VALUES (410202, '龙亭区', 3, 410200, ',410000,410200,410202,');
INSERT INTO `oa_city` VALUES (410203, '顺河回族区', 3, 410200, ',410000,410200,410203,');
INSERT INTO `oa_city` VALUES (410204, '鼓楼区', 3, 410200, ',410000,410200,410204,');
INSERT INTO `oa_city` VALUES (410205, '南关区', 3, 410200, ',410000,410200,410205,');
INSERT INTO `oa_city` VALUES (410211, '郊　区', 3, 410200, ',410000,410200,410211,');
INSERT INTO `oa_city` VALUES (410221, '杞　县', 3, 410200, ',410000,410200,410221,');
INSERT INTO `oa_city` VALUES (410222, '通许县', 3, 410200, ',410000,410200,410222,');
INSERT INTO `oa_city` VALUES (410223, '尉氏县', 3, 410200, ',410000,410200,410223,');
INSERT INTO `oa_city` VALUES (410224, '开封县', 3, 410200, ',410000,410200,410224,');
INSERT INTO `oa_city` VALUES (410225, '兰考县', 3, 410200, ',410000,410200,410225,');
INSERT INTO `oa_city` VALUES (410300, '洛阳市', 2, 410000, ',410000,410300,');
INSERT INTO `oa_city` VALUES (410302, '老城区', 3, 410300, ',410000,410300,410302,');
INSERT INTO `oa_city` VALUES (410303, '西工区', 3, 410300, ',410000,410300,410303,');
INSERT INTO `oa_city` VALUES (410304, '廛河回族区', 3, 410300, ',410000,410300,410304,');
INSERT INTO `oa_city` VALUES (410305, '涧西区', 3, 410300, ',410000,410300,410305,');
INSERT INTO `oa_city` VALUES (410306, '吉利区', 3, 410300, ',410000,410300,410306,');
INSERT INTO `oa_city` VALUES (410307, '洛龙区', 3, 410300, ',410000,410300,410307,');
INSERT INTO `oa_city` VALUES (410322, '孟津县', 3, 410300, ',410000,410300,410322,');
INSERT INTO `oa_city` VALUES (410323, '新安县', 3, 410300, ',410000,410300,410323,');
INSERT INTO `oa_city` VALUES (410324, '栾川县', 3, 410300, ',410000,410300,410324,');
INSERT INTO `oa_city` VALUES (410325, '嵩　县', 3, 410300, ',410000,410300,410325,');
INSERT INTO `oa_city` VALUES (410326, '汝阳县', 3, 410300, ',410000,410300,410326,');
INSERT INTO `oa_city` VALUES (410327, '宜阳县', 3, 410300, ',410000,410300,410327,');
INSERT INTO `oa_city` VALUES (410328, '洛宁县', 3, 410300, ',410000,410300,410328,');
INSERT INTO `oa_city` VALUES (410329, '伊川县', 3, 410300, ',410000,410300,410329,');
INSERT INTO `oa_city` VALUES (410381, '偃师市', 3, 410300, ',410000,410300,410381,');
INSERT INTO `oa_city` VALUES (410400, '平顶山市', 2, 410000, ',410000,410400,');
INSERT INTO `oa_city` VALUES (410402, '新华区', 3, 410400, ',410000,410400,410402,');
INSERT INTO `oa_city` VALUES (410403, '卫东区', 3, 410400, ',410000,410400,410403,');
INSERT INTO `oa_city` VALUES (410404, '石龙区', 3, 410400, ',410000,410400,410404,');
INSERT INTO `oa_city` VALUES (410411, '湛河区', 3, 410400, ',410000,410400,410411,');
INSERT INTO `oa_city` VALUES (410421, '宝丰县', 3, 410400, ',410000,410400,410421,');
INSERT INTO `oa_city` VALUES (410422, '叶　县', 3, 410400, ',410000,410400,410422,');
INSERT INTO `oa_city` VALUES (410423, '鲁山县', 3, 410400, ',410000,410400,410423,');
INSERT INTO `oa_city` VALUES (410425, '郏　县', 3, 410400, ',410000,410400,410425,');
INSERT INTO `oa_city` VALUES (410481, '舞钢市', 3, 410400, ',410000,410400,410481,');
INSERT INTO `oa_city` VALUES (410482, '汝州市', 3, 410400, ',410000,410400,410482,');
INSERT INTO `oa_city` VALUES (410500, '安阳市', 2, 410000, ',410000,410500,');
INSERT INTO `oa_city` VALUES (410502, '文峰区', 3, 410500, ',410000,410500,410502,');
INSERT INTO `oa_city` VALUES (410503, '北关区', 3, 410500, ',410000,410500,410503,');
INSERT INTO `oa_city` VALUES (410505, '殷都区', 3, 410500, ',410000,410500,410505,');
INSERT INTO `oa_city` VALUES (410506, '龙安区', 3, 410500, ',410000,410500,410506,');
INSERT INTO `oa_city` VALUES (410522, '安阳县', 3, 410500, ',410000,410500,410522,');
INSERT INTO `oa_city` VALUES (410523, '汤阴县', 3, 410500, ',410000,410500,410523,');
INSERT INTO `oa_city` VALUES (410526, '滑　县', 3, 410500, ',410000,410500,410526,');
INSERT INTO `oa_city` VALUES (410527, '内黄县', 3, 410500, ',410000,410500,410527,');
INSERT INTO `oa_city` VALUES (410581, '林州市', 3, 410500, ',410000,410500,410581,');
INSERT INTO `oa_city` VALUES (410600, '鹤壁市', 2, 410000, ',410000,410600,');
INSERT INTO `oa_city` VALUES (410602, '鹤山区', 3, 410600, ',410000,410600,410602,');
INSERT INTO `oa_city` VALUES (410603, '山城区', 3, 410600, ',410000,410600,410603,');
INSERT INTO `oa_city` VALUES (410611, '淇滨区', 3, 410600, ',410000,410600,410611,');
INSERT INTO `oa_city` VALUES (410621, '浚　县', 3, 410600, ',410000,410600,410621,');
INSERT INTO `oa_city` VALUES (410622, '淇　县', 3, 410600, ',410000,410600,410622,');
INSERT INTO `oa_city` VALUES (410700, '新乡市', 2, 410000, ',410000,410700,');
INSERT INTO `oa_city` VALUES (410702, '红旗区', 3, 410700, ',410000,410700,410702,');
INSERT INTO `oa_city` VALUES (410703, '卫滨区', 3, 410700, ',410000,410700,410703,');
INSERT INTO `oa_city` VALUES (410704, '凤泉区', 3, 410700, ',410000,410700,410704,');
INSERT INTO `oa_city` VALUES (410711, '牧野区', 3, 410700, ',410000,410700,410711,');
INSERT INTO `oa_city` VALUES (410721, '新乡县', 3, 410700, ',410000,410700,410721,');
INSERT INTO `oa_city` VALUES (410724, '获嘉县', 3, 410700, ',410000,410700,410724,');
INSERT INTO `oa_city` VALUES (410725, '原阳县', 3, 410700, ',410000,410700,410725,');
INSERT INTO `oa_city` VALUES (410726, '延津县', 3, 410700, ',410000,410700,410726,');
INSERT INTO `oa_city` VALUES (410727, '封丘县', 3, 410700, ',410000,410700,410727,');
INSERT INTO `oa_city` VALUES (410728, '长垣县', 3, 410700, ',410000,410700,410728,');
INSERT INTO `oa_city` VALUES (410781, '卫辉市', 3, 410700, ',410000,410700,410781,');
INSERT INTO `oa_city` VALUES (410782, '辉县市', 3, 410700, ',410000,410700,410782,');
INSERT INTO `oa_city` VALUES (410800, '焦作市', 2, 410000, ',410000,410800,');
INSERT INTO `oa_city` VALUES (410802, '解放区', 3, 410800, ',410000,410800,410802,');
INSERT INTO `oa_city` VALUES (410803, '中站区', 3, 410800, ',410000,410800,410803,');
INSERT INTO `oa_city` VALUES (410804, '马村区', 3, 410800, ',410000,410800,410804,');
INSERT INTO `oa_city` VALUES (410811, '山阳区', 3, 410800, ',410000,410800,410811,');
INSERT INTO `oa_city` VALUES (410821, '修武县', 3, 410800, ',410000,410800,410821,');
INSERT INTO `oa_city` VALUES (410822, '博爱县', 3, 410800, ',410000,410800,410822,');
INSERT INTO `oa_city` VALUES (410823, '武陟县', 3, 410800, ',410000,410800,410823,');
INSERT INTO `oa_city` VALUES (410825, '温　县', 3, 410800, ',410000,410800,410825,');
INSERT INTO `oa_city` VALUES (410881, '济源市', 3, 410800, ',410000,410800,410881,');
INSERT INTO `oa_city` VALUES (410882, '沁阳市', 3, 410800, ',410000,410800,410882,');
INSERT INTO `oa_city` VALUES (410883, '孟州市', 3, 410800, ',410000,410800,410883,');
INSERT INTO `oa_city` VALUES (410900, '濮阳市', 2, 410000, ',410000,410900,');
INSERT INTO `oa_city` VALUES (410902, '华龙区', 3, 410900, ',410000,410900,410902,');
INSERT INTO `oa_city` VALUES (410922, '清丰县', 3, 410900, ',410000,410900,410922,');
INSERT INTO `oa_city` VALUES (410923, '南乐县', 3, 410900, ',410000,410900,410923,');
INSERT INTO `oa_city` VALUES (410926, '范　县', 3, 410900, ',410000,410900,410926,');
INSERT INTO `oa_city` VALUES (410927, '台前县', 3, 410900, ',410000,410900,410927,');
INSERT INTO `oa_city` VALUES (410928, '濮阳县', 3, 410900, ',410000,410900,410928,');
INSERT INTO `oa_city` VALUES (411000, '许昌市', 2, 410000, ',410000,411000,');
INSERT INTO `oa_city` VALUES (411002, '魏都区', 3, 411000, ',410000,411000,411002,');
INSERT INTO `oa_city` VALUES (411023, '许昌县', 3, 411000, ',410000,411000,411023,');
INSERT INTO `oa_city` VALUES (411024, '鄢陵县', 3, 411000, ',410000,411000,411024,');
INSERT INTO `oa_city` VALUES (411025, '襄城县', 3, 411000, ',410000,411000,411025,');
INSERT INTO `oa_city` VALUES (411081, '禹州市', 3, 411000, ',410000,411000,411081,');
INSERT INTO `oa_city` VALUES (411082, '长葛市', 3, 411000, ',410000,411000,411082,');
INSERT INTO `oa_city` VALUES (411100, '漯河市', 2, 410000, ',410000,411100,');
INSERT INTO `oa_city` VALUES (411102, '源汇区', 3, 411100, ',410000,411100,411102,');
INSERT INTO `oa_city` VALUES (411103, '郾城区', 3, 411100, ',410000,411100,411103,');
INSERT INTO `oa_city` VALUES (411104, '召陵区', 3, 411100, ',410000,411100,411104,');
INSERT INTO `oa_city` VALUES (411121, '舞阳县', 3, 411100, ',410000,411100,411121,');
INSERT INTO `oa_city` VALUES (411122, '临颍县', 3, 411100, ',410000,411100,411122,');
INSERT INTO `oa_city` VALUES (411200, '三门峡市', 2, 410000, ',410000,411200,');
INSERT INTO `oa_city` VALUES (411202, '湖滨区', 3, 411200, ',410000,411200,411202,');
INSERT INTO `oa_city` VALUES (411221, '渑池县', 3, 411200, ',410000,411200,411221,');
INSERT INTO `oa_city` VALUES (411222, '陕　县', 3, 411200, ',410000,411200,411222,');
INSERT INTO `oa_city` VALUES (411224, '卢氏县', 3, 411200, ',410000,411200,411224,');
INSERT INTO `oa_city` VALUES (411281, '义马市', 3, 411200, ',410000,411200,411281,');
INSERT INTO `oa_city` VALUES (411282, '灵宝市', 3, 411200, ',410000,411200,411282,');
INSERT INTO `oa_city` VALUES (411300, '南阳市', 2, 410000, ',410000,411300,');
INSERT INTO `oa_city` VALUES (411302, '宛城区', 3, 411300, ',410000,411300,411302,');
INSERT INTO `oa_city` VALUES (411303, '卧龙区', 3, 411300, ',410000,411300,411303,');
INSERT INTO `oa_city` VALUES (411321, '南召县', 3, 411300, ',410000,411300,411321,');
INSERT INTO `oa_city` VALUES (411322, '方城县', 3, 411300, ',410000,411300,411322,');
INSERT INTO `oa_city` VALUES (411323, '西峡县', 3, 411300, ',410000,411300,411323,');
INSERT INTO `oa_city` VALUES (411324, '镇平县', 3, 411300, ',410000,411300,411324,');
INSERT INTO `oa_city` VALUES (411325, '内乡县', 3, 411300, ',410000,411300,411325,');
INSERT INTO `oa_city` VALUES (411326, '淅川县', 3, 411300, ',410000,411300,411326,');
INSERT INTO `oa_city` VALUES (411327, '社旗县', 3, 411300, ',410000,411300,411327,');
INSERT INTO `oa_city` VALUES (411328, '唐河县', 3, 411300, ',410000,411300,411328,');
INSERT INTO `oa_city` VALUES (411329, '新野县', 3, 411300, ',410000,411300,411329,');
INSERT INTO `oa_city` VALUES (411330, '桐柏县', 3, 411300, ',410000,411300,411330,');
INSERT INTO `oa_city` VALUES (411381, '邓州市', 3, 411300, ',410000,411300,411381,');
INSERT INTO `oa_city` VALUES (411400, '商丘市', 2, 410000, ',410000,411400,');
INSERT INTO `oa_city` VALUES (411402, '梁园区', 3, 411400, ',410000,411400,411402,');
INSERT INTO `oa_city` VALUES (411403, '睢阳区', 3, 411400, ',410000,411400,411403,');
INSERT INTO `oa_city` VALUES (411421, '民权县', 3, 411400, ',410000,411400,411421,');
INSERT INTO `oa_city` VALUES (411422, '睢　县', 3, 411400, ',410000,411400,411422,');
INSERT INTO `oa_city` VALUES (411423, '宁陵县', 3, 411400, ',410000,411400,411423,');
INSERT INTO `oa_city` VALUES (411424, '柘城县', 3, 411400, ',410000,411400,411424,');
INSERT INTO `oa_city` VALUES (411425, '虞城县', 3, 411400, ',410000,411400,411425,');
INSERT INTO `oa_city` VALUES (411426, '夏邑县', 3, 411400, ',410000,411400,411426,');
INSERT INTO `oa_city` VALUES (411481, '永城市', 3, 411400, ',410000,411400,411481,');
INSERT INTO `oa_city` VALUES (411500, '信阳市', 2, 410000, ',410000,411500,');
INSERT INTO `oa_city` VALUES (411502, '师河区', 3, 411500, ',410000,411500,411502,');
INSERT INTO `oa_city` VALUES (411503, '平桥区', 3, 411500, ',410000,411500,411503,');
INSERT INTO `oa_city` VALUES (411521, '罗山县', 3, 411500, ',410000,411500,411521,');
INSERT INTO `oa_city` VALUES (411522, '光山县', 3, 411500, ',410000,411500,411522,');
INSERT INTO `oa_city` VALUES (411523, '新　县', 3, 411500, ',410000,411500,411523,');
INSERT INTO `oa_city` VALUES (411524, '商城县', 3, 411500, ',410000,411500,411524,');
INSERT INTO `oa_city` VALUES (411525, '固始县', 3, 411500, ',410000,411500,411525,');
INSERT INTO `oa_city` VALUES (411526, '潢川县', 3, 411500, ',410000,411500,411526,');
INSERT INTO `oa_city` VALUES (411527, '淮滨县', 3, 411500, ',410000,411500,411527,');
INSERT INTO `oa_city` VALUES (411528, '息　县', 3, 411500, ',410000,411500,411528,');
INSERT INTO `oa_city` VALUES (411600, '周口市', 2, 410000, ',410000,411600,');
INSERT INTO `oa_city` VALUES (411602, '川汇区', 3, 411600, ',410000,411600,411602,');
INSERT INTO `oa_city` VALUES (411621, '扶沟县', 3, 411600, ',410000,411600,411621,');
INSERT INTO `oa_city` VALUES (411622, '西华县', 3, 411600, ',410000,411600,411622,');
INSERT INTO `oa_city` VALUES (411623, '商水县', 3, 411600, ',410000,411600,411623,');
INSERT INTO `oa_city` VALUES (411624, '沈丘县', 3, 411600, ',410000,411600,411624,');
INSERT INTO `oa_city` VALUES (411625, '郸城县', 3, 411600, ',410000,411600,411625,');
INSERT INTO `oa_city` VALUES (411626, '淮阳县', 3, 411600, ',410000,411600,411626,');
INSERT INTO `oa_city` VALUES (411627, '太康县', 3, 411600, ',410000,411600,411627,');
INSERT INTO `oa_city` VALUES (411628, '鹿邑县', 3, 411600, ',410000,411600,411628,');
INSERT INTO `oa_city` VALUES (411681, '项城市', 3, 411600, ',410000,411600,411681,');
INSERT INTO `oa_city` VALUES (411700, '驻马店市', 2, 410000, ',410000,411700,');
INSERT INTO `oa_city` VALUES (411702, '驿城区', 3, 411700, ',410000,411700,411702,');
INSERT INTO `oa_city` VALUES (411721, '西平县', 3, 411700, ',410000,411700,411721,');
INSERT INTO `oa_city` VALUES (411722, '上蔡县', 3, 411700, ',410000,411700,411722,');
INSERT INTO `oa_city` VALUES (411723, '平舆县', 3, 411700, ',410000,411700,411723,');
INSERT INTO `oa_city` VALUES (411724, '正阳县', 3, 411700, ',410000,411700,411724,');
INSERT INTO `oa_city` VALUES (411725, '确山县', 3, 411700, ',410000,411700,411725,');
INSERT INTO `oa_city` VALUES (411726, '泌阳县', 3, 411700, ',410000,411700,411726,');
INSERT INTO `oa_city` VALUES (411727, '汝南县', 3, 411700, ',410000,411700,411727,');
INSERT INTO `oa_city` VALUES (411728, '遂平县', 3, 411700, ',410000,411700,411728,');
INSERT INTO `oa_city` VALUES (411729, '新蔡县', 3, 411700, ',410000,411700,411729,');
INSERT INTO `oa_city` VALUES (420000, '湖北省', 1, 0, ',420000,');
INSERT INTO `oa_city` VALUES (420100, '武汉市', 2, 420000, ',420000,420100,');
INSERT INTO `oa_city` VALUES (420102, '江岸区', 3, 420100, ',420000,420100,420102,');
INSERT INTO `oa_city` VALUES (420103, '江汉区', 3, 420100, ',420000,420100,420103,');
INSERT INTO `oa_city` VALUES (420104, '乔口区', 3, 420100, ',420000,420100,420104,');
INSERT INTO `oa_city` VALUES (420105, '汉阳区', 3, 420100, ',420000,420100,420105,');
INSERT INTO `oa_city` VALUES (420106, '武昌区', 3, 420100, ',420000,420100,420106,');
INSERT INTO `oa_city` VALUES (420107, '青山区', 3, 420100, ',420000,420100,420107,');
INSERT INTO `oa_city` VALUES (420111, '洪山区', 3, 420100, ',420000,420100,420111,');
INSERT INTO `oa_city` VALUES (420112, '东西湖区', 3, 420100, ',420000,420100,420112,');
INSERT INTO `oa_city` VALUES (420113, '汉南区', 3, 420100, ',420000,420100,420113,');
INSERT INTO `oa_city` VALUES (420114, '蔡甸区', 3, 420100, ',420000,420100,420114,');
INSERT INTO `oa_city` VALUES (420115, '江夏区', 3, 420100, ',420000,420100,420115,');
INSERT INTO `oa_city` VALUES (420116, '黄陂区', 3, 420100, ',420000,420100,420116,');
INSERT INTO `oa_city` VALUES (420117, '新洲区', 3, 420100, ',420000,420100,420117,');
INSERT INTO `oa_city` VALUES (420200, '黄石市', 2, 420000, ',420000,420200,');
INSERT INTO `oa_city` VALUES (420202, '黄石港区', 3, 420200, ',420000,420200,420202,');
INSERT INTO `oa_city` VALUES (420203, '西塞山区', 3, 420200, ',420000,420200,420203,');
INSERT INTO `oa_city` VALUES (420204, '下陆区', 3, 420200, ',420000,420200,420204,');
INSERT INTO `oa_city` VALUES (420205, '铁山区', 3, 420200, ',420000,420200,420205,');
INSERT INTO `oa_city` VALUES (420222, '阳新县', 3, 420200, ',420000,420200,420222,');
INSERT INTO `oa_city` VALUES (420281, '大冶市', 3, 420200, ',420000,420200,420281,');
INSERT INTO `oa_city` VALUES (420300, '十堰市', 2, 420000, ',420000,420300,');
INSERT INTO `oa_city` VALUES (420302, '茅箭区', 3, 420300, ',420000,420300,420302,');
INSERT INTO `oa_city` VALUES (420303, '张湾区', 3, 420300, ',420000,420300,420303,');
INSERT INTO `oa_city` VALUES (420321, '郧　县', 3, 420300, ',420000,420300,420321,');
INSERT INTO `oa_city` VALUES (420322, '郧西县', 3, 420300, ',420000,420300,420322,');
INSERT INTO `oa_city` VALUES (420323, '竹山县', 3, 420300, ',420000,420300,420323,');
INSERT INTO `oa_city` VALUES (420324, '竹溪县', 3, 420300, ',420000,420300,420324,');
INSERT INTO `oa_city` VALUES (420325, '房　县', 3, 420300, ',420000,420300,420325,');
INSERT INTO `oa_city` VALUES (420381, '丹江口市', 3, 420300, ',420000,420300,420381,');
INSERT INTO `oa_city` VALUES (420500, '宜昌市', 2, 420000, ',420000,420500,');
INSERT INTO `oa_city` VALUES (420502, '西陵区', 3, 420500, ',420000,420500,420502,');
INSERT INTO `oa_city` VALUES (420503, '伍家岗区', 3, 420500, ',420000,420500,420503,');
INSERT INTO `oa_city` VALUES (420504, '点军区', 3, 420500, ',420000,420500,420504,');
INSERT INTO `oa_city` VALUES (420505, '猇亭区', 3, 420500, ',420000,420500,420505,');
INSERT INTO `oa_city` VALUES (420506, '夷陵区', 3, 420500, ',420000,420500,420506,');
INSERT INTO `oa_city` VALUES (420525, '远安县', 3, 420500, ',420000,420500,420525,');
INSERT INTO `oa_city` VALUES (420526, '兴山县', 3, 420500, ',420000,420500,420526,');
INSERT INTO `oa_city` VALUES (420527, '秭归县', 3, 420500, ',420000,420500,420527,');
INSERT INTO `oa_city` VALUES (420528, '长阳土家族自治县', 3, 420500, ',420000,420500,420528,');
INSERT INTO `oa_city` VALUES (420529, '五峰土家族自治县', 3, 420500, ',420000,420500,420529,');
INSERT INTO `oa_city` VALUES (420581, '宜都市', 3, 420500, ',420000,420500,420581,');
INSERT INTO `oa_city` VALUES (420582, '当阳市', 3, 420500, ',420000,420500,420582,');
INSERT INTO `oa_city` VALUES (420583, '枝江市', 3, 420500, ',420000,420500,420583,');
INSERT INTO `oa_city` VALUES (420600, '襄樊市', 2, 420000, ',420000,420600,');
INSERT INTO `oa_city` VALUES (420602, '襄城区', 3, 420600, ',420000,420600,420602,');
INSERT INTO `oa_city` VALUES (420606, '樊城区', 3, 420600, ',420000,420600,420606,');
INSERT INTO `oa_city` VALUES (420607, '襄阳区', 3, 420600, ',420000,420600,420607,');
INSERT INTO `oa_city` VALUES (420624, '南漳县', 3, 420600, ',420000,420600,420624,');
INSERT INTO `oa_city` VALUES (420625, '谷城县', 3, 420600, ',420000,420600,420625,');
INSERT INTO `oa_city` VALUES (420626, '保康县', 3, 420600, ',420000,420600,420626,');
INSERT INTO `oa_city` VALUES (420682, '老河口市', 3, 420600, ',420000,420600,420682,');
INSERT INTO `oa_city` VALUES (420683, '枣阳市', 3, 420600, ',420000,420600,420683,');
INSERT INTO `oa_city` VALUES (420684, '宜城市', 3, 420600, ',420000,420600,420684,');
INSERT INTO `oa_city` VALUES (420700, '鄂州市', 2, 420000, ',420000,420700,');
INSERT INTO `oa_city` VALUES (420702, '梁子湖区', 3, 420700, ',420000,420700,420702,');
INSERT INTO `oa_city` VALUES (420703, '华容区', 3, 420700, ',420000,420700,420703,');
INSERT INTO `oa_city` VALUES (420704, '鄂城区', 3, 420700, ',420000,420700,420704,');
INSERT INTO `oa_city` VALUES (420800, '荆门市', 2, 420000, ',420000,420800,');
INSERT INTO `oa_city` VALUES (420802, '东宝区', 3, 420800, ',420000,420800,420802,');
INSERT INTO `oa_city` VALUES (420804, '掇刀区', 3, 420800, ',420000,420800,420804,');
INSERT INTO `oa_city` VALUES (420821, '京山县', 3, 420800, ',420000,420800,420821,');
INSERT INTO `oa_city` VALUES (420822, '沙洋县', 3, 420800, ',420000,420800,420822,');
INSERT INTO `oa_city` VALUES (420881, '钟祥市', 3, 420800, ',420000,420800,420881,');
INSERT INTO `oa_city` VALUES (420900, '孝感市', 2, 420000, ',420000,420900,');
INSERT INTO `oa_city` VALUES (420902, '孝南区', 3, 420900, ',420000,420900,420902,');
INSERT INTO `oa_city` VALUES (420921, '孝昌县', 3, 420900, ',420000,420900,420921,');
INSERT INTO `oa_city` VALUES (420922, '大悟县', 3, 420900, ',420000,420900,420922,');
INSERT INTO `oa_city` VALUES (420923, '云梦县', 3, 420900, ',420000,420900,420923,');
INSERT INTO `oa_city` VALUES (420981, '应城市', 3, 420900, ',420000,420900,420981,');
INSERT INTO `oa_city` VALUES (420982, '安陆市', 3, 420900, ',420000,420900,420982,');
INSERT INTO `oa_city` VALUES (420984, '汉川市', 3, 420900, ',420000,420900,420984,');
INSERT INTO `oa_city` VALUES (421000, '荆州市', 2, 420000, ',420000,421000,');
INSERT INTO `oa_city` VALUES (421002, '沙市区', 3, 421000, ',420000,421000,421002,');
INSERT INTO `oa_city` VALUES (421003, '荆州区', 3, 421000, ',420000,421000,421003,');
INSERT INTO `oa_city` VALUES (421022, '公安县', 3, 421000, ',420000,421000,421022,');
INSERT INTO `oa_city` VALUES (421023, '监利县', 3, 421000, ',420000,421000,421023,');
INSERT INTO `oa_city` VALUES (421024, '江陵县', 3, 421000, ',420000,421000,421024,');
INSERT INTO `oa_city` VALUES (421081, '石首市', 3, 421000, ',420000,421000,421081,');
INSERT INTO `oa_city` VALUES (421083, '洪湖市', 3, 421000, ',420000,421000,421083,');
INSERT INTO `oa_city` VALUES (421087, '松滋市', 3, 421000, ',420000,421000,421087,');
INSERT INTO `oa_city` VALUES (421100, '黄冈市', 2, 420000, ',420000,421100,');
INSERT INTO `oa_city` VALUES (421102, '黄州区', 3, 421100, ',420000,421100,421102,');
INSERT INTO `oa_city` VALUES (421121, '团风县', 3, 421100, ',420000,421100,421121,');
INSERT INTO `oa_city` VALUES (421122, '红安县', 3, 421100, ',420000,421100,421122,');
INSERT INTO `oa_city` VALUES (421123, '罗田县', 3, 421100, ',420000,421100,421123,');
INSERT INTO `oa_city` VALUES (421124, '英山县', 3, 421100, ',420000,421100,421124,');
INSERT INTO `oa_city` VALUES (421125, '浠水县', 3, 421100, ',420000,421100,421125,');
INSERT INTO `oa_city` VALUES (421126, '蕲春县', 3, 421100, ',420000,421100,421126,');
INSERT INTO `oa_city` VALUES (421127, '黄梅县', 3, 421100, ',420000,421100,421127,');
INSERT INTO `oa_city` VALUES (421181, '麻城市', 3, 421100, ',420000,421100,421181,');
INSERT INTO `oa_city` VALUES (421182, '武穴市', 3, 421100, ',420000,421100,421182,');
INSERT INTO `oa_city` VALUES (421200, '咸宁市', 2, 420000, ',420000,421200,');
INSERT INTO `oa_city` VALUES (421202, '咸安区', 3, 421200, ',420000,421200,421202,');
INSERT INTO `oa_city` VALUES (421221, '嘉鱼县', 3, 421200, ',420000,421200,421221,');
INSERT INTO `oa_city` VALUES (421222, '通城县', 3, 421200, ',420000,421200,421222,');
INSERT INTO `oa_city` VALUES (421223, '崇阳县', 3, 421200, ',420000,421200,421223,');
INSERT INTO `oa_city` VALUES (421224, '通山县', 3, 421200, ',420000,421200,421224,');
INSERT INTO `oa_city` VALUES (421281, '赤壁市', 3, 421200, ',420000,421200,421281,');
INSERT INTO `oa_city` VALUES (421300, '随州市', 2, 420000, ',420000,421300,');
INSERT INTO `oa_city` VALUES (421302, '曾都区', 3, 421300, ',420000,421300,421302,');
INSERT INTO `oa_city` VALUES (421381, '广水市', 3, 421300, ',420000,421300,421381,');
INSERT INTO `oa_city` VALUES (422800, '恩施土家族苗族自治州', 2, 420000, ',420000,422800,');
INSERT INTO `oa_city` VALUES (422801, '恩施市', 3, 422800, ',420000,422800,422801,');
INSERT INTO `oa_city` VALUES (422802, '利川市', 3, 422800, ',420000,422800,422802,');
INSERT INTO `oa_city` VALUES (422822, '建始县', 3, 422800, ',420000,422800,422822,');
INSERT INTO `oa_city` VALUES (422823, '巴东县', 3, 422800, ',420000,422800,422823,');
INSERT INTO `oa_city` VALUES (422825, '宣恩县', 3, 422800, ',420000,422800,422825,');
INSERT INTO `oa_city` VALUES (422826, '咸丰县', 3, 422800, ',420000,422800,422826,');
INSERT INTO `oa_city` VALUES (422827, '来凤县', 3, 422800, ',420000,422800,422827,');
INSERT INTO `oa_city` VALUES (422828, '鹤峰县', 3, 422800, ',420000,422800,422828,');
INSERT INTO `oa_city` VALUES (429004, '仙桃市', 2, 420000, ',420000,429004,');
INSERT INTO `oa_city` VALUES (429005, '潜江市', 2, 420000, ',420000,429005,');
INSERT INTO `oa_city` VALUES (429006, '天门市', 2, 420000, ',420000,429006,');
INSERT INTO `oa_city` VALUES (429021, '神农架林区', 2, 420000, ',420000,429021,');
INSERT INTO `oa_city` VALUES (430000, '湖南省', 1, 0, ',430000,');
INSERT INTO `oa_city` VALUES (430100, '长沙市', 2, 430000, ',430000,430100,');
INSERT INTO `oa_city` VALUES (430102, '芙蓉区', 3, 430100, ',430000,430100,430102,');
INSERT INTO `oa_city` VALUES (430103, '天心区', 3, 430100, ',430000,430100,430103,');
INSERT INTO `oa_city` VALUES (430104, '岳麓区', 3, 430100, ',430000,430100,430104,');
INSERT INTO `oa_city` VALUES (430105, '开福区', 3, 430100, ',430000,430100,430105,');
INSERT INTO `oa_city` VALUES (430111, '雨花区', 3, 430100, ',430000,430100,430111,');
INSERT INTO `oa_city` VALUES (430121, '长沙县', 3, 430100, ',430000,430100,430121,');
INSERT INTO `oa_city` VALUES (430122, '望城县', 3, 430100, ',430000,430100,430122,');
INSERT INTO `oa_city` VALUES (430124, '宁乡县', 3, 430100, ',430000,430100,430124,');
INSERT INTO `oa_city` VALUES (430181, '浏阳市', 3, 430100, ',430000,430100,430181,');
INSERT INTO `oa_city` VALUES (430200, '株洲市', 2, 430000, ',430000,430200,');
INSERT INTO `oa_city` VALUES (430202, '荷塘区', 3, 430200, ',430000,430200,430202,');
INSERT INTO `oa_city` VALUES (430203, '芦淞区', 3, 430200, ',430000,430200,430203,');
INSERT INTO `oa_city` VALUES (430204, '石峰区', 3, 430200, ',430000,430200,430204,');
INSERT INTO `oa_city` VALUES (430211, '天元区', 3, 430200, ',430000,430200,430211,');
INSERT INTO `oa_city` VALUES (430221, '株洲县', 3, 430200, ',430000,430200,430221,');
INSERT INTO `oa_city` VALUES (430223, '攸　县', 3, 430200, ',430000,430200,430223,');
INSERT INTO `oa_city` VALUES (430224, '茶陵县', 3, 430200, ',430000,430200,430224,');
INSERT INTO `oa_city` VALUES (430225, '炎陵县', 3, 430200, ',430000,430200,430225,');
INSERT INTO `oa_city` VALUES (430281, '醴陵市', 3, 430200, ',430000,430200,430281,');
INSERT INTO `oa_city` VALUES (430300, '湘潭市', 2, 430000, ',430000,430300,');
INSERT INTO `oa_city` VALUES (430302, '雨湖区', 3, 430300, ',430000,430300,430302,');
INSERT INTO `oa_city` VALUES (430304, '岳塘区', 3, 430300, ',430000,430300,430304,');
INSERT INTO `oa_city` VALUES (430321, '湘潭县', 3, 430300, ',430000,430300,430321,');
INSERT INTO `oa_city` VALUES (430381, '湘乡市', 3, 430300, ',430000,430300,430381,');
INSERT INTO `oa_city` VALUES (430382, '韶山市', 3, 430300, ',430000,430300,430382,');
INSERT INTO `oa_city` VALUES (430400, '衡阳市', 2, 430000, ',430000,430400,');
INSERT INTO `oa_city` VALUES (430405, '珠晖区', 3, 430400, ',430000,430400,430405,');
INSERT INTO `oa_city` VALUES (430406, '雁峰区', 3, 430400, ',430000,430400,430406,');
INSERT INTO `oa_city` VALUES (430407, '石鼓区', 3, 430400, ',430000,430400,430407,');
INSERT INTO `oa_city` VALUES (430408, '蒸湘区', 3, 430400, ',430000,430400,430408,');
INSERT INTO `oa_city` VALUES (430412, '南岳区', 3, 430400, ',430000,430400,430412,');
INSERT INTO `oa_city` VALUES (430421, '衡阳县', 3, 430400, ',430000,430400,430421,');
INSERT INTO `oa_city` VALUES (430422, '衡南县', 3, 430400, ',430000,430400,430422,');
INSERT INTO `oa_city` VALUES (430423, '衡山县', 3, 430400, ',430000,430400,430423,');
INSERT INTO `oa_city` VALUES (430424, '衡东县', 3, 430400, ',430000,430400,430424,');
INSERT INTO `oa_city` VALUES (430426, '祁东县', 3, 430400, ',430000,430400,430426,');
INSERT INTO `oa_city` VALUES (430481, '耒阳市', 3, 430400, ',430000,430400,430481,');
INSERT INTO `oa_city` VALUES (430482, '常宁市', 3, 430400, ',430000,430400,430482,');
INSERT INTO `oa_city` VALUES (430500, '邵阳市', 2, 430000, ',430000,430500,');
INSERT INTO `oa_city` VALUES (430502, '双清区', 3, 430500, ',430000,430500,430502,');
INSERT INTO `oa_city` VALUES (430503, '大祥区', 3, 430500, ',430000,430500,430503,');
INSERT INTO `oa_city` VALUES (430511, '北塔区', 3, 430500, ',430000,430500,430511,');
INSERT INTO `oa_city` VALUES (430521, '邵东县', 3, 430500, ',430000,430500,430521,');
INSERT INTO `oa_city` VALUES (430522, '新邵县', 3, 430500, ',430000,430500,430522,');
INSERT INTO `oa_city` VALUES (430523, '邵阳县', 3, 430500, ',430000,430500,430523,');
INSERT INTO `oa_city` VALUES (430524, '隆回县', 3, 430500, ',430000,430500,430524,');
INSERT INTO `oa_city` VALUES (430525, '洞口县', 3, 430500, ',430000,430500,430525,');
INSERT INTO `oa_city` VALUES (430527, '绥宁县', 3, 430500, ',430000,430500,430527,');
INSERT INTO `oa_city` VALUES (430528, '新宁县', 3, 430500, ',430000,430500,430528,');
INSERT INTO `oa_city` VALUES (430529, '城步苗族自治县', 3, 430500, ',430000,430500,430529,');
INSERT INTO `oa_city` VALUES (430581, '武冈市', 3, 430500, ',430000,430500,430581,');
INSERT INTO `oa_city` VALUES (430600, '岳阳市', 2, 430000, ',430000,430600,');
INSERT INTO `oa_city` VALUES (430602, '岳阳楼区', 3, 430600, ',430000,430600,430602,');
INSERT INTO `oa_city` VALUES (430603, '云溪区', 3, 430600, ',430000,430600,430603,');
INSERT INTO `oa_city` VALUES (430611, '君山区', 3, 430600, ',430000,430600,430611,');
INSERT INTO `oa_city` VALUES (430621, '岳阳县', 3, 430600, ',430000,430600,430621,');
INSERT INTO `oa_city` VALUES (430623, '华容县', 3, 430600, ',430000,430600,430623,');
INSERT INTO `oa_city` VALUES (430624, '湘阴县', 3, 430600, ',430000,430600,430624,');
INSERT INTO `oa_city` VALUES (430626, '平江县', 3, 430600, ',430000,430600,430626,');
INSERT INTO `oa_city` VALUES (430681, '汨罗市', 3, 430600, ',430000,430600,430681,');
INSERT INTO `oa_city` VALUES (430682, '临湘市', 3, 430600, ',430000,430600,430682,');
INSERT INTO `oa_city` VALUES (430700, '常德市', 2, 430000, ',430000,430700,');
INSERT INTO `oa_city` VALUES (430702, '武陵区', 3, 430700, ',430000,430700,430702,');
INSERT INTO `oa_city` VALUES (430703, '鼎城区', 3, 430700, ',430000,430700,430703,');
INSERT INTO `oa_city` VALUES (430721, '安乡县', 3, 430700, ',430000,430700,430721,');
INSERT INTO `oa_city` VALUES (430722, '汉寿县', 3, 430700, ',430000,430700,430722,');
INSERT INTO `oa_city` VALUES (430723, '澧　县', 3, 430700, ',430000,430700,430723,');
INSERT INTO `oa_city` VALUES (430724, '临澧县', 3, 430700, ',430000,430700,430724,');
INSERT INTO `oa_city` VALUES (430725, '桃源县', 3, 430700, ',430000,430700,430725,');
INSERT INTO `oa_city` VALUES (430726, '石门县', 3, 430700, ',430000,430700,430726,');
INSERT INTO `oa_city` VALUES (430781, '津市市', 3, 430700, ',430000,430700,430781,');
INSERT INTO `oa_city` VALUES (430800, '张家界市', 2, 430000, ',430000,430800,');
INSERT INTO `oa_city` VALUES (430802, '永定区', 3, 430800, ',430000,430800,430802,');
INSERT INTO `oa_city` VALUES (430811, '武陵源区', 3, 430800, ',430000,430800,430811,');
INSERT INTO `oa_city` VALUES (430821, '慈利县', 3, 430800, ',430000,430800,430821,');
INSERT INTO `oa_city` VALUES (430822, '桑植县', 3, 430800, ',430000,430800,430822,');
INSERT INTO `oa_city` VALUES (430900, '益阳市', 2, 430000, ',430000,430900,');
INSERT INTO `oa_city` VALUES (430902, '资阳区', 3, 430900, ',430000,430900,430902,');
INSERT INTO `oa_city` VALUES (430903, '赫山区', 3, 430900, ',430000,430900,430903,');
INSERT INTO `oa_city` VALUES (430921, '南　县', 3, 430900, ',430000,430900,430921,');
INSERT INTO `oa_city` VALUES (430922, '桃江县', 3, 430900, ',430000,430900,430922,');
INSERT INTO `oa_city` VALUES (430923, '安化县', 3, 430900, ',430000,430900,430923,');
INSERT INTO `oa_city` VALUES (430981, '沅江市', 3, 430900, ',430000,430900,430981,');
INSERT INTO `oa_city` VALUES (431000, '郴州市', 2, 430000, ',430000,431000,');
INSERT INTO `oa_city` VALUES (431002, '北湖区', 3, 431000, ',430000,431000,431002,');
INSERT INTO `oa_city` VALUES (431003, '苏仙区', 3, 431000, ',430000,431000,431003,');
INSERT INTO `oa_city` VALUES (431021, '桂阳县', 3, 431000, ',430000,431000,431021,');
INSERT INTO `oa_city` VALUES (431022, '宜章县', 3, 431000, ',430000,431000,431022,');
INSERT INTO `oa_city` VALUES (431023, '永兴县', 3, 431000, ',430000,431000,431023,');
INSERT INTO `oa_city` VALUES (431024, '嘉禾县', 3, 431000, ',430000,431000,431024,');
INSERT INTO `oa_city` VALUES (431025, '临武县', 3, 431000, ',430000,431000,431025,');
INSERT INTO `oa_city` VALUES (431026, '汝城县', 3, 431000, ',430000,431000,431026,');
INSERT INTO `oa_city` VALUES (431027, '桂东县', 3, 431000, ',430000,431000,431027,');
INSERT INTO `oa_city` VALUES (431028, '安仁县', 3, 431000, ',430000,431000,431028,');
INSERT INTO `oa_city` VALUES (431081, '资兴市', 3, 431000, ',430000,431000,431081,');
INSERT INTO `oa_city` VALUES (431100, '永州市', 2, 430000, ',430000,431100,');
INSERT INTO `oa_city` VALUES (431102, '芝山区', 3, 431100, ',430000,431100,431102,');
INSERT INTO `oa_city` VALUES (431103, '冷水滩区', 3, 431100, ',430000,431100,431103,');
INSERT INTO `oa_city` VALUES (431121, '祁阳县', 3, 431100, ',430000,431100,431121,');
INSERT INTO `oa_city` VALUES (431122, '东安县', 3, 431100, ',430000,431100,431122,');
INSERT INTO `oa_city` VALUES (431123, '双牌县', 3, 431100, ',430000,431100,431123,');
INSERT INTO `oa_city` VALUES (431124, '道　县', 3, 431100, ',430000,431100,431124,');
INSERT INTO `oa_city` VALUES (431125, '江永县', 3, 431100, ',430000,431100,431125,');
INSERT INTO `oa_city` VALUES (431126, '宁远县', 3, 431100, ',430000,431100,431126,');
INSERT INTO `oa_city` VALUES (431127, '蓝山县', 3, 431100, ',430000,431100,431127,');
INSERT INTO `oa_city` VALUES (431128, '新田县', 3, 431100, ',430000,431100,431128,');
INSERT INTO `oa_city` VALUES (431129, '江华瑶族自治县', 3, 431100, ',430000,431100,431129,');
INSERT INTO `oa_city` VALUES (431200, '怀化市', 2, 430000, ',430000,431200,');
INSERT INTO `oa_city` VALUES (431202, '鹤城区', 3, 431200, ',430000,431200,431202,');
INSERT INTO `oa_city` VALUES (431221, '中方县', 3, 431200, ',430000,431200,431221,');
INSERT INTO `oa_city` VALUES (431222, '沅陵县', 3, 431200, ',430000,431200,431222,');
INSERT INTO `oa_city` VALUES (431223, '辰溪县', 3, 431200, ',430000,431200,431223,');
INSERT INTO `oa_city` VALUES (431224, '溆浦县', 3, 431200, ',430000,431200,431224,');
INSERT INTO `oa_city` VALUES (431225, '会同县', 3, 431200, ',430000,431200,431225,');
INSERT INTO `oa_city` VALUES (431226, '麻阳苗族自治县', 3, 431200, ',430000,431200,431226,');
INSERT INTO `oa_city` VALUES (431227, '新晃侗族自治县', 3, 431200, ',430000,431200,431227,');
INSERT INTO `oa_city` VALUES (431228, '芷江侗族自治县', 3, 431200, ',430000,431200,431228,');
INSERT INTO `oa_city` VALUES (431229, '靖州苗族侗族自治县', 3, 431200, ',430000,431200,431229,');
INSERT INTO `oa_city` VALUES (431230, '通道侗族自治县', 3, 431200, ',430000,431200,431230,');
INSERT INTO `oa_city` VALUES (431281, '洪江市', 3, 431200, ',430000,431200,431281,');
INSERT INTO `oa_city` VALUES (431300, '娄底市', 2, 430000, ',430000,431300,');
INSERT INTO `oa_city` VALUES (431302, '娄星区', 3, 431300, ',430000,431300,431302,');
INSERT INTO `oa_city` VALUES (431321, '双峰县', 3, 431300, ',430000,431300,431321,');
INSERT INTO `oa_city` VALUES (431322, '新化县', 3, 431300, ',430000,431300,431322,');
INSERT INTO `oa_city` VALUES (431381, '冷水江市', 3, 431300, ',430000,431300,431381,');
INSERT INTO `oa_city` VALUES (431382, '涟源市', 3, 431300, ',430000,431300,431382,');
INSERT INTO `oa_city` VALUES (433100, '湘西土家族苗族自治州', 2, 430000, ',430000,433100,');
INSERT INTO `oa_city` VALUES (433101, '吉首市', 3, 433100, ',430000,433100,433101,');
INSERT INTO `oa_city` VALUES (433122, '泸溪县', 3, 433100, ',430000,433100,433122,');
INSERT INTO `oa_city` VALUES (433123, '凤凰县', 3, 433100, ',430000,433100,433123,');
INSERT INTO `oa_city` VALUES (433124, '花垣县', 3, 433100, ',430000,433100,433124,');
INSERT INTO `oa_city` VALUES (433125, '保靖县', 3, 433100, ',430000,433100,433125,');
INSERT INTO `oa_city` VALUES (433126, '古丈县', 3, 433100, ',430000,433100,433126,');
INSERT INTO `oa_city` VALUES (433127, '永顺县', 3, 433100, ',430000,433100,433127,');
INSERT INTO `oa_city` VALUES (433130, '龙山县', 3, 433100, ',430000,433100,433130,');
INSERT INTO `oa_city` VALUES (440000, '广东省', 1, 0, ',440000,');
INSERT INTO `oa_city` VALUES (440100, '广州市', 2, 440000, ',440000,440100,');
INSERT INTO `oa_city` VALUES (440103, '荔湾区', 3, 440100, ',440000,440100,440103,');
INSERT INTO `oa_city` VALUES (440104, '越秀区', 3, 440100, ',440000,440100,440104,');
INSERT INTO `oa_city` VALUES (440105, '海珠区', 3, 440100, ',440000,440100,440105,');
INSERT INTO `oa_city` VALUES (440106, '天河区', 3, 440100, ',440000,440100,440106,');
INSERT INTO `oa_city` VALUES (440111, '白云区', 3, 440100, ',440000,440100,440111,');
INSERT INTO `oa_city` VALUES (440112, '黄埔区', 3, 440100, ',440000,440100,440112,');
INSERT INTO `oa_city` VALUES (440113, '番禺区', 3, 440100, ',440000,440100,440113,');
INSERT INTO `oa_city` VALUES (440114, '花都区', 3, 440100, ',440000,440100,440114,');
INSERT INTO `oa_city` VALUES (440115, '南沙区', 3, 440100, ',440000,440100,440115,');
INSERT INTO `oa_city` VALUES (440183, '增城区', 3, 440100, ',440000,440100,440183,');
INSERT INTO `oa_city` VALUES (440184, '从化区', 3, 440100, ',440000,440100,440184,');
INSERT INTO `oa_city` VALUES (440200, '韶关市', 2, 440000, ',440000,440200,');
INSERT INTO `oa_city` VALUES (440203, '武江区', 3, 440200, ',440000,440200,440203,');
INSERT INTO `oa_city` VALUES (440204, '浈江区', 3, 440200, ',440000,440200,440204,');
INSERT INTO `oa_city` VALUES (440205, '曲江区', 3, 440200, ',440000,440200,440205,');
INSERT INTO `oa_city` VALUES (440222, '始兴县', 3, 440200, ',440000,440200,440222,');
INSERT INTO `oa_city` VALUES (440224, '仁化县', 3, 440200, ',440000,440200,440224,');
INSERT INTO `oa_city` VALUES (440229, '翁源县', 3, 440200, ',440000,440200,440229,');
INSERT INTO `oa_city` VALUES (440232, '乳源瑶族自治县', 3, 440200, ',440000,440200,440232,');
INSERT INTO `oa_city` VALUES (440233, '新丰县', 3, 440200, ',440000,440200,440233,');
INSERT INTO `oa_city` VALUES (440281, '乐昌市', 3, 440200, ',440000,440200,440281,');
INSERT INTO `oa_city` VALUES (440282, '南雄市', 3, 440200, ',440000,440200,440282,');
INSERT INTO `oa_city` VALUES (440300, '深圳市', 2, 440000, ',440000,440300,');
INSERT INTO `oa_city` VALUES (440303, '罗湖区', 3, 440300, ',440000,440300,440303,');
INSERT INTO `oa_city` VALUES (440304, '福田区', 3, 440300, ',440000,440300,440304,');
INSERT INTO `oa_city` VALUES (440305, '南山区', 3, 440300, ',440000,440300,440305,');
INSERT INTO `oa_city` VALUES (440306, '宝安区', 3, 440300, ',440000,440300,440306,');
INSERT INTO `oa_city` VALUES (440307, '龙岗区', 3, 440300, ',440000,440300,440307,');
INSERT INTO `oa_city` VALUES (440308, '盐田区', 3, 440300, ',440000,440300,440308,');
INSERT INTO `oa_city` VALUES (440400, '珠海市', 2, 440000, ',440000,440400,');
INSERT INTO `oa_city` VALUES (440402, '香洲区', 3, 440400, ',440000,440400,440402,');
INSERT INTO `oa_city` VALUES (440403, '斗门区', 3, 440400, ',440000,440400,440403,');
INSERT INTO `oa_city` VALUES (440404, '金湾区', 3, 440400, ',440000,440400,440404,');
INSERT INTO `oa_city` VALUES (440500, '汕头市', 2, 440000, ',440000,440500,');
INSERT INTO `oa_city` VALUES (440507, '龙湖区', 3, 440500, ',440000,440500,440507,');
INSERT INTO `oa_city` VALUES (440511, '金平区', 3, 440500, ',440000,440500,440511,');
INSERT INTO `oa_city` VALUES (440512, '濠江区', 3, 440500, ',440000,440500,440512,');
INSERT INTO `oa_city` VALUES (440513, '潮阳区', 3, 440500, ',440000,440500,440513,');
INSERT INTO `oa_city` VALUES (440514, '潮南区', 3, 440500, ',440000,440500,440514,');
INSERT INTO `oa_city` VALUES (440515, '澄海区', 3, 440500, ',440000,440500,440515,');
INSERT INTO `oa_city` VALUES (440523, '南澳县', 3, 440500, ',440000,440500,440523,');
INSERT INTO `oa_city` VALUES (440524, '直属局', 3, 440500, ',440000,440500,440524,');
INSERT INTO `oa_city` VALUES (440525, '保税区', 3, 440500, ',440000,440500,440525,');
INSERT INTO `oa_city` VALUES (440600, '佛山市', 2, 440000, ',440000,440600,');
INSERT INTO `oa_city` VALUES (440604, '禅城区', 3, 440600, ',440000,440600,440604,');
INSERT INTO `oa_city` VALUES (440605, '南海区', 3, 440600, ',440000,440600,440605,');
INSERT INTO `oa_city` VALUES (440606, '顺德区', 3, 440600, ',440000,440600,440606,');
INSERT INTO `oa_city` VALUES (440607, '三水区', 3, 440600, ',440000,440600,440607,');
INSERT INTO `oa_city` VALUES (440608, '高明区', 3, 440600, ',440000,440600,440608,');
INSERT INTO `oa_city` VALUES (440700, '江门市', 2, 440000, ',440000,440700,');
INSERT INTO `oa_city` VALUES (440703, '蓬江区', 3, 440700, ',440000,440700,440703,');
INSERT INTO `oa_city` VALUES (440704, '江海区', 3, 440700, ',440000,440700,440704,');
INSERT INTO `oa_city` VALUES (440705, '新会区', 3, 440700, ',440000,440700,440705,');
INSERT INTO `oa_city` VALUES (440781, '台山市', 3, 440700, ',440000,440700,440781,');
INSERT INTO `oa_city` VALUES (440783, '开平市', 3, 440700, ',440000,440700,440783,');
INSERT INTO `oa_city` VALUES (440784, '鹤山市', 3, 440700, ',440000,440700,440784,');
INSERT INTO `oa_city` VALUES (440785, '恩平市', 3, 440700, ',440000,440700,440785,');
INSERT INTO `oa_city` VALUES (440800, '湛江市', 2, 440000, ',440000,440800,');
INSERT INTO `oa_city` VALUES (440802, '赤坎区', 3, 440800, ',440000,440800,440802,');
INSERT INTO `oa_city` VALUES (440803, '霞山区', 3, 440800, ',440000,440800,440803,');
INSERT INTO `oa_city` VALUES (440804, '坡头区', 3, 440800, ',440000,440800,440804,');
INSERT INTO `oa_city` VALUES (440811, '麻章区', 3, 440800, ',440000,440800,440811,');
INSERT INTO `oa_city` VALUES (440823, '遂溪县', 3, 440800, ',440000,440800,440823,');
INSERT INTO `oa_city` VALUES (440825, '徐闻县', 3, 440800, ',440000,440800,440825,');
INSERT INTO `oa_city` VALUES (440881, '廉江市', 3, 440800, ',440000,440800,440881,');
INSERT INTO `oa_city` VALUES (440882, '雷州市', 3, 440800, ',440000,440800,440882,');
INSERT INTO `oa_city` VALUES (440883, '吴川市', 3, 440800, ',440000,440800,440883,');
INSERT INTO `oa_city` VALUES (440900, '茂名市', 2, 440000, ',440000,440900,');
INSERT INTO `oa_city` VALUES (440902, '茂南区', 3, 440900, ',440000,440900,440902,');
INSERT INTO `oa_city` VALUES (440903, '茂港区', 3, 440900, ',440000,440900,440903,');
INSERT INTO `oa_city` VALUES (440923, '电白县', 3, 440900, ',440000,440900,440923,');
INSERT INTO `oa_city` VALUES (440981, '高州市', 3, 440900, ',440000,440900,440981,');
INSERT INTO `oa_city` VALUES (440982, '化州市', 3, 440900, ',440000,440900,440982,');
INSERT INTO `oa_city` VALUES (440983, '信宜市', 3, 440900, ',440000,440900,440983,');
INSERT INTO `oa_city` VALUES (441200, '肇庆市', 2, 440000, ',440000,441200,');
INSERT INTO `oa_city` VALUES (441202, '端州区', 3, 441200, ',440000,441200,441202,');
INSERT INTO `oa_city` VALUES (441203, '鼎湖区', 3, 441200, ',440000,441200,441203,');
INSERT INTO `oa_city` VALUES (441223, '广宁县', 3, 441200, ',440000,441200,441223,');
INSERT INTO `oa_city` VALUES (441224, '怀集县', 3, 441200, ',440000,441200,441224,');
INSERT INTO `oa_city` VALUES (441225, '封开县', 3, 441200, ',440000,441200,441225,');
INSERT INTO `oa_city` VALUES (441226, '德庆县', 3, 441200, ',440000,441200,441226,');
INSERT INTO `oa_city` VALUES (441283, '高要区', 3, 441200, ',440000,441200,441283,');
INSERT INTO `oa_city` VALUES (441284, '四会市', 3, 441200, ',440000,441200,441284,');
INSERT INTO `oa_city` VALUES (441300, '惠州市', 2, 440000, ',440000,441300,');
INSERT INTO `oa_city` VALUES (441302, '惠城区', 3, 441300, ',440000,441300,441302,');
INSERT INTO `oa_city` VALUES (441303, '惠阳区', 3, 441300, ',440000,441300,441303,');
INSERT INTO `oa_city` VALUES (441322, '博罗县', 3, 441300, ',440000,441300,441322,');
INSERT INTO `oa_city` VALUES (441323, '惠东县', 3, 441300, ',440000,441300,441323,');
INSERT INTO `oa_city` VALUES (441324, '龙门县', 3, 441300, ',440000,441300,441324,');
INSERT INTO `oa_city` VALUES (441400, '梅州市', 2, 440000, ',440000,441400,');
INSERT INTO `oa_city` VALUES (441402, '梅江区', 3, 441400, ',440000,441400,441402,');
INSERT INTO `oa_city` VALUES (441421, '梅　县', 3, 441400, ',440000,441400,441421,');
INSERT INTO `oa_city` VALUES (441422, '大埔县', 3, 441400, ',440000,441400,441422,');
INSERT INTO `oa_city` VALUES (441423, '丰顺县', 3, 441400, ',440000,441400,441423,');
INSERT INTO `oa_city` VALUES (441424, '五华县', 3, 441400, ',440000,441400,441424,');
INSERT INTO `oa_city` VALUES (441426, '平远县', 3, 441400, ',440000,441400,441426,');
INSERT INTO `oa_city` VALUES (441427, '蕉岭县', 3, 441400, ',440000,441400,441427,');
INSERT INTO `oa_city` VALUES (441481, '兴宁市', 3, 441400, ',440000,441400,441481,');
INSERT INTO `oa_city` VALUES (441500, '汕尾市', 2, 440000, ',440000,441500,');
INSERT INTO `oa_city` VALUES (441502, '城　区', 3, 441500, ',440000,441500,441502,');
INSERT INTO `oa_city` VALUES (441521, '海丰县', 3, 441500, ',440000,441500,441521,');
INSERT INTO `oa_city` VALUES (441523, '陆河县', 3, 441500, ',440000,441500,441523,');
INSERT INTO `oa_city` VALUES (441581, '陆丰市', 3, 441500, ',440000,441500,441581,');
INSERT INTO `oa_city` VALUES (441600, '河源市', 2, 440000, ',440000,441600,');
INSERT INTO `oa_city` VALUES (441602, '源城区', 3, 441600, ',440000,441600,441602,');
INSERT INTO `oa_city` VALUES (441621, '紫金县', 3, 441600, ',440000,441600,441621,');
INSERT INTO `oa_city` VALUES (441622, '龙川县', 3, 441600, ',440000,441600,441622,');
INSERT INTO `oa_city` VALUES (441623, '连平县', 3, 441600, ',440000,441600,441623,');
INSERT INTO `oa_city` VALUES (441624, '和平县', 3, 441600, ',440000,441600,441624,');
INSERT INTO `oa_city` VALUES (441625, '东源县', 3, 441600, ',440000,441600,441625,');
INSERT INTO `oa_city` VALUES (441700, '阳江市', 2, 440000, ',440000,441700,');
INSERT INTO `oa_city` VALUES (441702, '江城区', 3, 441700, ',440000,441700,441702,');
INSERT INTO `oa_city` VALUES (441721, '阳西县', 3, 441700, ',440000,441700,441721,');
INSERT INTO `oa_city` VALUES (441723, '阳东县', 3, 441700, ',440000,441700,441723,');
INSERT INTO `oa_city` VALUES (441781, '阳春市', 3, 441700, ',440000,441700,441781,');
INSERT INTO `oa_city` VALUES (441800, '清远市', 2, 440000, ',440000,441800,');
INSERT INTO `oa_city` VALUES (441802, '清城区', 3, 441800, ',440000,441800,441802,');
INSERT INTO `oa_city` VALUES (441821, '佛冈县', 3, 441800, ',440000,441800,441821,');
INSERT INTO `oa_city` VALUES (441823, '阳山县', 3, 441800, ',440000,441800,441823,');
INSERT INTO `oa_city` VALUES (441825, '连山壮族瑶族自治县', 3, 441800, ',440000,441800,441825,');
INSERT INTO `oa_city` VALUES (441826, '连南瑶族自治县', 3, 441800, ',440000,441800,441826,');
INSERT INTO `oa_city` VALUES (441827, '清新县', 3, 441800, ',440000,441800,441827,');
INSERT INTO `oa_city` VALUES (441881, '英德市', 3, 441800, ',440000,441800,441881,');
INSERT INTO `oa_city` VALUES (441882, '连州市', 3, 441800, ',440000,441800,441882,');
INSERT INTO `oa_city` VALUES (441900, '东莞市', 2, 440000, ',440000,441900,');
INSERT INTO `oa_city` VALUES (442000, '中山市', 2, 440000, ',440000,442000,');
INSERT INTO `oa_city` VALUES (445100, '潮州市', 2, 440000, ',440000,445100,');
INSERT INTO `oa_city` VALUES (445102, '湘桥区', 3, 445100, ',440000,445100,445102,');
INSERT INTO `oa_city` VALUES (445121, '潮安县', 3, 445100, ',440000,445100,445121,');
INSERT INTO `oa_city` VALUES (445122, '饶平县', 3, 445100, ',440000,445100,445122,');
INSERT INTO `oa_city` VALUES (445200, '揭阳市', 2, 440000, ',440000,445200,');
INSERT INTO `oa_city` VALUES (445202, '榕城区', 3, 445200, ',440000,445200,445202,');
INSERT INTO `oa_city` VALUES (445221, '揭东县', 3, 445200, ',440000,445200,445221,');
INSERT INTO `oa_city` VALUES (445222, '揭西县', 3, 445200, ',440000,445200,445222,');
INSERT INTO `oa_city` VALUES (445224, '惠来县', 3, 445200, ',440000,445200,445224,');
INSERT INTO `oa_city` VALUES (445281, '普宁市', 3, 445200, ',440000,445200,445281,');
INSERT INTO `oa_city` VALUES (445300, '云浮市', 2, 440000, ',440000,445300,');
INSERT INTO `oa_city` VALUES (445302, '云城区', 3, 445300, ',440000,445300,445302,');
INSERT INTO `oa_city` VALUES (445321, '新兴县', 3, 445300, ',440000,445300,445321,');
INSERT INTO `oa_city` VALUES (445322, '郁南县', 3, 445300, ',440000,445300,445322,');
INSERT INTO `oa_city` VALUES (445323, '云安县', 3, 445300, ',440000,445300,445323,');
INSERT INTO `oa_city` VALUES (445381, '罗定市', 3, 445300, ',440000,445300,445381,');
INSERT INTO `oa_city` VALUES (450000, '广西省', 1, 0, ',450000,');
INSERT INTO `oa_city` VALUES (450100, '南宁市', 2, 450000, ',450000,450100,');
INSERT INTO `oa_city` VALUES (450102, '兴宁区', 3, 450100, ',450000,450100,450102,');
INSERT INTO `oa_city` VALUES (450103, '青秀区', 3, 450100, ',450000,450100,450103,');
INSERT INTO `oa_city` VALUES (450105, '江南区', 3, 450100, ',450000,450100,450105,');
INSERT INTO `oa_city` VALUES (450107, '西乡塘区', 3, 450100, ',450000,450100,450107,');
INSERT INTO `oa_city` VALUES (450108, '良庆区', 3, 450100, ',450000,450100,450108,');
INSERT INTO `oa_city` VALUES (450109, '邕宁区', 3, 450100, ',450000,450100,450109,');
INSERT INTO `oa_city` VALUES (450122, '武鸣县', 3, 450100, ',450000,450100,450122,');
INSERT INTO `oa_city` VALUES (450123, '隆安县', 3, 450100, ',450000,450100,450123,');
INSERT INTO `oa_city` VALUES (450124, '马山县', 3, 450100, ',450000,450100,450124,');
INSERT INTO `oa_city` VALUES (450125, '上林县', 3, 450100, ',450000,450100,450125,');
INSERT INTO `oa_city` VALUES (450126, '宾阳县', 3, 450100, ',450000,450100,450126,');
INSERT INTO `oa_city` VALUES (450127, '横　县', 3, 450100, ',450000,450100,450127,');
INSERT INTO `oa_city` VALUES (450200, '柳州市', 2, 450000, ',450000,450200,');
INSERT INTO `oa_city` VALUES (450202, '城中区', 3, 450200, ',450000,450200,450202,');
INSERT INTO `oa_city` VALUES (450203, '鱼峰区', 3, 450200, ',450000,450200,450203,');
INSERT INTO `oa_city` VALUES (450204, '柳南区', 3, 450200, ',450000,450200,450204,');
INSERT INTO `oa_city` VALUES (450205, '柳北区', 3, 450200, ',450000,450200,450205,');
INSERT INTO `oa_city` VALUES (450221, '柳江县', 3, 450200, ',450000,450200,450221,');
INSERT INTO `oa_city` VALUES (450222, '柳城县', 3, 450200, ',450000,450200,450222,');
INSERT INTO `oa_city` VALUES (450223, '鹿寨县', 3, 450200, ',450000,450200,450223,');
INSERT INTO `oa_city` VALUES (450224, '融安县', 3, 450200, ',450000,450200,450224,');
INSERT INTO `oa_city` VALUES (450225, '融水苗族自治县', 3, 450200, ',450000,450200,450225,');
INSERT INTO `oa_city` VALUES (450226, '三江侗族自治县', 3, 450200, ',450000,450200,450226,');
INSERT INTO `oa_city` VALUES (450300, '桂林市', 2, 450000, ',450000,450300,');
INSERT INTO `oa_city` VALUES (450302, '秀峰区', 3, 450300, ',450000,450300,450302,');
INSERT INTO `oa_city` VALUES (450303, '叠彩区', 3, 450300, ',450000,450300,450303,');
INSERT INTO `oa_city` VALUES (450304, '象山区', 3, 450300, ',450000,450300,450304,');
INSERT INTO `oa_city` VALUES (450305, '七星区', 3, 450300, ',450000,450300,450305,');
INSERT INTO `oa_city` VALUES (450311, '雁山区', 3, 450300, ',450000,450300,450311,');
INSERT INTO `oa_city` VALUES (450321, '阳朔县', 3, 450300, ',450000,450300,450321,');
INSERT INTO `oa_city` VALUES (450322, '临桂县', 3, 450300, ',450000,450300,450322,');
INSERT INTO `oa_city` VALUES (450323, '灵川县', 3, 450300, ',450000,450300,450323,');
INSERT INTO `oa_city` VALUES (450324, '全州县', 3, 450300, ',450000,450300,450324,');
INSERT INTO `oa_city` VALUES (450325, '兴安县', 3, 450300, ',450000,450300,450325,');
INSERT INTO `oa_city` VALUES (450326, '永福县', 3, 450300, ',450000,450300,450326,');
INSERT INTO `oa_city` VALUES (450327, '灌阳县', 3, 450300, ',450000,450300,450327,');
INSERT INTO `oa_city` VALUES (450328, '龙胜各族自治县', 3, 450300, ',450000,450300,450328,');
INSERT INTO `oa_city` VALUES (450329, '资源县', 3, 450300, ',450000,450300,450329,');
INSERT INTO `oa_city` VALUES (450330, '平乐县', 3, 450300, ',450000,450300,450330,');
INSERT INTO `oa_city` VALUES (450331, '荔蒲县', 3, 450300, ',450000,450300,450331,');
INSERT INTO `oa_city` VALUES (450332, '恭城瑶族自治县', 3, 450300, ',450000,450300,450332,');
INSERT INTO `oa_city` VALUES (450400, '梧州市', 2, 450000, ',450000,450400,');
INSERT INTO `oa_city` VALUES (450403, '万秀区', 3, 450400, ',450000,450400,450403,');
INSERT INTO `oa_city` VALUES (450404, '蝶山区', 3, 450400, ',450000,450400,450404,');
INSERT INTO `oa_city` VALUES (450405, '长洲区', 3, 450400, ',450000,450400,450405,');
INSERT INTO `oa_city` VALUES (450421, '苍梧县', 3, 450400, ',450000,450400,450421,');
INSERT INTO `oa_city` VALUES (450422, '藤　县', 3, 450400, ',450000,450400,450422,');
INSERT INTO `oa_city` VALUES (450423, '蒙山县', 3, 450400, ',450000,450400,450423,');
INSERT INTO `oa_city` VALUES (450481, '岑溪市', 3, 450400, ',450000,450400,450481,');
INSERT INTO `oa_city` VALUES (450500, '北海市', 2, 450000, ',450000,450500,');
INSERT INTO `oa_city` VALUES (450502, '海城区', 3, 450500, ',450000,450500,450502,');
INSERT INTO `oa_city` VALUES (450503, '银海区', 3, 450500, ',450000,450500,450503,');
INSERT INTO `oa_city` VALUES (450512, '铁山港区', 3, 450500, ',450000,450500,450512,');
INSERT INTO `oa_city` VALUES (450521, '合浦县', 3, 450500, ',450000,450500,450521,');
INSERT INTO `oa_city` VALUES (450600, '防城港市', 2, 450000, ',450000,450600,');
INSERT INTO `oa_city` VALUES (450602, '港口区', 3, 450600, ',450000,450600,450602,');
INSERT INTO `oa_city` VALUES (450603, '防城区', 3, 450600, ',450000,450600,450603,');
INSERT INTO `oa_city` VALUES (450621, '上思县', 3, 450600, ',450000,450600,450621,');
INSERT INTO `oa_city` VALUES (450681, '东兴市', 3, 450600, ',450000,450600,450681,');
INSERT INTO `oa_city` VALUES (450700, '钦州市', 2, 450000, ',450000,450700,');
INSERT INTO `oa_city` VALUES (450702, '钦南区', 3, 450700, ',450000,450700,450702,');
INSERT INTO `oa_city` VALUES (450703, '钦北区', 3, 450700, ',450000,450700,450703,');
INSERT INTO `oa_city` VALUES (450721, '灵山县', 3, 450700, ',450000,450700,450721,');
INSERT INTO `oa_city` VALUES (450722, '浦北县', 3, 450700, ',450000,450700,450722,');
INSERT INTO `oa_city` VALUES (450800, '贵港市', 2, 450000, ',450000,450800,');
INSERT INTO `oa_city` VALUES (450802, '港北区', 3, 450800, ',450000,450800,450802,');
INSERT INTO `oa_city` VALUES (450803, '港南区', 3, 450800, ',450000,450800,450803,');
INSERT INTO `oa_city` VALUES (450804, '覃塘区', 3, 450800, ',450000,450800,450804,');
INSERT INTO `oa_city` VALUES (450821, '平南县', 3, 450800, ',450000,450800,450821,');
INSERT INTO `oa_city` VALUES (450881, '桂平市', 3, 450800, ',450000,450800,450881,');
INSERT INTO `oa_city` VALUES (450900, '玉林市', 2, 450000, ',450000,450900,');
INSERT INTO `oa_city` VALUES (450902, '玉州区', 3, 450900, ',450000,450900,450902,');
INSERT INTO `oa_city` VALUES (450921, '容　县', 3, 450900, ',450000,450900,450921,');
INSERT INTO `oa_city` VALUES (450922, '陆川县', 3, 450900, ',450000,450900,450922,');
INSERT INTO `oa_city` VALUES (450923, '博白县', 3, 450900, ',450000,450900,450923,');
INSERT INTO `oa_city` VALUES (450924, '兴业县', 3, 450900, ',450000,450900,450924,');
INSERT INTO `oa_city` VALUES (450981, '北流市', 3, 450900, ',450000,450900,450981,');
INSERT INTO `oa_city` VALUES (451000, '百色市', 2, 450000, ',450000,451000,');
INSERT INTO `oa_city` VALUES (451002, '右江区', 3, 451000, ',450000,451000,451002,');
INSERT INTO `oa_city` VALUES (451021, '田阳县', 3, 451000, ',450000,451000,451021,');
INSERT INTO `oa_city` VALUES (451022, '田东县', 3, 451000, ',450000,451000,451022,');
INSERT INTO `oa_city` VALUES (451023, '平果县', 3, 451000, ',450000,451000,451023,');
INSERT INTO `oa_city` VALUES (451024, '德保县', 3, 451000, ',450000,451000,451024,');
INSERT INTO `oa_city` VALUES (451025, '靖西县', 3, 451000, ',450000,451000,451025,');
INSERT INTO `oa_city` VALUES (451026, '那坡县', 3, 451000, ',450000,451000,451026,');
INSERT INTO `oa_city` VALUES (451027, '凌云县', 3, 451000, ',450000,451000,451027,');
INSERT INTO `oa_city` VALUES (451028, '乐业县', 3, 451000, ',450000,451000,451028,');
INSERT INTO `oa_city` VALUES (451029, '田林县', 3, 451000, ',450000,451000,451029,');
INSERT INTO `oa_city` VALUES (451030, '西林县', 3, 451000, ',450000,451000,451030,');
INSERT INTO `oa_city` VALUES (451031, '隆林各族自治县', 3, 451000, ',450000,451000,451031,');
INSERT INTO `oa_city` VALUES (451100, '贺州市', 2, 450000, ',450000,451100,');
INSERT INTO `oa_city` VALUES (451102, '八步区', 3, 451100, ',450000,451100,451102,');
INSERT INTO `oa_city` VALUES (451121, '昭平县', 3, 451100, ',450000,451100,451121,');
INSERT INTO `oa_city` VALUES (451122, '钟山县', 3, 451100, ',450000,451100,451122,');
INSERT INTO `oa_city` VALUES (451123, '富川瑶族自治县', 3, 451100, ',450000,451100,451123,');
INSERT INTO `oa_city` VALUES (451200, '河池市', 2, 450000, ',450000,451200,');
INSERT INTO `oa_city` VALUES (451202, '金城江区', 3, 451200, ',450000,451200,451202,');
INSERT INTO `oa_city` VALUES (451221, '南丹县', 3, 451200, ',450000,451200,451221,');
INSERT INTO `oa_city` VALUES (451222, '天峨县', 3, 451200, ',450000,451200,451222,');
INSERT INTO `oa_city` VALUES (451223, '凤山县', 3, 451200, ',450000,451200,451223,');
INSERT INTO `oa_city` VALUES (451224, '东兰县', 3, 451200, ',450000,451200,451224,');
INSERT INTO `oa_city` VALUES (451225, '罗城仫佬族自治县', 3, 451200, ',450000,451200,451225,');
INSERT INTO `oa_city` VALUES (451226, '环江毛南族自治县', 3, 451200, ',450000,451200,451226,');
INSERT INTO `oa_city` VALUES (451227, '巴马瑶族自治县', 3, 451200, ',450000,451200,451227,');
INSERT INTO `oa_city` VALUES (451228, '都安瑶族自治县', 3, 451200, ',450000,451200,451228,');
INSERT INTO `oa_city` VALUES (451229, '大化瑶族自治县', 3, 451200, ',450000,451200,451229,');
INSERT INTO `oa_city` VALUES (451281, '宜州市', 3, 451200, ',450000,451200,451281,');
INSERT INTO `oa_city` VALUES (451300, '来宾市', 2, 450000, ',450000,451300,');
INSERT INTO `oa_city` VALUES (451302, '兴宾区', 3, 451300, ',450000,451300,451302,');
INSERT INTO `oa_city` VALUES (451321, '忻城县', 3, 451300, ',450000,451300,451321,');
INSERT INTO `oa_city` VALUES (451322, '象州县', 3, 451300, ',450000,451300,451322,');
INSERT INTO `oa_city` VALUES (451323, '武宣县', 3, 451300, ',450000,451300,451323,');
INSERT INTO `oa_city` VALUES (451324, '金秀瑶族自治县', 3, 451300, ',450000,451300,451324,');
INSERT INTO `oa_city` VALUES (451381, '合山市', 3, 451300, ',450000,451300,451381,');
INSERT INTO `oa_city` VALUES (451400, '崇左市', 2, 450000, ',450000,451400,');
INSERT INTO `oa_city` VALUES (451402, '江洲区', 3, 451400, ',450000,451400,451402,');
INSERT INTO `oa_city` VALUES (451421, '扶绥县', 3, 451400, ',450000,451400,451421,');
INSERT INTO `oa_city` VALUES (451422, '宁明县', 3, 451400, ',450000,451400,451422,');
INSERT INTO `oa_city` VALUES (451423, '龙州县', 3, 451400, ',450000,451400,451423,');
INSERT INTO `oa_city` VALUES (451424, '大新县', 3, 451400, ',450000,451400,451424,');
INSERT INTO `oa_city` VALUES (451425, '天等县', 3, 451400, ',450000,451400,451425,');
INSERT INTO `oa_city` VALUES (451481, '凭祥市', 3, 451400, ',450000,451400,451481,');
INSERT INTO `oa_city` VALUES (460000, '海南省', 1, 0, ',460000,');
INSERT INTO `oa_city` VALUES (460100, '海口市', 2, 460000, ',460000,460100,');
INSERT INTO `oa_city` VALUES (460105, '秀英区', 3, 460100, ',460000,460100,460105,');
INSERT INTO `oa_city` VALUES (460106, '龙华区', 3, 460100, ',460000,460100,460106,');
INSERT INTO `oa_city` VALUES (460107, '琼山区', 3, 460100, ',460000,460100,460107,');
INSERT INTO `oa_city` VALUES (460108, '美兰区', 3, 460100, ',460000,460100,460108,');
INSERT INTO `oa_city` VALUES (460200, '三亚市', 2, 460000, ',460000,460200,');
INSERT INTO `oa_city` VALUES (460300, '三沙市', 2, 460000, ',460000,460300,');
INSERT INTO `oa_city` VALUES (469001, '五指山市', 2, 460000, ',460000,469001,');
INSERT INTO `oa_city` VALUES (469002, '琼海市', 2, 460000, ',460000,469002,');
INSERT INTO `oa_city` VALUES (469003, '儋州市', 2, 460000, ',460000,469003,');
INSERT INTO `oa_city` VALUES (469005, '文昌市', 2, 460000, ',460000,469005,');
INSERT INTO `oa_city` VALUES (469006, '万宁市', 2, 460000, ',460000,469006,');
INSERT INTO `oa_city` VALUES (469007, '东方市', 2, 460000, ',460000,469007,');
INSERT INTO `oa_city` VALUES (469025, '定安县', 2, 460000, ',460000,469025,');
INSERT INTO `oa_city` VALUES (469026, '屯昌县', 2, 460000, ',460000,469026,');
INSERT INTO `oa_city` VALUES (469027, '澄迈县', 2, 460000, ',460000,469027,');
INSERT INTO `oa_city` VALUES (469028, '临高县', 2, 460000, ',460000,469028,');
INSERT INTO `oa_city` VALUES (469030, '白沙黎族自治县', 2, 460000, ',460000,469030,');
INSERT INTO `oa_city` VALUES (469031, '昌江黎族自治县', 2, 460000, ',460000,469031,');
INSERT INTO `oa_city` VALUES (469033, '乐东黎族自治县', 2, 460000, ',460000,469033,');
INSERT INTO `oa_city` VALUES (469034, '陵水黎族自治县', 2, 460000, ',460000,469034,');
INSERT INTO `oa_city` VALUES (469035, '保亭黎族苗族自治县', 2, 460000, ',460000,469035,');
INSERT INTO `oa_city` VALUES (469036, '琼中黎族苗族自治县', 2, 460000, ',460000,469036,');
INSERT INTO `oa_city` VALUES (469037, '西沙群岛', 2, 460000, ',460000,469037,');
INSERT INTO `oa_city` VALUES (469038, '南沙群岛', 2, 460000, ',460000,469038,');
INSERT INTO `oa_city` VALUES (469039, '中沙群岛的岛礁及其海域', 2, 460000, ',460000,469039,');
INSERT INTO `oa_city` VALUES (500000, '重庆市', 1, 0, ',500000,');
INSERT INTO `oa_city` VALUES (500101, '万州区', 2, 500000, ',500000,500101,');
INSERT INTO `oa_city` VALUES (500102, '涪陵区', 2, 500000, ',500000,500102,');
INSERT INTO `oa_city` VALUES (500103, '渝中区', 2, 500000, ',500000,500103,');
INSERT INTO `oa_city` VALUES (500104, '大渡口区', 2, 500000, ',500000,500104,');
INSERT INTO `oa_city` VALUES (500105, '江北区', 2, 500000, ',500000,500105,');
INSERT INTO `oa_city` VALUES (500106, '沙坪坝区', 2, 500000, ',500000,500106,');
INSERT INTO `oa_city` VALUES (500107, '九龙坡区', 2, 500000, ',500000,500107,');
INSERT INTO `oa_city` VALUES (500108, '南岸区', 2, 500000, ',500000,500108,');
INSERT INTO `oa_city` VALUES (500109, '北碚区', 2, 500000, ',500000,500109,');
INSERT INTO `oa_city` VALUES (500110, '万盛区', 2, 500000, ',500000,500110,');
INSERT INTO `oa_city` VALUES (500111, '双桥区', 2, 500000, ',500000,500111,');
INSERT INTO `oa_city` VALUES (500112, '渝北区', 2, 500000, ',500000,500112,');
INSERT INTO `oa_city` VALUES (500113, '巴南区', 2, 500000, ',500000,500113,');
INSERT INTO `oa_city` VALUES (500114, '黔江区', 2, 500000, ',500000,500114,');
INSERT INTO `oa_city` VALUES (500115, '长寿区', 2, 500000, ',500000,500115,');
INSERT INTO `oa_city` VALUES (500222, '綦江县', 2, 500000, ',500000,500222,');
INSERT INTO `oa_city` VALUES (500223, '潼南县', 2, 500000, ',500000,500223,');
INSERT INTO `oa_city` VALUES (500224, '铜梁县', 2, 500000, ',500000,500224,');
INSERT INTO `oa_city` VALUES (500225, '大足县', 2, 500000, ',500000,500225,');
INSERT INTO `oa_city` VALUES (500226, '荣昌县', 2, 500000, ',500000,500226,');
INSERT INTO `oa_city` VALUES (500227, '璧山县', 2, 500000, ',500000,500227,');
INSERT INTO `oa_city` VALUES (500228, '梁平县', 2, 500000, ',500000,500228,');
INSERT INTO `oa_city` VALUES (500229, '城口县', 2, 500000, ',500000,500229,');
INSERT INTO `oa_city` VALUES (500230, '丰都县', 2, 500000, ',500000,500230,');
INSERT INTO `oa_city` VALUES (500231, '垫江县', 2, 500000, ',500000,500231,');
INSERT INTO `oa_city` VALUES (500232, '武隆县', 2, 500000, ',500000,500232,');
INSERT INTO `oa_city` VALUES (500233, '忠　县', 2, 500000, ',500000,500233,');
INSERT INTO `oa_city` VALUES (500234, '开　县', 2, 500000, ',500000,500234,');
INSERT INTO `oa_city` VALUES (500235, '云阳县', 2, 500000, ',500000,500235,');
INSERT INTO `oa_city` VALUES (500236, '奉节县', 2, 500000, ',500000,500236,');
INSERT INTO `oa_city` VALUES (500237, '巫山县', 2, 500000, ',500000,500237,');
INSERT INTO `oa_city` VALUES (500238, '巫溪县', 2, 500000, ',500000,500238,');
INSERT INTO `oa_city` VALUES (500240, '石柱土家族自治县', 2, 500000, ',500000,500240,');
INSERT INTO `oa_city` VALUES (500241, '秀山土家族苗族自治县', 2, 500000, ',500000,500241,');
INSERT INTO `oa_city` VALUES (500242, '酉阳土家族苗族自治县', 2, 500000, ',500000,500242,');
INSERT INTO `oa_city` VALUES (500243, '彭水苗族土家族自治县', 2, 500000, ',500000,500243,');
INSERT INTO `oa_city` VALUES (500381, '江津市', 2, 500000, ',500000,500381,');
INSERT INTO `oa_city` VALUES (500382, '合川市', 2, 500000, ',500000,500382,');
INSERT INTO `oa_city` VALUES (500383, '永川市', 2, 500000, ',500000,500383,');
INSERT INTO `oa_city` VALUES (500384, '南川市', 2, 500000, ',500000,500384,');
INSERT INTO `oa_city` VALUES (510000, '四川省', 1, 0, ',510000,');
INSERT INTO `oa_city` VALUES (510100, '成都市', 2, 510000, ',510000,510100,');
INSERT INTO `oa_city` VALUES (510104, '锦江区', 3, 510100, ',510000,510100,510104,');
INSERT INTO `oa_city` VALUES (510105, '青羊区', 3, 510100, ',510000,510100,510105,');
INSERT INTO `oa_city` VALUES (510106, '金牛区', 3, 510100, ',510000,510100,510106,');
INSERT INTO `oa_city` VALUES (510107, '武侯区', 3, 510100, ',510000,510100,510107,');
INSERT INTO `oa_city` VALUES (510108, '成华区', 3, 510100, ',510000,510100,510108,');
INSERT INTO `oa_city` VALUES (510112, '龙泉驿区', 3, 510100, ',510000,510100,510112,');
INSERT INTO `oa_city` VALUES (510113, '青白江区', 3, 510100, ',510000,510100,510113,');
INSERT INTO `oa_city` VALUES (510114, '新都区', 3, 510100, ',510000,510100,510114,');
INSERT INTO `oa_city` VALUES (510115, '温江区', 3, 510100, ',510000,510100,510115,');
INSERT INTO `oa_city` VALUES (510121, '金堂县', 3, 510100, ',510000,510100,510121,');
INSERT INTO `oa_city` VALUES (510122, '双流县', 3, 510100, ',510000,510100,510122,');
INSERT INTO `oa_city` VALUES (510124, '郫　县', 3, 510100, ',510000,510100,510124,');
INSERT INTO `oa_city` VALUES (510129, '大邑县', 3, 510100, ',510000,510100,510129,');
INSERT INTO `oa_city` VALUES (510131, '蒲江县', 3, 510100, ',510000,510100,510131,');
INSERT INTO `oa_city` VALUES (510132, '新津县', 3, 510100, ',510000,510100,510132,');
INSERT INTO `oa_city` VALUES (510181, '都江堰市', 3, 510100, ',510000,510100,510181,');
INSERT INTO `oa_city` VALUES (510182, '彭州市', 3, 510100, ',510000,510100,510182,');
INSERT INTO `oa_city` VALUES (510183, '邛崃市', 3, 510100, ',510000,510100,510183,');
INSERT INTO `oa_city` VALUES (510184, '崇州市', 3, 510100, ',510000,510100,510184,');
INSERT INTO `oa_city` VALUES (510300, '自贡市', 2, 510000, ',510000,510300,');
INSERT INTO `oa_city` VALUES (510302, '自流井区', 3, 510300, ',510000,510300,510302,');
INSERT INTO `oa_city` VALUES (510303, '贡井区', 3, 510300, ',510000,510300,510303,');
INSERT INTO `oa_city` VALUES (510304, '大安区', 3, 510300, ',510000,510300,510304,');
INSERT INTO `oa_city` VALUES (510311, '沿滩区', 3, 510300, ',510000,510300,510311,');
INSERT INTO `oa_city` VALUES (510321, '荣　县', 3, 510300, ',510000,510300,510321,');
INSERT INTO `oa_city` VALUES (510322, '富顺县', 3, 510300, ',510000,510300,510322,');
INSERT INTO `oa_city` VALUES (510400, '攀枝花市', 2, 510000, ',510000,510400,');
INSERT INTO `oa_city` VALUES (510402, '东　区', 3, 510400, ',510000,510400,510402,');
INSERT INTO `oa_city` VALUES (510403, '西　区', 3, 510400, ',510000,510400,510403,');
INSERT INTO `oa_city` VALUES (510411, '仁和区', 3, 510400, ',510000,510400,510411,');
INSERT INTO `oa_city` VALUES (510421, '米易县', 3, 510400, ',510000,510400,510421,');
INSERT INTO `oa_city` VALUES (510422, '盐边县', 3, 510400, ',510000,510400,510422,');
INSERT INTO `oa_city` VALUES (510500, '泸州市', 2, 510000, ',510000,510500,');
INSERT INTO `oa_city` VALUES (510502, '江阳区', 3, 510500, ',510000,510500,510502,');
INSERT INTO `oa_city` VALUES (510503, '纳溪区', 3, 510500, ',510000,510500,510503,');
INSERT INTO `oa_city` VALUES (510504, '龙马潭区', 3, 510500, ',510000,510500,510504,');
INSERT INTO `oa_city` VALUES (510521, '泸　县', 3, 510500, ',510000,510500,510521,');
INSERT INTO `oa_city` VALUES (510522, '合江县', 3, 510500, ',510000,510500,510522,');
INSERT INTO `oa_city` VALUES (510524, '叙永县', 3, 510500, ',510000,510500,510524,');
INSERT INTO `oa_city` VALUES (510525, '古蔺县', 3, 510500, ',510000,510500,510525,');
INSERT INTO `oa_city` VALUES (510600, '德阳市', 2, 510000, ',510000,510600,');
INSERT INTO `oa_city` VALUES (510603, '旌阳区', 3, 510600, ',510000,510600,510603,');
INSERT INTO `oa_city` VALUES (510623, '中江县', 3, 510600, ',510000,510600,510623,');
INSERT INTO `oa_city` VALUES (510626, '罗江县', 3, 510600, ',510000,510600,510626,');
INSERT INTO `oa_city` VALUES (510681, '广汉市', 3, 510600, ',510000,510600,510681,');
INSERT INTO `oa_city` VALUES (510682, '什邡市', 3, 510600, ',510000,510600,510682,');
INSERT INTO `oa_city` VALUES (510683, '绵竹市', 3, 510600, ',510000,510600,510683,');
INSERT INTO `oa_city` VALUES (510700, '绵阳市', 2, 510000, ',510000,510700,');
INSERT INTO `oa_city` VALUES (510703, '涪城区', 3, 510700, ',510000,510700,510703,');
INSERT INTO `oa_city` VALUES (510704, '游仙区', 3, 510700, ',510000,510700,510704,');
INSERT INTO `oa_city` VALUES (510722, '三台县', 3, 510700, ',510000,510700,510722,');
INSERT INTO `oa_city` VALUES (510723, '盐亭县', 3, 510700, ',510000,510700,510723,');
INSERT INTO `oa_city` VALUES (510724, '安　县', 3, 510700, ',510000,510700,510724,');
INSERT INTO `oa_city` VALUES (510725, '梓潼县', 3, 510700, ',510000,510700,510725,');
INSERT INTO `oa_city` VALUES (510726, '北川羌族自治县', 3, 510700, ',510000,510700,510726,');
INSERT INTO `oa_city` VALUES (510727, '平武县', 3, 510700, ',510000,510700,510727,');
INSERT INTO `oa_city` VALUES (510781, '江油市', 3, 510700, ',510000,510700,510781,');
INSERT INTO `oa_city` VALUES (510800, '广元市', 2, 510000, ',510000,510800,');
INSERT INTO `oa_city` VALUES (510802, '市中区', 3, 510800, ',510000,510800,510802,');
INSERT INTO `oa_city` VALUES (510811, '元坝区', 3, 510800, ',510000,510800,510811,');
INSERT INTO `oa_city` VALUES (510812, '朝天区', 3, 510800, ',510000,510800,510812,');
INSERT INTO `oa_city` VALUES (510821, '旺苍县', 3, 510800, ',510000,510800,510821,');
INSERT INTO `oa_city` VALUES (510822, '青川县', 3, 510800, ',510000,510800,510822,');
INSERT INTO `oa_city` VALUES (510823, '剑阁县', 3, 510800, ',510000,510800,510823,');
INSERT INTO `oa_city` VALUES (510824, '苍溪县', 3, 510800, ',510000,510800,510824,');
INSERT INTO `oa_city` VALUES (510900, '遂宁市', 2, 510000, ',510000,510900,');
INSERT INTO `oa_city` VALUES (510903, '船山区', 3, 510900, ',510000,510900,510903,');
INSERT INTO `oa_city` VALUES (510904, '安居区', 3, 510900, ',510000,510900,510904,');
INSERT INTO `oa_city` VALUES (510921, '蓬溪县', 3, 510900, ',510000,510900,510921,');
INSERT INTO `oa_city` VALUES (510922, '射洪县', 3, 510900, ',510000,510900,510922,');
INSERT INTO `oa_city` VALUES (510923, '大英县', 3, 510900, ',510000,510900,510923,');
INSERT INTO `oa_city` VALUES (511000, '内江市', 2, 510000, ',510000,511000,');
INSERT INTO `oa_city` VALUES (511002, '市中区', 3, 511000, ',510000,511000,511002,');
INSERT INTO `oa_city` VALUES (511011, '东兴区', 3, 511000, ',510000,511000,511011,');
INSERT INTO `oa_city` VALUES (511024, '威远县', 3, 511000, ',510000,511000,511024,');
INSERT INTO `oa_city` VALUES (511025, '资中县', 3, 511000, ',510000,511000,511025,');
INSERT INTO `oa_city` VALUES (511028, '隆昌县', 3, 511000, ',510000,511000,511028,');
INSERT INTO `oa_city` VALUES (511100, '乐山市', 2, 510000, ',510000,511100,');
INSERT INTO `oa_city` VALUES (511102, '市中区', 3, 511100, ',510000,511100,511102,');
INSERT INTO `oa_city` VALUES (511111, '沙湾区', 3, 511100, ',510000,511100,511111,');
INSERT INTO `oa_city` VALUES (511112, '五通桥区', 3, 511100, ',510000,511100,511112,');
INSERT INTO `oa_city` VALUES (511113, '金口河区', 3, 511100, ',510000,511100,511113,');
INSERT INTO `oa_city` VALUES (511123, '犍为县', 3, 511100, ',510000,511100,511123,');
INSERT INTO `oa_city` VALUES (511124, '井研县', 3, 511100, ',510000,511100,511124,');
INSERT INTO `oa_city` VALUES (511126, '夹江县', 3, 511100, ',510000,511100,511126,');
INSERT INTO `oa_city` VALUES (511129, '沐川县', 3, 511100, ',510000,511100,511129,');
INSERT INTO `oa_city` VALUES (511132, '峨边彝族自治县', 3, 511100, ',510000,511100,511132,');
INSERT INTO `oa_city` VALUES (511133, '马边彝族自治县', 3, 511100, ',510000,511100,511133,');
INSERT INTO `oa_city` VALUES (511181, '峨眉山市', 3, 511100, ',510000,511100,511181,');
INSERT INTO `oa_city` VALUES (511300, '南充市', 2, 510000, ',510000,511300,');
INSERT INTO `oa_city` VALUES (511302, '顺庆区', 3, 511300, ',510000,511300,511302,');
INSERT INTO `oa_city` VALUES (511303, '高坪区', 3, 511300, ',510000,511300,511303,');
INSERT INTO `oa_city` VALUES (511304, '嘉陵区', 3, 511300, ',510000,511300,511304,');
INSERT INTO `oa_city` VALUES (511321, '南部县', 3, 511300, ',510000,511300,511321,');
INSERT INTO `oa_city` VALUES (511322, '营山县', 3, 511300, ',510000,511300,511322,');
INSERT INTO `oa_city` VALUES (511323, '蓬安县', 3, 511300, ',510000,511300,511323,');
INSERT INTO `oa_city` VALUES (511324, '仪陇县', 3, 511300, ',510000,511300,511324,');
INSERT INTO `oa_city` VALUES (511325, '西充县', 3, 511300, ',510000,511300,511325,');
INSERT INTO `oa_city` VALUES (511381, '阆中市', 3, 511300, ',510000,511300,511381,');
INSERT INTO `oa_city` VALUES (511400, '眉山市', 2, 510000, ',510000,511400,');
INSERT INTO `oa_city` VALUES (511402, '东坡区', 3, 511400, ',510000,511400,511402,');
INSERT INTO `oa_city` VALUES (511421, '仁寿县', 3, 511400, ',510000,511400,511421,');
INSERT INTO `oa_city` VALUES (511422, '彭山县', 3, 511400, ',510000,511400,511422,');
INSERT INTO `oa_city` VALUES (511423, '洪雅县', 3, 511400, ',510000,511400,511423,');
INSERT INTO `oa_city` VALUES (511424, '丹棱县', 3, 511400, ',510000,511400,511424,');
INSERT INTO `oa_city` VALUES (511425, '青神县', 3, 511400, ',510000,511400,511425,');
INSERT INTO `oa_city` VALUES (511500, '宜宾市', 2, 510000, ',510000,511500,');
INSERT INTO `oa_city` VALUES (511502, '翠屏区', 3, 511500, ',510000,511500,511502,');
INSERT INTO `oa_city` VALUES (511521, '宜宾县', 3, 511500, ',510000,511500,511521,');
INSERT INTO `oa_city` VALUES (511522, '南溪县', 3, 511500, ',510000,511500,511522,');
INSERT INTO `oa_city` VALUES (511523, '江安县', 3, 511500, ',510000,511500,511523,');
INSERT INTO `oa_city` VALUES (511524, '长宁县', 3, 511500, ',510000,511500,511524,');
INSERT INTO `oa_city` VALUES (511525, '高　县', 3, 511500, ',510000,511500,511525,');
INSERT INTO `oa_city` VALUES (511526, '珙　县', 3, 511500, ',510000,511500,511526,');
INSERT INTO `oa_city` VALUES (511527, '筠连县', 3, 511500, ',510000,511500,511527,');
INSERT INTO `oa_city` VALUES (511528, '兴文县', 3, 511500, ',510000,511500,511528,');
INSERT INTO `oa_city` VALUES (511529, '屏山县', 3, 511500, ',510000,511500,511529,');
INSERT INTO `oa_city` VALUES (511600, '广安市', 2, 510000, ',510000,511600,');
INSERT INTO `oa_city` VALUES (511602, '广安区', 3, 511600, ',510000,511600,511602,');
INSERT INTO `oa_city` VALUES (511621, '岳池县', 3, 511600, ',510000,511600,511621,');
INSERT INTO `oa_city` VALUES (511622, '武胜县', 3, 511600, ',510000,511600,511622,');
INSERT INTO `oa_city` VALUES (511623, '邻水县', 3, 511600, ',510000,511600,511623,');
INSERT INTO `oa_city` VALUES (511681, '华莹市', 3, 511600, ',510000,511600,511681,');
INSERT INTO `oa_city` VALUES (511682, '前锋县', 3, 511700, ',510000,511600,511682,');
INSERT INTO `oa_city` VALUES (511683, '枣山区', 3, 511700, ',510000,511600,511683,');
INSERT INTO `oa_city` VALUES (511684, '经开区', 3, 511700, ',510000,511600,511684,');
INSERT INTO `oa_city` VALUES (511700, '达州市', 2, 510000, ',510000,511700,');
INSERT INTO `oa_city` VALUES (511702, '通川区', 3, 511700, ',510000,511700,511702,');
INSERT INTO `oa_city` VALUES (511721, '达川区', 3, 511700, ',510000,511700,511721,');
INSERT INTO `oa_city` VALUES (511722, '宣汉县', 3, 511700, ',510000,511700,511722,');
INSERT INTO `oa_city` VALUES (511723, '开江县', 3, 511700, ',510000,511700,511723,');
INSERT INTO `oa_city` VALUES (511724, '大竹县', 3, 511700, ',510000,511700,511724,');
INSERT INTO `oa_city` VALUES (511725, '渠　县', 3, 511700, ',510000,511700,511725,');
INSERT INTO `oa_city` VALUES (511781, '万源市', 3, 511700, ',510000,511700,511781,');
INSERT INTO `oa_city` VALUES (511782, '高新区', 3, 511700, ',510000,511700,511782,');
INSERT INTO `oa_city` VALUES (511783, '东部经开区', 3, 511700, ',510000,511700,511783,');
INSERT INTO `oa_city` VALUES (511800, '雅安市', 2, 510000, ',510000,511800,');
INSERT INTO `oa_city` VALUES (511802, '雨城区', 3, 511800, ',510000,511800,511802,');
INSERT INTO `oa_city` VALUES (511821, '名山县', 3, 511800, ',510000,511800,511821,');
INSERT INTO `oa_city` VALUES (511822, '荥经县', 3, 511800, ',510000,511800,511822,');
INSERT INTO `oa_city` VALUES (511823, '汉源县', 3, 511800, ',510000,511800,511823,');
INSERT INTO `oa_city` VALUES (511824, '石棉县', 3, 511800, ',510000,511800,511824,');
INSERT INTO `oa_city` VALUES (511825, '天全县', 3, 511800, ',510000,511800,511825,');
INSERT INTO `oa_city` VALUES (511826, '芦山县', 3, 511800, ',510000,511800,511826,');
INSERT INTO `oa_city` VALUES (511827, '宝兴县', 3, 511800, ',510000,511800,511827,');
INSERT INTO `oa_city` VALUES (511900, '巴中市', 2, 510000, ',510000,511900,');
INSERT INTO `oa_city` VALUES (511902, '巴州区', 3, 511900, ',510000,511900,511902,');
INSERT INTO `oa_city` VALUES (511921, '通江县', 3, 511900, ',510000,511900,511921,');
INSERT INTO `oa_city` VALUES (511922, '南江县', 3, 511900, ',510000,511900,511922,');
INSERT INTO `oa_city` VALUES (511923, '平昌县', 3, 511900, ',510000,511900,511923,');
INSERT INTO `oa_city` VALUES (512000, '资阳市', 2, 510000, ',510000,512000,');
INSERT INTO `oa_city` VALUES (512002, '雁江区', 3, 512000, ',510000,512000,512002,');
INSERT INTO `oa_city` VALUES (512021, '安岳县', 3, 512000, ',510000,512000,512021,');
INSERT INTO `oa_city` VALUES (512022, '乐至县', 3, 512000, ',510000,512000,512022,');
INSERT INTO `oa_city` VALUES (512081, '简阳市', 3, 512000, ',510000,512000,512081,');
INSERT INTO `oa_city` VALUES (513200, '阿坝藏族羌族自治州', 2, 510000, ',510000,513200,');
INSERT INTO `oa_city` VALUES (513221, '汶川县', 3, 513200, ',510000,513200,513221,');
INSERT INTO `oa_city` VALUES (513222, '理　县', 3, 513200, ',510000,513200,513222,');
INSERT INTO `oa_city` VALUES (513223, '茂　县', 3, 513200, ',510000,513200,513223,');
INSERT INTO `oa_city` VALUES (513224, '松潘县', 3, 513200, ',510000,513200,513224,');
INSERT INTO `oa_city` VALUES (513225, '九寨沟县', 3, 513200, ',510000,513200,513225,');
INSERT INTO `oa_city` VALUES (513226, '金川县', 3, 513200, ',510000,513200,513226,');
INSERT INTO `oa_city` VALUES (513227, '小金县', 3, 513200, ',510000,513200,513227,');
INSERT INTO `oa_city` VALUES (513228, '黑水县', 3, 513200, ',510000,513200,513228,');
INSERT INTO `oa_city` VALUES (513229, '马尔康县', 3, 513200, ',510000,513200,513229,');
INSERT INTO `oa_city` VALUES (513230, '壤塘县', 3, 513200, ',510000,513200,513230,');
INSERT INTO `oa_city` VALUES (513231, '阿坝县', 3, 513200, ',510000,513200,513231,');
INSERT INTO `oa_city` VALUES (513232, '若尔盖县', 3, 513200, ',510000,513200,513232,');
INSERT INTO `oa_city` VALUES (513233, '红原县', 3, 513200, ',510000,513200,513233,');
INSERT INTO `oa_city` VALUES (513300, '甘孜藏族自治州', 2, 510000, ',510000,513300,');
INSERT INTO `oa_city` VALUES (513321, '康定县', 3, 513300, ',510000,513300,513321,');
INSERT INTO `oa_city` VALUES (513322, '泸定县', 3, 513300, ',510000,513300,513322,');
INSERT INTO `oa_city` VALUES (513323, '丹巴县', 3, 513300, ',510000,513300,513323,');
INSERT INTO `oa_city` VALUES (513324, '九龙县', 3, 513300, ',510000,513300,513324,');
INSERT INTO `oa_city` VALUES (513325, '雅江县', 3, 513300, ',510000,513300,513325,');
INSERT INTO `oa_city` VALUES (513326, '道孚县', 3, 513300, ',510000,513300,513326,');
INSERT INTO `oa_city` VALUES (513327, '炉霍县', 3, 513300, ',510000,513300,513327,');
INSERT INTO `oa_city` VALUES (513328, '甘孜县', 3, 513300, ',510000,513300,513328,');
INSERT INTO `oa_city` VALUES (513329, '新龙县', 3, 513300, ',510000,513300,513329,');
INSERT INTO `oa_city` VALUES (513330, '德格县', 3, 513300, ',510000,513300,513330,');
INSERT INTO `oa_city` VALUES (513331, '白玉县', 3, 513300, ',510000,513300,513331,');
INSERT INTO `oa_city` VALUES (513332, '石渠县', 3, 513300, ',510000,513300,513332,');
INSERT INTO `oa_city` VALUES (513333, '色达县', 3, 513300, ',510000,513300,513333,');
INSERT INTO `oa_city` VALUES (513334, '理塘县', 3, 513300, ',510000,513300,513334,');
INSERT INTO `oa_city` VALUES (513335, '巴塘县', 3, 513300, ',510000,513300,513335,');
INSERT INTO `oa_city` VALUES (513336, '乡城县', 3, 513300, ',510000,513300,513336,');
INSERT INTO `oa_city` VALUES (513337, '稻城县', 3, 513300, ',510000,513300,513337,');
INSERT INTO `oa_city` VALUES (513338, '得荣县', 3, 513300, ',510000,513300,513338,');
INSERT INTO `oa_city` VALUES (513400, '凉山彝族自治州', 2, 510000, ',510000,513400,');
INSERT INTO `oa_city` VALUES (513401, '西昌市', 3, 513400, ',510000,513400,513401,');
INSERT INTO `oa_city` VALUES (513422, '木里藏族自治县', 3, 513400, ',510000,513400,513422,');
INSERT INTO `oa_city` VALUES (513423, '盐源县', 3, 513400, ',510000,513400,513423,');
INSERT INTO `oa_city` VALUES (513424, '德昌县', 3, 513400, ',510000,513400,513424,');
INSERT INTO `oa_city` VALUES (513425, '会理县', 3, 513400, ',510000,513400,513425,');
INSERT INTO `oa_city` VALUES (513426, '会东县', 3, 513400, ',510000,513400,513426,');
INSERT INTO `oa_city` VALUES (513427, '宁南县', 3, 513400, ',510000,513400,513427,');
INSERT INTO `oa_city` VALUES (513428, '普格县', 3, 513400, ',510000,513400,513428,');
INSERT INTO `oa_city` VALUES (513429, '布拖县', 3, 513400, ',510000,513400,513429,');
INSERT INTO `oa_city` VALUES (513430, '金阳县', 3, 513400, ',510000,513400,513430,');
INSERT INTO `oa_city` VALUES (513431, '昭觉县', 3, 513400, ',510000,513400,513431,');
INSERT INTO `oa_city` VALUES (513432, '喜德县', 3, 513400, ',510000,513400,513432,');
INSERT INTO `oa_city` VALUES (513433, '冕宁县', 3, 513400, ',510000,513400,513433,');
INSERT INTO `oa_city` VALUES (513434, '越西县', 3, 513400, ',510000,513400,513434,');
INSERT INTO `oa_city` VALUES (513435, '甘洛县', 3, 513400, ',510000,513400,513435,');
INSERT INTO `oa_city` VALUES (513436, '美姑县', 3, 513400, ',510000,513400,513436,');
INSERT INTO `oa_city` VALUES (513437, '雷波县', 3, 513400, ',510000,513400,513437,');
INSERT INTO `oa_city` VALUES (520000, '贵州省', 1, 0, ',520000,');
INSERT INTO `oa_city` VALUES (520100, '贵阳市', 2, 520000, ',520000,520100,');
INSERT INTO `oa_city` VALUES (520102, '南明区', 3, 520100, ',520000,520100,520102,');
INSERT INTO `oa_city` VALUES (520103, '云岩区', 3, 520100, ',520000,520100,520103,');
INSERT INTO `oa_city` VALUES (520111, '花溪区', 3, 520100, ',520000,520100,520111,');
INSERT INTO `oa_city` VALUES (520112, '乌当区', 3, 520100, ',520000,520100,520112,');
INSERT INTO `oa_city` VALUES (520113, '白云区', 3, 520100, ',520000,520100,520113,');
INSERT INTO `oa_city` VALUES (520114, '小河区', 3, 520100, ',520000,520100,520114,');
INSERT INTO `oa_city` VALUES (520115, '观山湖区', 3, 520100, ',520000,520100,520115,');
INSERT INTO `oa_city` VALUES (520121, '开阳县', 3, 520100, ',520000,520100,520121,');
INSERT INTO `oa_city` VALUES (520122, '息烽县', 3, 520100, ',520000,520100,520122,');
INSERT INTO `oa_city` VALUES (520123, '修文县', 3, 520100, ',520000,520100,520123,');
INSERT INTO `oa_city` VALUES (520181, '清镇市', 3, 520100, ',520000,520100,520181,');
INSERT INTO `oa_city` VALUES (520200, '六盘水市', 2, 520000, ',520000,520200,');
INSERT INTO `oa_city` VALUES (520201, '钟山区', 3, 520200, ',520000,520200,520201,');
INSERT INTO `oa_city` VALUES (520203, '六枝特区', 3, 520200, ',520000,520200,520203,');
INSERT INTO `oa_city` VALUES (520221, '水城县', 3, 520200, ',520000,520200,520221,');
INSERT INTO `oa_city` VALUES (520222, '盘　县', 3, 520200, ',520000,520200,520222,');
INSERT INTO `oa_city` VALUES (520300, '遵义市', 2, 520000, ',520000,520300,');
INSERT INTO `oa_city` VALUES (520302, '红花岗区', 3, 520300, ',520000,520300,520302,');
INSERT INTO `oa_city` VALUES (520303, '汇川区', 3, 520300, ',520000,520300,520303,');
INSERT INTO `oa_city` VALUES (520321, '遵义县', 3, 520300, ',520000,520300,520321,');
INSERT INTO `oa_city` VALUES (520322, '桐梓县', 3, 520300, ',520000,520300,520322,');
INSERT INTO `oa_city` VALUES (520323, '绥阳县', 3, 520300, ',520000,520300,520323,');
INSERT INTO `oa_city` VALUES (520324, '正安县', 3, 520300, ',520000,520300,520324,');
INSERT INTO `oa_city` VALUES (520325, '道真仡佬族苗族自治县', 3, 520300, ',520000,520300,520325,');
INSERT INTO `oa_city` VALUES (520326, '务川仡佬族苗族自治县', 3, 520300, ',520000,520300,520326,');
INSERT INTO `oa_city` VALUES (520327, '凤冈县', 3, 520300, ',520000,520300,520327,');
INSERT INTO `oa_city` VALUES (520328, '湄潭县', 3, 520300, ',520000,520300,520328,');
INSERT INTO `oa_city` VALUES (520329, '余庆县', 3, 520300, ',520000,520300,520329,');
INSERT INTO `oa_city` VALUES (520330, '习水县', 3, 520300, ',520000,520300,520330,');
INSERT INTO `oa_city` VALUES (520381, '赤水市', 3, 520300, ',520000,520300,520381,');
INSERT INTO `oa_city` VALUES (520382, '仁怀市', 3, 520300, ',520000,520300,520382,');
INSERT INTO `oa_city` VALUES (520400, '安顺市', 2, 520000, ',520000,520400,');
INSERT INTO `oa_city` VALUES (520402, '西秀区', 3, 520400, ',520000,520400,520402,');
INSERT INTO `oa_city` VALUES (520421, '平坝县', 3, 520400, ',520000,520400,520421,');
INSERT INTO `oa_city` VALUES (520422, '普定县', 3, 520400, ',520000,520400,520422,');
INSERT INTO `oa_city` VALUES (520423, '镇宁布依族苗族自治县', 3, 520400, ',520000,520400,520423,');
INSERT INTO `oa_city` VALUES (520424, '关岭布依族苗族自治县', 3, 520400, ',520000,520400,520424,');
INSERT INTO `oa_city` VALUES (520425, '紫云苗族布依族自治县', 3, 520400, ',520000,520400,520425,');
INSERT INTO `oa_city` VALUES (522200, '铜仁地区', 2, 520000, ',520000,522200,');
INSERT INTO `oa_city` VALUES (522201, '铜仁市', 3, 522200, ',520000,522200,522201,');
INSERT INTO `oa_city` VALUES (522222, '江口县', 3, 522200, ',520000,522200,522222,');
INSERT INTO `oa_city` VALUES (522223, '玉屏侗族自治县', 3, 522200, ',520000,522200,522223,');
INSERT INTO `oa_city` VALUES (522224, '石阡县', 3, 522200, ',520000,522200,522224,');
INSERT INTO `oa_city` VALUES (522225, '思南县', 3, 522200, ',520000,522200,522225,');
INSERT INTO `oa_city` VALUES (522226, '印江土家族苗族自治县', 3, 522200, ',520000,522200,522226,');
INSERT INTO `oa_city` VALUES (522227, '德江县', 3, 522200, ',520000,522200,522227,');
INSERT INTO `oa_city` VALUES (522228, '沿河土家族自治县', 3, 522200, ',520000,522200,522228,');
INSERT INTO `oa_city` VALUES (522229, '松桃苗族自治县', 3, 522200, ',520000,522200,522229,');
INSERT INTO `oa_city` VALUES (522230, '万山特区', 3, 522200, ',520000,522200,522230,');
INSERT INTO `oa_city` VALUES (522300, '黔西南布依族苗族自治州', 2, 520000, ',520000,522300,');
INSERT INTO `oa_city` VALUES (522301, '兴义市', 3, 522300, ',520000,522300,522301,');
INSERT INTO `oa_city` VALUES (522322, '兴仁县', 3, 522300, ',520000,522300,522322,');
INSERT INTO `oa_city` VALUES (522323, '普安县', 3, 522300, ',520000,522300,522323,');
INSERT INTO `oa_city` VALUES (522324, '晴隆县', 3, 522300, ',520000,522300,522324,');
INSERT INTO `oa_city` VALUES (522325, '贞丰县', 3, 522300, ',520000,522300,522325,');
INSERT INTO `oa_city` VALUES (522326, '望谟县', 3, 522300, ',520000,522300,522326,');
INSERT INTO `oa_city` VALUES (522327, '册亨县', 3, 522300, ',520000,522300,522327,');
INSERT INTO `oa_city` VALUES (522328, '安龙县', 3, 522300, ',520000,522300,522328,');
INSERT INTO `oa_city` VALUES (522400, '毕节地区', 2, 520000, ',520000,522400,');
INSERT INTO `oa_city` VALUES (522401, '毕节市', 3, 522400, ',520000,522400,522401,');
INSERT INTO `oa_city` VALUES (522422, '大方县', 3, 522400, ',520000,522400,522422,');
INSERT INTO `oa_city` VALUES (522423, '黔西县', 3, 522400, ',520000,522400,522423,');
INSERT INTO `oa_city` VALUES (522424, '金沙县', 3, 522400, ',520000,522400,522424,');
INSERT INTO `oa_city` VALUES (522425, '织金县', 3, 522400, ',520000,522400,522425,');
INSERT INTO `oa_city` VALUES (522426, '纳雍县', 3, 522400, ',520000,522400,522426,');
INSERT INTO `oa_city` VALUES (522427, '威宁彝族回族苗族自治县', 3, 522400, ',520000,522400,522427,');
INSERT INTO `oa_city` VALUES (522428, '赫章县', 3, 522400, ',520000,522400,522428,');
INSERT INTO `oa_city` VALUES (522600, '黔东南苗族侗族自治州', 2, 520000, ',520000,522600,');
INSERT INTO `oa_city` VALUES (522601, '凯里市', 3, 522600, ',520000,522600,522601,');
INSERT INTO `oa_city` VALUES (522622, '黄平县', 3, 522600, ',520000,522600,522622,');
INSERT INTO `oa_city` VALUES (522623, '施秉县', 3, 522600, ',520000,522600,522623,');
INSERT INTO `oa_city` VALUES (522624, '三穗县', 3, 522600, ',520000,522600,522624,');
INSERT INTO `oa_city` VALUES (522625, '镇远县', 3, 522600, ',520000,522600,522625,');
INSERT INTO `oa_city` VALUES (522626, '岑巩县', 3, 522600, ',520000,522600,522626,');
INSERT INTO `oa_city` VALUES (522627, '天柱县', 3, 522600, ',520000,522600,522627,');
INSERT INTO `oa_city` VALUES (522628, '锦屏县', 3, 522600, ',520000,522600,522628,');
INSERT INTO `oa_city` VALUES (522629, '剑河县', 3, 522600, ',520000,522600,522629,');
INSERT INTO `oa_city` VALUES (522630, '台江县', 3, 522600, ',520000,522600,522630,');
INSERT INTO `oa_city` VALUES (522631, '黎平县', 3, 522600, ',520000,522600,522631,');
INSERT INTO `oa_city` VALUES (522632, '榕江县', 3, 522600, ',520000,522600,522632,');
INSERT INTO `oa_city` VALUES (522633, '从江县', 3, 522600, ',520000,522600,522633,');
INSERT INTO `oa_city` VALUES (522634, '雷山县', 3, 522600, ',520000,522600,522634,');
INSERT INTO `oa_city` VALUES (522635, '麻江县', 3, 522600, ',520000,522600,522635,');
INSERT INTO `oa_city` VALUES (522636, '丹寨县', 3, 522600, ',520000,522600,522636,');
INSERT INTO `oa_city` VALUES (522700, '黔南布依族苗族自治州', 2, 520000, ',520000,522700,');
INSERT INTO `oa_city` VALUES (522701, '都匀市', 3, 522700, ',520000,522700,522701,');
INSERT INTO `oa_city` VALUES (522702, '福泉市', 3, 522700, ',520000,522700,522702,');
INSERT INTO `oa_city` VALUES (522722, '荔波县', 3, 522700, ',520000,522700,522722,');
INSERT INTO `oa_city` VALUES (522723, '贵定县', 3, 522700, ',520000,522700,522723,');
INSERT INTO `oa_city` VALUES (522725, '瓮安县', 3, 522700, ',520000,522700,522725,');
INSERT INTO `oa_city` VALUES (522726, '独山县', 3, 522700, ',520000,522700,522726,');
INSERT INTO `oa_city` VALUES (522727, '平塘县', 3, 522700, ',520000,522700,522727,');
INSERT INTO `oa_city` VALUES (522728, '罗甸县', 3, 522700, ',520000,522700,522728,');
INSERT INTO `oa_city` VALUES (522729, '长顺县', 3, 522700, ',520000,522700,522729,');
INSERT INTO `oa_city` VALUES (522730, '龙里县', 3, 522700, ',520000,522700,522730,');
INSERT INTO `oa_city` VALUES (522731, '惠水县', 3, 522700, ',520000,522700,522731,');
INSERT INTO `oa_city` VALUES (522732, '三都水族自治县', 3, 522700, ',520000,522700,522732,');
INSERT INTO `oa_city` VALUES (530000, '云南省', 1, 0, ',530000,');
INSERT INTO `oa_city` VALUES (530100, '昆明市', 2, 530000, ',530000,530100,');
INSERT INTO `oa_city` VALUES (530102, '五华区', 3, 530100, ',530000,530100,530102,');
INSERT INTO `oa_city` VALUES (530103, '盘龙区', 3, 530100, ',530000,530100,530103,');
INSERT INTO `oa_city` VALUES (530111, '官渡区', 3, 530100, ',530000,530100,530111,');
INSERT INTO `oa_city` VALUES (530112, '西山区', 3, 530100, ',530000,530100,530112,');
INSERT INTO `oa_city` VALUES (530113, '东川区', 3, 530100, ',530000,530100,530113,');
INSERT INTO `oa_city` VALUES (530121, '呈贡县', 3, 530100, ',530000,530100,530121,');
INSERT INTO `oa_city` VALUES (530122, '晋宁县', 3, 530100, ',530000,530100,530122,');
INSERT INTO `oa_city` VALUES (530124, '富民县', 3, 530100, ',530000,530100,530124,');
INSERT INTO `oa_city` VALUES (530125, '宜良县', 3, 530100, ',530000,530100,530125,');
INSERT INTO `oa_city` VALUES (530126, '石林彝族自治县', 3, 530100, ',530000,530100,530126,');
INSERT INTO `oa_city` VALUES (530127, '嵩明县', 3, 530100, ',530000,530100,530127,');
INSERT INTO `oa_city` VALUES (530128, '禄劝彝族苗族自治县', 3, 530100, ',530000,530100,530128,');
INSERT INTO `oa_city` VALUES (530129, '寻甸回族彝族自治县', 3, 530100, ',530000,530100,530129,');
INSERT INTO `oa_city` VALUES (530181, '安宁市', 3, 530100, ',530000,530100,530181,');
INSERT INTO `oa_city` VALUES (530300, '曲靖市', 2, 530000, ',530000,530300,');
INSERT INTO `oa_city` VALUES (530302, '麒麟区', 3, 530300, ',530000,530300,530302,');
INSERT INTO `oa_city` VALUES (530321, '马龙县', 3, 530300, ',530000,530300,530321,');
INSERT INTO `oa_city` VALUES (530322, '陆良县', 3, 530300, ',530000,530300,530322,');
INSERT INTO `oa_city` VALUES (530323, '师宗县', 3, 530300, ',530000,530300,530323,');
INSERT INTO `oa_city` VALUES (530324, '罗平县', 3, 530300, ',530000,530300,530324,');
INSERT INTO `oa_city` VALUES (530325, '富源县', 3, 530300, ',530000,530300,530325,');
INSERT INTO `oa_city` VALUES (530326, '会泽县', 3, 530300, ',530000,530300,530326,');
INSERT INTO `oa_city` VALUES (530328, '沾益县', 3, 530300, ',530000,530300,530328,');
INSERT INTO `oa_city` VALUES (530381, '宣威市', 3, 530300, ',530000,530300,530381,');
INSERT INTO `oa_city` VALUES (530400, '玉溪市', 2, 530000, ',530000,530400,');
INSERT INTO `oa_city` VALUES (530402, '红塔区', 3, 530400, ',530000,530400,530402,');
INSERT INTO `oa_city` VALUES (530421, '江川县', 3, 530400, ',530000,530400,530421,');
INSERT INTO `oa_city` VALUES (530422, '澄江县', 3, 530400, ',530000,530400,530422,');
INSERT INTO `oa_city` VALUES (530423, '通海县', 3, 530400, ',530000,530400,530423,');
INSERT INTO `oa_city` VALUES (530424, '华宁县', 3, 530400, ',530000,530400,530424,');
INSERT INTO `oa_city` VALUES (530425, '易门县', 3, 530400, ',530000,530400,530425,');
INSERT INTO `oa_city` VALUES (530426, '峨山彝族自治县', 3, 530400, ',530000,530400,530426,');
INSERT INTO `oa_city` VALUES (530427, '新平彝族傣族自治县', 3, 530400, ',530000,530400,530427,');
INSERT INTO `oa_city` VALUES (530428, '元江哈尼族彝族傣族自治县', 3, 530400, ',530000,530400,530428,');
INSERT INTO `oa_city` VALUES (530500, '保山市', 2, 530000, ',530000,530500,');
INSERT INTO `oa_city` VALUES (530502, '隆阳区', 3, 530500, ',530000,530500,530502,');
INSERT INTO `oa_city` VALUES (530521, '施甸县', 3, 530500, ',530000,530500,530521,');
INSERT INTO `oa_city` VALUES (530522, '腾冲县', 3, 530500, ',530000,530500,530522,');
INSERT INTO `oa_city` VALUES (530523, '龙陵县', 3, 530500, ',530000,530500,530523,');
INSERT INTO `oa_city` VALUES (530524, '昌宁县', 3, 530500, ',530000,530500,530524,');
INSERT INTO `oa_city` VALUES (530600, '昭通市', 2, 530000, ',530000,530600,');
INSERT INTO `oa_city` VALUES (530602, '昭阳区', 3, 530600, ',530000,530600,530602,');
INSERT INTO `oa_city` VALUES (530621, '鲁甸县', 3, 530600, ',530000,530600,530621,');
INSERT INTO `oa_city` VALUES (530622, '巧家县', 3, 530600, ',530000,530600,530622,');
INSERT INTO `oa_city` VALUES (530623, '盐津县', 3, 530600, ',530000,530600,530623,');
INSERT INTO `oa_city` VALUES (530624, '大关县', 3, 530600, ',530000,530600,530624,');
INSERT INTO `oa_city` VALUES (530625, '永善县', 3, 530600, ',530000,530600,530625,');
INSERT INTO `oa_city` VALUES (530626, '绥江县', 3, 530600, ',530000,530600,530626,');
INSERT INTO `oa_city` VALUES (530627, '镇雄县', 3, 530600, ',530000,530600,530627,');
INSERT INTO `oa_city` VALUES (530628, '彝良县', 3, 530600, ',530000,530600,530628,');
INSERT INTO `oa_city` VALUES (530629, '威信县', 3, 530600, ',530000,530600,530629,');
INSERT INTO `oa_city` VALUES (530630, '水富县', 3, 530600, ',530000,530600,530630,');
INSERT INTO `oa_city` VALUES (530700, '丽江市', 2, 530000, ',530000,530700,');
INSERT INTO `oa_city` VALUES (530702, '古城区', 3, 530700, ',530000,530700,530702,');
INSERT INTO `oa_city` VALUES (530721, '玉龙纳西族自治县', 3, 530700, ',530000,530700,530721,');
INSERT INTO `oa_city` VALUES (530722, '永胜县', 3, 530700, ',530000,530700,530722,');
INSERT INTO `oa_city` VALUES (530723, '华坪县', 3, 530700, ',530000,530700,530723,');
INSERT INTO `oa_city` VALUES (530724, '宁蒗彝族自治县', 3, 530700, ',530000,530700,530724,');
INSERT INTO `oa_city` VALUES (530800, '思茅市', 2, 530000, ',530000,530800,');
INSERT INTO `oa_city` VALUES (530802, '翠云区', 3, 530800, ',530000,530800,530802,');
INSERT INTO `oa_city` VALUES (530821, '普洱哈尼族彝族自治县', 3, 530800, ',530000,530800,530821,');
INSERT INTO `oa_city` VALUES (530822, '墨江哈尼族自治县', 3, 530800, ',530000,530800,530822,');
INSERT INTO `oa_city` VALUES (530823, '景东彝族自治县', 3, 530800, ',530000,530800,530823,');
INSERT INTO `oa_city` VALUES (530824, '景谷傣族彝族自治县', 3, 530800, ',530000,530800,530824,');
INSERT INTO `oa_city` VALUES (530825, '镇沅彝族哈尼族拉祜族自治县', 3, 530800, ',530000,530800,530825,');
INSERT INTO `oa_city` VALUES (530826, '江城哈尼族彝族自治县', 3, 530800, ',530000,530800,530826,');
INSERT INTO `oa_city` VALUES (530827, '孟连傣族拉祜族佤族自治县', 3, 530800, ',530000,530800,530827,');
INSERT INTO `oa_city` VALUES (530828, '澜沧拉祜族自治县', 3, 530800, ',530000,530800,530828,');
INSERT INTO `oa_city` VALUES (530829, '西盟佤族自治县', 3, 530800, ',530000,530800,530829,');
INSERT INTO `oa_city` VALUES (530900, '临沧市', 2, 530000, ',530000,530900,');
INSERT INTO `oa_city` VALUES (530902, '临翔区', 3, 530900, ',530000,530900,530902,');
INSERT INTO `oa_city` VALUES (530921, '凤庆县', 3, 530900, ',530000,530900,530921,');
INSERT INTO `oa_city` VALUES (530922, '云　县', 3, 530900, ',530000,530900,530922,');
INSERT INTO `oa_city` VALUES (530923, '永德县', 3, 530900, ',530000,530900,530923,');
INSERT INTO `oa_city` VALUES (530924, '镇康县', 3, 530900, ',530000,530900,530924,');
INSERT INTO `oa_city` VALUES (530925, '双江拉祜族佤族布朗族傣族自治县', 3, 530900, ',530000,530900,530925,');
INSERT INTO `oa_city` VALUES (530926, '耿马傣族佤族自治县', 3, 530900, ',530000,530900,530926,');
INSERT INTO `oa_city` VALUES (530927, '沧源佤族自治县', 3, 530900, ',530000,530900,530927,');
INSERT INTO `oa_city` VALUES (532300, '楚雄彝族自治州', 2, 530000, ',530000,532300,');
INSERT INTO `oa_city` VALUES (532301, '楚雄市', 3, 532300, ',530000,532300,532301,');
INSERT INTO `oa_city` VALUES (532322, '双柏县', 3, 532300, ',530000,532300,532322,');
INSERT INTO `oa_city` VALUES (532323, '牟定县', 3, 532300, ',530000,532300,532323,');
INSERT INTO `oa_city` VALUES (532324, '南华县', 3, 532300, ',530000,532300,532324,');
INSERT INTO `oa_city` VALUES (532325, '姚安县', 3, 532300, ',530000,532300,532325,');
INSERT INTO `oa_city` VALUES (532326, '大姚县', 3, 532300, ',530000,532300,532326,');
INSERT INTO `oa_city` VALUES (532327, '永仁县', 3, 532300, ',530000,532300,532327,');
INSERT INTO `oa_city` VALUES (532328, '元谋县', 3, 532300, ',530000,532300,532328,');
INSERT INTO `oa_city` VALUES (532329, '武定县', 3, 532300, ',530000,532300,532329,');
INSERT INTO `oa_city` VALUES (532331, '禄丰县', 3, 532300, ',530000,532300,532331,');
INSERT INTO `oa_city` VALUES (532500, '红河哈尼族彝族自治州', 2, 530000, ',530000,532500,');
INSERT INTO `oa_city` VALUES (532501, '个旧市', 3, 532500, ',530000,532500,532501,');
INSERT INTO `oa_city` VALUES (532502, '开远市', 3, 532500, ',530000,532500,532502,');
INSERT INTO `oa_city` VALUES (532522, '蒙自县', 3, 532500, ',530000,532500,532522,');
INSERT INTO `oa_city` VALUES (532523, '屏边苗族自治县', 3, 532500, ',530000,532500,532523,');
INSERT INTO `oa_city` VALUES (532524, '建水县', 3, 532500, ',530000,532500,532524,');
INSERT INTO `oa_city` VALUES (532525, '石屏县', 3, 532500, ',530000,532500,532525,');
INSERT INTO `oa_city` VALUES (532526, '弥勒县', 3, 532500, ',530000,532500,532526,');
INSERT INTO `oa_city` VALUES (532527, '泸西县', 3, 532500, ',530000,532500,532527,');
INSERT INTO `oa_city` VALUES (532528, '元阳县', 3, 532500, ',530000,532500,532528,');
INSERT INTO `oa_city` VALUES (532529, '红河县', 3, 532500, ',530000,532500,532529,');
INSERT INTO `oa_city` VALUES (532530, '金平苗族瑶族傣族自治县', 3, 532500, ',530000,532500,532530,');
INSERT INTO `oa_city` VALUES (532531, '绿春县', 3, 532500, ',530000,532500,532531,');
INSERT INTO `oa_city` VALUES (532532, '河口瑶族自治县', 3, 532500, ',530000,532500,532532,');
INSERT INTO `oa_city` VALUES (532600, '文山壮族苗族自治州', 2, 530000, ',530000,532600,');
INSERT INTO `oa_city` VALUES (532621, '文山县', 3, 532600, ',530000,532600,532621,');
INSERT INTO `oa_city` VALUES (532622, '砚山县', 3, 532600, ',530000,532600,532622,');
INSERT INTO `oa_city` VALUES (532623, '西畴县', 3, 532600, ',530000,532600,532623,');
INSERT INTO `oa_city` VALUES (532624, '麻栗坡县', 3, 532600, ',530000,532600,532624,');
INSERT INTO `oa_city` VALUES (532625, '马关县', 3, 532600, ',530000,532600,532625,');
INSERT INTO `oa_city` VALUES (532626, '丘北县', 3, 532600, ',530000,532600,532626,');
INSERT INTO `oa_city` VALUES (532627, '广南县', 3, 532600, ',530000,532600,532627,');
INSERT INTO `oa_city` VALUES (532628, '富宁县', 3, 532600, ',530000,532600,532628,');
INSERT INTO `oa_city` VALUES (532800, '西双版纳傣族自治州', 2, 530000, ',530000,532800,');
INSERT INTO `oa_city` VALUES (532801, '景洪市', 3, 532800, ',530000,532800,532801,');
INSERT INTO `oa_city` VALUES (532822, '勐海县', 3, 532800, ',530000,532800,532822,');
INSERT INTO `oa_city` VALUES (532823, '勐腊县', 3, 532800, ',530000,532800,532823,');
INSERT INTO `oa_city` VALUES (532900, '大理白族自治州', 2, 530000, ',530000,532900,');
INSERT INTO `oa_city` VALUES (532901, '大理市', 3, 532900, ',530000,532900,532901,');
INSERT INTO `oa_city` VALUES (532922, '漾濞彝族自治县', 3, 532900, ',530000,532900,532922,');
INSERT INTO `oa_city` VALUES (532923, '祥云县', 3, 532900, ',530000,532900,532923,');
INSERT INTO `oa_city` VALUES (532924, '宾川县', 3, 532900, ',530000,532900,532924,');
INSERT INTO `oa_city` VALUES (532925, '弥渡县', 3, 532900, ',530000,532900,532925,');
INSERT INTO `oa_city` VALUES (532926, '南涧彝族自治县', 3, 532900, ',530000,532900,532926,');
INSERT INTO `oa_city` VALUES (532927, '巍山彝族回族自治县', 3, 532900, ',530000,532900,532927,');
INSERT INTO `oa_city` VALUES (532928, '永平县', 3, 532900, ',530000,532900,532928,');
INSERT INTO `oa_city` VALUES (532929, '云龙县', 3, 532900, ',530000,532900,532929,');
INSERT INTO `oa_city` VALUES (532930, '洱源县', 3, 532900, ',530000,532900,532930,');
INSERT INTO `oa_city` VALUES (532931, '剑川县', 3, 532900, ',530000,532900,532931,');
INSERT INTO `oa_city` VALUES (532932, '鹤庆县', 3, 532900, ',530000,532900,532932,');
INSERT INTO `oa_city` VALUES (533100, '德宏傣族景颇族自治州', 2, 530000, ',530000,533100,');
INSERT INTO `oa_city` VALUES (533102, '瑞丽市', 3, 533100, ',530000,533100,533102,');
INSERT INTO `oa_city` VALUES (533103, '潞西市', 3, 533100, ',530000,533100,533103,');
INSERT INTO `oa_city` VALUES (533122, '梁河县', 3, 533100, ',530000,533100,533122,');
INSERT INTO `oa_city` VALUES (533123, '盈江县', 3, 533100, ',530000,533100,533123,');
INSERT INTO `oa_city` VALUES (533124, '陇川县', 3, 533100, ',530000,533100,533124,');
INSERT INTO `oa_city` VALUES (533300, '怒江傈僳族自治州', 2, 530000, ',530000,533300,');
INSERT INTO `oa_city` VALUES (533321, '泸水县', 3, 533300, ',530000,533300,533321,');
INSERT INTO `oa_city` VALUES (533323, '福贡县', 3, 533300, ',530000,533300,533323,');
INSERT INTO `oa_city` VALUES (533324, '贡山独龙族怒族自治县', 3, 533300, ',530000,533300,533324,');
INSERT INTO `oa_city` VALUES (533325, '兰坪白族普米族自治县', 3, 533300, ',530000,533300,533325,');
INSERT INTO `oa_city` VALUES (533400, '迪庆藏族自治州', 2, 530000, ',530000,533400,');
INSERT INTO `oa_city` VALUES (533421, '香格里拉县', 3, 533400, ',530000,533400,533421,');
INSERT INTO `oa_city` VALUES (533422, '德钦县', 3, 533400, ',530000,533400,533422,');
INSERT INTO `oa_city` VALUES (533423, '维西傈僳族自治县', 3, 533400, ',530000,533400,533423,');
INSERT INTO `oa_city` VALUES (540000, '西　藏', 1, 0, ',540000,');
INSERT INTO `oa_city` VALUES (540100, '拉萨市', 2, 540000, ',540000,540100,');
INSERT INTO `oa_city` VALUES (540102, '城关区', 3, 540100, ',540000,540100,540102,');
INSERT INTO `oa_city` VALUES (540121, '林周县', 3, 540100, ',540000,540100,540121,');
INSERT INTO `oa_city` VALUES (540122, '当雄县', 3, 540100, ',540000,540100,540122,');
INSERT INTO `oa_city` VALUES (540123, '尼木县', 3, 540100, ',540000,540100,540123,');
INSERT INTO `oa_city` VALUES (540124, '曲水县', 3, 540100, ',540000,540100,540124,');
INSERT INTO `oa_city` VALUES (540125, '堆龙德庆县', 3, 540100, ',540000,540100,540125,');
INSERT INTO `oa_city` VALUES (540126, '达孜县', 3, 540100, ',540000,540100,540126,');
INSERT INTO `oa_city` VALUES (540127, '墨竹工卡县', 3, 540100, ',540000,540100,540127,');
INSERT INTO `oa_city` VALUES (542100, '昌都地区', 2, 540000, ',540000,542100,');
INSERT INTO `oa_city` VALUES (542121, '昌都县', 3, 542100, ',540000,542100,542121,');
INSERT INTO `oa_city` VALUES (542122, '江达县', 3, 542100, ',540000,542100,542122,');
INSERT INTO `oa_city` VALUES (542123, '贡觉县', 3, 542100, ',540000,542100,542123,');
INSERT INTO `oa_city` VALUES (542124, '类乌齐县', 3, 542100, ',540000,542100,542124,');
INSERT INTO `oa_city` VALUES (542125, '丁青县', 3, 542100, ',540000,542100,542125,');
INSERT INTO `oa_city` VALUES (542126, '察雅县', 3, 542100, ',540000,542100,542126,');
INSERT INTO `oa_city` VALUES (542127, '八宿县', 3, 542100, ',540000,542100,542127,');
INSERT INTO `oa_city` VALUES (542128, '左贡县', 3, 542100, ',540000,542100,542128,');
INSERT INTO `oa_city` VALUES (542129, '芒康县', 3, 542100, ',540000,542100,542129,');
INSERT INTO `oa_city` VALUES (542132, '洛隆县', 3, 542100, ',540000,542100,542132,');
INSERT INTO `oa_city` VALUES (542133, '边坝县', 3, 542100, ',540000,542100,542133,');
INSERT INTO `oa_city` VALUES (542200, '山南地区', 2, 540000, ',540000,542200,');
INSERT INTO `oa_city` VALUES (542221, '乃东县', 3, 542200, ',540000,542200,542221,');
INSERT INTO `oa_city` VALUES (542222, '扎囊县', 3, 542200, ',540000,542200,542222,');
INSERT INTO `oa_city` VALUES (542223, '贡嘎县', 3, 542200, ',540000,542200,542223,');
INSERT INTO `oa_city` VALUES (542224, '桑日县', 3, 542200, ',540000,542200,542224,');
INSERT INTO `oa_city` VALUES (542225, '琼结县', 3, 542200, ',540000,542200,542225,');
INSERT INTO `oa_city` VALUES (542226, '曲松县', 3, 542200, ',540000,542200,542226,');
INSERT INTO `oa_city` VALUES (542227, '措美县', 3, 542200, ',540000,542200,542227,');
INSERT INTO `oa_city` VALUES (542228, '洛扎县', 3, 542200, ',540000,542200,542228,');
INSERT INTO `oa_city` VALUES (542229, '加查县', 3, 542200, ',540000,542200,542229,');
INSERT INTO `oa_city` VALUES (542231, '隆子县', 3, 542200, ',540000,542200,542231,');
INSERT INTO `oa_city` VALUES (542232, '错那县', 3, 542200, ',540000,542200,542232,');
INSERT INTO `oa_city` VALUES (542233, '浪卡子县', 3, 542200, ',540000,542200,542233,');
INSERT INTO `oa_city` VALUES (542300, '日喀则地区', 2, 540000, ',540000,542300,');
INSERT INTO `oa_city` VALUES (542301, '日喀则市', 3, 542300, ',540000,542300,542301,');
INSERT INTO `oa_city` VALUES (542322, '南木林县', 3, 542300, ',540000,542300,542322,');
INSERT INTO `oa_city` VALUES (542323, '江孜县', 3, 542300, ',540000,542300,542323,');
INSERT INTO `oa_city` VALUES (542324, '定日县', 3, 542300, ',540000,542300,542324,');
INSERT INTO `oa_city` VALUES (542325, '萨迦县', 3, 542300, ',540000,542300,542325,');
INSERT INTO `oa_city` VALUES (542326, '拉孜县', 3, 542300, ',540000,542300,542326,');
INSERT INTO `oa_city` VALUES (542327, '昂仁县', 3, 542300, ',540000,542300,542327,');
INSERT INTO `oa_city` VALUES (542328, '谢通门县', 3, 542300, ',540000,542300,542328,');
INSERT INTO `oa_city` VALUES (542329, '白朗县', 3, 542300, ',540000,542300,542329,');
INSERT INTO `oa_city` VALUES (542330, '仁布县', 3, 542300, ',540000,542300,542330,');
INSERT INTO `oa_city` VALUES (542331, '康马县', 3, 542300, ',540000,542300,542331,');
INSERT INTO `oa_city` VALUES (542332, '定结县', 3, 542300, ',540000,542300,542332,');
INSERT INTO `oa_city` VALUES (542333, '仲巴县', 3, 542300, ',540000,542300,542333,');
INSERT INTO `oa_city` VALUES (542334, '亚东县', 3, 542300, ',540000,542300,542334,');
INSERT INTO `oa_city` VALUES (542335, '吉隆县', 3, 542300, ',540000,542300,542335,');
INSERT INTO `oa_city` VALUES (542336, '聂拉木县', 3, 542300, ',540000,542300,542336,');
INSERT INTO `oa_city` VALUES (542337, '萨嘎县', 3, 542300, ',540000,542300,542337,');
INSERT INTO `oa_city` VALUES (542338, '岗巴县', 3, 542300, ',540000,542300,542338,');
INSERT INTO `oa_city` VALUES (542400, '那曲地区', 2, 540000, ',540000,542400,');
INSERT INTO `oa_city` VALUES (542421, '那曲县', 3, 542400, ',540000,542400,542421,');
INSERT INTO `oa_city` VALUES (542422, '嘉黎县', 3, 542400, ',540000,542400,542422,');
INSERT INTO `oa_city` VALUES (542423, '比如县', 3, 542400, ',540000,542400,542423,');
INSERT INTO `oa_city` VALUES (542424, '聂荣县', 3, 542400, ',540000,542400,542424,');
INSERT INTO `oa_city` VALUES (542425, '安多县', 3, 542400, ',540000,542400,542425,');
INSERT INTO `oa_city` VALUES (542426, '申扎县', 3, 542400, ',540000,542400,542426,');
INSERT INTO `oa_city` VALUES (542427, '索　县', 3, 542400, ',540000,542400,542427,');
INSERT INTO `oa_city` VALUES (542428, '班戈县', 3, 542400, ',540000,542400,542428,');
INSERT INTO `oa_city` VALUES (542429, '巴青县', 3, 542400, ',540000,542400,542429,');
INSERT INTO `oa_city` VALUES (542430, '尼玛县', 3, 542400, ',540000,542400,542430,');
INSERT INTO `oa_city` VALUES (542500, '阿里地区', 2, 540000, ',540000,542500,');
INSERT INTO `oa_city` VALUES (542521, '普兰县', 3, 542500, ',540000,542500,542521,');
INSERT INTO `oa_city` VALUES (542522, '札达县', 3, 542500, ',540000,542500,542522,');
INSERT INTO `oa_city` VALUES (542523, '噶尔县', 3, 542500, ',540000,542500,542523,');
INSERT INTO `oa_city` VALUES (542524, '日土县', 3, 542500, ',540000,542500,542524,');
INSERT INTO `oa_city` VALUES (542525, '革吉县', 3, 542500, ',540000,542500,542525,');
INSERT INTO `oa_city` VALUES (542526, '改则县', 3, 542500, ',540000,542500,542526,');
INSERT INTO `oa_city` VALUES (542527, '措勤县', 3, 542500, ',540000,542500,542527,');
INSERT INTO `oa_city` VALUES (542600, '林芝地区', 2, 540000, ',540000,542600,');
INSERT INTO `oa_city` VALUES (542621, '林芝县', 3, 542600, ',540000,542600,542621,');
INSERT INTO `oa_city` VALUES (542622, '工布江达县', 3, 542600, ',540000,542600,542622,');
INSERT INTO `oa_city` VALUES (542623, '米林县', 3, 542600, ',540000,542600,542623,');
INSERT INTO `oa_city` VALUES (542624, '墨脱县', 3, 542600, ',540000,542600,542624,');
INSERT INTO `oa_city` VALUES (542625, '波密县', 3, 542600, ',540000,542600,542625,');
INSERT INTO `oa_city` VALUES (542626, '察隅县', 3, 542600, ',540000,542600,542626,');
INSERT INTO `oa_city` VALUES (542627, '朗　县', 3, 542600, ',540000,542600,542627,');
INSERT INTO `oa_city` VALUES (610000, '陕西省', 1, 0, ',610000,');
INSERT INTO `oa_city` VALUES (610100, '西安市', 2, 610000, ',610000,610100,');
INSERT INTO `oa_city` VALUES (610102, '新城区', 3, 610100, ',610000,610100,610102,');
INSERT INTO `oa_city` VALUES (610103, '碑林区', 3, 610100, ',610000,610100,610103,');
INSERT INTO `oa_city` VALUES (610104, '莲湖区', 3, 610100, ',610000,610100,610104,');
INSERT INTO `oa_city` VALUES (610111, '灞桥区', 3, 610100, ',610000,610100,610111,');
INSERT INTO `oa_city` VALUES (610112, '未央区', 3, 610100, ',610000,610100,610112,');
INSERT INTO `oa_city` VALUES (610113, '雁塔区', 3, 610100, ',610000,610100,610113,');
INSERT INTO `oa_city` VALUES (610114, '阎良区', 3, 610100, ',610000,610100,610114,');
INSERT INTO `oa_city` VALUES (610115, '临潼区', 3, 610100, ',610000,610100,610115,');
INSERT INTO `oa_city` VALUES (610116, '长安区', 3, 610100, ',610000,610100,610116,');
INSERT INTO `oa_city` VALUES (610122, '蓝田县', 3, 610100, ',610000,610100,610122,');
INSERT INTO `oa_city` VALUES (610124, '周至县', 3, 610100, ',610000,610100,610124,');
INSERT INTO `oa_city` VALUES (610125, '户　县', 3, 610100, ',610000,610100,610125,');
INSERT INTO `oa_city` VALUES (610126, '高陵县', 3, 610100, ',610000,610100,610126,');
INSERT INTO `oa_city` VALUES (610200, '铜川市', 2, 610000, ',610000,610200,');
INSERT INTO `oa_city` VALUES (610202, '王益区', 3, 610200, ',610000,610200,610202,');
INSERT INTO `oa_city` VALUES (610203, '印台区', 3, 610200, ',610000,610200,610203,');
INSERT INTO `oa_city` VALUES (610204, '耀州区', 3, 610200, ',610000,610200,610204,');
INSERT INTO `oa_city` VALUES (610222, '宜君县', 3, 610200, ',610000,610200,610222,');
INSERT INTO `oa_city` VALUES (610300, '宝鸡市', 2, 610000, ',610000,610300,');
INSERT INTO `oa_city` VALUES (610302, '渭滨区', 3, 610300, ',610000,610300,610302,');
INSERT INTO `oa_city` VALUES (610303, '金台区', 3, 610300, ',610000,610300,610303,');
INSERT INTO `oa_city` VALUES (610304, '陈仓区', 3, 610300, ',610000,610300,610304,');
INSERT INTO `oa_city` VALUES (610322, '凤翔县', 3, 610300, ',610000,610300,610322,');
INSERT INTO `oa_city` VALUES (610323, '岐山县', 3, 610300, ',610000,610300,610323,');
INSERT INTO `oa_city` VALUES (610324, '扶风县', 3, 610300, ',610000,610300,610324,');
INSERT INTO `oa_city` VALUES (610326, '眉　县', 3, 610300, ',610000,610300,610326,');
INSERT INTO `oa_city` VALUES (610327, '陇　县', 3, 610300, ',610000,610300,610327,');
INSERT INTO `oa_city` VALUES (610328, '千阳县', 3, 610300, ',610000,610300,610328,');
INSERT INTO `oa_city` VALUES (610329, '麟游县', 3, 610300, ',610000,610300,610329,');
INSERT INTO `oa_city` VALUES (610330, '凤　县', 3, 610300, ',610000,610300,610330,');
INSERT INTO `oa_city` VALUES (610331, '太白县', 3, 610300, ',610000,610300,610331,');
INSERT INTO `oa_city` VALUES (610400, '咸阳市', 2, 610000, ',610000,610400,');
INSERT INTO `oa_city` VALUES (610402, '秦都区', 3, 610400, ',610000,610400,610402,');
INSERT INTO `oa_city` VALUES (610403, '杨凌区', 3, 610400, ',610000,610400,610403,');
INSERT INTO `oa_city` VALUES (610404, '渭城区', 3, 610400, ',610000,610400,610404,');
INSERT INTO `oa_city` VALUES (610422, '三原县', 3, 610400, ',610000,610400,610422,');
INSERT INTO `oa_city` VALUES (610423, '泾阳县', 3, 610400, ',610000,610400,610423,');
INSERT INTO `oa_city` VALUES (610424, '乾　县', 3, 610400, ',610000,610400,610424,');
INSERT INTO `oa_city` VALUES (610425, '礼泉县', 3, 610400, ',610000,610400,610425,');
INSERT INTO `oa_city` VALUES (610426, '永寿县', 3, 610400, ',610000,610400,610426,');
INSERT INTO `oa_city` VALUES (610427, '彬　县', 3, 610400, ',610000,610400,610427,');
INSERT INTO `oa_city` VALUES (610428, '长武县', 3, 610400, ',610000,610400,610428,');
INSERT INTO `oa_city` VALUES (610429, '旬邑县', 3, 610400, ',610000,610400,610429,');
INSERT INTO `oa_city` VALUES (610430, '淳化县', 3, 610400, ',610000,610400,610430,');
INSERT INTO `oa_city` VALUES (610431, '武功县', 3, 610400, ',610000,610400,610431,');
INSERT INTO `oa_city` VALUES (610481, '兴平市', 3, 610400, ',610000,610400,610481,');
INSERT INTO `oa_city` VALUES (610500, '渭南市', 2, 610000, ',610000,610500,');
INSERT INTO `oa_city` VALUES (610502, '临渭区', 3, 610500, ',610000,610500,610502,');
INSERT INTO `oa_city` VALUES (610521, '华　县', 3, 610500, ',610000,610500,610521,');
INSERT INTO `oa_city` VALUES (610522, '潼关县', 3, 610500, ',610000,610500,610522,');
INSERT INTO `oa_city` VALUES (610523, '大荔县', 3, 610500, ',610000,610500,610523,');
INSERT INTO `oa_city` VALUES (610524, '合阳县', 3, 610500, ',610000,610500,610524,');
INSERT INTO `oa_city` VALUES (610525, '澄城县', 3, 610500, ',610000,610500,610525,');
INSERT INTO `oa_city` VALUES (610526, '蒲城县', 3, 610500, ',610000,610500,610526,');
INSERT INTO `oa_city` VALUES (610527, '白水县', 3, 610500, ',610000,610500,610527,');
INSERT INTO `oa_city` VALUES (610528, '富平县', 3, 610500, ',610000,610500,610528,');
INSERT INTO `oa_city` VALUES (610581, '韩城市', 3, 610500, ',610000,610500,610581,');
INSERT INTO `oa_city` VALUES (610582, '华阴市', 3, 610500, ',610000,610500,610582,');
INSERT INTO `oa_city` VALUES (610600, '延安市', 2, 610000, ',610000,610600,');
INSERT INTO `oa_city` VALUES (610602, '宝塔区', 3, 610600, ',610000,610600,610602,');
INSERT INTO `oa_city` VALUES (610621, '延长县', 3, 610600, ',610000,610600,610621,');
INSERT INTO `oa_city` VALUES (610622, '延川县', 3, 610600, ',610000,610600,610622,');
INSERT INTO `oa_city` VALUES (610623, '子长县', 3, 610600, ',610000,610600,610623,');
INSERT INTO `oa_city` VALUES (610624, '安塞县', 3, 610600, ',610000,610600,610624,');
INSERT INTO `oa_city` VALUES (610625, '志丹县', 3, 610600, ',610000,610600,610625,');
INSERT INTO `oa_city` VALUES (610626, '吴旗县', 3, 610600, ',610000,610600,610626,');
INSERT INTO `oa_city` VALUES (610627, '甘泉县', 3, 610600, ',610000,610600,610627,');
INSERT INTO `oa_city` VALUES (610628, '富　县', 3, 610600, ',610000,610600,610628,');
INSERT INTO `oa_city` VALUES (610629, '洛川县', 3, 610600, ',610000,610600,610629,');
INSERT INTO `oa_city` VALUES (610630, '宜川县', 3, 610600, ',610000,610600,610630,');
INSERT INTO `oa_city` VALUES (610631, '黄龙县', 3, 610600, ',610000,610600,610631,');
INSERT INTO `oa_city` VALUES (610632, '黄陵县', 3, 610600, ',610000,610600,610632,');
INSERT INTO `oa_city` VALUES (610700, '汉中市', 2, 610000, ',610000,610700,');
INSERT INTO `oa_city` VALUES (610702, '汉台区', 3, 610700, ',610000,610700,610702,');
INSERT INTO `oa_city` VALUES (610721, '南郑县', 3, 610700, ',610000,610700,610721,');
INSERT INTO `oa_city` VALUES (610722, '城固县', 3, 610700, ',610000,610700,610722,');
INSERT INTO `oa_city` VALUES (610723, '洋　县', 3, 610700, ',610000,610700,610723,');
INSERT INTO `oa_city` VALUES (610724, '西乡县', 3, 610700, ',610000,610700,610724,');
INSERT INTO `oa_city` VALUES (610725, '勉　县', 3, 610700, ',610000,610700,610725,');
INSERT INTO `oa_city` VALUES (610726, '宁强县', 3, 610700, ',610000,610700,610726,');
INSERT INTO `oa_city` VALUES (610727, '略阳县', 3, 610700, ',610000,610700,610727,');
INSERT INTO `oa_city` VALUES (610728, '镇巴县', 3, 610700, ',610000,610700,610728,');
INSERT INTO `oa_city` VALUES (610729, '留坝县', 3, 610700, ',610000,610700,610729,');
INSERT INTO `oa_city` VALUES (610730, '佛坪县', 3, 610700, ',610000,610700,610730,');
INSERT INTO `oa_city` VALUES (610800, '榆林市', 2, 610000, ',610000,610800,');
INSERT INTO `oa_city` VALUES (610802, '榆阳区', 3, 610800, ',610000,610800,610802,');
INSERT INTO `oa_city` VALUES (610821, '神木县', 3, 610800, ',610000,610800,610821,');
INSERT INTO `oa_city` VALUES (610822, '府谷县', 3, 610800, ',610000,610800,610822,');
INSERT INTO `oa_city` VALUES (610823, '横山县', 3, 610800, ',610000,610800,610823,');
INSERT INTO `oa_city` VALUES (610824, '靖边县', 3, 610800, ',610000,610800,610824,');
INSERT INTO `oa_city` VALUES (610825, '定边县', 3, 610800, ',610000,610800,610825,');
INSERT INTO `oa_city` VALUES (610826, '绥德县', 3, 610800, ',610000,610800,610826,');
INSERT INTO `oa_city` VALUES (610827, '米脂县', 3, 610800, ',610000,610800,610827,');
INSERT INTO `oa_city` VALUES (610828, '佳　县', 3, 610800, ',610000,610800,610828,');
INSERT INTO `oa_city` VALUES (610829, '吴堡县', 3, 610800, ',610000,610800,610829,');
INSERT INTO `oa_city` VALUES (610830, '清涧县', 3, 610800, ',610000,610800,610830,');
INSERT INTO `oa_city` VALUES (610831, '子洲县', 3, 610800, ',610000,610800,610831,');
INSERT INTO `oa_city` VALUES (610900, '安康市', 2, 610000, ',610000,610900,');
INSERT INTO `oa_city` VALUES (610902, '汉滨区', 3, 610900, ',610000,610900,610902,');
INSERT INTO `oa_city` VALUES (610921, '汉阴县', 3, 610900, ',610000,610900,610921,');
INSERT INTO `oa_city` VALUES (610922, '石泉县', 3, 610900, ',610000,610900,610922,');
INSERT INTO `oa_city` VALUES (610923, '宁陕县', 3, 610900, ',610000,610900,610923,');
INSERT INTO `oa_city` VALUES (610924, '紫阳县', 3, 610900, ',610000,610900,610924,');
INSERT INTO `oa_city` VALUES (610925, '岚皋县', 3, 610900, ',610000,610900,610925,');
INSERT INTO `oa_city` VALUES (610926, '平利县', 3, 610900, ',610000,610900,610926,');
INSERT INTO `oa_city` VALUES (610927, '镇坪县', 3, 610900, ',610000,610900,610927,');
INSERT INTO `oa_city` VALUES (610928, '旬阳县', 3, 610900, ',610000,610900,610928,');
INSERT INTO `oa_city` VALUES (610929, '白河县', 3, 610900, ',610000,610900,610929,');
INSERT INTO `oa_city` VALUES (611000, '商洛市', 2, 610000, ',610000,611000,');
INSERT INTO `oa_city` VALUES (611002, '商州区', 3, 611000, ',610000,611000,611002,');
INSERT INTO `oa_city` VALUES (611021, '洛南县', 3, 611000, ',610000,611000,611021,');
INSERT INTO `oa_city` VALUES (611022, '丹凤县', 3, 611000, ',610000,611000,611022,');
INSERT INTO `oa_city` VALUES (611023, '商南县', 3, 611000, ',610000,611000,611023,');
INSERT INTO `oa_city` VALUES (611024, '山阳县', 3, 611000, ',610000,611000,611024,');
INSERT INTO `oa_city` VALUES (611025, '镇安县', 3, 611000, ',610000,611000,611025,');
INSERT INTO `oa_city` VALUES (611026, '柞水县', 3, 611000, ',610000,611000,611026,');
INSERT INTO `oa_city` VALUES (620000, '甘肃省', 1, 0, ',620000,');
INSERT INTO `oa_city` VALUES (620100, '兰州市', 2, 620000, ',620000,620100,');
INSERT INTO `oa_city` VALUES (620102, '城关区', 3, 620100, ',620000,620100,620102,');
INSERT INTO `oa_city` VALUES (620103, '七里河区', 3, 620100, ',620000,620100,620103,');
INSERT INTO `oa_city` VALUES (620104, '西固区', 3, 620100, ',620000,620100,620104,');
INSERT INTO `oa_city` VALUES (620105, '安宁区', 3, 620100, ',620000,620100,620105,');
INSERT INTO `oa_city` VALUES (620111, '红古区', 3, 620100, ',620000,620100,620111,');
INSERT INTO `oa_city` VALUES (620121, '永登县', 3, 620100, ',620000,620100,620121,');
INSERT INTO `oa_city` VALUES (620122, '皋兰县', 3, 620100, ',620000,620100,620122,');
INSERT INTO `oa_city` VALUES (620123, '榆中县', 3, 620100, ',620000,620100,620123,');
INSERT INTO `oa_city` VALUES (620200, '嘉峪关市', 2, 620000, ',620000,620200,');
INSERT INTO `oa_city` VALUES (620300, '金昌市', 2, 620000, ',620000,620300,');
INSERT INTO `oa_city` VALUES (620302, '金川区', 3, 620300, ',620000,620300,620302,');
INSERT INTO `oa_city` VALUES (620321, '永昌县', 3, 620300, ',620000,620300,620321,');
INSERT INTO `oa_city` VALUES (620400, '白银市', 2, 620000, ',620000,620400,');
INSERT INTO `oa_city` VALUES (620402, '白银区', 3, 620400, ',620000,620400,620402,');
INSERT INTO `oa_city` VALUES (620403, '平川区', 3, 620400, ',620000,620400,620403,');
INSERT INTO `oa_city` VALUES (620421, '靖远县', 3, 620400, ',620000,620400,620421,');
INSERT INTO `oa_city` VALUES (620422, '会宁县', 3, 620400, ',620000,620400,620422,');
INSERT INTO `oa_city` VALUES (620423, '景泰县', 3, 620400, ',620000,620400,620423,');
INSERT INTO `oa_city` VALUES (620500, '天水市', 2, 620000, ',620000,620500,');
INSERT INTO `oa_city` VALUES (620502, '秦城区', 3, 620500, ',620000,620500,620502,');
INSERT INTO `oa_city` VALUES (620503, '北道区', 3, 620500, ',620000,620500,620503,');
INSERT INTO `oa_city` VALUES (620521, '清水县', 3, 620500, ',620000,620500,620521,');
INSERT INTO `oa_city` VALUES (620522, '秦安县', 3, 620500, ',620000,620500,620522,');
INSERT INTO `oa_city` VALUES (620523, '甘谷县', 3, 620500, ',620000,620500,620523,');
INSERT INTO `oa_city` VALUES (620524, '武山县', 3, 620500, ',620000,620500,620524,');
INSERT INTO `oa_city` VALUES (620525, '张家川回族自治县', 3, 620500, ',620000,620500,620525,');
INSERT INTO `oa_city` VALUES (620600, '武威市', 2, 620000, ',620000,620600,');
INSERT INTO `oa_city` VALUES (620602, '凉州区', 3, 620600, ',620000,620600,620602,');
INSERT INTO `oa_city` VALUES (620621, '民勤县', 3, 620600, ',620000,620600,620621,');
INSERT INTO `oa_city` VALUES (620622, '古浪县', 3, 620600, ',620000,620600,620622,');
INSERT INTO `oa_city` VALUES (620623, '天祝藏族自治县', 3, 620600, ',620000,620600,620623,');
INSERT INTO `oa_city` VALUES (620700, '张掖市', 2, 620000, ',620000,620700,');
INSERT INTO `oa_city` VALUES (620702, '甘州区', 3, 620700, ',620000,620700,620702,');
INSERT INTO `oa_city` VALUES (620721, '肃南裕固族自治县', 3, 620700, ',620000,620700,620721,');
INSERT INTO `oa_city` VALUES (620722, '民乐县', 3, 620700, ',620000,620700,620722,');
INSERT INTO `oa_city` VALUES (620723, '临泽县', 3, 620700, ',620000,620700,620723,');
INSERT INTO `oa_city` VALUES (620724, '高台县', 3, 620700, ',620000,620700,620724,');
INSERT INTO `oa_city` VALUES (620725, '山丹县', 3, 620700, ',620000,620700,620725,');
INSERT INTO `oa_city` VALUES (620800, '平凉市', 2, 620000, ',620000,620800,');
INSERT INTO `oa_city` VALUES (620802, '崆峒区', 3, 620800, ',620000,620800,620802,');
INSERT INTO `oa_city` VALUES (620821, '泾川县', 3, 620800, ',620000,620800,620821,');
INSERT INTO `oa_city` VALUES (620822, '灵台县', 3, 620800, ',620000,620800,620822,');
INSERT INTO `oa_city` VALUES (620823, '崇信县', 3, 620800, ',620000,620800,620823,');
INSERT INTO `oa_city` VALUES (620824, '华亭县', 3, 620800, ',620000,620800,620824,');
INSERT INTO `oa_city` VALUES (620825, '庄浪县', 3, 620800, ',620000,620800,620825,');
INSERT INTO `oa_city` VALUES (620826, '静宁县', 3, 620800, ',620000,620800,620826,');
INSERT INTO `oa_city` VALUES (620900, '酒泉市', 2, 620000, ',620000,620900,');
INSERT INTO `oa_city` VALUES (620902, '肃州区', 3, 620900, ',620000,620900,620902,');
INSERT INTO `oa_city` VALUES (620921, '金塔县', 3, 620900, ',620000,620900,620921,');
INSERT INTO `oa_city` VALUES (620922, '安西县', 3, 620900, ',620000,620900,620922,');
INSERT INTO `oa_city` VALUES (620923, '肃北蒙古族自治县', 3, 620900, ',620000,620900,620923,');
INSERT INTO `oa_city` VALUES (620924, '阿克塞哈萨克族自治县', 3, 620900, ',620000,620900,620924,');
INSERT INTO `oa_city` VALUES (620981, '玉门市', 3, 620900, ',620000,620900,620981,');
INSERT INTO `oa_city` VALUES (620982, '敦煌市', 3, 620900, ',620000,620900,620982,');
INSERT INTO `oa_city` VALUES (621000, '庆阳市', 2, 620000, ',620000,621000,');
INSERT INTO `oa_city` VALUES (621002, '西峰区', 3, 621000, ',620000,621000,621002,');
INSERT INTO `oa_city` VALUES (621021, '庆城县', 3, 621000, ',620000,621000,621021,');
INSERT INTO `oa_city` VALUES (621022, '环　县', 3, 621000, ',620000,621000,621022,');
INSERT INTO `oa_city` VALUES (621023, '华池县', 3, 621000, ',620000,621000,621023,');
INSERT INTO `oa_city` VALUES (621024, '合水县', 3, 621000, ',620000,621000,621024,');
INSERT INTO `oa_city` VALUES (621025, '正宁县', 3, 621000, ',620000,621000,621025,');
INSERT INTO `oa_city` VALUES (621026, '宁　县', 3, 621000, ',620000,621000,621026,');
INSERT INTO `oa_city` VALUES (621027, '镇原县', 3, 621000, ',620000,621000,621027,');
INSERT INTO `oa_city` VALUES (621100, '定西市', 2, 620000, ',620000,621100,');
INSERT INTO `oa_city` VALUES (621102, '安定区', 3, 621100, ',620000,621100,621102,');
INSERT INTO `oa_city` VALUES (621121, '通渭县', 3, 621100, ',620000,621100,621121,');
INSERT INTO `oa_city` VALUES (621122, '陇西县', 3, 621100, ',620000,621100,621122,');
INSERT INTO `oa_city` VALUES (621123, '渭源县', 3, 621100, ',620000,621100,621123,');
INSERT INTO `oa_city` VALUES (621124, '临洮县', 3, 621100, ',620000,621100,621124,');
INSERT INTO `oa_city` VALUES (621125, '漳　县', 3, 621100, ',620000,621100,621125,');
INSERT INTO `oa_city` VALUES (621126, '岷　县', 3, 621100, ',620000,621100,621126,');
INSERT INTO `oa_city` VALUES (621200, '陇南市', 2, 620000, ',620000,621200,');
INSERT INTO `oa_city` VALUES (621202, '武都区', 3, 621200, ',620000,621200,621202,');
INSERT INTO `oa_city` VALUES (621221, '成　县', 3, 621200, ',620000,621200,621221,');
INSERT INTO `oa_city` VALUES (621222, '文　县', 3, 621200, ',620000,621200,621222,');
INSERT INTO `oa_city` VALUES (621223, '宕昌县', 3, 621200, ',620000,621200,621223,');
INSERT INTO `oa_city` VALUES (621224, '康　县', 3, 621200, ',620000,621200,621224,');
INSERT INTO `oa_city` VALUES (621225, '西和县', 3, 621200, ',620000,621200,621225,');
INSERT INTO `oa_city` VALUES (621226, '礼　县', 3, 621200, ',620000,621200,621226,');
INSERT INTO `oa_city` VALUES (621227, '徽　县', 3, 621200, ',620000,621200,621227,');
INSERT INTO `oa_city` VALUES (621228, '两当县', 3, 621200, ',620000,621200,621228,');
INSERT INTO `oa_city` VALUES (622900, '临夏回族自治州', 2, 620000, ',620000,622900,');
INSERT INTO `oa_city` VALUES (622901, '临夏市', 3, 622900, ',620000,622900,622901,');
INSERT INTO `oa_city` VALUES (622921, '临夏县', 3, 622900, ',620000,622900,622921,');
INSERT INTO `oa_city` VALUES (622922, '康乐县', 3, 622900, ',620000,622900,622922,');
INSERT INTO `oa_city` VALUES (622923, '永靖县', 3, 622900, ',620000,622900,622923,');
INSERT INTO `oa_city` VALUES (622924, '广河县', 3, 622900, ',620000,622900,622924,');
INSERT INTO `oa_city` VALUES (622925, '和政县', 3, 622900, ',620000,622900,622925,');
INSERT INTO `oa_city` VALUES (622926, '东乡族自治县', 3, 622900, ',620000,622900,622926,');
INSERT INTO `oa_city` VALUES (622927, '积石山保安族东乡族撒拉族自治县', 3, 622900, ',620000,622900,622927,');
INSERT INTO `oa_city` VALUES (623000, '甘南藏族自治州', 2, 620000, ',620000,623000,');
INSERT INTO `oa_city` VALUES (623001, '合作市', 3, 623000, ',620000,623000,623001,');
INSERT INTO `oa_city` VALUES (623021, '临潭县', 3, 623000, ',620000,623000,623021,');
INSERT INTO `oa_city` VALUES (623022, '卓尼县', 3, 623000, ',620000,623000,623022,');
INSERT INTO `oa_city` VALUES (623023, '舟曲县', 3, 623000, ',620000,623000,623023,');
INSERT INTO `oa_city` VALUES (623024, '迭部县', 3, 623000, ',620000,623000,623024,');
INSERT INTO `oa_city` VALUES (623025, '玛曲县', 3, 623000, ',620000,623000,623025,');
INSERT INTO `oa_city` VALUES (623026, '碌曲县', 3, 623000, ',620000,623000,623026,');
INSERT INTO `oa_city` VALUES (623027, '夏河县', 3, 623000, ',620000,623000,623027,');
INSERT INTO `oa_city` VALUES (630000, '青海省', 1, 0, ',630000,');
INSERT INTO `oa_city` VALUES (630100, '西宁市', 2, 630000, ',630000,630100,');
INSERT INTO `oa_city` VALUES (630102, '城东区', 3, 630100, ',630000,630100,630102,');
INSERT INTO `oa_city` VALUES (630103, '城中区', 3, 630100, ',630000,630100,630103,');
INSERT INTO `oa_city` VALUES (630104, '城西区', 3, 630100, ',630000,630100,630104,');
INSERT INTO `oa_city` VALUES (630105, '城北区', 3, 630100, ',630000,630100,630105,');
INSERT INTO `oa_city` VALUES (630121, '大通回族土族自治县', 3, 630100, ',630000,630100,630121,');
INSERT INTO `oa_city` VALUES (630122, '湟中县', 3, 630100, ',630000,630100,630122,');
INSERT INTO `oa_city` VALUES (630123, '湟源县', 3, 630100, ',630000,630100,630123,');
INSERT INTO `oa_city` VALUES (632100, '海东地区', 2, 630000, ',630000,632100,');
INSERT INTO `oa_city` VALUES (632121, '平安县', 3, 632100, ',630000,632100,632121,');
INSERT INTO `oa_city` VALUES (632122, '民和回族土族自治县', 3, 632100, ',630000,632100,632122,');
INSERT INTO `oa_city` VALUES (632123, '乐都县', 3, 632100, ',630000,632100,632123,');
INSERT INTO `oa_city` VALUES (632126, '互助土族自治县', 3, 632100, ',630000,632100,632126,');
INSERT INTO `oa_city` VALUES (632127, '化隆回族自治县', 3, 632100, ',630000,632100,632127,');
INSERT INTO `oa_city` VALUES (632128, '循化撒拉族自治县', 3, 632100, ',630000,632100,632128,');
INSERT INTO `oa_city` VALUES (632200, '海北藏族自治州', 2, 630000, ',630000,632200,');
INSERT INTO `oa_city` VALUES (632221, '门源回族自治县', 3, 632200, ',630000,632200,632221,');
INSERT INTO `oa_city` VALUES (632222, '祁连县', 3, 632200, ',630000,632200,632222,');
INSERT INTO `oa_city` VALUES (632223, '海晏县', 3, 632200, ',630000,632200,632223,');
INSERT INTO `oa_city` VALUES (632224, '刚察县', 3, 632200, ',630000,632200,632224,');
INSERT INTO `oa_city` VALUES (632300, '黄南藏族自治州', 2, 630000, ',630000,632300,');
INSERT INTO `oa_city` VALUES (632321, '同仁县', 3, 632300, ',630000,632300,632321,');
INSERT INTO `oa_city` VALUES (632322, '尖扎县', 3, 632300, ',630000,632300,632322,');
INSERT INTO `oa_city` VALUES (632323, '泽库县', 3, 632300, ',630000,632300,632323,');
INSERT INTO `oa_city` VALUES (632324, '河南蒙古族自治县', 3, 632300, ',630000,632300,632324,');
INSERT INTO `oa_city` VALUES (632500, '海南藏族自治州', 2, 630000, ',630000,632500,');
INSERT INTO `oa_city` VALUES (632521, '共和县', 3, 632500, ',630000,632500,632521,');
INSERT INTO `oa_city` VALUES (632522, '同德县', 3, 632500, ',630000,632500,632522,');
INSERT INTO `oa_city` VALUES (632523, '贵德县', 3, 632500, ',630000,632500,632523,');
INSERT INTO `oa_city` VALUES (632524, '兴海县', 3, 632500, ',630000,632500,632524,');
INSERT INTO `oa_city` VALUES (632525, '贵南县', 3, 632500, ',630000,632500,632525,');
INSERT INTO `oa_city` VALUES (632600, '果洛藏族自治州', 2, 630000, ',630000,632600,');
INSERT INTO `oa_city` VALUES (632621, '玛沁县', 3, 632600, ',630000,632600,632621,');
INSERT INTO `oa_city` VALUES (632622, '班玛县', 3, 632600, ',630000,632600,632622,');
INSERT INTO `oa_city` VALUES (632623, '甘德县', 3, 632600, ',630000,632600,632623,');
INSERT INTO `oa_city` VALUES (632624, '达日县', 3, 632600, ',630000,632600,632624,');
INSERT INTO `oa_city` VALUES (632625, '久治县', 3, 632600, ',630000,632600,632625,');
INSERT INTO `oa_city` VALUES (632626, '玛多县', 3, 632600, ',630000,632600,632626,');
INSERT INTO `oa_city` VALUES (632700, '玉树藏族自治州', 2, 630000, ',630000,632700,');
INSERT INTO `oa_city` VALUES (632721, '玉树县', 3, 632700, ',630000,632700,632721,');
INSERT INTO `oa_city` VALUES (632722, '杂多县', 3, 632700, ',630000,632700,632722,');
INSERT INTO `oa_city` VALUES (632723, '称多县', 3, 632700, ',630000,632700,632723,');
INSERT INTO `oa_city` VALUES (632724, '治多县', 3, 632700, ',630000,632700,632724,');
INSERT INTO `oa_city` VALUES (632725, '囊谦县', 3, 632700, ',630000,632700,632725,');
INSERT INTO `oa_city` VALUES (632726, '曲麻莱县', 3, 632700, ',630000,632700,632726,');
INSERT INTO `oa_city` VALUES (632800, '海西蒙古族藏族自治州', 2, 630000, ',630000,632800,');
INSERT INTO `oa_city` VALUES (632801, '格尔木市', 3, 632800, ',630000,632800,632801,');
INSERT INTO `oa_city` VALUES (632802, '德令哈市', 3, 632800, ',630000,632800,632802,');
INSERT INTO `oa_city` VALUES (632821, '乌兰县', 3, 632800, ',630000,632800,632821,');
INSERT INTO `oa_city` VALUES (632822, '都兰县', 3, 632800, ',630000,632800,632822,');
INSERT INTO `oa_city` VALUES (632823, '天峻县', 3, 632800, ',630000,632800,632823,');
INSERT INTO `oa_city` VALUES (640000, '宁　夏', 1, 0, ',640000,');
INSERT INTO `oa_city` VALUES (640100, '银川市', 2, 640000, ',640000,640100,');
INSERT INTO `oa_city` VALUES (640104, '兴庆区', 3, 640100, ',640000,640100,640104,');
INSERT INTO `oa_city` VALUES (640105, '西夏区', 3, 640100, ',640000,640100,640105,');
INSERT INTO `oa_city` VALUES (640106, '金凤区', 3, 640100, ',640000,640100,640106,');
INSERT INTO `oa_city` VALUES (640121, '永宁县', 3, 640100, ',640000,640100,640121,');
INSERT INTO `oa_city` VALUES (640122, '贺兰县', 3, 640100, ',640000,640100,640122,');
INSERT INTO `oa_city` VALUES (640181, '灵武市', 3, 640100, ',640000,640100,640181,');
INSERT INTO `oa_city` VALUES (640200, '石嘴山市', 2, 640000, ',640000,640200,');
INSERT INTO `oa_city` VALUES (640202, '大武口区', 3, 640200, ',640000,640200,640202,');
INSERT INTO `oa_city` VALUES (640205, '惠农区', 3, 640200, ',640000,640200,640205,');
INSERT INTO `oa_city` VALUES (640221, '平罗县', 3, 640200, ',640000,640200,640221,');
INSERT INTO `oa_city` VALUES (640300, '吴忠市', 2, 640000, ',640000,640300,');
INSERT INTO `oa_city` VALUES (640302, '利通区', 3, 640300, ',640000,640300,640302,');
INSERT INTO `oa_city` VALUES (640323, '盐池县', 3, 640300, ',640000,640300,640323,');
INSERT INTO `oa_city` VALUES (640324, '同心县', 3, 640300, ',640000,640300,640324,');
INSERT INTO `oa_city` VALUES (640381, '青铜峡市', 3, 640300, ',640000,640300,640381,');
INSERT INTO `oa_city` VALUES (640400, '固原市', 2, 640000, ',640000,640400,');
INSERT INTO `oa_city` VALUES (640402, '原州区', 3, 640400, ',640000,640400,640402,');
INSERT INTO `oa_city` VALUES (640422, '西吉县', 3, 640400, ',640000,640400,640422,');
INSERT INTO `oa_city` VALUES (640423, '隆德县', 3, 640400, ',640000,640400,640423,');
INSERT INTO `oa_city` VALUES (640424, '泾源县', 3, 640400, ',640000,640400,640424,');
INSERT INTO `oa_city` VALUES (640425, '彭阳县', 3, 640400, ',640000,640400,640425,');
INSERT INTO `oa_city` VALUES (640500, '中卫市', 2, 640000, ',640000,640500,');
INSERT INTO `oa_city` VALUES (640502, '沙坡头区', 3, 640500, ',640000,640500,640502,');
INSERT INTO `oa_city` VALUES (640521, '中宁县', 3, 640500, ',640000,640500,640521,');
INSERT INTO `oa_city` VALUES (640522, '海原县', 3, 640500, ',640000,640500,640522,');
INSERT INTO `oa_city` VALUES (650000, '新　疆', 1, 0, ',650000,');
INSERT INTO `oa_city` VALUES (650100, '乌鲁木齐市', 2, 650000, ',650000,650100,');
INSERT INTO `oa_city` VALUES (650102, '天山区', 3, 650100, ',650000,650100,650102,');
INSERT INTO `oa_city` VALUES (650103, '沙依巴克区', 3, 650100, ',650000,650100,650103,');
INSERT INTO `oa_city` VALUES (650104, '新市区', 3, 650100, ',650000,650100,650104,');
INSERT INTO `oa_city` VALUES (650105, '水磨沟区', 3, 650100, ',650000,650100,650105,');
INSERT INTO `oa_city` VALUES (650106, '头屯河区', 3, 650100, ',650000,650100,650106,');
INSERT INTO `oa_city` VALUES (650107, '达坂城区', 3, 650100, ',650000,650100,650107,');
INSERT INTO `oa_city` VALUES (650108, '东山区', 3, 650100, ',650000,650100,650108,');
INSERT INTO `oa_city` VALUES (650121, '乌鲁木齐县', 3, 650100, ',650000,650100,650121,');
INSERT INTO `oa_city` VALUES (650200, '克拉玛依市', 2, 650000, ',650000,650200,');
INSERT INTO `oa_city` VALUES (650202, '独山子区', 3, 650200, ',650000,650200,650202,');
INSERT INTO `oa_city` VALUES (650203, '克拉玛依区', 3, 650200, ',650000,650200,650203,');
INSERT INTO `oa_city` VALUES (650204, '白碱滩区', 3, 650200, ',650000,650200,650204,');
INSERT INTO `oa_city` VALUES (650205, '乌尔禾区', 3, 650200, ',650000,650200,650205,');
INSERT INTO `oa_city` VALUES (652100, '吐鲁番地区', 2, 650000, ',650000,652100,');
INSERT INTO `oa_city` VALUES (652101, '吐鲁番市', 3, 652100, ',650000,652100,652101,');
INSERT INTO `oa_city` VALUES (652122, '鄯善县', 3, 652100, ',650000,652100,652122,');
INSERT INTO `oa_city` VALUES (652123, '托克逊县', 3, 652100, ',650000,652100,652123,');
INSERT INTO `oa_city` VALUES (652200, '哈密地区', 2, 650000, ',650000,652200,');
INSERT INTO `oa_city` VALUES (652201, '哈密市', 3, 652200, ',650000,652200,652201,');
INSERT INTO `oa_city` VALUES (652222, '巴里坤哈萨克自治县', 3, 652200, ',650000,652200,652222,');
INSERT INTO `oa_city` VALUES (652223, '伊吾县', 3, 652200, ',650000,652200,652223,');
INSERT INTO `oa_city` VALUES (652300, '昌吉回族自治州', 2, 650000, ',650000,652300,');
INSERT INTO `oa_city` VALUES (652301, '昌吉市', 3, 652300, ',650000,652300,652301,');
INSERT INTO `oa_city` VALUES (652302, '阜康市', 3, 652300, ',650000,652300,652302,');
INSERT INTO `oa_city` VALUES (652303, '米泉市', 3, 652300, ',650000,652300,652303,');
INSERT INTO `oa_city` VALUES (652323, '呼图壁县', 3, 652300, ',650000,652300,652323,');
INSERT INTO `oa_city` VALUES (652324, '玛纳斯县', 3, 652300, ',650000,652300,652324,');
INSERT INTO `oa_city` VALUES (652325, '奇台县', 3, 652300, ',650000,652300,652325,');
INSERT INTO `oa_city` VALUES (652327, '吉木萨尔县', 3, 652300, ',650000,652300,652327,');
INSERT INTO `oa_city` VALUES (652328, '木垒哈萨克自治县', 3, 652300, ',650000,652300,652328,');
INSERT INTO `oa_city` VALUES (652700, '博尔塔拉蒙古自治州', 2, 650000, ',650000,652700,');
INSERT INTO `oa_city` VALUES (652701, '博乐市', 3, 652700, ',650000,652700,652701,');
INSERT INTO `oa_city` VALUES (652722, '精河县', 3, 652700, ',650000,652700,652722,');
INSERT INTO `oa_city` VALUES (652723, '温泉县', 3, 652700, ',650000,652700,652723,');
INSERT INTO `oa_city` VALUES (652800, '巴音郭楞蒙古自治州', 2, 650000, ',650000,652800,');
INSERT INTO `oa_city` VALUES (652801, '库尔勒市', 3, 652800, ',650000,652800,652801,');
INSERT INTO `oa_city` VALUES (652822, '轮台县', 3, 652800, ',650000,652800,652822,');
INSERT INTO `oa_city` VALUES (652823, '尉犁县', 3, 652800, ',650000,652800,652823,');
INSERT INTO `oa_city` VALUES (652824, '若羌县', 3, 652800, ',650000,652800,652824,');
INSERT INTO `oa_city` VALUES (652825, '且末县', 3, 652800, ',650000,652800,652825,');
INSERT INTO `oa_city` VALUES (652826, '焉耆回族自治县', 3, 652800, ',650000,652800,652826,');
INSERT INTO `oa_city` VALUES (652827, '和静县', 3, 652800, ',650000,652800,652827,');
INSERT INTO `oa_city` VALUES (652828, '和硕县', 3, 652800, ',650000,652800,652828,');
INSERT INTO `oa_city` VALUES (652829, '博湖县', 3, 652800, ',650000,652800,652829,');
INSERT INTO `oa_city` VALUES (652900, '阿克苏地区', 2, 650000, ',650000,652900,');
INSERT INTO `oa_city` VALUES (652901, '阿克苏市', 3, 652900, ',650000,652900,652901,');
INSERT INTO `oa_city` VALUES (652922, '温宿县', 3, 652900, ',650000,652900,652922,');
INSERT INTO `oa_city` VALUES (652923, '库车县', 3, 652900, ',650000,652900,652923,');
INSERT INTO `oa_city` VALUES (652924, '沙雅县', 3, 652900, ',650000,652900,652924,');
INSERT INTO `oa_city` VALUES (652925, '新和县', 3, 652900, ',650000,652900,652925,');
INSERT INTO `oa_city` VALUES (652926, '拜城县', 3, 652900, ',650000,652900,652926,');
INSERT INTO `oa_city` VALUES (652927, '乌什县', 3, 652900, ',650000,652900,652927,');
INSERT INTO `oa_city` VALUES (652928, '阿瓦提县', 3, 652900, ',650000,652900,652928,');
INSERT INTO `oa_city` VALUES (652929, '柯坪县', 3, 652900, ',650000,652900,652929,');
INSERT INTO `oa_city` VALUES (653000, '克孜勒苏柯尔克孜自治州', 2, 650000, ',650000,653000,');
INSERT INTO `oa_city` VALUES (653001, '阿图什市', 3, 653000, ',650000,653000,653001,');
INSERT INTO `oa_city` VALUES (653022, '阿克陶县', 3, 653000, ',650000,653000,653022,');
INSERT INTO `oa_city` VALUES (653023, '阿合奇县', 3, 653000, ',650000,653000,653023,');
INSERT INTO `oa_city` VALUES (653024, '乌恰县', 3, 653000, ',650000,653000,653024,');
INSERT INTO `oa_city` VALUES (653100, '喀什地区', 2, 650000, ',650000,653100,');
INSERT INTO `oa_city` VALUES (653101, '喀什市', 3, 653100, ',650000,653100,653101,');
INSERT INTO `oa_city` VALUES (653121, '疏附县', 3, 653100, ',650000,653100,653121,');
INSERT INTO `oa_city` VALUES (653122, '疏勒县', 3, 653100, ',650000,653100,653122,');
INSERT INTO `oa_city` VALUES (653123, '英吉沙县', 3, 653100, ',650000,653100,653123,');
INSERT INTO `oa_city` VALUES (653124, '泽普县', 3, 653100, ',650000,653100,653124,');
INSERT INTO `oa_city` VALUES (653125, '莎车县', 3, 653100, ',650000,653100,653125,');
INSERT INTO `oa_city` VALUES (653126, '叶城县', 3, 653100, ',650000,653100,653126,');
INSERT INTO `oa_city` VALUES (653127, '麦盖提县', 3, 653100, ',650000,653100,653127,');
INSERT INTO `oa_city` VALUES (653128, '岳普湖县', 3, 653100, ',650000,653100,653128,');
INSERT INTO `oa_city` VALUES (653129, '伽师县', 3, 653100, ',650000,653100,653129,');
INSERT INTO `oa_city` VALUES (653130, '巴楚县', 3, 653100, ',650000,653100,653130,');
INSERT INTO `oa_city` VALUES (653131, '塔什库尔干塔吉克自治县', 3, 653100, ',650000,653100,653131,');
INSERT INTO `oa_city` VALUES (653200, '和田地区', 2, 650000, ',650000,653200,');
INSERT INTO `oa_city` VALUES (653201, '和田市', 3, 653200, ',650000,653200,653201,');
INSERT INTO `oa_city` VALUES (653221, '和田县', 3, 653200, ',650000,653200,653221,');
INSERT INTO `oa_city` VALUES (653222, '墨玉县', 3, 653200, ',650000,653200,653222,');
INSERT INTO `oa_city` VALUES (653223, '皮山县', 3, 653200, ',650000,653200,653223,');
INSERT INTO `oa_city` VALUES (653224, '洛浦县', 3, 653200, ',650000,653200,653224,');
INSERT INTO `oa_city` VALUES (653225, '策勒县', 3, 653200, ',650000,653200,653225,');
INSERT INTO `oa_city` VALUES (653226, '于田县', 3, 653200, ',650000,653200,653226,');
INSERT INTO `oa_city` VALUES (653227, '民丰县', 3, 653200, ',650000,653200,653227,');
INSERT INTO `oa_city` VALUES (654000, '伊犁哈萨克自治州', 2, 650000, ',650000,654000,');
INSERT INTO `oa_city` VALUES (654002, '伊宁市', 3, 654000, ',650000,654000,654002,');
INSERT INTO `oa_city` VALUES (654003, '奎屯市', 3, 654000, ',650000,654000,654003,');
INSERT INTO `oa_city` VALUES (654021, '伊宁县', 3, 654000, ',650000,654000,654021,');
INSERT INTO `oa_city` VALUES (654022, '察布查尔锡伯自治县', 3, 654000, ',650000,654000,654022,');
INSERT INTO `oa_city` VALUES (654023, '霍城县', 3, 654000, ',650000,654000,654023,');
INSERT INTO `oa_city` VALUES (654024, '巩留县', 3, 654000, ',650000,654000,654024,');
INSERT INTO `oa_city` VALUES (654025, '新源县', 3, 654000, ',650000,654000,654025,');
INSERT INTO `oa_city` VALUES (654026, '昭苏县', 3, 654000, ',650000,654000,654026,');
INSERT INTO `oa_city` VALUES (654027, '特克斯县', 3, 654000, ',650000,654000,654027,');
INSERT INTO `oa_city` VALUES (654028, '尼勒克县', 3, 654000, ',650000,654000,654028,');
INSERT INTO `oa_city` VALUES (654200, '塔城地区', 2, 650000, ',650000,654200,');
INSERT INTO `oa_city` VALUES (654201, '塔城市', 3, 654200, ',650000,654200,654201,');
INSERT INTO `oa_city` VALUES (654202, '乌苏市', 3, 654200, ',650000,654200,654202,');
INSERT INTO `oa_city` VALUES (654221, '额敏县', 3, 654200, ',650000,654200,654221,');
INSERT INTO `oa_city` VALUES (654223, '沙湾县', 3, 654200, ',650000,654200,654223,');
INSERT INTO `oa_city` VALUES (654224, '托里县', 3, 654200, ',650000,654200,654224,');
INSERT INTO `oa_city` VALUES (654225, '裕民县', 3, 654200, ',650000,654200,654225,');
INSERT INTO `oa_city` VALUES (654226, '和布克赛尔蒙古自治县', 3, 654200, ',650000,654200,654226,');
INSERT INTO `oa_city` VALUES (654300, '阿勒泰地区', 2, 650000, ',650000,654300,');
INSERT INTO `oa_city` VALUES (654301, '阿勒泰市', 3, 654300, ',650000,654300,654301,');
INSERT INTO `oa_city` VALUES (654321, '布尔津县', 3, 654300, ',650000,654300,654321,');
INSERT INTO `oa_city` VALUES (654322, '富蕴县', 3, 654300, ',650000,654300,654322,');
INSERT INTO `oa_city` VALUES (654323, '福海县', 3, 654300, ',650000,654300,654323,');
INSERT INTO `oa_city` VALUES (654324, '哈巴河县', 3, 654300, ',650000,654300,654324,');
INSERT INTO `oa_city` VALUES (654325, '青河县', 3, 654300, ',650000,654300,654325,');
INSERT INTO `oa_city` VALUES (654326, '吉木乃县', 3, 654300, ',650000,654300,654326,');
INSERT INTO `oa_city` VALUES (659001, '石河子市', 2, 650000, ',650000,659001,');
INSERT INTO `oa_city` VALUES (659002, '阿拉尔市', 2, 650000, ',650000,659002,');
INSERT INTO `oa_city` VALUES (659003, '图木舒克市', 2, 650000, ',650000,659003,');
INSERT INTO `oa_city` VALUES (659004, '五家渠市', 2, 650000, ',650000,659004,');
INSERT INTO `oa_city` VALUES (710000, '台湾省', 1, 0, ',710000,');
INSERT INTO `oa_city` VALUES (810000, '香　港', 1, 0, ',810000,');
INSERT INTO `oa_city` VALUES (820000, '澳　门', 1, 0, ',820000,');
INSERT INTO `oa_city` VALUES (440113007000, '市桥街道', 4, 440113, ',440000,440100,440113,440113007000');
INSERT INTO `oa_city` VALUES (440113008000, '沙头街道', 4, 440113, ',440000,440100,440113,440113008000');
INSERT INTO `oa_city` VALUES (440113009000, '东环街道', 4, 440113, ',440000,440100,440113,440113009000');
INSERT INTO `oa_city` VALUES (440113010000, '桥南街道', 4, 440113, ',440000,440100,440113,440113010000');
INSERT INTO `oa_city` VALUES (440113011000, '小谷围街道', 4, 440113, ',440000,440100,440113,440113011000');
INSERT INTO `oa_city` VALUES (440113012000, '大石街道', 4, 440113, ',440000,440100,440113,440113012000');
INSERT INTO `oa_city` VALUES (440113013000, '洛浦街道', 4, 440113, ',440000,440100,440113,440113013000');
INSERT INTO `oa_city` VALUES (440113014000, '石壁街道', 4, 440113, ',440000,440100,440113,440113014000');
INSERT INTO `oa_city` VALUES (440113015000, '钟村街道', 4, 440113, ',440000,440100,440113,440113015000');
INSERT INTO `oa_city` VALUES (440113016000, '大龙街道', 4, 440113, ',440000,440100,440113,440113016000');
INSERT INTO `oa_city` VALUES (440113102000, '南村镇', 4, 440113, ',440000,440100,440113,440113102000');
INSERT INTO `oa_city` VALUES (440113103000, '新造镇', 4, 440113, ',440000,440100,440113,440113103000');
INSERT INTO `oa_city` VALUES (440113104000, '化龙镇', 4, 440113, ',440000,440100,440113,440113104000');
INSERT INTO `oa_city` VALUES (440113105000, '石楼镇', 4, 440113, ',440000,440100,440113,440113105000');
INSERT INTO `oa_city` VALUES (440113118000, '沙湾镇', 4, 440113, ',440000,440100,440113,440113118000');
INSERT INTO `oa_city` VALUES (440113120000, '石碁镇', 4, 440113, ',440000,440100,440113,440113120000');
INSERT INTO `oa_city` VALUES (440114001000, '新华街道', 4, 440114, ',440000,440100,440114,440114001000');
INSERT INTO `oa_city` VALUES (440114002000, '花城街道', 4, 440114, ',440000,440100,440114,440114002000');
INSERT INTO `oa_city` VALUES (440114003000, '秀全街道', 4, 440114, ',440000,440100,440114,440114003000');
INSERT INTO `oa_city` VALUES (440114004000, '新雅街道', 4, 440114, ',440000,440100,440114,440114004000');
INSERT INTO `oa_city` VALUES (440114103000, '梯面镇', 4, 440114, ',440000,440100,440114,440114103000');
INSERT INTO `oa_city` VALUES (440114104000, '花山镇', 4, 440114, ',440000,440100,440114,440114104000');
INSERT INTO `oa_city` VALUES (440114105000, '花东镇', 4, 440114, ',440000,440100,440114,440114105000');
INSERT INTO `oa_city` VALUES (440114107000, '炭步镇', 4, 440114, ',440000,440100,440114,440114107000');
INSERT INTO `oa_city` VALUES (440114108000, '赤坭镇', 4, 440114, ',440000,440100,440114,440114108000');
INSERT INTO `oa_city` VALUES (440114109000, '狮岭镇', 4, 440114, ',440000,440100,440114,440114109000');
INSERT INTO `oa_city` VALUES (440607001000, '西南街道', 4, 440607, ',440000,440600,440607,440607001000');
INSERT INTO `oa_city` VALUES (440607004000, '云东海街道', 4, 440607, ',440000,440600,440607,440607004000');
INSERT INTO `oa_city` VALUES (440607101000, '大塘镇', 4, 440607, ',440000,440600,440607,440607101000');
INSERT INTO `oa_city` VALUES (440607103000, '乐平镇', 4, 440607, ',440000,440600,440607,440607103000');
INSERT INTO `oa_city` VALUES (440607104000, '白坭镇', 4, 440607, ',440000,440600,440607,440607104000');
INSERT INTO `oa_city` VALUES (440607105000, '芦苞镇', 4, 440607, ',440000,440600,440607,440607105000');
INSERT INTO `oa_city` VALUES (440607106000, '南山镇', 4, 440607, ',440000,440600,440607,440607106000');
