<?php

namespace Kotchasan;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2022-12-22 at 15:16:40.
 */
class ValidatorTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var Validator
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->object = new Validator();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {

    }

    /**
     * Generated from @assert ('admin@localhost.com') [==] true.
     *
     * @covers Kotchasan\Validator::email
     */
    public function testEmail()
    {

        $this->assertTrue(
            \Kotchasan\Validator::email('admin@localhost.com')
        );
    }

    /**
     * Generated from @assert ('admin@localhost') [==] true.
     *
     * @covers Kotchasan\Validator::email
     */
    public function testEmail2()
    {

        $this->assertTrue(
            \Kotchasan\Validator::email('admin@localhost')
        );
    }

    /**
     * Generated from @assert ('Abc01.d_e-f@1081009.com') [==] true.
     *
     * @covers Kotchasan\Validator::email
     */
    public function testEmail3()
    {

        $this->assertTrue(
            \Kotchasan\Validator::email('Abc01.d_e-f@1081009.com')
        );
    }

    /**
     * Generated from @assert ('ทดสอบ@localhost') [==] false.
     *
     * @covers Kotchasan\Validator::email
     */
    public function testEmail4()
    {

        $this->assertFalse(
            \Kotchasan\Validator::email('ทดสอบ@localhost')
        );
    }

    /**
     * Generated from @assert (['gif'], ['name' => 'blank.GIF', 'tmp_name' => ROOT_PATH.'skin/img/blank.gif']) [==] ['ext' => 'gif', 'width' => 1, 'height' => 1, 'mime' => 'image/gif'].
     *
     * @covers Kotchasan\Validator::isImage
     */
    public function testIsImage()
    {

        $this->assertEquals(
            ['ext' => 'gif', 'width' => 1, 'height' => 1, 'mime' => 'image/gif'],
            \Kotchasan\Validator::isImage(['gif'], ['name' => 'blank.GIF', 'tmp_name' => ROOT_PATH.'skin/img/blank.gif'])
        );
    }
}