<?php
namespace Kotchasan;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2024-06-13 at 21:33:39.
 */
class LanguageTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var Language
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {

    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
    }

    /**
     * Generated from @assert ('YEAR_OFFSET') [==] 543.
     *
     * @covers Kotchasan\Language::get
     */
    public function testGet()
    {

        $this->assertEquals(
            543,
            \Kotchasan\Language::get('YEAR_OFFSET')
        );
    }

    /**
     * Generated from @assert ('XYZ', []) [==] [].
     *
     * @covers Kotchasan\Language::get
     */
    public function testGet2()
    {

        $this->assertEquals(
            [],
            \Kotchasan\Language::get('XYZ', [])
        );
    }

    /**
     * Generated from @assert ('DATE_LONG', null, 0) [==] 'อาทิตย์'.
     *
     * @covers Kotchasan\Language::get
     */
    public function testGet3()
    {

        $this->assertEquals(
            'อาทิตย์',
            \Kotchasan\Language::get('DATE_LONG', null, 0)
        );
    }

    /**
     * Generated from @assert ('DATE_LONG', null, 12) [==] 'DATE_LONG'.
     *
     * @covers Kotchasan\Language::get
     */
    public function testGet4()
    {

        $this->assertEquals(
            'DATE_LONG',
            \Kotchasan\Language::get('DATE_LONG', null, 12)
        );
    }

    /**
     * Generated from @assert ('not found', 'default') [==] 'default'.
     *
     * @covers Kotchasan\Language::get
     */
    public function testGet5()
    {

        $this->assertEquals(
            'default',
            \Kotchasan\Language::get('not found', 'default')
        );
    }

    /**
     * Generated from @assert (array(array('id' => 0, 'key' => 'One'), array('id' => 100, 'key' => 'Two')), 'One') [==] 0.
     *
     * @covers Kotchasan\Language::keyExists
     */
    public function testKeyExists()
    {

        $this->assertEquals(
            0,
            \Kotchasan\Language::keyExists(array(array('id' => 0, 'key' => 'One'), array('id' => 100, 'key' => 'Two')), 'One')
        );
    }

    /**
     * Generated from @assert (array(array('id' => 0, 'key' => 'One'), array('id' => 100, 'key' => 'Two')), 'two') [==] 100.
     *
     * @covers Kotchasan\Language::keyExists
     */
    public function testKeyExists2()
    {

        $this->assertEquals(
            100,
            \Kotchasan\Language::keyExists(array(array('id' => 0, 'key' => 'One'), array('id' => 100, 'key' => 'Two')), 'two')
        );
    }

    /**
     * Generated from @assert (array(array('id' => 0, 'key' => 'One'), array('id' => 100, 'key' => 'Two')), 'O') [==] -1.
     *
     * @covers Kotchasan\Language::keyExists
     */
    public function testKeyExists3()
    {

        $this->assertEquals(
            -1,
            \Kotchasan\Language::keyExists(array(array('id' => 0, 'key' => 'One'), array('id' => 100, 'key' => 'Two')), 'O')
        );
    }

    /**
     * Generated from @assert ('DATE_LONG', 1) [==] true.
     *
     * @covers Kotchasan\Language::arrayKeyExists
     */
    public function testArrayKeyExists()
    {

        $this->assertTrue(
            \Kotchasan\Language::arrayKeyExists('DATE_LONG', 1)
        );
    }

    /**
     * Generated from @assert ('DATE_LONG', 7) [==] false.
     *
     * @covers Kotchasan\Language::arrayKeyExists
     */
    public function testArrayKeyExists2()
    {

        $this->assertFalse(
            \Kotchasan\Language::arrayKeyExists('DATE_LONG', 7)
        );
    }

    /**
     * Generated from @assert () [==] 'th'.
     *
     * @covers Kotchasan\Language::name
     */
    public function testName()
    {

        $this->assertEquals(
            'th',
            \Kotchasan\Language::name()
        );
    }

    /**
     * Generated from @assert (array(1 => 'not found')) [==] 'not found'.
     *
     * @covers Kotchasan\Language::parse
     */
    public function testParse()
    {

        $this->assertEquals(
            'not found',
            \Kotchasan\Language::parse(array(1 => 'not found'))
        );
    }

    /**
     * Generated from @assert ('You want to :action', array(':action' => 'delete')) [==] 'You want to delete'.
     *
     * @covers Kotchasan\Language::replace
     */
    public function testReplace()
    {

        $this->assertEquals(
            'You want to delete',
            \Kotchasan\Language::replace('You want to :action', array(':action' => 'delete'))
        );
    }

    /**
     * Generated from @assert ('You want to %s', 'delete') [==] 'You want to delete'.
     *
     * @covers Kotchasan\Language::replace
     */
    public function testReplace2()
    {

        $this->assertEquals(
            'You want to delete',
            \Kotchasan\Language::replace('You want to %s', 'delete')
        );
    }

    /**
     * Generated from @assert ('You want to %s', 1) [==] 'You want to 1'.
     *
     * @covers Kotchasan\Language::replace
     */
    public function testReplace3()
    {

        $this->assertEquals(
            'You want to 1',
            \Kotchasan\Language::replace('You want to %s', 1)
        );
    }

    /**
     * Generated from @assert ('Error moving uploaded file %1s to %2s', 'one', 'two') [==] 'Error moving uploaded file one to two'.
     *
     * @covers Kotchasan\Language::sprintf
     */
    public function testSprintf()
    {

        $this->assertEquals(
            'Error moving uploaded file one to two',
            \Kotchasan\Language::sprintf('Error moving uploaded file %1s to %2s', 'one', 'two')
        );
    }

    /**
     * Generated from @assert ('Error moving uploaded file %s to %s', 'one', 'two') [==] 'Error moving uploaded file one to two'.
     *
     * @covers Kotchasan\Language::sprintf
     */
    public function testSprintf2()
    {

        $this->assertEquals(
            'Error moving uploaded file one to two',
            \Kotchasan\Language::sprintf('Error moving uploaded file %s to %s', 'one', 'two')
        );
    }

    /**
     * Generated from @assert ('ภาษา {LNG_DATE_FORMAT} ไทย') [==] 'ภาษา d M Y เวลา H:i น. ไทย'.
     *
     * @covers Kotchasan\Language::trans
     */
    public function testTrans()
    {

        $this->assertEquals(
            'ภาษา d M Y เวลา H:i น. ไทย',
            \Kotchasan\Language::trans('ภาษา {LNG_DATE_FORMAT} ไทย')
        );
    }
}
