<?php

namespace Kotchasan;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2023-04-08 at 18:50:15.
 */
class JwtTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var Jwt
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->object = Jwt::create();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {

    }

    /**
     * Generated from @assert (array('name' => 'ภาษาไทย', 'id' => 1234567890)) [==] 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJuYW1lIjoiXHUwZTIwXHUwZTMyXHUwZTI5XHUwZTMyXHUwZTQ0XHUwZTE3XHUwZTIyIiwiaWQiOjEyMzQ1Njc4OTB9.fAdzmsl4AIGAyNGt7MfNum9DUIxn6DGMhdn1hw4PwwE'.
     *
     * @covers Kotchasan\Jwt::encode
     */
    public function testEncode()
    {

        $this->assertEquals(
            'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJuYW1lIjoiXHUwZTIwXHUwZTMyXHUwZTI5XHUwZTMyXHUwZTQ0XHUwZTE3XHUwZTIyIiwiaWQiOjEyMzQ1Njc4OTB9.fAdzmsl4AIGAyNGt7MfNum9DUIxn6DGMhdn1hw4PwwE',
            $this->object->encode(['name' => 'ภาษาไทย', 'id' => 1234567890])
        );
    }

    /**
     * Generated from @assert ('eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJuYW1lIjoiXHUwZTIwXHUwZTMyXHUwZTI5XHUwZTMyXHUwZTQ0XHUwZTE3XHUwZTIyIiwiaWQiOjEyMzQ1Njc4OTB9.fAdzmsl4AIGAyNGt7MfNum9DUIxn6DGMhdn1hw4PwwE') [==] array('name' => 'ภาษาไทย', 'id' => 1234567890).
     *
     * @covers Kotchasan\Jwt::decode
     */
    public function testDecode()
    {

        $this->assertEquals(
            ['name' => 'ภาษาไทย', 'id' => 1234567890],
            $this->object->decode('eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJuYW1lIjoiXHUwZTIwXHUwZTMyXHUwZTI5XHUwZTMyXHUwZTQ0XHUwZTE3XHUwZTIyIiwiaWQiOjEyMzQ1Njc4OTB9.fAdzmsl4AIGAyNGt7MfNum9DUIxn6DGMhdn1hw4PwwE')
        );
    }

    /**
     * Generated from @assert ('eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJuYW1lIjoiXHUwZTIwXHUwZTMyXHUwZTI5XHUwZTMyXHUwZTQ0XHUwZTE3XHUwZTIyIiwiaWQiOjEyMzQ1Njc4OTB9.fAdzmsl4AIGAyNGt7MfNum9DUIxn6DGMhdn1hw4PwwE') [==] array('name' => 'ภาษาไทย', 'id' => 1234567890).
     *
     * @covers Kotchasan\Jwt::verify
     */
    public function testVerify()
    {

        $this->assertEquals(
            ['name' => 'ภาษาไทย', 'id' => 1234567890],
            $this->object->verify('eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJuYW1lIjoiXHUwZTIwXHUwZTMyXHUwZTI5XHUwZTMyXHUwZTQ0XHUwZTE3XHUwZTIyIiwiaWQiOjEyMzQ1Njc4OTB9.fAdzmsl4AIGAyNGt7MfNum9DUIxn6DGMhdn1hw4PwwE')
        );
    }

    /**
     * Generated from @assert ('eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJuYW1lIjoiXHUwZTIwXHUwZTMyXHUwZTI5XHUwZTMyXHUwZTQ0XHAwZTE3XHUwZTIyIiwiaWQiOjEyMzQ1Njc4OTB9.fAdzmsl4AIGAyNGt7MfNum9DUIxn6DGMhdn1hw4PwwE') [throws] \Exception.
     *
     * @covers Kotchasan\Jwt::verify
     * @expectedException \Exception
     */
    public function testVerify2()
    {

        $this->object->verify('eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJuYW1lIjoiXHUwZTIwXHUwZTMyXHUwZTI5XHUwZTMyXHUwZTQ0XHAwZTE3XHUwZTIyIiwiaWQiOjEyMzQ1Njc4OTB9.fAdzmsl4AIGAyNGt7MfNum9DUIxn6DGMhdn1hw4PwwE');
    }

    /**
     * Test JWT expiration (should throw an exception).
     *
     * @covers Kotchasan\Jwt::verify
     * @expectedException \Exception
     */
    public function testTokenExpiration()
    {
        // สร้าง JWT ที่หมดอายุใน 1 วินาที
        $jwt = Jwt::create('my_secret_key', 1, 'HS256');
        $token = $jwt->encode(['name' => 'ภาษาไทย', 'id' => 1234567890]);

        // รอให้ token หมดอายุ
        sleep(2);

        // ทดสอบการตรวจสอบ JWT ที่หมดอายุ
        $jwt->verify($token);
    }

    /**
     * Test invalid algorithm that should throw an exception.
     *
     * @covers Kotchasan\Jwt::create
     * @expectedException \Exception
     */
    public function testInvalidAlgorithm()
    {
        Jwt::create('my_secret_key', 3600, 'invalid_algo');
    }
}
