<?php

namespace Kotchasan;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2022-09-28 at 11:44:52.
 */
class InputItemTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var InputItem
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->object = new InputItem();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {

    }

    /**
     * Generated from @assert create('#000')->color() [==] '#000'.
     *
     * @covers Kotchasan\InputItem::color
     */
    public function testColor()
    {

        $this->assertEquals(
            '#000',
            $this->object->create('#000')->color()
        );
    }

    /**
     * Generated from @assert create('red')->color() [==] 'red'.
     *
     * @covers Kotchasan\InputItem::color
     */
    public function testColor2()
    {

        $this->assertEquals(
            'red',
            $this->object->create('red')->color()
        );
    }

    /**
     * Generated from @assert create('2016-01-01 20:20:20')->date() [==] '2016-01-01 20:20:20'.
     *
     * @covers Kotchasan\InputItem::date
     */
    public function testDate()
    {

        $this->assertEquals(
            '2016-01-01 20:20:20',
            $this->object->create('2016-01-01 20:20:20')->date()
        );
    }

    /**
     * Generated from @assert create('2016-01-01   20:20:20')->date() [==] '2016-01-01   20:20:20'.
     *
     * @covers Kotchasan\InputItem::date
     */
    public function testDate2()
    {

        $this->assertEquals(
            '2016-01-01   20:20:20',
            $this->object->create('2016-01-01   20:20:20')->date()
        );
    }

    /**
     * Generated from @assert create('2016-01-01   20:20:20')->date(true) [==] '2016-01-01 20:20:20'.
     *
     * @covers Kotchasan\InputItem::date
     */
    public function testDate3()
    {

        $this->assertEquals(
            '2016-01-01 20:20:20',
            $this->object->create('2016-01-01   20:20:20')->date(true)
        );
    }

    /**
     * Generated from @assert create('20:20:20')->date() [==] '20:20:20'.
     *
     * @covers Kotchasan\InputItem::date
     */
    public function testDate4()
    {

        $this->assertEquals(
            '20:20:20',
            $this->object->create('20:20:20')->date()
        );
    }

    /**
     * Generated from @assert create('20:20')->date() [==] '20:20'.
     *
     * @covers Kotchasan\InputItem::date
     */
    public function testDate5()
    {

        $this->assertEquals(
            '20:20',
            $this->object->create('20:20')->date()
        );
    }

    /**
     * Generated from @assert create('20:20')->date(true) [==] '20:20:00'.
     *
     * @covers Kotchasan\InputItem::date
     */
    public function testDate6()
    {

        $this->assertEquals(
            '20:20:00',
            $this->object->create('20:20')->date(true)
        );
    }

    /**
     * Generated from @assert create('2016-01-01')->date() [==] '2016-01-01'.
     *
     * @covers Kotchasan\InputItem::date
     */
    public function testDate7()
    {

        $this->assertEquals(
            '2016-01-01',
            $this->object->create('2016-01-01')->date()
        );
    }

    /**
     * Generated from @assert create('')->date() [==] null.
     *
     * @covers Kotchasan\InputItem::date
     */
    public function testDate8()
    {

        $this->assertEquals(
            null,
            $this->object->create('')->date()
        );
    }

    /**
     * Generated from @assert create(null)->date() [==] null.
     *
     * @covers Kotchasan\InputItem::date
     */
    public function testDate9()
    {

        $this->assertEquals(
            null,
            $this->object->create(null)->date()
        );
    }

    /**
     * Generated from @assert create('20:20:20')->time() [==] '20:20:20'.
     *
     * @covers Kotchasan\InputItem::time
     */
    public function testTime()
    {

        $this->assertEquals(
            '20:20:20',
            $this->object->create('20:20:20')->time()
        );
    }

    /**
     * Generated from @assert create('--:--')->time() [==] null.
     *
     * @covers Kotchasan\InputItem::time
     */
    public function testTime2()
    {

        $this->assertEquals(
            null,
            $this->object->create('--:--')->time()
        );
    }

    /**
     * Generated from @assert create('')->time() [==] null.
     *
     * @covers Kotchasan\InputItem::time
     */
    public function testTime3()
    {

        $this->assertEquals(
            null,
            $this->object->create('')->time()
        );
    }

    /**
     * Generated from @assert create('20:20:20')->time() [==] '20:20:20'.
     *
     * @covers Kotchasan\InputItem::time
     */
    public function testTime4()
    {

        $this->assertEquals(
            '20:20:20',
            $this->object->create('20:20:20')->time()
        );
    }

    /**
     * Generated from @assert create('20:20')->time() [==] '20:20'.
     *
     * @covers Kotchasan\InputItem::time
     */
    public function testTime5()
    {

        $this->assertEquals(
            '20:20',
            $this->object->create('20:20')->time()
        );
    }

    /**
     * Generated from @assert create('20:20')->time(true) [==] '20:20:00'.
     *
     * @covers Kotchasan\InputItem::time
     */
    public function testTime6()
    {

        $this->assertEquals(
            '20:20:00',
            $this->object->create('20:20')->time(true)
        );
    }

    /**
     * Generated from @assert create("ท.ด(ส     )อ\"บ'\r\n\t<?php echo '555'?>")->description() [==] 'ท.ด(ส )อ บ'.
     *
     * @covers Kotchasan\InputItem::description
     */
    public function testDescription()
    {

        $this->assertEquals(
            'ท.ด(ส )อ บ',
            $this->object->create("ท.ด(ส     )อ\"บ'\r\n\t<?php echo '555'?>")->description()
        );
    }

    /**
     * Generated from @assert create('ทดสอบ<style>body {color: red}</style>')->description() [==] 'ทดสอบ'.
     *
     * @covers Kotchasan\InputItem::description
     */
    public function testDescription2()
    {

        $this->assertEquals(
            'ทดสอบ',
            $this->object->create('ทดสอบ<style>body {color: red}</style>')->description()
        );
    }

    /**
     * Generated from @assert create('ทดสอบ<b>ตัวหนา</b>')->description() [==] 'ทดสอบตัวหนา'.
     *
     * @covers Kotchasan\InputItem::description
     */
    public function testDescription3()
    {

        $this->assertEquals(
            'ทดสอบตัวหนา',
            $this->object->create('ทดสอบ<b>ตัวหนา</b>')->description()
        );
    }

    /**
     * Generated from @assert create('ทดสอบ{LNG_Language name}')->description() [==] 'ทดสอบ'.
     *
     * @covers Kotchasan\InputItem::description
     */
    public function testDescription4()
    {

        $this->assertEquals(
            'ทดสอบ',
            $this->object->create('ทดสอบ{LNG_Language name}')->description()
        );
    }

    /**
     * Generated from @assert create('ทดสอบ[code]ตัวหนา[/code]')->description() [==] 'ทดสอบ'.
     *
     * @covers Kotchasan\InputItem::description
     */
    public function testDescription5()
    {

        $this->assertEquals(
            'ทดสอบ',
            $this->object->create('ทดสอบ[code]ตัวหนา[/code]')->description()
        );
    }

    /**
     * Generated from @assert create('ทดสอบ[b]ตัวหนา[/b]')->description() [==] 'ทดสอบตัวหนา'.
     *
     * @covers Kotchasan\InputItem::description
     */
    public function testDescription6()
    {

        $this->assertEquals(
            'ทดสอบตัวหนา',
            $this->object->create('ทดสอบ[b]ตัวหนา[/b]')->description()
        );
    }

    /**
     * Generated from @assert create('2 > 1 < 3 > 2{WIDGET_XXX}')->description() [==] '2 > 1 < 3 > 2'.
     *
     * @covers Kotchasan\InputItem::description
     */
    public function testDescription7()
    {

        $this->assertEquals(
            '2 > 1 < 3 > 2',
            $this->object->create('2 > 1 < 3 > 2{WIDGET_XXX}')->description()
        );
    }

    /**
     * Generated from @assert create('ทดสอบ<!--WIDGET_XXX-->')->description() [==] 'ทดสอบ'.
     *
     * @covers Kotchasan\InputItem::description
     */
    public function testDescription8()
    {

        $this->assertEquals(
            'ทดสอบ',
            $this->object->create('ทดสอบ<!--WIDGET_XXX-->')->description()
        );
    }

    /**
     * Generated from @assert create('ท&amp;ด&quot;\&nbsp;/__ส-อ+บ')->description() [==] 'ท ด \ /__ส-อ+บ'.
     *
     * @covers Kotchasan\InputItem::description
     */
    public function testDescription9()
    {

        $this->assertEquals(
            'ท ด \ /__ส-อ+บ',
            $this->object->create('ท&amp;ด&quot;\&nbsp;/__ส-อ+บ')->description()
        );
    }

    /**
     * Generated from @assert create('ภาคภูมิ')->description(2) [==] 'ภา'.
     *
     * @covers Kotchasan\InputItem::description
     */
    public function testDescription10()
    {

        $this->assertEquals(
            'ภา',
            $this->object->create('ภาคภูมิ')->description(2)
        );
    }

    /**
     * Generated from @assert create('U1.username ทดสอบภาษาไทย')->description(5) [throws] \Kotchasan\InputItemException.
     *
     * @covers Kotchasan\InputItem::description
     * @expectedException \Kotchasan\InputItemException
     */
    public function testDescription11()
    {

        $this->object->create('U1.username ทดสอบภาษาไทย')->description(5);
    }

    /**
     * Generated from @assert create('{ทด\/สอบ<?php echo "555"?>}')->detail() [==] '&#x007B;ทด&#92;/สอบ&#x007D;'.
     *
     * @covers Kotchasan\InputItem::detail
     */
    public function testDetail()
    {

        $this->assertEquals(
            '&#x007B;ทด&#92;/สอบ&#x007D;',
            $this->object->create('{ทด\/สอบ<?php echo "555"?>}')->detail()
        );
    }

    /**
     * Generated from @assert create('<?=555?>U1.username')->detail() [throws] \Kotchasan\InputItemException.
     *
     * @covers Kotchasan\InputItem::detail
     * @expectedException \Kotchasan\InputItemException
     */
    public function testDetail2()
    {

        $this->object->create('<?=555?>U1.username')->detail();
    }

    /**
     * Generated from @assert create('admin,1234')->filter('0-9a-zA-Z,') [==] 'admin,1234'.
     *
     * @covers Kotchasan\InputItem::filter
     */
    public function testFilter()
    {

        $this->assertEquals(
            'admin,1234',
            $this->object->create('admin,1234')->filter('0-9a-zA-Z,')
        );
    }

    /**
     * Generated from @assert create('adminกข,12ฟ34')->filter('0-9a-zA-Z,') [==] 'admin,1234'.
     *
     * @covers Kotchasan\InputItem::filter
     */
    public function testFilter2()
    {

        $this->assertEquals(
            'admin,1234',
            $this->object->create('adminกข,12ฟ34')->filter('0-9a-zA-Z,')
        );
    }

    /**
     * Generated from @assert create('U1.username')->filter('a-zA-Z0-9\.') [throws] \Kotchasan\InputItemException.
     *
     * @covers Kotchasan\InputItem::filter
     * @expectedException \Kotchasan\InputItemException
     */
    public function testFilter3()
    {

        $this->object->create('U1.username')->filter('a-zA-Z0-9\.');
    }

    /**
     * Generated from @assert create("<b>ทด</b>   \r\nสอบ")->keywords() [==] 'ทด สอบ'.
     *
     * @covers Kotchasan\InputItem::keywords
     */
    public function testKeywords()
    {

        $this->assertEquals(
            'ทด สอบ',
            $this->object->create("<b>ทด</b>   \r\nสอบ")->keywords()
        );
    }

    /**
     * Generated from @assert create('<b>U1.username</b> ทดสอบ')->keywords(5) [throws] \Kotchasan\InputItemException.
     *
     * @covers Kotchasan\InputItem::keywords
     * @expectedException \Kotchasan\InputItemException
     */
    public function testKeywords2()
    {

        $this->object->create('<b>U1.username</b> ทดสอบ')->keywords(5);
    }

    /**
     * Generated from @assert create(12345)->number() [==] '12345'.
     *
     * @covers Kotchasan\InputItem::number
     */
    public function testNumber()
    {

        $this->assertEquals(
            '12345',
            $this->object->create(12345)->number()
        );
    }

    /**
     * Generated from @assert create(0.12345)->number() [==] '012345'.
     *
     * @covers Kotchasan\InputItem::number
     */
    public function testNumber2()
    {

        $this->assertEquals(
            '012345',
            $this->object->create(0.12345)->number()
        );
    }

    /**
     * Generated from @assert create('ทด0123สอ4บ5')->number() [==] '012345'.
     *
     * @covers Kotchasan\InputItem::number
     */
    public function testNumber3()
    {

        $this->assertEquals(
            '012345',
            $this->object->create('ทด0123สอ4บ5')->number()
        );
    }

    /**
     * Generated from @assert create("ทด'สอบ")->quote() [==] "ทด&#39;สอบ".
     *
     * @covers Kotchasan\InputItem::quote
     */
    public function testQuote()
    {

        $this->assertEquals(
            "ทด&#39;สอบ",
            $this->object->create("ทด'สอบ")->quote()
        );
    }

    /**
     * Generated from @assert create(' U1.username ')->quote() [throws] \Kotchasan\InputItemException.
     *
     * @covers Kotchasan\InputItem::quote
     * @expectedException \Kotchasan\InputItemException
     */
    public function testQuote2()
    {

        $this->object->create(' U1.username ')->quote();
    }

    /**
     * Generated from @assert create(" ทด\/สอบ<?php echo '555'?> ")->text() [==] 'ทด&#92;/สอบ&lt;?php echo &#039;555&#039;?&gt;'.
     *
     * @covers Kotchasan\InputItem::text
     */
    public function testText()
    {

        $this->assertEquals(
            'ทด&#92;/สอบ&lt;?php echo &#039;555&#039;?&gt;',
            $this->object->create(" ทด\/สอบ<?php echo '555'?> ")->text()
        );
    }

    /**
     * Generated from @assert create('U1.username')->text() [throws] \Kotchasan\InputItemException.
     *
     * @covers Kotchasan\InputItem::text
     * @expectedException \Kotchasan\InputItemException
     */
    public function testText2()
    {

        $this->object->create('U1.username')->text();
    }

    /**
     * Generated from @assert create("ทด\/สอบ\n<?php echo '$555'?>")->textarea() [==] "ทด&#92;/สอบ\n&lt;?php echo '&#36;555'?&gt;".
     *
     * @covers Kotchasan\InputItem::textarea
     */
    public function testTextarea()
    {

        $this->assertEquals(
            "ทด&#92;/สอบ\n&lt;?php echo '&#36;555'?&gt;",
            $this->object->create("ทด\/สอบ\n<?php echo '$555'?>")->textarea()
        );
    }

    /**
     * Generated from @assert create('U1.username')->textarea() [throws] \Kotchasan\InputItemException.
     *
     * @covers Kotchasan\InputItem::textarea
     * @expectedException \Kotchasan\InputItemException
     */
    public function testTextarea2()
    {

        $this->object->create('U1.username')->textarea();
    }

    /**
     * Generated from @assert create(true)->toBoolean() [==] 1.
     *
     * @covers Kotchasan\InputItem::toBoolean
     */
    public function testToBoolean()
    {

        $this->assertEquals(
            1,
            $this->object->create(true)->toBoolean()
        );
    }

    /**
     * Generated from @assert create(false)->toBoolean() [==] 0.
     *
     * @covers Kotchasan\InputItem::toBoolean
     */
    public function testToBoolean2()
    {

        $this->assertEquals(
            0,
            $this->object->create(false)->toBoolean()
        );
    }

    /**
     * Generated from @assert create(1)->toBoolean() [==] 1.
     *
     * @covers Kotchasan\InputItem::toBoolean
     */
    public function testToBoolean3()
    {

        $this->assertEquals(
            1,
            $this->object->create(1)->toBoolean()
        );
    }

    /**
     * Generated from @assert create(0)->toBoolean() [==] 0.
     *
     * @covers Kotchasan\InputItem::toBoolean
     */
    public function testToBoolean4()
    {

        $this->assertEquals(
            0,
            $this->object->create(0)->toBoolean()
        );
    }

    /**
     * Generated from @assert create(null)->toBoolean() [==] 0.
     *
     * @covers Kotchasan\InputItem::toBoolean
     */
    public function testToBoolean5()
    {

        $this->assertEquals(
            0,
            $this->object->create(null)->toBoolean()
        );
    }

    /**
     * Generated from @assert create(0.454)->toDouble() [==] 0.454.
     *
     * @covers Kotchasan\InputItem::toDouble
     */
    public function testToDouble()
    {

        $this->assertEquals(
            0.454,
            $this->object->create(0.454)->toDouble()
        );
    }

    /**
     * Generated from @assert create(0.545)->toDouble() [==] 0.545.
     *
     * @covers Kotchasan\InputItem::toDouble
     */
    public function testToDouble2()
    {

        $this->assertEquals(
            0.545,
            $this->object->create(0.545)->toDouble()
        );
    }

    /**
     * Generated from @assert create('15,362.454')->toDouble() [==] 15362.454.
     *
     * @covers Kotchasan\InputItem::toDouble
     */
    public function testToDouble3()
    {

        $this->assertEquals(
            15362.454,
            $this->object->create('15,362.454')->toDouble()
        );
    }

    /**
     * Generated from @assert create(0.454)->toFloat() [==] 0.454.
     *
     * @covers Kotchasan\InputItem::toFloat
     */
    public function testToFloat()
    {

        $this->assertEquals(
            0.454,
            $this->object->create(0.454)->toFloat()
        );
    }

    /**
     * Generated from @assert create(0.545)->toFloat() [==] 0.545.
     *
     * @covers Kotchasan\InputItem::toFloat
     */
    public function testToFloat2()
    {

        $this->assertEquals(
            0.545,
            $this->object->create(0.545)->toFloat()
        );
    }

    /**
     * Generated from @assert create(0.454)->toInt() [==] 0.
     *
     * @covers Kotchasan\InputItem::toInt
     */
    public function testToInt()
    {

        $this->assertEquals(
            0,
            $this->object->create(0.454)->toInt()
        );
    }

    /**
     * Generated from @assert create(2.945)->toInt() [==] 2.
     *
     * @covers Kotchasan\InputItem::toInt
     */
    public function testToInt2()
    {

        $this->assertEquals(
            2,
            $this->object->create(2.945)->toInt()
        );
    }

    /**
     * Generated from @assert create('test')->toObject() [==] (object)'test'.
     *
     * @covers Kotchasan\InputItem::toObject
     */
    public function testToObject()
    {

        $this->assertEquals(
            (object)'test',
            $this->object->create('test')->toObject()
        );
    }

    /**
     * Generated from @assert create('ทดสอบ')->toString() [==] 'ทดสอบ'.
     *
     * @covers Kotchasan\InputItem::toString
     */
    public function testToString()
    {

        $this->assertEquals(
            'ทดสอบ',
            $this->object->create('ทดสอบ')->toString()
        );
    }

    /**
     * Generated from @assert create('1')->toString() [==] '1'.
     *
     * @covers Kotchasan\InputItem::toString
     */
    public function testToString2()
    {

        $this->assertEquals(
            '1',
            $this->object->create('1')->toString()
        );
    }

    /**
     * Generated from @assert create(1)->toString() [==] '1'.
     *
     * @covers Kotchasan\InputItem::toString
     */
    public function testToString3()
    {

        $this->assertEquals(
            '1',
            $this->object->create(1)->toString()
        );
    }

    /**
     * Generated from @assert create(null)->toString() [==] null.
     *
     * @covers Kotchasan\InputItem::toString
     */
    public function testToString4()
    {

        $this->assertEquals(
            null,
            $this->object->create(null)->toString()
        );
    }

    /**
     * Generated from @assert create(array('one', 'two'))->toArray() [==] array('one', 'two').
     *
     * @covers Kotchasan\InputItem::toArray
     */
    public function testToArray()
    {

        $this->assertEquals(
            array('one', 'two'),
            $this->object->create(array('one', 'two'))->toArray()
        );
    }

    /**
     * Generated from @assert create(' ทด\/สอบ'."\r\n\t".'<?php echo \'555\'?> ')->topic() [==] 'ทด&#92;/สอบ &lt;?php echo &#039;555&#039;?&gt;'.
     *
     * @covers Kotchasan\InputItem::topic
     */
    public function testTopic()
    {

        $this->assertEquals(
            'ทด&#92;/สอบ &lt;?php echo &#039;555&#039;?&gt;',
            $this->object->create(' ทด\/สอบ'."\r\n\t".'<?php echo \'555\'?> ')->topic()
        );
    }

    /**
     * Generated from @assert create('U1.username')->topic() [throws] \Kotchasan\InputItemException.
     *
     * @covers Kotchasan\InputItem::topic
     * @expectedException \Kotchasan\InputItemException
     */
    public function testTopic2()
    {

        $this->object->create('U1.username')->topic();
    }

    /**
     * Generated from @assert create(" http://www.kotchasan.com?a=1&b=2&amp;c=3 ")->url() [==] 'http://www.kotchasan.com?a=1&amp;b=2&amp;c=3'.
     *
     * @covers Kotchasan\InputItem::url
     */
    public function testUrl()
    {

        $this->assertEquals(
            'http://www.kotchasan.com?a=1&amp;b=2&amp;c=3',
            $this->object->create(" http://www.kotchasan.com?a=1&b=2&amp;c=3 ")->url()
        );
    }

    /**
     * Generated from @assert create("javascript:alert('xxx')")->url() [==] 'alertxxx'.
     *
     * @covers Kotchasan\InputItem::url
     */
    public function testUrl2()
    {

        $this->assertEquals(
            'alertxxx',
            $this->object->create("javascript:alert('xxx')")->url()
        );
    }

    /**
     * Generated from @assert create("http://www.xxx.com/javascript/")->url() [==] 'http://www.xxx.com/javascript/'.
     *
     * @covers Kotchasan\InputItem::url
     */
    public function testUrl3()
    {

        $this->assertEquals(
            'http://www.xxx.com/javascript/',
            $this->object->create("http://www.xxx.com/javascript/")->url()
        );
    }

    /**
     * Generated from @assert create('U1.username')->url() [throws] \Kotchasan\InputItemException.
     *
     * @covers Kotchasan\InputItem::url
     * @expectedException \Kotchasan\InputItemException
     */
    public function testUrl4()
    {

        $this->object->create('U1.username')->url();
    }

    /**
     * Generated from @assert create(' admin@demo.com')->username() [==] 'admin@demo.com'.
     *
     * @covers Kotchasan\InputItem::username
     */
    public function testUsername()
    {

        $this->assertEquals(
            'admin@demo.com',
            $this->object->create(' admin@demo.com')->username()
        );
    }

    /**
     * Generated from @assert create('012 3465')->username() [==] '0123465'.
     *
     * @covers Kotchasan\InputItem::username
     */
    public function testUsername2()
    {

        $this->assertEquals(
            '0123465',
            $this->object->create('012 3465')->username()
        );
    }

    /**
     * Generated from @assert create('U1.username')->username() [throws] \Kotchasan\InputItemException.
     *
     * @covers Kotchasan\InputItem::username
     * @expectedException \Kotchasan\InputItemException
     */
    public function testUsername3()
    {

        $this->object->create('U1.username')->username();
    }
}